#ifndef _EVE_PARAMETERS_DECLARATIONS_H_
#define _EVE_PARAMETERS_DECLARATIONS_H_

/*! 
 * \brief Declaration of the data structures for global eve parameters; default values are assigned in Eve_parameters::Eve_parameters()
 *   
 */


//----------------------------------------------------------------------
// ENERGY
struct energy_t{
  // inital energy of a newborn cell
  int initial_energy;

};

//----------------------------------------------------------------------
// GENERAL
struct general_t{
  //! number of signals in the enviroment
  int n_signals;

};

//----------------------------------------------------------------------
// NETWORK
struct network_t{
  //! probalility of creation of a new node [??]
  double creation;
  //! probability of destruction of a node [??]
  double destruction;
  //! [??] probability of amild mutation
  double mild_mutation;
  //! [??] probability of astrong mutation
  double strong_mutation;
  //! [??] not constant mutation rate -- based on theis  second derivative (mutation rate -- first derivat)
  double evolvability;

  //! [??] probability to be attached to the input signal
  double initial_sensor_prob;
};


//----------------------------------------------------------------------
// GRID

struct grid_t{
  //! spatial 2D grid: number of grid pints along X & Y axes
  int n;
  //! maximum distance between grid points ( diagonal -- sqrt(2)*n -- sotred for convinience)
  double dmax;
  //! Cell diffusion probability
  double diff_probability;
  //! Cell diffusion halfwidth[units=2D_grid_blocks]
  double diff_sdev;
  //! Division copied cell displacement distribution halfwidth[units=2D_grid_blocks]
  double division_copy_sdev;
  //! If replace the weakest cell in the population (otherwise replace cell with min value of F(E,Dist) function)
  int if_global_min;
  //! Radius around dividing cell where it searches for cell to replace
  double search_radius;
};

//----------------------------------------------------------------------
// LGT

struct lgt_t{
  //! flag, if ==1, keep regulations from/to metabolic protein (metabolic protein itself is discarded)
  int if_coonect_metabolic;

  //! transformation probability
  double tf_probability;
  //! transformation probability of creating a link in the gene regulatory network
  double tf_link_probability;
  //! transformation distance middle[units=2D_grid_points]
  double tf_dist_middle;
  //! transformation distance slope
  double tf_dist_slope;
  //! transformation module size middle[units=n_triplets]
  double tf_size_middle;
  //! transformation module size slope
  double tf_size_slope;

  //! conjugation probability
  double cj_probability;
  //! conjugation probability of creating a link in the gene regulatory network
  double cj_link_probability;
  //! conjugation distance middle[units=2D_grid_points]
  double cj_dist_middle;
  //! conjugation distance slope
  double cj_dist_slope;
  //! conjugation module size middle[units=n_triplets]
  double cj_size_middle;
  //! conjugation module size slope
  double cj_size_slope;

  //! transduction probability
  double td_probability;
  //! transduction probability of creating a link in the gene regulatory network
  double td_link_probability;
  //! transduction distance middle[units=2D_grid_points]
  double td_dist_middle;
  //! transduction distance slope
  double td_dist_slope;
  //! transduction module size middle[units=n_triplets]
  double td_size_middle;
  //! transduction module size slope
  double td_size_slope;


};



//  global parameters
struct globals_t {
  // used for random number generation; used to be globals in ilibrary.cpp
  my_srand_seed_t idum;
  my_srand_seed_t itemp;

};


//----------------------------------------------------------------------
// ALL DATA TOGETHER
struct eve_parameters_t{
  // general paramenters
  general_t general;
  // energy parametters of the cell
  energy_t energy;
  // regulatoryy nerwork parameters
  network_t network;
  // 2D spatial grid parameters
  grid_t grid;
  // LGT parameters
  lgt_t lgt;
  //  global parameters
  globals_t globals;
};

#endif
