#ifndef _GENERIC_HEADER_H_
#define _GENERIC_HEADER_H_

#include <string.h> 
#include <stdlib.h> 
#include <stdio.h> 

#include <math.h>
#include <time.h>

#include <iostream>
#include <fstream>
#include <sstream>
#include <iomanip>

#include <algorithm>

#if _IF_MPI
     #include "mpi.h"
#endif

//! structure is used in search for MIN & MAX energy across the population;
//  contains info for all cells in this process
struct double_int{
  double value;
  int rank;
};


// integer and float min & max values:
#include <limits.h>
#include <float.h>

#define ROUND(x) ((x)>=0?(long)((x)+0.5):(long)((x)-0.5))
#define MAX(x,y) ((x)>=y ? x : y)
#define MIN(x,y) ((x)<=y ? x : y)
#define my_pi 3.1415
#define PI 3.14159265


using namespace std;

//Declaration of type of signal waveform
enum type 
	{
		RANDOM,
		PERIODIC,
		PRESET_GATE,
		MULTIGATE,
		BISTATE,
		PRESET_OSC,
		VARIANCE_LOCK,
		TOGGLE_SWITCH
	}; 


// Define type to hold a random number seed for my_srand() and my_getseed() and a
// random floating point number for my_rand().
#if USE_RAND_64 // 64-bit random number generator
typedef unsigned long long my_srand_seed_t;
typedef double my_rand_t;
#else
typedef unsigned long my_srand_seed_t;
typedef float my_rand_t;
#endif


//Import file parameters and experiment type
extern type signal_type;

// General parameters
extern double intraconnectivity[3][3];
extern double intraconnectivity_regulator[3];
extern double intraconnectivity_regulated[3];
extern double input_connection_mild, input_connection_strong, input_disconnection_probability;
extern double dephosphorylation;
extern int maintenance_cost, node_cost, food_per_metabolic;
extern int n_cells_per_process;
extern int cell_division_threshold, cell_death_threshold;
extern int number_of_epochs, selection_period;
extern int sync_freq;
extern int save_cell_info_freq;
extern int import_cells, import_signals;

extern int random_appearance, random_duration, mutation_flag, if_mutation_per_triplet, connection_specificity_flag, intraconnectivity_flag;
extern int evolvability_energy_cor, node_cost_proportional_to_mutation;

#endif 
