#ifndef HDF5_CONSTANTS_H_
#define HDF5_CONSTANTS_H_

#include <hdf5.h>
#define FIRST_EPOCH_ID -1

#define FILE_NAME_RANK_SUFFIX "__rank"
#define FILE_NAME_PREFIX "cell_info"
#define FILE_NAME_LAST_PREFIX "last_"
#define MAX_H5_OBJECT_NAME_LENGTH 30

#define H5_FILE_EXTENSION ".h5"

#define H5_GROUP_ROOT "/"
#define H5_GROUP_EPOCH "Epoch"
#define H5_GROUP_CELL "Cell"
#define H5_GROUP_LOG "Log"

#define H5_ATTRIB_ROOT_N_CELLS_PER_PROC "No. Cells per MPI Process"
#define H5_ATTRIB_ROOT_N_PROCS "No. MPI Processes"
#define H5_ATTRIB_ROOT_N_CELLS "No. Cells"
#define H5_ATTRIB_ROOT_N_TIMESTEPS_PER_EPOCH "No. Timesteps per Epoch"
#define H5_ATTRIB_ROOT_N_EPOCHS "No. Epochs"
#define H5_ATTRIB_ROOT_N_TIMESTEPS "No. Timesteps"
#define H5_ATTRIB_CELL_ID "Unique ID"
#define H5_ATTRIB_CELL_RANK "MPI Process"
#define H5_ATTRIB_CELL_FITNESS "Fitness"
#define H5_ATTRIB_CELL_CREATION "Creation"
#define H5_ATTRIB_CELL_DESTRUCTION "Destruction"
#define H5_ATTRIB_CELL_EVOLVABILITY "Evolvability"
#define H5_ATTRIB_CELL_COORD "Coordinate"
#define H5_ATTRIB_CELL_ENERGY "Energy"
#define H5_ATTRIB_CELL_MILD_MUTATION "Mild Mutation"
#define H5_ATTRIB_CELL_STRONG_MUTATION "Strong Mutation"
#define H5_ATTRIB_CELL_N_NODES "Number of Nodes"
#define H5_ATTRIB_CELL_ISP "Input Connection Vector"
#define H5_ATTRIB_CELL_SLOPE "Slope Vector"
#define H5_ATTRIB_CELL_MIDDLEPOINT "Middlepoint Vector"
#define H5_ATTRIB_CELL_BASAL "Basal Vector"
#define H5_ATTRIB_CELL_DEGRADATION "Degradation Vector"
#define H5_ATTRIB_CELL_WEIGHT "Weight Matrix"
#define H5_ATTRIB_CELL_REGSLOPE "Regslope Matrix"
#define H5_ATTRIB_CELL_REGMIDDLE "Regmiddle Matrix"

#define H5_DATASET_CELL_V_HISTORY "V_History Matrix"

#endif /* HDF5_CONSTANTS_H_ */
