#include "ilibrary.h"

// ***********************************************
// *	PEARSON CORRELATION	(double,double)	 *
// ***********************************************

double pearson(double * data1, double * data2, int m) 
{
  double sum1   = 0.0;
  double sum2   = 0.0;

  double avg1   = 0.0;
  double avg2   = 0.0;
    
  double a, b, c;

  int i;

  for (i=0; i<m; i++) 
  {
    sum1   += data1[i];
    sum2   += data2[i];
  }
    
  avg1 = sum1 / (double)m;
  avg2 = sum2 / (double)m;

  // calc the Pearson correlation
    
  a = 0.0;
  b = 0.0;
  c = 0.0;

  for (i=0; i<m; i++) 
  {
    a += (data1[i] - avg1) * (data2[i] - avg2);
    b += (data1[i] - avg1) * (data1[i] - avg1);
    c += (data2[i] - avg2) * (data2[i] - avg2);
  }
  if (a==0 || b==0 || c==0)
	  return 0;
  return a / sqrt ( b * c );
}


/*************************************************/
/*			PEARSON CORRELATION	(int,double)	 */
/*************************************************/


double pearson(int * data1, double * data2, int m) 
{
  
  double sum1   = 0.0;
  double sum2   = 0.0;

  double avg1   = 0.0;
  double avg2   = 0.0;
    
  double a, b, c;

  int i;

  for (i=0; i<m; i++) 
  {
    sum1   += data1[i];
    sum2   += data2[i];
  }
    
  avg1 = sum1 / (double)m;
  avg2 = sum2 / (double)m;

  // calc the Pearson correlation
    
  a = 0.0;
  b = 0.0;
  c = 0.0;

  for (i=0; i<m; i++) 
  {
    a += (data1[i] - avg1) * (data2[i] - avg2);
    b += (data1[i] - avg1) * (data1[i] - avg1);
    c += (data2[i] - avg2) * (data2[i] - avg2);
  }
  if (a==0 || b==0 || c==0)
	  return 0;
  return a / sqrt ( b * c );
}


/***********************************************************/
/*				UNIFORM RANDOM NUMBER GENERATOR			   */
/*			WARNING: CANNOT BE -O3 OPTIMIZED!!!!		   */	
/***********************************************************/



#if USE_RAND_64 // 64-bit random number generator

#define jflone 0x3ff0000000000000
#define jflmsk 0x000fffffffffffff

my_rand_t my_rand(my_srand_seed_t &idum, my_srand_seed_t &itemp){
  return rand()/(RAND_MAX*1.0);
  /*
  idum =  2862933555777941757L*idum + 3037000493L;
  itemp = (jflone | (jflmsk & idum));
  return *(double*)&itemp - 1.0;
  */
};



#else // 32-bit random number generator                                 

#define jflone 0x3f800000
#define jflmsk 0x007fffff

my_rand_t my_rand(my_srand_seed_t &idum, my_srand_seed_t &itemp){
  return rand()/(RAND_MAX*1.0);
  /*
  idum = 1664525L*idum + 1013904223L;
  itemp = (jflone | (jflmsk & idum));
  return *(float*)&itemp - 1.0;
  */
};

#endif

//void my_srand(my_srand_seed_t seed, my_srand_seed_t &idum){idum = seed;};
void my_srand(my_srand_seed_t seed, my_srand_seed_t &idum){ idum = seed; srand(seed); };

my_srand_seed_t my_getseed(my_srand_seed_t &idum){return idum;};


/***********************************************************/
/*				GAUSSIAN RANDOM NUMBER GENERATOR		   */
/***********************************************************/

//double gaussian(double mean, double stddev)
double gaussian(double mean, double stddev, my_srand_seed_t &idum, my_srand_seed_t &itemp)
{
	
  static bool cached = false;
  static double extra;  	// the extra number from a 0 mean unit stdev gaussian

  if (cached) 
  {
    cached = false;
    return extra*stddev + mean;
  }
  else 
  {
  // pick a random point in the unit circle (excluding the origin)
  double a,b,c;
    do {
      a = 2*my_rand(idum, itemp)-1.0;
      b = 2*my_rand(idum, itemp)-1.0;
      c = a*a + b*b;
    }
    while (c >= 1.0 || c == 0.0);
    // transform it into two values drawn from a gaussian
    double t = sqrt(-2*log(c)/c);
    extra = t*a;
    cached = true;
    return t*b*stddev + mean;
  }
}


/***********************************************************/
/*		EXPONENTIAL ONE SIDED RANDOM NUMBER GENERATOR	   */
/***********************************************************/

double exponential(double lamda, my_srand_seed_t &idum, my_srand_seed_t &itemp)
//double exponential(double lamda)
{
	double temp=0;
	while (temp <= 0)
		temp = -1/lamda* log(my_rand(idum, itemp));
	return temp;
}

/***********************************************************/
/*		POWERLAW TWO SIDED RANDOM NUMBER GENERATOR	   */
/***********************************************************/

//double powerlaw(double degree)
double powerlaw(double degree, my_srand_seed_t &idum, my_srand_seed_t &itemp)
{
	double temp = 0;
	while (temp <= 0)
		temp = (double)pow((double)my_rand(idum, itemp),(-1/degree));
	
	if (my_rand(idum, itemp) >0.5)
		temp = -temp;

	return temp; 
}

/*******************************************************/
/*				QUICK SORT							   */
/*******************************************************/

void quickSort(double *numbers, int array_size)
{
  q_sort(numbers, 0, array_size - 1);
}


void q_sort(double *numbers, int left, int right)
{
  double pivot; 
  int l_hold, r_hold;

  l_hold = left;
  r_hold = right;
  pivot = numbers[left];
  while (left < right)
  {
    while ((numbers[right] >= pivot) && (left < right))
      right--;
    if (left != right)
    {
      numbers[left] = numbers[right];
      left++;
    }
    while ((numbers[left] <= pivot) && (left < right))
      left++;
    if (left != right)
    {
      numbers[right] = numbers[left];
      right--;
    }
  }
  numbers[left] = pivot;
  pivot = left;
  left = l_hold;
  right = r_hold;
  if (left < pivot)
    q_sort(numbers, left, static_cast<int>(pivot-1));
  if (right > pivot)
    q_sort(numbers, static_cast<int>(pivot+1), right);
}

int binarysearch(double *numbers, double value, double left, double right)
{
	int middle;
	while (left <= right)
	{
		middle = static_cast<int>(floor((left+right)/2));
		if (numbers[middle] == value)
            return middle;
        if (value < numbers[middle])
            right = middle-1;
        else
            left  = middle+1;
	}
    return  -1;
}

/*******************************************************/
/*				MEAN AND STD DEV					   */
/*******************************************************/

double mean(double * x, int size)
{
	int i;
	double temp =0;
	for (i=0;i<size;i++)
		temp = temp + x[i];
	temp = temp / size;
	return temp;
}

double mean(int *x, int size)
{
	int i;
	double temp =0;
	for (i=0;i<size;i++)
		temp = temp + x[i];
	temp = temp / size;
	return temp;
}


double standart_deviation(double * x, int size, double mean)
{
	int i;
	double temp = 0;
	for (i=0;i<size;i++)
		temp = temp + pow((x[i] - mean),2);
	temp = temp / size;
	temp = pow(temp,0.5);
	return temp;
}

double standart_deviation(int * x, int size, double mean)
{
	int i;
	double temp = 0;
	for (i=0;i<size;i++)
		temp = temp + pow((x[i] - mean),2);
	temp = temp / size;
	temp = pow(temp,0.5);
	return temp;
}


// Return string with the current time:
std::string GetTime(){
  time_t rawtime;
  time ( &rawtime );
  return  ctime ( &rawtime );
}
