#include "import_export.h"

void load_input(std::string file_name, Eve_parameters * global, std::string& output)
{
  ifstream in_file;
  in_file.open(file_name.c_str());
  if (!in_file) {
    cerr << "Unable to open the input file: " << file_name <<" \nEXITING!\n";
    exit(1);  
  }

  // save a copy of the input file into this string
  std::stringstream out_data;
  out_data << "Loading input file:" << file_name << "\n";
	
  char *x = new char [100];

  in_file.ignore(500,'\n'); // [first line -- comment]
  in_file.ignore(500,'\n'); // [empty line]
  in_file.ignore(500,'\n'); // GENERAL

  double n_epochs_tmp;
  in_file >> x >> x >> x >> x;
  number_of_epochs = atoi(x); // "Number of epochs: "
	
  in_file >> x >> x >> x >> x >> x;
  selection_period = atoi(x); // "Time steps per epoch: "

  in_file >> x >> x >> x >> x >> x >> x;	
  n_cells_per_process = atoi(x); // "Number of cells per process: "

  in_file >> x >> x >> x >> x;	
  global->param.general.n_signals = atoi(x); // "Number of signals: "

  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(500,'\n'); // FLAGS

  in_file >> x >> x >> x;
  random_appearance = atoi(x); //"Random appearance: "

  in_file >> x >> x >> x;
  random_duration = atoi(x); // "Random duration: " 
	
  in_file >> x >> x >> x >> x;
  mutation_flag = atoi(x); // "Variable mutation rates: "
	
  in_file >> x >> x >> x; 
  if_mutation_per_triplet = atoi(x); // "Mutation rate-per-priplet: "

  in_file >> x >> x >> x; 
  evolvability_energy_cor = atoi(x); // "Evolvability/energy anticorrelation: "
	
  in_file >> x >> x >> x >> x; 
  node_cost_proportional_to_mutation = atoi(x); // "Mutation/node cost anticorrelation: "

  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(500,'\n'); //ENERGY

  in_file >> x >> x >> x >> x >> x >> x; 
  global->param.energy.initial_energy = atoi(x); //"Initial energy of each cell: "

  in_file >> x >> x >> x; 
  cell_division_threshold = atoi(x); //"Division threshold: " 

  in_file >> x >> x >> x; 
  cell_death_threshold = atoi(x); // "Ddeath threshold: " 

  in_file >> x >> x >> x >> x >> x >> x; 
  maintenance_cost = atoi(x); // "Maintenance cost per response protein: " 

  in_file >> x >> x >> x >> x >> x >> x; 
  node_cost = atoi(x); // "Maintenance cost per network code: "

  in_file >> x >> x >> x >> x >> x >> x; 
  food_per_metabolic = atoi(x); // "Metabolic gain per response protein: "
	
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(200,'\n'); //NETWORK


  in_file >> x >> x; 
  global->param.network.creation = atof(x); // "Creation: "

  in_file >> x >> x;
  global->param.network.destruction = atof(x); // "Destruction: "

  in_file >> x >> x >> x;
  global->param.network.mild_mutation = atof(x); // "Mild mutation: " 
	
  in_file >> x >> x >> x;
  global->param.network.strong_mutation = atof(x); // "Strong mutation: "

  in_file >> x >> x >> x >> x >> x >> x >> x;
  input_connection_mild = atof(x); // "Input connection probability for mild mutations: "

  in_file >> x >> x >> x >> x >> x >> x >> x;
  input_connection_strong = atof(x); // "Input connection probability for strong mutations: "

  in_file >> x >> x >> x >> x;
  input_disconnection_probability = atof(x); // "Input disconnection probability: "

  in_file >> x >> x >> x;
  dephosphorylation = atof(x); // "Dephosphorylation probability: "

  in_file >> x >> x >> x >> x;
  global->param.network.initial_sensor_prob = atof(x); // "Initialization input probability: "
	
  in_file >> x >> x;
  global->param.network.evolvability = atof(x); // "Evolvobility: "

  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(200,'\n'); //MPI


  in_file >> x >> x >> x >> x >> x;
  sync_freq = atoi(x); // "Energy synchronization frequency [units=time_steps]: "

  in_file >> x >> x >> x >> x >> x >> x;
  save_cell_info_freq = atoi(x); // "Save cell info frequency [units=epochs]: "
	
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(200,'\n'); //FILES


  in_file >> x >> x >> x;
  import_cells = atoi(x); // "Import cell: "

  in_file >> x >> x >> x;
  import_signals = atoi(x); // "Import signals: "
      
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(200,'\n'); // GRID

  in_file >> x >> x >> x >> x >> x;
  global->param.grid.n  = atoi(x); // "Grid points along X&Y:"
  global->param.grid.dmax = sqrt(2.0)*global->param.grid.n; // max distance. i.e. diagonal

  in_file >> x >> x >> x >> x;
  global->param.grid.diff_probability = atof(x); //"Cell diffusion probability: "
  in_file >> x >> x >> x >> x;
  global->param.grid.diff_sdev = atof(x); //"Cell diffusion st.dev.[units=2D_grid_blocks]: "
  in_file >> x >> x >> x >> x >> x >> x >> x;
  global->param.grid.division_copy_sdev = atof(x); //"Division copied cell displacement distribution st.dev.[units=2D_grid_blocks]: " 
  in_file >> x >> x >> x >> x >> x >> x >> x;
  global->param.grid.if_global_min = atoi(x); //"If replace cell with least energy[flag]: "
  in_file >> x >> x >> x >> x >> x >> x;
  global->param.grid.search_radius = atoi(x); // "Replace radius (used when least_energy_flag=0): "

  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(500,'\n'); // [EOL]
  in_file.ignore(200,'\n'); // LATERAL GENE TRANSFER

  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.if_coonect_metabolic = atoi(x); // "Keep metabolic protein regulation: "

  in_file >> x >> x >> x;
  global->param.lgt.tf_probability = atof(x); // "Transformation probability:"
  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.tf_link_probability = atof(x); // "Transformation network incorporation probability:"
  in_file >> x >> x >> x >> x;
  global->param.lgt.tf_dist_middle = atof(x); // "Transformation distance middle[units=2D_grid_blocks]:" 
  in_file >> x >> x >> x >> x;
  global->param.lgt.tf_dist_slope  = atof(x); // "Transformation distance slope:"
  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.tf_size_middle = atof(x); // "Transformation module size middle[units=n_triplets]:"
  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.tf_size_slope  = atof(x); // "Transformation module size slope:"

  in_file >> x >> x >> x;
  global->param.lgt.cj_probability = atof(x); // "Conjugation probability:"
  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.cj_link_probability = atof(x); // "Conjugation network incorporation probability:"
  in_file >> x >> x >> x >> x;
  global->param.lgt.cj_dist_middle = atof(x); // "Conjugation distance middle[units=2D_grid_blocks]:" 
  in_file >> x >> x >> x >> x;
  global->param.lgt.cj_dist_slope  = atof(x); // "Conjugation distance slope:"
  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.cj_size_middle = atof(x); // "Conjugation module size middle[units=n_triplets]:"
  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.cj_size_slope  = atof(x); // "Conjugation module size slope:"
	
  in_file >> x >> x >> x;
  global->param.lgt.td_probability = atof(x); // "Transduction probability:"
  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.td_link_probability = atof(x); // "Transduction network incorporation probability:"
  in_file >> x >> x >> x >> x;
  global->param.lgt.td_dist_middle = atof(x); // "Transduction distance middle[units=2D_grid_blocks]:" 
  in_file >> x >> x >> x >> x;
  global->param.lgt.td_dist_slope  = atof(x); // "Transduction distance slope:"
  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.td_size_middle = atof(x); // "Transduction module size middle[units=n_triplets]:"
  in_file >> x >> x >> x >> x >> x;
  global->param.lgt.td_size_slope  = atof(x); // "Transduction module size slope:"


  in_file.close();

  // "return"
  output = out_data.str();
}


void save_input(Eve_parameters * global, std::string& output)
{
  // save a copy of the input file into this string
  std::stringstream out_data;

  out_data << "----------------------------------------------------------------------\n";
  out_data << "Parameters are saved on "<< GetTime()
	   << "\nGENERAL\n";
  out_data << "Number of epochs: " << number_of_epochs << "\n";
  out_data << "Time steps per epoch: " << selection_period << "\n"; 
  out_data << "Number of cells per process: " << n_cells_per_process << "\n"; 
  out_data << "Number of signals: " << global->param.general.n_signals << "\n"; 
  out_data << "\nFLAGS\n";
  out_data << "Random appearance: " << random_appearance << "\n";
  out_data << "Random duration: " << random_duration << "\n";
  out_data << "Variable mutation rates: " <<mutation_flag<< "\n";
  out_data << "Mutation rate-per-priplet: " << if_mutation_per_triplet << "\n";
  out_data << "Evolvability/energy anticorrelation: " <<evolvability_energy_cor<< "\n";
  out_data << "Mutation/node cost anticorrelation: " << node_cost_proportional_to_mutation<< "\n";

  out_data << "\nENERGY\n";
  out_data << "Initial energy of each cell: " << global->param.energy.initial_energy<< "\n";
  out_data << "Division threshold: " << cell_division_threshold << "\n";
  out_data << "Death threshold: " << cell_death_threshold << "\n";
  out_data <<"Maintenance cost per response protein: " << maintenance_cost<< "\n";
  out_data <<"Maintenance cost per network node: " << node_cost << "\n";
  out_data <<"Metabolic gain per response protein: " << food_per_metabolic << "\n";

  out_data << "\nNETWORK\n";
  out_data << "Creation: " << global->param.network.creation << "\n";
  out_data << "Destruction: " << global->param.network.destruction << "\n";
  out_data << "Mild mutation: " << global->param.network.mild_mutation << "\n";
  out_data << "Strong mutation: " <<  global->param.network.strong_mutation << "\n";
  out_data << "Input connection probability for mild mutations: " <<  input_connection_mild << "\n";
  out_data << "Input connection probability for strong mutations: " <<  input_connection_strong << "\n";
  out_data << "Input disconnection probability: " <<  input_disconnection_probability << "\n";
  out_data << "Dephosphorylation probability: " << dephosphorylation << "\n";
  out_data << "Initialization input probability: " << global->param.network.initial_sensor_prob << "\n";
  out_data << "Evolvability: " << global->param.network.evolvability << "\n";

  out_data << "\nMPI\n";
  out_data << "Energy synchronization frequency [units=time_steps]: " << sync_freq << "\n";
  out_data << "Save cell info frequency [units=epochs]: " << save_cell_info_freq << "\n";

  out_data << "\nFILES\n";
  out_data << "Import cell: " << import_cells << "\n";
  out_data << "Import signals: " << import_signals << "\n";

  out_data << "\nGRID\n";
  out_data << "Grid points along X&Y: " << global->param.grid.n << "\n";
  out_data << "Cell diffusion probability: " << global->param.grid.diff_probability << "\n";
  out_data << "Cell diffusion st.dev.[units=2D_grid_blocks]: " << global->param.grid.diff_sdev << "\n";
  out_data << "Division copied cell displacement distribution st.dev.[units=2D_grid_blocks]: " << global->param.grid.division_copy_sdev << "\n";
  out_data << "If replace cell with least energy[flag]: " <<  global->param.grid.if_global_min << "\n";
  out_data << "Replace radius (used when least_energy_flag=0): " << global->param.grid.search_radius << "\n";

  out_data << "\nLATERAL GENE TRANSFER\n";
  out_data << "Keep metabolic protein regulation: " <<  global->param.lgt.if_coonect_metabolic << "\n";
  out_data << "Transformation probability: " <<  global->param.lgt.tf_probability << "\n";
  out_data << "Transformation network incorporation probability: " <<  global->param.lgt.tf_link_probability << "\n"; 
  out_data << "Transformation distance middle[units=2D_grid_blocks]: " << global->param.lgt.tf_dist_middle << "\n";
  out_data << "Transformation distance slope: "  << global->param.lgt.tf_dist_slope << "\n";
  out_data << "Transformation module size middle[units=n_triplets]: " << global->param.lgt.tf_size_middle << "\n";
  out_data << "Transformation module size slope: " << global->param.lgt.tf_size_slope << "\n";

  out_data << "Conjugation probability: " <<  global->param.lgt.cj_probability << "\n";
  out_data << "Conjugation network incorporation probability: " << global->param.lgt.cj_link_probability << "\n";
  out_data << "Conjugation distance middle[units=2D_grid_blocks]: " << global->param.lgt.cj_dist_middle << "\n";
  out_data << "Conjugation distance slope: "  << global->param.lgt.cj_dist_slope << "\n";
  out_data << "Conjugation module size middle[units=n_triplets]: " << global->param.lgt.cj_size_middle << "\n";
  out_data << "Conjugation module size slope: " << global->param.lgt.cj_size_slope << "\n";

  out_data << "Transduction probability: " <<  global->param.lgt.td_probability << "\n";
  out_data << "Transduction network incorporation probability: " << global->param.lgt.td_link_probability << "\n";  
  out_data << "Transduction distance middle[units=2D_grid_blocks]: " << global->param.lgt.td_dist_middle << "\n";
  out_data << "Transduction distance slope: "  << global->param.lgt.td_dist_slope << "\n";
  out_data << "Transduction module size middle[units=n_triplets]: " << global->param.lgt.td_size_middle << "\n";
  out_data << "Transduction module size slope: " << global->param.lgt.td_size_slope << "\n";
 
  out_data << "----------------------------------------------------------------------\n";

  // "return"
  output = out_data.str();
}

void save_signals(int n_signals, double* food, double** signal_ptr, std::string& output)
{
  std::stringstream out_data;


  out_data << "----------------------------------------------------------------------\n";

  out_data << "Signals.  Number of signals: " << n_signals
	   << " (+ one food signal); Timesteps in an epoch: " << selection_period << ";\n";

  for (int i=0; i<n_signals; i++)
    out_data << "Signal #" << i+1 << "  ";
  out_data << "Food signal\n";

  for (int j=0; j<selection_period; j++){
    for (int i=0; i<n_signals; i++)
      out_data << signal_ptr[i][j] << ' ';
    out_data << food[j] << '\n';
  }

  out_data << "\n\n----------------------------------------------------------------------\n";

  // return string
  output=out_data.str();
}

// new format: signal per column

void load_signals(int n_signals, double* food, double** signal_ptr,std::string file_name, std::string& output)
{
  ifstream inFile;
  inFile.open(file_name.c_str());
  if (!inFile) 
    {
      cerr << "Unable to open file " << file_name << " with signals.\n";
      exit(1);   // call system to stop
    }
  int i, j;
  char *x = new char [100];

  // save a copy of the input file into this string
  std::stringstream out_data;
  inFile.ignore(500,'\n'); // comment line
  inFile.ignore(500,'\n'); // 2nd comment line: "Signal #1  Signal #2  Food signal"

  for (j=0; j<selection_period; j++){
    for (i=0; i<n_signals; i++){
      inFile >> x;
      signal_ptr[i][j] = atof(x);
    }
    inFile >> x;
    food[j] = atof(x);

    inFile.ignore(500,'\n'); // [EOL]
  }
	
  out_data << "----------------------------------------------------------------------\n";
  out_data << "Signals loaded from " << file_name << " on " << GetTime();

  //return str
  output = out_data.str();
}


// OLDER FORMAT signal per line with one empty line separation
 /*
void load_signals(int n_signals, double* food, double** signal_ptr,std::string file_name, std::string& output)
{
  ifstream inFile;
  inFile.open(file_name.c_str());
  if (!inFile) 
    {
      cerr << "Unable to open file " << file_name << " with signals.\n";
      exit(1);   // call system to stop
    }
  int i, j;
  char *x = new char [100];

  // save a copy of the input file into this string
  std::stringstream out_data;
  inFile.ignore(500,'\n'); // comment line
	
  //environmental signals
  for (i=0;i<n_signals;i++){
    inFile.ignore(500,'\n'); // signal's comment line
    for (j=0;j<selection_period;j++){
      inFile >> x;
      signal_ptr[i][j] = atof(x);
    }
    inFile.ignore(500,'\n'); // [EOL]
  }

  //food
  inFile.ignore(500,'\n'); // food's comment line
  for (j=0;j<selection_period;j++){
    inFile >> x;
    food[j] = atof(x);
  }

  out_data << "----------------------------------------------------------------------\n";
  out_data << "Signals loaded from " << file_name << " on " << GetTime();

  //return str
  output = out_data.str();
}
*/

 void save_grid(int x_max, int y_max, int* matrix, std::string& output)
 {
   // save a copy of the input file into this string
  std::stringstream out_data;

  for (int y=0; y<y_max; y++){
    for (int x=0; x<x_max; x++){
      out_data << std::setw(5) << matrix[y*x_max+x] << " ";
    }
    out_data << "\n";
  }
 
  //return str
  output = out_data.str();
 }

