#ifndef _IMPORT_EXPORT_TMP_H_
#define _IMPORT_EXPORT_TMP_H_

#include "generic_header.h"
#include "eve_parameters.h"

#include "cell.h"
#include "ilibrary.h"

// reads/writes input files (vm, 2010)

/*! 
 * \brief load global parameters from the input file; 
 *
 * @param file_name input file name
 * @param global pointer to a singletone with all global parameters of eve run
 * @param output messaged are saved in the "output"
*/
void load_input(std::string file_name, Eve_parameters* global, std::string& output);

/*! 
 * \brief saves a copy of the parameters into the "output" (keeps input file format)
 *
 * @param global pointer to a singletone with all global parameters of eve run
 * @param output global parameters are returned in an input file format into this string
*/
void save_input(Eve_parameters* global, std::string& output);

/*! \brief save signals into the output string
 *
 * @param n_signals number of signals to load (and also a food signal)
 * @param food pointer to the food "signal"
 * @param signal_ptr pointer to the array of signals
 * @param output output messages are returned in this string
 */
void save_signals(int n_signals, double* food, double** signal_ptr, std::string& output);

//! load a signal
/*! \brief load signas from a file (two comment lines; after that each column is a siugnal; last column is a food "signal")
 *
 * @param n_signals number of signals to load (and also a food signal)
 * @param food pointer to the food "signal"
 * @param signal_ptr pointer to the array of signals
 * @param file_name filename with "n_siganls" signals and one food signal
 * @param output output messages are returned in this string
 */
void load_signals(int n_signals, double* food, double** signal_ptr,std::string file_name, std::string& output);

/*!
 * \brief save 2d grid matrix in "a matrix from" to the output string
 *
 * @param x_max number of columns in the matrix
 * @param y_max number of rows in the matrix
 * @param matrix matrix [x_max x y_max] of int-s
 * @param output matrix is printed into this string
 */
void save_grid(int x_max, int y_max, int* matrix, std::string& output);

#endif

