#include "value_calculation.h"

void signal_subroutine(eve_parameters_t& global_param, double* food,double** signal_ptr, int random_appearance,int random_duration, int offset, int selection_period) 
{
	int max_inputs = 10000;
	int max_food = 10000;
	ofstream outfile;
	double random_temp;
	int i,j,k;
		if (signal_type == RANDOM)
		{
			int random_creation = max_inputs; //the number of random signal population to be sampled from.
			double **signal_ptr_temp = new double *[random_creation];
			for (i=0;i<random_creation;i++) //we need selection_period + 1, because of the way signal_creation is working (needs N+1 elements)
				signal_ptr_temp[i] = new double [selection_period+1];
			double *pearson_temp1 = new double [random_creation];
			double *pearson_temp2 = new double [random_creation];

			signal_creation(food,selection_period,10,0,max_food,global_param.globals.idum,global_param.globals.itemp); //food goes up to max_food
			for (i=0;i<random_creation;i++)
			{
				signal_creation(signal_ptr_temp[i],selection_period, 10, -1, 1,global_param.globals.idum,global_param.globals.itemp); //signal ptr,period,bins,min,max		
				pearson_temp1[i] = pearson(signal_ptr_temp[i],food,selection_period); //here pearson_temp1 is used as temp.
				pearson_temp2[i] = pearson_temp1[i];
			}
			
			
			quickSort(pearson_temp1,selection_period);

			for (i=0; i<global_param.general.n_signals; i++)
			{
				random_temp = my_rand(global_param.globals.idum, global_param.globals.itemp);
				if (random_temp < 0.5)
				{
					for (j=0;j<random_creation;j++)
					{
						if (pearson_temp1[i] == pearson_temp2[j])
						{
							for (k=0;k<selection_period;k++)
								signal_ptr[i][k] = signal_ptr_temp[j][k];
							continue;
						}
					}
				}
				else
				{
					for (j=0;j<random_creation;j++)
					{
						if (pearson_temp1[selection_period - i - 1] == pearson_temp2[j])
						{
							for (k=0;k<selection_period;k++)
								signal_ptr[i][k] = signal_ptr_temp[j][k];
							continue;
						}
					}
				}
			}


			delete[] pearson_temp1;
			delete[] pearson_temp2;
			for (i=0;i<random_creation;i++)
				delete[] signal_ptr_temp[i];
			delete[] signal_ptr_temp;
		} //END OF RANDOM SIGNAL TYPE

		else if (signal_type == VARIANCE_LOCK)
		{
			static int duration=0;
			static float stochastic =0;
			static float random_number1 = my_rand(global_param.globals.idum, global_param.globals.itemp);
			static float random_number2 = my_rand(global_param.globals.idum, global_param.globals.itemp);
                        if (offset%20==0)
                        {
                                random_number1 = my_rand(global_param.globals.idum, global_param.globals.itemp);
                                random_number2 = my_rand(global_param.globals.idum, global_param.globals.itemp);
                                if (random_appearance ==1)
                                        stochastic =  1 -2*random_number1;
                                if (random_duration ==1)
				  duration = MAX(0,200 + ROUND(gaussian(stochastic,random_number2,global_param.globals.idum,global_param.globals.itemp)*100));
                                else
                                        duration = 200; //normally resources should be 400 time units.
                        }
                        else
						{
                                if (random_appearance ==1)
                                        stochastic = 1 - 2*random_number1;
                                if (random_duration==1)
                                        duration = MAX(0,200 + ROUND(gaussian(stochastic,random_number2,global_param.globals.idum,global_param.globals.itemp)*200));
                                else
                                        duration = 200;
                        }
                        for (i=0;i<selection_period;i++)
                        {
                                food[i]=0;
                                signal_ptr[0][i] = -1;
                                signal_ptr[1][i] = -1;
				if (random_duration==1)
                                        signal_ptr[2][i] = -1 + 2*random_number2; //signal carries resource variance
				if (random_appearance==1)
                                        signal_ptr[2][i] = stochastic; //signal carries resource mean

                                if (i>=(750) && i<=(1150))
                                        signal_ptr[0][i-500] = 1;
                                if (i>=(950-duration) && i<=(950+duration))
                                      food[i] = 10000;

                                if (i>=(2250) && i<=(2650))
                                        signal_ptr[1][i-500] = 1;
                                if (i>=(2450-duration) && i<=(2450+duration))
                                      food[i] = 10000;

                                //if (i>=(3750) && i <=(4150)) //FOR OR,NAND
                                if (i>=(3200) && i<=(4000)) //FOR AND,XOR,NOR
                                {
                                        signal_ptr[0][i-500] = 1;
                                        signal_ptr[1][i-500] = 1;
                                }
			}


		}

                else if (signal_type == TOGGLE_SWITCH)
                {
                        int duration = 0, stochastic = 0;
                        float random_number =  my_rand(global_param.globals.idum, global_param.globals.itemp);
                        if (random_appearance ==1)
                                stochastic =  ROUND(my_rand(global_param.globals.idum, global_param.globals.itemp)*1000);

                        if (random_duration ==1)
                                duration = ROUND(random_number*400);
                        else
                                duration = 400; //normally resources should be 400 time units.
                        for (i=0;i<selection_period;i++)
                        {
                                food[i]=0;
                                signal_ptr[0][i] = -1;
                                signal_ptr[1][i] = -1;
                                //OR 07.22.06 - AND 07.24.06 -XOR 07.28.06 - NAND 08.02.06

                                if (i>=(800+stochastic-duration) && i<=(950+stochastic-duration))
                                        signal_ptr[0][i] = 1;
                                if (i>=(950+stochastic-duration) && i<=(950+stochastic+duration))
                                      food[i] = 10000;
                                if (i>=(950+stochastic+duration) && i<=(1100+stochastic+duration))
                                        signal_ptr[1][i] = 1;

                                if (i>=(2800+stochastic-duration) && i<=(2950+stochastic-duration))
                                        signal_ptr[0][i] = 1;
                                if (i>=(2950+stochastic-duration) && i<=(2950+stochastic+duration))
                                      food[i] = 10000;
                                if (i>=(2950+stochastic+duration) && i<=(3100+stochastic+duration))
                                        signal_ptr[1][i] = 1;


                        }
                } // TOGGLE_SWITCH END


		else if (signal_type == PRESET_GATE)
	        {
			int duration = 0, stochastic = 0;
			float random_number =  my_rand(global_param.globals.idum, global_param.globals.itemp);     
			if (random_appearance ==1)
				stochastic =  ROUND(my_rand(global_param.globals.idum, global_param.globals.itemp)*500);
			
			if (random_duration ==1)
				duration = 50 + ROUND(random_number*300);
			else
				duration = 200; //normally resources should be 400 time units.
			for (i=0;i<selection_period;i++)
			{
				food[i]=0;
                 		signal_ptr[0][i] = -1;
				signal_ptr[1][i] = -1;
				if (random_duration==1 && global_param.general.n_signals>2)
					signal_ptr[2][i] = -1 +2*random_number;

                                //OR 07.22.06 - AND 07.24.06 -XOR 07.28.06 - NAND 08.02.06
				
                                if (i>=(750+stochastic) && i<=(1150+stochastic))
                                        signal_ptr[0][i-500] = 1;
				if (i>=(950+stochastic-duration) && i<=(950+stochastic+duration))
					food[i] = 10000;

                                if (i>=(2250+stochastic) && i<=(2650+stochastic))
                                        signal_ptr[1][i-500] = 1;
                                if (i>=(2450+stochastic-duration) && i<=(2450+stochastic+duration)) 
					food[i] = 10000;

                                //if (i>=(3750+stochastic) && i <=(4150+ stochastic)) //FOR OR,NAND
                                if (i>=(3200+stochastic) && i<=(4000+stochastic)) //FOR AND,XOR,NOR
                                {
                                        signal_ptr[0][i-500] = 1;
                                        signal_ptr[1][i-500] = 1;
                                }
				//if (i>=(3950+stochastic-duration) && i<=(3950+stochastic+duration))
				//if (i>=3600+stochastic-2*duration) && i<=(3600+stochastic+2*duration))
				//{
				//	food[i] = 10000;
				//}
					
								
			}

		} // PRESET_GATE END

		else if (signal_type == MULTIGATE)
		{
			//random assignment of gate based on signal 3.
			//int random_gate_type = ROUND(my_rand(global_param.globals.idum, global_param.globals.itemp));
			static int random_gate_type =1;
			random_gate_type  ^= 1; //XOR with 1
			cout << "\ngate type: " << random_gate_type;
			for (i=0; i<selection_period;i++)
				signal_ptr[2][i] = -1 + 2*random_gate_type;

			int duration = 0, stochastic = 0;     
			if (random_appearance ==1)
			{
				duration = 200 + ROUND(my_rand(global_param.globals.idum, global_param.globals.itemp)*600);
				stochastic = 1450 - ROUND(my_rand(global_param.globals.idum, global_param.globals.itemp)*2900);
			}
			for (i=0;i<selection_period;i++)
			{
				 food[i]=0;
		                 signal_ptr[0][i] = -1;
				 signal_ptr[1][i] = -1;
			
				//MULTIGATE EXPERIMENT
				if (signal_ptr[2][i] == -1)
				{
					//OR gate
					if (i>=550 && i<=950)
                     			{
						signal_ptr[0][i-500] = 1;
			                        food[i] = 10000;
					}
			                if (i>=2050 && i<=2450)
                     			{
			                        signal_ptr[1][i-500] = 1;
                        			food[i] = 10000;
			                }
		                        if (i>=3550 && i <=3950)
                   			//if (i>=3150 && i<=4350)
			                {
                         			signal_ptr[0][i-500] = 1;
			                        signal_ptr[1][i-500] = 1;
                        			food[i] = 10000;
                     			}
				}
				else if (signal_ptr[2][i] == 1)
				{
					//XOR gate
					if (i>=550 && i<=950)
                     			{
						signal_ptr[0][i-500] = 1;
                         			food[i] = 10000;
					}
                     			if (i>=2050 && i<=2450)
                     			{
                         			signal_ptr[1][i-500] = 1;
                        			food[i] = 10000;
                     			}
                     			//if (i>=3550 && i <=3950)
                    			if (i>=3150 && i<=4350)
                     			{
                         			signal_ptr[0][i-500] = 1;
                         			signal_ptr[1][i-500] = 1;
                         			//food[i] = 10000;
                     			}
				 }
			}
		} //End of MULTIGATE
		
		//Multistate experiments have 2 environmental states: one where the resource is well corellated with
		// the signal and another where it is totally random. Offset will have the ratio of state1:state2
		else if (signal_type == BISTATE)
		{
			float random_number = my_rand(global_param.globals.idum, global_param.globals.itemp);
			int smoothness = 100;
			int duration = 0, stochastic = 0;
			//cout <<"Random_number, offset, duration, stochastic: " << random_number << "," << offset <<"," << random_duration << random_appearance;
			if (random_number < (double(offset)/double(offset+1)))
			{
				//STATE1:CORRELATED SIGNAL WITH FOOD  
				if (random_appearance ==1)
					stochastic =  ROUND((1-2*my_rand(global_param.globals.idum, global_param.globals.itemp))*500);
				if (random_duration ==1)
					duration = 400 + ROUND(random_number*400);
				else
					duration = 600; //normally resources should be present for 1200 time units.
				for (i=0;i<selection_period;i++)
				{
					food[i]=0;
                    			signal_ptr[0][i] = 1;
					if (i>=(2250 + stochastic - duration-smoothness) && i<=(2250 + stochastic + duration))
					{
						signal_ptr[0][i-500] = tanh(2 - 2*(i-(2250 + stochastic - duration-smoothness))*(1/double(smoothness)));
						food[i] = 10000*(0.5 + 0.5*tanh(-2 + 2*(i-(2250 + stochastic - duration-smoothness))*(1/double(smoothness))));
					}
				    if (i>=(2250 + stochastic + duration-smoothness) && i<=(2250 + stochastic + duration +smoothness))
					{
						signal_ptr[0][i-500] = tanh(-2 + 2*(i-(2250 + stochastic + duration - smoothness))*(1/double(smoothness)));
						food[i] = 10000*(0.5 +0.5*tanh(2 - 2*(i-(2250 + stochastic + duration - smoothness))*(1/double(smoothness))));
					}
				}
			} 
			else
			{
				//cout <<"\nRandom";
				//STATE2:NO CORRELATION SIGNAL TO FOOD
			    if (random_appearance ==1)
					stochastic =  ROUND((1-2*my_rand(global_param.globals.idum, global_param.globals.itemp))*500);
				if (random_duration ==1)
					duration = 400 + ROUND(random_number*400);
				else
					duration = 600; //normally resources should be present for 1200 time units.
				for (i=0;i<selection_period;i++)
				{
					food[i]=0;
                    			signal_ptr[0][i] = -1;
				}
				for (i=0;i<(5+ROUND(10*my_rand(global_param.globals.idum, global_param.globals.itemp)));i++) //number of transitions
				{
					int duration = 100 + ROUND(100*my_rand(global_param.globals.idum, global_param.globals.itemp));
					int start_interval = ROUND(my_rand(global_param.globals.idum, global_param.globals.itemp)*(selection_period - duration)); //time point when the oxygen goes up
					for (int j=0;j<duration/2;j++) //duration of food/oxygen
						food[start_interval +j] = 10000*tanh(4*j/double(duration));
					for (int j=duration/2;j<duration;j++) //duration of food/oxygen
						food[start_interval +j] = 10000*tanh(2*double(duration)/j -2);
				}
			}
			}
		else if (signal_type == PERIODIC)
		{

			int max_food = 10000;			
			double *theta = new double [ global_param.general.n_signals ];
			for (i=0; i<global_param.general.n_signals; i++)
				theta[i] = my_rand(global_param.globals.idum, global_param.globals.itemp)*my_pi; //phase

			int frequency = 10;	//frequency of cosine
			for (i=0;i<selection_period;i++)
			{
				for (j=0; j<global_param.general.n_signals; j++)
					signal_ptr[j][i] = cos((double)(2*frequency*my_pi*i/selection_period +theta[j]));
				food[i] = MAX(0,max_food*(-0.3 + 0.5*cos((double)(2*frequency*my_pi*i/selection_period))));
			}
			/*for (i=0;i<selection_period;i++)
			{
				for (j=0;j<number_of_inputs;j++)
					signal_ptr[j][i] = cos((double)(2*frequency*my_pi*i/selection_period +theta[j]));
				food[i] = 1000*(0.5+0.5*cos((double)(2*frequency*my_pi*i/selection_period)));
			}*/
			delete[] theta;
		}
}



double * signal_creation(double *signal_ptr,int signal_duration, int bins,double min, double max, unsigned long &idum, unsigned long &itemp)
{
	int i,j;
	double step;
	int fundamental = signal_duration / bins;
	for (i=0;i<=bins;i++)
		signal_ptr[i*fundamental] =  min + (max-min)*my_rand(idum, itemp);
	for (i=0;i<bins;i++)
	{
		step = (signal_ptr[(i+1)*fundamental] - signal_ptr[i*fundamental])/fundamental;
		for (j=1;j<=fundamental;j++)
			signal_ptr[j + i*fundamental] = signal_ptr[i*fundamental + j-1] + step;
	}
	return signal_ptr;
}



//! puts MAX value (and rank) in array of double_ints into "out"; returns the original index of the max value
int find_maxloc(double_int *array, int size, double_int &out)
{
  int index=0;
  out.value=0;
  for (int i=0; i<size; i++) 
    if (array[i].value>out.value){
      out.value=array[i].value;
      out.rank=array[i].rank;
      index=i;
    }
  return index;
}


//! puts MIN value (and rank) in array of double_ints into "out"; returns the original index of the min value
int find_minloc(double_int *array, int size, double_int &out)
{
  int index=0;
  out.value=DBL_MAX;
  for (int i=0; i<size; i++)
    if (array[i].value<out.value){
      out.value=array[i].value;
      out.rank=array[i].rank;
      index=i;
    }
  return index;
}

//! returns SUM value for all elements of the array of doubles
double find_sum_dbl(double *array, int size)
{
  double sum=0;
  for (int i=0; i<size; i++)
    sum += array[i];
  return sum;
}

//! returns SUM value for all elements of the array of ints
int find_sum_int(int *array, int size)
{
  int sum=0;
  for (int i=0; i<size; i++)
    sum += array[i];
  return sum;
}


// returns distance between two coordintates on the grid
double calc_dist(int grid_x_max, int coord1, int coord2)
{
  int x1 = coord1 % grid_x_max;
  int y1 = coord1 / grid_x_max;
  int x2 = coord2 % grid_x_max;
  int y2 = coord2 / grid_x_max;
  return sqrt( double( (x2-x1)*(x2-x1) + (y2-y1)*(y2-y1) ) );
}
