/*
 * Framework.cpp
 *
 *  Created on: Aug 17, 2012
 *      Author: linh
 */
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/time.h>
#include <algorithm>
#include <vector>
#include <sstream>
#include <string>
#include <map>
#include <queue>
#include <stack>
#include <iostream>
#include "Framework.h"


#include <fstream>
#include <ctime>
#include "DesignProblem.h"
#include "PartDatabase.h"
#include "xmlParser.h"

#include "VFLIB/argedit.h"
#include "VFLIB/allocpool.h"

//#define CLOCKS_PER_SEC 100000
bool compare_id_pair(std::pair<int,int> first, std::pair<int,int> second) {
	return (first.first > second.first);
}

Framework::Framework(PartDatabase* partDB_): partDB(partDB_) {

}

Framework::Framework(PartDatabase* partDB_, DesignProblem dp_): partDB(partDB_), dp(dp_){

}

Framework::~Framework() {
	// TODO Auto-generated destructor stub
}

vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >* Framework::ModuleMatch(int number_of_solutions, int synthetic_module_library_size, int number_of_DB_replicates) {
	vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >* solution_list = new vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >;



	//cout << number_of_solutions << endl;
		//cout << synthetic_module_library_size << endl;
		//cout << number_of_DB_replicates << endl;

		//for (int i = 0; i < align_NODE_TYPE; i++){
		//for (int i = 0; i < 8; i++){
		//		 	  	cout << align_NODE_TYPE[i] << endl;
		//		 	  	}

		ARGEdit editor_tmp1;
			GeneCircuitGraph* gcg_last = new GeneCircuitGraph(&editor_tmp1);




	//clock_t begin, end;
	vector<Module*> *module_list;
	if (synthetic_module_library_size > 1)
		module_list = partDB->RandomizeModuleLibrary(synthetic_module_library_size, 15);
	else
		module_list = partDB->loadModuleLibrary();

	// Initialization
	GeneCircuitGraph* extension_gcg_tmp = dp.gcg.clone();
	for (int node_id = 0; node_id < extension_gcg_tmp->NodeCount(); node_id++)
		extension_gcg_tmp->GetNodeAttr(node_id)->original_node_id = node_id;
	queue<GeneCircuitGraph*> extension_history_queue;
	extension_history_queue.push(extension_gcg_tmp);
	bool continue_searching = true;
	do { // main loop on node selection & expansion
		stack<Matching_State*> traverse_history_stack;
		GeneCircuitGraph *current_extension_gcg = extension_history_queue.front();
		extension_history_queue.pop();
		GeneCircuitGraph *current_gcg = current_extension_gcg->clone();
		unsigned int current_module_id = 0;
		bool forward = true;	// to determine if the process will be forward or will be stepped back
		do { // main loop on module matching
			// TEST HERE
			// if (forward) {
			//	cout << "==============================" << endl;
			//	current_gcg->TestPrint(&std::cout);
			//}
			GraphIsomorphismCollection* all_graph_isomorphism_tmp = new GraphIsomorphismCollection;
			if (forward) {
				if (current_gcg->getNumberOfUnkownNodes() == 0) { // If current gene circuit graph == empty -> a solution is found
					//solution_list->push_back(Layout(current_gcg, partDB));
					GeneCircuitGraph* full_gcg = Layout(current_gcg, partDB);
					solution_list->push_back(std::make_pair(current_gcg->clone(), full_gcg));
					// TEST HERE
					//cout << "One solution found !" << endl;
					//cout << "==============================" << endl;
					//Layout(current_gcg, partDB)->TestPrint(&std::cout);


					gcg_last = 0;gcg_last = current_gcg;



					forward = false;	// step back
				}
				else {
					while (all_graph_isomorphism_tmp->size() == 0 && current_module_id < module_list->size()) {
						//module_list->at(current_module_id)->TestPrint(&std::cout);
						VF2SubState vf2_sub_state(module_list->at(current_module_id), current_gcg);
						match(&vf2_sub_state, all_visitor, all_graph_isomorphism_tmp);
						current_module_id++;
					}
					//current_module_id--;	// back to the id of current module
				}
			}
			if (all_graph_isomorphism_tmp->size()) {	// match successfully
				// update the history stack
				traverse_history_stack.push(new Matching_State(current_gcg, current_module_id - 1, all_graph_isomorphism_tmp, 0));
				//current_module_id++;
			}
			else {	// step back here since we can not continue matching
				if (!traverse_history_stack.empty()) {
					if (((unsigned int)traverse_history_stack.top()->matching_id) < traverse_history_stack.top()->matching_list->size() - 1) { // try with the next matching
						// Update the history stack
						traverse_history_stack.top()->matching_id++;
						current_module_id = traverse_history_stack.top()->module_id + 1;
						free_v(current_gcg);
					}
					else { // skip this module and try with the next one
						current_module_id = traverse_history_stack.top()->module_id + 1;
						delete traverse_history_stack.top();
						traverse_history_stack.pop();							// remove the last matching
						free_v(current_gcg);
					}
				}
				else
					break;	// Finish, escape the main loop on module matching
			}
			// Update current gene circuit graph
			// Check the connection compatibility
			//		forward = true if compatible, otherwise, forward = false
			// TODO: Contract the matched subgraph into some nodes
			if (!traverse_history_stack.empty()) {
				// Update current gene circuit graph
				//cout << "---------------------------" << endl;
				//current_gcg->TestPrint(&std::cout);
				int current_module_id_tmp = traverse_history_stack.top()->module_id;
				current_gcg = traverse_history_stack.top()->gcg->clone();
				map<int,int> circuit_to_module;
				bool *is_matched = new bool [current_gcg->NodeCount()];
				for (int node_id = 0; node_id < current_gcg->NodeCount(); node_id++)
					is_matched[node_id] = false;
				// Update nodes
				for (unsigned int pair_id = 0; pair_id < traverse_history_stack.top()->matching_list->at(traverse_history_stack.top()->matching_id).size(); pair_id++) {
					NodePair node_pair_tmp = traverse_history_stack.top()->matching_list->at(traverse_history_stack.top()->matching_id)[pair_id];
					is_matched[node_pair_tmp.large_graph_node] = true;
					circuit_to_module[node_pair_tmp.large_graph_node] = node_pair_tmp.small_graph_node;
					current_gcg->GetNodeAttr(node_pair_tmp.large_graph_node)->module_id_list.push_back(current_module_id_tmp);
					// TEST HERE
					// cout << current_gcg->GetNodeAttr(node_pair_tmp.large_graph_node)->component->name << " ---> " << module_list->at(current_module_id_tmp)->GetNodeAttr(node_pair_tmp.small_graph_node)->component->name << endl;
					current_gcg->GetNodeAttr(node_pair_tmp.large_graph_node)->component->name = module_list->at(current_module_id_tmp)->GetNodeAttr(node_pair_tmp.small_graph_node)->component->name;
				}
				// Update edges
				for (int src_node_id = 0; src_node_id < current_gcg->NodeCount(); src_node_id++)
					for (int dest_node_id = 0; dest_node_id < current_gcg->NodeCount(); dest_node_id++)
						if (src_node_id != dest_node_id && is_matched[src_node_id] && is_matched[dest_node_id] && current_gcg->GetEdgeAttr(src_node_id, dest_node_id) != NULL)
							current_gcg->GetEdgeAttr(src_node_id, dest_node_id)->type = module_list->at(current_module_id_tmp)->GetEdgeAttr(circuit_to_module[src_node_id],circuit_to_module[dest_node_id])->type;
				// TEST HERE
				//if (current_module_id_tmp == 7)
				//{
				//	cout << "+++++++++++++++++++++++++++++" << endl;
				//	current_gcg->TestPrint(&std::cout);
				//}
				// Check the connection compatibility
				bool compatible = true;
				for (int src_node_id = 0; src_node_id < current_gcg->NodeCount(); src_node_id++) {
					for (int dest_node_id = 0; dest_node_id < current_gcg->NodeCount(); dest_node_id++)
						if (src_node_id != dest_node_id && current_gcg->GetEdgeAttr(src_node_id, dest_node_id) != NULL
							&& ((!is_matched[src_node_id] && is_matched[dest_node_id]) || (is_matched[src_node_id] && !is_matched[dest_node_id]))) {
								compatible = Check_Update(current_gcg, src_node_id, dest_node_id, partDB);
								if (!compatible)
									break;
						}
					if (!compatible)
						break;
				}
				if (compatible)
					forward = true;
				else {
					forward = false;
					free_v(current_gcg);
				}
				delete []is_matched;
			}
			else
				current_gcg = current_extension_gcg->clone();
		}
		while (solution_list->size() < ((unsigned int) number_of_solutions));
		if (solution_list->size() < ((unsigned int) number_of_solutions)) {
			// Choose a node and expand it
			for (int node_id = 0; node_id < current_extension_gcg->NodeCount(); node_id++) {
				int number_of_subs = partDB->getNumberOfSubsitution(Id2Str(current_extension_gcg->GetNodeAttr(node_id)->component->getType()));
				if (current_extension_gcg->GetNodeAttr(node_id)->component->name.compare("") == STR_EQ && number_of_subs > 0)
					for (int sub_id = 1; sub_id <= number_of_subs; sub_id++) {
						// Expansion here
						ARGEdit *editor_tmp = new ARGEdit;
						map<int,int> circuit_to_extension;
						// Add nodes
						for (int circuit_node_id = 0; circuit_node_id < current_extension_gcg->NodeCount(); circuit_node_id++)
							if (circuit_node_id != node_id)
								circuit_to_extension[circuit_node_id] = editor_tmp->InsertNode(current_extension_gcg->GetNodeAttr(circuit_node_id)->clone());
						// Add edges
						for (int circuit_src_node_id = 0; circuit_src_node_id < current_extension_gcg->NodeCount(); circuit_src_node_id++)
							for (int circuit_dest_node_id = 0; circuit_dest_node_id < current_extension_gcg->NodeCount(); circuit_dest_node_id++)
								if (circuit_src_node_id != node_id && circuit_dest_node_id != node_id && circuit_src_node_id != circuit_dest_node_id && current_extension_gcg->GetEdgeAttr(circuit_src_node_id, circuit_dest_node_id) != NULL)
									editor_tmp->InsertEdge(circuit_to_extension[circuit_src_node_id], circuit_to_extension[circuit_dest_node_id], current_extension_gcg->GetEdgeAttr(circuit_src_node_id, circuit_dest_node_id)->clone());
						// Expansion with the substitution
						Module *sub_gcg = partDB->loadSubstitution(Id2Str(current_extension_gcg->GetNodeAttr(node_id)->component->getType()),sub_id);
						map<int,int> sub_to_extension;
						// Add nodes
						for (int sub_node_id = 0; sub_node_id < sub_gcg->NodeCount(); sub_node_id++) {
							BioNetNode *bn_node_tmp = sub_gcg->GetNodeAttr(sub_node_id)->clone();
							bn_node_tmp->original_node_id = current_extension_gcg->GetNodeAttr(node_id)->original_node_id;
							sub_to_extension[sub_node_id] = editor_tmp->InsertNode(bn_node_tmp);
						}
						// Add edges
						for (int sub_src_node_id = 0; sub_src_node_id < sub_gcg->NodeCount(); sub_src_node_id++)
							for (int sub_dest_node_id = 0; sub_dest_node_id < sub_gcg->NodeCount(); sub_dest_node_id++)
								if (sub_src_node_id != sub_dest_node_id && sub_gcg->GetEdgeAttr(sub_src_node_id, sub_dest_node_id) != NULL)
									editor_tmp->InsertEdge(sub_to_extension[sub_src_node_id], sub_to_extension[sub_dest_node_id], sub_gcg->GetEdgeAttr(sub_src_node_id, sub_dest_node_id)->clone());
						// TODO: permute inputs and fix for the multiple output case
						// Add connections to the output
						int adj_to_output_node_id = current_extension_gcg->GetOutEdge(node_id, 0);
						editor_tmp->InsertEdge(sub_to_extension[sub_gcg->outputs[0]], circuit_to_extension[adj_to_output_node_id], current_extension_gcg->GetEdgeAttr(node_id, adj_to_output_node_id)->clone());
						// Add connections to the inputs
						int number_of_inputs = current_extension_gcg->InEdgeCount(node_id);
						if (number_of_inputs == 1) {
							int adj_to_input_node_id = current_extension_gcg->GetInEdge(node_id, 0);
							editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id], sub_to_extension[sub_gcg->inputs[0]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id, node_id)->clone());
							GeneCircuitGraph *gcg_tmp =  new GeneCircuitGraph(editor_tmp);
							// TEST HERE
							//gcg_tmp->TestPrint(&std::cout);
							extension_history_queue.push(gcg_tmp);
						}
						else if (number_of_inputs == 2) {
							int adj_to_input_node_id_0 = current_extension_gcg->GetInEdge(node_id, 0);
							int adj_to_input_node_id_1 = current_extension_gcg->GetInEdge(node_id, 1);
							editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], sub_to_extension[sub_gcg->inputs[0]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id_0, node_id)->clone());
							editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], sub_to_extension[sub_gcg->inputs[1]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id_1, node_id)->clone());
							GeneCircuitGraph *gcg_tmp1 =  new GeneCircuitGraph(editor_tmp);
							// TEST HERE
							//gcg_tmp1->TestPrint(&std::cout);
							extension_history_queue.push(gcg_tmp1);
							ARGEdit *another_editor = (ARGEdit *)gcg_tmp1->ConvertToLoader();
							another_editor->DeleteEdge(circuit_to_extension[adj_to_input_node_id_0], sub_to_extension[sub_gcg->inputs[0]]);
							another_editor->DeleteEdge(circuit_to_extension[adj_to_input_node_id_1], sub_to_extension[sub_gcg->inputs[1]]);
							another_editor->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], sub_to_extension[sub_gcg->inputs[1]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id_0, node_id)->clone());
							another_editor->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], sub_to_extension[sub_gcg->inputs[0]], current_extension_gcg->GetEdgeAttr(adj_to_input_node_id_1, node_id)->clone());
							GeneCircuitGraph *gcg_tmp2 =  new GeneCircuitGraph(another_editor);
							// TEST HERE
							//gcg_tmp2->TestPrint(&std::cout);
							extension_history_queue.push(gcg_tmp2);
						}
						else
							cout << "WE HAVE NOT PROCESSED YET FOR MODULES THAT HAVE MORE THAN TWO INPUTS " << endl;
					}
			}
		}
		else {
			continue_searching = false;	// Finish, escape the main loop on node selection & expansion
			// clear the main stack
			while (!traverse_history_stack.empty()) {
				delete traverse_history_stack.top()->gcg;
				delete traverse_history_stack.top()->matching_list;
				traverse_history_stack.pop();
			}
		}
		delete current_extension_gcg;
	}
	while (!extension_history_queue.empty() && continue_searching);
	// clear the main queue
	while (!extension_history_queue.empty()) {
		delete extension_history_queue.front();
		extension_history_queue.pop();
	}


	///////////////////////////////////////////////////////////////////////////////////
				  	/////////////////////////// OPTIMIZE //////////////////////////////////////////////

				 /// 	vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >* solution_list = ModuleMatch(1,0);

				  	vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >* solution_list1 =solution_list;

				  //	cout << "\nExhaustive search 111111" << endl;

				  		ARGLoader* loader = solution_list1->at(0).second->ConvertToLoader();

				  	//	cout << "\nExhaustive search2222" << endl;

				  		IdList inputs, outputs;
				  		for (int i = 0; i < dp.gcg.NodeCount(); i++) {
				  			if (dp.gcg.InEdgeCount(i) == 0)
				  				for (int j = 0; j < loader->NodeCount(); j++)
				  					if (((BioNetNode*)loader->GetNodeAttr(j))->original_node_id == i) {
				  						inputs.push_back(j);
				  						break;
				  					}
				  			if (dp.gcg.OutEdgeCount(i) == 0)
				  				for (int j = 0; j < loader->NodeCount(); j++)
				  					if (((BioNetNode*)loader->GetNodeAttr(j))->original_node_id == i) {
				  						outputs.push_back(j);
				  						break;
				  					}
				  		}
				 // 		cout << "\nExhaustive search" << endl;
				  		// Build the static circuit
				  		Module* final_gcg = new Module(loader, inputs, outputs);
				  		// TEST HERE
				  		//	final_gcg->TestPrint(&std::cout);
				  		// delete solution_list;

				  		// Build the dynamic circuit
				  		DynamicGeneCircuit dgc(final_gcg);
				  		//delete final_gcg;
				  		// TEST HERE
				  		// dgc.PrintOut(&std::cout);

		///		  		double t0, t1;
				  		double t0, t2;

				  		// Exhaustive search
			//	  		cout << "\nExhaustive search" << endl;
				  		//t0 = clock();
				  		//dgc.ExhaustiveSearch(partDB, dp.inputs, dp.outputs);
				  		//t1 = clock();
				  		//cout << "Time: " << (t1 - t0)/(double)CLOCKS_PER_SEC << endl;

				  		string SHOW_ME_THE_TYPE[solution_list1->at(0).first->NodeCount()];

				  		// GA search
			//	  		cout << "GA search" << endl;
				  		for (int i = 0; i < 1; i++) {
				  			t0 = clock();
				  			dgc.GASearch(partDB, dp.inputs, dp.outputs);
				  			t2 = clock();
			//	  			cout << "Time: " << (t2 - t0)/(double)CLOCKS_PER_SEC << endl;
				  		}
				  		for (unsigned int i = 0; i < dgc.root_component->sub_component_list.size();i++)
				  			final_gcg->GetNodeAttr(i)->component->variant_id = dgc.root_component->sub_component_list[i]->variant_id;
				  		//final_gcg->TestPrint(&std::cout);
				  		//dgc.SimulateSteadyState(partDB,dp.inputs,dp.outputs);
				  		//dp.TestPrint(&std::cout);*/
				  		GeneCircuitGraph *gcg_tmp = solution_list1->at(0).first;
				  		for (int i = 0; i < solution_list1->at(0).first->NodeCount(); i++) {
			//	  			cout << i << "\t" << Id2Str(gcg_tmp->GetNodeAttr(i)->component->getType()) << "\t" << gcg_tmp->GetNodeAttr(i)->component->name << endl;

				  			SHOW_ME_THE_TYPE[i] =  gcg_tmp->GetNodeAttr(i)->component->name;

			//	  			cout << SHOW_ME_THE_TYPE[i] << "   oooooooooo  " <<endl;

				  			for (int j = 0; j < final_gcg->NodeCount(); j++)
				  				if (final_gcg->GetNodeAttr(j)->original_node_id == i) {
			//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << endl;
			//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << "\t" << final_gcg->GetNodeAttr(j)->component->variant_id << endl;
				  				}
			//	  			cout << "--------------------" << endl;
				  		}

				  		//cout <<

				  		//delete solution_list->at(0).first;
				  		//delete solution_list->at(0).second;
				  		//delete solution_list;

				  	//////////////////////////// END OPTIMIZE /////////////////////////////////////////
				  	///////////////////////////////////////////////////////////////////////////////////

	//dp.gcg.TestPrint(&std::cout);
	//	gcg_last->TestPrint(&std::cout);



//	Layout(gcg_last, partDB)->TestPrint(&std::cout);
	//GeneCircuitGraph* full_gcg = Layout(current_gcg, partDB);
	//					solution_list->push_back(std::make_pair(current_gcg->clone(), full_gcg));


	//Layout(current_gcg, partDB)->TestPrint(&std::cout);

	////////////////////////////////////////////////////////////////
	//////////////////// START NASOS ////////////////////////////////
	////////////////////////////////////////////////////////////////

	//template <class Node, class Edge>

		  int i;
		    for(i=0; i<gcg_last->NodeCount(); i++)
		      // out << i << ' ' << *g.GetNodeAttr(i) << endl; // linh
		    	//{cout << i << *gcg_last->GetNodeAttr(i) << endl;}
		    {
		    	//string A_TEST = gcg_last->GetNodeAttr(i)->component->getType();
		    	//cout << i << gcg_last-> GetNodeAttr(i)->component->getType() << endl;
		    	//cout << i << gcg_last-> GetNodeAttr(i)->component->name << gcg_last-> GetNodeAttr(i)->component->getStringType() << endl;

		    }

		    int j;
		    for(i=0; i<gcg_last->NodeCount(); i++)
		      { //out << g.OutEdgeCount(i) << endl; // linh
		        for(j=0; j<gcg_last->OutEdgeCount(i); j++)
		          {// int k;
		           // BioNetEdge *attr;
		           // k=gcg_last->GetOutEdge(i, j, &attr);
		           // cout << i << ' ' << k << ' ' << *attr << endl;
		           // cout << i << ' ' << k << ' '  << endl;
		          }
		      }



		// 	EXPORT XML




		    // STATIC WAY
		    // just take the scaled input geometry, give type x in AND,OR etc gates as part type for XML and define pictures of variants in web app.

		    //step 1 - output the scaled thing, with standard gates
		    // convert from XML to ordered AND scaled XML, parse three times, one for input, one for output and one for rest
		    //define scale factor, use same code with scale =1 in main for ordered part !!!!

		    float scale_factor=1.2; //global scale
		    float gate_scale_factor=2.5;

		    //convert from XML to ordered XML
		    XMLNode xMainNode=XMLNode::openFileHelper("Database/multiplexer2XML.xml");
		    XMLNode  xNode=xMainNode.getChildNode("mxGraphModel").getChildNode("root").getChildNode("mxCell");

			int n=xNode.nChildNode("mxCell");

			  			  int  nodes_counter =0;
			  			  int  input_count =0;
			  			  for (int i = 2; i < xMainNode.getChildNode(0).nElement(); i++){

			  			  if(strcmp(xMainNode.getChildNode(0).getChildNode(i).getName() , "mxCell") ==0 ){

			  			  	  if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "triangle") ==0 ){
			  			  		nodes_counter++;}
			  			  	  else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=or") ==0 ){
			  			  		nodes_counter++;}
			  			  	  else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=xor") ==0 ){
			  			  		nodes_counter++; }
			  			  	  else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=step") ==0 ){
			  			  		nodes_counter++; input_count++;}
			  			  	  else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "rounded=1") ==0 ){
			  			  		nodes_counter++;	}
			  			  	  else if (strncmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "image", strlen("image"))==0){nodes_counter++;}

			  			  }
			  			  if(strcmp(xMainNode.getChildNode(0).getChildNode(i).getName() , "UserObject") ==0 ){

			  			  	if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "triangle") ==0 ){
			  			  		nodes_counter++;}

			  			  		  if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=or") ==0 ){
			  			  			nodes_counter++; }

			  			  		  if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=xor") ==0 ){
			  			  			nodes_counter++; }

			  			  		  if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=step") ==0 ){
			  			  			nodes_counter++;input_count++;}

			  			  		  if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "rounded=1") ==0 ){
			  			  			nodes_counter++;  }

			  			  		if (strncmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "image", strlen("image"))==0){nodes_counter++;}

			  			  }

			  			  }


		    ofstream myfile ("Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml"); //change to XML_ORDERED_FOR_INPUT in main
		    if (myfile.is_open())
		    {

		    	  // WRITE HEADER
				  string TEXT1 = "<mxGraphModel grid=\"1\" guides=\"1\" tooltips=\"1\" connect=\"1\" fold=\"1\" page=\"0\" pageScale=\"1\" pageWidth=\"826\" pageHeight=\"1169\">";
				  myfile << TEXT1 << "\n";
				  TEXT1 = "<root>";
				  myfile << TEXT1 << "\n";
				  TEXT1 = "<mxCell id=\"0\"/>";
				  myfile << TEXT1 << "\n";
				  TEXT1 = "<mxCell id=\"1\" parent=\"0\"/>";
				  myfile << TEXT1 << "\n";

			  //READ original XML, write back scaled, parse for INPUT

			 //WRITE NODES
			 // for (int comp = 0; comp < dp.gcg.NodeCount(); comp++)
			 int  input_counter =1;
			 string  node_mapper[nodes_counter+2]; //map the node as you find it (which is the order it is written in the file) to its xml ID, to remap edges later
			  int node_counter =2; //not 0 because we write to XML

			  int combinations = pow(2,input_count);
			  float my_flt[combinations][input_count+1];



			  // FIRST FOR  - INPUTS
for (int step_i = 0; step_i < 3; step_i++){

int testme=10;
string testmine = "aaaa";
std::stringstream testaki;
				   testaki << step_i ;
				   string testaki_CHAR = testaki.str();
//
//cout << " " <<  testaki_CHAR << " " << endl;

for (int i = 2; i < xMainNode.getChildNode(0).nElement(); i++){

				 // cout <<  "mxCell";
				 // cout <<xMainNode.getChildNode(0).getChildNode(i).getName();
				 // myfile <<   xMainNode.getChildNode(0).getChildNode(i).getAttribute("style");
				 // myfile <<   xMainNode.getChildNode(0).getChildNode(i+1).getAttribute("style") << "\n";

	string s1 ("edgeStyle");
	if(strcmp(xMainNode.getChildNode(0).getChildNode(i).getName() , "mxCell") ==0 ){

//	cout <<  "mxCell";

// INIT WRITE EACH NODE
				  int PLACE_REAL_X = atoi(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("width"))*scale_factor;
				  int PLACE_REAL_Y = atoi(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("width"))*scale_factor*1.5;
				  int SCALED_WIDTH = atoi(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("width"));
				  int SCALED_HEIGHT = atoi(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("height"));

				  // WRITE EACH NODE
				  //for (int i = 0; i < gcg_last->NodeCount(); i++){
				  string LABEL_IT = "pLUX"; // collect this from output data, left
				  string DEFINE_IT = "mRNA"; // collect this from output data, right
				  int ID_IT = 0; // collect this from output data, first, ADD +2 to everything, since nodes will start from 2 and forth, DO SAME for edges (connections)

				//   LABEL_IT = gcg_last-> GetNodeAttr(i)->component->name;
				//   DEFINE_IT = Id2Str(gcg_last->GetNodeAttr(i)->component->getType());

				//take from original XML for main
//				cout <<  "mxCell";

				//define based on gate type - put DUMMY for now
				//LABEL_IT = xMainNode.getChildNode(0).getChildNode(i).getAttribute("label");
				//DEFINE_IT = xMainNode.getChildNode(0).getChildNode(i).getAttribute("link");

				LABEL_IT = "DUMMY1";
				DEFINE_IT = "DUMMY2";




//				cout <<  "mxCellaaaaaaaaaa";
				//take from OUTPUT, match with passed parameter from main, choose proper from group list in OUTPUT


				   ID_IT = node_counter;//i+2

				   std::stringstream ID_IT_X;
				   ID_IT_X << ID_IT ;
				   string ID_IT_X_CHAR = ID_IT_X.str();
				  //TEXT1 = "<UserObject label=\"mRNA\" link=\"0 0 1.3 1.3 0 1.3 0 1.3\" id=\"2\">";

				  string SHAPE_IT = "ellipse"; //shape=step
				//take from original XML for main

				 SHAPE_IT = xMainNode.getChildNode(0).getChildNode(i).getAttribute("style");
				//take from OUTPUT, match with passed parameter from main, choose proper from group list in OUTPUT

				  std::stringstream PLACE_IT_X;
				  PLACE_IT_X << PLACE_REAL_X ;
				  string PLACE_IT_X_CHAR = PLACE_IT_X.str();

				  std::stringstream PLACE_IT_Y;
				  PLACE_IT_Y << PLACE_REAL_Y ;
				  string PLACE_IT_Y_CHAR = PLACE_IT_Y.str();

		//if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=step") ==0 ){
		if (
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=step") ==0 & step_i == 0) |
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "rounded=1") ==0 & step_i == 1) |
		//(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=step") !=0 & strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "rounded=1") !=0 & step_i == 2)
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "triangle") ==0 & step_i == 2) |
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=or") ==0 & step_i == 2) |
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=xor") ==0 & step_i == 2)

		//add the case we have image/known gate etc
		//strncmp(str, substr, strlen(substr))
		| (strncmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "image", strlen("image"))==0 & step_i == 2 )

		){

	//	cout <<  " mxCell4 ";


		//assume Lihn given matchings

						 //<mxCell id="3" value="" style="image;image=stencils/clipart/Full_Folder_128x128.png" vertex="1" parent="1">
						 //     <mxGeometry x="330" y="360" width="390" height="340" as="geometry"/>
						 //   </mxCell>







				  //define based on style and Lihn gate type
				  if(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=or") ==0){
					  if(i<5){
				  SHAPE_IT = "image;image=stencils/clipart/Full_Folder_128x128.png";//AND gate type 1 // Earth_globe_128x128.png is type 2 etc
				  LABEL_IT = "AND_GATE - type 1";
					  }
					  else{
					SHAPE_IT = "image;image=stencils/clipart/Earth_globe_128x128.png";//AND gate type 1 // Earth_globe_128x128.png is type 2 etc
					LABEL_IT = "AND_GATE - type 2";
					  					  }

								DEFINE_IT = "pBAD - variant 1, hrpS - variant 2";
				  }
				  if(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "triangle") ==0){
				  SHAPE_IT = "image;image=stencils/clipart/Empty_Folder_128x128.png";//AND gate type 1
					LABEL_IT = "NOT_GATE - type 1";
								DEFINE_IT = "pLAC - variant 1, lacI - variant 2";
				  }




				 	//cout << strncmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "tria", strlen("tria")) << endl;

				  /////// DECIDE image - all will be images - USE variable SHOW_ME_THE_TYPE, use node_counter variable to do the matching (and not i which corresponds to the initial unordered XML)

				  		string IMAGE_MIDDLE_NAME = SHOW_ME_THE_TYPE[node_counter-2];

				  		if(strncmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "image", strlen("image"))==0
				  			|	(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "triangle") ==0 ) |
				  						(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=or") ==0 ) |
				  						(strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=xor") ==0 )

				  		){
				  		SHAPE_IT = "image;image=stencils/clipart/"+IMAGE_MIDDLE_NAME+"_128x128.png";

				  		LABEL_IT = xMainNode.getChildNode(0).getChildNode(i).getAttribute("value");
				  		//DEFINE_IT = xMainNode.getChildNode(0).getChildNode(i).getAttribute("link");
				  		LABEL_IT = IMAGE_MIDDLE_NAME;

				  		///// DEFINE VARIANTS
				  		DEFINE_IT = "";

				  		for (int j = 0; j < final_gcg->NodeCount(); j++){
				  						  			//	if (final_gcg->GetNodeAttr(j)->original_node_id == i) {
				  			if (final_gcg->GetNodeAttr(j)->original_node_id == node_counter-2) {

				  				string DEF1 = final_gcg->GetNodeAttr(j)->component->name;

				  				std::stringstream DEF_X;
				  				DEF_X << final_gcg->GetNodeAttr(j)->component->variant_id ;
				  				string DEF_X_CHAR = DEF_X.str();

				  				string DEF2 = DEF_X_CHAR;//final_gcg->GetNodeAttr(j)->component->variant_id.c_str();

				  				DEFINE_IT =  DEFINE_IT+" Name:"+DEF1+" Variant:"+ DEF2;

				  				//cout << DEFINE_IT;
				  					//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << endl;
				  					//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << "\t" << final_gcg->GetNodeAttr(j)->component->variant_id << endl;
				  						  				}
				  						  			//cout << "--------------------" << endl;
				  				}
				  				///// END DEFINE VARIANTS

				  		}



				  TEXT1 = "<UserObject label=\""+ LABEL_IT +"\" link=\""+ DEFINE_IT +"\" id=\""+ID_IT_X_CHAR+"\">";
								  //<UserObject label="mRNA" link="0 0 1.3 1.3 0 1.3 0 1.3" id="2">
								  myfile << TEXT1 << "\n";

				  TEXT1 = "<mxCell style=\""+SHAPE_IT+"\" vertex=\"1\" parent=\"1\">";
				  //<mxCell style="shape=step" vertex="1" parent="1"> // ADD everything as ellipse
				  myfile << TEXT1 << "\n";

 				  std::stringstream SCALED_WIDTH_X;
				  SCALED_WIDTH_X << SCALED_WIDTH*gate_scale_factor ;
				  string SCALED_WIDTH_X_CHAR = SCALED_WIDTH_X.str();

				  std::stringstream SCALED_HEIGHT_X;
				  SCALED_HEIGHT_X << SCALED_HEIGHT*gate_scale_factor*0.6 ;
				  string SCALED_HEIGHT_X_CHAR = SCALED_HEIGHT_X.str();

//cout <<  PLACE_IT_X_CHAR << endl;
//cout <<  PLACE_IT_Y_CHAR << endl;
//cout <<  SCALED_WIDTH_X_CHAR << endl;
//cout <<  SCALED_HEIGHT_X_CHAR << endl;
//cout <<  xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("x") << endl;
//cout <<  xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("y") << endl;
//cout <<  xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("width") << endl;
//cout <<  xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("height") << endl;

				  TEXT1 = "<mxGeometry x=\""+PLACE_IT_X_CHAR+"\" y=\""+PLACE_IT_Y_CHAR+"\" width=\""+SCALED_WIDTH_X_CHAR+"\" height=\""+SCALED_HEIGHT_X_CHAR+"\" as=\"geometry\"/>";



				  //TEXT1 = "<mxGeometry x=\""+PLACE_IT_X_CHAR+"\" y=\""+PLACE_IT_Y_CHAR+"\" width=\"120\" height=\"80\" as=\"geometry\"/>";
				  //TEXT1 = "<mxGeometry x=\""+PLACE_IT_X+"\" y=\""+PLACE_IT_Y+"\" width=\"120\" height=\"80\" as=\"geometry\"/>";
				  // TEXT1 = "<mxGeometry x=\"180\" y=\"150\" width=\"120\" height=\"80\" as=\"geometry\"/>";
				  myfile << TEXT1 << "\n";



				  TEXT1 = "</mxCell>";
				  myfile << TEXT1 << "\n";



				  TEXT1 = " </UserObject>";
				  myfile << TEXT1 << "\n";

			 // align_NODE_TYPE[node_counter]="INPUT";
			 // myfile << node_counter<< " ";
			 // std::stringstream sstm;
			 // sstm << "INPUT" << " " << "INPUT" << input_counter <<"\n" ;
			 // string result_txt = sstm.str();
			 				 		  //myfile << "INPUT"<<(char)input_counter<<"\n"; input_counter++;
			 // 	  	  	  	  	  	  myfile << result_txt; input_counter++;

		//	 cout <<  TEXT1 << endl;

			  	  	  	node_mapper[node_counter] = xMainNode.getChildNode(0).getChildNode(i).getAttribute("id");
			  	  	  	  	  //myfile <<input_counter;
			  	  	  	node_counter++;


			  	  	  	//cout <<  xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") << endl;
			 }
	}

	if(strcmp(xMainNode.getChildNode(0).getChildNode(i).getName() , "UserObject") ==0 ){

//		cout <<  "USERmxCell";

		// INIT WRITE EACH NODE
				  int PLACE_REAL_X = atoi(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getChildNode(0).getAttribute("width"))*scale_factor;
				  int PLACE_REAL_Y = atoi(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getChildNode(0).getAttribute("width"))*scale_factor*1.5;
				  int SCALED_WIDTH = atoi(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getChildNode(0).getAttribute("width"));
				  int SCALED_HEIGHT = atoi(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getChildNode(0).getAttribute("height"));

				  // WRITE EACH NODE
				  //for (int i = 0; i < gcg_last->NodeCount(); i++){
				  string LABEL_IT = "pLUX"; // collect this from output data, left
				  string DEFINE_IT = "mRNA"; // collect this from output data, right
				  int ID_IT = 0; // collect this from output data, first, ADD +2 to everything, since nodes will start from 2 and forth, DO SAME for edges (connections)

				//   LABEL_IT = gcg_last-> GetNodeAttr(i)->component->name;
				//   DEFINE_IT = Id2Str(gcg_last->GetNodeAttr(i)->component->getType());

				//take from original XML for main

//				cout <<  "USERmxCell1";

				LABEL_IT = xMainNode.getChildNode(0).getChildNode(i).getAttribute("label");
				DEFINE_IT = xMainNode.getChildNode(0).getChildNode(i).getAttribute("link"); ////////// if not input or output, link can hold variants !!!!!!

//				cout <<  "USERmxCell2";
				//take from OUTPUT, match with passed parameter from main, choose proper from group list in OUTPUT

				   ID_IT = node_counter;//i+2

				   std::stringstream ID_IT_X;
				   ID_IT_X << ID_IT ;
				   string ID_IT_X_CHAR = ID_IT_X.str();
				  //TEXT1 = "<UserObject label=\"mRNA\" link=\"0 0 1.3 1.3 0 1.3 0 1.3\" id=\"2\">";

				  string SHAPE_IT = "ellipse"; //shape=step
				//take from original XML for main

				 SHAPE_IT = xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style");
				//take from OUTPUT, match with passed parameter from main, choose proper from group list in OUTPUT

//				cout <<  "USERmxCell3";

				  std::stringstream PLACE_IT_X;
				  PLACE_IT_X << PLACE_REAL_X ;
				  string PLACE_IT_X_CHAR = PLACE_IT_X.str();

				  std::stringstream PLACE_IT_Y;
				  PLACE_IT_Y << PLACE_REAL_Y ;
				  string PLACE_IT_Y_CHAR = PLACE_IT_Y.str();

			//  if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=step") ==0 ){
			  if (
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=step") ==0 & step_i == 0) |
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "rounded=1") ==0 & step_i == 1) |
		//(strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=step") !=0 & strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "rounded=1") !=0 & step_i == 2)
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "triangle") ==0 & step_i == 2) |
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=or") ==0 & step_i == 2) |
		(strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=xor") ==0 & step_i == 2)

		//add the case we have image/known gate etc
//strncmp(str, substr, strlen(substr))
		 | (strncmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "image", strlen("image"))==0 & step_i == 2 )

		){

//cout <<  "USERmxCell4";




				  /////// DECIDE image - all will be images - USE variable SHOW_ME_THE_TYPE, use node_counter variable to do the matching (and not i which corresponds to the initial unordered XML)

				 				  		string IMAGE_MIDDLE_NAME = SHOW_ME_THE_TYPE[node_counter-2];

				 				  		if(strncmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "image", strlen("image"))==0

				 				  			|	(strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "triangle") ==0 ) |
				 				  						(strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=or") ==0 ) |
				 				  						(strcmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "shape=xor") ==0  )

				 				  		){
				 				  		SHAPE_IT = "image;image=stencils/clipart/"+IMAGE_MIDDLE_NAME+"_128x128.png";

				 	//cout << strncmp(xMainNode.getChildNode(0).getChildNode(i).getChildNode(0).getAttribute("style") , "image", strlen("image")) << endl;

				 				  			///// DEFINE VARIANTS
				 				  								LABEL_IT = IMAGE_MIDDLE_NAME;

				 				  						  		DEFINE_IT = "";

				 				  						  		for (int j = 0; j < final_gcg->NodeCount(); j++){
				 				  						  						  			//	if (final_gcg->GetNodeAttr(j)->original_node_id == i) {
				 				  						  			if (final_gcg->GetNodeAttr(j)->original_node_id == node_counter-2) {

				 				  						  				string DEF1 = final_gcg->GetNodeAttr(j)->component->name;

				 				  						  				std::stringstream DEF_X;
				 				  						  				DEF_X << final_gcg->GetNodeAttr(j)->component->variant_id ;
				 				  						  				string DEF_X_CHAR = DEF_X.str();

				 				  						  				string DEF2 = DEF_X_CHAR;//final_gcg->GetNodeAttr(j)->component->variant_id.c_str();

				 				  						  				DEFINE_IT =  DEFINE_IT+" Name:"+DEF1+" Variant:"+ DEF2;

				 				  						  				//cout << DEFINE_IT;
				 				  						  					//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << endl;
				 				  						  					//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << "\t" << final_gcg->GetNodeAttr(j)->component->variant_id << endl;
				 				  						  						  				}
				 				  						  						  			//cout << "--------------------" << endl;
				 				  						  				}
				 				  			///// END DEFINE VARIANTS


				 				  		}


				 TEXT1 = "<UserObject label=\""+ LABEL_IT +"\" link=\""+ DEFINE_IT +"\" id=\""+ID_IT_X_CHAR+"\">";
				 //<UserObject label="mRNA" link="0 0 1.3 1.3 0 1.3 0 1.3" id="2">
				 myfile << TEXT1 << "\n";

				  TEXT1 = "<mxCell style=\""+SHAPE_IT+"\" vertex=\"1\" parent=\"1\">";
				  //<mxCell style="shape=step" vertex="1" parent="1"> // ADD everything as ellipse
				  myfile << TEXT1 << "\n";

				    std::stringstream SCALED_WIDTH_X;
				  SCALED_WIDTH_X << SCALED_WIDTH ;
				  string SCALED_WIDTH_X_CHAR = SCALED_WIDTH_X.str();

				  std::stringstream SCALED_HEIGHT_X;
				  SCALED_HEIGHT_X << SCALED_HEIGHT ;
				  string SCALED_HEIGHT_X_CHAR = SCALED_HEIGHT_X.str();

				  TEXT1 = "<mxGeometry x=\""+PLACE_IT_X_CHAR+"\" y=\""+PLACE_IT_Y_CHAR+"\" width=\""+SCALED_WIDTH_X_CHAR+"\" height=\""+SCALED_HEIGHT_X_CHAR+"\" as=\"geometry\"/>";
				  //TEXT1 = "<mxGeometry x=\""+PLACE_IT_X_CHAR+"\" y=\""+PLACE_IT_Y_CHAR+"\" width=\"120\" height=\"80\" as=\"geometry\"/>";
				  //TEXT1 = "<mxGeometry x=\""+PLACE_IT_X+"\" y=\""+PLACE_IT_Y+"\" width=\"120\" height=\"80\" as=\"geometry\"/>";
				  // TEXT1 = "<mxGeometry x=\"180\" y=\"150\" width=\"120\" height=\"80\" as=\"geometry\"/>";
				  myfile << TEXT1 << "\n";

				  TEXT1 = "</mxCell>";
				  myfile << TEXT1 << "\n";

				  TEXT1 = " </UserObject>";
				  myfile << TEXT1 << "\n";

			 // align_NODE_TYPE[node_counter]="INPUT";
			 // myfile << node_counter<< " ";
			 // std::stringstream sstm;
			 // sstm << "INPUT" << " " << "INPUT" << input_counter <<"\n" ;
			 // string result_txt = sstm.str();
			 				 		  //myfile << "INPUT"<<(char)input_counter<<"\n"; input_counter++;
			 // 	  	  	  	  	  	  myfile << result_txt; input_counter++;
			  	  	  	node_mapper[node_counter] = xMainNode.getChildNode(0).getChildNode(i).getAttribute("id");
			  	  	  	  	  //myfile <<input_counter;
			  	  	  	node_counter++;

			  	  	  	//cout <<  "USERmxCell5";

				 				 		 }


	}
} // END FIRST FOR
} // END 3 times for


//cout <<  " mxCellaaaaaaaaaa EDGES ";

// WRITE EDGES, run for each node
			  int temp_count=0; //count appearances of each node in edges
			  string keep_cource[nodes_counter*4]; // allow 4 edges to each node
			  string keep_target[nodes_counter*4];

			  string keep_style[nodes_counter*4];

			  int edge_counter=2;

			  for (int j = 2; j < nodes_counter+2; j++){
	for (int i = 2; i < xMainNode.getChildNode(0).nElement(); i++){
	if(strcmp(xMainNode.getChildNode(0).getChildNode(i).getName() , "mxCell") ==0 ){

		  if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "triangle") ==0 ){}
		  else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=or") ==0 ){}
		  else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=xor") ==0 ){}
		  else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "shape=step") ==0 ){}
		  else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "rounded=1") ==0 ){}
		  else if (strncmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") , "image", strlen("image"))==0){}
		  else{
			  // DRAW EDGES

	//		  cout <<  node_mapper[j] << endl;

			  //check if node is same from mapping
			  if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getAttribute("source") , node_mapper[j].c_str()) ==0 )
			  {
				  keep_cource[temp_count] = xMainNode.getChildNode(0).getChildNode(i).getAttribute("source") ;
				  keep_target[temp_count] = xMainNode.getChildNode(0).getChildNode(i).getAttribute("target") ;

				  //add style
				  keep_style[temp_count] = xMainNode.getChildNode(0).getChildNode(i).getAttribute("style") ;

				  temp_count++;
			  }
		  }
	   }
	}

	//write for each node
	//myfile << temp_count << "\n";
	//cout << temp_count << endl;
	//int ID_is=0;
	for(int k = 0; k < temp_count; k++){

	//	myfile << j ; //write the source
	//	myfile << " ";

		//find the ID the target got in mapping
		int ID_is=0;
		for(int m = 2; m < nodes_counter+2; m++){
			if (strcmp(node_mapper[m].c_str(), keep_target[k].c_str()) ==0 )
			{
				 ID_is=m;
			}
		}

	//	myfile << ID_is << " " << "PRO" << " " << "UNKNOWN" << "\n";

	//}

																				/// write XML
 						std::stringstream GET_AI;
				  	          //GET_AI << i+2 ;
				  	          GET_AI << j ;
				  	          string GET_AI_CHAR = GET_AI.str();

				  	        std::stringstream GET_KAI;
				  	        //GET_KAI << k+2 ;
				  	        GET_KAI << ID_is ;
				  	        string GET_KAI_CHAR = GET_KAI.str();

				  	      std::stringstream GET_KAID;
				  	      			  	        //GET_KAID << gcg_last->NodeCount() + i+2 ;
				  	      			  	        GET_KAID << nodes_counter+edge_counter ; edge_counter++;
				  	      			  	        string GET_KAID_CHAR = GET_KAID.str();

				  	   //   TEXT1 = "<mxCell id=\""+GET_KAID_CHAR+"\" value=\"\" style=\"edgeStyle=elbowEdgeStyle;elbow=horizontal;exitX=1;exitY=0.5;exitPerimeter=0;entryX=0.175;entryY=0.25;entryPerimeter=0\" edge=\"1\" source=\""+GET_AI_CHAR+"\" target=\""+GET_KAI_CHAR+"\" parent=\"1\">";
				  	   //   myfile << TEXT1 << "\n";

				  	      	//check if repression or activation and put right variable
				  	      string ARROW = ";endArrow=oval";

				  	      //find if statement value
				  	      //int GET_ATTRIB =  attr->type; //use to find repression/activation, in input is just arrow
						int GET_ATTRIB = 0; //use in main

				  	      if(GET_ATTRIB == 0)
				  	      {ARROW = "";}

				  	    if(GET_ATTRIB == 1)
				  	     {ARROW = ";endArrow=oval";}
				  	    if(GET_ATTRIB == 2)
				  	  	{ARROW = ";endArrow=diamond";}

				  	    //check if more similar targets appeared, put lower if so
				  	    float Y_OFFSET = 0.25;
			//	  	    for(int i11=0; i11<count_edges-1; i11++){

			//	  		  if(keep_edge_numbers[i11] == k+2){Y_OFFSET = 0.75;}

				  		//cout << keep_edge_numbers[i11] << ' ' << k+2 << endl;

			//	  	    }
			//	  	   //cout << i << ' ' << k  << ' ' << count_all_edges << endl;

				  	    std::stringstream GET_ATTRIB1;
				  	    //GET_ATTRIB1 << Y_OFFSET;
				  	    GET_ATTRIB1 << Y_OFFSET;

				  	    //cout << i << ' ' << k << ' ' << attr << endl;
				  	    string Y_OFFSET_CHAR = GET_ATTRIB1.str();
				  	    //GET_KAID_CHAR = GET_ATTRIB_CHAR;

				  	    //string Y_OFFSET_CHAR = Y_OFFSET.str();

				  	    string STYLE_ME =keep_style[k];

				  	  //    TEXT1 = "<mxCell id=\""+GET_KAID_CHAR+"\" value=\"\" style=\"edgeStyle=elbowEdgeStyle;elbow=horizontal;exitX=1;exitY=0.5;exitPerimeter=0;entryX=0.175;entryY="+Y_OFFSET_CHAR+ARROW+";entryPerimeter=0\" edge=\"1\" source=\""+GET_AI_CHAR+"\" target=\""+GET_KAI_CHAR+"\" parent=\"1\">";
				  		  TEXT1 = "<mxCell id=\""+GET_KAID_CHAR+"\" value=\"\" style=\""+STYLE_ME+"\" edge=\"1\" source=\""+GET_AI_CHAR+"\" target=\""+GET_KAI_CHAR+"\" parent=\"1\">";

				  		  myfile << TEXT1 << "\n";

				  	      TEXT1 = "<mxGeometry x=\"-200\" y=\"-75\" width=\"100\" height=\"100\" as=\"geometry\">";
				  	      myfile << TEXT1 << "\n";

				  	      TEXT1 = " <mxPoint x=\"-200\" y=\"25\" as=\"sourcePoint\"/>";
				  	      myfile << TEXT1 << "\n";

				  	      TEXT1 = "<mxPoint x=\"-100\" y=\"-75\" as=\"targetPoint\"/>";
				  	  	  myfile << TEXT1 << "\n";

				  	  	  TEXT1 = " </mxGeometry>";
				  	  	  myfile << TEXT1 << "\n";

				  	  	  TEXT1 = "  </mxCell>";
				  	  	  myfile << TEXT1 << "\n";
																				/// END write XML

	}

	//cout << temp_count << endl;
	temp_count=0;
	myfile  << "\n";

	  } // END WRITE EDGES











			  	  // WRITE OUTPUT TEXT

			  	  //<mxCell id="4"

			  //value="
		//	  &lt;p style=&quot;margin:0px;margin-top:6px;text-align:center;&quot;&gt;&lt;b&gt;
		//	  Component&lt;/b&gt;&lt;/p&gt;&lt;hr/&gt;&lt;p style=&quot;margin:0px;margin-left:8px;&quot;&gt;
		//	  + Attribute1: Type&lt;br/&gt;
		//	  + Attribute2: Type&lt;/p&gt;
		//	  &lt;p style=&quot;margin:0px;margin-top:6px;text-align:center;&quot;&gt;&lt;b&gt;
		//	  Component&lt;/b&gt;&lt;/p&gt;&lt;hr/&gt;&lt;p style=&quot;margin:0px;margin-left:8px;&quot;&gt;
		//	  + Attribute1: Type&lt;br/&gt;
		//	  + Attribute2: Type&lt;/p&gt;"

		//	  style="verticalAlign=top;align=left;overflow=fill;html=1" vertex="1" parent="1">
			      //  <mxGeometry x="620" y="120" width="230" height="240" as="geometry"/>
			      //</mxCell>


			  std::stringstream GET_FINAL_KAID;
			  //GET_KAID << gcg_last->NodeCount() + i+2 ;
			  GET_FINAL_KAID << nodes_counter+edge_counter ; //edge_counter++;
			 string GET_FINAL_KAID_CHAR = GET_FINAL_KAID.str();





			  	  std::stringstream ALL_IN_ONE_TEXT;

			  	//ALL_IN_ONE_TEXT << "tttt";

			  	ALL_IN_ONE_TEXT << "<mxCell id=\""+GET_FINAL_KAID_CHAR+"\"" << " value=\"";

				for (int i = 0; i < solution_list1->at(0).first->NodeCount(); i++) {
						//	  			cout << i << "\t" << Id2Str(gcg_tmp->GetNodeAttr(i)->component->getType()) << "\t" << gcg_tmp->GetNodeAttr(i)->component->name << endl;
							  			//SHOW_ME_THE_TYPE[i] =  gcg_tmp->GetNodeAttr(i)->component->name;
						//	  			cout << SHOW_ME_THE_TYPE[i] << "   oooooooooo  " <<endl;

					//////////////////////////// WRITE LINE

					ALL_IN_ONE_TEXT << "&lt;p style=&quot;margin:0px;margin-top:6px;text-align:center;&quot;&gt;&lt;b&gt;" << i << "\t" << Id2Str(gcg_tmp->GetNodeAttr(i)->component->getType()) << "\t" << gcg_tmp->GetNodeAttr(i)->component->name << ";/b&gt;&lt;/p&gt;&lt;hr/&gt;&lt;p style=&quot;margin:0px;margin-left:8px;&quot;&gt;";

					//////////////////////////// END WRITE LINE

							  			for (int j = 0; j < final_gcg->NodeCount(); j++)
							  				if (final_gcg->GetNodeAttr(j)->original_node_id == i) {
						//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << endl;
						//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << "\t" << final_gcg->GetNodeAttr(j)->component->variant_id << endl;

							  				//////////////////////////////// WRITE SUBLINE

							  					ALL_IN_ONE_TEXT << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << "\t" << final_gcg->GetNodeAttr(j)->component->variant_id << "&lt;br/&gt;";

							  				//////////////////////////////// END WRITE SUBLINE


							  				}
						//	  			cout << "--------------------" << endl;
							  		}

				ALL_IN_ONE_TEXT <<  " \" style=\"verticalAlign=top;align=left;overflow=fill;html=1\" vertex=\"1\" parent=\"1\">";
				ALL_IN_ONE_TEXT << "<mxGeometry x=\"1060\" y=\"40\" width=\"330\" height=\"840\" as=\"geometry\"/>";
				ALL_IN_ONE_TEXT << "</mxCell>";

				myfile << ALL_IN_ONE_TEXT.str() << "\n";






					// WRITE END
				  	TEXT1 = "</root>";
				  	myfile << TEXT1 << "\n";
				  	TEXT1 = "</mxGraphModel>";
				  	myfile << TEXT1 << "\n";

				 	myfile <<  "\n";
				 	myfile.close();

		    }





























		    // DYNAMIC WAY


		//cout << gcg_last->NodeCount();


		    /////// NEW CODE - define group placements

		    //// define per group
		    // align_NODE_TYPE[] - the input groups and the type assigned to each input group
		    // int align_GROUP_X[] - the X of upper left corner of group i
		    // int align_GROUP_Y[]- the Y of upper left corner of group i
		    // int align_GROUP_COUNT[] - elements in each group
		    // int align_GROUP_left_covered[] - a counter counting how many gates have taken the left place in the group, if more than one you need a Y extra placement
		    // int align_GROUP_right_covered[] - see above
		    // int align_GROUP_middle_covered[] - see above

		    // STEP 1 - define group placement, by looking at input graph and scale of new required graph

		    // STEP 2 - start making graph, by putting groups and under group gates first for each group that has elements > 1
		    			// remember to increase the ID that will go into the XML accordingly (the +2 becomes +2+groups_with_more_then_one_member_number

		    // STEP 3 - define everything else in relation to group placements and by looking at adjustent block connections

		ofstream myfile1 ("Database/OUT_XML.xml");
			  if (myfile1.is_open())
			  {

				  // WRITE HEADER
				  string TEXT1 = "<mxGraphModel grid=\"1\" guides=\"1\" tooltips=\"1\" connect=\"1\" fold=\"1\" page=\"0\" pageScale=\"1\" pageWidth=\"826\" pageHeight=\"1169\">";
				  myfile1 << TEXT1 << "\n";
				  TEXT1 = "<root>";
				  myfile1 << TEXT1 << "\n";
				  TEXT1 = "<mxCell id=\"0\"/>";
				  myfile1 << TEXT1 << "\n";
				  TEXT1 = "<mxCell id=\"1\" parent=\"0\"/>";
				  myfile1 << TEXT1 << "\n";


				  // write groups, find how many first

				 // <mxCell id="4" value="" style="group" vertex="1" connectable="0" parent="1">
				 //      <mxGeometry x="270" y="220" width="90" height="250" as="geometry"/>
				 //    </mxCell>

				  int GROUP_COUNT=0;
				  int MATCH_ME[final_gcg->NodeCount()];

					for (int i = 0; i < solution_list1->at(0).first->NodeCount(); i++)
					{
		//						  			cout << i << "\t" << Id2Str(gcg_tmp->GetNodeAttr(i)->component->getType()) << "\t" << gcg_tmp->GetNodeAttr(i)->component->name << endl;
								  			//SHOW_ME_THE_TYPE[i] =  gcg_tmp->GetNodeAttr(i)->component->name;
								  			//cout << SHOW_ME_THE_TYPE[i] << "   oooooooooo  " <<endl;
								  			int INNER_COUNT =0;
								  			for (int j = 0; j < final_gcg->NodeCount(); j++){
								  				if (final_gcg->GetNodeAttr(j)->original_node_id == i) {
							//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << endl;
							//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << "\t" << final_gcg->GetNodeAttr(j)->component->variant_id << endl;
								  					INNER_COUNT++;

								  			//		if(INNER_COUNT ==1){
								  			//		MATCH_ME[j]=1;
								  			//		}else{MATCH_ME[j]=GROUP_COUNT+2;}

								  				}//else{MATCH_ME[j]=1;}
								  			}

								  			if(INNER_COUNT > 1){	//dont make GROUPS for items with one element

								  				MATCH_ME[i]=GROUP_COUNT+2;

								  				std::stringstream ID_GROUP;
								  				ID_GROUP << GROUP_COUNT+2 ;
								  				string ID_GROUP_CHAR = ID_GROUP.str();

								  				string GROUP_NAME = gcg_tmp->GetNodeAttr(i)->component->name;

								  				//OUTPUT GROUP
								  				TEXT1 = "<mxCell id=\""+ID_GROUP_CHAR+"\" value=\""+GROUP_NAME+"\" style=\"group\" vertex=\"1\" connectable=\"0\" parent=\"1\">";
								  				myfile1 << TEXT1 << "\n";
								  				TEXT1 =  "<mxGeometry x=\"270\" y=\"220\" width=\"90\" height=\"250\" as=\"geometry\"/>";
								  				myfile1 << TEXT1 << "\n";
								  				TEXT1 = "</mxCell>";
								  				myfile1 << TEXT1 << "\n";

								  				GROUP_COUNT++;

								  			}else{MATCH_ME[i]=1;}


								  			//cout << "--------------------" << endl;
					}

				  // END GROUPS


				  // INIT WRITE EACH NODE
				  int PLACE_REAL_X = 50;
				  int PLACE_REAL_Y = 50;
				  // WRITE EACH NODE
				  for (int i = 0; i < final_gcg->NodeCount(); i++){
				  string LABEL_IT = "pLUX"; // collect this from output data, left
				  string DEFINE_IT = "mRNA"; // collect this from output data, right
				  int ID_IT = 0; // collect this from output data, first, ADD +2 to everything, since nodes will start from 2 and forth, DO SAME for edges (connections)

				   LABEL_IT = final_gcg-> GetNodeAttr(i)->component->name;
				   //DEFINE_IT = gcg_last-> GetNodeAttr(i)->component->getStringType();
				   //DEFINE_IT = gcg_last-> GetNodeAttr(i)->component->getType();
				   //DEFINE_IT = gcg_last-> GetNodeAttr(i)->component->getCategory();
				   DEFINE_IT = Id2Str(final_gcg->GetNodeAttr(i)->component->getType());

				   //ID_IT = i+2;
				   ID_IT = i+GROUP_COUNT+2;
				   // gcg_last-> GetNodeAttr(i)->component->name << gcg_last-> GetNodeAttr(i)->component->getStringType() << endl;

				   std::stringstream ID_IT_X;
				   ID_IT_X << ID_IT ;
				   string ID_IT_X_CHAR = ID_IT_X.str();
				  //TEXT1 = "<UserObject label=\"mRNA\" link=\"0 0 1.3 1.3 0 1.3 0 1.3\" id=\"2\">";
				  TEXT1 = "<UserObject label=\""+ LABEL_IT +"\" link=\""+ DEFINE_IT +"\" id=\""+ID_IT_X_CHAR+"\">";
				  //<UserObject label="mRNA" link="0 0 1.3 1.3 0 1.3 0 1.3" id="2">
				  myfile1 << TEXT1 << "\n";

				  string SHAPE_IT = "ellipse"; //shape=step

				  //choose shape based on part
				  if (DEFINE_IT == "mRNA"){SHAPE_IT = "";}/////
				  if (DEFINE_IT == "Ligand"){SHAPE_IT = "shape=hexagon";}
				  if (DEFINE_IT == "LIGAND"){SHAPE_IT = "shape=hexagon";}
				  if (DEFINE_IT == "RNAComplex"){SHAPE_IT = "shape=rhombus";}
				  if (DEFINE_IT == "RNA_COMPLEX"){SHAPE_IT = "shape=rhombus";}
				  if (DEFINE_IT == "Protein"){SHAPE_IT = "ellipse";} //////
				  if (DEFINE_IT == "PROTEIN"){SHAPE_IT = "ellipse";} //////
				  if (DEFINE_IT == "ProteinComplex"){SHAPE_IT = "shape=actor";}
				  if (DEFINE_IT == "PROTEIN_COMPLEX"){SHAPE_IT = "shape=actor";}
				  if (DEFINE_IT == "LigandProteinComplex"){SHAPE_IT = "shape=actor";}/////////
				  if (DEFINE_IT == "LIGAND_PROTEIN_COMPLEX"){SHAPE_IT = "shape=actor";}/////////
				  if (DEFINE_IT == "POOL"){SHAPE_IT = "shape=cylinder";}
				  if (DEFINE_IT == "ADAPTER"){SHAPE_IT = "shape=tape";}
				  if (DEFINE_IT == "SENSOR"){SHAPE_IT = "ellipse;shape=cloud";}
				  if (DEFINE_IT == "BUFFER"){SHAPE_IT = "shape=plus";}
				  if (DEFINE_IT == "INPUT"){SHAPE_IT = "shape=step";}/////////
				  if (DEFINE_IT == "OUTPUT"){SHAPE_IT = "rounded=1";}///////
				  if (DEFINE_IT == "NOT_GATE"){SHAPE_IT = "triangle";}////////
				  if (DEFINE_IT == "NOT_GATE_COMPLETE"){SHAPE_IT = "triangle";}
				  if (DEFINE_IT == "OR_GATE"){SHAPE_IT = "shape=xor";}////////
				  if (DEFINE_IT == "AND_GATE"){SHAPE_IT = "shape=or";}//////////
				  if (DEFINE_IT == "AND_GATE_COMPLETE"){SHAPE_IT = "shape=or";}



				std::stringstream IDs_GROUP;

				//int INNER_COUNT =0;
				//								  			for (int j = 0; j < final_gcg->NodeCount(); j++){
				//								  				if (final_gcg->GetNodeAttr(j)->original_node_id == i) {
											//	  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << endl;
				//								  					cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << "\t" << final_gcg->GetNodeAttr(j)->component->variant_id << endl;
				//								  					INNER_COUNT++;
				//								  				}
				//								  			}

				//								  			if(INNER_COUNT > 1){

				//IDs_GROUP << final_gcg->GetNodeAttr(i)->original_node_id+2 ;
				//								  			}else {IDs_GROUP << 1;}

				//IDs_GROUP << MATCH_ME[i];

				IDs_GROUP << MATCH_ME[final_gcg->GetNodeAttr(i)->original_node_id];

				string IDs_GROUP_CHAR = IDs_GROUP.str();

				 TEXT1 = "<mxCell style=\""+SHAPE_IT+"\" vertex=\"1\" parent=\""+IDs_GROUP_CHAR+"\">";

				 // TEXT1 = "<mxCell style=\""+SHAPE_IT+"\" vertex=\"1\" parent=\"1\">";
				  //<mxCell style="shape=step" vertex="1" parent="1"> // ADD everything as ellipse
				  myfile1 << TEXT1 << "\n";

				  //string PLACE_IT_X="";
				  //string PLACE_IT_Y="";

				  // PLACE_IT_X << PLACE_REAL_X;
				  // PLACE_IT_Y << PLACE_REAL_Y;

				  PLACE_REAL_X = PLACE_REAL_X +60;
				  PLACE_REAL_Y = PLACE_REAL_Y +60;

				  std::stringstream PLACE_IT_X;
				  PLACE_IT_X << PLACE_REAL_X ;
				  string PLACE_IT_X_CHAR = PLACE_IT_X.str();

				  std::stringstream PLACE_IT_Y;
				  PLACE_IT_Y << PLACE_REAL_Y ;
				  string PLACE_IT_Y_CHAR = PLACE_IT_Y.str();

				  TEXT1 = "<mxGeometry x=\""+PLACE_IT_X_CHAR+"\" y=\""+PLACE_IT_Y_CHAR+"\" width=\"120\" height=\"80\" as=\"geometry\"/>";
				  //TEXT1 = "<mxGeometry x=\""+PLACE_IT_X+"\" y=\""+PLACE_IT_Y+"\" width=\"120\" height=\"80\" as=\"geometry\"/>";
				  // TEXT1 = "<mxGeometry x=\"180\" y=\"150\" width=\"120\" height=\"80\" as=\"geometry\"/>";
				  myfile1 << TEXT1 << "\n";

				  TEXT1 = "</mxCell>";
				  myfile1 << TEXT1 << "\n";

				  TEXT1 = " </UserObject>";
				  myfile1 << TEXT1 << "\n";

				  }

				  //WRITE EDGES, ID in xml must be a number above node count !!!!

				  int j;
				  int count_all_edges =0;
				  			  	    for(int i=0; i<final_gcg->NodeCount(); i++)
				  			  	      { //out << g.OutEdgeCount(i) << endl; // linh
				  			  	        for(j=0; j<final_gcg->OutEdgeCount(i); j++)
				  			  	          {count_all_edges++;}
				  			  	      }

				  int keep_edge_numbers[count_all_edges]; // keep target numbers that have appeared at each point
				  int count_edges=0; //dont reuse counter

				  //int j;
				  	    for(int i=0; i<final_gcg->NodeCount(); i++)
				  	      { //out << g.OutEdgeCount(i) << endl; // linh
				  	        for(j=0; j<final_gcg->OutEdgeCount(i); j++)
				  	          { int k;
				  	            BioNetEdge *attr;
				  	            k=final_gcg->GetOutEdge(i, j, &attr);
				  	           // cout << i << ' ' << k << ' ' << *attr << endl;
				  	           // cout << i << ' ' << k << ' '  << endl;

				  	          keep_edge_numbers[count_edges] = k+2+GROUP_COUNT; count_edges++;

				  	          std::stringstream GET_AI;
				  	          GET_AI << i+2+GROUP_COUNT ;
				  	          string GET_AI_CHAR = GET_AI.str();

				  	        std::stringstream GET_KAI;
				  	        GET_KAI << k+2+GROUP_COUNT ;
				  	        string GET_KAI_CHAR = GET_KAI.str();

				  	      std::stringstream GET_KAID;
				  	      			  	        GET_KAID << final_gcg->NodeCount() + i+2+GROUP_COUNT ;
				  	      			  	        string GET_KAID_CHAR = GET_KAID.str();

				  	   //   TEXT1 = "<mxCell id=\""+GET_KAID_CHAR+"\" value=\"\" style=\"edgeStyle=elbowEdgeStyle;elbow=horizontal;exitX=1;exitY=0.5;exitPerimeter=0;entryX=0.175;entryY=0.25;entryPerimeter=0\" edge=\"1\" source=\""+GET_AI_CHAR+"\" target=\""+GET_KAI_CHAR+"\" parent=\"1\">";
				  	   //   myfile << TEXT1 << "\n";

				  	      	//check if repression or activation and put right variable
				  	      string ARROW = ";endArrow=oval";

				  	      //find if statement value
				  	      int GET_ATTRIB =  attr->type;

				  	      if(GET_ATTRIB == 0)
				  	      {ARROW = "";}

				  	    if(GET_ATTRIB == 1)
				  	     {ARROW = ";endArrow=oval";}
				  	    if(GET_ATTRIB == 2)
				  	  	{ARROW = ";endArrow=diamond";}

				  	    //check if more similar targets appeared, put lower if so
				  	    float Y_OFFSET = 0.25;
				  	    for(int i11=0; i11<count_edges-1; i11++){

				  		  if(keep_edge_numbers[i11] == k+2+GROUP_COUNT){Y_OFFSET = 0.75;}

				  		//cout << keep_edge_numbers[i11] << ' ' << k+2 << endl;

				  	    }
				  	   //cout << i << ' ' << k  << ' ' << count_all_edges << endl;

				  	    std::stringstream GET_ATTRIB1;
				  	    GET_ATTRIB1 << Y_OFFSET;
				  	    //cout << i << ' ' << k << ' ' << attr << endl;
				  	    string Y_OFFSET_CHAR = GET_ATTRIB1.str();
				  	    //GET_KAID_CHAR = GET_ATTRIB_CHAR;

				  	    //string Y_OFFSET_CHAR = Y_OFFSET.str();

				  	      TEXT1 = "<mxCell id=\""+GET_KAID_CHAR+"\" value=\"\" style=\"edgeStyle=elbowEdgeStyle;elbow=horizontal;exitX=1;exitY=0.5;exitPerimeter=0;entryX=0.175;entryY="+Y_OFFSET_CHAR+ARROW+";entryPerimeter=0\" edge=\"1\" source=\""+GET_AI_CHAR+"\" target=\""+GET_KAI_CHAR+"\" parent=\"1\">";
				  		  myfile1 << TEXT1 << "\n";

				  	      TEXT1 = "<mxGeometry x=\"-200\" y=\"-75\" width=\"100\" height=\"100\" as=\"geometry\">";
				  	      myfile1 << TEXT1 << "\n";

				  	      TEXT1 = " <mxPoint x=\"-200\" y=\"25\" as=\"sourcePoint\"/>";
				  	      myfile1 << TEXT1 << "\n";

				  	      TEXT1 = "<mxPoint x=\"-100\" y=\"-75\" as=\"targetPoint\"/>";
				  	  	  myfile1 << TEXT1 << "\n";

				  	  	  TEXT1 = " </mxGeometry>";
				  	  	  myfile1 << TEXT1 << "\n";

				  	  	  TEXT1 = "  </mxCell>";
				  	  	  myfile1 << TEXT1 << "\n";

				  	      //    <mxCell id="7" value="" style="edgeStyle=elbowEdgeStyle;elbow=horizontal;exitX=1;exitY=0.5;exitPerimeter=0;entryX=0.175;entryY=0.25;entryPerimeter=0" edge="1" source="3" target="4" parent="1">
				  	      //          <mxGeometry x="-200" y="-75" width="100" height="100" as="geometry">
				  	      //            <mxPoint x="-200" y="25" as="sourcePoint"/>
				  	      ///            <mxPoint x="-100" y="-75" as="targetPoint"/>
				  	      ///          </mxGeometry>
				  	      //        </mxCell>


	///////////////////////////////////////////////////////////////
				  	          }
				  	}

				    // WRITE END
				  	TEXT1 = "</root>";
				  	myfile1 << TEXT1 << "\n";
				  	TEXT1 = "</mxGraphModel>";
				  	myfile1 << TEXT1 << "\n";



				 		  myfile1 <<  "\n";
				 		 myfile1.close();
			  }
		//	END EXPORT XML

	// DISPLAY XML

			  XMLNode xMainNodeOUT=XMLNode::openFileHelper("Database/OUT_XML.xml");

			  	char *t1=xMainNodeOUT.createXMLString(true);
		//	  			  printf("%s\n",t1);



			  	XMLNode xMainNodeOUT2=XMLNode::openFileHelper("Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");

			  				  	char *t22=xMainNodeOUT2.createXMLString(true);
			  				  			  printf("%s\n",t22);



			  	// END DISPLAY XML


		//	cout <<  	gcg_last->NodeCount() << endl;
		//	cout <<  	final_gcg->NodeCount() << endl;


		//delete module_list;
		//cout << "Total number of possible derivations: " << count << endl;
		//end = clock();
		//addRunningTime(((double)(end - begin))/CLOCKS_PER_SEC);
		//return true;

			  	//cout << solution_list[0][0].second << endl;

	////////////////////////////////////////////////////////////////
	//////////////////// END NASOS ////////////////////////////////
	////////////////////////////////////////////////////////////////






	return solution_list;
}

vector<Molecule*>* SrcComponent2Molecule(GeneCircuitComponent *component, PartDatabase* partDB) {
	vector<Molecule*>* tmp = new vector<Molecule*>;
	if (component->getCategory() == MOLECULE)
		tmp->push_back((Molecule*) component->clone());
	else {
		Module* module_tmp = partDB->loadContent(Id2Str(component->getType()),component->name);
		for (unsigned int i = 0; i < module_tmp->inputs.size(); i++) {
			vector<Molecule*>* molecule_list_tmp  = SrcComponent2Molecule(module_tmp->GetNodeAttr(module_tmp->inputs[i])->component, partDB);
			for (unsigned int j = 0; j < molecule_list_tmp->size(); j++)
				tmp->push_back((Molecule*)molecule_list_tmp->at(j)->clone());
			delete molecule_list_tmp;
		}
		delete module_tmp;
	}
	return tmp;
}

Molecule* DestComponent2Molecule(GeneCircuitComponent *component, PartDatabase* partDB) {
	if (component->getCategory() == MOLECULE)
		return ((Molecule*) component->clone());
	else {
		Module* module_tmp = partDB->loadContent(Id2Str(component->getType()),component->name);
		GeneCircuitComponent* component_tmp = DestComponent2Molecule(module_tmp->GetNodeAttr(module_tmp->outputs[0])->component, partDB)->clone();
		delete module_tmp;
		return ((Molecule*)component_tmp);
	}
}

int Find_Regulation(GeneCircuitComponent* src, GeneCircuitComponent* dest, PartDatabase *partDB) {
	int regulation_type = UNKNOWN;
	if (src->name.length() > 0 && dest->name.length() > 0) {
		Molecule* src_mol = DestComponent2Molecule(src, partDB);
		vector<Molecule*>* dest_mol_list = SrcComponent2Molecule(dest, partDB);
		for (unsigned int i = 0; i < dest_mol_list->size(); i++) {
			int t = partDB->getRegulationType(src_mol, dest_mol_list->at(i));
			if (t != NONE) {
				regulation_type = t;
				break;
			}
		}
		if (regulation_type == UNKNOWN)
			regulation_type = NONE;
		for (unsigned int i = 0; i < dest_mol_list->size(); i++)
			delete dest_mol_list->at(i);
		delete dest_mol_list;
	}
	return regulation_type;
}

bool Check_Update(GeneCircuitGraph *gcg, int src_node_id, int dest_node_id, PartDatabase* partDB) {
	GeneCircuitComponent *src = gcg->GetNodeAttr(src_node_id)->component;
	GeneCircuitComponent *dest = gcg->GetNodeAttr(dest_node_id)->component;
	if (src->name.length() > 0 && dest->name.length() > 0) {
		Molecule* src_mol = DestComponent2Molecule(src, partDB);
		vector<Molecule*>* dest_mol_list = SrcComponent2Molecule(dest, partDB);
		bool compatible = false;
		for (unsigned int i = 0; i < dest_mol_list->size(); i++) {
			int type_1 = partDB->getRegulationType(src_mol, dest_mol_list->at(i));
			int type_2 = gcg->GetEdgeAttr(src_node_id, dest_node_id)->type;
			// TEST HERE
			//cout << src_mol->name << " " << type_1 << " " << dest_mol_list->at(i)->name
			//	<< "\t" << src_node_id << " " << type_2 << " " << dest_node_id << endl;
			if ((type_1 == type_2) || (type_1 != NONE && type_2 == UNKNOWN)) {
				compatible = true;
				break;
			}
		}
		delete dest_mol_list;
		return compatible;
	}
	// TODO: update src_mol and dest_mol
	return true;
}

GeneCircuitGraph* Layout(GeneCircuitGraph *gcg, PartDatabase* partDB) {
	GeneCircuitGraph *current_gcg = gcg->clone();
	bool continue_extending;
	do {
		continue_extending = false;
		for (int node_id = 0; node_id < current_gcg->NodeCount(); node_id++)
			if (current_gcg->GetNodeAttr(node_id)->component->getCategory() != MOLECULE) {
				Module *module_tmp = partDB->loadContent(Id2Str(current_gcg->GetNodeAttr(node_id)->component->getType()), current_gcg->GetNodeAttr(node_id)->component->name);
				GeneCircuitGraph *gcg_tmp = GeneCircuitGraphExtension(current_gcg, node_id, module_tmp, partDB);
				delete current_gcg;
				current_gcg = gcg_tmp;
				continue_extending = true;
				break;
			}
		// TEST HERE
		//cout << "***************************";
		//current_gcg->TestPrint(&std::cout);
	} while (continue_extending);
	// Update the edges that are created during the expansion step
	for (int src_id = 0; src_id < current_gcg->NodeCount(); src_id++)
		for (int dest_id = 0; dest_id < current_gcg->NodeCount(); dest_id++)
			if (src_id != dest_id) {
				BioNetEdge *bn_e = current_gcg->GetEdgeAttr(src_id, dest_id);
				if (bn_e != NULL && bn_e->type == UNKNOWN)
					bn_e->type = Find_Regulation(current_gcg->GetNodeAttr(src_id)->component, current_gcg->GetNodeAttr(dest_id)->component, partDB);
			}
	return current_gcg;
}

GeneCircuitGraph* GeneCircuitGraphExtension(GeneCircuitGraph* gcg, int sub_node_id, Module* module, PartDatabase *partDB) {
	// TEST HERE
	//module->TestPrint(&std::cout);
	ARGEdit *editor_tmp = new ARGEdit;
	map<int,int> circuit_to_extension;
	// Add nodes
	for (int i = 0; i < gcg->NodeCount(); i++)
		if (i != sub_node_id)
			circuit_to_extension[i] = editor_tmp->InsertNode(gcg->GetNodeAttr(i)->clone());
	// Add edges
	for (int i = 0; i < gcg->NodeCount(); i++)
		for (int j = 0; j < gcg->NodeCount(); j++)
			if (i != sub_node_id && j != sub_node_id && i != j && gcg->GetEdgeAttr(i,j) != NULL)
				editor_tmp->InsertEdge(circuit_to_extension[i], circuit_to_extension[j], gcg->GetEdgeAttr(i,j)->clone());
	map<int,int> module_to_extension;
	// Add nodes
	for (int i = 0; i < module->NodeCount(); i++) {
		BioNetNode *bn_node_tmp = module->GetNodeAttr(i)->clone();
		bn_node_tmp->original_node_id = gcg->GetNodeAttr(sub_node_id)->original_node_id;
		module_to_extension[i] = editor_tmp->InsertNode(bn_node_tmp);
	}
	// Add edges
	for (int i = 0; i < module->NodeCount(); i++)
		for (int j = 0; j < module->NodeCount(); j++)
			if (i != j && module->GetEdgeAttr(i,j) != NULL)
				editor_tmp->InsertEdge(module_to_extension[i], module_to_extension[j], module->GetEdgeAttr(i,j)->clone());
	// TODO: permute inputs and fix for the multiple output case
	// Add connections to the output
	int adj_to_output_node_id = gcg->GetOutEdge(sub_node_id, 0);
	editor_tmp->InsertEdge(module_to_extension[module->outputs[0]], circuit_to_extension[adj_to_output_node_id], gcg->GetEdgeAttr(sub_node_id, adj_to_output_node_id)->clone());
	// Add connections to the inputs
	int number_of_inputs = gcg->InEdgeCount(sub_node_id);
	if (number_of_inputs == 1) {
		int adj_to_input_node_id = gcg->GetInEdge(sub_node_id, 0);
		editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id], module_to_extension[module->inputs[0]], gcg->GetEdgeAttr(adj_to_input_node_id, sub_node_id)->clone());
	}
	else if (number_of_inputs == 2) {
		int adj_to_input_node_id_0 = gcg->GetInEdge(sub_node_id, 0);
		int adj_to_input_node_id_1 = gcg->GetInEdge(sub_node_id, 1);
		if (Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[0])->component, partDB) != NONE) {
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], module_to_extension[module->inputs[0]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[0])->component, partDB)));
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], module_to_extension[module->inputs[1]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_1)->component, module->GetNodeAttr(module->inputs[1])->component, partDB)));
		}
		else {
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], module_to_extension[module->inputs[1]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[1])->component, partDB)));
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], module_to_extension[module->inputs[0]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_1)->component, module->GetNodeAttr(module->inputs[0])->component, partDB)));
		}
	}
	else
		cout << "WE HAVE NOT PROCESSED YET FOR MODULES THAT HAVE MORE THAN TWO INPUTS " << endl;
	return new GeneCircuitGraph(editor_tmp);
}

void Framework::Scalability(int number_of_gates, int number_of_inputs, int number_of_DB_replicates, int module_library_size, int number_of_solutions) {
	bool finish;
	//clock_t begin, end;
	do {
		finish = false;
		//begin = clock();
		// Randomize topology
		dp.gcg = *(GenerateGateNetwork(number_of_gates, number_of_inputs, true));
		dp.gcg.TestPrint(&std::cout);
		break;
		ResetRunningTime();
		//finish = TopologyMatch(number_of_solutions, module_library_size, number_of_DB_replicates);
		//end = clock();
	}
	while (!finish);
	cout << getRunningTime() << "\t";
}

void Framework::Optimize() {
	vector<std::pair<GeneCircuitGraph*, GeneCircuitGraph*> >* solution_list = ModuleMatch(1,0);
	ARGLoader* loader = solution_list->at(0).second->ConvertToLoader();
	IdList inputs, outputs;
	for (int i = 0; i < dp.gcg.NodeCount(); i++) {
		if (dp.gcg.InEdgeCount(i) == 0)
			for (int j = 0; j < loader->NodeCount(); j++)
				if (((BioNetNode*)loader->GetNodeAttr(j))->original_node_id == i) {
					inputs.push_back(j);
					break;
				}
		if (dp.gcg.OutEdgeCount(i) == 0)
			for (int j = 0; j < loader->NodeCount(); j++)
				if (((BioNetNode*)loader->GetNodeAttr(j))->original_node_id == i) {
					outputs.push_back(j);
					break;
				}
	}

	// Build the static circuit
	Module* final_gcg = new Module(loader, inputs, outputs);
	// TEST HERE
	//	final_gcg->TestPrint(&std::cout);
	// delete solution_list;


	// Build the dynamic circuit
	DynamicGeneCircuit dgc(final_gcg);
	//delete final_gcg;
	// TEST HERE
	// dgc.PrintOut(&std::cout);

	double t0, t1;

	// Exhaustive search
	cout << "\nExhaustive search" << endl;
	//t0 = clock();
	//dgc.ExhaustiveSearch(partDB, dp.inputs, dp.outputs);
	//t1 = clock();
	//cout << "Time: " << (t1 - t0)/(double)CLOCKS_PER_SEC << endl;


	// GA search
	cout << "GA search" << endl;
	for (int i = 0; i < 1; i++) {
		t0 = clock();
		dgc.GASearch(partDB, dp.inputs, dp.outputs);
		t1 = clock();
		cout << "Time: " << (t1 - t0)/(double)CLOCKS_PER_SEC << endl;
	}
	for (unsigned int i = 0; i < dgc.root_component->sub_component_list.size();i++)
		final_gcg->GetNodeAttr(i)->component->variant_id = dgc.root_component->sub_component_list[i]->variant_id;
	//final_gcg->TestPrint(&std::cout);
	//dgc.SimulateSteadyState(partDB,dp.inputs,dp.outputs);
	//dp.TestPrint(&std::cout);*/
	GeneCircuitGraph *gcg_tmp = solution_list->at(0).first;
	for (int i = 0; i < solution_list->at(0).first->NodeCount(); i++) {
		cout << i << "\t" << Id2Str(gcg_tmp->GetNodeAttr(i)->component->getType()) << "\t" << gcg_tmp->GetNodeAttr(i)->component->name << endl;
		for (int j = 0; j < final_gcg->NodeCount(); j++)
			if (final_gcg->GetNodeAttr(j)->original_node_id == i) {
				cout << "\t" << j << "\t" << Id2Str(final_gcg->GetNodeAttr(j)->component->getType()) << "\t" << final_gcg->GetNodeAttr(j)->component->name << endl;
			}
		cout << "--------------------" << endl;
	}
	delete solution_list->at(0).first;
	delete solution_list->at(0).second;
	delete solution_list;
}

bool all_visitor(int n, node_id* small_graph_node_list, node_id* large_graph_node_list, void* all_graph_isomorphism) {
	GraphIsomorphism graph_isomorphism;
	graph_isomorphism.reserve(n);
	for (int i = 0; i < n; i++){
		NodePair node_pair_tmp(small_graph_node_list[i],large_graph_node_list[i]);
		graph_isomorphism.push_back(node_pair_tmp);
	}
	((vector<GraphIsomorphism>*) all_graph_isomorphism)->push_back(graph_isomorphism);
	return false;
}
