/*
 * PartDatabase.cpp
 *
 *  Created on: Aug 8, 2012
 *      Author: linh
 */

#include <iostream>
#include <map>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "PartDatabase.h"

static int callback_count(void *NotUsed, int argc, char **argv, char **azColName){
	(*(int*)NotUsed) = atoi(argv[0]);
	return 0;
}
static int callback_string(void *NotUsed, int argc, char **argv, char **azColName){
	vector<string> tmp(argc);
	for (int i = 0; i < argc; i++) {
		string str_tmp(argv[i]);
		tmp[i] = str_tmp;
	}
	((StringMatrix*)NotUsed)->push_back(tmp);
	return 0;
}
PartDatabase::PartDatabase() {
	db = NULL;
}

PartDatabase::PartDatabase(std::string db_filename) {
	int rc = sqlite3_open(db_filename.c_str(), &db);
	if (rc) {
		std::cout << "Can't open database: " << sqlite3_errmsg(db) << std::endl;
		sqlite3_close(db);
	}
}

PartDatabase::~PartDatabase() {
	sqlite3_close(db);
}

int PartDatabase::getNumberOfProteins() const {
	return number_of_proteins;
}

double PartDatabase::getDegradationRate(string protein_name) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT degradation_rate FROM Protein";
	qri.query += " WHERE name = '" + protein_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (qri.string_matrix.empty())
		cout << "There is no protein " << protein_name << endl;
	return atof(qri.string_matrix[0][0].c_str());
}

int PartDatabase::getNumberOfMutants(string promoter_name) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT COUNT(*) FROM Promoter_Mutant";
	qri.query += " WHERE promoter_name = '" + promoter_name + "'";
	int count_tmp;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_count, &count_tmp, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	return count_tmp;
}

double PartDatabase::getPromoterBasal(string promoter_name, int mutant_index) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT basal FROM Promoter_Mutant";
	qri.query += " WHERE promoter_name = '" + promoter_name + "' AND mutant_id = " + Num2Str(mutant_index);
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (qri.string_matrix.empty())
		cout << "There is no mutant of " << promoter_name << " with mutant index is " << mutant_index << endl;
	return atof(qri.string_matrix[0][0].c_str());
}
double PartDatabase::getPromoterStrength(string promoter_name, int mutant_index) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT strength FROM Promoter_Mutant";
	qri.query += " WHERE promoter_name = '" + promoter_name + "' AND mutant_id = " + Num2Str(mutant_index);
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (qri.string_matrix.empty())
		cout << "There is no mutant of " << promoter_name << " with mutant index is " << mutant_index << endl;
	return atof(qri.string_matrix[0][0].c_str());
}
TranscriptionRegulation PartDatabase::getPromoterRegulation(string regulator_name, string promoter_name) const {
	TranscriptionRegulation tr;
	QueryResultInfo qri = Init();
	qri.query = "SELECT beta,eta,type FROM Transcription_Regulation";
	qri.query += " WHERE regulator_name = '" + regulator_name + "' AND promoter_name = '" + promoter_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (qri.string_matrix.empty())
		cout << "There is no interaction between " << regulator_name << " and " << promoter_name << endl;
	tr.binding_affinity = atof(qri.string_matrix[0][0].c_str());
	tr.cooperativity = atof(qri.string_matrix[0][1].c_str());
	tr.regulator_type = (qri.string_matrix[0][2].compare("ACT") == STR_EQ) ? ACTIVATORY : INHIBITORY;
	return tr;
}
LigandRegulation PartDatabase::getLigandRegulation(string ligand_name, string protein_name) const {
	LigandRegulation lr;
	QueryResultInfo qri = Init();
	qri.query = "SELECT theta,eta FROM Ligand_Protein_Interaction";
	qri.query += " WHERE ligand_name = '" + ligand_name + "' AND protein_name = '" + protein_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	lr.dissociation = atof(qri.string_matrix[0][0].c_str());
	lr.cooperativity = atof(qri.string_matrix[0][1].c_str());
	return lr;
}

vector<Module*>* PartDatabase::loadModuleLibrary() {
	StringMatrix module_name_list;
	QueryResultInfo qri = Init();
	qri.query = "SELECT DISTINCT priority FROM Module_Node";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_name_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	vector<Module*>* module_list = new vector<Module*>(module_name_list.size());

	for (unsigned int priority_id = 0; priority_id < module_list->size(); priority_id++) {
		ARGEdit* module_editor = new ARGEdit;
		// Read nodes
		StringMatrix module_node_list;
		Reset(qri);
		qri.query = "SELECT node_id,node_type,node_name,module_name FROM Module_Node";
		qri.query += " WHERE priority = '" + Num2Str(priority_id + 1) + "'";
		qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_node_list, &qri.zErrMsg);
		if(qri.rc != SQLITE_OK) {
			cout << qri.query << endl;
			std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
			sqlite3_free(qri.zErrMsg);
		}
		std::map<string, int> node_id_to_bionode_id;
		for (unsigned int node_id = 0; node_id < module_node_list.size(); node_id++) {
			int id_tmp = module_editor->InsertNode(CreateBioNetNode(module_node_list[node_id][1], module_node_list[node_id][2]));
			node_id_to_bionode_id[module_node_list[node_id][0]] = id_tmp;
		}
		// Read edges
		StringMatrix module_edge_list;
		Reset(qri);
		qri.query = "SELECT src_id, dest_id, edge_type FROM Module_Edge";
		qri.query += " WHERE module_name = '" + module_node_list[0][3] + "'";
		qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_edge_list, &qri.zErrMsg);
		if(qri.rc != SQLITE_OK) {
			cout << qri.query << endl;
			std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
			sqlite3_free(qri.zErrMsg);
		}
		for (unsigned int edge_id = 0; edge_id < module_edge_list.size(); edge_id++)
			module_editor->InsertEdge(node_id_to_bionode_id[module_edge_list[edge_id][0]],node_id_to_bionode_id[module_edge_list[edge_id][1]], new BioNetEdge(module_edge_list[edge_id][2]));
		// Create a new module
		module_list->at(priority_id) = new Module(module_editor);
		// TEST HERE
		// module_list->at(priority_id)->TestPrint(&std::cout);
	}
	return module_list;
}

int PartDatabase::getRegulationType(Molecule* m1, Molecule* m2) {
	QueryResultInfo qri = Init();
	qri.query = "SELECT regulation FROM Regulation";
	qri.query += " WHERE src_type = '" + Id2Str(m1->getType()) + "' AND src_name = '" + m1->getName() + "' AND dest_type = '" + Id2Str(m2->getType()) + "' AND dest_name = '" + m2->getName() + "'";
	StringMatrix regulation_type;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &regulation_type, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (regulation_type.empty())
		return NONE;
	else
		if (regulation_type[0][0].compare("ACT") == STR_EQ)
			return ACTIVATORY;
		else
			return INHIBITORY;
}

int PartDatabase::getNumberOfSubsitution(string functional_module_type) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT COUNT (DISTINCT derive_id) FROM Functional_Module_Node";
	qri.query += " WHERE functional_module_type = '" + functional_module_type + "'";
	int count_tmp;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_count, &count_tmp, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	return count_tmp;
}

Module* PartDatabase::loadSubstitution(string functional_module_type, int derive_id) const {
	QueryResultInfo qri = Init();
	ARGEdit* module_editor = new ARGEdit;
	// Read nodes
	StringMatrix module_node_list;
	Reset(qri);
	qri.query = "SELECT node_id,node_type,node_name,node_role FROM Functional_Module_Node";
	qri.query += " WHERE functional_module_type = '" + functional_module_type + "' AND derive_id = '" + Num2Str(derive_id) + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_node_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	std::map<string, int> node_id_to_bionode_id;
	IdList input_tmp, output_tmp;
	for (unsigned int node_id = 0; node_id < module_node_list.size(); node_id++) {
		int id_tmp = module_editor->InsertNode(CreateBioNetNode(module_node_list[node_id][1], module_node_list[node_id][2]));
		node_id_to_bionode_id[module_node_list[node_id][0]] = id_tmp;
		if (module_node_list[node_id][3].compare("Input") == STR_EQ)
			input_tmp.push_back(id_tmp);
		else if (module_node_list[node_id][3].compare("Output") == STR_EQ)
			output_tmp.push_back(id_tmp);
		else if (module_node_list[node_id][3].compare("Input_Output") == STR_EQ) {
			input_tmp.push_back(id_tmp);
			output_tmp.push_back(id_tmp);
		}
	}
	// Read edges
	StringMatrix module_edge_list;
	Reset(qri);
	qri.query = "SELECT src_id, dest_id, edge_type FROM Functional_Module_Edge";
	qri.query += " WHERE functional_module_type = '" + functional_module_type + "' AND derive_id = '" + Num2Str(derive_id) + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_edge_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	for (unsigned int edge_id = 0; edge_id < module_edge_list.size(); edge_id++)
		module_editor->InsertEdge(node_id_to_bionode_id[module_edge_list[edge_id][0]],node_id_to_bionode_id[module_edge_list[edge_id][1]], new BioNetEdge(module_edge_list[edge_id][2]));
	// Create a new module
	Module* tmp = new Module(module_editor);
	tmp->inputs = input_tmp;
	tmp->outputs = output_tmp;
	// TEST HERE
	//tmp->TestPrint(&std::cout);
	return tmp;
}

Module* PartDatabase::loadContent(string macro_module_type, string macro_module_name) const {
	QueryResultInfo qri = Init();
	ARGEdit* module_editor = new ARGEdit;
	// Read nodes
	StringMatrix module_node_list;
	Reset(qri);
	qri.query = "SELECT node_id,node_type,node_name,node_role FROM Macro_Module_Node";
	qri.query += " WHERE macro_module_type = '" + macro_module_type + "' AND macro_module_name = '" + macro_module_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_node_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	std::map<string, int> node_id_to_bionode_id;
	IdList input_tmp, output_tmp;
	for (unsigned int node_id = 0; node_id < module_node_list.size(); node_id++) {
		int id_tmp = module_editor->InsertNode(CreateBioNetNode(module_node_list[node_id][1], module_node_list[node_id][2]));
		node_id_to_bionode_id[module_node_list[node_id][0]] = id_tmp;
		if (module_node_list[node_id][3].compare("Input") == STR_EQ)
			input_tmp.push_back(id_tmp);
		else if (module_node_list[node_id][3].compare("Output") == STR_EQ)
			output_tmp.push_back(id_tmp);
		else if (module_node_list[node_id][3].compare("Input_Output") == STR_EQ) {
			input_tmp.push_back(id_tmp);
			output_tmp.push_back(id_tmp);
		}
	}
	// Read edges
	StringMatrix module_edge_list;
	Reset(qri);
	qri.query = "SELECT src_id, dest_id, edge_type FROM Macro_Module_Edge";
	qri.query += " WHERE macro_module_type = '" + macro_module_type + "' AND macro_module_name = '" + macro_module_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_edge_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	for (unsigned int edge_id = 0; edge_id < module_edge_list.size(); edge_id++)
		module_editor->InsertEdge(node_id_to_bionode_id[module_edge_list[edge_id][0]],node_id_to_bionode_id[module_edge_list[edge_id][1]], new BioNetEdge(module_edge_list[edge_id][2]));
	// Create a new module
	Module* tmp = new Module(module_editor);
	tmp->inputs = input_tmp;
	tmp->outputs = output_tmp;
	// TODO: solve for the EMPTY OR GATE here
	if (macro_module_type.compare("OR_GATE") == STR_EQ && tmp->inputs.size() == 1)
		tmp->inputs.push_back(tmp->inputs[0]);
	// TEST HERE
	//cout << macro_module_type << "\t" << macro_module_name << endl;
	//tmp->TestPrint(&std::cout);
	return tmp;
}

double ev(int k, int n, double alpha) {
	return pow(alpha,k) - 1 - n*(alpha - 1);
}
double find_scale(int k, int n) { // solve the equation (alpha^k - 1)/(alpha - 1) = n --> alpha^k - 1 - n(alpha - 1) = 0
	double u = n, l = 1 + 1e-10;
	while (u - l > 1e-10) {
		double mid = (u + l)/2;
		if ((ev(k,n,u) > 0 && ev(k,n,mid) < 0) || (ev(k,n,u) < 0 && ev(k,n,mid) > 0))
			l = mid;
		else
			u = mid;
	}
	return (u+l)/2;
}

vector<Module*>* PartDatabase::RandomizeModuleLibrary(int library_size, int max_module_size) {
	vector<Module*>* tmp;
	int total_number_of_modules = 0;
	int max_module_library_size = floor(0.4*library_size);
	double scale = find_scale(max_module_size - 1, max_module_library_size);
	for (int module_size = max_module_size; module_size > 1; module_size--) {
		int number_of_modules = round(pow(scale, max_module_size - module_size));
		total_number_of_modules += number_of_modules;
		for (int module_id = 0; module_id < number_of_modules; module_id++) {
			// Generate module topology, each module has more than one gates
			Module* module = GenerateGateNetwork(module_size,round(0.4*module_size), false);
			// Fill names
			tmp->push_back(module);
		}
	}
	// Generate single gates
	// Generate molecules cascade
	// Generate single molecules and YES-GATE
	return tmp;
}

QueryResultInfo Init() {
	QueryResultInfo qri;
	qri.zErrMsg = NULL;
	qri.query = "";
	qri.string_matrix.clear();
	return qri;
}

void Reset(QueryResultInfo& qri) {
	qri.zErrMsg = NULL;
	qri.query = "";
	qri.string_matrix.clear();
}


string Num2StrPlus1(int num) {
	stringstream ss;
	ss << num + 1; // PLUS 1
	string tmp(ss.str());
	return tmp;
}

string Num2Str(int num) {
	stringstream ss;
	ss << num;
	string tmp(ss.str());
	return tmp;
}
