/*
 * DesignProblem.cpp
 *
 *  Created on: Apr 20, 2012
 *      Author: linh, UC Davis
 */

#include <fstream>
#include "DesignProblem.h"

void SimulationData::TestPrint(ostream* f) {
	for (int row = 0; row < input_values.size(); row++) {
		for (int col = 0; col < input_values[row].size(); col++)
			*f << input_values[row][col] << "\t";
		for (int col = 0; col < output_values[row].size(); col++)
			*f << output_values[row][col] << "\t";
		*f << endl;
	}
}

ValueMatrix transpose (ValueMatrix matrix) {
	ValueMatrix tmp;
	if (!matrix.empty()) {
		int n = matrix.size();
		int m = matrix[0].size();
		tmp.resize(m);
		for (int i = 0; i < m; i++) {
			tmp[i].resize(n);
			 for (int j = 0; j < n; j++)
				 tmp[i][j] = matrix[j][i];
		}
	}
	return tmp;
}

DesignProblem::DesignProblem(string input_filename) {
	ARGEdit* editor = new ARGEdit;
	// PARSE THE INPUT FILE
	XMLNode xMainNode=XMLNode::openFileHelper(input_filename.c_str());
	int number_of_cells = xMainNode.getChildNode(0).nElement();
	int number_of_nodes = 0;
	int number_of_inputs = 0;
	map<int,int> cell_to_node;
	map<int,NodeVisualInfo*> node_id_to_visual_info;
	ValueMatrix input_values_t, output_values_t;	// transpose
	IdList inputs, outputs;
	ValueList vl_tmp;
	// BUILD THE INPUT GRAPH
	// Add nodes
	for (int i = 2; i < number_of_cells; i++) {
		int cell_id = atoi(xMainNode.getChildNode(0).getChildNode(i).getAttribute("id"));
		XMLNode current_node;
		if(strcmp(xMainNode.getChildNode(0).getChildNode(i).getName(), "mxCell") == STR_EQ)
			current_node = xMainNode.getChildNode(0).getChildNode(i);
		else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getName(), "UserObject") == STR_EQ) {	// input or output
			vl_tmp.clear();
			string values = xMainNode.getChildNode(0).getChildNode(i).getAttribute("link");
			int pre_pos = -1;
			for (int tmp = 0; tmp < values.length(); tmp++) {
				if (values[tmp] != ' ' && pre_pos < 0)
					pre_pos = tmp;
				if (values[tmp] == ' ' && pre_pos >= 0) {
					vl_tmp.push_back(atof(values.substr(pre_pos, tmp - pre_pos).c_str()));
					pre_pos = -1;
				}
				if (tmp == values.length() - 1 && pre_pos >= 0)
					vl_tmp.push_back(atof(values.substr(pre_pos, tmp - pre_pos + 1).c_str()));
			}
			current_node = xMainNode.getChildNode(0).getChildNode(i).getChildNode(0);
		}
		string style_str = current_node.getAttribute("style");
		//cout << style_str << endl;
		string l_str = "shape=ligand;", p_str = "shape=protein;", m_str = "shape=mrna;";
		string l_p_str = "shape=ligand-protein;", p_p_str = "shape=protein-protein;", m_m_str = "shape=mrna-mrna;";
		if (style_str.compare("shape=not_gate") == STR_EQ) {						// 	NOT gate
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("NOT_GATE"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.compare("shape=yes_gate") == STR_EQ) {					// 	NOT gate
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("YES_GATE"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.compare("shape=or_gate") == STR_EQ) {					//	OR gate
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("OR_GATE"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.compare("shape=and_gate") == STR_EQ) {					//	AND gate
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("AND_GATE"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.compare("shape=nor_gate") == STR_EQ) {					//	NOR gate
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("NOR_GATE"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.compare("shape=input") == STR_EQ) {						//	input
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("INPUT"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
			inputs.push_back(cell_to_node[cell_id]);
			input_values_t.push_back(vl_tmp);
		}
		else if (style_str.compare("shape=output") == STR_EQ) {						//	output
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("OUTPUT"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
			outputs.push_back(cell_to_node[cell_id]);
			output_values_t.push_back(vl_tmp);
		}
		else if (style_str.substr(0,l_str.length()).compare(l_str) == STR_EQ) {		// Ligand
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("Ligand"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.substr(0,p_str.length()).compare(p_str) == STR_EQ) {		// Protein
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("Protein"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.substr(0,m_str.length()).compare(m_str) == STR_EQ) {		// mRNA
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("mRNA"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.substr(0,l_p_str.length()).compare(l_p_str) == STR_EQ) {	// Ligand-Protein
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("LigandProteinComplex"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.substr(0,p_p_str.length()).compare(p_p_str) == STR_EQ) {	// Protein-Protein
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("ProteinComplex"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
		else if (style_str.substr(0,m_m_str.length()).compare(m_m_str) == STR_EQ) {	// RNA-RNA
			cell_to_node[cell_id] = editor->InsertNode(CreateBioNetNode("RNAComplex"));
			node_id_to_visual_info[cell_to_node[cell_id]] = GetVisualInfo(current_node.getChildNode(0));
		}
	}
	// Add edges
	for (int i = 2; i < number_of_cells; i++) {
		XMLNode current_node;
		if(strcmp(xMainNode.getChildNode(0).getChildNode(i).getName(), "mxCell") == STR_EQ)
			current_node = xMainNode.getChildNode(0).getChildNode(i);
		else if (strcmp(xMainNode.getChildNode(0).getChildNode(i).getName(), "UserObject") == STR_EQ)
			current_node = xMainNode.getChildNode(0).getChildNode(i).getChildNode(0);
		if (strncmp(current_node.getAttribute("style") , "edgeStyle", strlen("edgeStyle")) == STR_EQ) {
			int src_id = atoi(xMainNode.getChildNode(0).getChildNode(i).getAttribute("source"));
			int dest_id = atoi(xMainNode.getChildNode(0).getChildNode(i).getAttribute("target"));
			string edge_str = xMainNode.getChildNode(0).getChildNode(i).getAttribute("style");
			int edge_type = UNKNOWN;
			if (edge_str.find("endArrow=classic") != string::npos)
				edge_type = ACTIVATORY;
			else if (edge_str.find("endArrow=oval") != string::npos)
				edge_type= INHIBITORY;
			editor->InsertEdge(cell_to_node[src_id], cell_to_node[dest_id], new BioNetEdge(edge_type));
		}
	}
	// set up the design problem
	gcg.ResetLoader(editor);
	desired_behavior.inputs = inputs;
	desired_behavior.outputs = outputs;
	desired_behavior.input_values = transpose(input_values_t);
	desired_behavior.output_values = transpose(output_values_t);
}

void DesignProblem::TestPrint(ostream* f){
	gcg.TestPrint(f);
	*f << "INPUTS: " ;
	for (unsigned int i = 0; i < desired_behavior.inputs.size(); i++)
		*f << desired_behavior.inputs[i] << "\t";
	*f << endl << "OUTPUTS: ";
	for (unsigned int i = 0; i < desired_behavior.outputs.size(); i++)
		*f << desired_behavior.outputs[i] << "\t";
	*f << endl;
	for (unsigned int i = 0; i < desired_behavior.input_values.size(); i++) {
		for (int j = 0; j < desired_behavior.input_values[i].size(); j++)
			*f << desired_behavior.input_values[i][j] << "\t";
		for (int j = 0; j < desired_behavior.output_values[i].size(); j++)
			*f << desired_behavior.output_values[i][j] << "\t";
		*f << endl;
	}
}

NodeVisualInfo* GetVisualInfo(XMLNode xml_node) {
	return new NodeVisualInfo(atoi(xml_node.getAttribute("x")), atoi(xml_node.getAttribute("y")), atoi(xml_node.getAttribute("width")), atoi(xml_node.getAttribute("height")));
}
