/*
 * Framework.cpp
 *
 *  Created on: Aug 17, 2012
 *      Author: linh
 */
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/time.h>
#include <algorithm>
#include <vector>
#include <sstream>
#include <string>
#include <map>
#include <queue>
#include <stack>
#include <iostream>
#include "Framework.h"

void OutputNodeRecord::Print() {
	cout << "Cost: " << cost << endl;
	cout << "Output: " << output << endl;
	PrintStringTree(&signal_list);
	//for (int i = 0; i < branch_node_info.size(); i++)
	//	cout << branch_node_info[i].signal_name << ((branch_node_info[i].is_contained)? " Y ":" N ");
	//cout << endl;
	//cout << "Module id: " << module_id << endl;
	//cout << "Matching id: " << matching_id << endl;
	//cout << "Previous nodes: ";
	//for (int i = 0; i < pre_node_record_list.size(); i++)
	//	cout << pre_node_record_list[i] << " ";
	//cout << endl;
}

ModuleMatchingManager::ModuleMatchingManager(GeneCircuitGraph* input_gcg, PartDatabase* input_pdb) {
	partDB = input_pdb;		// Unsafe assignment, but it is simple
	gcg = input_gcg;		// Unsafe assignment, but it is simple
	module_lib = partDB->loadModuleLibrary();
	// TEST HERE
	// gcg->TestPrint(&std::cout);
	// END TEST
	// Match each module with the input graph to build the matching map
	matching_map = new GraphIsomorphismCollection*[module_lib->size()]; // matching_map[module_id]->at(matching_id) is a list of node pair that is indexed by the node_id of the module
	matching_list_at_node.resize(gcg->NodeCount());
	for (unsigned int module_id = 0; module_id < module_lib->size(); module_id++) {
		// call Ullman here
		Module* module_tmp = module_lib->at(module_id);
		// TODO: clean
		matching_map[module_id] = new GraphIsomorphismCollection;
		VF2SubState vf2_sub_state(module_tmp, gcg);
		match(&vf2_sub_state, all_visitor, matching_map[module_id]); // TODO: we should sort pairs in each isomorphism so that it is indexed by the small node id
		// TEST HERE
		//cout << "--------------- Module: " << module_id << endl;
		//module_tmp->TestPrint(&std::cout);
		//cout << "____________" << endl;
		//for (unsigned int matching_id = 0; matching_id < matching_map[module_id]->size(); matching_id++) {
		//	cout << "Matching: " << matching_id + 1 << "-th" << endl;
		//	for (unsigned int node_pair_id = 0; node_pair_id < matching_map[module_id]->at(matching_id).size(); node_pair_id++)
		//		cout << matching_map[module_id]->at(matching_id)[node_pair_id].large_graph_node << "\t" << matching_map[module_id]->at(matching_id)[node_pair_id].small_graph_node << endl;
		//}
		//cout << "---------------" << endl;
		// END TEST
		bool *is_input = new bool[module_tmp->NodeCount()];
		for (int i = 0; i < module_tmp->NodeCount(); i++)
			is_input[i] = false;
		for (int i = 0; i < module_tmp->inputs.size(); i++)
			is_input[module_tmp->inputs[i]] = true;
		for (unsigned int matching_id = 0; matching_id < matching_map[module_id]->size(); matching_id++) {
			if (module_tmp->outputs.empty()) {
				cout << "SBROME ERROR: Module has no output" << endl;
				module_tmp->TestPrint(&std::cout);
			}
			int module_node_output_index = module_tmp->outputs[0]; // TODO: extend for the case of multiple outputs
			// NOTICE:
			//		+ matching_list_at_node[node_id][i].first: id of the matched module_id
			//		+ matching_list_at_node[node_id][i].second: id of the matching corresponded to module_id

			bool* is_matched = new bool[gcg->NodeCount()];	// use to check if a node is matched with another node in the module graph
			for (int node_id = 0; node_id < gcg->NodeCount(); node_id++)
				is_matched[node_id] = false;
			for (unsigned int node_pair_id = 0; node_pair_id < matching_map[module_id]->at(matching_id).size(); node_pair_id++)
				is_matched[matching_map[module_id]->at(matching_id)[node_pair_id].large_graph_node] = true;
			bool encapsulated_checking = true;	// check to ensure that there is no connection between a node outside of the module with a neither an input node nor a selector node inside the module
			for (unsigned int node_pair_id = 0; node_pair_id < matching_map[module_id]->at(matching_id).size(); node_pair_id++) {
				int circuit_node_id = matching_map[module_id]->at(matching_id)[node_pair_id].large_graph_node;
				int in_degree = gcg->InEdgeCount(circuit_node_id);
				for (int in_node_id = 0; in_node_id < in_degree; in_node_id++)
					if (!is_matched[gcg->GetInEdge(circuit_node_id,in_node_id)]
						&& !is_input[matching_map[module_id]->at(matching_id)[node_pair_id].small_graph_node]
						&& gcg->GetNodeAttr(circuit_node_id)->component->getType() != SELECTOR) {
						encapsulated_checking = false;
						break;
					}
				if (!encapsulated_checking)
					break;
			}
			if (encapsulated_checking)
				matching_list_at_node[matching_map[module_id]->at(matching_id)[module_node_output_index].large_graph_node].push_back(std::make_pair(module_id,matching_id));
			delete []is_matched;
		}
		delete []is_input;
		//delete module_tmp;
	}
	// Labeling nodes
	int number_of_nodes = gcg->NodeCount();
	gcg->Topo_Sort(&topo_order_list);
	// Determine the branching nodes and input nodes
	int number_of_branching_nodes = 0;
	int number_of_input_nodes = 0;
	for (int node_id = 0; node_id < number_of_nodes; node_id++) {
		if (gcg->OutEdgeCount(node_id) > 1)
			branching_node_map[node_id] = number_of_branching_nodes++;
		if (gcg->GetNodeAttr(node_id)->component->getType() == INPUT)
			input_node_map[node_id] = number_of_input_nodes++;
	}
	// Reset the record list
	current_optimal_cost = UNKNOWN;
	record_list.resize(number_of_nodes);
}

ModuleMatchingManager::~ModuleMatchingManager() {
	//vector<Module*> *module_lib;
	//GraphIsomorphismCollection** matching_map;
}

bool ModuleMatchingManager::is_look_ahead_ok(int node_id, string species_name) {
	if (partDB->getSpeciesType(species_name).compare("Protein") == STR_EQ) {
		StringList dest_species_list;
		IdList interaction_type_list;
		partDB->getAllInteractedSpecies(species_name, &dest_species_list, &interaction_type_list);
		int num_out_edge = gcg->OutEdgeCount(node_id);
		for (int i = 0; i < num_out_edge; i++) {
			int dest_node_id = gcg->GetOutEdge(node_id, i);
			int dest_node_type = gcg->GetNodeAttr(dest_node_id)->component->getType();
			if (gcg->GetNodeAttr(dest_node_id)->component->getType() == OUTPUT) {
				if(!partDB->is_output(species_name))
					return false;
			}
			else if (gcg->GetNodeAttr(dest_node_id)->component->getType() == POOL) {
				if (!is_look_ahead_ok(dest_node_id, species_name))
					return false;
			}
			else if (gcg->GetNodeAttr(dest_node_id)->component->getCategory() == MOLECULE) {
				bool is_look_ahead_good = false;
				for (int j = 0; j < dest_species_list.size(); j++) {
					//cout << partDB->getSpeciesType(dest_species_list[j]) << "\t" << Id2Str(dest_node_type) << "\t" << gcg->GetEdgeAttr(node_id,dest_node_id)->type << "\t" << interaction_type_list[j]<< endl;
					if (Str2Id(partDB->getSpeciesType(dest_species_list[j])) == dest_node_type && gcg->GetEdgeAttr(node_id,dest_node_id)->type == interaction_type_list[j]) {
						is_look_ahead_good = true;
						break;
					}
				}
				if (!is_look_ahead_good)
					return false;
			}
		}
	}
	return true;
}

double ModuleMatchingManager::Match(int search_mode, int starting_node_id, int max_number_of_kept_records) {
	bool is_a_heuristic_pass = (search_mode != DP);
	// TEST HERE
	//if (is_a_heuristic_pass)
	//	cout << "HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH Heuristic pass begin HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH" << endl;
	//else
	//	cout << "RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR Regular pass begin RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR" << endl;
	// END TEST
	if (is_a_heuristic_pass && max_number_of_kept_records <= 0)
		return UNKNOWN;	// Branch & bound is not applied
	int number_of_nodes = gcg->NodeCount();
	int number_of_branching_nodes = this->branching_node_map.size();
	// Main loop here to update the information record for each intermediate output node
	for (int topo_id = starting_node_id; topo_id < number_of_nodes; topo_id++) {
		// Run the heuristic here to find a solution
		//double cost_tmp = (is_a_heuristic_pass)?UNKNOWN:this->Match(HS_DP, topo_id, max_number_of_kept_records);
		//if (cost_tmp >= 0 && (current_optimal_cost < 0 || current_optimal_cost > cost_tmp))
		//	current_optimal_cost = cost_tmp;
		if (!is_a_heuristic_pass && current_optimal_cost < 0) {
			 current_optimal_cost = this->Match(HS_DP, topo_id, max_number_of_kept_records);
			 //if (current_optimal_cost >= 0)
			//	 cout << "A solution found with cost: " << current_optimal_cost << endl;
		}
		// TEST HERE
		//if (!is_a_heuristic_pass)
		//	cout << topo_order_list[topo_id] << "\t Current optimal cost: \t" << current_optimal_cost << endl;
		// END TEST
		int node_id = this->topo_order_list[topo_id];
		StringMatrix duplicate_checking;
		duplicate_checking.clear();
		if (gcg->GetNodeAttr(node_id)->component->getCategory() == CIRCUIT_SIGNAL || gcg->GetNodeAttr(node_id)->component->getCategory() == MOLECULE) { // TODO: extend to "select" node for the future
			if (gcg->GetNodeAttr(node_id)->component->getCategory() == CIRCUIT_SIGNAL && gcg->GetNodeAttr(node_id)->component->getType() == INPUT) {	// input nodes
				record_list[node_id].resize(1);
				record_list[node_id][0].output = "UNKNOWN";
				record_list[node_id][0].branch_node_info.resize(number_of_branching_nodes);
				record_list[node_id][0].input_name_info.resize(this->input_node_map.size());
			}
			else {
				// TEST HERE
				//cout << "##################" << endl;
				//cout << "Node: " << node_id << " ---- Number of possible matchings: " << matching_list_at_node[node_id].size() << endl;
				//cout << "##################" << endl;
				// END TEST
				bool is_final_node = false;
				int number_of_out_edges = gcg->OutEdgeCount(node_id);
				for (int edge_id = 0; edge_id < number_of_out_edges; edge_id++)
					if (gcg->GetNodeAttr(gcg->GetOutEdge(node_id,edge_id))->component->getType() == OUTPUT) {
						is_final_node = true;
						break;
					}
				int number_of_matchings = (gcg->GetNodeAttr(node_id)->component->getType() == POOL)? (matching_list_at_node[node_id].size() + 1) : matching_list_at_node[node_id].size();
				//int number_of_matchings = matching_list_at_node[node_id].size();
				//cout << "Number of matchings: "<< number_of_matchings << endl;
				for (unsigned int matching_id = 0; matching_id < number_of_matchings; matching_id++) {
					bool is_a_pool_matching = (matching_id == matching_list_at_node[node_id].size()); // If this is "natural" matching with a pool node, not a conventional matching
					int number_of_fan_ins;
					int matching_id_in_mapping;
					int matched_module_id;
					Module* current_matched_module;
					if (!is_a_pool_matching) {
						matched_module_id = matching_list_at_node[node_id][matching_id].first;
						current_matched_module = module_lib->at(matched_module_id);
						matching_id_in_mapping = matching_list_at_node[node_id][matching_id].second;
						number_of_fan_ins = current_matched_module->inputs.size();
					}
					else
						number_of_fan_ins = gcg->InEdgeCount(node_id);

					// LOOK AHEAD HERE TO SEE IF THE OUTPUT IS USEFUL
					if (!is_a_pool_matching) {
						if (!is_look_ahead_ok(node_id,current_matched_module->GetNodeAttr(current_matched_module->outputs[0])->component->name)) {
							//if (!is_a_heuristic_pass)
								//cout << "Node: " << node_id << "\t" << current_matched_module->GetNodeAttr(current_matched_module->outputs[0])->component->name << "\t Look ahead: Not OK"  << endl;
							continue;
						}
					}
					else {

					}
					// TEST HERE
					//if (!is_a_heuristic_pass) {
					//	cout << "=================================" << endl;
					//	if (!is_a_pool_matching) {
					//		cout << "Node: " << node_id << "\t Module: " << module_lib->at(matched_module_id)->name << endl;
					//		module_lib->at(matched_module_id)->TestPrint(&std::cout);
					//		cout << "=================" << endl;
					//		for (unsigned int i = 0; i < matching_map[matched_module_id]->at(matching_id_in_mapping).size(); i++) {
					//			cout << matching_map[matched_module_id]->at(matching_id_in_mapping)[i].large_graph_node << "\t" << matching_map[matched_module_id]->at(matching_id_in_mapping)[i].small_graph_node << endl;				}
					//	}
					//	else
					//		cout << node_id << "\t" << "POOL" << endl;
					//	cout << "=================================" << endl;
					//}
					// END TEST
					// main loop to compute the product of all fan-ins

					int* fan_in_node_id_list = new int[number_of_fan_ins];
					int* input_node_id_list = new int[number_of_fan_ins];
					int* numbering_array = new int[number_of_fan_ins];
					bool record_is_empty = false;
					for (int fan_index = 0; fan_index < number_of_fan_ins; fan_index++) {
						if (!is_a_pool_matching) {
							fan_in_node_id_list[fan_index] = matching_map[matched_module_id]->at(matching_id_in_mapping)[current_matched_module->inputs[fan_index]].large_graph_node;
							input_node_id_list[fan_index] = current_matched_module->inputs[fan_index];
						}
						else
							fan_in_node_id_list[fan_index] = gcg->GetInEdge(node_id, fan_index);
						// TEST HERE
						//cout << fan_in_node_id_list[fan_index] << endl;
						// END TEST
						if (record_list[fan_in_node_id_list[fan_index]].size() > 0)
							numbering_array[fan_index] = 0;
						else {
							record_is_empty = true;
							break;
						}
					}
					if (!record_is_empty) {
						int idx_tmp;
						do {
							// Synthesize a new record here
							OutputNodeRecord composite_record_tmp;
							composite_record_tmp.branch_node_info.resize(number_of_branching_nodes);
							composite_record_tmp.input_name_info.resize(this->input_node_map.size());
							if (!is_a_pool_matching) {
								composite_record_tmp.cost = current_matched_module->cost;
							}
							else
								composite_record_tmp.cost = 0;	// a natural matching for a pool node
							// Estimate the cost and apply branch&bound
							for (int fan_index = 0; fan_index < number_of_fan_ins; fan_index++)
								composite_record_tmp.cost += record_list[fan_in_node_id_list[fan_index]][numbering_array[fan_index]].cost;
							if (current_optimal_cost >= 0 && composite_record_tmp.cost > current_optimal_cost) {
								// TEST HERE
								//cout << "BB is applied: Current cost is " << composite_record_tmp.cost << " while current optimal cost is " << current_optimal_cost << endl;
								// END TEST
							}
							else if (current_optimal_cost < 0 && is_a_heuristic_pass && record_list[node_id].size() == max_number_of_kept_records && record_list[node_id][max_number_of_kept_records - 1].cost <= composite_record_tmp.cost) { // for a heuristic pass
								// TEST HERE
								//cout << "This is a heuristic pass and the current cost is " << composite_record_tmp.cost << " while the largest cost is " << record_list[node_id][max_number_of_kept_records - 1].cost << endl;
								// END TEST
							}
							else {
								StringList empty_str_list;
								bool is_output_compatible = true;
								bool is_cross_talking = false;
								bool is_branching_node_ok = true;
								bool is_input_name_ok = true;
								// Update the signal check list and the branching node check list with the mapping at the output node
								if (!is_a_pool_matching) {
									for(int node_id_tmp = 0; node_id_tmp < current_matched_module->NodeCount(); node_id_tmp++){
										int node_index_in_input_graph = matching_map[matched_module_id]->at(matching_id_in_mapping)[node_id_tmp].large_graph_node;
										if (branching_node_map.count(node_index_in_input_graph) > 0) {	// For branching nodes
											composite_record_tmp.branch_node_info[branching_node_map[node_index_in_input_graph]].signal_name = current_matched_module->GetNodeAttr(node_id_tmp)->component->name;
											composite_record_tmp.branch_node_info[branching_node_map[node_index_in_input_graph]].is_contained = (current_matched_module->InEdgeCount(node_id_tmp) > 1 || gcg->InEdgeCount(node_index_in_input_graph) == 0);
										}
										if (gcg->GetNodeAttr(node_index_in_input_graph)->component->getType() == INPUT) { // For input nodes
											composite_record_tmp.input_name_info[input_node_map[node_index_in_input_graph]] = current_matched_module->GetNodeAttr(node_id_tmp)->component->name;
										}
									}
								}
								// Update these two check lists with the mapping at each fan-in
								IdList temp_update_node_list;	// contains nodes in the matched module where name is UNKNOWN, it is updated temporarily with the name of the fan-in module output
								for (int fan_index = 0; fan_index < number_of_fan_ins; fan_index++) {
									OutputNodeRecord fan_in_record_tmp = record_list[fan_in_node_id_list[fan_index]][numbering_array[fan_index]];
									// Check compatible
									if (!is_a_pool_matching) {
										is_output_compatible = (fan_in_record_tmp.output.compare("UNKNOWN") == STR_EQ || current_matched_module->GetNodeAttr(input_node_id_list[fan_index])->component->name.compare("UNKNOWN") == STR_EQ || current_matched_module->GetNodeAttr(input_node_id_list[fan_index])->component->name.compare(fan_in_record_tmp.output) == STR_EQ);
										if (!is_output_compatible) {
											//cout << "NOT COMPATIBLE, output: " << fan_in_record_tmp.output << "\t input needed: " << current_matched_module->GetNodeAttr(input_node_id_list[fan_index])->component->name << endl;
											break;
										}
										else if (current_matched_module->GetNodeAttr(input_node_id_list[fan_index])->component->name.compare("UNKNOWN") == STR_EQ) {
											temp_update_node_list.push_back(input_node_id_list[fan_index]);
											current_matched_module->GetNodeAttr(input_node_id_list[fan_index])->component->name = fan_in_record_tmp.output;
										}
									}
									else if (fan_index > 0){	// a natural matching for a pool node
										string pre_output = record_list[fan_in_node_id_list[fan_index-1]][numbering_array[fan_index-1]].output;
										string current_output = record_list[fan_in_node_id_list[fan_index]][numbering_array[fan_index]].output;
										if (pre_output.compare(current_output) != STR_EQ) {
											is_output_compatible = false;
											//cout << "NOT COMPATIBLE, previous fan-in output: " << pre_output << " while the current fan-in output is " << current_output << endl;
											break;
										}
									}
									// Check cross-talk
									// if the fan-in signal output is connected to a pool node, skip the cross-talk check on this signal
									CheckList skip_list;
									if (!is_a_pool_matching) {
										int pool_node_id = current_matched_module->GetOutEdge(input_node_id_list[fan_index],0);
										vector<Molecule*>* mol_list_tmp = SrcComponent2Molecule(current_matched_module->GetNodeAttr(pool_node_id)->component, partDB);
										if (mol_list_tmp->at(0)->getType() == POOL)
											skip_list[fan_in_record_tmp.output] = 1;
										for (int i = 0; i < mol_list_tmp->size(); i++)
											delete mol_list_tmp->at(i);
										delete mol_list_tmp;
									}
									else // a natural matching for a pool node
										skip_list[fan_in_record_tmp.output] = 1;
									is_cross_talking = check_and_merge(&composite_record_tmp.signal_list, &fan_in_record_tmp.signal_list, &skip_list);
									if (is_cross_talking) {
										//cout << "CROSS TALKING" << endl;
										break;
									}
									// Check branching-nodes
									for (int branching_node_id = 0; branching_node_id < number_of_branching_nodes; branching_node_id++) {
										if (!fan_in_record_tmp.branch_node_info[branching_node_id].signal_name.empty())
											if (composite_record_tmp.branch_node_info[branching_node_id].signal_name.empty() || composite_record_tmp.branch_node_info[branching_node_id].signal_name.compare("UNKNOWN") == STR_EQ || (composite_record_tmp.branch_node_info[branching_node_id].signal_name.compare(fan_in_record_tmp.branch_node_info[branching_node_id].signal_name) == STR_EQ))
												composite_record_tmp.branch_node_info[branching_node_id] = fan_in_record_tmp.branch_node_info[branching_node_id];
											else {
												// TEST HERE
												//cout << "BRANCHING NODE IS NOT OK: One is " << composite_record_tmp.branch_node_info[branching_node_id].signal_name << " and one is " << fan_in_record_tmp.branch_node_info[branching_node_id].signal_name << endl;
												// END TEST
												is_branching_node_ok = false;
												break;
											}
									}
									if (!is_branching_node_ok)
										break;
									// Check to ensure all inputs are different
									for (int input_node_id = 0; input_node_id < composite_record_tmp.input_name_info.size(); input_node_id++) {
										if (!fan_in_record_tmp.input_name_info[input_node_id].empty()) {
											for (int input_node_id_tmp = 0; input_node_id_tmp < composite_record_tmp.input_name_info.size(); input_node_id_tmp++)
												if (input_node_id_tmp != input_node_id && fan_in_record_tmp.input_name_info[input_node_id].compare(composite_record_tmp.input_name_info[input_node_id_tmp]) == STR_EQ) {
													//cout << "Inputs are repeated!" << endl;
													is_input_name_ok = false;
													break;
												}
											if (is_input_name_ok)
												composite_record_tmp.input_name_info[input_node_id] = fan_in_record_tmp.input_name_info[input_node_id];
										}
										if (!is_input_name_ok)
											break;
									}
									if (!is_input_name_ok)
										break;
								}
								if (is_output_compatible && !is_cross_talking && is_branching_node_ok && is_input_name_ok) {
									StrTree matched_module_str_tree;
									if (!is_a_pool_matching) {
										GCG2StrTree(Layout(current_matched_module, partDB), &matched_module_str_tree);
									}
									// TEST HERE
									//cout << "::::::::::::::" << endl;
									//PrintStringTree(&matched_module_str_tree);
									//cout << ";;;;;;;;;;;;;;" << endl;
									//PrintStringTree(&composite_record_tmp.signal_list);
									//cout << "::::::::::::::" << endl;
									// END TEST
									if (!check_and_merge(&composite_record_tmp.signal_list, &matched_module_str_tree, NULL)) {
										if (!is_a_pool_matching) {
											composite_record_tmp.output = current_matched_module->getOutputName()[0];
											composite_record_tmp.module_id = matched_module_id;
											composite_record_tmp.matching_id = matching_id_in_mapping;
										}
										else {
											composite_record_tmp.output = record_list[fan_in_node_id_list[0]][numbering_array[0]].output;
											composite_record_tmp.module_id = UNKNOWN;
											composite_record_tmp.matching_id = UNKNOWN;
										}
										composite_record_tmp.pre_node_record_list.resize(number_of_fan_ins);
										for (int i = 0; i < number_of_fan_ins; i++)
											composite_record_tmp.pre_node_record_list[i] = numbering_array[i];
										// Add this new record if it does lead to the same solution of any other record
										// TRAVERSE TO FIND THE LIST OF SPECIES NAME
										StringList species_assignment;
										for (int i = 0; i < number_of_nodes; i++)
											species_assignment.push_back("UNKNOWN");
										record_list[node_id].push_back(composite_record_tmp);	// pretend to add this record and then we will remove it later if it is duplicated
										queue<IdPair> traverse_queue;
										traverse_queue.push(std::make_pair(node_id, record_list[node_id].size() - 1));
										while (!traverse_queue.empty()) {
											IdPair pair_tmp = traverse_queue.front();
											traverse_queue.pop();
											int matched_module_id = record_list[pair_tmp.first][pair_tmp.second].module_id;
											int matching_id = record_list[pair_tmp.first][pair_tmp.second].matching_id;
											if (matched_module_id == UNKNOWN) { // a natural matching for a pool node
												if (gcg->GetNodeAttr(pair_tmp.first)->component->getType() != POOL)
													cout << "SBROME ERROR: The matched module id is UNKNOWN while the matched node type is " << gcg->GetNodeAttr(pair_tmp.first)->component->getType() << endl;
												else
													species_assignment[pair_tmp.first] = record_list[pair_tmp.first][pair_tmp.second].output;
												// push the fan-ins into the queue
												int number_of_fan_ins = gcg->InEdgeCount(pair_tmp.first);
												for (int i = 0; i < number_of_fan_ins; i++) {
													int fan_in_node_id_in_result_graph = gcg->GetInEdge(pair_tmp.first,i);
													if (gcg->GetNodeAttr(fan_in_node_id_in_result_graph)->component->getType() != INPUT) // i.e., not an input node of the result graph
														traverse_queue.push(std::make_pair(fan_in_node_id_in_result_graph,record_list[pair_tmp.first][pair_tmp.second].pre_node_record_list[i]));
												}
											}
											else {
												Module* matched_module = module_lib->at(matched_module_id);
												// Assign the name to the result graph nodes
												for (int i = 0; i < matching_map[matched_module_id]->at(matching_id).size(); i++) {
													int result_graph_node_id = matching_map[matched_module_id]->at(matching_id)[i].large_graph_node;
													int module_graph_node_id = matching_map[matched_module_id]->at(matching_id)[i].small_graph_node;
													if (!matched_module->is_input(module_graph_node_id) || gcg->GetNodeAttr(result_graph_node_id)->component->getType() == INPUT) {	// i.e., a global input or a non-input node of a module
														species_assignment[result_graph_node_id] = matched_module->GetNodeAttr(module_graph_node_id)->component->name;
														//if (matched_module->GetNodeAttr(module_graph_node_id)->component->getCategory() == CIRCUIT_SIGNAL)
														//	species_assignment[result_graph_node_id] = ((CircuitSignal*)matched_module->GetNodeAttr(module_graph_node_id)->component)->physical_instance->name;
														//else
														//	species_assignment[result_graph_node_id] = matched_module->GetNodeAttr(module_graph_node_id)->component->name;
													}
												}
												// push the fan-ins into the queue
												int number_of_fan_ins = module_lib->at(matched_module_id)->inputs.size();
												for (int i = 0; i < number_of_fan_ins; i++) {
													int fan_in_node_id_in_result_graph = matching_map[matched_module_id]->at(matching_id)[module_lib->at(matched_module_id)->inputs[i]].large_graph_node;
													if (gcg->GetNodeAttr(fan_in_node_id_in_result_graph)->component->getType() != INPUT) // i.e., not an input node of the result graph
														traverse_queue.push(std::make_pair(fan_in_node_id_in_result_graph,record_list[pair_tmp.first][pair_tmp.second].pre_node_record_list[i]));
												}
											}
										}
										// COMPARE THIS SPECIES NAME LIST WITH OTHER LISTS
										bool is_record_duplicated = false;
										//for (int j = 0; j < number_of_nodes; j++)
										//	cout << species_assignment[j] << "\t";
										//cout << endl;
										for (int record_id = 0; record_id < duplicate_checking.size(); record_id++) {
											//for (int j = 0; j < number_of_nodes; j++)
											//	cout << duplicate_checking[record_id][j] << "\t";
											//cout << endl;
											bool species_list_eq = true;
											for (int j = 0; j < number_of_nodes; j++)
												if (duplicate_checking[record_id][j].compare(species_assignment[j]) != STR_EQ) {
													species_list_eq = false;
													break;
												}
											if (species_list_eq) {
												is_record_duplicated = true;
												if (record_list[node_id][record_id].cost > composite_record_tmp.cost)
													record_list[node_id][record_id] = composite_record_tmp;
												break;
											}
										}
										if (is_record_duplicated)
											record_list[node_id].pop_back();
										else {
											if (is_a_heuristic_pass) { // sort all records by an increasing cost order
												record_list[node_id].pop_back(); // remove and then we will insert it into a right position with an increasing cost order
												int record_id;
												if (record_list[node_id].empty())
													record_id = -1;
												else {
													for (record_id = 0; record_id < record_list[node_id].size() - 1; record_id++)
														if (composite_record_tmp.cost >= record_list[node_id][record_id].cost && composite_record_tmp.cost <= record_list[node_id][record_id + 1].cost)
															break;
												}
												record_list[node_id].insert(record_list[node_id].begin() + record_id + 1, composite_record_tmp);
												duplicate_checking.insert(duplicate_checking.begin() + record_id + 1,species_assignment);
												if (is_a_heuristic_pass && record_list[node_id].size() == max_number_of_kept_records + 1) {
													record_list[node_id].pop_back();
													duplicate_checking.pop_back();
												}
											}
											else {
												duplicate_checking.push_back(species_assignment);
											}
										}
										// TEST HERE
										//cout << "^-^" << endl;
										// END TEST
									}
									//else
										//cout << "CROSS TALKING" << endl;
								}
								// Recover some input nodes of the module that we updated temporarily back to UNKNOWN
								for (int id_tmp = 0; id_tmp < temp_update_node_list.size(); id_tmp++)
									current_matched_module->GetNodeAttr(temp_update_node_list[id_tmp])->component->name = "UNKNOWN";
							}
							// Re-numbering
							idx_tmp = 0;
							while ((idx_tmp < number_of_fan_ins) && (numbering_array[idx_tmp] == record_list[fan_in_node_id_list[idx_tmp]].size() - 1)) {
								numbering_array[idx_tmp] = 0;
								idx_tmp++;
							}
							if (idx_tmp < number_of_fan_ins)
								numbering_array[idx_tmp]++;
						}
						while (idx_tmp < number_of_fan_ins);
					}
					delete [] fan_in_node_id_list;
					delete [] input_node_id_list;
					delete [] numbering_array;
				}
			}
		}
		// TEST HERE
		if (!is_a_heuristic_pass) {
			//cout << "****************************" << endl;
			//cout << "Node: " << node_id << " --- Number of records: "<< record_list[node_id].size() << endl;
			//for (int i = 0; i < record_list[node_id].size(); i++) {
			//	cout << "+++++++++++++ record " << i << "-th" << endl;
			//	record_list[node_id][i].Print();
			//}
			//cout << "****************************" << endl;
		}
		// END TEST
	}
	// Clear all new records
	double best_cost = UNKNOWN;
	int output_node_id = this->topo_order_list[number_of_nodes - 1];
	if (record_list[output_node_id].size() > 0) {
		best_cost = record_list[output_node_id][0].cost;
		for (int i = 1; i < record_list[output_node_id].size(); i++)
			if (record_list[output_node_id][i].cost < best_cost)
				best_cost = record_list[output_node_id][i].cost;
	}
	if (search_mode == HS_DP)	// Heuristic search for BB in DP
		for (int topo_id = starting_node_id; topo_id < number_of_nodes; topo_id++)
			this->record_list[this->topo_order_list[topo_id]].clear();
	//if (is_a_heuristic_pass)
	//	cout << "HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH Heuristic pass end HHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHHH" << endl;
	//else
	//	cout << "RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR Regular pass end RRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRRR" << endl;
	return best_cost;
}

void ModuleMatchingManager::Traceback(GeneCircuitGraph* output_gcg) {
	// Trace back to find the optimal solution
	int number_of_nodes = this->gcg->NodeCount();
	int output_node_id = this->topo_order_list[number_of_nodes - 1];
	int optimal_index = 0;
	if (record_list[output_node_id].size() > 0) {
		double optimal_cost = record_list[output_node_id][0].cost;
		for (int i = 1; i < record_list[output_node_id].size(); i++)
			if (record_list[output_node_id][i].cost < optimal_cost) {
				optimal_cost = record_list[output_node_id][i].cost;
				optimal_index = i;
			}
		queue<IdPair> traverse_queue;	// each pair contains the output node id (in the large graph) and the record id (i.e. the optimal record for this node)
		traverse_queue.push(std::make_pair(output_node_id, optimal_index));
		GeneCircuitGraph* result_gcg = gcg->clone();
		bool* is_deleted_node = new bool[gcg->NodeCount()];
		for (int i = 0; i < gcg->NodeCount(); i++)
			is_deleted_node[i] = true;
		while (!traverse_queue.empty()){
			IdPair pair_tmp = traverse_queue.front();
			traverse_queue.pop();
			int matched_module_id = record_list[pair_tmp.first][pair_tmp.second].module_id;
			int matching_id = record_list[pair_tmp.first][pair_tmp.second].matching_id;
			if (matched_module_id == UNKNOWN) { // a natural matching for a pool node
				if (result_gcg->GetNodeAttr(pair_tmp.first)->component->getType() != POOL)
					cout << "SBROME ERROR: The matched module id is UNKNOWN while the matched node type is " << result_gcg->GetNodeAttr(pair_tmp.first)->component->getType() << endl;
				else {
					is_deleted_node[pair_tmp.first] = false;
					result_gcg->GetNodeAttr(pair_tmp.first)->component->name = record_list[pair_tmp.first][pair_tmp.second].output;
				}
				// push the fan-ins into the queue
				int number_of_fan_ins = result_gcg->InEdgeCount(pair_tmp.first);
				for (int i = 0; i < number_of_fan_ins; i++) {
					int fan_in_node_id_in_result_graph = result_gcg->GetInEdge(pair_tmp.first,i);
					if (result_gcg->GetNodeAttr(fan_in_node_id_in_result_graph)->component->getType() != INPUT) // i.e., not an input node of the result graph
						traverse_queue.push(std::make_pair(fan_in_node_id_in_result_graph,record_list[pair_tmp.first][pair_tmp.second].pre_node_record_list[i]));
				}
			}
			else {
				Module* matched_module = module_lib->at(matched_module_id);
				// TEST HERE
				//cout << "Node id: " << pair_tmp.first << "\tRecord id: " << pair_tmp.second << "\tModule id: " << matched_module_id << "\tMatching id: " << matching_id << "\tTotal matches: " << matching_map[matched_module_id]->size() << endl;
				// END TEST
				// Assign the name to the result graph nodes
				for (int i = 0; i < matching_map[matched_module_id]->at(matching_id).size(); i++) {
					int result_graph_node_id = matching_map[matched_module_id]->at(matching_id)[i].large_graph_node;
					int module_graph_node_id = matching_map[matched_module_id]->at(matching_id)[i].small_graph_node;
					//if (matched_module->InEdgeCount(module_graph_node_id) > 0 || result_gcg->InEdgeCount(result_graph_node_id) == 0) {	// i.e., a global input or a non-input node of a module
					if (!matched_module->is_input(module_graph_node_id) || result_gcg->GetNodeAttr(result_graph_node_id)->component->getType() == INPUT) {	// i.e., a global input or a non-input node of a module
						is_deleted_node[result_graph_node_id] = false;
						result_gcg->GetNodeAttr(result_graph_node_id)->component->name = matched_module->GetNodeAttr(module_graph_node_id)->component->name;
						result_gcg->GetNodeAttr(result_graph_node_id)->module_name_list.push_back(matched_module->name);
						if (result_gcg->GetNodeAttr(result_graph_node_id)->component->getCategory() == CIRCUIT_SIGNAL)
							if (matched_module->GetNodeAttr(module_graph_node_id)->component->getCategory() == CIRCUIT_SIGNAL)
								((CircuitSignal*)result_gcg->GetNodeAttr(result_graph_node_id)->component)->physical_instance = ((CircuitSignal*)matched_module->GetNodeAttr(module_graph_node_id)->component)->physical_instance->clone();
							else
								((CircuitSignal*)result_gcg->GetNodeAttr(result_graph_node_id)->component)->physical_instance = matched_module->GetNodeAttr(module_graph_node_id)->component->clone();
					}
				}
				// push the fan-ins into the queue
				int number_of_fan_ins = module_lib->at(matched_module_id)->inputs.size();
				for (int i = 0; i < number_of_fan_ins; i++) {
					int fan_in_node_id_in_result_graph = matching_map[matched_module_id]->at(matching_id)[module_lib->at(matched_module_id)->inputs[i]].large_graph_node;
					if (result_gcg->GetNodeAttr(fan_in_node_id_in_result_graph)->component->getType() != INPUT) // i.e., not an input node of the result graph
						traverse_queue.push(std::make_pair(fan_in_node_id_in_result_graph,record_list[pair_tmp.first][pair_tmp.second].pre_node_record_list[i]));
				}
			}
		}
		ARGEdit final_editor;
		map<int,int> result_to_final;
		for (int i = 0; i < result_gcg->NodeCount(); i++)
			if (!is_deleted_node[i])
				result_to_final[i] = final_editor.InsertNode(result_gcg->GetNodeAttr(i)->clone());
		for (int i = 0; i < result_gcg->NodeCount(); i++)
			for (int j = 0; j < result_gcg->NodeCount(); j++)
				if (!is_deleted_node[i] && !is_deleted_node[j] && i != j && result_gcg->GetEdgeAttr(i,j) != NULL)
					final_editor.InsertEdge(result_to_final[i], result_to_final[j], result_gcg->GetEdgeAttr(i,j)->clone());
		output_gcg->ResetLoader(&final_editor);
		delete result_gcg;
		delete [] is_deleted_node;
	}
}

Framework::Framework(string database_filename, string input_filename): partDB(database_filename), dp(input_filename) {
	// Do nothing
}

RunningTimeInfo Framework::Optimize(int part_selection_mode, int variant_selection_mode, string output_filename) {
	RunningTimeInfo running_time;
	clock_t begin = clock();
	GeneCircuitGraph* expanded_gcg = dp.gcg.clone();
	// TEST HERE
	expanded_gcg->TestPrint(&std::cout);
	// END TEST
	double assembly_cost;
	GeneCircuitGraph* optimal_gcg = new GeneCircuitGraph;
	bool overtime = false;
	switch(part_selection_mode) {
		case ES: {
			vector<ExpansionResultInfo> expansion_list = partDB.TopologyExpansion(expanded_gcg);
			cout << "Number of possible topologies: " << expansion_list.size() << endl;
			assembly_cost = UNKNOWN;
			clock_t t0 = clock();
			//expansion_list[0].first->TestPrint(&std::cout);
			ModuleMatchingManager manager(expansion_list[0].first, &partDB);
			assembly_cost = manager.Match(DP, 0, MAX_NUM_OF_RECORD);
			//cout << assembly_cost << endl;
			if (assembly_cost > 0) {
				manager.Traceback(optimal_gcg);
				//optimal_gcg->TestPrint(&std::cout);
			}
			clock_t t1 = clock();
			double estimated_time = double(t1 - t0) / CLOCKS_PER_SEC;
			estimated_time *= expansion_list.size();
			if (estimated_time < MAX_RUNNING_TIME)
				for (int i = 1; i < expansion_list.size(); i++) {
					// TEST HERE
					if (i % 10 == 0)
						cout << i << endl;
					//expansion_list[i].first->TestPrint(&std::cout);
					// END TEST
					ModuleMatchingManager manager_tmp(expansion_list[i].first, &partDB);
					double cost = manager_tmp.Match(DP, 0, MAX_NUM_OF_RECORD);
					//cout << cost << endl;
					if (assembly_cost < 0 || (assembly_cost > cost && cost > 0)) {
						assembly_cost = cost;
						manager_tmp.Traceback(optimal_gcg);
					}
				}
			else {
				overtime = true;
				cout << "Overtime" << endl;
				running_time.module_matching_time = estimated_time;
			}
			break;
		}
		case HS:
		case DP: {
			int max_num_of_record = MAX_NUM_OF_RECORD;
			do {
				partDB.ExpandAndMergeTopology(expanded_gcg);
				// TEST HERE
				//expanded_gcg->TestPrint(&std::cout);
				// END TEST
				cout << "Expanded topology size: " << expanded_gcg->NodeCount() << endl;
				ModuleMatchingManager manager_tmp(expanded_gcg, &partDB);
				assembly_cost = manager_tmp.Match(part_selection_mode, 0, max_num_of_record);
				if (assembly_cost > 0)
					manager_tmp.Traceback(optimal_gcg);
				else
					max_num_of_record *= 2;
			} while (assembly_cost < 0 && max_num_of_record < 250);
			break;
		}
	}
	cout << "COST = " << assembly_cost << endl;
	// TEST HERE
	if (assembly_cost >= 0)
		optimal_gcg->TestPrint(&std::cout);
	// END TEST
	clock_t end = clock();
	if (!overtime)
		running_time.module_matching_time = double(end - begin) / CLOCKS_PER_SEC;
	cout << "Running time: " << running_time.module_matching_time << endl;
	/*
	if (ds.gcg.NodeCount() != 0) {
		bool is_zero_input_matrix = true;
		for (int row = 0; row < dp.desired_behavior.input_values.size(); row++) {
			for (int col = 0; col < dp.desired_behavior.input_values[row].size(); col++)
				if (dp.desired_behavior.input_values[row][col] != 0) {
					is_zero_input_matrix = false;
					break;
				}
			if (!is_zero_input_matrix)
				break;
		}
		if (is_zero_input_matrix) { // Module matching only
			ds.simulation_behavior.outputs.clear();
			ds.simulation_behavior.output_values.clear();
		}
		else {	// Mutant search here
			cout << "OPTIMIZING ..." << endl;
			switch (variant_selection_mode) {
				case SI: {	// Simulation only
					Module* module_tmp = new Module(ds.gcg.ConvertToLoader(), dp.desired_behavior.inputs, dp.desired_behavior.outputs);
					DynamicGeneCircuit dgc(module_tmp);
					dgc.SimulateSteadyState(&partDB, dp.desired_behavior.input_values, dp.desired_behavior.output_values);
					ds.simulation_behavior = dp.desired_behavior;
					running_time.mutant_searching_time = 0;
					break;
				}
				case ES: {	// Exhaustive search
					break;
				}
				case MS: {	// Modular search
					break;
				}
				case HS: {	// Genetic algorithm search
					break;
				}
				default:
					cout << variant_selection_mode << ": No such variant selection mode" << endl;
					break;
			}
			map<int,NodeVisualInfo*> visual_info_list;
			UpdateVisualInfo(&visual_info_list);
			NodeVisualInfoMap nvim;
			WriteOutputFile(output_filename, &nvim);
		}
	}
	else
		cout << "No solution" << endl;
	*/
	return running_time;
}

void Framework::WriteOutputFile(string output_filename, NodeVisualInfoMap* nvim) {
	IdList inputs, outputs;
	GeneCircuitGraph* gcg = &ds.gcg;
	for (int i = 0; i < gcg->NodeCount(); i++) {
		if (gcg->GetNodeAttr(i)->component->getType() == INPUT)
			inputs.push_back(i);
		if (gcg->GetNodeAttr(i)->component->getType() == OUTPUT)
			outputs.push_back(i);
	}
	// Assign colors
	string color_array[] = {"FF3333","006600","99FF33","66B2FF","0000CC","FFCCCC","000066","E6FFCC","CCCCFF","FF6666","B3FF66","FFFF00"};
	map<string,string> module_id_to_color;
	int current_color = 0;
	for (int i = 0; i < gcg->NodeCount(); i++)
		if (gcg->GetNodeAttr(i)->component->getCategory() == MOLECULE)
			if (module_id_to_color.find(gcg->GetNodeAttr(i)->module_name_list[0]) == module_id_to_color.end()) {
				module_id_to_color[gcg->GetNodeAttr(i)->module_name_list[0]] = color_array[current_color];
				current_color++;
				if (current_color == 10)
					cout << "Out of color!!!" << endl;
			}
	ofstream myfile (output_filename.c_str());
	if (myfile.is_open()) {
		// WRITE HEADER
		string TEXT1 = "<mxGraphModel grid=\"1\" guides=\"1\" tooltips=\"1\" connect=\"1\" fold=\"1\" page=\"0\" pageScale=\"1\" pageWidth=\"826\" pageHeight=\"1169\">";
		myfile << TEXT1 << "\n";
		TEXT1 = "<root>";
		myfile << TEXT1 << "\n";
		TEXT1 = "<mxCell id=\"0\"/>";
		myfile << TEXT1 << "\n";
		TEXT1 = "<mxCell id=\"1\" parent=\"0\"/>";
		myfile << TEXT1 << "\n";
		int number_of_cells = 0;
		// WRITE NODES
		double graph_border_y = 0;
		for (int node_id = 0; node_id < gcg->NodeCount(); node_id++) {
			number_of_cells++;
			string node_name = gcg->GetNodeAttr(node_id)->component->name;
			XMLNode dummy_node;
			XMLNode xml_node = dummy_node.createXMLTopNode("mxCell");
			xml_node.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
			xml_node.addAttribute("value", node_name.c_str());
			string node_style;
			if (gcg->GetNodeAttr(node_id)->component->getCategory() == MOLECULE) {
				switch (gcg->GetNodeAttr(node_id)->component->getType()) {
					case m_RNA:
						node_style = "shape=mrna;whiteSpace=wrap;strokeColor=none";
						break;
					case PROTEIN:
						node_style = "shape=protein;whiteSpace=wrap;strokeColor=none";
						break;
					case LIGAND:
						node_style = "shape=ligand;whiteSpace=wrap;strokeColor=none";
						break;
					case PROTEIN_COMPLEX:
						node_style = "shape=protein-protein;whiteSpace=wrap;strokeColor=none";
						break;
					case LIGAND_PROTEIN_COMPLEX:
						node_style = "shape=ligand-protein;whiteSpace=wrap;strokeColor=none";
						break;
					case RNA_COMPLEX:
						node_style = "shape=rna-rna;whiteSpace=wrap;strokeColor=none";
						break;
					case POOL:
						node_style = "round=1";
						break;

				}
				node_style += ";gradientColor=#" + module_id_to_color[gcg->GetNodeAttr(node_id)->module_name_list[0]];
			}
			else if (gcg->GetNodeAttr(node_id)->component->getCategory() == LOGIC_GATE) {
				switch (gcg->GetNodeAttr(node_id)->component->getType()) {
					case YES_GATE:
						node_style = "shape=yes_gate";
						break;
					case NOT_GATE:
						node_style = "shape=not_gate";
						break;
					case AND_GATE:
						node_style = "shape=and_gate";
						break;
					case OR_GATE:
						node_style = "shape=or_gate_aux";
						break;
				}
			}
			else if (gcg->GetNodeAttr(node_id)->component->getCategory() == CIRCUIT_SIGNAL) {
				switch (gcg->GetNodeAttr(node_id)->component->getType()) {
					case INPUT:
						node_style = "shape=input";
						break;
					case OUTPUT:
						node_style = "shape=output";
						break;
				}
			}
			if (node_name.length() > 0) {
				double font_size = (*nvim)[node_id]->width/node_name.length();
				node_style += ";fontSize=" + Num2Str(font_size);
			}
			node_style += ";strokeWidth=" + Num2Str((*nvim)[node_id]->line_width);
			xml_node.addAttribute("style", node_style.c_str());
			xml_node.addAttribute("vertex", "1");
			xml_node.addAttribute("parent", "1");
			// Add a geometry child
			XMLNode geometry_node = xml_node.addChild("mxGeometry");
			geometry_node.addAttribute("x", Num2Str((*nvim)[node_id]->pos_x).c_str());
			geometry_node.addAttribute("y", Num2Str((*nvim)[node_id]->pos_y).c_str());
			geometry_node.addAttribute("width", Num2Str((*nvim)[node_id]->width).c_str());
			geometry_node.addAttribute("height", Num2Str((*nvim)[node_id]->height).c_str());
			geometry_node.addAttribute("as","geometry");
			if (graph_border_y < ((*nvim)[node_id]->pos_y + (*nvim)[node_id]->height))
				graph_border_y = (*nvim)[node_id]->pos_y + (*nvim)[node_id]->height;
			char* XMLstr = xml_node.createXMLString();
			myfile << XMLstr << "\n";
			delete []XMLstr;
		}
		// WRITE EDGES
		XMLNode dummy_node;
		for (int src_node_id = 0; src_node_id < gcg->NodeCount(); src_node_id++) {
			for (int dest_node_id = 0; dest_node_id < gcg->NodeCount(); dest_node_id++) {
				if (src_node_id != dest_node_id && gcg->GetEdgeAttr(src_node_id, dest_node_id) != NULL) {
					number_of_cells++;
					XMLNode xml_node = dummy_node.createXMLTopNode("mxCell");
					xml_node.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
					xml_node.addAttribute("value","");
					double line_width = ((*nvim)[src_node_id]->line_width < (*nvim)[dest_node_id]->line_width)?((*nvim)[src_node_id]->line_width):((*nvim)[dest_node_id]->line_width);
					string edge_style = "edgeStyle=elbowEdgeStyle;elbow=horizontal";
					switch (gcg->GetEdgeAttr(src_node_id, dest_node_id)->type) {
						case ACTIVATORY:
							edge_style += ";endArrow=classic";
							break;
						case INHIBITORY:
							edge_style += ";endArrow=oval";
							break;
						case UNKNOWN:
							edge_style += ";endArrow=none";
							break;
					}
					edge_style += ";exitX=1;exitY=0.5;entryX=0;entryY=0.5";
					edge_style += ";strokeWidth=" + Num2Str(line_width) + ";endSize=" + Num2Str(line_width*5);
					xml_node.addAttribute("style",edge_style.c_str());
					xml_node.addAttribute("edge","1");
					xml_node.addAttribute("parent","1");
					xml_node.addAttribute("source",Num2Str(src_node_id + 2).c_str());
					xml_node.addAttribute("target",Num2Str(dest_node_id + 2).c_str());
					// Add a geometry child
					XMLNode geometry_node = xml_node.addChild("mxGeometry");
					geometry_node.addAttribute("width","100");
					geometry_node.addAttribute("height","100");
					geometry_node.addAttribute("as","geometry");
					XMLNode mxpoint_node_1 = geometry_node.addChild("mxPoint");
					mxpoint_node_1.addAttribute("y","100");
					mxpoint_node_1.addAttribute("as","sourcePoint");
					XMLNode mxpoint_node_2 = geometry_node.addChild("mxPoint");
					mxpoint_node_2.addAttribute("x","100");
					mxpoint_node_2.addAttribute("as","targetPoint");
					char* XMLstr = xml_node.createXMLString();
					myfile << XMLstr << "\n";
					delete []XMLstr;
				}
			}
		}
		// WRITE THE SIMULATION DATA
		if (!ds.simulation_behavior.input_values.empty() && !ds.simulation_behavior.output_values.empty()) {
			double data_x = 100;
			double data_y = graph_border_y + 100;
			double data_w = 400;
			double data_h = 200;
			double data_point_h = 10;
			// X_AXIS
			number_of_cells++;
			XMLNode xml_node1 = dummy_node.createXMLTopNode("mxCell");
			xml_node1.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
			xml_node1.addAttribute("value", "");
			xml_node1.addAttribute("style", "line;rotation=0;strokeWidth=3");
			xml_node1.addAttribute("vertex", "1");
			xml_node1.addAttribute("parent", "1");
			// Add a geometry child
			XMLNode geometry_node1 = xml_node1.addChild("mxGeometry");
			geometry_node1.addAttribute("x", Num2Str(data_x).c_str());
			geometry_node1.addAttribute("y", Num2Str(data_y + data_h + data_point_h).c_str());
			geometry_node1.addAttribute("width", Num2Str(data_w).c_str());
			geometry_node1.addAttribute("height", "1");
			geometry_node1.addAttribute("as","geometry");
			char* XMLstr = xml_node1.createXMLString();
			//cout << XMLstr << endl;
			myfile << XMLstr << "\n";
			delete []XMLstr;
			// Y_AXIS
			number_of_cells++;
			XMLNode xml_node2 = dummy_node.createXMLTopNode("mxCell");
			xml_node2.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
			xml_node2.addAttribute("value", "");
			xml_node2.addAttribute("style", "line;rotation=90;strokeWidth=3");
			xml_node2.addAttribute("vertex", "1");
			xml_node2.addAttribute("parent", "1");
			// Add a geometry child
			XMLNode geometry_node2 = xml_node2.addChild("mxGeometry");
			geometry_node2.addAttribute("x", Num2Str(data_x - data_h/2).c_str());
			geometry_node2.addAttribute("y", Num2Str(data_y + data_point_h).c_str());
			geometry_node2.addAttribute("width", Num2Str(data_h).c_str());
			geometry_node2.addAttribute("height", Num2Str(data_h).c_str());
			geometry_node2.addAttribute("as","geometry");
			XMLstr = xml_node2.createXMLString();
			//cout << XMLstr << endl;
			myfile << XMLstr << "\n";
			delete []XMLstr;
			// DATA POINTS
			double max_concentration = 0;
			for (int row = 0; row < dp.desired_behavior.output_values.size(); row++) {
				if (max_concentration < dp.desired_behavior.output_values[row][0])
					max_concentration = dp.desired_behavior.output_values[row][0];
				if (max_concentration < ds.simulation_behavior.output_values[row][0])
					max_concentration = ds.simulation_behavior.output_values[row][0];
			}
			// X_LABEL
			for (int col = 0; col < dp.desired_behavior.input_values[0].size(); col++) {
				number_of_cells++;
				XMLNode xml_x_label = dummy_node.createXMLTopNode("mxCell");
				xml_x_label.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
				cout << dp.desired_behavior.inputs[col] << endl;
				string tmp = "[" + gcg->GetNodeAttr(inputs[col])->component->name + "]";
				xml_x_label.addAttribute("value", tmp.c_str());
				xml_x_label.addAttribute("style", "text");
				xml_x_label.addAttribute("vertex", "1");
				xml_x_label.addAttribute("parent", "1");
				// Add a geometry child
				XMLNode geometry_x_label = xml_x_label.addChild("mxGeometry");
				geometry_x_label.addAttribute("x", Num2Str(data_x + 5).c_str());
				geometry_x_label.addAttribute("y", Num2Str(data_y + data_h + data_point_h + col*20 + 20).c_str());
				geometry_x_label.addAttribute("width", "10");
				geometry_x_label.addAttribute("height", "10");
				geometry_x_label.addAttribute("as","geometry");
				XMLstr = xml_x_label.createXMLString();
				//cout << XMLstr << endl;
				myfile << XMLstr << "\n";
				delete []XMLstr;
			}
			for (int row = 0; row < dp.desired_behavior.output_values.size(); row++) {
				// X_STICK
				for (int col = 0; col < dp.desired_behavior.input_values[0].size(); col++) {
					number_of_cells++;
					XMLNode xml_x_label = dummy_node.createXMLTopNode("mxCell");
					xml_x_label.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
					xml_x_label.addAttribute("value", Num2Str(dp.desired_behavior.input_values[row][col]).c_str());
					xml_x_label.addAttribute("style", "text");
					xml_x_label.addAttribute("vertex", "1");
					xml_x_label.addAttribute("parent", "1");
					// Add a geometry child
					XMLNode geometry_x_label = xml_x_label.addChild("mxGeometry");
					geometry_x_label.addAttribute("x", Num2Str(data_w*(row + 1)/(dp.desired_behavior.output_values.size() + 1) + data_x).c_str());
					geometry_x_label.addAttribute("y", Num2Str(data_y + data_h + data_point_h + col*20 + 20).c_str());
					geometry_x_label.addAttribute("width", "10");
					geometry_x_label.addAttribute("height", "10");
					geometry_x_label.addAttribute("as","geometry");
					XMLstr = xml_x_label.createXMLString();
					//cout << XMLstr << endl;
					myfile << XMLstr << "\n";
					delete []XMLstr;
				}
				// DESIRED VALUE
				number_of_cells++;
				XMLNode xml_node1 = dummy_node.createXMLTopNode("mxCell");
				xml_node1.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
				xml_node1.addAttribute("value", "");
				xml_node1.addAttribute("style", "ellipse;whiteSpace=wrap;fillColor=#6666FF");
				xml_node1.addAttribute("vertex", "1");
				xml_node1.addAttribute("parent", "1");
				// Add a geometry child
				XMLNode geometry_node1 = xml_node1.addChild("mxGeometry");
				geometry_node1.addAttribute("x", Num2Str(data_w*(row + 1)/(dp.desired_behavior.output_values.size() + 1) + data_x).c_str());
				geometry_node1.addAttribute("y", Num2Str(data_y + data_h - 0.9*data_h*dp.desired_behavior.output_values[row][0]/max_concentration).c_str());
				geometry_node1.addAttribute("width", "10");
				geometry_node1.addAttribute("height", "10");
				geometry_node1.addAttribute("as","geometry");
				XMLstr = xml_node1.createXMLString();
				//cout << XMLstr << endl;
				myfile << XMLstr << "\n";
				delete []XMLstr;
				// SIMULATED VALUE
				number_of_cells++;
				XMLNode xml_node2 = dummy_node.createXMLTopNode("mxCell");
				xml_node2.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
				xml_node2.addAttribute("value", "");
				xml_node2.addAttribute("style", "rhombus;whiteSpace=wrap;fillColor=#CC0000");
				xml_node2.addAttribute("vertex", "1");
				xml_node2.addAttribute("parent", "1");
				// Add a geometry child
				XMLNode geometry_node2 = xml_node2.addChild("mxGeometry");
				geometry_node2.addAttribute("x", Num2Str(data_w*(row + 1)/(dp.desired_behavior.output_values.size() + 1) + data_x).c_str());
				geometry_node2.addAttribute("y", Num2Str(data_y + data_h - 0.9*data_h*ds.simulation_behavior.output_values[row][0]/max_concentration).c_str());
				geometry_node2.addAttribute("width", "10");
				geometry_node2.addAttribute("height", "10");
				geometry_node2.addAttribute("as","geometry");
				XMLstr = xml_node2.createXMLString();
				//cout << XMLstr << endl;
				myfile << XMLstr << "\n";
				delete []XMLstr;
			}
			// Y_LABEL
			number_of_cells++;
			XMLNode xml_y_label = dummy_node.createXMLTopNode("mxCell");
			xml_y_label.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
			string tmp = "[" + gcg->GetNodeAttr(outputs[0])->component->name + "]";
			xml_y_label.addAttribute("value", tmp.c_str());
			xml_y_label.addAttribute("style", "text");
			xml_y_label.addAttribute("vertex", "1");
			xml_y_label.addAttribute("parent", "1");
			// Add a geometry child
			XMLNode geometry_y_label = xml_y_label.addChild("mxGeometry");
			geometry_y_label.addAttribute("x", Num2Str(data_x - 40).c_str());
			geometry_y_label.addAttribute("y", Num2Str(data_y + data_point_h).c_str());
			geometry_y_label.addAttribute("width", "10");
			geometry_y_label.addAttribute("height", "10");
			geometry_y_label.addAttribute("as","geometry");
			XMLstr = xml_y_label.createXMLString();
			//cout << XMLstr << endl;
			myfile << XMLstr << "\n";
			delete []XMLstr;
			// LEGEND
			// DESIRED LEGEND
			number_of_cells++;
			XMLNode xml_desired_legend = dummy_node.createXMLTopNode("mxCell");
			xml_desired_legend.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
			xml_desired_legend.addAttribute("value", "Desired");
			xml_desired_legend.addAttribute("style", "text");
			xml_desired_legend.addAttribute("vertex", "1");
			xml_desired_legend.addAttribute("parent", "1");
			// Add a geometry child
			XMLNode geometry_desired_legend = xml_desired_legend.addChild("mxGeometry");
			geometry_desired_legend.addAttribute("x", Num2Str(data_x + data_w + 20).c_str());
			geometry_desired_legend.addAttribute("y", Num2Str(data_y - 20).c_str());
			geometry_desired_legend.addAttribute("width", "10");
			geometry_desired_legend.addAttribute("height", "10");
			geometry_desired_legend.addAttribute("as","geometry");
			XMLstr = xml_desired_legend.createXMLString();
			//cout << XMLstr << endl;
			myfile << XMLstr << "\n";
			delete []XMLstr;
			// DESIRED ICON
			number_of_cells++;
			xml_desired_legend = dummy_node.createXMLTopNode("mxCell");
			xml_desired_legend.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
			xml_desired_legend.addAttribute("value", "");
			xml_desired_legend.addAttribute("style", "ellipse;whiteSpace=wrap;fillColor=#6666FF");
			xml_desired_legend.addAttribute("vertex", "1");
			xml_desired_legend.addAttribute("parent", "1");
			// Add a geometry child
			geometry_desired_legend = xml_desired_legend.addChild("mxGeometry");
			geometry_desired_legend.addAttribute("x", Num2Str(data_x + data_w).c_str());
			geometry_desired_legend.addAttribute("y", Num2Str(data_y + data_point_h - 20).c_str());
			geometry_desired_legend.addAttribute("width", "10");
			geometry_desired_legend.addAttribute("height", "10");
			geometry_desired_legend.addAttribute("as","geometry");
			XMLstr = xml_desired_legend.createXMLString();
			//cout << XMLstr << endl;
			myfile << XMLstr << "\n";
			delete []XMLstr;
			// SIMULATION LEGEND
			number_of_cells++;
			xml_desired_legend = dummy_node.createXMLTopNode("mxCell");
			xml_desired_legend.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
			xml_desired_legend.addAttribute("value", "Simulation");
			xml_desired_legend.addAttribute("style", "text");
			xml_desired_legend.addAttribute("vertex", "1");
			xml_desired_legend.addAttribute("parent", "1");
			// Add a geometry child
			geometry_desired_legend = xml_desired_legend.addChild("mxGeometry");
			geometry_desired_legend.addAttribute("x", Num2Str(data_x + data_w + 20).c_str());
			geometry_desired_legend.addAttribute("y", Num2Str(data_y).c_str());
			geometry_desired_legend.addAttribute("width", "10");
			geometry_desired_legend.addAttribute("height", "10");
			geometry_desired_legend.addAttribute("as","geometry");
			XMLstr = xml_desired_legend.createXMLString();
			//cout << XMLstr << endl;
			myfile << XMLstr << "\n";
			delete []XMLstr;
			// SIMULATION ICON
			number_of_cells++;
			xml_desired_legend = dummy_node.createXMLTopNode("mxCell");
			xml_desired_legend.addAttribute("id", Num2Str(number_of_cells + 1).c_str());
			xml_desired_legend.addAttribute("value", "");
			xml_desired_legend.addAttribute("style", "rhombus;whiteSpace=wrap;fillColor=#CC0000");
			xml_desired_legend.addAttribute("vertex", "1");
			xml_desired_legend.addAttribute("parent", "1");
			// Add a geometry child
			geometry_desired_legend = xml_desired_legend.addChild("mxGeometry");
			geometry_desired_legend.addAttribute("x", Num2Str(data_x + data_w).c_str());
			geometry_desired_legend.addAttribute("y", Num2Str(data_y + data_point_h).c_str());
			geometry_desired_legend.addAttribute("width", "10");
			geometry_desired_legend.addAttribute("height", "10");
			geometry_desired_legend.addAttribute("as","geometry");
			XMLstr = xml_desired_legend.createXMLString();
			//cout << XMLstr << endl;
			myfile << XMLstr << "\n";
		}
		// WRITE FOOTER
		myfile << "</root>" << "\n" << "</mxGraphModel>";
    }
	myfile.close();
}

void Framework::UpdateVisualInfo(map<int,NodeVisualInfo*>* visual_info_list) {
	map<int,NodeVisualInfo*>* current_visual_info_list = new map<int,NodeVisualInfo*>;
	//for (int i = 0; i < expanded_gcg.NodeCount(); i++)
	//	if (visual_info_list->find(i) != visual_info_list->end())
	//			(*current_visual_info_list)[i] = (*visual_info_list)[i];
	GeneCircuitGraph* current_gcg; // = expanded_gcg.clone();
	// TEST HERE
	//cout << "~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
	//current_gcg->TestPrint(&std::cout);
	//cout << "~~~~~~~" << endl;
	//for (int i = 0; i < current_gcg->NodeCount(); i++)
	//	if (current_visual_info_list->find(i) == current_visual_info_list->end())
	//		cout << i << endl;
	//	else {
	//		cout << i << "\t";
	//		(*current_visual_info_list)[i]->Print(&std::cout);
	//	}
	//cout << "~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
	// END TEST
	IdList empty_gate_type_list;
	vector<NodeVisualInfo*> empty_gate_type_visual_info_list;
	if (ds.exp_info.size())
		for (int step = 0; step < ds.exp_info.size(); step++) {
			int expanded_node_id = ds.exp_info[step].expanded_node_id; // expanded node id
			// save the expanded gate node
			empty_gate_type_list.push_back(current_gcg->GetNodeAttr(expanded_node_id)->component->getType());
			empty_gate_type_visual_info_list.push_back((*current_visual_info_list)[expanded_node_id]);
			// load the module
			vector<NodeVisualInfo> *module_visual_info_list = new vector<NodeVisualInfo>;
			Module* expansion_module = partDB.loadMotifTopology(ds.exp_info[step].motif_name, module_visual_info_list);
			// determine all input nodes
			bool* is_input = new bool[expansion_module->NodeCount()];
			for (int i_tmp = 0; i_tmp < expansion_module->NodeCount(); i_tmp++)
				is_input[i_tmp] = false;
			for (int i_tmp = 0; i_tmp < expansion_module->inputs.size(); i_tmp++)
				is_input[i_tmp] = true;
			// TEST HERE
			//cout << "++++++++++++++++++++++++++++++++" << endl;
			//current_gcg->TestPrint(&std::cout);
			//cout << ds.exp_info[step].expanded_node_id << "\t" << ds.exp_info[step].motif_name << endl;
			//cout << "______________" << endl;
			//expansion_module->TestPrint(&std::cout);
			//cout << "++++++++++++++++++++++++++++++++" << endl;
			// END TEST
			ARGEdit* module_editor_tmp = new ARGEdit;
			map<int,int> old_to_new, module_to_new;
			// Add nodes
			for (int i = 0; i < current_gcg->NodeCount(); i++)
				if (i != expanded_node_id)
					old_to_new[i] = module_editor_tmp->InsertNode(current_gcg->GetNodeAttr(i)->clone());
			for (int i = 0; i < expansion_module->NodeCount(); i++)
				if (!is_input[i])
					module_to_new[i] = module_editor_tmp->InsertNode(expansion_module->GetNodeAttr(i)->clone());
			// Add edges
			for (int i = 0; i < current_gcg->NodeCount(); i++)
					for (int j = 0; j < current_gcg->NodeCount(); j++)
						if (i != expanded_node_id && j != expanded_node_id && i != j && current_gcg->GetEdgeAttr(i,j) != NULL)
							module_editor_tmp->InsertEdge(old_to_new[i], old_to_new[j], current_gcg->GetEdgeAttr(i,j)->clone());
			for (int i = 0; i < expansion_module->NodeCount(); i++)
				for (int j = 0; j < expansion_module->NodeCount(); j++)
					if (!is_input[i] && !is_input[j] && i != j && expansion_module->GetEdgeAttr(i,j) != NULL)
						module_editor_tmp->InsertEdge(module_to_new[i], module_to_new[j], expansion_module->GetEdgeAttr(i,j)->clone());
			// Update the visual information
			double x_min = 10000, y_min = 10000, x_max = 0, y_max = 0;
			for (unsigned int node_id = 0; node_id < module_visual_info_list->size(); node_id++)
				if (!is_input[node_id]){
					if (module_visual_info_list->at(node_id).pos_x < x_min)
						x_min = module_visual_info_list->at(node_id).pos_x;
					if (module_visual_info_list->at(node_id).pos_x + module_visual_info_list->at(node_id).width > x_max)
						x_max = module_visual_info_list->at(node_id).pos_x + module_visual_info_list->at(node_id).width;
					if (module_visual_info_list->at(node_id).pos_y < y_min)
						y_min = module_visual_info_list->at(node_id).pos_y;
					if (module_visual_info_list->at(node_id).pos_y + module_visual_info_list->at(node_id).height > y_max)
						y_max = module_visual_info_list->at(node_id).pos_y + module_visual_info_list->at(node_id).height;
				}
			double w_z = x_max - x_min;
			double h_z = y_max - y_min;
			double x_parent, y_parent, w_parent, h_parent;	// visual information of the parent node
			double x_c, y_c, w_c, h_c; 	// visual information of the container
			x_parent = (*current_visual_info_list)[expanded_node_id]->pos_x;	// visual information of the parent node
			y_parent = (*current_visual_info_list)[expanded_node_id]->pos_y;
			w_parent = (*current_visual_info_list)[expanded_node_id]->width;
			h_parent = (*current_visual_info_list)[expanded_node_id]->height;
			switch (current_gcg->GetNodeAttr(expanded_node_id)->component->getType()) {
				case YES_GATE:
					x_c = x_parent + 0.03*w_parent;
					y_c = y_parent + 0.25*h_parent;
					w_c = 0.8*w_parent;
					h_c = 0.5*h_parent;
					break;
				case NOT_GATE:
					x_c = x_parent + 0.03*w_parent;
					y_c = y_parent + 0.25*h_parent;
					w_c = 0.7*w_parent;	// to void the negation circle
					h_c = 0.5*h_parent;
					break;
				case AND_GATE:
					x_c = x_parent + 0.05*w_parent;
					y_c = y_parent + 0.1*h_parent;
					w_c = 0.9*w_parent;
					h_c = 0.8*h_parent;
					break;
				case OR_GATE:
					x_c = x_parent + 0.5*w_parent;
					y_c = y_parent + 0.25*h_parent;
					w_c = 0.5*w_parent;
					h_c = 0.5*h_parent;
					break;
				default:
					cout << "Error: Visual information of gate " << Id2Str(current_gcg->GetNodeAttr(expanded_node_id)->component->getType()) << " has not been defined yet" << endl;
					break;
			}
			map<int,NodeVisualInfo*>* visual_info_list_tmp = new map<int,NodeVisualInfo*>;
			for (int i = 0; i < current_gcg->NodeCount(); i++)
				if (i != expanded_node_id) {
					if (current_visual_info_list->find(i) != current_visual_info_list->end())
						(*visual_info_list_tmp)[old_to_new[i]] = (*current_visual_info_list)[i];
				}
			for (int i = 0; i < expansion_module->NodeCount(); i++) {
				if (!is_input[i]) {
					double x = module_visual_info_list->at(i).pos_x;
					double y = module_visual_info_list->at(i).pos_y;
					double w = module_visual_info_list->at(i).width;
					double h = module_visual_info_list->at(i).height;
					if (w_c/w_z < h_c/h_z) { // scale by x-axis
						double scale = w_c/w_z;
						(*visual_info_list_tmp)[module_to_new[i]] = new NodeVisualInfo((x-x_min)*scale + x_c, (y-y_min)*scale + y_c + h_c/2 - h_z*scale/2, w*scale, h*scale, scale);
					}
					else {	// scale by y-axis
						double scale = h_c/h_z;
						(*visual_info_list_tmp)[module_to_new[i]] = new NodeVisualInfo((x-x_min)*scale + x_c + w_c/2 - w_z*scale/2 , (y-y_min)*scale + y_c, w*scale, h*scale, scale);
					}
				}
			}
			//delete current_visual_info_list;
			current_visual_info_list = visual_info_list_tmp;
			if (expansion_module->inputs.size() == 1) {
				// Add a connection between the old input node to the expanded module
				int pre_input = current_gcg->GetInEdge(expanded_node_id,0);	// the node that connects to the expanded node
				int succ_input = expansion_module->GetOutEdge(expansion_module->inputs[0],0);
				module_editor_tmp->InsertEdge(old_to_new[pre_input], module_to_new[succ_input], expansion_module->GetEdgeAttr(expansion_module->inputs[0], succ_input)->clone());
			}
			else if (expansion_module->inputs.size() == 2) {
				// Add a connection between the old input node to the expanded module
				int succ_input_1 = expansion_module->GetOutEdge(expansion_module->inputs[0],0);
				int succ_input_2 = expansion_module->GetOutEdge(expansion_module->inputs[1],0);
				module_editor_tmp->InsertEdge(old_to_new[ds.exp_info[step].input_permutation[0]], module_to_new[succ_input_1], expansion_module->GetEdgeAttr(expansion_module->inputs[0], succ_input_1)->clone());
				module_editor_tmp->InsertEdge(old_to_new[ds.exp_info[step].input_permutation[1]], module_to_new[succ_input_2], expansion_module->GetEdgeAttr(expansion_module->inputs[1], succ_input_2)->clone());
			}
			else {
				cout << "ERROR: Device has more that two inputs" << endl;
			}
			int number_of_succ_nodes = current_gcg->OutEdgeCount(expanded_node_id);
			for (int i = 0; i < number_of_succ_nodes; i++)
				module_editor_tmp->InsertEdge(module_to_new[expansion_module->outputs[0]], old_to_new[current_gcg->GetOutEdge(expanded_node_id,i)], new BioNetEdge());
			if (step == ds.exp_info.size() - 1) {
				for (int i = 0; i < module_editor_tmp->NodeCount(); i++) {
					((BioNetNode*) module_editor_tmp->GetNodeAttr(i))->component->name = ds.gcg.GetNodeAttr(i)->component->name;
					((BioNetNode*) module_editor_tmp->GetNodeAttr(i))->module_name_list = ds.gcg.GetNodeAttr(i)->module_name_list;
				}

				for (int i = empty_gate_type_list.size() - 1; i >= 0 ; i--) {
					int node_id_tmp = module_editor_tmp->InsertNode(CreateBioNetNode(Id2Str(empty_gate_type_list[i])));
					(*current_visual_info_list)[node_id_tmp] = empty_gate_type_visual_info_list[i];
				}
			}
			delete current_gcg;
			current_gcg = new GeneCircuitGraph(module_editor_tmp);
			// TEST HERE
			//cout << "~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
			//current_gcg->TestPrint(&std::cout);
			//cout << "~~~~~~~" << endl;
			//for (int i = 0; i < current_gcg->NodeCount(); i++)
			//	if (current_visual_info_list->find(i) == current_visual_info_list->end())
			//		cout << i << endl;
			//	else {
			//		cout << i << "\t";
			//		(*current_visual_info_list)[i]->Print(&std::cout);
			//	}
			//cout << "~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
			// END TEST
			delete [] is_input;
		}
	else { // When there is no expansion
		for (int i = 0; i < current_gcg->NodeCount(); i++)
			((BioNetNode*) current_gcg->GetNodeAttr(i))->component->name = ds.gcg.GetNodeAttr(i)->component->name;
	}
	// Remove all linkers here
	map<int,int> old_to_remove;
	ARGEdit* editor = new ARGEdit;
	/*
	for (int i = current_gcg->NodeCount() - 1; i >= 0 ; i--)
		if (current_gcg->GetNodeAttr(i)->component->getCategory() != CIRCUIT_SIGNAL || current_gcg->GetNodeAttr(i)->component->getType() != LINKER) {
			old_to_remove[i] = editor->InsertNode(current_gcg->GetNodeAttr(i)->clone());
			(*visual_info_list)[old_to_remove[i]] = (*current_visual_info_list)[i];
		}
	for (int i = 0; i < current_gcg->NodeCount(); i++)
		for (int j = 0; j < current_gcg->NodeCount(); j++)
			if (i != j && current_gcg->GetEdgeAttr(i,j) != NULL)
				if (current_gcg->GetNodeAttr(i)->component->getCategory() == CIRCUIT_SIGNAL && current_gcg->GetNodeAttr(i)->component->getType() == LINKER)
					editor->InsertEdge(old_to_remove[current_gcg->GetInEdge(i,0)], old_to_remove[j], new BioNetEdge);
				else if (current_gcg->GetNodeAttr(j)->component->getCategory() != CIRCUIT_SIGNAL || current_gcg->GetNodeAttr(j)->component->getType() != LINKER)
					editor->InsertEdge(old_to_remove[i], old_to_remove[j], current_gcg->GetEdgeAttr(i,j)->clone());
	*/
	current_gcg = new GeneCircuitGraph(editor);
}

void GCG2StrTree(GeneCircuitGraph* gcg, StrTree* str_tree) {
	int n = gcg->NodeCount();
	for (int node_id = 0; node_id < gcg->NodeCount(); node_id++) {
		int in_deg = gcg->InEdgeCount(node_id);
		if (gcg->GetNodeAttr(node_id)->component->getCategory() == MOLECULE && in_deg > 0) {	// TODO: fix for the pool nodes also
			StringList str_list_tmp;
			for (int i = 0; i < in_deg; i++)
				str_list_tmp.push_back(gcg->GetNodeAttr(gcg->GetInEdge(node_id,i))->component->name);
			(*str_tree)[gcg->GetNodeAttr(node_id)->component->name].first = str_list_tmp;
			(*str_tree)[gcg->GetNodeAttr(node_id)->component->name].second = -1;	// is not the global input
		}
	}
	// TEST HERE
	//for (StrTree::iterator it = str_tree->begin(); it != str_tree->end(); it++) {
	//	cout << it->first << "  ";
	//	for (int i = 0; i < it->second.size(); i++)
	//		cout << " --" << it->second[i];
	//	cout << endl;
	//}
	// END TEST
}

bool equivalence_check(StrTree* original_str_tree, StrTree* sub_str_tree, string signal, int count = 0) {
	// TEST HERE
	if (count > 20) {
		return false;
		//cout << "************" << endl;
		//cout << signal << endl;
		//PrintStringTree(original_str_tree);
		//PrintStringTree(sub_str_tree);
		//cout << "************" << endl;
	}
	// END TEST HERE
	StringList sl1;
	if (original_str_tree->count(signal))
		sl1 = original_str_tree->at(signal).first;
	StringList sl2;
	if (sub_str_tree->count(signal))
		sl2 = sub_str_tree->at(signal).first;
	if (sl1.size() != sl2.size())
		return false;
	else
		for (int i = 0; i < sl1.size(); i++) {
			int j;
			for (j = 0; j < sl2.size(); j++)
				if (sl1[i].compare(sl2[j]) == STR_EQ) {
					if (!equivalence_check(original_str_tree, sub_str_tree, sl1[i], count + 1))
						return false;
					break;
				}
			if (j == sl2.size())
				return false;
		}
	return true;
}

bool check_and_merge(StrTree* original_str_tree, StrTree* sub_str_tree, CheckList* skip_list) {
	for (StrTree::iterator it = sub_str_tree->begin(); it != sub_str_tree->end(); ++it)
		if (original_str_tree->count(it->first) == 0)
			(*original_str_tree)[it->first] = it->second;
		else {
			if (it->second.second >= 0 && (*original_str_tree)[it->first].second >= 0 && it->second.second != (*original_str_tree)[it->first].second) {
				//cout << "Cross-talk with: " << it->first << endl;
				return true;
			}
			if (!equivalence_check(original_str_tree, sub_str_tree, it->first))
				if(skip_list == NULL || skip_list->count(it->first) == 0) {
					//cout << "Cross-talk with: " << it->first << endl;
					return true;
				}
				else
					UnionStrList(&(*original_str_tree)[it->first].first, &it->second.first);
		}
	return false;	// it means there is no cross-talking
}

void UnionStrList(StringList* first_str_list, StringList* second_str_list) {
	int l1 = first_str_list->size();
	int l2 = second_str_list->size();
	for (int j = 0; j < l2; j++) {
		int i;
		for (i = 0; i < l1; i++)
			if (first_str_list->at(i).compare(second_str_list->at(j)) == STR_EQ)
				break;
		if (i == l1)
			first_str_list->push_back(second_str_list->at(j));
	}
}

void PrintStringTree(StrTree* str_tree) {
	cout << "~~~~~~~~~~" << endl;
	for (StrTree::iterator it = str_tree->begin(); it != str_tree->end(); it++) {
		cout << it->first << ((it->second.second >= 0)?"(Input) ":" ");
		for (int i = 0; i < it->second.first.size(); i++)
			cout << " --" << it->second.first[i];
		cout << endl;
	}
	cout << "~~~~~~~~~~" << endl;
}

vector<Molecule*>* SrcComponent2Molecule(GeneCircuitComponent *component, PartDatabase* partDB) {
	vector<Molecule*>* tmp = new vector<Molecule*>;
	if (component->getCategory() == MOLECULE)
		tmp->push_back((Molecule*) component->clone());
	else if (component->getCategory() == CIRCUIT_SIGNAL)
		tmp->push_back((Molecule*)((CircuitSignal*) component)->physical_instance->clone());
	else {
		Module* module_tmp = partDB->loadContent(Id2Str(component->getType()),component->name);
		// TEST HERE
		//cout << "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ " << Id2Str(component->getType()) << "\t"<< component->name << endl;
		//module_tmp->TestPrint(&std::cout);
		//cout << "@@@@@@@@@@@@@@@@@@@@@@@@@@@@@" << endl;
		// END TEST
		for (unsigned int i = 0; i < module_tmp->inputs.size(); i++) {
			vector<Molecule*>* molecule_list_tmp  = SrcComponent2Molecule(module_tmp->GetNodeAttr(module_tmp->inputs[i])->component, partDB);
			for (unsigned int j = 0; j < molecule_list_tmp->size(); j++)
				tmp->push_back((Molecule*)molecule_list_tmp->at(j)->clone());
			delete molecule_list_tmp;
		}
		delete module_tmp;
	}
	return tmp;
}

Molecule* DestComponent2Molecule(GeneCircuitComponent *component, PartDatabase* partDB) {
	if (component->getCategory() == MOLECULE)
		return ((Molecule*) component->clone());
	else if (component->getCategory() == CIRCUIT_SIGNAL)
		return ((Molecule*)((CircuitSignal*)component)->physical_instance->clone());
	else {
		Module* module_tmp = partDB->loadContent(Id2Str(component->getType()),component->name);
		GeneCircuitComponent* component_tmp = DestComponent2Molecule(module_tmp->GetNodeAttr(module_tmp->outputs[0])->component, partDB)->clone();
		delete module_tmp;
		return ((Molecule*)component_tmp);
	}
}

int Find_Regulation(GeneCircuitComponent* src, GeneCircuitComponent* dest, PartDatabase *partDB) {
	int regulation_type = UNKNOWN;
	if (src->name.length() > 0 && dest->name.length() > 0) {
		Molecule* src_mol = DestComponent2Molecule(src, partDB);
		//cout << "src: " << src_mol->name << endl;
		vector<Molecule*>* dest_mol_list = SrcComponent2Molecule(dest, partDB);
		for (unsigned int i = 0; i < dest_mol_list->size(); i++) {
			int t = partDB->getRegulationType(src_mol, dest_mol_list->at(i));
			//cout << "dest " << i << ":\t" <<  dest_mol_list->at(i)->name << "\t" << t << endl;
			if (t != NONE) {
				regulation_type = t;
				break;
			}
		}
		if (regulation_type == UNKNOWN)
			regulation_type = NONE;
		for (unsigned int i = 0; i < dest_mol_list->size(); i++)
			delete dest_mol_list->at(i);
		delete dest_mol_list;
	}
	return regulation_type;
}

bool Check_Update(GeneCircuitGraph *gcg, int src_node_id, int dest_node_id, PartDatabase* partDB) {
	GeneCircuitComponent *src = gcg->GetNodeAttr(src_node_id)->component;
	GeneCircuitComponent *dest = gcg->GetNodeAttr(dest_node_id)->component;
	if (src->name.length() > 0 && dest->name.length() > 0) {
		Molecule* src_mol = DestComponent2Molecule(src, partDB);
		vector<Molecule*>* dest_mol_list = SrcComponent2Molecule(dest, partDB);
		bool compatible = false;
		for (unsigned int i = 0; i < dest_mol_list->size(); i++) {
			int type_1 = partDB->getRegulationType(src_mol, dest_mol_list->at(i));
			int type_2 = gcg->GetEdgeAttr(src_node_id, dest_node_id)->type;
			// TEST HERE
			//cout << src_mol->name << " " << type_1 << " " << dest_mol_list->at(i)->name
			//	<< "\t" << src_node_id << " " << type_2 << " " << dest_node_id << endl;
			if ((type_1 == type_2) || (type_1 != NONE && type_2 == UNKNOWN)) {
				compatible = true;
				break;
			}
		}
		delete dest_mol_list;
		return compatible;
	}
	// TODO: update src_mol and dest_mol
	return true;
}

GeneCircuitGraph* Layout(GeneCircuitGraph *gcg, PartDatabase* partDB, map<int,NodeVisualInfo*>* visual_info_list) {
	// Remove linkers first
	ARGEdit* editor = (ARGEdit*) gcg->ConvertToLoader();
	IdList deleted_node_list;
	for (int node_id = 0; node_id < gcg->NodeCount(); node_id++) {
		//if (gcg->GetNodeAttr(node_id)->component->getCategory() == CIRCUIT_SIGNAL && gcg->GetNodeAttr(node_id)->component->getType() == LINKER) {
		if (gcg->GetNodeAttr(node_id)->component->getCategory() == CIRCUIT_SIGNAL) {
			/*
			if (visual_info_list == NULL || (gcg->GetNodeAttr(node_id)->component->getType() == LINKER))
				deleted_node_list.push_back(node_id);
			if (gcg->GetNodeAttr(node_id)->component->getType() == LINKER) {
				int src_id = gcg->GetInEdge(node_id,0);
				int number_of_succ_nodes = gcg->OutEdgeCount(node_id);
				for (int succ_id = 0; succ_id < number_of_succ_nodes; succ_id++) {
					int succ_node_id = gcg->GetOutEdge(node_id, succ_id);
					editor->InsertEdge(src_id, succ_node_id, gcg->GetEdgeAttr(node_id, succ_node_id)->clone());
				}
			}
			*/
		}
	}
	for (unsigned int i = 0; i < deleted_node_list.size(); i++)
		editor->DeleteNode(deleted_node_list[i] - i);
	// Extend device nodes
	GeneCircuitGraph *current_gcg = new GeneCircuitGraph(editor);
	bool continue_extending;
	do {
		continue_extending = false;
		for (int node_id = 0; node_id < current_gcg->NodeCount(); node_id++)
			if (current_gcg->GetNodeAttr(node_id)->component->getCategory() == CIRCUIT_SIGNAL) {
				//GeneCircuitComponent* comp_tmp;
				//if (current_gcg->GetNodeAttr(node_id)->component->getType() == OUTPUT)
				//	comp_tmp = CreateComponent("Pool", current_gcg->GetNodeAttr(node_id)->component->name);
				//else
				//	comp_tmp = ((CircuitSignal*)current_gcg->GetNodeAttr(node_id)->component)->physical_instance->clone();
				//delete current_gcg->GetNodeAttr(node_id)->component;
				//current_gcg->GetNodeAttr(node_id)->component = comp_tmp;
			}
			else if (current_gcg->GetNodeAttr(node_id)->component->getCategory() != MOLECULE && !current_gcg->GetNodeAttr(node_id)->component->getName().empty()) { // check if the name is empty since we can keep the device node by setting it's name = empty
				vector<NodeVisualInfo> *module_visual_info_list = new vector<NodeVisualInfo>;
				Module *module_tmp = partDB->loadContent(Id2Str(current_gcg->GetNodeAttr(node_id)->component->getType()), current_gcg->GetNodeAttr(node_id)->component->name, module_visual_info_list);
				GeneCircuitGraph *gcg_tmp = GeneCircuitGraphExtension(current_gcg, node_id, module_tmp, partDB, visual_info_list, module_visual_info_list);
				delete current_gcg;
				current_gcg = gcg_tmp;
				continue_extending = true;
				break;
			}
		// TEST HERE
		//cout << "***************************";
		//current_gcg->TestPrint(&std::cout);
	} while (continue_extending);
	// Update the edges that are created during the expansion step
	for (int src_id = 0; src_id < current_gcg->NodeCount(); src_id++)
		for (int dest_id = 0; dest_id < current_gcg->NodeCount(); dest_id++)
			if (src_id != dest_id) {
				BioNetEdge *bn_e = current_gcg->GetEdgeAttr(src_id, dest_id);
				if (bn_e != NULL && bn_e->type == UNKNOWN)
					bn_e->type = Find_Regulation(current_gcg->GetNodeAttr(src_id)->component, current_gcg->GetNodeAttr(dest_id)->component, partDB);
			}
	return current_gcg;
}

GeneCircuitGraph* GeneCircuitGraphExtension(GeneCircuitGraph* gcg, int sub_node_id, Module* module, PartDatabase *partDB, map<int,NodeVisualInfo*>* visual_info_list, vector<NodeVisualInfo> *module_visual_info_list) {
	// TEST HERE
	//cout << "---------------------------";
	//gcg->TestPrint(&std::cout);
	//cout << "---------";
	//module->TestPrint(&std::cout);
	//cout << "---------------------------";
	// END TEST
	ARGEdit *editor_tmp = new ARGEdit;
	map<int,int> circuit_to_extension;
	// Add nodes
	for (int i = 0; i < gcg->NodeCount(); i++)
		if (i != sub_node_id)
			circuit_to_extension[i] = editor_tmp->InsertNode(gcg->GetNodeAttr(i)->clone());
		else if (visual_info_list != NULL) { // visual_info_list != NULL ---> keep the expanded node for the visual expansion
			gcg->GetNodeAttr(i)->component->name = "";	// set the name to be empty so that it will not be expanded later
			circuit_to_extension[i] = editor_tmp->InsertNode(gcg->GetNodeAttr(i)->clone());
		}
	// Add edges
	for (int i = 0; i < gcg->NodeCount(); i++)
		for (int j = 0; j < gcg->NodeCount(); j++)
			if (i != sub_node_id && j != sub_node_id && i != j && gcg->GetEdgeAttr(i,j) != NULL) // all edges connect to the expanded node the will be removed
				editor_tmp->InsertEdge(circuit_to_extension[i], circuit_to_extension[j], gcg->GetEdgeAttr(i,j)->clone());
	map<int,int> module_to_extension;
	// Add nodes
	double x_min = 10000, y_min = 10000, x_max = 0, y_max = 0;
	double w_z, h_z; // for the zone of this motif
	if (module_visual_info_list != NULL) {
		for (unsigned int node_id = 0; node_id < module_visual_info_list->size(); node_id++) {
			if (module_visual_info_list->at(node_id).pos_x < x_min)
				x_min = module_visual_info_list->at(node_id).pos_x;
			if (module_visual_info_list->at(node_id).pos_x + module_visual_info_list->at(node_id).width > x_max)
				x_max = module_visual_info_list->at(node_id).pos_x + module_visual_info_list->at(node_id).width;
			if (module_visual_info_list->at(node_id).pos_y < y_min)
				y_min = module_visual_info_list->at(node_id).pos_y;
			if (module_visual_info_list->at(node_id).pos_y + module_visual_info_list->at(node_id).height > y_max)
				y_max = module_visual_info_list->at(node_id).pos_y + module_visual_info_list->at(node_id).height;
		}
		w_z = x_max - x_min;
		h_z = y_max - y_min;
	}
	double x_parent, y_parent, w_parent, h_parent;	// visual information of the parent node
	double x_c, y_c, w_c, h_c; 	// visual information of the container
	if (visual_info_list != NULL) {
		x_parent = visual_info_list->at(sub_node_id)->pos_x;	// visual information of the parent node
		y_parent = visual_info_list->at(sub_node_id)->pos_y;
		w_parent = visual_info_list->at(sub_node_id)->width;
		h_parent = visual_info_list->at(sub_node_id)->height;
		switch (gcg->GetNodeAttr(sub_node_id)->component->getType()) {
			case YES_GATE:
				x_c = x_parent + 0.03*w_parent;
				y_c = y_parent + 0.25*h_parent;
				w_c = 0.8*w_parent;
				h_c = 0.5*h_parent;
				break;
			case NOT_GATE:
				x_c = x_parent + 0.03*w_parent;
				y_c = y_parent + 0.25*h_parent;
				w_c = 0.8*w_parent;
				h_c = 0.5*h_parent;
				break;
			case AND_GATE:
				x_c = x_parent + 0.05*w_parent;
				y_c = y_parent + 0.1*h_parent;
				w_c = 0.9*w_parent;
				h_c = 0.8*h_parent;
				break;
			case OR_GATE:
				x_c = x_parent + 0.5*w_parent;
				y_c = y_parent + 0.25*h_parent;
				w_c = 0.5*w_parent;
				h_c = 0.5*h_parent;
				break;
		}
	}
	for (int i = 0; i < module->NodeCount(); i++) {
		BioNetNode *bn_node_tmp = module->GetNodeAttr(i)->clone();
		bn_node_tmp->original_node_id = gcg->GetNodeAttr(sub_node_id)->original_node_id;
		module_to_extension[i] = editor_tmp->InsertNode(bn_node_tmp);
		// Extend the visual information list
		if (visual_info_list != NULL && module_visual_info_list != NULL) {
			double x = module_visual_info_list->at(i).pos_x;
			double y = module_visual_info_list->at(i).pos_y;
			double w = module_visual_info_list->at(i).width;
			double h = module_visual_info_list->at(i).height;
			if (w_c/w_z < h_c/h_z) { // scale by x-axis
				double scale = w_c/w_z;
				(*visual_info_list)[module_to_extension[i]] = new NodeVisualInfo((x-x_min)*scale + x_c, (y-y_min)*scale + y_c + h_c/2 - h_z*scale/2, w*scale, h*scale, scale);
			}
			else {	// scale by y-axis
				double scale = h_c/h_z;
				(*visual_info_list)[module_to_extension[i]] = new NodeVisualInfo((x-x_min)*scale + x_c + w_c/2 - w_z*scale/2 , (y-y_min)*scale + y_c, w*scale, h*scale, scale);
			}
		}
	}
	// Add edges
	for (int i = 0; i < module->NodeCount(); i++)
		for (int j = 0; j < module->NodeCount(); j++)
			if (i != j && module->GetEdgeAttr(i,j) != NULL)
				editor_tmp->InsertEdge(module_to_extension[i], module_to_extension[j], module->GetEdgeAttr(i,j)->clone());
	// TODO: permute inputs and fix for the multiple output case
	// Add connections to the output
	int adj_to_output_node_id = gcg->GetOutEdge(sub_node_id, 0);
	editor_tmp->InsertEdge(module_to_extension[module->outputs[0]], circuit_to_extension[adj_to_output_node_id], gcg->GetEdgeAttr(sub_node_id, adj_to_output_node_id)->clone());
	// Add connections to the inputs
	int number_of_inputs = gcg->InEdgeCount(sub_node_id);
	if (number_of_inputs == 1) {
		int adj_to_input_node_id = gcg->GetInEdge(sub_node_id, 0);
		editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id], module_to_extension[module->inputs[0]], gcg->GetEdgeAttr(adj_to_input_node_id, sub_node_id)->clone());
	}
	else if (number_of_inputs == 2) {
		int adj_to_input_node_id_0 = gcg->GetInEdge(sub_node_id, 0);
		int adj_to_input_node_id_1 = gcg->GetInEdge(sub_node_id, 1);
		if (module->inputs.size() == 1) {	// two signal inputs connect to the same input node in the module, e.g., hrpR --------> hrpR-hrpS <-------- hrpS
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], module_to_extension[module->inputs[0]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[0])->component, partDB)));
			editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], module_to_extension[module->inputs[0]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_1)->component, module->GetNodeAttr(module->inputs[0])->component, partDB)));
		}
		else {
			if (Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[0])->component, partDB) != NONE) {
				editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], module_to_extension[module->inputs[0]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[0])->component, partDB)));
				editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], module_to_extension[module->inputs[1]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_1)->component, module->GetNodeAttr(module->inputs[1])->component, partDB)));
			}
			else {
				editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_0], module_to_extension[module->inputs[1]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_0)->component, module->GetNodeAttr(module->inputs[1])->component, partDB)));
				editor_tmp->InsertEdge(circuit_to_extension[adj_to_input_node_id_1], module_to_extension[module->inputs[0]], new BioNetEdge(Find_Regulation(gcg->GetNodeAttr(adj_to_input_node_id_1)->component, module->GetNodeAttr(module->inputs[0])->component, partDB)));
			}
		}
	}
	else
		cout << "WE HAVE NOT PROCESSED YET FOR MODULES THAT HAVE MORE THAN TWO INPUTS " << endl;
	return new GeneCircuitGraph(editor_tmp);
}

bool all_visitor(int n, node_id* small_graph_node_list, node_id* large_graph_node_list, void* all_graph_isomorphism) {
	GraphIsomorphism graph_isomorphism;
	graph_isomorphism.reserve(n);
	for (int i = 0; i < n; i++){
		NodePair node_pair_tmp(small_graph_node_list[i],large_graph_node_list[i]);
		graph_isomorphism.push_back(node_pair_tmp);
	}
	((vector<GraphIsomorphism>*) all_graph_isomorphism)->push_back(graph_isomorphism);
	return false;
}
