/*
 * Framework.h
 *
 *  Created on: Aug 17, 2012
 *      Author: linh
 */

#ifndef FRAMEWORK_H_
#define FRAMEWORK_H_

#include "VFLIB/ull_sub_state.h"
#include "VFLIB/vf2_sub_state.h"
#include "VFLIB/match.h"
#include "VFLIB/argedit.h"
#include "DesignProblem.h"
#include "PartDatabase.h"
#include "GeneCircuitGraph.h"
#include "DynamicGeneCircuit.h"
#include "xmlParser.h"

enum Threshold {
	MAX_NUM_OF_RECORD = 15,
	MAX_RUNNING_TIME = 1500
};

enum Search_Mode {
	SI,	// Simulation only
	ES,	// Exhaustive search
	MS,	// Modular search
	DP,	// Dynamic-programming based search
	HS,	// Heuristic search
	HS_DP
};

bool all_visitor(int n, node_id* small_graph_node_list, node_id* large_graph_node_list, void* all_graph_isomorphism);

class Matching_State {
public:
	Matching_State(GeneCircuitGraph* gcg_, int module_id_, GraphIsomorphismCollection* matching_list_, int matching_id_, int signal_id_): gcg(gcg_),
		module_id(module_id_),
		matching_list(matching_list_),
		matching_id(matching_id_),
		signal_id(signal_id_) {
		// Do nothing
	}
	~Matching_State() {
		free_var(gcg);
		free_var(matching_list);
	}
	GeneCircuitGraph* gcg;
	int module_id;
	GraphIsomorphismCollection *matching_list;
	int matching_id;
	int signal_id; 			// to manage the cross-talk
};

class BranchingNodeRecord {	// contains information for each branching node
public:
	bool is_contained;
	string signal_name;
};

class OutputNodeRecord { 	// contains information for each node
public:
	void Print();

	double  cost;
	string output;
	StrTree signal_list;
	vector<BranchingNodeRecord> branch_node_info;
	vector<string> input_name_info;
	// For tracing back
	int module_id;			// id of the module that can match and create this output
	int matching_id;
	IdList pre_node_record_list;
};
typedef vector<OutputNodeRecord> OutputNodeRecordList;

struct RunningTimeInfo{
	double module_matching_time;
	double mutant_searching_time;
};

class ModuleMatchingManager {
public:
	ModuleMatchingManager(GeneCircuitGraph* input_gcg, PartDatabase* input_pdb);
	~ModuleMatchingManager();
	double Match(int search_mode, int starting_node_id, int max_number_of_kept_records);
	void Traceback(GeneCircuitGraph* output_gcg);
private:
	double current_optimal_cost;
	vector<Module*> *module_lib;
	GraphIsomorphismCollection** matching_map;
	vector<IdPairList> matching_list_at_node;
	IdList topo_order_list;
	map<int,int> branching_node_map;
	map<int,int> input_node_map;
	PartDatabase* partDB;		// DO NOT DELETE IT IN THE DESTRUCTION
	GeneCircuitGraph* gcg;		// DO NOT DELETE IT IN THE DESTRUCTION
	vector<OutputNodeRecordList> record_list;

	bool is_look_ahead_ok(int node_id, string species_name);
};

class Framework {
public:
	Framework(string database_filename, string input_filename);
	RunningTimeInfo Optimize(int part_selection_mode, int variant_selection_mode, string output_file_name);
private:
	void UpdateVisualInfo(map<int,NodeVisualInfo*>* visual_info_list);
	void WriteOutputFile(string output_filename, NodeVisualInfoMap* nvim);

	DesignProblem dp;
	PartDatabase partDB;
	DesignSolution ds;
};

vector<Molecule*>* SrcComponent2Molecule(GeneCircuitComponent *component, PartDatabase* partDB);
Molecule* DestComponent2Molecule(GeneCircuitComponent *component, PartDatabase* partDB);
int Find_Regulation(GeneCircuitComponent* src, GeneCircuitComponent* dest, PartDatabase *partDB);
bool Check_Update(GeneCircuitGraph *gcg, int src_node, int dest_node, PartDatabase *partDB);
GeneCircuitGraph* Layout(GeneCircuitGraph *gcg, PartDatabase* partDB, map<int,NodeVisualInfo*>* visual_info_list = NULL);
GeneCircuitGraph* GeneCircuitGraphExtension(GeneCircuitGraph* gcg, int sub_node_id, Module* module, PartDatabase *partDB, map<int,NodeVisualInfo*>* visual_info_list, vector<NodeVisualInfo> *module_visual_info_list);
void GCG2StrTree(GeneCircuitGraph* gcg, StrTree* str_tree);
bool check_and_merge(StrTree* original_str_tree, StrTree* sub_str_tree, CheckList* skip_list);	// check if there is a cross-talk effect between them and then merge the second tree into the first one
void UnionStrList(StringList* first_str_list, StringList* second_str_list);
void PrintStringTree(StrTree* str_tree);

#endif /* FRAMEWORK_H_ */
