/*
 * GeneCircuitGraph.cpp
 *
 *  Created on: May 2, 2012
 *      Author: linh, UC Davis
 */

#include <stdlib.h>
#include <stdio.h>
#include "GeneCircuitGraph.h"

string Id2Str(int type_id) {
	switch (type_id) {
		case LIGAND:
			return "Ligand";
		case m_RNA:
			return "mRNA";
		case t_RNA:
			return "tRNA";
		case PROTEIN:
			return "Protein";
		case POOL:
			return "POOL";
		case LIGAND_PROTEIN_COMPLEX:
			return "LigandProteinComplex";
		case RNA_COMPLEX:
			return "RNAComplex";
		case PROTEIN_COMPLEX:
			return "ProteinComplex";
		case INPUT:
			return "INPUT";
		case OUTPUT:
			return "OUTPUT";
		case SELECTOR:
			return "SELECTOR";
		case YES_GATE:
			return "YES_GATE";
		case NOT_GATE:
			return "NOT_GATE";
		case AND_GATE:
			return "AND_GATE";
		case NAND_GATE:
			return "NAND_GATE";
		case OR_GATE:
			return "OR_GATE";
		case NOR_GATE:
			return "NOR_GATE";
		default:
			SBROME_Error("There is no id type: " + type_id);
			return "UNKNOWN";
	}
}

int Str2Id(string type_str) {
	if (type_str.compare("Ligand") == STR_EQ)
		return LIGAND;
	else if (type_str.compare("mRNA") == STR_EQ)
		return m_RNA;
	else if (type_str.compare("mRNA(t)") == STR_EQ)	// TANDEM
		return m_RNA;
	else if (type_str.compare("mRNA(m)") == STR_EQ)	// MUTANT
		return m_RNA;
	else if (type_str.compare("tRNA") == STR_EQ)
			return t_RNA;
	else if (type_str.compare("Protein") == STR_EQ)
		return PROTEIN;
	else if (type_str.compare("POOL") == STR_EQ)
		return POOL;
	else if (type_str.compare("LigandProteinComplex") == STR_EQ)
		return LIGAND_PROTEIN_COMPLEX;
	else if (type_str.compare("ProteinComplex") == STR_EQ)
		return PROTEIN_COMPLEX;
	else if (type_str.compare("RNAComplex") == STR_EQ)
		return RNA_COMPLEX;
	else if (type_str.compare("INPUT") == STR_EQ)
		return INPUT;
	else if (type_str.compare("OUTPUT") == STR_EQ)
		return OUTPUT;
	else if (type_str.compare("SELECTOR") == STR_EQ)
		return SELECTOR;
	else if (type_str.compare("YES_GATE") == STR_EQ)
		return YES_GATE;
	else if (type_str.compare("NOT_GATE") == STR_EQ)
		return NOT_GATE;
	else if (type_str.compare("AND_GATE") == STR_EQ)
		return AND_GATE;
	else if (type_str.compare("NAND_GATE") == STR_EQ)
		return NAND_GATE;
	else if (type_str.compare("OR_GATE") == STR_EQ)
		return OR_GATE;
	else if (type_str.compare("NOR_GATE") == STR_EQ)
		return NOR_GATE;
	else if (type_str.compare("UNKNOWN") == STR_EQ)
		return POOL;
	else {
		SBROME_Error("There is no type: " + type_str);
		return UNKNOWN;
	}
}

bool SingleMolecule::CompareTo(GeneCircuitComponent* another_component) {
	if (another_component->getCategory() == MOLECULE) {
		if (another_component->getType() != UNKNOWN_MOLECULE && this->getType() != UNKNOWN_MOLECULE && (another_component->getType() != this->getType()
			|| (another_component->getName().compare("") != STR_EQ && this->getName().compare("") != STR_EQ && another_component->getName().compare(this->getName()) != STR_EQ)))
				return false;
		else
			return true;
	}
	else if (another_component->getCategory() == CIRCUIT_SIGNAL) {
		GeneCircuitComponent *tmp = ((InputSignal*)another_component)->physical_instance;
		if (tmp->getCategory() != MOLECULE
			|| (this->getType() != UNKNOWN_MOLECULE && (tmp->getType() != this->getType()
			|| (tmp->getName().compare("") != STR_EQ && this->getName().compare("") != STR_EQ && tmp->getName().compare(this->getName()) != STR_EQ))))
				return false;
		else
			return true;
	}
	else {	// GATE
		return false;
	}
}

void GRNEdit::TestPrint(ostream* f) {
	//StreamARGLoader<BioNetNode, BioNetEdge>::write(*f,*this);
	*f << this->NodeCount() << endl;
	for (int i = 0; i < this->count; i++) {
		*f << i << "\t";
		*f << *((BioNetNode*)this->GetNodeAttr(i));
		*f << endl;
	}
	for (int i = 0; i < this->count; i++) {
		int n_out = this->OutEdgeCount(i);
		for (int j = 0; j < n_out; j++) {
			int dest_node_id = this->getOutEdge(i,j);
			*f << i << "\t" << dest_node_id << "\t" << *(this->getEdgeAttr(i,dest_node_id)) << endl;
		}
	}
}

int GRNEdit::InEdgeCount(node_id node) {
	int n = this->count;
	int in_n = 0;
	for (int i = 0; i < n; i++) {
		int out_n = this->OutEdgeCount(i);
		void** tmp = NULL;
		for (int j = 0; j < out_n; j++)
			if (this->GetOutEdge(i,j,tmp) == node) {
				in_n++;
				break;
			}
	}
	return in_n;
}

BioNetEdge* GRNEdit::getEdgeAttr(node_id n1, node_id n2) {
	int out_n = this->OutEdgeCount(n1);
	void** tmp = new void*;
	for (int j = 0; j < out_n; j++)
		if (this->GetOutEdge(n1,j,tmp) == n2)
			return ((BioNetEdge*)*tmp)->clone();
	return NULL;
}

node_id GRNEdit::getInEdge(node_id node, int i) {
	int n = this->count;
	int in_n = 0;
	for (int k = 0; k < n; k++) {
		int out_n = this->OutEdgeCount(k);
		void** tmp = NULL;
		for (int l = 0; l < out_n; l++)
			if (this->GetOutEdge(k,l,tmp) == node) {
				if (in_n == i)
					return k;
				in_n++;
				break;
			}
	}
	cout << "SBROME ERROR: Error while trying to find the input-node " << i << "-th from the node " << node << endl;
	return UNKNOWN;
}

node_id GRNEdit::getOutEdge(node_id node, int i) {
	void** tmp = NULL;
	return this->GetOutEdge(node,i,tmp);
}

GeneCircuitGraph::GeneCircuitGraph() {
	// Do nothing
}
GeneCircuitGraph::GeneCircuitGraph(ARGLoader* loader): ARGraph<BioNetNode, BioNetEdge>(loader) {
	this->SetNodeDestroyer(new BioNetNodeDestroyer());
	this->SetNodeComparator(new BioNetNodeComparator());
	this->SetEdgeDestroyer(new BioNetEdgeDestroyer());
	this->SetEdgeComparator(new BioNetEdgeComparator());
}
GeneCircuitGraph::GeneCircuitGraph(istream* f){
	NewAllocator<BioNetNode> node_allocator;
	NewAllocator<BioNetEdge> edge_allocator;
	StreamARGLoader<BioNetNode, BioNetEdge> loader_temp(&node_allocator, &edge_allocator, *f);
	this->ResetLoader(&loader_temp);
	this->SetNodeDestroyer(new BioNetNodeDestroyer());
	this->SetNodeComparator(new BioNetNodeComparator());
	this->SetEdgeDestroyer(new BioNetEdgeDestroyer());
	this->SetEdgeComparator(new BioNetEdgeComparator());
}

GeneCircuitGraph::GeneCircuitGraph(const GeneCircuitGraph& another_gene_circuit_graph): ARGraph<BioNetNode, BioNetEdge>(another_gene_circuit_graph) {
	// Do nothing
}
GeneCircuitGraph& GeneCircuitGraph::operator = (const GeneCircuitGraph& another_gene_circuit_graph) {
	ARGraph<BioNetNode, BioNetEdge>::operator = (another_gene_circuit_graph);
	return *this;
}
GeneCircuitGraph::~GeneCircuitGraph() {
	// TODO:
}
void GeneCircuitGraph::TestPrint(ostream* f) {
	StreamARGLoader<BioNetNode, BioNetEdge>::write(*f,*this);
}

GRNEdit* GeneCircuitGraph::ConvertToLoader() {
	GRNEdit* tmp = new GRNEdit;
	for (int i = 0; i < this->NodeCount(); i++)
		tmp->InsertNode(this->GetNodeAttr(i)->clone());
	for (int i = 0; i < this->NodeCount(); i++)
		for (int j = 0; j < this->NodeCount(); j++)
			if (this->GetEdgeAttr(i,j) != NULL)
				tmp->InsertEdge(i,j,this->GetEdgeAttr(i,j)->clone());
	return tmp;
}

GeneCircuitGraph* GeneCircuitGraph::clone() {
	return new GeneCircuitGraph(this->ConvertToLoader());
}

bool GeneCircuitGraph::Topo_Sort(IdList* topo_order_list) {	// return false if there is a loop
	bool is_null_input = false;
	if (topo_order_list == NULL) {
		topo_order_list = new IdList;
		is_null_input = true;
	}
	bool is_cyclic;
	int number_of_nodes = this->NodeCount();
	bool* marked = new bool[number_of_nodes];
	int* in_deg = new int[number_of_nodes];		// in-degree list of nodes
	topo_order_list->resize(number_of_nodes);
	for (int i = 0; i < number_of_nodes; i++) {
		in_deg[i] = this->InEdgeCount(i);
		marked[i] = false;
	}
	int current_index = 0;
	do {
		is_cyclic = true;
		for (int i = 0; i < number_of_nodes; i++)
			if (!marked[i] && in_deg[i] == 0) {
				int out_num = this->OutEdgeCount(i);
				for (int j = 0; j < out_num; j++)
					in_deg[this->GetOutEdge(i,j)]--;
				marked[i] = true;
				topo_order_list->at(current_index) = i;
				current_index++;
				is_cyclic = false;
			}
		if (is_cyclic)
			break;
	}
	while (current_index < number_of_nodes);
	delete [] marked;
	delete [] in_deg;
	if (is_null_input)
		delete topo_order_list;
	//if (is_cyclic) {
	//	cout << "---------------------------" << endl;
	//	this->TestPrint(&std::cout);
	//	cout << "---------------------------" << endl;
	//}
	return (not is_cyclic);
}

BioNetNode* CreateBioNetNode (string type) {
	BioNetNode* tmp = new BioNetNode;
	tmp->component = CreateComponent(type);
	return tmp;
}

BioNetNode* CreateBioNetNode (string type, string name) {
	BioNetNode* tmp = new BioNetNode;
	tmp->component = CreateComponent(type, name);
	return tmp;
}

GeneCircuitComponent* CreateComponent (string type) {
	return CreateComponent(type, "");
}
GeneCircuitComponent* CreateComponent (string type, string name) {
	if (type.compare("mRNA(t)") == STR_EQ)
		return new SingleMolecule(Str2Id(type), name, TANDEM);
	else if (type.compare("mRNA(m)") == STR_EQ)
		return new SingleMolecule(Str2Id(type), name, MUTANT);
	else
		return CreateComponent(Str2Id(type), name);
}
GeneCircuitComponent* CreateComponent (int type, string name) {
	GeneCircuitComponent *component;
	if (type == LIGAND || type == m_RNA || type == t_RNA || type == PROTEIN)
		component = new SingleMolecule(type, name);
	else if (type == POOL)
		component = new PoolSignal;
	else if (type == LIGAND_PROTEIN_COMPLEX) {
		int pos = name.find_first_of('-');
		SingleMolecule* m1 = new SingleMolecule(LIGAND, name.substr(0,pos));
		SingleMolecule* m2 = new SingleMolecule(PROTEIN, name.substr(pos + 1));
		component = new ComplexMolecule(m1,m2);
		delete m1;
		delete m2;
	}
	else if (type == PROTEIN_COMPLEX) {
		int pos = name.find_first_of('-');
		SingleMolecule* m1 = new SingleMolecule(PROTEIN, name.substr(0,pos));
		SingleMolecule* m2 = new SingleMolecule(PROTEIN, name.substr(pos + 1));
		component = new ComplexMolecule(m1,m2);
		delete m1;
		delete m2;
	}
	else if (type == RNA_COMPLEX) {
		int pos = name.find_first_of('-');
		SingleMolecule* m1 = new SingleMolecule(m_RNA, name.substr(0,pos));
		SingleMolecule* m2 = new SingleMolecule(m_RNA, name.substr(pos + 1));
		component = new ComplexMolecule(m1,m2);
		delete m1;
		delete m2;
	}
	else if (type == INPUT)
		component = new InputSignal;
	else if (type == OUTPUT)
		component = new OutputSignal;
	else if (type == POOL)
		component = new PoolSignal;
	else if (type == SELECTOR)
		component = new SelectorSignal;
	else if (type == YES_GATE)
		component = new YESGate;
	else if (type == NOT_GATE)
		component = new NOTGate;
	else if (type == AND_GATE)
		component = new ANDGate;
	else if (type == NAND_GATE)
		component = new NANDGate;
	else if (type == OR_GATE)
		component = new ORGate;
	else if (type == NOR_GATE)
		component = new NORGate;
	else
		cout << "Error: " << type << ", no such type defined" << endl;
	component->name = name;
	return component;
}

inline istream& operator >> (istream& in, BioNetNode& node) {
	string type;
	in >> type;
	node.component = CreateComponent(type);
	node.component->operator >>(in);
	return in;
}
inline ostream& operator << (ostream& out, BioNetNode& node) {
	//out << "\t" << node.original_node_id << "\t";
	out << "\t";
	node.component->operator <<(out);
	if (node.component->getType() == m_RNA && node.component->variant_id != UNKNOWN)
		out << "\t" << "variant id = " << node.component->variant_id;
	if (!node.module_name_list.empty())
		out << "\t" << node.module_name_list[0];
	else
		out << "\t" << "";
	return out;
}

inline istream& operator >> (istream& in, BioNetEdge& BioNet_edge) {
	string tmp;
	in >> tmp;
	if (tmp.compare("ACT") == 0)
		BioNet_edge.type = ACTIVATORY;
	else if (tmp.compare("REP") == 0)
		BioNet_edge.type = INHIBITORY;
	else if (tmp.compare("UNKNOWN") == 0 || tmp.compare("NA") == 0)
		BioNet_edge.type = UNKNOWN;
	return in;
}

inline ostream& operator << (ostream& out, BioNetEdge BioNet_edge) {
	switch (BioNet_edge.type) {
		case ACTIVATORY:
			out << " ACT ";
			break;
		case INHIBITORY:
			out << " REP ";
			break;
		case UNKNOWN:
			out << " UNKNOWN ";
			break;
	}
	return out;
}

Module::Module() {
	// TODO Auto-generated constructor stub
}

Module::~Module() {
	// TODO Auto-generated destructor stub
}

void Module::TestPrint(ostream* f) {
	cout << "{-- " << name << " -- Cost: " << cost << " }" << endl;
	GeneCircuitGraph::TestPrint(f);
	*f << "Inputs: ";
	for (unsigned int i = 0; i < inputs.size(); i++)
		*f << inputs[i] << " ";
	*f << endl;
	*f << "Outputs: ";
	for (unsigned int i = 0; i < outputs.size(); i++)
		*f << outputs[i] << " ";
	*f << endl;
}

Module* GenerateGateNetwork(int number_of_gates, int number_of_inputs, bool is_complete) {
	ARGEdit* editor_tmp = new ARGEdit;
	int n1 = editor_tmp->InsertNode(new BioNetNode("Ligand",""));
	int n2 = editor_tmp->InsertNode(new BioNetNode("Protein","gfp"));
	editor_tmp->InsertEdge(n1,n2, new BioNetEdge("UNKNOWN"));
	vector<IdPair*> input_id_list; // each pair contains source and dest of the input edge
	input_id_list.push_back(new IdPair(n1,n2));

	for (int g = 0; g < number_of_gates - number_of_inputs; g++) {
		int id = rand() % input_id_list.size();
		int gate_type = rand() % 3;
		switch (gate_type) {
			case 0: {
				// NOT
				delete ((BioNetNode*)editor_tmp->GetNodeAttr(input_id_list[id]->first))->component;
				((BioNetNode*)editor_tmp->GetNodeAttr(input_id_list[id]->first))->component = CreateComponent("NOT_GATE");
				int new_id = editor_tmp->InsertNode(new BioNetNode("Ligand",""));
				editor_tmp->InsertEdge(new_id, input_id_list[id]->first, new BioNetEdge("UNKNOWN"));
				input_id_list[id]->second = input_id_list[id]->first;
				input_id_list[id]->first = new_id;
				break;
			}
			case 2: {
				// OR
				delete ((BioNetNode*)editor_tmp->GetNodeAttr(input_id_list[id]->first))->component;
				((BioNetNode*)editor_tmp->GetNodeAttr(input_id_list[id]->first))->component = CreateComponent("OR_GATE");
				int new_id_1 = editor_tmp->InsertNode(new BioNetNode("Ligand",""));
				int new_id_2 = editor_tmp->InsertNode(new BioNetNode("Ligand",""));
				editor_tmp->InsertEdge(new_id_1, input_id_list[id]->first, new BioNetEdge("UNKNOWN"));
				editor_tmp->InsertEdge(new_id_2, input_id_list[id]->first, new BioNetEdge("UNKNOWN"));
				input_id_list[id]->second = input_id_list[id]->first;
				input_id_list[id]->first = new_id_1;
				input_id_list.push_back(new IdPair(new_id_2, input_id_list[id]->second));
				break;
			}
			case 1: {
				// AND
				delete ((BioNetNode*)editor_tmp->GetNodeAttr(input_id_list[id]->first))->component;
				((BioNetNode*)editor_tmp->GetNodeAttr(input_id_list[id]->first))->component = CreateComponent("AND_GATE");
				int new_id_1 = editor_tmp->InsertNode(new BioNetNode("Ligand",""));
				int new_id_2 = editor_tmp->InsertNode(new BioNetNode("Ligand",""));
				editor_tmp->InsertEdge(new_id_1, input_id_list[id]->first, new BioNetEdge("UNKNOWN"));
				editor_tmp->InsertEdge(new_id_2, input_id_list[id]->first, new BioNetEdge("UNKNOWN"));
				input_id_list[id]->second = input_id_list[id]->first;
				input_id_list[id]->first = new_id_1;
				input_id_list.push_back(new IdPair(new_id_2, input_id_list[id]->second));
				break;
			}
		}
	}

	if (input_id_list.size() > (unsigned int)number_of_inputs) { // the number of inputs is larger than the expected one, so we need to merge them together
		vector<vector<int> > dest_id_matrix_tmp(number_of_inputs);	// store the dest node ids of each set of input nodes
		for (int id_tmp = 0; id_tmp < number_of_inputs; id_tmp++)
			dest_id_matrix_tmp[id_tmp].push_back(input_id_list[id_tmp]->second);
		vector<int> del_node_id_list;

		for (unsigned int id_gather = number_of_inputs; id_gather < input_id_list.size(); id_gather++) {
			int tmp;
			bool check;
			do {// check to ensure that there are no two input nodes that connect to the same dest node can be merged together
				tmp = rand() % number_of_inputs;
				check = true;
				for (unsigned int it = 0; it < dest_id_matrix_tmp[tmp].size(); it++)
					if (input_id_list[id_gather]->second == dest_id_matrix_tmp[tmp][it]) {
						check = false;
						break;
					}
			} while (!check);
			del_node_id_list.push_back(input_id_list[id_gather]->first);
			editor_tmp->InsertEdge(input_id_list[tmp]->first, input_id_list[id_gather]->second, new BioNetEdge("UNKNOWN"));
			dest_id_matrix_tmp[tmp].push_back(input_id_list[id_gather]->second);
			editor_tmp->DeleteEdge(input_id_list[id_gather]->first, input_id_list[id_gather]->second);
		}
	}

	for (unsigned int i = 0; i < input_id_list.size(); i++) { // Add an YES_GATE for each input node
		int id_tmp = editor_tmp->InsertNode(new BioNetNode("Ligand"));
		delete ((BioNetNode*)editor_tmp->GetNodeAttr(id_tmp))->component;
		((BioNetNode*)editor_tmp->GetNodeAttr(id_tmp))->component = ((BioNetNode*)editor_tmp->GetNodeAttr(input_id_list[i]->first))->component;
		((BioNetNode*)editor_tmp->GetNodeAttr(input_id_list[i]->first))->component = CreateComponent("YES_GATE");
		editor_tmp->InsertEdge(id_tmp,input_id_list[i]->first,new BioNetEdge("UNKNOWN"));
	}
	bool del_check;
	// remove abundant nodes
	do {
		del_check = true;
		for (int i = 0; i < editor_tmp->NodeCount(); i++)
			if (editor_tmp->OutEdgeCount(i) == 0 && ((BioNetNode*)editor_tmp->GetNodeAttr(i))->component->getType() != PROTEIN) {
				editor_tmp->DeleteNode(i);
				del_check = false;
				break;
		}
	}
	while (!del_check);
	return new Module(editor_tmp);
}
IdMatrix GenerateAllPermutation (IdList idl) {
	IdMatrix final_matrix;
	if (idl.size() <= 1)
		final_matrix.push_back(idl);
	else {
		int last_element = idl.back();
		idl.pop_back();
		IdMatrix tmp1 = GenerateAllPermutation(idl);
		for (int i = 0; i < tmp1.size(); i++) {
			IdList idl_tmp = tmp1[i];
			for (int j = 0; j < idl.size(); j++) {
				idl_tmp.insert(idl_tmp.begin() + j, last_element);
				final_matrix.push_back(idl_tmp);
			}
		}
	}
	return final_matrix;
}
enum SymmetryCheck{
	UNKNOWN_SYMMETRY = 0,
	ASYMMETRIC = -1,
	SYMMETRIC = 1
};
bool IsSymmetricInput(GRNEdit* editor, int node_id) {
	int number_of_inputs = editor->InEdgeCount(node_id);
	if (number_of_inputs < 2)
		return true;
	else if (number_of_inputs == 2) {
		int i1 = editor->getInEdge(node_id,0);
		int i2 = editor->getInEdge(node_id,1);
		return (editor->InEdgeCount(i1) == 0 && editor->InEdgeCount(i2) == 0 && ((BioNetNode*)editor->GetNodeAttr(i1))->component->getType() == ((BioNetNode*)editor->GetNodeAttr(i2))->component->getType());
	}
	else
		cout << "SBROME: A functional node has more than two inputs" << endl;
	return false;
}
bool IsSymmetric(Module* m) {
	if (m->inputs.size() == 1)
		return true;
	else if (m->inputs.size() == 2) {
		int n = m->NodeCount();
		int** symmetric_pair = new int*[m->NodeCount()];
		for (int i = 0; i < n; i++) {
			symmetric_pair[i] = new int[n];
			for (int j = 0; j < n; j++)
				symmetric_pair[i][j] = UNKNOWN_SYMMETRY; // UNKNOWN
		}
		bool updated;
		do {
			// TEST HERE
			//for (int i = 0; i < n; i++) {
			//	for (int j = 0; j < n; j++)
			//		cout << symmetric_pair[i][j] << "\t";
			//	cout << endl;
			//}
			// END TEST
			updated = false;
			for (int i = 0; i < n; i++)
				for (int j = 0; j < i; j++)
					if (symmetric_pair[i][j] == UNKNOWN_SYMMETRY) { // UNKNOWN
						if ((m->GetNodeAttr(i)->component->getType() != m->GetNodeAttr(j)->component->getType() && (m->GetNodeAttr(i)->component->getType() != m_RNA || m->GetNodeAttr(j)->component->getType() != t_RNA) && (m->GetNodeAttr(i)->component->getType() != t_RNA || m->GetNodeAttr(j)->component->getType() != m_RNA))
							|| m->GetNodeAttr(i)->component->getCategory() != m->GetNodeAttr(j)->component->getCategory()
							|| m->InEdgeCount(i) != m->InEdgeCount(j) || m->OutEdgeCount(i) != m->OutEdgeCount(j)) {
							// TEST HERE
							//cout << i << " vs " << j << endl;
							// END TEST
							symmetric_pair[i][j] = symmetric_pair[j][i] = ASYMMETRIC;
							updated = true;
						}
						else {
							IdList input1, input2, output1, output2;
							for (int k = 0; k < m->InEdgeCount(i); k++) {
								input1.push_back(m->GetInEdge(i,k));
								input2.push_back(m->GetInEdge(j,k));
							}
							for (int k = 0; k < m->OutEdgeCount(i); k++) {
								output1.push_back(m->GetOutEdge(i,k));
								output2.push_back(m->GetOutEdge(j,k));
							}
							IdMatrix IM1 = GenerateAllPermutation(input1);
							IdMatrix IM2 = GenerateAllPermutation(input2);
							bool is_possible_symmetry = false;
							for (int r = 0; r < IM1.size(); r++) {
								for (int s = 0; s < IM2.size(); s++) {
									bool equivalent = true;
									for (int t = 0 ; t < input1.size(); t++) {
										if (symmetric_pair[IM1[r][t]][IM2[s][t]] == ASYMMETRIC)	{ // not symmetric
											equivalent = false;
											break;
										}
									}
									if (equivalent) {
										is_possible_symmetry = true;
										break;
									}
								}
								if (is_possible_symmetry)
									break;
							}
							if (is_possible_symmetry || (input1.empty())) {
								is_possible_symmetry = false;
								IdMatrix OM1 = GenerateAllPermutation(output1);
								IdMatrix OM2 = GenerateAllPermutation(output2);
								for (int r = 0; r < OM1.size(); r++) {
									for (int s = 0; s < OM2.size(); s++) {
										bool equivalent = true;
										for (int t = 0 ; t < output1.size(); t++) {
											if (symmetric_pair[OM1[r][t]][OM2[s][t]] == ASYMMETRIC)	{ // not symmetric
												equivalent = false;
												break;
											}
										}
										if (equivalent) {
											is_possible_symmetry = true;
											break;
										}
									}
									if (is_possible_symmetry)
										break;
								}
							}
							if (!is_possible_symmetry && !output1.empty()) {
								symmetric_pair[i][j] = symmetric_pair[j][i] = ASYMMETRIC;
								// TEST HERE
								//cout << i << "--" << j << endl;
								// END TEST
								updated = true;
							}
						}
					}
		}
		while (updated);
		bool is_module_symmetric = symmetric_pair[m->inputs[0]][m->inputs[1]] != ASYMMETRIC;
		for (int i = 0; i < n; i++)
			delete [] symmetric_pair[i];
		delete [] symmetric_pair;
		// TEST HERE
		//m->TestPrint(&std::cout);
		//cout << "---------------- " << (is_module_symmetric ? "Symmetric" : "Not symmetric") << endl;
		// END TEST
		return is_module_symmetric;
	}
	else {
		cout << "ERROR: Module has more than 3 inputs" << endl;
		return false;
	}
}
