/*
 * PartDatabase.cpp
 *
 *  Created on: Aug 8, 2012
 *      Author: linh
 */

#include <iostream>
#include <map>
#include <stack>
#include <algorithm>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "PartDatabase.h"

static int callback_count(void *NotUsed, int argc, char **argv, char **azColName){
	(*(int*)NotUsed) = atoi(argv[0]);
	return 0;
}
static int callback_string(void *NotUsed, int argc, char **argv, char **azColName){
	vector<string> tmp(argc);
	for (int i = 0; i < argc; i++) {
		string str_tmp(argv[i]);
		tmp[i] = str_tmp;
	}
	((StringMatrix*)NotUsed)->push_back(tmp);
	return 0;
}
PartDatabase::PartDatabase() {
	db = NULL;
	module_library = NULL;
}

PartDatabase::PartDatabase(std::string db_filename) {
	int rc = sqlite3_open(db_filename.c_str(), &db);
	if (rc) {
		std::cout << "Can't open database: " << sqlite3_errmsg(db) << std::endl;
		sqlite3_close(db);
	}
	module_library = InitializeModuleLibrary();
}

PartDatabase::~PartDatabase() {
	sqlite3_close(db);
}

int PartDatabase::getNumberOfProteins() const {
	return number_of_proteins;
}

double PartDatabase::getDegradationRate(string protein_name) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT degradation_rate FROM Protein";
	qri.query += " WHERE name = '" + protein_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (qri.string_matrix.empty())
		cout << "There is no protein " << protein_name << endl;
	return atof(qri.string_matrix[0][0].c_str());
}

int PartDatabase::getNumberOfMutants(string promoter_name) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT COUNT(*) FROM Promoter_Mutant";
	qri.query += " WHERE promoter_name = '" + promoter_name + "'";
	int count_tmp;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_count, &count_tmp, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	return count_tmp;
}

double PartDatabase::getPromoterBasal(string promoter_name, int mutant_index) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT basal FROM Promoter_Mutant";
	qri.query += " WHERE promoter_name = '" + promoter_name + "' AND mutant_id = " + Num2Str(mutant_index);
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (qri.string_matrix.empty())
		cout << "There is no mutant of " << promoter_name << " with mutant index is " << mutant_index << endl;
	return atof(qri.string_matrix[0][0].c_str());
}
double PartDatabase::getPromoterStrength(string promoter_name, int mutant_index) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT strength FROM Promoter_Mutant";
	qri.query += " WHERE promoter_name = '" + promoter_name + "' AND mutant_id = " + Num2Str(mutant_index);
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (qri.string_matrix.empty())
		cout << "There is no mutant of " << promoter_name << " with mutant index is " << mutant_index << endl;
	return atof(qri.string_matrix[0][0].c_str());
}
TranscriptionRegulation PartDatabase::getPromoterRegulation(string regulator_name, string promoter_name) const {
	TranscriptionRegulation tr;
	QueryResultInfo qri = Init();
	qri.query = "SELECT beta,eta,type FROM Transcription_Regulation";
	qri.query += " WHERE regulator_name = '" + regulator_name + "' AND promoter_name = '" + promoter_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (qri.string_matrix.empty())
		cout << "There is no interaction between " << regulator_name << " and " << promoter_name << endl;
	tr.binding_affinity = atof(qri.string_matrix[0][0].c_str());
	tr.cooperativity = atof(qri.string_matrix[0][1].c_str());
	tr.regulator_type = (qri.string_matrix[0][2].compare("ACT") == STR_EQ) ? ACTIVATORY : INHIBITORY;
	return tr;
}
LigandRegulation PartDatabase::getLigandRegulation(string ligand_name, string protein_name) const {
	LigandRegulation lr;
	QueryResultInfo qri = Init();
	qri.query = "SELECT theta,eta FROM Ligand_Protein_Interaction";
	qri.query += " WHERE ligand_name = '" + ligand_name + "' AND protein_name = '" + protein_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	lr.dissociation = atof(qri.string_matrix[0][0].c_str());
	lr.cooperativity = atof(qri.string_matrix[0][1].c_str());
	return lr;
}

int IOStr2Num(string io_str) {
	if (io_str.compare("Input") == STR_EQ)
		return INPUT;
	else
		return OUTPUT;
}
vector<Module*>* PartDatabase::loadModuleLibrary() {
	return module_library;
}
vector<Module*>* PartDatabase::InitializeModuleLibrary() {
	StringMatrix module_info_list;
	QueryResultInfo qri = Init();
	qri.query = "SELECT module_name, motif_name, ref FROM module_info WHERE type = 'FULL'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_info_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	vector<Module*>* module_list = new vector<Module*>(module_info_list.size());

	for (unsigned int module_id = 0; module_id < module_list->size(); module_id++) {
		ARGEdit* module_editor = new ARGEdit;
		IdList inputs, outputs;
		inputs.clear();
		outputs.clear();
		// Read node name
		StringMatrix node_name_list;
		Reset(qri);
		qri.query = "SELECT node_id, node_name FROM module_node";
		qri.query += " WHERE module_name = '" + module_info_list[module_id][0] + "'";
		qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &node_name_list, &qri.zErrMsg);
		if(qri.rc != SQLITE_OK) {
			cout << qri.query << endl;
			std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
			sqlite3_free(qri.zErrMsg);
		}
		map<string, string> node_id_to_node_name;
		for (unsigned int node_id = 0; node_id < node_name_list.size(); node_id++)
			node_id_to_node_name[node_name_list[node_id][0]] = node_name_list[node_id][1];
			//node_id_to_node_name[node_name_list[node_id][0]] = ((node_name_list[node_id][1].compare("UNKNOWN") == STR_EQ)?"":node_name_list[node_id][1]);
		// Read nodes
		StringMatrix module_node_list;
		Reset(qri);
		qri.query = "SELECT node_id, node_type, node_role FROM motif_node";
		qri.query += " WHERE motif_name = '" + module_info_list[module_id][1] + "'";
		qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_node_list, &qri.zErrMsg);
		if(qri.rc != SQLITE_OK) {
			cout << qri.query << endl;
			std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
			sqlite3_free(qri.zErrMsg);
		}
		// Read all information
		double module_cost = 0;
		std::map<string, int> node_id_to_bionode_id;
		for (unsigned int node_id = 0; node_id < module_node_list.size(); node_id++) {
			BioNetNode* bnn = CreateBioNetNode(module_node_list[node_id][1], node_id_to_node_name[module_node_list[node_id][0]]);
			node_id_to_bionode_id[module_node_list[node_id][0]] = module_editor->InsertNode(bnn);
			if (module_node_list[node_id][2].compare("Input") == STR_EQ)
				inputs.push_back(node_id_to_bionode_id[module_node_list[node_id][0]]);
			else {
				if ((bnn->component->getType() == PROTEIN || bnn->component->getType() == m_RNA || bnn->component->getType() == t_RNA) && module_cost < 1)
					module_cost = 1;
				if (module_node_list[node_id][2].compare("Output") == STR_EQ)
					outputs.push_back(node_id_to_bionode_id[module_node_list[node_id][0]]);
				else if (module_node_list[node_id][2].compare("Input-Output") == STR_EQ) {
				//	inputs.push_back(node_id_to_bionode_id[module_node_list[node_id][0]]);
				//	outputs.push_back(node_id_to_bionode_id[module_node_list[node_id][0]]);
					cout << "SBROME: Error!!!!!!" << endl;
				}
			}
		}
		// Read edges
		StringMatrix module_edge_list;
		Reset(qri);
		qri.query = "SELECT src_node_id, dest_node_id, edge_type FROM motif_edge";
		qri.query += " WHERE motif_name = '" + module_info_list[module_id][1] + "'";
		qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_edge_list, &qri.zErrMsg);
		if(qri.rc != SQLITE_OK) {
			cout << qri.query << endl;
			std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
			sqlite3_free(qri.zErrMsg);
		}
		for (unsigned int edge_id = 0; edge_id < module_edge_list.size(); edge_id++)
			module_editor->InsertEdge(node_id_to_bionode_id[module_edge_list[edge_id][0]],node_id_to_bionode_id[module_edge_list[edge_id][1]], new BioNetEdge(module_edge_list[edge_id][2]));
		// Process for the exceptional cases, it should be handled by a language rather than a graph
		if (module_info_list[module_id][1].compare("input_ligand") == STR_EQ) { // For the case where the module only contains one node
			int input_node_id = module_editor->InsertNode(CreateBioNetNode("INPUT"));
			((InputSignal*)((BioNetNode*)module_editor->GetNodeAttr(input_node_id))->component)->physical_instance = ((BioNetNode*)module_editor->GetNodeAttr(outputs[0]))->component->clone();
			((BioNetNode*)module_editor->GetNodeAttr(input_node_id))->component->name = ((BioNetNode*)module_editor->GetNodeAttr(outputs[0]))->component->name;
			inputs.push_back(input_node_id);
			module_editor->InsertEdge(input_node_id,outputs[0],new BioNetEdge);
		}
		else if (module_info_list[module_id][1].compare("protein_output") == STR_EQ) {
			int output_node_id = module_editor->InsertNode(CreateBioNetNode("OUTPUT"));
			((OutputSignal*)((BioNetNode*)module_editor->GetNodeAttr(output_node_id))->component)->physical_instance = ((BioNetNode*)module_editor->GetNodeAttr(inputs[0]))->component->clone();
			((BioNetNode*)module_editor->GetNodeAttr(output_node_id))->component->name = ((BioNetNode*)module_editor->GetNodeAttr(inputs[0]))->component->name;
			outputs.push_back(output_node_id);
			module_editor->InsertEdge(inputs[0],output_node_id,new BioNetEdge);
		}
		// Create a new module
		module_list->at(module_id) = new Module(module_editor, inputs, outputs);
		module_list->at(module_id)->cost = module_cost;
		if (!module_info_list[module_id][2].empty())
			module_list->at(module_id)->name = module_info_list[module_id][2];
		else
			module_list->at(module_id)->name = "Module " + module_info_list[module_id][0];
		// TEST HERE
		//module_list->at(module_id)->TestPrint(&std::cout);
	}
	vector<Module*>* module_list_tmp = GenerateModuleLibrary("Database/ML_June_2013.txt");
	//cout << "Number of parts: " << module_list->size() << " Number of modules: " << module_list_tmp->size() << endl;
	for (int i = 0 ; i < module_list_tmp->size(); i++)
		module_list->push_back(module_list_tmp->at(i));
	delete module_list_tmp;
	return module_list;
}

vector<Module*>* PartDatabase::GenerateModuleLibrary(string filename) const {
	vector<Module*>* module_list = new vector<Module*>;
	StringMatrix fragment_list;
	StringMatrix* ligand_production_list = getAllInteractionSpecies("Ligand");
	StringMatrix* complex_production_list = getAllInteractionSpecies("LigandProteinComplex");
	AppendStringMatrix(complex_production_list, getAllInteractionSpecies("RNAComplex"));
	AppendStringMatrix(complex_production_list, getAllInteractionSpecies("ProteinComplex"));
	ifstream infile;
	infile.open(filename.c_str());
	while(!infile.eof()) {
		string module_name, part_list, inputs, outputs, author, title, journal, year;
		infile >> module_name;
		if (module_name.empty())
			break;	// ???
		infile >> part_list;
		vector<string>* species_name_list = split_string(part_list,'+');
		//cout << part_list << endl;
		infile >> inputs;
		vector<string>* input_list = split_string(inputs, ',');
		infile >> outputs;
		vector<string>* output_list = split_string(outputs, ',');
		// Analyze the part list here
		ARGEdit* module_editor = new ARGEdit;
		int current_promoter_node_id = UNKNOWN;
		map<string,int> available_species;
		IdList direct_product_node_id_list;
		int* node_id_map = new int[species_name_list->size()];	// map from species id to node id in the graph
		for (int species_id = 0; species_id < species_name_list->size(); species_id++) {
			string species_name = species_name_list->at(species_id);
			if (species_name[species_name.length() - 1] == '<' || species_name[species_name.length() - 1] == '>')
				species_name.erase(species_name.length() - 1, 1);
			string species_type = getSpeciesType(species_name);
			if (species_type.compare("Terminator") != STR_EQ && species_type.compare("Origin") != STR_EQ) {
				int node_id_tmp =  module_editor->InsertNode(CreateBioNetNode(species_type, species_name));
				available_species[species_name] = node_id_map[species_id] = node_id_tmp;
				direct_product_node_id_list.push_back(node_id_tmp);
			}
			else {
				node_id_map[species_id] = UNKNOWN;	// Terminator or Origin
			}
		}
		for (int species_id = 0; species_id < species_name_list->size(); species_id++) {
			string species_name = species_name_list->at(species_id);
			if (species_name[species_name.length() - 1] == '<') { // a left promoter
				for (int i = species_id - 1; i >= 0; i--) { // a left promoter
					string tmp = species_name_list->at(i);
					if (tmp[tmp.length() - 1] == '>' || tmp[tmp.length() - 1] == '<' || tmp.compare("TTT") == STR_EQ || tmp.compare("XXX") == STR_EQ)
						break;
					else
						module_editor->InsertEdge(node_id_map[species_id], node_id_map[i], new BioNetEdge("ACT"));
				}
			}
			if (species_name[species_name.length() - 1] == '>') { // a right promoter
				for (int i = species_id + 1; i < species_name_list->size(); i++) {
					string tmp = species_name_list->at(i);
					if (tmp[tmp.length() - 1] == '>' || tmp[tmp.length() - 1] == '<' || tmp.compare("TTT") == STR_EQ || tmp.compare("XXX") == STR_EQ)
						break;
					else
						module_editor->InsertEdge(node_id_map[species_id], node_id_map[i], new BioNetEdge("ACT"));
				}
			}
		}
		// Add input nodes
		IdList input_node_id_list;
		if (input_list->at(0).compare("EMPTY") != STR_EQ)
			for (int i = 0; i < input_list->size(); i++)
				if (available_species.find(input_list->at(i)) == available_species.end()) {
					int node_id_tmp = module_editor->InsertNode(CreateBioNetNode(getSpeciesType(input_list->at(i)), input_list->at(i)));
					available_species[input_list->at(i)] = node_id_tmp;
					input_node_id_list.push_back(node_id_tmp);
				}
				else
					input_node_id_list.push_back(available_species.find(input_list->at(i))->second);
		// Add ligand nodes which are produced from proteins
		for (int i = 0; i < ligand_production_list->size(); i++)
			if (available_species.find(ligand_production_list->at(i)[0]) == available_species.end()) {
				int j;
				for (j = 1; j < ligand_production_list->at(i).size(); j++)
					if (available_species.find(ligand_production_list->at(i)[j]) == available_species.end())
						break;
				if (j == ligand_production_list->at(i).size()) {
					int node_id_tmp = module_editor->InsertNode(CreateBioNetNode(getSpeciesType(ligand_production_list->at(i)[0]), ligand_production_list->at(i)[0]));
					available_species[ligand_production_list->at(i)[0]] = node_id_tmp;
				}
			}
		// Add complex nodes which are produced from proteins
		IdList complex_node_id_list;
		for (int i = 0; i < complex_production_list->size(); i++) {
			if (available_species.find(complex_production_list->at(i)[0]) == available_species.end()) {
				//cout << complex_production_list->at(i)[0] << endl;
				int j;
				for (j = 1; j < complex_production_list->at(i).size(); j++)
					if (available_species.find(complex_production_list->at(i)[j]) == available_species.end()) {
						//cout << complex_production_list->at(i)[j] << endl;
						break;
					}
				if (j == complex_production_list->at(i).size()) {
					int node_id_tmp = module_editor->InsertNode(CreateBioNetNode(getSpeciesType(complex_production_list->at(i)[0]), complex_production_list->at(i)[0]));
					available_species[complex_production_list->at(i)[0]] = node_id_tmp;
					complex_node_id_list.push_back(node_id_tmp);
					complex_node_id_list.push_back(node_id_tmp);
				}
			}
		}
		// Add output nodes
		IdList output_node_id_list;
		if (output_list->at(0).compare("EMPTY") != STR_EQ)
			for (int i = 0; i < output_list->size(); i++)
				if (available_species.find(output_list->at(i)) != available_species.end())
					output_node_id_list.push_back(available_species.find(output_list->at(i))->second);
				else
					cout << "SBROME: Error! the output " << output_list->at(i) << " is irrelavant with module " << module_name << endl;
		// Add edges
		for (int src_node_id = 0; src_node_id < module_editor->NodeCount(); src_node_id++)
			for (int dest_node_id = 0; dest_node_id < module_editor->NodeCount(); dest_node_id++) {
				string edge_type = getSpeciesInteractionType(((BioNetNode*)module_editor->GetNodeAttr(src_node_id))->component->name,((BioNetNode*)module_editor->GetNodeAttr(dest_node_id))->component->name);
				//cout << ((BioNetNode*)module_editor->GetNodeAttr(src_node_id))->component->name << "\t" << edge_type << "\t" << ((BioNetNode*)module_editor->GetNodeAttr(dest_node_id))->component->name << endl;
				if (edge_type.compare("NONE") != STR_EQ)
					module_editor->InsertEdge(src_node_id, dest_node_id, new BioNetEdge(edge_type));
			}
		// End analysis
		author = ReadSentence(&infile);
		title = ReadSentence(&infile);
		journal = ReadSentence(&infile);
		infile >> year;
		string ref = author + ". " + title + ". " + journal + ", " + year;
		Module* original_module = new Module(module_editor, input_node_id_list, output_node_id_list);
		//cout << "+++++++++++++++++" << endl;
		//original_module->TestPrint(&std::cout);
		//cout << "+++++++++++++++++" << endl;
		// Generate all fragment modules here
		// Mark ligand nodes
		bool* is_direct_product_node = new bool[original_module->NodeCount()];
		for (int i = 0; i < original_module->NodeCount(); i++)
			is_direct_product_node[i] = false;
		for (int i = 0; i < direct_product_node_id_list.size(); i++)
			is_direct_product_node[i] = true;
		// Mark complex nodes
		bool* is_complex_node = new bool[original_module->NodeCount()];
		for (int i = 0; i < original_module->NodeCount(); i++)
			is_complex_node[i] = false;
		for (int i = 0; i < complex_node_id_list.size(); i++)
			is_complex_node[i] = true;
		// Generate all fragments
		int minimum_length = 2;	// threshold value for the fragment size
		for (int left_i = 0; left_i < species_name_list->size() - minimum_length + 1; left_i++)
			for (int right_i = left_i + minimum_length - 1; right_i < species_name_list->size(); right_i++) {
				// Check if the fragment appeared or not
				bool is_appeared_already = false;
				for (int fragment_id = 0; fragment_id < fragment_list.size(); fragment_id++)
					if (fragment_list[fragment_id].size() == right_i - left_i + 1) {
						bool is_the_same = true;;
						for (int species_id = 0; species_id < fragment_list[fragment_id].size(); species_id++)
							if (species_name_list->at(left_i + species_id).compare(fragment_list[fragment_id][species_id]) != STR_EQ) {
								is_the_same = false;
								break;

							}
						if (is_the_same) {
							is_appeared_already = true;
							break;
						}
					}
				if (is_appeared_already) {
					//cout << species_name_list->at(left_i) << " ... " << species_name_list->at(right_i) << " is repeated" << endl;
					continue;
				}
				else {
					vector<string> tmp;
					for (int species_id = left_i; species_id <= right_i; species_id++)
						tmp.push_back(species_name_list->at(species_id));
					fragment_list.push_back(tmp);
				}
				// clone here
				ARGEdit* tmp_editor = (ARGEdit*) original_module->ConvertToLoader();
				bool* is_removed = new bool [tmp_editor->NodeCount()];
				string fragment_name = module_name + ": ";
				for (int i = left_i; i <= right_i; i++) {
					fragment_name += species_name_list->at(i);
					if (i < right_i)
						fragment_name += "+";
				}
				// Determine gene product nodes
				for (int i = 0; i < tmp_editor->NodeCount(); i++)
					is_removed[i] = true;
				for (int i = left_i; i <= right_i; i++)
					if (node_id_map[i] != UNKNOWN)
						is_removed[node_id_map[i]] = false;
				// Determine complex nodes
				bool is_continue = true;
				while (is_continue) {
					is_continue = false;
					for (int i = 0; i < original_module->NodeCount(); i++) {
						if (is_removed[i] && original_module->InEdgeCount(i) && !is_direct_product_node[i]) {
							bool is_produced_completely = true;
							bool is_produced_partially = false;
							bool is_used = false;
							for (int j = 0; j < original_module->NodeCount(); j++)
								if (i != j && original_module->GetEdgeAttr(j,i) != NULL)
									if (is_removed[j]) {
										is_produced_completely = false;
										break;
									}
									else
										is_produced_partially = true;
							for (int j = 0; j < original_module->NodeCount(); j++)
								if (i != j && original_module->GetEdgeAttr(i,j) != NULL && !is_removed[j]) {
									is_used = true;
									break;
								}
							if (is_produced_completely || (is_produced_partially && is_used)) {
								is_removed[i] = false;
								is_continue = true;
							}
						}
					}
				}
				IdList input_node_id_list_tmp, output_node_id_list_tmp;
				// Determine the inputs
				for (int i = 0 ; i < original_module->NodeCount(); i++) {
					if (is_removed[i]) {
						int out_edge_num = original_module->OutEdgeCount(i);
						for	(int j = 0; j < out_edge_num; j++) {
							if (!is_removed[original_module->GetOutEdge(i,j)]) {
								input_node_id_list_tmp.push_back(i);
								break;
							}
						}
					}
				}
				// Determine the outputs
				for (int i = 0 ; i < original_module->NodeCount(); i++) {
					if (!is_removed[i]) {
						int out_edge_num = original_module->OutEdgeCount(i);
						for	(int j = 0; j < out_edge_num; j++) {
							if (is_removed[original_module->GetOutEdge(i,j)]) {
								output_node_id_list_tmp.push_back(i);
								break;
							}
						}
					}
				}
				for (int i = 0; i < input_node_id_list_tmp.size(); i++)
					is_removed[input_node_id_list_tmp[i]] = false;
				// Add the global outputs
				for (int i = 0; i < output_node_id_list.size(); i++)
					if (!is_removed[output_node_id_list[i]]) {
						int j;
						for (j = 0; j < output_node_id_list_tmp.size(); j++)
							if (output_node_id_list[i] == output_node_id_list_tmp[j])
								break;
						if (j == output_node_id_list_tmp.size())
							output_node_id_list_tmp.push_back(output_node_id_list[i]);
					}
				// Update the input & output nodes list since the indexed will be changed after some irrelevant nodes are deleted
				for (int i = 0; i < input_node_id_list_tmp.size(); i++) {
					int c = 0;
					for (int j = 0; j < input_node_id_list_tmp[i]; j++)
						if (is_removed[j])
							c++;
					input_node_id_list_tmp[i] -= c;
				}
				for (int i = 0; i < output_node_id_list_tmp.size(); i++) {
					int c = 0;
					for (int j = 0; j < output_node_id_list_tmp[i]; j++)
						if (is_removed[j])
							c++;
					output_node_id_list_tmp[i] -= c;
				}
				// Remove irrelevant nodes
				for (int i = original_module->NodeCount() - 1; i >= 0; i--)
					if (is_removed[i])
						tmp_editor->DeleteNode(i);
				// Modify the mRNA input node to UNKNOWN
				for (int i = 0; i < input_node_id_list_tmp.size(); i++) {
					GeneCircuitComponent* tmp = ((BioNetNode*)tmp_editor->GetNodeAttr(input_node_id_list_tmp[i]))->component;
					if (tmp->getType() == m_RNA)
						tmp->name = "UNKNOWN";
				}
				Module* module_tmp = new Module(tmp_editor, input_node_id_list_tmp, output_node_id_list_tmp);
				module_tmp->name = fragment_name;
				//module_tmp->reference
				//cout << "=====================================" << endl;
				//module_tmp->TestPrint(&std::cout);
				//cout << "=====================================" << endl;
				if (module_tmp->outputs.size() == 1 && module_tmp->Topo_Sort()) {
					if (left_i == 0 && right_i == species_name_list->size() - 1)
						module_tmp->cost = 0.95;
					else
						module_tmp->cost = 1;
					module_list->push_back(module_tmp);
					//cout << "+++++++++++++++++++++++++++++++++++" << endl;
					//module_tmp->TestPrint(&std::cout);
					//cout << "+++++++++++++++++++++++++++++++++++" << endl;
				}
			}
		delete original_module;
		delete [] node_id_map;
	}
	infile.close();
	//cout << module_list->size() << endl;
	return module_list;
}

void PartDatabase::getAllInteractedSpecies(string species_name, StringList* dest_species_name_list, IdList* interaction_type_list) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT dest_species, interaction_type FROM species_interaction";
	qri.query +=  " WHERE src_species = '" + species_name + "'";
	StringMatrix result_list;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &result_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	//cout << species_name << "\t" << src_name_list.size() << endl;
	for (int j = 0; j < result_list.size(); j++) {
		dest_species_name_list->push_back(result_list[j][0]);
		interaction_type_list->push_back((result_list[j][1].compare("ACT")==STR_EQ)?ACTIVATORY:INHIBITORY);
	}
}

StringMatrix* PartDatabase::getAllInteractionSpecies(string species_type) const {
	StringMatrix* tmp = new StringMatrix;
	QueryResultInfo qri = Init();
	qri.query = "SELECT species_name FROM species";
	qri.query += " WHERE species_type = '" + species_type + "'";
	//cout << qri.query << endl;
	StringMatrix species_name_list;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &species_name_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	for (int i = 0; i < species_name_list.size(); i++) {
		string species_name = species_name_list[i][0];
		//cout << endl << "--------------" << endl;
		//cout << species_name << endl;
		//cout << "--------------" << endl;
		Reset(qri);
		qri.query = "SELECT src_species FROM species_interaction";
		qri.query +=  " WHERE dest_species = '" + species_name + "'";
		StringMatrix src_name_list;
		qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &src_name_list, &qri.zErrMsg);
		if(qri.rc != SQLITE_OK) {
			cout << qri.query << endl;
			std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
			sqlite3_free(qri.zErrMsg);
		}
		if (!src_name_list.empty()) {
			vector<string> list_tmp;
			list_tmp.push_back(species_name);
			for (int j = 0; j < src_name_list.size(); j++) {
				list_tmp.push_back(src_name_list[j][0]);
				//cout << src_name_list[j][0] << "\t";
			}
			tmp->push_back(list_tmp);
		}
	}
	return tmp;
}

string PartDatabase::getSpeciesType(string species_name) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT species_type FROM species";
	qri.query += " WHERE species_name = '" + species_name + "'";
	//cout << qri.query << endl;
	StringMatrix regulation_type;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &regulation_type, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (regulation_type.empty()) {
		cout << species_name << "\t is not found in the DB" <<  endl;
		return "";
	}
	else
		return regulation_type[0][0];
}

bool PartDatabase::is_output(string species_name) const {
	QueryResultInfo qri = Init();
	qri.query = "SELECT node_id FROM module_node";
	qri.query += " WHERE node_name = '"+ species_name + "' AND (module_name IN (SELECT module_name FROM module_info WHERE motif_name = 'protein_output'))";
	//cout << qri.query << endl;
	StringMatrix node_id;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &node_id, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	//cout << species_name << ((!node_id.empty())?" YES" : " NO") << endl;
	return (!node_id.empty());
}

string PartDatabase::getSpeciesInteractionType(string src_species_name, string dest_species_name) const{
	QueryResultInfo qri = Init();
	qri.query = "SELECT interaction_type FROM species_interaction";
	qri.query += " WHERE src_species = '" + src_species_name + "' AND dest_species = '" + dest_species_name + "'";
	//cout << qri.query << endl;
	StringMatrix interaction_type;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &interaction_type, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (interaction_type.empty())
		return "NONE";
	else {
		//cout << src_species_name << "\t" << interaction_type[0][0] << "\t" << dest_species_name << endl;
		return interaction_type[0][0];
	}
}
int PartDatabase::getRegulationType(Molecule* m1, Molecule* m2) {
	QueryResultInfo qri = Init();
	qri.query = "SELECT regulation FROM Regulation";
	qri.query += " WHERE src_type = '" + Id2Str(m1->getType()) + "' AND src_name = '" + m1->getName() + "' AND dest_type = '" + Id2Str(m2->getType()) + "' AND dest_name = '" + m2->getName() + "'";
	//cout << qri.query << endl;
	StringMatrix regulation_type;
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &regulation_type, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	if (regulation_type.empty())
		return NONE;
	else
		if (regulation_type[0][0].compare("ACT") == STR_EQ)
			return ACTIVATORY;
		else
			return INHIBITORY;
}

IdList InEdgeList(ARGEdit* editor, int node_id) {
	IdList tmp;
	int n = editor->NodeCount();
	for (int i = 0; i < n; i++) {
		int out_n = editor->OutEdgeCount(i);
		for (int j = 0; j < out_n; j++) {
			void** v = NULL;
			if (editor->GetOutEdge(i,j,v) == node_id)
				tmp.push_back(i);
		}
	}
	return tmp;
}

int getCurrentNodeOutputType(ARGEdit* editor, GeneCircuitGraph* gcg, int node_id) {
	GeneCircuitComponent* gcc;
	if (editor == NULL)
		gcc = gcg->GetNodeAttr(node_id)->component;
	else
		gcc = ((BioNetNode*)editor->GetNodeAttr(node_id))->component;
	if (gcc->getCategory() == LOGIC_GATE) {
		return m_RNA;
	}
	else if (gcc->getCategory() == MOLECULE) {
		return gcc->getType();
	}
	else if (gcc->getType() == INPUT) {
		return LIGAND;
	}
	else if (gcc->getType() == SELECTOR) {
		if (editor == NULL) {
			return getCurrentNodeOutputType(editor, gcg, gcg->GetInEdge(node_id,0));
		}
		else {
			IdList tmp = InEdgeList(editor, node_id);
			return getCurrentNodeOutputType(editor, gcg, tmp[0]);
		}
	}
	else {
		cout << "EXPANSION ERROR: Inputs of logic gates are only LOGIC GATE, MOLECULE, INPUT or SELECTOR. Other cases have not been considered" << endl;
		return UNKNOWN;
	}
}
IdList InputTypeList(GeneCircuitGraph* gcg, int node_id) {
	IdList result;
	int number_of_in_nodes = gcg->InEdgeCount(node_id);
	for (int i = 0; i < number_of_in_nodes; i++)
		result.push_back(getCurrentNodeOutputType(NULL, gcg, gcg->GetInEdge(node_id, i)));
	return result;
}
IdList InputTypeList(ARGEdit* editor, int node_id) {
	IdList input_node_list = InEdgeList(editor, node_id);
	IdList result;
	for (int i = 0; i < input_node_list.size(); i++)
		result.push_back(getCurrentNodeOutputType(editor, NULL, input_node_list[i]));
	return result;
}
int OutEdge (ARGEdit* editor, int node_id) {
	void** tmp = NULL;
	return editor->GetOutEdge(node_id,0,tmp);
}
IdList OutputTypeList(ARGEdit* editor, int node_id) {
	int current_node_id = OutEdge(editor, node_id);
	while (((BioNetNode*)editor->GetNodeAttr(current_node_id))->component->getType() == SELECTOR)
		current_node_id = OutEdge(editor, current_node_id);
	IdList result;
	if (((BioNetNode*)editor->GetNodeAttr(current_node_id))->component->getType() == OUTPUT)
		result.push_back(PROTEIN);
	else
		result.push_back(m_RNA);
	return result;
}
IdList OutputTypeList(GeneCircuitGraph* gcg, int node_id) {
	int current_node_id = gcg->GetOutEdge(node_id,0);
	while (((BioNetNode*)gcg->GetNodeAttr(current_node_id))->component->getType() == SELECTOR)
		current_node_id = gcg->GetOutEdge(current_node_id,0);
	IdList result;
	if (((BioNetNode*)gcg->GetNodeAttr(current_node_id))->component->getType() == OUTPUT)
		result.push_back(PROTEIN);
	else
		result.push_back(m_RNA);
	return result;
}
void PartDatabase::ExpandAndMergeTopology (GeneCircuitGraph* input_topology) const {
	//input_topology->TestPrint(&std::cout);
	GRNEdit* editor = input_topology->ConvertToLoader();
	bool is_fully_expanded;
	do {
		is_fully_expanded = true;
		int n = editor->NodeCount();
		//cout << "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
		//editor->TestPrint(&std::cout);
		//cout << "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
		for (int node_id = 0; node_id < n; node_id++) {
			BioNetNode* node_tmp = (BioNetNode*)editor->GetNodeAttr(node_id);
			if (node_tmp->component->getCategory() == LOGIC_GATE) {
				// TEST HERE
				//cout << "==============================" << endl;
				//editor->TestPrint(&std::cout);
				//cout << "==============================" << endl;
				// END HERE
				IdList input_type_list = InputTypeList(editor, node_id);
				vector<Module*> module_list = loadMotifTopologyList(Id2Str(node_tmp->component->getType()), node_tmp->component->name, input_type_list, OutputTypeList(editor, node_id));
				if (!module_list.size())
					break;
				else {
					int select_node_id = UNKNOWN;
					if (module_list.size() > 1 || (module_list[0]->inputs.size() == 2 && !IsSymmetric(module_list[0]) && !IsSymmetricInput(editor, node_id))) {
						// Add select node and connect the select node with the next node of the module
						select_node_id = editor->InsertNode(CreateBioNetNode("SELECTOR"));
						int number_of_succ_nodes = editor->OutEdgeCount(node_id);
						for (int i = 0; i < number_of_succ_nodes; i++) {
							void** tmp = new void*;
							int j = editor->GetOutEdge(node_id,i,tmp);
							editor->InsertEdge(select_node_id,j,*tmp);
						}
					}
					bool is_symmetric_input = IsSymmetricInput(editor, node_id);
					for (int module_id = 0; module_id < module_list.size(); module_id++) {
						Module* expansion_module = module_list[module_id];
						// TEST HERE
						//cout << "/////////////////////" << endl;
						//expansion_module->TestPrint(&std::cout);
						//cout << "/////////////////////" << endl;
						// END TEST
						if (expansion_module->inputs.size() > 2)
							cout << "ERROR: Device has more that two inputs" << endl;
						else {
							bool* is_input = new bool[expansion_module->NodeCount()];
							for (int i_tmp = 0; i_tmp < expansion_module->NodeCount(); i_tmp++)
								is_input[i_tmp] = false;
							for (int i_tmp = 0; i_tmp < expansion_module->inputs.size(); i_tmp++)
								is_input[i_tmp] = true;
							int number_of_copies = (expansion_module->inputs.size() == 1 || (expansion_module->inputs.size() == 2 && (IsSymmetric(expansion_module) || input_type_list[0] != input_type_list[1] || is_symmetric_input))) ? 1 : 2;
							// TEST HERE
							//cout << "Symmetric: " << ((number_of_copies==1)?"Y":"N") << endl;
							// END TEST
							for (int copy_id = 0; copy_id < number_of_copies; copy_id++) {
								map<int,int> module_to_new;
								// Add nodes
								for (int i = 0; i < expansion_module->NodeCount(); i++)
									if (!is_input[i])
										module_to_new[i] = editor->InsertNode(expansion_module->GetNodeAttr(i)->clone());
								// Add edges
								for (int i = 0; i < expansion_module->NodeCount(); i++)
									for (int j = 0; j < expansion_module->NodeCount(); j++)
										if (!is_input[i] && !is_input[j] && i != j && expansion_module->GetEdgeAttr(i,j) != NULL)
											editor->InsertEdge(module_to_new[i], module_to_new[j], expansion_module->GetEdgeAttr(i,j)->clone());
								// Add connections from the module to the current editor
								// from module to select node
								if (select_node_id == UNKNOWN) {
									int number_of_succ_nodes = editor->OutEdgeCount(node_id);
									for (int i = 0; i < number_of_succ_nodes; i++) {
										void** tmp = new void*;
										int j = editor->GetOutEdge(node_id,i,tmp);
										editor->InsertEdge(module_to_new[expansion_module->outputs[0]],j, *tmp);
									}
								}
								else
									editor->InsertEdge(module_to_new[expansion_module->outputs[0]],select_node_id,new BioNetEdge());
								// to module
								IdList pre_input_list;
								for (int i = 0; i < editor->NodeCount(); i++) {
									void ** tmp = NULL;
									int out_edge_count = editor->OutEdgeCount(i);
									for (int j = 0; j < out_edge_count; j++)
									if (editor->GetOutEdge(i,j,tmp) == node_id) {
										pre_input_list.push_back(i);
										break;
									}
								}
								if (expansion_module->inputs.size() == 1) {
									int succ_input = expansion_module->GetOutEdge(expansion_module->inputs[0],0);
									editor->InsertEdge(pre_input_list[0], module_to_new[succ_input], expansion_module->GetEdgeAttr(expansion_module->inputs[0], succ_input)->clone());
								}
								else {
									int succ_input_0 = expansion_module->GetOutEdge(expansion_module->inputs[0],0);
									int succ_input_1 = expansion_module->GetOutEdge(expansion_module->inputs[1],0);
									bool parallel;
									if (number_of_copies == 2)
										if (copy_id == 0)
											parallel = true;
										else
											parallel = false;
									else {
										// TEST HERE
										//cout << "Output pre-node: " << Id2Str(getCurrentNodeOutputType(editor,pre_input_list[0])) << "\t 1st input of the module: " << Id2Str(expansion_module->GetNodeAttr(expansion_module->inputs[0])->component->getType()) << endl;
										// END TEST
										if (getCurrentNodeOutputType(editor, NULL, pre_input_list[0]) == expansion_module->GetNodeAttr(expansion_module->inputs[0])->component->getType())
											parallel = true;
										else
											parallel = false;
									}
									if (parallel) {
										editor->InsertEdge(pre_input_list[0], module_to_new[succ_input_0], expansion_module->GetEdgeAttr(expansion_module->inputs[0], succ_input_0)->clone());
										editor->InsertEdge(pre_input_list[1], module_to_new[succ_input_1], expansion_module->GetEdgeAttr(expansion_module->inputs[1], succ_input_1)->clone());
									}
									else {
										editor->InsertEdge(pre_input_list[0], module_to_new[succ_input_1], expansion_module->GetEdgeAttr(expansion_module->inputs[0], succ_input_0)->clone());
										editor->InsertEdge(pre_input_list[1], module_to_new[succ_input_0], expansion_module->GetEdgeAttr(expansion_module->inputs[1], succ_input_1)->clone());
									}
								}
							}
						}
						// TEST HERE
						//cout << "------------------------------" << endl;
						//editor->TestPrint(&std::cout);
						//cout << "------------------------------" << endl;
						// END HERE
					}
				}
				is_fully_expanded = false;
				editor->DeleteNode(node_id);
				// TEST HERE
				//cout << "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
				//editor->TestPrint(&std::cout);
				//cout << "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
				// END TEST
				break;
			}
		}
	}
	while (!is_fully_expanded);
	// REMOVE ALL SELECTORS
	// TEST HERE
	//cout << "****************************" << endl;
	//editor->TestPrint(&std::cout);
	//cout << "****************************" << endl;
	// END TEST
	bool is_simplified_completely;
	do {
		// TEST HERE
		//cout << "****************************" << endl;
		//simplified_editor->TestPrint(&std::cout);
		//cout << "****************************" << endl;
		// END TEST
		is_simplified_completely = true;
		for (int node_id = 0; node_id < editor->NodeCount(); node_id++) {
			GeneCircuitComponent* comp_tmp = ((BioNetNode*)editor->GetNodeAttr(node_id))->component;
			if (comp_tmp->getType() == SELECTOR && ((SelectorSignal*)comp_tmp)->physical_instance == NULL) {
				is_simplified_completely = false;
				int n_out = editor->OutEdgeCount(node_id);
				int n_in = editor->InEdgeCount(node_id);
				for (int i = 0; i < n_out; i++) {
					int succ_node_id = editor->getOutEdge(node_id, i);
					GeneCircuitComponent* tmp = ((BioNetNode*)editor->GetNodeAttr(succ_node_id))->component;
					while (tmp->getType() == SELECTOR)
						tmp = ((SelectorSignal*)tmp)->physical_instance;
					((BioNetNode*)editor->GetNodeAttr(succ_node_id))->component = new SelectorSignal(tmp);
					delete tmp;
					for (int j = 0; j < n_in; j++) {
						int pre_node_id = editor->getInEdge(node_id,j);
						editor->InsertEdge(pre_node_id, succ_node_id, editor->getEdgeAttr(node_id,succ_node_id)->clone());
					}
				}
				editor->DeleteNode(node_id);
				break;
			}
		}
	}
	while (!is_simplified_completely);
	input_topology->ResetLoader(editor);
	for (int node_id = 0; node_id < input_topology->NodeCount(); node_id++)
		if (input_topology->GetNodeAttr(node_id)->component->getType() == POOL) {
			GeneCircuitComponent* gcc = input_topology->GetNodeAttr(node_id)->component;
			if (((PoolSignal*) gcc)->physical_instance == NULL) {
				int pre_type;
				if (input_topology->GetNodeAttr(input_topology->GetInEdge(node_id,0))->component->getCategory() != CIRCUIT_SIGNAL)
					pre_type = input_topology->GetNodeAttr(input_topology->GetInEdge(node_id,0))->component->getType();
				else
					pre_type = ((CircuitSignal*)input_topology->GetNodeAttr(input_topology->GetInEdge(node_id,0))->component)->physical_instance->getType();
				((PoolSignal*) gcc)->physical_instance = CreateComponent(Id2Str(pre_type));
			}
		}
}

vector<ExpansionResultInfo> PartDatabase::TopologyExpansion(GeneCircuitGraph* input_topology) const {
	stack<ExpansionResultInfo> main_stack;
	vector<ExpansionResultInfo> tmp;
	ExpansionInfo dummy;
	main_stack.push(std::make_pair(input_topology, dummy));
	while (!main_stack.empty()) {
		ExpansionResultInfo current_expansion_result_info = main_stack.top();
		GeneCircuitGraph* current_topology = current_expansion_result_info.first;
		main_stack.pop();
		bool fully_expanded_module = true;
		for (int node_id = 0; node_id < current_topology->NodeCount(); node_id++) {
			if (current_topology->GetNodeAttr(node_id)->component->getCategory() == LOGIC_GATE) {
				// TEST HERE
				//cout << "------- current: " << node_id << endl;
				//current_topology->TestPrint(&std::cout);
				//cout << "------- " << endl;
				// END TEST
				fully_expanded_module = false;
				IdList input_type_list = InputTypeList(current_topology, node_id);
				vector<Module*> module_list = loadMotifTopologyList(Id2Str(current_topology->GetNodeAttr(node_id)->component->getType()), current_topology->GetNodeAttr(node_id)->component->name, input_type_list, OutputTypeList(current_topology, node_id));
				for (int expansion_id = 0; expansion_id < module_list.size(); expansion_id++) {
					Module* expansion_module = module_list[expansion_id];
					// TEST HERE
					//expansion_module->TestPrint(&std::cout);
					// END TEST
					ARGEdit* module_editor_tmp_1 = new ARGEdit;
					ARGEdit* module_editor_tmp_2 = new ARGEdit;
					bool* is_input = new bool[expansion_module->NodeCount()];
					for (int i_tmp = 0; i_tmp < expansion_module->NodeCount(); i_tmp++)
						is_input[i_tmp] = false;
					for (int i_tmp = 0; i_tmp < expansion_module->inputs.size(); i_tmp++)
						is_input[i_tmp] = true;
					map<int,int> old_to_new, module_to_new;
					// Add nodes
					for (int i = 0; i < current_topology->NodeCount(); i++)
						if (i != node_id) {
							old_to_new[i] = module_editor_tmp_1->InsertNode(current_topology->GetNodeAttr(i)->clone());
							module_editor_tmp_2->InsertNode(current_topology->GetNodeAttr(i)->clone());
						}
					for (int i = 0; i < expansion_module->NodeCount(); i++)
						if (!is_input[i]) {
							module_to_new[i] = module_editor_tmp_1->InsertNode(expansion_module->GetNodeAttr(i)->clone());
							module_editor_tmp_2->InsertNode(expansion_module->GetNodeAttr(i)->clone());
						}
					// Add edges
					for (int i = 0; i < current_topology->NodeCount(); i++)
							for (int j = 0; j < current_topology->NodeCount(); j++)
								if (i != node_id && j != node_id && i != j && current_topology->GetEdgeAttr(i,j) != NULL) {
									module_editor_tmp_1->InsertEdge(old_to_new[i], old_to_new[j], current_topology->GetEdgeAttr(i,j)->clone());
									module_editor_tmp_2->InsertEdge(old_to_new[i], old_to_new[j], current_topology->GetEdgeAttr(i,j)->clone());
								}
					for (int i = 0; i < expansion_module->NodeCount(); i++)
						for (int j = 0; j < expansion_module->NodeCount(); j++)
							if (!is_input[i] && !is_input[j] && i != j && expansion_module->GetEdgeAttr(i,j) != NULL) {
								module_editor_tmp_1->InsertEdge(module_to_new[i], module_to_new[j], expansion_module->GetEdgeAttr(i,j)->clone());
								module_editor_tmp_2->InsertEdge(module_to_new[i], module_to_new[j], expansion_module->GetEdgeAttr(i,j)->clone());
							}
					if (expansion_module->inputs.size() == 1) {
						// Add a connection between the old input node to the expanded module
						int pre_input = current_topology->GetInEdge(node_id,0);	// the node that connects to the expanded node
						int succ_input = expansion_module->GetOutEdge(expansion_module->inputs[0],0);
						module_editor_tmp_1->InsertEdge(old_to_new[pre_input], module_to_new[succ_input], expansion_module->GetEdgeAttr(expansion_module->inputs[0], succ_input)->clone());
						int number_of_succ_nodes = current_topology->OutEdgeCount(node_id);
						for (int i = 0; i < number_of_succ_nodes; i++)
							module_editor_tmp_1->InsertEdge(module_to_new[expansion_module->outputs[0]], old_to_new[current_topology->GetOutEdge(node_id,i)], new BioNetEdge());
						NodeExpansionInfo info_tmp(node_id, expansion_module->name, pre_input);
						vector<NodeExpansionInfo> current_expansion_result_info_1 = current_expansion_result_info.second;
						current_expansion_result_info_1.push_back(info_tmp);
						main_stack.push(std::make_pair(new GeneCircuitGraph(module_editor_tmp_1), current_expansion_result_info_1));
						// TEST HERE
						//cout << "====================" << endl;
						//main_stack.top().first->TestPrint(&std::cout);
						//cout << "====================" << endl;
						// END TEST
					}
					else if (expansion_module->inputs.size() == 2) {
						int number_of_copies = (IsSymmetric(expansion_module) || input_type_list[0] != input_type_list[1]) ? 1 : 2;
						// Add a connection between the old input node to the expanded module
						int pre_input_1 = current_topology->GetInEdge(node_id,0);	// 1st node that connects to the expanded node
						int pre_input_2 = current_topology->GetInEdge(node_id,1);	// 2nd node that connects to the expanded node
						int succ_input_1 = expansion_module->GetOutEdge(expansion_module->inputs[0],0);
						int succ_input_2 = expansion_module->GetOutEdge(expansion_module->inputs[1],0);
						module_editor_tmp_1->InsertEdge(old_to_new[pre_input_1], module_to_new[succ_input_1], expansion_module->GetEdgeAttr(expansion_module->inputs[0], succ_input_1)->clone());
						module_editor_tmp_1->InsertEdge(old_to_new[pre_input_2], module_to_new[succ_input_2], expansion_module->GetEdgeAttr(expansion_module->inputs[1], succ_input_2)->clone());
						module_editor_tmp_2->InsertEdge(old_to_new[pre_input_2], module_to_new[succ_input_1], expansion_module->GetEdgeAttr(expansion_module->inputs[0], succ_input_1)->clone());
						module_editor_tmp_2->InsertEdge(old_to_new[pre_input_1], module_to_new[succ_input_2], expansion_module->GetEdgeAttr(expansion_module->inputs[1], succ_input_2)->clone());
						int number_of_succ_nodes = current_topology->OutEdgeCount(node_id);
						for (int i = 0; i < number_of_succ_nodes; i++) {
							module_editor_tmp_1->InsertEdge(module_to_new[expansion_module->outputs[0]], old_to_new[current_topology->GetOutEdge(node_id,i)], new BioNetEdge());
							module_editor_tmp_2->InsertEdge(module_to_new[expansion_module->outputs[0]], old_to_new[current_topology->GetOutEdge(node_id,i)], new BioNetEdge());
						}
						if (getCurrentNodeOutputType(NULL, current_topology, pre_input_1) == expansion_module->GetNodeAttr(expansion_module->inputs[0])->component->getType()) {
							NodeExpansionInfo info_tmp_1(node_id, expansion_module->name, pre_input_1, pre_input_2);
							vector<NodeExpansionInfo> current_expansion_result_info_1 = current_expansion_result_info.second;
							current_expansion_result_info_1.push_back(info_tmp_1);
							main_stack.push(std::make_pair(new GeneCircuitGraph(module_editor_tmp_1), current_expansion_result_info_1));
							// TEST HERE
							//cout << "====================" << endl;
							//main_stack.top().first->TestPrint(&std::cout);
							//cout << "====================" << endl;
							// END TEST
						}
						if (number_of_copies == 2 || (number_of_copies == 1 && getCurrentNodeOutputType(NULL, current_topology, pre_input_1) != expansion_module->GetNodeAttr(expansion_module->inputs[0])->component->getType())) {
							NodeExpansionInfo info_tmp_2(node_id, expansion_module->name, pre_input_2, pre_input_1);
							vector<NodeExpansionInfo> current_expansion_result_info_2 = current_expansion_result_info.second;
							current_expansion_result_info_2.push_back(info_tmp_2);
							main_stack.push(std::make_pair(new GeneCircuitGraph(module_editor_tmp_2), current_expansion_result_info_2));
							// TEST HERE
							//cout << "====================" << endl;
							//main_stack.top().first->TestPrint(&std::cout);
							//cout << "====================" << endl;
							// END TEST
						}
					}
					else {
						cout << "ERROR: Device has more that two inputs" << endl;
					}
				}
				break;
			}
		}
		if (fully_expanded_module) {
			// TEST HERE
			//cout << "--------------------------" << endl;
			//current_expansion_result_info.first->TestPrint(&std::cout);
			//cout << "__________________________" << endl;
			//for (int i = 0; i < current_expansion_result_info.second.size(); i++)
			//	cout << current_expansion_result_info.second[i].expanded_node_id << "\t" << current_expansion_result_info.second[i].motif_name << endl;
			//cout << "--------------------------" << endl;
			// END TEST
			GeneCircuitGraph* gcg_tmp = current_expansion_result_info.first;
			for (int node_id = 0; node_id < gcg_tmp->NodeCount(); node_id++)
				if (gcg_tmp->GetNodeAttr(node_id)->component->getType() == POOL) {
					GeneCircuitComponent* gcc = gcg_tmp->GetNodeAttr(node_id)->component;
					if (((PoolSignal*) gcc)->physical_instance == NULL) {
						int pre_type;
						if (gcg_tmp->GetNodeAttr(gcg_tmp->GetInEdge(node_id,0))->component->getCategory() != CIRCUIT_SIGNAL)
							pre_type = gcg_tmp->GetNodeAttr(gcg_tmp->GetInEdge(node_id,0))->component->getType();
						else
							pre_type = ((CircuitSignal*)gcg_tmp->GetNodeAttr(gcg_tmp->GetInEdge(node_id,0))->component)->physical_instance->getType();
						((PoolSignal*) gcc)->physical_instance = CreateComponent(Id2Str(pre_type));
					}
				}
			tmp.push_back(current_expansion_result_info);
		}
	}
	return tmp;
}

vector<Module*> PartDatabase::loadMotifTopologyList(string functional_device_type, string category_name, IdList input_type_list, IdList output_type_list) const {
	// TEST HERE
	//cout << functional_device_type << "\t" << category_name << endl;
	//cout << "INPUTS: ";
	//for (int i = 0; i < input_type_list.size(); i++)
	//	cout << Id2Str(input_type_list[i]) << "\t";
	//cout << endl << "OUTPUTS: ";
	//for (int i = 0; i < output_type_list.size(); i++)
	//	cout << Id2Str(output_type_list[i]) << "\t";
	//cout << endl;
	// END TEST
	QueryResultInfo qri = Init();
	StringMatrix motif_name_list;
	if (category_name.empty() || category_name.compare("UNKNOWN") == STR_EQ) {
		qri.query = "SELECT device_motif, input1, input2, output FROM device_expansion";
		qri.query += " WHERE device_type = '" + functional_device_type + "'";
		qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &motif_name_list, &qri.zErrMsg);
		if(qri.rc != SQLITE_OK) {
			cout << qri.query << endl;
			std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
			sqlite3_free(qri.zErrMsg);
		}
	}
	else {
		cout << "SBORME ERROR: A logic gate with a specific name can not be expanded" << endl;
	}
	vector<Module*> tmp;
	if (motif_name_list.size()) {
		for (int motif_id = 0; motif_id < motif_name_list.size(); motif_id++) {
			bool is_compatible = true;
			string input1 = motif_name_list[motif_id][1];
			string input2 = motif_name_list[motif_id][2];
			string output = motif_name_list[motif_id][3];
			if (input_type_list.size() == 1) {
				if (Str2Id(input1) != input_type_list[0])
					is_compatible = false;
			}
			else if ((Str2Id(input1) != input_type_list[0] || Str2Id(input2) != input_type_list[1]) && (Str2Id(input1) != input_type_list[1] || Str2Id(input2) != input_type_list[0]))
				is_compatible = false;
			if (Str2Id(output) != output_type_list[0])
				is_compatible = false;
			if (is_compatible)
				tmp.push_back(loadMotifTopology(motif_name_list[motif_id][0]));
		}
	}
	else {
		cout << "SBROME: Empty expansion list " << endl;
	}
	return tmp;
}

Module* PartDatabase::loadMotifTopology(string motif_name, vector<NodeVisualInfo> *module_visual_info_list) const {
	QueryResultInfo qri = Init();
	ARGEdit* module_editor = new ARGEdit;
	// Read nodes
	StringMatrix module_node_list;
	Reset(qri);
	qri.query = "SELECT node_id, node_type, node_name, node_role, pos_x, pos_y, width, height FROM motif_node";
	qri.query += " WHERE motif_name = '" + motif_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_node_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	std::map<string, int> node_id_to_bionode_id;
	IdList input_tmp, output_tmp;
	for (unsigned int node_id = 0; node_id < module_node_list.size(); node_id++) {
		if (module_visual_info_list != NULL) {
			NodeVisualInfo tmp;
			tmp.pos_x = atoi(module_node_list[node_id][4].c_str());
			tmp.pos_y = atoi(module_node_list[node_id][5].c_str());
			tmp.width = atoi(module_node_list[node_id][6].c_str());
			tmp.height = atoi(module_node_list[node_id][7].c_str());
			module_visual_info_list->push_back(tmp);
		}
		int id_tmp = module_editor->InsertNode(CreateBioNetNode(module_node_list[node_id][1], module_node_list[node_id][2]));
		node_id_to_bionode_id[module_node_list[node_id][0]] = id_tmp;
		if (module_node_list[node_id][3].compare("Input") == STR_EQ)
			input_tmp.push_back(id_tmp);
		else if (module_node_list[node_id][3].compare("Output") == STR_EQ)
			output_tmp.push_back(id_tmp);
		else if (module_node_list[node_id][3].compare("Input_Output") == STR_EQ) {
			input_tmp.push_back(id_tmp);
			output_tmp.push_back(id_tmp);
		}
	}
	// Read edges
	StringMatrix module_edge_list;
	Reset(qri);
	qri.query = "SELECT src_node_id, dest_node_id, edge_type FROM motif_edge";
	qri.query += " WHERE motif_name = '" + motif_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_edge_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	for (unsigned int edge_id = 0; edge_id < module_edge_list.size(); edge_id++)
		module_editor->InsertEdge(node_id_to_bionode_id[module_edge_list[edge_id][0]],node_id_to_bionode_id[module_edge_list[edge_id][1]], new BioNetEdge(module_edge_list[edge_id][2]));
	// Create a new module
	Module* tmp = new Module(module_editor);
	tmp->name = motif_name;
	tmp->inputs = input_tmp;
	tmp->outputs = output_tmp;
	// TEST HERE
	//cout << "~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
	//cout << motif_name << endl;
	//tmp->TestPrint(&std::cout);
	//cout << "~~~~~~~~~~~~~~~~~~~~~~~~" << endl;
	return tmp;
}

Module* PartDatabase::loadContent(string macro_module_type, string macro_module_name, vector<NodeVisualInfo> *module_visual_info_list) const {
	QueryResultInfo qri = Init();
	ARGEdit* module_editor = new ARGEdit;
	// Read node name
	StringMatrix node_name_list;
	Reset(qri);
	qri.query = "SELECT node_id, node_name FROM module_node";
	qri.query += " WHERE module_name = '" + macro_module_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &node_name_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	map<string, string> node_id_to_node_name;
	for (unsigned int node_id = 0; node_id < node_name_list.size(); node_id++)
		node_id_to_node_name[node_name_list[node_id][0]] = node_name_list[node_id][1];
	// Read motif name
	Reset(qri);
	qri.query = "SELECT motif_name FROM module_info";
	qri.query += " WHERE module_name = '" + macro_module_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &qri.string_matrix, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	string motif_name = qri.string_matrix[0][0];
	// Read nodes
	StringMatrix module_node_list;
	Reset(qri);
	qri.query = "SELECT node_id, node_type, node_role, pos_x, pos_y, width, height FROM motif_node";
	qri.query += " WHERE motif_name = '" + motif_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_node_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	std::map<string, int> node_id_to_bionode_id;
	IdList input_tmp, output_tmp;
	for (unsigned int node_id = 0; node_id < module_node_list.size(); node_id++) {
		if (module_visual_info_list != NULL) {
			NodeVisualInfo tmp;
			tmp.pos_x = atoi(module_node_list[node_id][3].c_str());
			tmp.pos_y = atoi(module_node_list[node_id][4].c_str());
			tmp.width = atoi(module_node_list[node_id][5].c_str());
			tmp.height = atoi(module_node_list[node_id][6].c_str());
			module_visual_info_list->push_back(tmp);
		}
		int id_tmp = module_editor->InsertNode(CreateBioNetNode(module_node_list[node_id][1], node_id_to_node_name[module_node_list[node_id][0]]));
		node_id_to_bionode_id[module_node_list[node_id][0]] = id_tmp;
		if (module_node_list[node_id][2].compare("Input") == STR_EQ)
			input_tmp.push_back(id_tmp);
		else if (module_node_list[node_id][2].compare("Output") == STR_EQ)
			output_tmp.push_back(id_tmp);
		else if (module_node_list[node_id][2].compare("Input-Output") == STR_EQ) {
			input_tmp.push_back(id_tmp);
			output_tmp.push_back(id_tmp);
		}
	}
	// Read edges
	StringMatrix module_edge_list;
	Reset(qri);
	qri.query = "SELECT src_node_id, dest_node_id, edge_type FROM motif_edge";
	qri.query += " WHERE motif_name = '" + motif_name + "'";
	qri.rc = sqlite3_exec(db, qri.query.c_str(), callback_string, &module_edge_list, &qri.zErrMsg);
	if(qri.rc != SQLITE_OK) {
		cout << qri.query << endl;
		std::cout << "SQL error: \n" << qri.zErrMsg << std::endl;
		sqlite3_free(qri.zErrMsg);
	}
	for (unsigned int edge_id = 0; edge_id < module_edge_list.size(); edge_id++)
		module_editor->InsertEdge(node_id_to_bionode_id[module_edge_list[edge_id][0]],node_id_to_bionode_id[module_edge_list[edge_id][1]], new BioNetEdge(module_edge_list[edge_id][2]));
	// Create a new module
	Module* tmp = new Module(module_editor);
	tmp->inputs = input_tmp;
	tmp->outputs = output_tmp;
	// TODO: solve for the EMPTY OR GATE here
	if (macro_module_type.compare("OR_GATE") == STR_EQ && tmp->inputs.size() == 1)
		tmp->inputs.push_back(tmp->inputs[0]);
	// TEST HERE
	//cout << macro_module_type << "\t" << macro_module_name << endl;
	//tmp->TestPrint(&std::cout);
	return tmp;
}

double ev(int k, int n, double alpha) {
	return pow(alpha,k) - 1 - n*(alpha - 1);
}
double find_scale(int k, int n) { // solve the equation (alpha^k - 1)/(alpha - 1) = n --> alpha^k - 1 - n(alpha - 1) = 0
	double u = n, l = 1 + 1e-10;
	while (u - l > 1e-10) {
		double mid = (u + l)/2;
		if ((ev(k,n,u) > 0 && ev(k,n,mid) < 0) || (ev(k,n,u) < 0 && ev(k,n,mid) > 0))
			l = mid;
		else
			u = mid;
	}
	return (u+l)/2;
}

vector<Module*>* PartDatabase::RandomizeModuleLibrary(int library_size, int max_module_size) {
	vector<Module*>* tmp;
	int total_number_of_modules = 0;
	int max_module_library_size = floor(0.4*library_size);
	double scale = find_scale(max_module_size - 1, max_module_library_size);
	for (int module_size = max_module_size; module_size > 1; module_size--) {
		int number_of_modules = round(pow(scale, max_module_size - module_size));
		total_number_of_modules += number_of_modules;
		for (int module_id = 0; module_id < number_of_modules; module_id++) {
			// Generate module topology, each module has more than one gates
			Module* module = GenerateGateNetwork(module_size,round(0.4*module_size), false);
			// Fill names
			tmp->push_back(module);
		}
	}
	// Generate single gates
	// Generate molecules cascade
	// Generate single molecules and YES-GATE
	return tmp;
}

vector<string>* split_string(string str, char c) {
	vector<string>* string_list = new vector<string>;
	int pre_index = 0;
	for (int i = 0; i < str.length(); i++)
		if (str[i] == c) {
			string_list->push_back(str.substr(pre_index, i - pre_index));
			pre_index = i + 1;
		}
	string_list->push_back(str.substr(pre_index, str.length() - pre_index));
	return string_list;
}

string ReadSentence(ifstream* f) {
	string final_sentence;
	*f >> final_sentence;
	if (final_sentence[0] == '[') {
		string tmp;
		do {
			*f >> tmp;
			final_sentence += " ";
			final_sentence += tmp;
		}
		while (tmp[tmp.length() - 1] != ']');
		final_sentence = final_sentence.erase(0,1);
		final_sentence = final_sentence.erase(final_sentence.length() - 1,1);
	}
	return final_sentence;
}

QueryResultInfo Init() {
	QueryResultInfo qri;
	qri.zErrMsg = NULL;
	qri.query = "";
	qri.string_matrix.clear();
	return qri;
}

void AppendStringMatrix(StringMatrix* sm1, StringMatrix* sm2) { // sm1 = sm1 + sm2
	for (int i = 0; i < sm2->size(); i++)
		sm1->push_back(sm2->at(i));
	delete sm2;
}

void Reset(QueryResultInfo& qri) {
	qri.zErrMsg = NULL;
	qri.query = "";
	qri.string_matrix.clear();
}

string Num2StrPlus1(int num) {
	stringstream ss;
	ss << num + 1; // PLUS 1
	string tmp(ss.str());
	return tmp;
}

string Num2Str(int num) {
	stringstream ss;
	ss << num;
	string tmp(ss.str());
	return tmp;
}
string Num2Str(double num) {
	num = round(num*1000)/1000;
	std::ostringstream strs;
	strs << num;
	return strs.str();
}
