/*
 * DesignProblem.h
 *
 *  Created on: Apr 20, 2012
 *      Author: linh, UC Davis
 */

#ifndef DESIGNPROBLEM_H_
#define DESIGNPROBLEM_H_

#include <iostream>
#include <string>
#include <map>
#include "GeneCircuitGraph.h"
#include "xmlParser.h"
#include "string.h"

class SimulationData {
public:
	IdList inputs, outputs;						// List of ids of input nodes & output nodes
	ValueMatrix input_values, output_values;	// number of rows = number of data points (for steady state cases) or number of time points (temporal cases)
	void TestPrint(ostream* f);
};

class DesignProblem {
public:
	DesignProblem(string filename);
	void Reset(string filename);
	void TestPrint(ostream* f);
	map<int,NodeVisualInfo> visual_info;
	GeneCircuitGraph gcg;
	SimulationData desired_behavior;
};

class DesignSolution {
public:
	SimulationData simulation_behavior;
	GeneCircuitGraph gcg;
	ExpansionInfo exp_info;
};

NodeVisualInfo* GetVisualInfo(XMLNode xml_node);
#endif /* DESIGNPROBLEM_H_ */
