/*
 * PartDatabase.h
 *
 *  Created on: Aug 8, 2012
 *      Author: linh
 */

#ifndef PARTDATABASE_H_
#define PARTDATABASE_H_

#include <string>
#include <sqlite3.h>
#include <sstream>
#include "VFLIB/argedit.h"
#include "GRN.h"
#include "GeneCircuitGraph.h"

struct QueryResultInfo {
	// For access DB
	int rc;
	char *zErrMsg;
	std::string query;
	StringMatrix string_matrix;
};

struct TranscriptionRegulation {
	int regulator_type;
	double binding_affinity;
	double cooperativity;
};

struct LigandRegulation {
	double dissociation;
	double cooperativity;
};

class PartDatabase {
public:
	PartDatabase();
	PartDatabase(std::string db_filename);
	virtual ~PartDatabase();

	// Interface
	int getNumberOfProteins() const;
	BioNetNode* getBioNetNode(int module_id, int node_id) const;
	double getDegradationRate(string protein_name) const;
	int getNumberOfMutants(string promoter_name) const;

	double getPromoterBasal(string promoter_name, int mutant_index) const;
	double getPromoterStrength(string promoter_name, int mutant_index) const;
	TranscriptionRegulation getPromoterRegulation(string regulator_name, string promoter_name) const;
	LigandRegulation getLigandRegulation(string inducer_name, string protein_name) const;

	vector<Module*>* RandomizeModuleLibrary(int library_size, int max_module_size);

	// For module library, load each module and integrate the inputs
	vector<Module*>* loadModuleLibrary();
	vector<Module*>* GenerateModuleLibrary(string filename) const;
	string getSpeciesType(string species_name) const;
	bool is_output(string species_name) const;
	string getSpeciesInteractionType(string src_species_name, string dest_species_name) const;
	void getAllInteractedSpecies(string species_name, StringList* dest_species_name_list, IdList* interaction_type_list) const;
	StringMatrix* getAllInteractionSpecies(string species_type) const;
	// For regulation
	int getRegulationType(Molecule* m1, Molecule* m2);
	// For functional module substitutions
	void ExpandAndMergeTopology (GeneCircuitGraph* input_topology) const;
	vector<ExpansionResultInfo> TopologyExpansion(GeneCircuitGraph* input_topology) const;
	vector<Module*> loadMotifTopologyList(string functional_device_type, string category_name, IdList input_type_list, IdList output_type_list) const;
	Module* loadMotifTopology(string motif_name, vector<NodeVisualInfo> *module_visual_info_list = NULL) const;
	// For macro module substitutions
	Module* loadContent(string macro_module_type, string macro_module_name, vector<NodeVisualInfo> *module_visual_info_list = NULL) const;

private:
	sqlite3 *db;
	int number_of_proteins;
	vector<Module*>* module_library;
	vector<Module*>* InitializeModuleLibrary();
};

void Reset(QueryResultInfo &qri);
vector<string>* split_string(string str, char c);
void AppendStringMatrix(StringMatrix* sm1, StringMatrix* sm2);
string ReadSentence(ifstream* f);
QueryResultInfo Init();
string Num2StrPlus1(int num);
string Num2Str(int num);
string Num2Str(double num);

#endif /* PARTDATABASE_H_ */
