/*
 * main.cpp
 *
 *  Created on: Apr 8, 2012
 *      Author: linh, UC Davis
 */

#include <stdio.h>
#include <iostream>
#include <fstream>
#include <string>
#include <math.h>
#include <stdlib.h>
#include <time.h>
#include <ctime>
#include <map>

#include "DesignProblem.h"
#include "PartDatabase.h"
#include "Framework.h"

using namespace std;

void Experiment(string database_filename, string input_filename, string output_filename) {
	// Number of gates, number of possible topologies, number of modules (DP,ES), running time (HEU, ES, DP)
	cout << "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" << endl;
	cout << input_filename << endl;
	cout << "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" << endl;
	clock_t begin = clock();
  	Framework framework(database_filename, input_filename);
	clock_t end = clock();
	double loading_time = double(end - begin) / CLOCKS_PER_SEC;
	RunningTimeInfo t0 = framework.Optimize(ES, SI, output_filename);
	cout << "--------------------------------" << endl;
	RunningTimeInfo t2 = framework.Optimize(HS, SI, output_filename);
	cout << "--------------------------------" << endl;
	RunningTimeInfo t1 = framework.Optimize(DP, SI, output_filename);
	cout << "++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++" << endl;
}

void Bioinformarics_Testcase() {
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/2-cascade.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/3-cascade.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/4-cascade.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/band-detector.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/feed-forward.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/not-and.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/3-input-and.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/3-input-not-and.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	Experiment("Database/CAD","Benchmarks/Bioinformatics/2-to-1-multiplexer-1.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/D1_Nat_Biotech.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/D2_Nat_Biotech.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");

	//Experiment("Database/CAD","Benchmarks/Bioinformatics/2-to-1-multiplexer-2.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/band-detector-1.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/pulse-generator.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/pulse-generator-1.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Bioinformatics/1-bit-full-adder.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
}

int main() {
	Bioinformarics_Testcase();
	//Experiment("Database/CAD","Benchmarks/Simple/Without_IO/YES.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Simple/Without_IO/NOT.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	//Experiment("Database/CAD","Benchmarks/Simple/Without_IO/AND.xml","Database/XML_ORDERED_SCALED_FOR_OUTPUT.xml");
	cout << "FINISH!" << endl;
}
