/*
 * Decompiled with CFR 0.152.
 */
package jspecview.app;

import java.net.URL;
import java.util.Map;
import javajs.util.List;
import javajs.util.PT;
import jspecview.api.AppletFrame;
import jspecview.api.JSVAppInterface;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTreeNode;
import jspecview.api.PanelListener;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelNode;
import jspecview.common.Parameters;
import jspecview.common.PeakPickEvent;
import jspecview.common.ScriptToken;
import jspecview.common.ScriptTokenizer;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.source.FileReader;
import jspecview.source.JDXSource;
import jspecview.util.JSVEscape;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSVApp
implements PanelListener,
JSVAppInterface {
    protected AppletFrame appletFrame;
    private int fileCount;
    private int nViews;
    private int scriptLevelCount;
    boolean isNewWindow;
    private boolean allowCompoundMenu = true;
    private boolean allowMenu = true;
    private boolean autoIntegrate;
    private boolean interfaceOverlaid;
    private boolean loadImaginary = false;
    private Boolean obscureTitleFromUser;
    private int initialStartIndex = -1;
    private int initialEndIndex = -1;
    private String integrationRatios;
    public String appletReadyCallbackFunctionName;
    private String coordCallbackFunctionName;
    private String loadFileCallbackFunctionName;
    private String peakCallbackFunctionName;
    private String syncCallbackFunctionName;
    public JSViewer viewer;
    private JSVPanel prevPanel;
    private String returnFromJmolModel;

    public JSVApp(AppletFrame appletFrame, boolean isJS) {
        this.appletFrame = appletFrame;
        this.initViewer(isJS);
        this.init();
    }

    private void initViewer(boolean isJS) {
        this.viewer = new JSViewer(this, true, isJS);
        this.appletFrame.setDropTargetListener(this.isSigned(), this.viewer);
        URL path = this.appletFrame.getDocumentBase();
        JSVFileManager.setDocumentBase(this.viewer, path);
    }

    @Override
    public boolean isPro() {
        return this.isSigned();
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    @Override
    public void siSetCurrentSource(JDXSource source) {
        this.viewer.currentSource = source;
    }

    @Override
    public int siGetFileCount() {
        return this.fileCount;
    }

    @Override
    public void siSetFileCount(int n) {
        this.fileCount = n;
    }

    @Override
    public void siSetIntegrationRatios(String value) {
        this.integrationRatios = value;
    }

    @Override
    public String siGetIntegrationRatios() {
        return this.integrationRatios;
    }

    public AppletFrame getAppletFrame() {
        return this.appletFrame;
    }

    @Override
    public void siSetLoadImaginary(boolean TF) {
        this.loadImaginary = TF;
    }

    @Override
    public int siIncrementScriptLevelCount(int n) {
        return this.scriptLevelCount += n;
    }

    @Override
    public int siIncrementViewCount(int n) {
        return this.nViews += n;
    }

    public void dispose() {
        try {
            this.viewer.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getPropertyAsJavaObject(String key) {
        return this.viewer.getPropertyAsJavaObject(key);
    }

    @Override
    public String getPropertyAsJSON(String key) {
        return PT.toJSON(null, this.getPropertyAsJavaObject(key));
    }

    @Override
    public String getCoordinate() {
        return this.viewer.getCoordinate();
    }

    @Override
    public void loadInline(String data) {
        this.siOpenDataOrFile(data, null, null, null, -1, -1, true);
        this.appletFrame.validateContent(3);
    }

    @Override
    public String exportSpectrum(String type, int n) {
        return this.viewer.export(type, n);
    }

    @Override
    public void setFilePath(String tmpFilePath) {
        this.runScript("load " + JSVEscape.eS(tmpFilePath));
    }

    @Override
    public void setSpectrumNumber(int n) {
        this.runScript((Object)((Object)ScriptToken.SPECTRUMNUMBER) + " " + n);
    }

    @Override
    public void reversePlot() {
        this.toggle(ScriptToken.REVERSEPLOT);
    }

    @Override
    public void toggleGrid() {
        this.toggle(ScriptToken.GRIDON);
    }

    @Override
    public void toggleCoordinate() {
        this.toggle(ScriptToken.COORDINATESON);
    }

    @Override
    public void toggleIntegration() {
        this.toggle(ScriptToken.INTEGRATE);
    }

    private void toggle(ScriptToken st) {
        JSVPanel jsvp = this.viewer.selectedPanel;
        if (jsvp != null) {
            this.runScript((Object)((Object)st) + " TOGGLE");
        }
    }

    @Override
    public void addHighlight(double x1, double x2, int r, int g, int b, int a) {
        this.viewer.addHighLight(x1, x2, r, g, b, a);
    }

    @Override
    public void removeAllHighlights() {
        this.viewer.removeAllHighlights();
    }

    @Override
    public void removeHighlight(double x1, double x2) {
        this.viewer.removeHighlight(x1, x2);
    }

    @Override
    public void syncScript(String peakScript) {
        this.viewer.syncScript(peakScript);
    }

    @Override
    public void writeStatus(String msg) {
        Logger.info(msg);
    }

    private void init() {
        this.initParams(this.appletFrame.getParameter("script"));
    }

    public void initParams(String params) {
        this.parseInitScript(params);
        this.newAppletPanel();
        this.viewer.setPopupMenu(this.allowMenu, this.viewer.parameters.getBoolean(ScriptToken.ENABLEZOOM));
        this.runScriptNow(params);
    }

    private void newAppletPanel() {
        Logger.info("newAppletPanel");
        this.appletFrame.addNewPanel(this.viewer);
    }

    @Override
    public void siSendPanelChange(JSVPanel jsvp) {
        if (jsvp == this.prevPanel) {
            return;
        }
        this.prevPanel = jsvp;
        this.viewer.sendPanelChange(jsvp);
    }

    @Override
    public void siNewWindow(boolean isSelected, boolean fromFrame) {
        this.isNewWindow = isSelected;
        if (fromFrame) {
            if (this.viewer.jsvpPopupMenu != null) {
                this.viewer.jsvpPopupMenu.setSelected("Window", false);
            }
        } else {
            this.appletFrame.newWindow(isSelected);
        }
    }

    @Override
    public void repaint() {
        this.appletFrame.repaint();
    }

    public void updateJS(int width, int height) {
    }

    @Override
    public void siValidateAndRepaint() {
        if (this.viewer.selectedPanel != null) {
            this.viewer.selectedPanel.getPanelData().taintedAll = true;
        }
        this.appletFrame.validate();
        this.repaint();
    }

    @Override
    public void siSyncLoad(String filePath) {
        this.newAppletPanel();
        Logger.info("JSVP syncLoad reading " + filePath);
        this.siOpenDataOrFile(null, null, null, filePath, -1, -1, false);
        this.appletFrame.validateContent(3);
    }

    private void parseInitScript(String params) {
        if (params == null) {
            params = "";
        }
        ScriptTokenizer allParamTokens = new ScriptTokenizer(params, true);
        if (Logger.debugging) {
            Logger.info("Running in DEBUG mode");
        }
        block17: while (allParamTokens.hasMoreTokens()) {
            String token = allParamTokens.nextToken();
            ScriptTokenizer eachParam = new ScriptTokenizer(token, false);
            String key = eachParam.nextToken();
            if (key.equalsIgnoreCase("SET")) {
                key = eachParam.nextToken();
            }
            key = key.toUpperCase();
            ScriptToken st = ScriptToken.getScriptToken(key);
            String value = ScriptToken.getValue(st, eachParam, token);
            Logger.info("KEY-> " + key + " VALUE-> " + value + " : " + (Object)((Object)st));
            try {
                switch (st) {
                    default: {
                        this.viewer.parameters.set(null, st, value);
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    case APPLETID: {
                        this.viewer.appletID = value;
                        this.viewer.fullName = String.valueOf(this.viewer.appletID) + "__" + this.viewer.syncID + "__";
                        break;
                    }
                    case APPLETREADYCALLBACKFUNCTIONNAME: {
                        this.appletReadyCallbackFunctionName = value;
                        break;
                    }
                    case AUTOINTEGRATE: {
                        this.autoIntegrate = Parameters.isTrue(value);
                        break;
                    }
                    case COMPOUNDMENUON: {
                        this.allowCompoundMenu = Boolean.parseBoolean(value);
                        break;
                    }
                    case COORDCALLBACKFUNCTIONNAME: 
                    case LOADFILECALLBACKFUNCTIONNAME: 
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: {
                        this.siExecSetCallback(st, value);
                        break;
                    }
                    case ENDINDEX: {
                        this.initialEndIndex = Integer.parseInt(value);
                        break;
                    }
                    case INTERFACE: {
                        this.siExecSetInterface(value);
                        break;
                    }
                    case IRMODE: {
                        this.viewer.setIRmode(value);
                        break;
                    }
                    case MENUON: {
                        this.allowMenu = Boolean.parseBoolean(value);
                        break;
                    }
                    case OBSCURE: {
                        if (this.obscureTitleFromUser != null) continue block17;
                        this.obscureTitleFromUser = Boolean.valueOf(value);
                        break;
                    }
                    case STARTINDEX: {
                        this.initialStartIndex = Integer.parseInt(value);
                        break;
                    }
                    case SYNCID: {
                        this.viewer.syncID = value;
                        this.viewer.fullName = String.valueOf(this.viewer.appletID) + "__" + this.viewer.syncID + "__";
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void siOpenDataOrFile(String data, String name, List<JDXSpectrum> specs, String url, int firstSpec, int lastSpec, boolean isAppend) {
        int status = this.viewer.openDataOrFile(data, name, specs, url, firstSpec, lastSpec, isAppend);
        if (status == -1) {
            return;
        }
        if (status != 0) {
            this.siSetSelectedPanel(null);
            return;
        }
        if (this.viewer.jsvpPopupMenu != null) {
            this.viewer.jsvpPopupMenu.setCompoundMenu(this.viewer.panelNodes, this.allowCompoundMenu);
        }
        Logger.info(String.valueOf(this.appletFrame.getAppletInfo()) + " File " + this.viewer.currentSource.getFilePath() + " Loaded Successfully");
    }

    @Override
    public void siProcessCommand(String scriptItem) {
        this.viewer.runScriptNow(scriptItem);
    }

    @Override
    public boolean runScriptNow(String params) {
        return this.viewer.runScriptNow(params);
    }

    private void checkCallbacks() {
        Coordinate actualCoord;
        if (this.coordCallbackFunctionName == null && this.peakCallbackFunctionName == null) {
            return;
        }
        Coordinate coord = new Coordinate();
        Coordinate coordinate = actualCoord = this.peakCallbackFunctionName == null ? null : new Coordinate();
        if (!this.viewer.selectedPanel.getPanelData().getPickedCoordinates(coord, actualCoord)) {
            return;
        }
        int iSpec = this.viewer.viewPanel.getCurrentPanelIndex();
        if (actualCoord == null) {
            this.appletFrame.callToJavaScript(this.coordCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), iSpec + 1});
        } else {
            this.appletFrame.callToJavaScript(this.peakCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), actualCoord.getXVal(), actualCoord.getYVal(), iSpec + 1});
        }
    }

    @Override
    public void siSetSelectedPanel(JSVPanel jsvp) {
        this.viewer.viewPanel.setSelectedPanel(jsvp, this.viewer.panelNodes);
        this.viewer.selectedPanel = jsvp;
        this.viewer.spectraTree.setSelectedPanel(this, jsvp);
        this.appletFrame.validate();
        if (jsvp != null) {
            jsvp.setEnabled(true);
            jsvp.setFocusable(true);
        }
    }

    public void doAdvanced(String filePath) {
    }

    @Override
    public void panelEvent(Object eventObj) {
        if (eventObj instanceof PeakPickEvent) {
            this.viewer.processPeakPickEvent(eventObj, false);
        } else if (!(eventObj instanceof ZoomEvent)) {
            boolean cfr_ignored_0 = eventObj instanceof SubSpecChangeEvent;
        }
    }

    @Override
    public void siExecSetCallback(ScriptToken st, String value) {
        switch (st) {
            case LOADFILECALLBACKFUNCTIONNAME: {
                this.loadFileCallbackFunctionName = value;
                break;
            }
            case PEAKCALLBACKFUNCTIONNAME: {
                this.peakCallbackFunctionName = value;
                break;
            }
            case SYNCCALLBACKFUNCTIONNAME: {
                this.syncCallbackFunctionName = value;
                break;
            }
            case COORDCALLBACKFUNCTIONNAME: {
                this.coordCallbackFunctionName = value;
            }
        }
    }

    @Override
    public String getSolnColour() {
        return this.viewer.getSolutionColor();
    }

    @Override
    public void siExecClose(String value) {
        boolean fromScript;
        boolean bl = fromScript = !value.startsWith("!");
        if (fromScript) {
            value = value.substring(1);
        }
        this.viewer.close(value);
        if (!fromScript) {
            this.siValidateAndRepaint();
        }
    }

    @Override
    public String siExecLoad(String value) {
        this.viewer.load(value);
        if (this.viewer.selectedPanel == null) {
            return null;
        }
        if (this.loadFileCallbackFunctionName != null) {
            this.appletFrame.callToJavaScript(this.loadFileCallbackFunctionName, new Object[]{this.viewer.appletID, value});
        }
        return null;
    }

    @Override
    public void siExecHidden(boolean b) {
    }

    @Override
    public void siExecSetInterface(String value) {
        this.interfaceOverlaid = value.equalsIgnoreCase("single") || value.equalsIgnoreCase("overlay");
    }

    @Override
    public void siExecScriptComplete(String msg, boolean isOK) {
        this.siValidateAndRepaint();
    }

    @Override
    public void siExecSetAutoIntegrate(boolean b) {
        this.autoIntegrate = b;
    }

    @Override
    public synchronized void syncToJmol(String msg) {
        if (this.syncCallbackFunctionName == null) {
            return;
        }
        Logger.info("JSVApp.syncToJmol JSV>Jmol " + msg);
        this.appletFrame.callToJavaScript(this.syncCallbackFunctionName, new Object[]{this.viewer.fullName, msg});
    }

    @Override
    public void setVisible(boolean b) {
        this.appletFrame.setPanelVisible(b);
    }

    @Override
    public void siUpdateBoolean(ScriptToken st, boolean TF) {
    }

    @Override
    public void siCheckCallbacks(String title) {
        this.checkCallbacks();
    }

    @Override
    public void siSetNode(PanelNode panelNode, boolean fromTree) {
        if (panelNode.jsvp != this.viewer.selectedPanel) {
            this.siSetSelectedPanel(panelNode.jsvp);
        }
        this.siSendPanelChange(panelNode.jsvp);
        this.appletFrame.validateContent(2);
        this.siValidateAndRepaint();
    }

    @Override
    public void siCloseSource(JDXSource source) {
        this.viewer.closeSource(source);
    }

    @Override
    public void setCursor(int id) {
        this.viewer.apiPlatform.setCursor(id, this.appletFrame);
    }

    @Override
    public boolean siGetAutoCombine() {
        return this.interfaceOverlaid;
    }

    @Override
    public JDXSource siCreateSource(String data, String filePath, int firstSpec, int lastSpec) throws Exception {
        return FileReader.createJDXSource(JSVFileManager.getBufferedReaderForString(data), filePath, this.obscureTitleFromUser == Boolean.TRUE, this.loadImaginary, -1, -1);
    }

    @Override
    public JSVPanel siGetNewJSVPanel2(List<JDXSpectrum> specs) {
        JSVPanel jsvp = this.appletFrame.getJSVPanel(this.viewer, specs, this.initialStartIndex, this.initialEndIndex);
        this.initialStartIndex = -1;
        this.initialEndIndex = -1;
        jsvp.getPanelData().addListener(this);
        this.viewer.parameters.setFor(jsvp, null, true);
        return jsvp;
    }

    @Override
    public JSVPanel siGetNewJSVPanel(JDXSpectrum spec) {
        if (spec == null) {
            this.initialStartIndex = -1;
            this.initialEndIndex = -1;
            return null;
        }
        List<JDXSpectrum> specs = new List<JDXSpectrum>();
        specs.addLast(spec);
        JSVPanel jsvp = this.appletFrame.getJSVPanel(this.viewer, specs, this.initialStartIndex, this.initialEndIndex);
        jsvp.getPanelData().addListener(this);
        this.viewer.parameters.setFor(jsvp, null, true);
        return jsvp;
    }

    @Override
    public PanelNode siGetNewPanelNode(String id, String fileName, JDXSource source, JSVPanel jsvp) {
        return new PanelNode(id, fileName, source, jsvp);
    }

    @Override
    public boolean siGetAutoShowLegend() {
        return false;
    }

    @Override
    public void siSetReturnFromJmolModel(String model) {
        this.returnFromJmolModel = model;
    }

    @Override
    public String siGetReturnFromJmolModel() {
        return this.returnFromJmolModel;
    }

    @Override
    public void siSetPropertiesFromPreferences(JSVPanel jsvp, boolean includeMeasures) {
        if (this.autoIntegrate) {
            jsvp.getPanelData().integrateAll(this.viewer.parameters);
        }
    }

    @Override
    public void siSetLoaded(String fileName, String filePath) {
    }

    @Override
    public void siSetMenuEnables(PanelNode node, boolean isSplit) {
    }

    @Override
    public void siSetRecentURL(String filePath) {
    }

    @Override
    public void siUpdateRecentMenus(String filePath) {
    }

    @Override
    public void siExecTest(String value) {
        String data = "##TITLE= Acetophenone\n##JCAMP-DX= 5.01\n##DATA TYPE= MASS SPECTRUM\n##DATA CLASS= XYPOINTS\n##ORIGIN= UWI, Mona, JAMAICA\n##OWNER= public domain\n##LONGDATE= 2012/02/19 22:20:06.0416 -0600 $$ export date from JSpecView\n##BLOCK_ID= 4\n##$URL= http://wwwchem.uwimona.edu.jm/spectra\n##SPECTROMETER/DATA SYSTEM= Finnigan\n##.INSTRUMENT PARAMETERS= LOW RESOLUTION\n##.SPECTROMETER TYPE= TRAP\n##.INLET= GC\n##.IONIZATION MODE= EI+\n##MOLFORM= C 8 H 8 O\n##$MODELS= \n<Models>\n<ModelData id=\"acetophenone\" type=\"MOL\">\nacetophenone\nDSViewer          3D                             0\n\n17 17  0  0  0  0  0  0  0  0999 V2000\n-1.6931    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  1\n-0.2141    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  2\n2.5839    0.0872    0.0000 C   0  0  0  0  0  0  0  0  0  3\n0.4615    1.2373   -0.0005 C   0  0  0  0  0  0  0  0  0  4\n0.5257   -1.1809    0.0001 C   0  0  0  0  0  0  0  0  0  5\n1.9188   -1.1393    0.0005 C   0  0  0  0  0  0  0  0  0  6\n1.8539    1.2756   -0.0001 C   0  0  0  0  0  0  0  0  0  7\n-0.1262    2.1703   -0.0009 H   0  0  0  0  0  0  0  0  0  8\n0.0144   -2.1556    0.0002 H   0  0  0  0  0  0  0  0  0  9\n2.4947   -2.0764    0.0009 H   0  0  0  0  0  0  0  0  0 10\n2.3756    2.2439   -0.0001 H   0  0  0  0  0  0  0  0  0 11\n3.6838    0.1161    0.0003 H   0  0  0  0  0  0  0  0  0 12\n-2.3403    1.0639    0.0008 O   0  0  0  0  0  0  0  0  0 13\n-2.3832   -1.3197   -0.0010 C   0  0  0  0  0  0  0  0  0 14\n-2.0973   -1.8988    0.9105 H   0  0  0  0  0  0  0  0  0 15\n-2.0899   -1.9018   -0.9082 H   0  0  0  0  0  0  0  0  0 16\n-3.4920   -1.1799   -0.0059 H   0  0  0  0  0  0  0  0  0 17\n1  2  1  0  0  0\n2  5  4  0  0  0\n2  4  4  0  0  0\n3 12  1  0  0  0\n4  7  4  0  0  0\n5  6  4  0  0  0\n6 10  1  0  0  0\n6  3  4  0  0  0\n7  3  4  0  0  0\n7 11  1  0  0  0\n8  4  1  0  0  0\n9  5  1  0  0  0\n13  1  2  0  0  0\n14 16  1  0  0  0\n14  1  1  0  0  0\n14 15  1  0  0  0\n17 14  1  0  0  0\nM  END\n</ModelData>\n<ModelData id=\"2\" type=\"MOL\">\nacetophenone m/z 120\nDSViewer          3D                             0\n\n17 17  0  0  0  0  0  0  0  0999 V2000\n-1.6931    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  1\n-0.2141    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  2\n2.5839    0.0872    0.0000 C   0  0  0  0  0  0  0  0  0  3\n0.4615    1.2373   -0.0005 C   0  0  0  0  0  0  0  0  0  4\n0.5257   -1.1809    0.0001 C   0  0  0  0  0  0  0  0  0  5\n1.9188   -1.1393    0.0005 C   0  0  0  0  0  0  0  0  0  6\n1.8539    1.2756   -0.0001 C   0  0  0  0  0  0  0  0  0  7\n-0.1262    2.1703   -0.0009 H   0  0  0  0  0  0  0  0  0  8\n0.0144   -2.1556    0.0002 H   0  0  0  0  0  0  0  0  0  9\n2.4947   -2.0764    0.0009 H   0  0  0  0  0  0  0  0  0 10\n2.3756    2.2439   -0.0001 H   0  0  0  0  0  0  0  0  0 11\n3.6838    0.1161    0.0003 H   0  0  0  0  0  0  0  0  0 12\n-2.3403    1.0639    0.0008 O   0  0  0  0  0  0  0  0  0 13\n-2.3832   -1.3197   -0.0010 C   0  0  0  0  0  0  0  0  0 14\n-2.0973   -1.8988    0.9105 H   0  0  0  0  0  0  0  0  0 15\n-2.0899   -1.9018   -0.9082 H   0  0  0  0  0  0  0  0  0 16\n-3.4920   -1.1799   -0.0059 H   0  0  0  0  0  0  0  0  0 17\n1  2  1  0  0  0\n2  5  4  0  0  0\n2  4  4  0  0  0\n3 12  1  0  0  0\n4  7  4  0  0  0\n5  6  4  0  0  0\n6 10  1  0  0  0\n6  3  4  0  0  0\n7  3  4  0  0  0\n7 11  1  0  0  0\n8  4  1  0  0  0\n9  5  1  0  0  0\n13  1  2  0  0  0\n14 16  1  0  0  0\n14  1  1  0  0  0\n14 15  1  0  0  0\n17 14  1  0  0  0\nM  END\nacetophenone m/z 105\n\ncreated with ArgusLab version 4.0.1\n13 13  0  0  0  0  0  0  0  0  0 V2000\n-1.6931    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n-0.2141    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n2.5839    0.0872    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n0.4615    1.2373   -0.0005 C   0  0  0  0  0  0  0  0  0  0  0  0\n0.5257   -1.1809    0.0001 C   0  0  0  0  0  0  0  0  0  0  0  0\n1.9188   -1.1393    0.0005 C   0  0  0  0  0  0  0  0  0  0  0  0\n1.8539    1.2756   -0.0001 C   0  0  0  0  0  0  0  0  0  0  0  0\n-2.3403    1.0639    0.0008 O   0  0  0  0  0  0  0  0  0  0  0  0\n-0.1262    2.1703   -0.0009 H   0  0  0  0  0  0  0  0  0  0  0  0\n0.0144   -2.1556    0.0002 H   0  0  0  0  0  0  0  0  0  0  0  0\n2.4947   -2.0764    0.0009 H   0  0  0  0  0  0  0  0  0  0  0  0\n2.3756    2.2439   -0.0001 H   0  0  0  0  0  0  0  0  0  0  0  0\n3.6838    0.1161    0.0003 H   0  0  0  0  0  0  0  0  0  0  0  0\n1  2  1  0  0  0  0\n1  8  2  0  0  0  0\n2  4  4  0  0  0  0\n2  5  4  0  0  0  0\n3  6  4  0  0  0  0\n3  7  4  0  0  0  0\n3 13  1  0  0  0  0\n4  7  4  0  0  0  0\n4  9  1  0  0  0  0\n5  6  4  0  0  0  0\n5 10  1  0  0  0  0\n6 11  1  0  0  0  0\n7 12  1  0  0  0  0\nM  END\nacetophenone m/z 77\n\ncreated with ArgusLab version 4.0.1\n11 11  0  0  0  0  0  0  0  0  0 V2000\n-0.2141    0.0078    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n2.5839    0.0872    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n0.4615    1.2373   -0.0005 C   0  0  0  0  0  0  0  0  0  0  0  0\n0.5257   -1.1809    0.0001 C   0  0  0  0  0  0  0  0  0  0  0  0\n1.9188   -1.1393    0.0005 C   0  0  0  0  0  0  0  0  0  0  0  0\n1.8539    1.2756   -0.0001 C   0  0  0  0  0  0  0  0  0  0  0  0\n-0.1262    2.1703   -0.0009 H   0  0  0  0  0  0  0  0  0  0  0  0\n0.0144   -2.1556    0.0002 H   0  0  0  0  0  0  0  0  0  0  0  0\n2.4947   -2.0764    0.0009 H   0  0  0  0  0  0  0  0  0  0  0  0\n2.3756    2.2439   -0.0001 H   0  0  0  0  0  0  0  0  0  0  0  0\n3.6838    0.1161    0.0003 H   0  0  0  0  0  0  0  0  0  0  0  0\n1  3  4  0  0  0  0\n1  4  4  0  0  0  0\n2  5  4  0  0  0  0\n2  6  4  0  0  0  0\n2 11  1  0  0  0  0\n3  6  4  0  0  0  0\n3  7  1  0  0  0  0\n4  5  4  0  0  0  0\n4  8  1  0  0  0  0\n5  9  1  0  0  0  0\n6 10  1  0  0  0  0\nM  END\n</ModelData>\n</Models>\n##$PEAKS= \n<Peaks type=\"MS\" xUnits=\"M/Z\" yUnits=\"RELATIVE ABUNDANCE\" >\n<PeakData id=\"1\" title=\"molecular ion (~120)\" peakShape=\"sharp\" model=\"2.1\"  xMax=\"121\" xMin=\"119\"  yMax=\"100\" yMin=\"0\" />\n<PeakData id=\"2\" title=\"fragment 1 (~105)\" peakShape=\"sharp\" model=\"2.2\"  xMax=\"106\" xMin=\"104\"  yMax=\"100\" yMin=\"0\" />\n<PeakData id=\"3\" title=\"fragment 2 (~77)\" peakShape=\"sharp\" model=\"2.3\"  xMax=\"78\" xMin=\"76\"  yMax=\"100\" yMin=\"0\" />\n</Peaks>\n##XUNITS= M/Z\n##YUNITS= RELATIVE ABUNDANCE\n##XFACTOR= 1E0\n##YFACTOR= 1E0\n##FIRSTX= 0\n##FIRSTY= 0\n##LASTX= 121\n##NPOINTS= 19\n##XYPOINTS= (XY..XY)\n0.000000, 0.000000 \n38.000000, 5.200000 \n39.000000, 8.000000 \n43.000000, 21.900000 \n50.000000, 20.200000 \n51.000000, 41.900000 \n52.000000, 4.000000 \n63.000000, 3.800000 \n74.000000, 6.600000 \n75.000000, 3.700000 \n76.000000, 4.600000 \n77.000000, 100.000000 \n78.000000, 10.400000 \n89.000000, 1.000000 \n91.000000, 1.000000 \n105.000000, 80.800000 \n106.000000, 6.000000 \n120.000000, 23.100000 \n121.000000, 2.000000 \n##END=";
        this.loadInline(data);
    }

    @Override
    public String siSetFileAsString(String value) {
        return JSVFileManager.getFileAsString(value);
    }

    @Override
    public JSVTreeNode siCreateTree(JDXSource source, JSVPanel[] jsvPanels) {
        return this.viewer.spectraTree.createTree(this, source, jsvPanels);
    }

    @Override
    public JSViewer siGetViewer() {
        return this.viewer;
    }

    @Override
    public void runScript(String script) {
        this.viewer.runScript(script);
    }

    @Override
    public List<String> getScriptQueue() {
        return this.viewer.scriptQueue;
    }
}

