/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Encoding;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.JSVZipInterface;
import jspecview.common.JSVersion;
import jspecview.common.JSViewer;
import jspecview.util.JSVEscape;
import org.jmol.util.Logger;

public class JSVFileManager {
    public static final String SIMULATION_PROTOCOL = "http://SIMULATION/";
    public static URL appletDocumentBase;
    private static JSViewer viewer;
    public static String jsDocumentBase;
    private static final String[] urlPrefixes;
    public static final int URL_LOCAL = 4;
    private static String nciResolver;
    private static String nmrdbServer;
    private static Map<String, String> htSimulate;
    private static int stringCount;

    static {
        jsDocumentBase = "";
        urlPrefixes = new String[]{"http:", "https:", "ftp:", SIMULATION_PROTOCOL, "file:"};
        nciResolver = "http://cactus.nci.nih.gov/chemical/structure/%FILE/file?format=sdf";
        nmrdbServer = "http://www.nmrdb.org/tools/jmol/predict.php?POST?molfile=";
    }

    public boolean isApplet() {
        return appletDocumentBase != null;
    }

    public static String getFileAsString(String name) {
        if (name == null) {
            return null;
        }
        SB sb = new SB();
        try {
            String line;
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(name, null);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.appendC('\n');
            }
            br.close();
        }
        catch (Exception e) {
            return null;
        }
        return sb.toString();
    }

    public static BufferedReader getBufferedReaderForInputStream(InputStream in) {
        try {
            return new BufferedReader(new InputStreamReader(in, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public static BufferedReader getBufferedReaderForString(String data) {
        return data == null ? null : new BufferedReader(new StringReader(data));
    }

    public static BufferedReader getBufferedReaderFromName(String name, String startCode) throws MalformedURLException, IOException {
        if (name == null) {
            throw new IOException("Cannot find " + name);
        }
        Logger.info("JSVFileManager getBufferedReaderFromName " + name);
        String path = JSVFileManager.getFullPathName(name);
        Logger.info("JSVFileManager getBufferedReaderFromName " + path);
        return JSVFileManager.getUnzippedBufferedReaderFromName(path, startCode);
    }

    public static String getFullPathName(String name) throws MalformedURLException {
        if (appletDocumentBase == null) {
            if (JSVFileManager.isURL(name)) {
                URL url = new URL(null, name, null);
                return url.toString();
            }
            return JSVFileManager.viewer.apiPlatform.newFile(name).getFullPath();
        }
        if (name.indexOf(":\\") == 1 || name.indexOf(":/") == 1) {
            name = "file:///" + name;
        }
        URL url = new URL(appletDocumentBase, name, null);
        return url.toString();
    }

    public static boolean isURL(String name) {
        int i = urlPrefixes.length;
        while (--i >= 0) {
            if (!name.startsWith(urlPrefixes[i])) continue;
            return true;
        }
        return false;
    }

    public static int urlTypeIndex(String name) {
        int i = 0;
        while (i < urlPrefixes.length) {
            if (name.startsWith(urlPrefixes[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean isLocal(String fileName) {
        if (fileName == null) {
            return false;
        }
        int itype = JSVFileManager.urlTypeIndex(fileName);
        return itype < 0 || itype == 4;
    }

    private static BufferedReader getUnzippedBufferedReaderFromName(String name, String startCode) throws IOException {
        String[] subFileList = null;
        if (name.indexOf("|") >= 0 && (subFileList = PT.split(name, "|")) != null && subFileList.length > 0) {
            name = subFileList[0];
        }
        if (name.startsWith(SIMULATION_PROTOCOL)) {
            return JSVFileManager.getBufferedReaderForString(JSVFileManager.getNMRSimulationJCampDX(name.substring(SIMULATION_PROTOCOL.length())));
        }
        if (JSVFileManager.viewer.isApplet) {
            Object ret = JSVFileManager.viewer.apiPlatform.getBufferedURLInputStream(new URL(null, name, null), null, null);
            if (ret instanceof SB || ret instanceof String) {
                return new BufferedReader(new StringReader(ret.toString()));
            }
            if (JSVFileManager.isAB(ret)) {
                return new BufferedReader(new StringReader(new String((byte[])ret)));
            }
            return new BufferedReader(new InputStreamReader((InputStream)ret, "UTF-8"));
        }
        InputStream in = JSVFileManager.getInputStream(name, true, null);
        BufferedInputStream bis = new BufferedInputStream(in);
        in = bis;
        if (JSVFileManager.isZipFile(bis)) {
            return ((JSVZipInterface)JSViewer.getInterface("jspecview.util.JSVZipUtil")).newJSVZipFileSequentialReader(in, subFileList, startCode);
        }
        if (JSVFileManager.isGzip(bis)) {
            in = ((JSVZipInterface)JSViewer.getInterface("jspecview.util.JSVZipUtil")).newGZIPInputStream(in);
        }
        return new BufferedReader(new InputStreamReader(in, "UTF-8"));
    }

    public static boolean isAB(Object x) {
        return x instanceof byte[];
    }

    public static boolean isZipFile(InputStream is) throws IOException {
        byte[] abMagic = new byte[4];
        is.mark(5);
        int countRead = is.read(abMagic, 0, 4);
        is.reset();
        return countRead == 4 && abMagic[0] == 80 && abMagic[1] == 75 && abMagic[2] == 3 && abMagic[3] == 4;
    }

    private static boolean isGzip(InputStream is) throws IOException {
        byte[] abMagic = new byte[4];
        is.mark(5);
        int countRead = is.read(abMagic, 0, 4);
        is.reset();
        return countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117;
    }

    public static Object getStreamAsBytes(BufferedInputStream bis, OC out) throws IOException {
        byte[] buf = new byte[1024];
        byte[] bytes = out == null ? new byte[4096] : null;
        int len = 0;
        int totalLen = 0;
        while ((len = bis.read(buf, 0, 1024)) > 0) {
            totalLen += len;
            if (out == null) {
                if (totalLen >= bytes.length) {
                    bytes = AU.ensureLengthByte(bytes, totalLen * 2);
                }
                System.arraycopy(buf, 0, bytes, totalLen - len, len);
                continue;
            }
            out.write(buf, 0, len);
        }
        bis.close();
        if (out == null) {
            return AU.arrayCopyByte(bytes, totalLen);
        }
        return String.valueOf(totalLen) + " bytes";
    }

    public static String postByteArray(String fileName, byte[] bytes) {
        Object ret = null;
        try {
            ret = JSVFileManager.getInputStream(fileName, false, bytes);
        }
        catch (Exception e) {
            return e.toString();
        }
        if (ret instanceof String) {
            return (String)ret;
        }
        try {
            ret = JSVFileManager.getStreamAsBytes((BufferedInputStream)ret, null);
        }
        catch (IOException e) {
            try {
                ((BufferedInputStream)ret).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return ret == null ? "" : JSVFileManager.fixUTF((byte[])ret);
    }

    private static Encoding getUTFEncoding(byte[] bytes) {
        if (bytes.length >= 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            return Encoding.UTF8;
        }
        if (bytes.length >= 4 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
            return Encoding.UTF_32BE;
        }
        if (bytes.length >= 4 && bytes[0] == -1 && bytes[1] == -2 && bytes[2] == 0 && bytes[3] == 0) {
            return Encoding.UTF_32LE;
        }
        if (bytes.length >= 2 && bytes[0] == -1 && bytes[1] == -2) {
            return Encoding.UTF_16LE;
        }
        if (bytes.length >= 2 && bytes[0] == -2 && bytes[1] == -1) {
            return Encoding.UTF_16BE;
        }
        return Encoding.NONE;
    }

    public static String fixUTF(byte[] bytes) {
        Encoding encoding = JSVFileManager.getUTFEncoding(bytes);
        if (encoding != Encoding.NONE) {
            try {
                String s = new String(bytes, encoding.name().replace('_', '-'));
                switch (encoding) {
                    case UTF8: 
                    case UTF_16BE: 
                    case UTF_16LE: {
                        s = s.substring(1);
                        break;
                    }
                }
                return s;
            }
            catch (UnsupportedEncodingException e) {
                System.out.println(e);
            }
        }
        return new String(bytes);
    }

    public static InputStream getInputStream(String name, boolean showMsg, byte[] postBytes) throws IOException, MalformedURLException {
        int iurl;
        boolean isURL = JSVFileManager.isURL(name);
        boolean isApplet = appletDocumentBase != null;
        Object in = null;
        String post = null;
        if (isURL && (iurl = name.indexOf("?POST?")) >= 0) {
            post = name.substring(iurl + 6);
            name = name.substring(0, iurl);
        }
        if (isApplet || isURL) {
            URL url = new URL(appletDocumentBase, name, null);
            Logger.info("JSVFileManager opening URL " + url + (post == null ? "" : " with POST of " + post.length() + " bytes"));
            in = JSVFileManager.viewer.apiPlatform.getBufferedURLInputStream(url, postBytes, post);
            if (in instanceof String) {
                Logger.info("JSVFileManager could not get this URL:" + in);
                return null;
            }
        } else {
            if (showMsg) {
                Logger.info("JSVFileManager opening file " + name);
            }
            in = JSVFileManager.viewer.apiPlatform.getBufferedFileInputStream(name);
        }
        return (InputStream)in;
    }

    private static String getNMRSimulationJCampDX(String name) {
        String key;
        String jcamp;
        if (htSimulate == null) {
            htSimulate = new Hashtable<String, String>();
        }
        if ((jcamp = htSimulate.get(key = "" + name.substring(name.indexOf("V2000") + 1).hashCode())) != null) {
            return jcamp;
        }
        boolean isInline = name.startsWith("MOL=");
        String molFile = isInline ? PT.simpleReplace(name.substring(4), "\\n", "\n") : JSVFileManager.getFileAsString(PT.simpleReplace(nciResolver, "%FILE", PT.escapeUrl(name.substring(1))));
        if (molFile == null) {
            Logger.info("no data returned");
        }
        int pt = molFile.indexOf("\n");
        molFile = "/JSpecView " + JSVersion.VERSION + molFile.substring(pt);
        molFile = PT.simpleReplace(molFile, "?", "_");
        String json = JSVFileManager.getFileAsString(String.valueOf(nmrdbServer) + molFile);
        System.out.println(json);
        json = PT.simpleReplace(json, "\\r\\n", "\n");
        json = PT.simpleReplace(json, "\\t", "\t");
        json = PT.simpleReplace(json, "\\n", "\n");
        molFile = JSVFileManager.getQuotedJSONAttribute(json, "molfile", null);
        String xml = JSVFileManager.getQuotedJSONAttribute(json, "xml", null);
        xml = PT.simpleReplace(xml, "</", "\n</");
        xml = PT.simpleReplace(xml, "><", ">\n<");
        xml = PT.simpleReplace(xml, "\\\"", "\"");
        jcamp = JSVFileManager.getQuotedJSONAttribute(json, "jcamp", null);
        jcamp = "##TITLE=" + (isInline ? "JMOL SIMULATION" : name) + "\n" + jcamp.substring(jcamp.indexOf("\n##") + 1);
        Logger.info(String.valueOf(jcamp.substring(0, jcamp.indexOf("##XYDATA") + 40)) + "...");
        pt = 0;
        pt = jcamp.indexOf("##.");
        String id = name;
        int pt1 = id.indexOf("id='");
        if (isInline && pt1 > 0) {
            id = id.substring(pt1 + 4, (String.valueOf(id) + "'").indexOf("'", pt1 + 4));
        }
        jcamp = String.valueOf(jcamp.substring(0, pt)) + "##$MODELS=\n<Models>\n" + "<ModelData id=" + JSVEscape.eS(id) + "\n type=\"MOL\">\n" + molFile + "</ModelData>\n</Models>\n" + "##$SIGNALS=\n" + xml + "\n" + jcamp.substring(pt);
        htSimulate.put(key, jcamp);
        return jcamp;
    }

    private static URL getResource(Object object, String fileName, String[] error) {
        URL url = null;
        try {
            url = object.getClass().getResource(fileName);
            if (url == null) {
                error[0] = "Couldn't find file: " + fileName;
            }
        }
        catch (Exception e) {
            error[0] = "Exception " + e.getMessage() + " in getResource " + fileName;
        }
        return url;
    }

    public static String getResourceString(Object object, String name, String[] error) {
        URL url = JSVFileManager.getResource(object, name, error);
        if (url == null) {
            error[0] = "Error loading resource " + name;
            return null;
        }
        if (url instanceof String) {
            return JSVFileManager.getFileAsString((String)((Object)url));
        }
        SB sb = new SB();
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)url.getContent(), "UTF-8"));
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
            br.close();
        }
        catch (Exception e) {
            error[0] = e.getMessage();
        }
        return sb.toString();
    }

    public static String getJmolFilePath(String filePath) {
        try {
            filePath = JSVFileManager.getFullPathName(filePath);
        }
        catch (MalformedURLException e) {
            return null;
        }
        return appletDocumentBase == null ? filePath.replace('\\', '/') : filePath;
    }

    public static String getName(String fileName) {
        if (fileName == null) {
            return "String" + ++stringCount;
        }
        if (JSVFileManager.isURL(fileName)) {
            try {
                if (fileName.startsWith(SIMULATION_PROTOCOL) && fileName.length() > 100) {
                    return String.valueOf(fileName.substring(0, Math.min(fileName.length(), 30))) + "...";
                }
                String name = new URL(null, fileName, null).getFile();
                return name.substring(name.lastIndexOf(47) + 1);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return JSVFileManager.viewer.apiPlatform.newFile(fileName).getName();
    }

    public static String getQuotedJSONAttribute(String json, String key1, String key2) {
        if (key2 == null) {
            key2 = key1;
        }
        key1 = "\"" + key1 + "\":";
        key2 = "\"" + key2 + "\":";
        int pt1 = json.indexOf(key1);
        int pt2 = json.indexOf(key2, pt1);
        return pt1 < 0 || pt2 < 0 ? null : PT.getQuotedStringAt(json, pt2 + key2.length());
    }

    public static void setDocumentBase(JSViewer v, URL documentBase) {
        viewer = v;
        appletDocumentBase = documentBase;
    }
}

