/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.api.BytePoster;
import javajs.api.GenericFileInterface;
import javajs.api.GenericPlatform;
import javajs.api.JSInterface;
import javajs.api.PlatformViewer;
import javajs.awt.Dimension;
import javajs.util.List;
import javajs.util.OC;
import javajs.util.PT;
import javajs.util.SB;
import jspecview.api.ExportInterface;
import jspecview.api.JSVFileHelper;
import jspecview.api.JSVGraphics;
import jspecview.api.JSVMainPanel;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPopupMenu;
import jspecview.api.JSVPrintDialog;
import jspecview.api.JSVTree;
import jspecview.api.JSVTreeNode;
import jspecview.api.ScriptInterface;
import jspecview.api.VisibleInterface;
import jspecview.common.Annotation;
import jspecview.common.ColorParameters;
import jspecview.common.Coordinate;
import jspecview.common.ExportType;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVFileManager;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PrintLayout;
import jspecview.common.RepaintManager;
import jspecview.common.ScriptToken;
import jspecview.common.ScriptTokenizer;
import jspecview.dialog.DialogManager;
import jspecview.dialog.JSVDialog;
import jspecview.source.JDXDataObject;
import jspecview.source.JDXSource;
import jspecview.tree.SimpleTree;
import jspecview.util.JSVEscape;
import org.jmol.util.Logger;

public class JSViewer
implements PlatformViewer,
JSInterface,
BytePoster {
    public static final String sourceLabel = "Original...";
    public static final int FILE_OPEN_OK = 0;
    public static final int FILE_OPEN_ALREADY = -1;
    public static final int FILE_OPEN_ERROR = -3;
    public static final int FILE_OPEN_NO_DATA = -4;
    public static final int OVERLAY_DIALOG = -1;
    public static final int OVERLAY_OFFSET = 99;
    public static final int PORTRAIT = 1;
    public static final int PAGE_EXISTS = 0;
    public static final int NO_SUCH_PAGE = 1;
    private static final String noColor = "255,255,255";
    private static String testScript = "<PeakData  index=\"1\" title=\"\" model=\"~1.1\" type=\"1HNMR\" xMin=\"3.2915\" xMax=\"3.2965\" atoms=\"15,16,17,18,19,20\" multiplicity=\"\" integral=\"1\"> src=\"JPECVIEW\" file=\"http://SIMULATION/$caffeine\"";
    private static final int NLEVEL_MAX = 100;
    public ScriptInterface si;
    public JSVGraphics g2d;
    public JSVTree spectraTree;
    public JDXSource currentSource;
    public List<PanelNode> panelNodes;
    public ColorParameters parameters;
    public RepaintManager repaintManager;
    public JSVPanel selectedPanel;
    public JSVMainPanel viewPanel;
    public Properties properties;
    public List<String> scriptQueue;
    public JSVFileHelper fileHelper;
    public JSVPopupMenu jsvpPopupMenu;
    private DialogManager dialogManager;
    private JSVDialog viewDialog;
    private JSVDialog overlayLegendDialog;
    private JDXSpectrum.IRMode irMode = JDXSpectrum.IRMode.NO_CONVERT;
    public boolean isSingleThreaded;
    public boolean isApplet;
    public boolean isJS;
    public boolean isSigned;
    private String recentScript = "";
    public String appletID;
    public String fullName;
    public String syncID;
    public Object applet;
    public Object display;
    private int maximumSize = Integer.MAX_VALUE;
    final Dimension dimScreen = new Dimension(0, 0);
    public GenericPlatform apiPlatform;
    private boolean popupAllowMenu = true;
    private boolean popupZoomEnabled = true;
    private boolean overlayLegendVisible;
    private int recentStackPercent = 5;
    private PrintLayout lastPrintLayout;
    private Object offWindowFrame;

    public void setProperty(String string, String string2) {
        if (this.properties != null) {
            this.properties.setProperty(string, string2);
        }
    }

    public void setNode(PanelNode panelNode, boolean bl) {
        this.si.siSetNode(panelNode, bl);
    }

    public JSViewer(ScriptInterface scriptInterface, boolean bl, boolean bl2) {
        this.si = scriptInterface;
        this.isApplet = bl;
        this.isJS = bl && bl2;
        this.isSigned = scriptInterface.isSigned();
        this.apiPlatform = (GenericPlatform)this.getPlatformInterface("Platform");
        this.apiPlatform.setViewer(this, this.display);
        this.g2d = (JSVGraphics)this.getPlatformInterface("G2D");
        this.spectraTree = new SimpleTree(this);
        this.parameters = (ColorParameters)this.getPlatformInterface("Parameters");
        this.parameters.setName("applet");
        this.fileHelper = ((JSVFileHelper)this.getPlatformInterface("FileHelper")).set(this);
        this.isSingleThreaded = this.apiPlatform.isSingleThreaded();
        this.panelNodes = new List();
        this.repaintManager = new RepaintManager(this);
        if (!bl) {
            this.setPopupMenu(true, true);
        }
    }

    public void setPopupMenu(boolean bl, boolean bl2) {
        this.popupAllowMenu = bl;
        this.popupZoomEnabled = bl2;
    }

    public void showMenu(int n, int n2) {
        if (this.jsvpPopupMenu == null) {
            try {
                this.jsvpPopupMenu = (JSVPopupMenu)this.getPlatformInterface("Popup");
                this.jsvpPopupMenu.jpiInitialize(this, this.isApplet ? "appletMenu" : "appMenu");
                this.jsvpPopupMenu.setEnabled(this.popupAllowMenu, this.popupZoomEnabled);
            }
            catch (Exception exception) {
                System.out.println(exception + " initializing popup menu");
                return;
            }
        }
        this.jsvpPopupMenu.jpiShow(n, n2);
    }

    public boolean runScriptNow(String string) {
        this.si.siIncrementViewCount(1);
        if (string == null) {
            string = "";
        }
        if ((string = string.trim()).startsWith("!")) {
            string = string.substring(1).trim();
        }
        System.out.println("RUNSCRIPT " + string);
        boolean bl = true;
        int n = 10;
        ScriptTokenizer scriptTokenizer = new ScriptTokenizer(string, true);
        String string2 = null;
        block53: while (scriptTokenizer.hasMoreTokens() && n > 0 && bl) {
            String string3 = scriptTokenizer.nextToken();
            ScriptTokenizer scriptTokenizer2 = new ScriptTokenizer(string3, false);
            String string4 = ScriptToken.getKey(scriptTokenizer2);
            if (string4 == null) continue;
            ScriptToken scriptToken = ScriptToken.getScriptToken(string4);
            String string5 = ScriptToken.getValue(scriptToken, scriptTokenizer2, string3);
            System.out.println("KEY-> " + string4 + " VALUE-> " + string5 + " : " + (Object)((Object)scriptToken));
            try {
                block1 : switch (scriptToken) {
                    case UNKNOWN: {
                        Logger.info("Unrecognized parameter: " + string4);
                        --n;
                        break;
                    }
                    default: {
                        if (this.selectedPanel == null) break;
                        this.parameters.set(this.pd(), scriptToken, string5);
                        this.si.siUpdateBoolean(scriptToken, Parameters.isTrue(string5));
                        break;
                    }
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: 
                    case COORDCALLBACKFUNCTIONNAME: 
                    case LOADFILECALLBACKFUNCTIONNAME: {
                        this.si.siExecSetCallback(scriptToken, string5);
                        break;
                    }
                    case AUTOINTEGRATE: {
                        this.si.siExecSetAutoIntegrate(Parameters.isTrue(string5));
                        break;
                    }
                    case CLOSE: {
                        this.si.siExecClose(string5);
                        break;
                    }
                    case DEBUG: {
                        Logger.setLogLevel(string5.toLowerCase().equals("high") ? 6 : (Parameters.isTrue(string5) ? 5 : 4));
                        break;
                    }
                    case GETPROPERTY: {
                        Map<String, Object> map = this.selectedPanel == null ? null : this.getPropertyAsJavaObject(string5);
                        if (map == null) continue block53;
                        this.selectedPanel.showMessage(PT.toJSON(null, map), string5);
                        break;
                    }
                    case HIDDEN: {
                        this.si.siExecHidden(Parameters.isTrue(string5));
                        break;
                    }
                    case INTEGRATIONRATIOS: {
                        this.si.siSetIntegrationRatios(string5);
                        if (this.selectedPanel == null) continue block53;
                        this.execIntegrate(null);
                        break;
                    }
                    case INTERFACE: {
                        this.si.siExecSetInterface(string5);
                        break;
                    }
                    case INTEGRALOFFSET: 
                    case INTEGRALRANGE: {
                        this.execSetIntegralParameter(scriptToken, Double.parseDouble(string5));
                        break;
                    }
                    case JMOL: {
                        this.si.syncToJmol(string5);
                        break;
                    }
                    case JSV: {
                        this.syncScript(PT.trimQuotes(string5));
                        break;
                    }
                    case LOAD: {
                        string2 = this.si.siExecLoad(string5);
                        break;
                    }
                    case LOADIMAGINARY: {
                        this.si.siSetLoadImaginary(Parameters.isTrue(string5));
                        break;
                    }
                    case PEAK: {
                        this.execPeak(string5);
                        break;
                    }
                    case PEAKLIST: {
                        this.execPeakList(string5);
                        break;
                    }
                    case SCALEBY: {
                        this.scaleSelectedBy(this.panelNodes, string5);
                        break;
                    }
                    case SCRIPT: {
                        if (string5.equals("") || string5.toLowerCase().startsWith("inline")) {
                            this.execScriptInline(string5);
                            break;
                        }
                        String string6 = this.si.siSetFileAsString(string5);
                        if (string6 == null || this.si.siIncrementScriptLevelCount(0) >= 100) continue block53;
                        this.runScriptNow(string6);
                        break;
                    }
                    case SELECT: {
                        this.execSelect(string5);
                        break;
                    }
                    case SPECTRUM: 
                    case SPECTRUMNUMBER: {
                        if (this.setSpectrum(string5)) continue block53;
                        bl = false;
                        break;
                    }
                    case STACKOFFSETY: {
                        this.execOverlayOffsetY(PT.parseInt("" + PT.parseFloat(string5)));
                        break;
                    }
                    case TEST: {
                        this.si.siExecTest(string5);
                        break;
                    }
                    case OVERLAY: 
                    case VIEW: {
                        this.execView(string5, true);
                        break;
                    }
                    case FINDX: 
                    case GETSOLUTIONCOLOR: 
                    case INTEGRATION: 
                    case INTEGRATE: 
                    case IRMODE: 
                    case LABEL: 
                    case LINK: 
                    case OVERLAYSTACKED: 
                    case PRINT: 
                    case SETPEAK: 
                    case SETX: 
                    case SHIFTX: 
                    case SHOWERRORS: 
                    case SHOWINTEGRATION: 
                    case SHOWKEY: 
                    case SHOWMEASUREMENTS: 
                    case SHOWMENU: 
                    case SHOWPEAKLIST: 
                    case SHOWPROPERTIES: 
                    case SHOWSOURCE: 
                    case YSCALE: 
                    case WRITE: 
                    case ZOOM: {
                        if (this.selectedPanel == null) {
                            bl = false;
                            break;
                        }
                        switch (scriptToken) {
                            default: {
                                break block1;
                            }
                            case FINDX: {
                                this.pd().findX(null, Double.parseDouble(string5));
                                break block1;
                            }
                            case GETSOLUTIONCOLOR: {
                                this.selectedPanel.showMessage(this.getSolutionColorHtml(), "Predicted Colour");
                                break block1;
                            }
                            case INTEGRATION: 
                            case INTEGRATE: {
                                this.execIntegrate(string5);
                                break block1;
                            }
                            case IRMODE: {
                                this.execIRMode(string5);
                                break block1;
                            }
                            case LABEL: {
                                this.pd().addAnnotation(ScriptToken.getTokens(string5));
                                break block1;
                            }
                            case LINK: {
                                this.pd().linkSpectra(PanelData.LinkMode.getMode(string5));
                                break block1;
                            }
                            case OVERLAYSTACKED: {
                                this.pd().splitStack(!Parameters.isTrue(string5));
                                break block1;
                            }
                            case PRINT: {
                                string2 = this.execWrite(null);
                                break block1;
                            }
                            case SETPEAK: {
                                this.pd().shiftSpectrum(Double.NaN, string5.equalsIgnoreCase("NONE") ? Double.MAX_VALUE : (string5.equalsIgnoreCase("?") ? Double.MIN_VALUE : Double.parseDouble(string5)));
                                break block1;
                            }
                            case SETX: {
                                this.pd().shiftSpectrum(Double.MIN_VALUE, Double.parseDouble(string5));
                                break block1;
                            }
                            case SHIFTX: {
                                this.pd().shiftSpectrum(string5.equalsIgnoreCase("NONE") ? Double.MAX_VALUE : Double.parseDouble(string5), Double.NaN);
                                break block1;
                            }
                            case SHOWERRORS: {
                                this.show("errors");
                                break block1;
                            }
                            case SHOWINTEGRATION: {
                                this.pd().showAnnotation(Annotation.AType.Integration, Parameters.getTFToggle(string5));
                                break block1;
                            }
                            case SHOWKEY: {
                                this.setOverlayLegendVisibility(Parameters.getTFToggle(string5), true);
                                break block1;
                            }
                            case SHOWMEASUREMENTS: {
                                this.pd().showAnnotation(Annotation.AType.Measurements, Parameters.getTFToggle(string5));
                                break block1;
                            }
                            case SHOWMENU: {
                                this.showMenu(Integer.MIN_VALUE, 0);
                                break block1;
                            }
                            case SHOWPEAKLIST: {
                                this.pd().showAnnotation(Annotation.AType.PeakList, Parameters.getTFToggle(string5));
                                break block1;
                            }
                            case SHOWPROPERTIES: {
                                this.show("properties");
                                break block1;
                            }
                            case SHOWSOURCE: {
                                this.show("source");
                                break block1;
                            }
                            case YSCALE: {
                                this.setYScale(string5);
                                break block1;
                            }
                            case WINDOW: {
                                this.si.siNewWindow(Parameters.isTrue(string5), false);
                                break block1;
                            }
                            case WRITE: {
                                string2 = this.execWrite(string5);
                                break block1;
                            }
                            case ZOOM: 
                        }
                        bl = this.execZoom(string5);
                    }
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                Logger.error(exception.getMessage());
                if (Logger.debugging) {
                    exception.printStackTrace();
                }
                bl = false;
                --n;
            }
        }
        this.si.siIncrementViewCount(-1);
        this.si.siExecScriptComplete(string2, true);
        return bl;
    }

    private PanelData pd() {
        return this.selectedPanel.getPanelData();
    }

    private void execPeak(String string) {
        try {
            List<String> list = ScriptToken.getTokens(string);
            string = " type=\"" + ((String)list.get(0)).toUpperCase() + "\" _match=\"" + PT.trimQuotes(((String)list.get(1)).toUpperCase()) + "\"";
            if (list.size() > 2 && ((String)list.get(2)).equalsIgnoreCase("all")) {
                string = string + " title=\"ALL\"";
            }
            this.processPeakPickEvent(new PeakInfo(string), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void execPeakList(String string) {
        JSVPanel jSVPanel = this.selectedPanel;
        ColorParameters colorParameters = this.parameters;
        Boolean bl = Parameters.getTFToggle(string);
        if (string.indexOf("=") < 0) {
            if (jSVPanel != null) {
                jSVPanel.getPanelData().getPeakListing(null, bl);
            }
        } else {
            List<String> list = ScriptToken.getTokens(string);
            int n = list.size();
            while (--n >= 0) {
                String string2 = (String)list.get(n);
                int n2 = string2.indexOf("=");
                if (n2 <= 0) continue;
                String string3 = string2.substring(0, n2);
                string = string2.substring(n2 + 1);
                try {
                    if (string3.startsWith("thr")) {
                        colorParameters.peakListThreshold = Double.valueOf(string);
                    } else if (string3.startsWith("int")) {
                        String string4 = colorParameters.peakListInterpolation = string.equalsIgnoreCase("none") ? "NONE" : "parabolic";
                    }
                    if (jSVPanel == null) continue;
                    jSVPanel.getPanelData().getPeakListing(colorParameters, Boolean.TRUE);
                }
                catch (Exception exception) {}
            }
        }
    }

    private boolean execZoom(String string) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        List<String> list = ScriptToken.getTokens(string);
        switch (list.size()) {
            default: {
                return false;
            }
            case 1: {
                this.zoomTo((String)list.get(0));
                return true;
            }
            case 2: {
                d = Double.parseDouble((String)list.get(0));
                d2 = Double.parseDouble((String)list.get(1));
                break;
            }
            case 4: {
                d = Double.parseDouble((String)list.get(0));
                d3 = Double.parseDouble((String)list.get(1));
                d2 = Double.parseDouble((String)list.get(2));
                d4 = Double.parseDouble((String)list.get(3));
            }
        }
        this.pd().setZoom(d, d3, d2, d4);
        return true;
    }

    private void zoomTo(String string) {
        PanelData panelData = this.pd();
        if (string.equalsIgnoreCase("next")) {
            panelData.nextView();
        } else if (string.toLowerCase().startsWith("prev")) {
            panelData.previousView();
        } else if (string.equalsIgnoreCase("out")) {
            panelData.resetView();
        } else if (string.equalsIgnoreCase("clear")) {
            panelData.clearAllView();
        }
    }

    private void scaleSelectedBy(List<PanelNode> list, String string) {
        try {
            double d = Double.parseDouble(string);
            int n = list.size();
            while (--n >= 0) {
                ((PanelNode)list.get((int)n)).jsvp.getPanelData().scaleSelectedBy(d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void execSelect(String string) {
        List<PanelNode> list = this.panelNodes;
        int n = list.size();
        while (--n >= 0) {
            ((PanelNode)list.get((int)n)).jsvp.getPanelData().selectFromEntireSet(Integer.MIN_VALUE);
        }
        List<JDXSpectrum> list2 = new List<JDXSpectrum>();
        this.fillSpecList(string, list2, false);
    }

    public void execView(String string, boolean bl) {
        if (string.equals("")) {
            this.checkOverlay();
            return;
        }
        List<JDXSpectrum> list = new List<JDXSpectrum>();
        String string2 = this.fillSpecList(string, list, true);
        if (list.size() > 0) {
            this.si.siOpenDataOrFile(null, string2, list, string2, -1, -1, false);
        }
        if (!bl) {
            this.si.siValidateAndRepaint();
        }
    }

    private void execIRMode(String string) {
        JDXSpectrum.IRMode iRMode = JDXSpectrum.IRMode.getMode(string);
        PanelData panelData = this.pd();
        JDXSpectrum jDXSpectrum = panelData.getSpectrum();
        JDXSpectrum jDXSpectrum2 = JDXSpectrum.taConvert(jDXSpectrum, iRMode);
        if (jDXSpectrum2 == jDXSpectrum) {
            return;
        }
        panelData.setSpectrum(jDXSpectrum2);
        this.setIRmode(string);
    }

    private void execIntegrate(String string) {
        JSVPanel jSVPanel = this.selectedPanel;
        if (jSVPanel == null) {
            return;
        }
        jSVPanel.getPanelData().checkIntegral(this.parameters, string);
        String string2 = this.si.siGetIntegrationRatios();
        if (string2 != null) {
            jSVPanel.getPanelData().setIntegrationRatios(string2);
        }
        this.si.siSetIntegrationRatios(null);
        jSVPanel.doRepaint(true);
    }

    private void execSetIntegralParameter(ScriptToken scriptToken, double d) {
        ColorParameters colorParameters = this.parameters;
        switch (scriptToken) {
            case INTEGRALRANGE: {
                colorParameters.integralRange = d;
                break;
            }
            case INTEGRALOFFSET: {
                colorParameters.integralOffset = d;
            }
        }
        JSVPanel jSVPanel = this.selectedPanel;
        if (jSVPanel == null) {
            return;
        }
        jSVPanel.getPanelData().checkIntegral(this.parameters, "update");
    }

    private void setYScale(String string) {
        List<String> list = ScriptToken.getTokens(string);
        int n = 0;
        boolean bl = false;
        if (list.size() > 1 && ((String)list.get(0)).equalsIgnoreCase("ALL")) {
            bl = true;
        }
        int n2 = ++n;
        double d = Double.parseDouble((String)list.get(n2));
        double d2 = Double.parseDouble((String)list.get(++n));
        if (bl) {
            JDXSpectrum jDXSpectrum = this.pd().getSpectrum();
            int n3 = this.panelNodes.size();
            while (--n3 >= 0) {
                PanelNode panelNode = (PanelNode)this.panelNodes.get(n3);
                if (panelNode.source != this.currentSource || !JDXSpectrum.areXScalesCompatible(jDXSpectrum, panelNode.getSpectrum(), false, false)) continue;
                panelNode.jsvp.getPanelData().setZoom(0.0, d, 0.0, d2);
            }
        } else {
            this.pd().setZoom(0.0, d, 0.0, d2);
        }
    }

    private void setOverlayLegendVisibility(Boolean bl, boolean bl2) {
        if (bl2) {
            this.overlayLegendVisible = bl == null ? !this.overlayLegendVisible : bl == Boolean.TRUE;
        }
        PanelNode panelNode = PanelNode.findNode(this.selectedPanel, this.panelNodes);
        int n = this.panelNodes.size();
        while (--n >= 0) {
            this.showOverlayLegend((PanelNode)this.panelNodes.get(n), this.panelNodes.get(n) == panelNode && this.overlayLegendVisible);
        }
    }

    private void showOverlayLegend(PanelNode panelNode, boolean bl) {
        JSVDialog jSVDialog = panelNode.legend;
        if (jSVDialog == null && bl) {
            jSVDialog = panelNode.setLegend(panelNode.jsvp.getPanelData().getNumberOfSpectraInCurrentSet() > 1 && panelNode.jsvp.getPanelData().getNumberOfGraphSets() == 1 ? this.getDialog(Annotation.AType.OverlayLegend, null) : null);
        }
        if (jSVDialog != null) {
            jSVDialog.setVisible(bl);
        }
    }

    public void addHighLight(double d, double d2, int n, int n2, int n3, int n4) {
        JSVPanel jSVPanel = this.selectedPanel;
        if (jSVPanel != null) {
            jSVPanel.getPanelData().addHighlight(null, d, d2, null, n, n2, n3, n4);
            jSVPanel.doRepaint(false);
        }
    }

    public void syncScript(String string) {
        String string2;
        if (string.equals("TEST")) {
            string = testScript;
        }
        Logger.info("JSViewer.syncScript Jmol>JSV " + string);
        if (string.indexOf("<PeakData") < 0) {
            this.runScriptNow(string);
            if (string.indexOf("#SYNC_PEAKS") >= 0) {
                JDXSource jDXSource = this.currentSource;
                if (jDXSource == null) {
                    return;
                }
                try {
                    String string3 = "file=" + JSVEscape.eS(jDXSource.getFilePath());
                    List<PeakInfo> list = ((JDXSpectrum)jDXSource.getSpectra().get(0)).getPeakList();
                    SB sB = new SB();
                    sB.append("[");
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        String string4 = ((PeakInfo)list.get(i)).toString();
                        string4 = string4 + " " + string3;
                        sB.append(JSVEscape.eS(string4));
                        if (i <= 0) continue;
                        sB.append(",");
                    }
                    sB.append("]");
                    this.si.syncToJmol("Peaks: " + sB);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        string = PT.simpleReplace(string, "\\\"", "");
        String string5 = PT.getQuotedAttribute(string, "file");
        System.out.println("file2=" + string5);
        String string6 = PT.getQuotedAttribute(string, "index");
        if (string5 == null || string6 == null) {
            return;
        }
        String string7 = PT.getQuotedAttribute(string, "model");
        String string8 = PT.getQuotedAttribute(string, "src");
        String string9 = string2 = string8 != null && string8.startsWith("Jmol") ? null : this.si.siGetReturnFromJmolModel();
        if (string7 != null && string2 != null && !string7.equals(string2)) {
            Logger.info("JSV ignoring model " + string7 + "; should be " + string2);
            return;
        }
        this.si.siSetReturnFromJmolModel(null);
        if (this.panelNodes.size() == 0 || !this.checkFileAlreadyLoaded(string5)) {
            Logger.info("file " + string5 + " not found -- JSViewer closing all and reopening");
            this.si.siSyncLoad(string5);
        }
        PeakInfo peakInfo = this.selectPanelByPeak(string);
        JSVPanel jSVPanel = this.selectedPanel;
        String string10 = PT.getQuotedAttribute(string, "type");
        jSVPanel.getPanelData().selectSpectrum(string5, string10, string7, true);
        this.si.siSendPanelChange(jSVPanel);
        jSVPanel.getPanelData().addPeakHighlight(peakInfo);
        jSVPanel.doRepaint(true);
        if (string8 == null || peakInfo != null && peakInfo.getAtoms() != null) {
            this.si.syncToJmol(this.jmolSelect(peakInfo));
        }
    }

    private boolean checkFileAlreadyLoaded(String string) {
        JSVPanel jSVPanel = this.selectedPanel;
        if (jSVPanel != null && jSVPanel.getPanelData().hasFileLoaded(string)) {
            return true;
        }
        int n = this.panelNodes.size();
        while (--n >= 0) {
            if (!((PanelNode)this.panelNodes.get((int)n)).jsvp.getPanelData().hasFileLoaded(string)) continue;
            this.si.siSetSelectedPanel(((PanelNode)this.panelNodes.get((int)n)).jsvp);
            return true;
        }
        return false;
    }

    private PeakInfo selectPanelByPeak(String string) {
        if (this.panelNodes == null) {
            return null;
        }
        String string2 = PT.getQuotedAttribute(string, "file");
        String string3 = PT.getQuotedAttribute(string, "index");
        PeakInfo peakInfo = null;
        int n = this.panelNodes.size();
        while (--n >= 0) {
            ((PanelNode)this.panelNodes.get((int)n)).jsvp.getPanelData().addPeakHighlight(null);
        }
        JSVPanel jSVPanel = this.selectedPanel;
        peakInfo = jSVPanel.getPanelData().selectPeakByFileIndex(string2, string3);
        System.out.println(Thread.currentThread() + "JSViewer selectPanelByPeak pi = " + peakInfo);
        if (peakInfo != null) {
            this.setNode(PanelNode.findNode(jSVPanel, this.panelNodes), false);
        } else {
            int n2 = this.panelNodes.size();
            while (--n2 >= 0) {
                PanelNode panelNode = (PanelNode)this.panelNodes.get(n2);
                peakInfo = panelNode.jsvp.getPanelData().selectPeakByFileIndex(string2, string3);
                if (peakInfo == null) continue;
                this.setNode(panelNode, false);
                break;
            }
        }
        return peakInfo;
    }

    public void processPeakPickEvent(Object object, boolean bl) {
        PeakInfo peakInfo;
        if (object instanceof PeakInfo) {
            peakInfo = (PeakInfo)object;
            JSVPanel jSVPanel = this.selectedPanel;
            PeakInfo peakInfo2 = jSVPanel.getPanelData().findMatchingPeakInfo(peakInfo);
            if (peakInfo2 == null) {
                if (!"ALL".equals(peakInfo.getTitle())) {
                    return;
                }
                PanelNode panelNode = null;
                for (int i = 0; i < this.panelNodes.size(); ++i) {
                    peakInfo2 = ((PanelNode)this.panelNodes.get((int)i)).jsvp.getPanelData().findMatchingPeakInfo(peakInfo);
                    if (peakInfo2 == null) continue;
                    panelNode = (PanelNode)this.panelNodes.get(i);
                    break;
                }
                if (panelNode == null) {
                    return;
                }
                this.setNode(panelNode, false);
            }
            peakInfo = peakInfo2;
        } else {
            PeakPickEvent peakPickEvent = (PeakPickEvent)object;
            this.si.siSetSelectedPanel((JSVPanel)peakPickEvent.getSource());
            peakInfo = peakPickEvent.getPeakInfo();
        }
        this.pd().addPeakHighlight(peakInfo);
        this.syncToJmol(peakInfo);
        if (peakInfo.isClearAll()) {
            this.selectedPanel.doRepaint(false);
        } else {
            this.pd().selectSpectrum(peakInfo.getFilePath(), peakInfo.getType(), peakInfo.getModel(), true);
        }
        this.si.siCheckCallbacks(peakInfo.getTitle());
    }

    private void syncToJmol(PeakInfo peakInfo) {
        this.si.siSetReturnFromJmolModel(peakInfo.getModel());
        this.si.syncToJmol(this.jmolSelect(peakInfo));
    }

    public void sendPanelChange(JSVPanel jSVPanel) {
        PanelData panelData = jSVPanel.getPanelData();
        JDXSpectrum jDXSpectrum = panelData.getSpectrum();
        PeakInfo peakInfo = jDXSpectrum.getSelectedPeak();
        if (peakInfo == null) {
            peakInfo = jDXSpectrum.getModelPeakInfoForAutoSelectOnLoad();
        }
        if (peakInfo == null) {
            peakInfo = jDXSpectrum.getBasePeakInfo();
        }
        panelData.addPeakHighlight(peakInfo);
        Logger.info(Thread.currentThread() + "JSViewer sendFrameChange " + jSVPanel);
        this.syncToJmol(peakInfo);
    }

    private String jmolSelect(PeakInfo peakInfo) {
        String string = null;
        string = "IR".equals(peakInfo.getType()) || "RAMAN".equals(peakInfo.getType()) ? "vibration ON; selectionHalos OFF;" : (peakInfo.getAtoms() != null ? "vibration OFF; selectionhalos ON;" : "vibration OFF; selectionhalos OFF;");
        string = "Select: " + peakInfo + " script=\"" + string;
        System.out.println("JSViewer.jmolSelect " + string);
        return string;
    }

    public Map<String, Object> getPropertyAsJavaObject(String string) {
        boolean bl = false;
        if (string != null && string.toUpperCase().startsWith("ALL ") || "all".equalsIgnoreCase(string)) {
            string = string.substring(3).trim();
            bl = true;
        }
        if ("".equals(string)) {
            string = null;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Map<String, Object> map = this.pd().getInfo(true, string);
        if (!bl && map != null) {
            return map;
        }
        if (map != null) {
            hashtable.put("current", map);
        }
        List<Map<String, Object>> list = new List<Map<String, Object>>();
        for (int i = 0; i < this.panelNodes.size(); ++i) {
            JSVPanel jSVPanel = ((PanelNode)this.panelNodes.get((int)i)).jsvp;
            if (jSVPanel == null) continue;
            list.addLast(((PanelNode)this.panelNodes.get(i)).getInfo(string));
        }
        hashtable.put("items", list);
        return hashtable;
    }

    public String getCoordinate() {
        Coordinate coordinate;
        if (this.selectedPanel != null && (coordinate = this.pd().getClickedCoordinate()) != null) {
            return coordinate.getXVal() + " " + coordinate.getYVal();
        }
        return "";
    }

    private String fillSpecList(String string, List<JDXSpectrum> list, boolean bl) {
        PanelNode panelNode;
        List<String> list2;
        int n;
        SB sB;
        Object object;
        String string2 = "1.";
        List<String> list3 = null;
        boolean bl2 = string.equalsIgnoreCase("NONE");
        if (bl2 || string.equalsIgnoreCase("all")) {
            string = "*";
        }
        if (string.indexOf("*") < 0) {
            object = string.split(" ");
            sB = new SB();
            for (n = 0; n < ((String[])object).length; ++n) {
                int n2 = object[n].indexOf(46);
                if (n2 != ((String)object[n]).lastIndexOf(46)) {
                    object[n] = ((String)object[n]).substring(0, n2 + 1) + ((String)object[n]).substring(n2 + 1).replace('.', '_');
                }
                sB.append((String)object[n]).append(" ");
            }
            string = sB.toString().trim();
        }
        if (string.equals("*")) {
            list2 = ScriptToken.getTokens(PanelNode.getSpectrumListAsString(this.panelNodes));
        } else if (string.startsWith("\"")) {
            list2 = ScriptToken.getTokens(string);
        } else {
            string = PT.simpleReplace(string, "_", " _ ");
            string = PT.simpleReplace(string, "-", " - ");
            list2 = ScriptToken.getTokens(string);
            list3 = ScriptToken.getTokens(PanelNode.getSpectrumListAsString(this.panelNodes));
            if (list3.size() == 0) {
                return null;
            }
        }
        object = this.selectedPanel == null ? string2 : PanelNode.findNode((JSVPanel)this.selectedPanel, this.panelNodes).id;
        object = ((String)object).substring(0, ((String)object).indexOf(".") + 1);
        sB = new SB();
        n = list2.size();
        String string3 = null;
        for (int i = 0; i < n; ++i) {
            PanelNode panelNode2;
            String string4 = (String)list2.get(i);
            double d = Double.NaN;
            int n3 = -1;
            if (i + 1 < n && ((String)list2.get(i + 1)).equals("*")) {
                d = Double.parseDouble((String)list2.get(i += 2));
            } else if (i + 1 < n && ((String)list2.get(i + 1)).equals("_")) {
                n3 = Integer.parseInt((String)list2.get(i += 2));
            }
            if (string4.equals("-")) {
                int n4;
                if (string3 == null) {
                    string3 = (String)list3.get(0);
                }
                String string5 = string4 = i + 1 == n ? (String)list3.get(list3.size() - 1) : (String)list2.get(++i);
                if (!string4.contains(".")) {
                    string4 = (String)object + string4;
                }
                for (n4 = 0; n4 < list3.size() && !((String)list3.get(n4)).equals(string3); ++n4) {
                }
                ++n4;
                while (n4 < list3.size() && !string3.equals(string4)) {
                    string3 = (String)list3.get(n4++);
                    list.addLast(PanelNode.findNodeById((String)string3, this.panelNodes).jsvp.getPanelData().getSpectrumAt(0));
                    sB.append(",").append(string3);
                }
                continue;
            }
            if (string4.startsWith("\"")) {
                string4 = PT.trim(string4, "\"");
                for (int j = 0; j < this.panelNodes.size(); ++j) {
                    PanelNode panelNode3 = (PanelNode)this.panelNodes.get(j);
                    if ((panelNode3.fileName == null || !panelNode3.fileName.startsWith(string4)) && (panelNode3.frameTitle == null || !panelNode3.frameTitle.startsWith(string4))) continue;
                    this.addSpecToList(panelNode3.jsvp.getPanelData(), d, -1, list, bl);
                    sB.append(",").append(panelNode3.id);
                }
                continue;
            }
            if (!string4.contains(".")) {
                string4 = (String)object + string4;
            }
            if ((panelNode2 = PanelNode.findNodeById(string4, this.panelNodes)) == null) continue;
            string3 = string4;
            this.addSpecToList(panelNode2.jsvp.getPanelData(), d, n3, list, bl);
            sB.append(",").append(string4);
            if (n3 <= 0) continue;
            sB.append(".").appendI(n3);
        }
        if (bl && list.size() == 1 && (panelNode = PanelNode.findNodeById(string3, this.panelNodes)) != null) {
            this.setNode(panelNode, true);
            list.clear();
        }
        return bl2 ? "NONE" : (sB.length() > 0 ? sB.toString().substring(1) : null);
    }

    private void addSpecToList(PanelData panelData, double d, int n, List<JDXSpectrum> list, boolean bl) {
        if (bl) {
            JDXSpectrum jDXSpectrum = panelData.getSpectrumAt(0);
            jDXSpectrum.setUserYFactor(Double.isNaN(d) ? 1.0 : d);
            panelData.addToList(n - 1, list);
        } else {
            panelData.selectFromEntireSet(n - 1);
        }
    }

    public String getSolutionColor() {
        JDXSpectrum jDXSpectrum = this.pd().getSpectrum();
        return jDXSpectrum.canShowSolutionColor() ? ((VisibleInterface)JSViewer.getInterface("jspecview.common.Visible")).getColour(jDXSpectrum.getXYCoords(), jDXSpectrum.getYUnits()) : noColor;
    }

    public String getSolutionColorHtml() {
        String string = this.getSolutionColor();
        return "<html><body style='background-color:rgb(" + string + ")'><br />Predicted Solution Colour- RGB(" + string + ")<br /><br /></body></html>";
    }

    public int openDataOrFile(String string, String string2, List<JDXSpectrum> list, String string3, int n, int n2, boolean bl) {
        boolean bl2;
        Object object;
        if ("NONE".equals(string2)) {
            this.close("View*");
            return 0;
        }
        this.si.writeStatus("");
        String string4 = null;
        String string5 = null;
        String string6 = null;
        boolean bl3 = false;
        if (string == null) {
            if (list != null) {
                bl3 = true;
                string6 = string4 = "View" + this.si.siIncrementViewCount(1);
                string5 = string4;
            } else if (string3 != null) {
                try {
                    object = new URL(JSVFileManager.appletDocumentBase, string3, null);
                    string4 = ((URL)object).toString();
                    this.si.siSetRecentURL(string4);
                    string6 = JSVFileManager.getName(string4);
                }
                catch (MalformedURLException malformedURLException) {
                    GenericFileInterface genericFileInterface = this.apiPlatform.newFile(string3);
                    string6 = genericFileInterface.getName();
                    string5 = string4 = genericFileInterface.getFullPath();
                    this.si.siSetRecentURL(null);
                }
            }
        }
        if (!bl3 && (PanelNode.isOpen(this.panelNodes, string4) || PanelNode.isOpen(this.panelNodes, string3))) {
            this.si.writeStatus(string4 + " is already open");
            return -1;
        }
        if (!bl && !bl3) {
            this.close("all");
        }
        this.si.setCursor(3);
        try {
            this.si.siSetCurrentSource(bl3 ? JDXSource.createView(list) : this.si.siCreateSource(string, string4, n, n2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.si.writeStatus(exception.getMessage());
            this.si.setCursor(0);
            return -3;
        }
        this.si.setCursor(0);
        System.gc();
        if (string5 == null) {
            string5 = this.currentSource.getFilePath();
            if (string5 != null) {
                string6 = string5.substring(string5.lastIndexOf("/") + 1);
            }
        } else {
            this.currentSource.setFilePath(string5);
        }
        this.si.siSetLoaded(string6, string5);
        object = this.currentSource.getJDXSpectrum(0);
        if (object == null) {
            return -4;
        }
        list = this.currentSource.getSpectra();
        JDXSpectrum.process(list, this.irMode);
        boolean bl4 = this.si.siGetAutoCombine() || ((JDXDataObject)object).isAutoOverlayFromJmolClick();
        boolean bl5 = bl2 = bl3 || bl4 && this.currentSource.isCompoundSource;
        if (bl2) {
            this.combineSpectra(bl3 ? string3 : null);
        } else {
            this.splitSpectra();
        }
        this.selectedPanel.getPanelData().taintedAll = true;
        if (!bl3) {
            this.si.siUpdateRecentMenus(string4);
        }
        return 0;
    }

    public void close(String string) {
        if (string == null || string.equalsIgnoreCase("all") || string.equals("*")) {
            this.si.siCloseSource(null);
            return;
        }
        if ((string = string.replace('\\', '/')).endsWith("*")) {
            string = string.substring(0, string.length() - 1);
            int n = this.panelNodes.size();
            while (--n >= 0) {
                if (n >= this.panelNodes.size() || !((PanelNode)this.panelNodes.get((int)n)).fileName.startsWith(string)) continue;
                this.si.siCloseSource(((PanelNode)this.panelNodes.get((int)n)).source);
            }
        } else if (string.equals("selected")) {
            List<JDXSource> list = new List<JDXSource>();
            JDXSource jDXSource = null;
            int n = this.panelNodes.size();
            while (--n >= 0) {
                JDXSource jDXSource2 = ((PanelNode)this.panelNodes.get((int)n)).source;
                if (((PanelNode)this.panelNodes.get((int)n)).isSelected && (jDXSource == null || jDXSource != jDXSource2)) {
                    list.addLast(jDXSource2);
                }
                jDXSource = jDXSource2;
            }
            n = list.size();
            while (--n >= 0) {
                this.si.siCloseSource((JDXSource)list.get(n));
            }
        } else {
            JDXSource jDXSource;
            JDXSource jDXSource3 = jDXSource = string.length() == 0 ? this.currentSource : PanelNode.findSourceByNameOrId(string, this.panelNodes);
            if (jDXSource == null) {
                return;
            }
            this.si.siCloseSource(jDXSource);
        }
        if (this.selectedPanel == null && this.panelNodes.size() > 0) {
            this.si.siSetSelectedPanel(PanelNode.getLastFileFirstNode(this.panelNodes));
        }
    }

    public void load(String string) {
        boolean bl;
        List<String> list = ScriptToken.getTokens(string);
        String string2 = (String)list.get(0);
        int n = 0;
        boolean bl2 = string2.equalsIgnoreCase("APPEND");
        boolean bl3 = string2.equalsIgnoreCase("CHECK");
        if (bl2 || bl3) {
            string2 = (String)list.get(++n);
        }
        if (bl = string2.equalsIgnoreCase("MOL")) {
            string2 = "http://SIMULATION/MOL=" + PT.trimQuotes((String)list.get(++n));
        }
        if (!bl3 && !bl2) {
            if (string2.equals("\"\"") && this.currentSource != null) {
                string2 = this.currentSource.getFilePath();
            }
            this.close("all");
        }
        if ((string2 = PT.trimQuotes(string2)).startsWith("$")) {
            bl = true;
            string2 = "http://SIMULATION/" + string2;
        }
        int n2 = n + 1 < list.size() ? Integer.valueOf((String)list.get(++n)) : -1;
        int n3 = n + 1 < list.size() ? Integer.valueOf((String)list.get(++n)) : n2;
        this.si.siOpenDataOrFile(null, null, null, string2, n2, n3, bl2);
    }

    public void combineSpectra(String string) {
        JDXSource jDXSource = this.currentSource;
        List<JDXSpectrum> list = jDXSource.getSpectra();
        JSVPanel jSVPanel = this.si.siGetNewJSVPanel2(list);
        jSVPanel.setTitle(jDXSource.getTitle());
        if (jSVPanel.getTitle().equals("")) {
            jSVPanel.getPanelData().setViewTitle(jDXSource.getFilePath());
            jSVPanel.setTitle(string);
        }
        this.si.siSetPropertiesFromPreferences(jSVPanel, true);
        (new JSVPanel[1])[0] = jSVPanel;
        this.si.siCreateTree((JDXSource)jDXSource, (JSVPanel[])new JSVPanel[1]).getPanelNode().isView = true;
        PanelNode panelNode = PanelNode.findNode(this.selectedPanel, this.panelNodes);
        panelNode.setFrameTitle(string);
        panelNode.isView = true;
        if (this.si.siGetAutoShowLegend() && this.pd().getNumberOfGraphSets() == 1) {
            panelNode.setLegend(this.getDialog(Annotation.AType.OverlayLegend, null));
        }
        this.si.siSetMenuEnables(panelNode, false);
    }

    public void closeSource(JDXSource jDXSource) {
        JSVTreeNode jSVTreeNode = this.spectraTree.getRootNode();
        String string = jDXSource == null ? null : jDXSource.getFilePath();
        List<JSVTreeNode> list = new List<JSVTreeNode>();
        Enumeration<JSVTreeNode> enumeration = jSVTreeNode.children();
        while (enumeration.hasMoreElements()) {
            JSVTreeNode jSVTreeNode2 = enumeration.nextElement();
            if (string != null && !jSVTreeNode2.getPanelNode().source.getFilePath().equals(string)) continue;
            Enumeration<JSVTreeNode> enumeration2 = jSVTreeNode2.children();
            while (enumeration2.hasMoreElements()) {
                JSVTreeNode jSVTreeNode3 = enumeration2.nextElement();
                list.addLast(jSVTreeNode3);
                this.panelNodes.removeObj(jSVTreeNode3.getPanelNode());
            }
            list.addLast(jSVTreeNode2);
            if (string == null) continue;
            break;
        }
        this.spectraTree.deleteNodes(list);
        if (jDXSource == null) {
            if (this.currentSource != null) {
                this.currentSource.dispose();
            }
            this.currentSource = null;
            if (this.selectedPanel != null) {
                this.selectedPanel.dispose();
            }
        }
        if (this.currentSource == jDXSource) {
            this.si.siSetSelectedPanel(null);
            this.si.siSetCurrentSource(null);
        }
        int n = 0;
        for (int i = 0; i < this.panelNodes.size(); ++i) {
            float f = PT.parseFloat(((PanelNode)this.panelNodes.get((int)i)).id);
            if (!(f >= (float)(n + 1))) continue;
            n = (int)Math.floor(f);
        }
        this.si.siSetFileCount(n);
        System.gc();
        Logger.checkMemory();
    }

    public void setFrameAndTreeNode(int n) {
        if (this.panelNodes == null || n < 0 || n >= this.panelNodes.size()) {
            return;
        }
        this.setNode((PanelNode)this.panelNodes.get(n), false);
    }

    public PanelNode selectFrameNode(JSVPanel jSVPanel) {
        PanelNode panelNode = PanelNode.findNode(jSVPanel, this.panelNodes);
        if (panelNode == null) {
            return null;
        }
        this.spectraTree.setPath(this.spectraTree.newTreePath(panelNode.treeNode.getPath()));
        this.setOverlayLegendVisibility(null, false);
        return panelNode;
    }

    private boolean setSpectrum(String string) {
        if (string.indexOf(46) >= 0) {
            PanelNode panelNode = PanelNode.findNodeById(string, this.panelNodes);
            if (panelNode == null) {
                return false;
            }
            this.setNode(panelNode, false);
        } else {
            int n = PT.parseInt(string);
            if (n <= 0) {
                this.checkOverlay();
                return false;
            }
            this.setFrameAndTreeNode(n - 1);
        }
        return true;
    }

    public void splitSpectra() {
        JDXSource jDXSource = this.currentSource;
        List<JDXSpectrum> list = jDXSource.getSpectra();
        JSVPanel[] jSVPanelArray = new JSVPanel[list.size()];
        JSVPanel jSVPanel = null;
        for (int i = 0; i < list.size(); ++i) {
            JDXSpectrum jDXSpectrum = (JDXSpectrum)list.get(i);
            jSVPanel = this.si.siGetNewJSVPanel(jDXSpectrum);
            this.si.siSetPropertiesFromPreferences(jSVPanel, true);
            jSVPanelArray[i] = jSVPanel;
        }
        this.si.siCreateTree(jDXSource, jSVPanelArray);
        this.si.siGetNewJSVPanel(null);
        PanelNode panelNode = PanelNode.findNode(this.selectedPanel, this.panelNodes);
        this.si.siSetMenuEnables(panelNode, true);
    }

    public void selectedTreeNode(JSVTreeNode jSVTreeNode) {
        if (jSVTreeNode == null) {
            return;
        }
        if (jSVTreeNode.isLeaf()) {
            this.setNode(jSVTreeNode.getPanelNode(), true);
        } else {
            System.out.println("not a leaf");
        }
        this.si.siSetCurrentSource(jSVTreeNode.getPanelNode().source);
    }

    public void removeAllHighlights() {
        JSVPanel jSVPanel = this.selectedPanel;
        if (jSVPanel != null) {
            jSVPanel.getPanelData().removeAllHighlights();
            jSVPanel.doRepaint(false);
        }
    }

    public void removeHighlight(double d, double d2) {
        JSVPanel jSVPanel = this.selectedPanel;
        if (jSVPanel != null) {
            jSVPanel.getPanelData().removeHighlight(d, d2);
            jSVPanel.doRepaint(false);
        }
    }

    public void dispose() {
        this.fileHelper = null;
        if (this.viewDialog != null) {
            this.viewDialog.dispose();
        }
        this.viewDialog = null;
        if (this.overlayLegendDialog != null) {
            this.overlayLegendDialog.dispose();
        }
        this.overlayLegendDialog = null;
        if (this.jsvpPopupMenu != null) {
            this.jsvpPopupMenu.jpiDispose();
            this.jsvpPopupMenu = null;
        }
        if (this.panelNodes != null) {
            int n = this.panelNodes.size();
            while (--n >= 0) {
                ((PanelNode)this.panelNodes.get(n)).dispose();
                this.panelNodes.remove(n);
            }
        }
    }

    public void runScript(String string) {
        if (this.scriptQueue == null) {
            this.si.siProcessCommand(string);
        } else {
            this.scriptQueue.addLast(string);
        }
    }

    public void requestRepaint() {
        if (this.selectedPanel != null) {
            this.repaintManager.refresh();
        }
    }

    public void repaintDone() {
        this.repaintManager.repaintDone();
    }

    public void checkOverlay() {
        if (this.viewPanel != null) {
            this.viewPanel.markSelectedPanels(this.panelNodes);
        }
        this.viewDialog = this.getDialog(Annotation.AType.Views, null);
    }

    private void execOverlayOffsetY(int n) {
        if (this.selectedPanel == null) {
            return;
        }
        if (n == Integer.MIN_VALUE) {
            String string = this.selectedPanel.getInput("Enter a vertical offset in percent for stacked plots", "Overlay", "" + this.recentStackPercent);
            float f = PT.parseFloat(string);
            if (Float.isNaN(f)) {
                return;
            }
            n = (int)f;
        }
        this.recentStackPercent = n;
        this.pd().setYStackOffsetPercent(n);
    }

    private void execScriptInline(String string) {
        if (string.length() > 0) {
            string = string.substring(6).trim();
        }
        if (string.length() == 0) {
            string = this.selectedPanel.getInput("Enter a JSpecView script", "Script", this.recentScript);
        }
        if (string == null) {
            return;
        }
        this.recentScript = string;
        this.runScriptNow(string);
    }

    public void setDisplay(Object object) {
        this.display = object;
        this.apiPlatform.setViewer(this, this.display);
        int[] nArray = new int[2];
        this.apiPlatform.getFullScreenDimensions(object, nArray);
        this.setScreenDimension(nArray[0], nArray[1]);
    }

    @Override
    public void setScreenDimension(int n, int n2) {
        n2 = Math.min(n2, this.maximumSize);
        if (this.dimScreen.width == (n = Math.min(n, this.maximumSize)) && this.dimScreen.height == n2) {
            return;
        }
        this.resizeImage(n, n2);
    }

    void resizeImage(int n, int n2) {
        if (n > 0) {
            this.dimScreen.width = n;
            this.dimScreen.height = n2;
        } else {
            n = this.dimScreen.width == 0 ? (this.dimScreen.width = 500) : this.dimScreen.width;
            n2 = this.dimScreen.height == 0 ? (this.dimScreen.height = 500) : this.dimScreen.height;
        }
        this.g2d.setWindowParameters(n, n2);
    }

    @Override
    public void updateJS(int n, int n2) {
        if (this.selectedPanel == null) {
            return;
        }
    }

    @Override
    public boolean processMouseEvent(int n, int n2, int n3, int n4, long l) {
        return this.selectedPanel != null && this.selectedPanel.processMouseEvent(n, n2, n3, n4, l);
    }

    @Override
    public void processTwoPointGesture(float[][][] fArray) {
        if (this.selectedPanel != null) {
            this.selectedPanel.processTwoPointGesture(fArray);
        }
    }

    @Override
    public Object getApplet() {
        return this.applet;
    }

    @Override
    public void startHoverWatcher(boolean bl) {
    }

    @Override
    public int cacheFileByName(String string, boolean bl) {
        return 0;
    }

    @Override
    public void cachePut(String string, Object object) {
    }

    @Override
    public void openFileAsyncSpecial(String string, int n) {
    }

    public int getHeight() {
        return this.dimScreen.height;
    }

    public int getWidth() {
        return this.dimScreen.width;
    }

    public Object getPlatformInterface(String string) {
        return JSViewer.getInterface("jspecview." + (this.isJS ? "js2d.Js" : "java.Awt") + string);
    }

    public DialogManager getDialogManager() {
        if (this.dialogManager != null) {
            return this.dialogManager;
        }
        this.dialogManager = (DialogManager)this.getPlatformInterface("DialogManager");
        return this.dialogManager.set(this);
    }

    public JSVDialog getDialog(Annotation.AType aType, JDXSpectrum jDXSpectrum) {
        String string = "jspecview.dialog.";
        switch (aType) {
            case Integration: {
                return ((JSVDialog)JSViewer.getInterface(string + "IntegrationDialog")).setParams("Integration for " + jDXSpectrum, this, jDXSpectrum);
            }
            case Measurements: {
                return ((JSVDialog)JSViewer.getInterface(string + "MeasurementsDialog")).setParams("Measurements for " + jDXSpectrum, this, jDXSpectrum);
            }
            case PeakList: {
                return ((JSVDialog)JSViewer.getInterface(string + "PeakListDialog")).setParams("Peak List for " + jDXSpectrum, this, jDXSpectrum);
            }
            case OverlayLegend: {
                this.overlayLegendDialog = ((JSVDialog)JSViewer.getInterface(string + "OverlayLegendDialog")).setParams(this.pd().getViewTitle(), this, null);
                return this.overlayLegendDialog;
            }
            case Views: {
                this.viewDialog = ((JSVDialog)JSViewer.getInterface(string + "ViewsDialog")).setParams("View/Combine/Close Spectra", this, null);
                return this.viewDialog;
            }
        }
        return null;
    }

    private void show(String string) {
        this.getDialogManager();
        if (string.equals("properties")) {
            this.dialogManager.showProperties(null, this.pd().getSpectrum());
        } else if (string.equals("errors")) {
            this.dialogManager.showSourceErrors(null, this.currentSource);
        } else if (string.equals("source")) {
            if (this.currentSource == null) {
                if (this.panelNodes.size() > 0) {
                    this.dialogManager.showMessageDialog(null, "Please Select a Spectrum", "Select Spectrum", 0);
                }
                return;
            }
            this.dialogManager.showSource(this, this.currentSource);
        }
    }

    public PrintLayout getDialogPrint(boolean bl) {
        if (!this.isJS) {
            try {
                PrintLayout printLayout = ((JSVPrintDialog)this.getPlatformInterface("PrintDialog")).set(this.offWindowFrame, this.lastPrintLayout, bl).getPrintLayout();
                if (printLayout != null) {
                    this.lastPrintLayout = printLayout;
                }
                return printLayout;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PrintLayout();
    }

    public void setIRmode(String string) {
        this.irMode = string.equals("AtoT") ? JDXSpectrum.IRMode.TO_TRANS : (string.equals("TtoA") ? JDXSpectrum.IRMode.TO_ABS : JDXSpectrum.IRMode.getMode(string));
    }

    public int getOptionFromDialog(String[] stringArray, String string, String string2) {
        this.getDialogManager().getOptionFromDialog(null, stringArray, this.selectedPanel, string, string2);
        return 0;
    }

    private String execWrite(String string) {
        if (this.isJS && string == null) {
            string = "PDF";
        }
        String string2 = ((ExportInterface)JSViewer.getInterface("jspecview.export.Exporter")).write(this, string == null ? null : ScriptToken.getTokens(string), false);
        this.si.writeStatus(string2);
        return string2;
    }

    public String export(String string, int n) {
        if (string == null) {
            string = "XY";
        }
        PanelData panelData = this.pd();
        int n2 = panelData.getNumberOfSpectraInCurrentSet();
        if (n < -1 || n >= n2) {
            return "Maximum spectrum index (0-based) is " + (n2 - 1) + ".";
        }
        JDXSpectrum jDXSpectrum = n < 0 ? panelData.getSpectrum() : panelData.getSpectrumAt(n);
        try {
            return ((ExportInterface)JSViewer.getInterface("jspecview.export.Exporter")).exportTheSpectrum(this, ExportType.getType(string), null, jDXSpectrum, 0, jDXSpectrum.getXYCoords().length - 1, null);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return null;
        }
    }

    @Override
    public String postByteArray(String string, byte[] byArray) {
        return JSVFileManager.postByteArray(string, byArray);
    }

    public OC getOutputChannel(String string, boolean bl) throws Exception {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = string == null ? null : new FileOutputStream(string);
        return new OC().setParams(this, string, !bl, fileOutputStream);
    }

    public static Object getInterface(String string) {
        try {
            Class<?> clazz = Class.forName(string);
            return clazz == null ? null : clazz.newInstance();
        }
        catch (Exception exception) {
            Logger.error("Interface.java Error creating instance for " + string + ": \n" + exception);
            return null;
        }
    }
}

