/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.Component;
import java.awt.Frame;
import java.io.File;
import javajs.api.GenericFileInterface;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jspecview.api.JSVFileHelper;
import jspecview.common.ExportType;
import jspecview.common.JSViewer;
import jspecview.java.AwtDialogFileFilter;
import jspecview.java.AwtFile;

public class AwtFileHelper
implements JSVFileHelper {
    public String dirLastOpened;
    public boolean useDirLastOpened;
    public boolean useDirLastExported;
    public String dirLastExported;
    private JFileChooser fc;
    private JSViewer viewer;

    public AwtFileHelper set(JSViewer viewer) {
        this.viewer = viewer;
        return this;
    }

    public void setFileChooser(ExportType imode) {
        if (this.fc == null) {
            this.fc = new JFileChooser();
        }
        AwtDialogFileFilter filter = new AwtDialogFileFilter();
        this.fc.resetChoosableFileFilters();
        switch (imode) {
            case UNK: {
                filter = new AwtDialogFileFilter();
                filter.addExtension("xml");
                filter.addExtension("aml");
                filter.addExtension("cml");
                filter.setDescription("CML/XML Files");
                this.fc.setFileFilter(filter);
                filter = new AwtDialogFileFilter();
                filter.addExtension("jdx");
                filter.addExtension("dx");
                filter.setDescription("JCAMP-DX Files");
                this.fc.setFileFilter(filter);
                break;
            }
            case SOURCE: 
            case DIF: 
            case FIX: 
            case SQZ: 
            case PAC: 
            case XY: 
            case DIFDUP: {
                filter.addExtension("jdx");
                filter.addExtension("dx");
                filter.setDescription("JCAMP-DX Files");
                break;
            }
            default: {
                filter.addExtension(imode.toString().toLowerCase());
                filter.setDescription((Object)((Object)imode) + " Files");
            }
        }
        this.fc.setFileFilter(filter);
    }

    public GenericFileInterface showFileOpenDialog(Frame frame) {
        this.setFileChooser(ExportType.UNK);
        return this.getFile("", frame, false);
    }

    public GenericFileInterface getFile(String name, Object panelOrFrame, boolean isSave) {
        int returnVal;
        Component c = (Component)panelOrFrame;
        this.fc.setSelectedFile(new File(name));
        if (isSave) {
            if (this.useDirLastExported) {
                this.fc.setCurrentDirectory(new File(this.dirLastExported));
            }
        } else if (this.useDirLastOpened) {
            this.fc.setCurrentDirectory(new File(this.dirLastOpened));
        }
        int n = returnVal = isSave ? this.fc.showSaveDialog(c) : this.fc.showOpenDialog(c);
        if (returnVal != 0) {
            return null;
        }
        AwtFile file = new AwtFile(this.fc.getSelectedFile().getAbsolutePath());
        if (isSave) {
            int option;
            this.dirLastExported = file.getParent();
            this.viewer.setProperty("directoryLastExportedFile", this.dirLastExported);
            if (file.exists() && (option = JOptionPane.showConfirmDialog(c, "Overwrite " + file.getName() + "?", "Confirm Overwrite Existing File", 0, 3)) == 1) {
                return null;
            }
        } else {
            this.dirLastOpened = file.getParent();
            this.viewer.setProperty("directoryLastOpenedFile", this.dirLastOpened);
        }
        return file;
    }

    public String setDirLastExported(String name) {
        this.dirLastExported = name;
        return this.dirLastExported;
    }
}

