/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import javajs.util.List;
import javajs.util.SB;
import jspecview.api.SourceReader;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.source.FileReader;
import jspecview.source.JDXSource;
import jspecview.source.JSVXmlReader;
import org.jmol.util.Logger;

abstract class XMLReader
implements SourceReader {
    protected JDXSource source;
    protected String filePath = "";
    protected JSVXmlReader reader;
    protected String tagName = "START";
    protected String attrList = "";
    protected String title = "";
    protected String owner = "UNKNOWN";
    protected String origin = "UNKNOWN";
    protected String tmpEnd = "END";
    protected String molForm = "";
    protected String techname = "";
    protected int npoints = -1;
    protected int samplenum = -1;
    protected double[] yaxisData;
    protected double[] xaxisData;
    protected String xUnits = "";
    protected String yUnits = "ARBITRARY UNITS";
    protected String vendor = "na";
    protected String modelType = "MODEL UNKNOWN";
    protected String LongDate = "";
    protected String pathlength = "na";
    protected String identifier = "";
    protected String plLabel = "";
    protected String resolution = "na";
    protected String resLabel = "";
    protected String LocName = "";
    protected String LocContact = "";
    protected String casName = "";
    protected String sampleowner = "";
    protected String obNucleus = "";
    protected String StrObFreq = "";
    protected boolean increasing = false;
    protected boolean continuous = false;
    protected int ivspoints;
    protected int evspoints;
    protected int sampleRefNum = 0;
    protected double deltaX = Double.MAX_VALUE;
    protected double xFactor = Double.MAX_VALUE;
    protected double yFactor = Double.MAX_VALUE;
    protected double firstX = Double.MAX_VALUE;
    protected double lastX = Double.MAX_VALUE;
    protected double firstY = Double.MAX_VALUE;
    protected double obFreq = Double.MAX_VALUE;
    protected double refPoint = Double.MAX_VALUE;
    protected String casRN = "";
    protected String sampleID;
    protected SB errorLog = new SB();
    static final String[] tagNames = new String[]{"audittrail", "experimentstepset", "sampleset", "xx result", "spectrum", "metadatalist", "conditionlist", "parameterlist", "sample", "spectrumdata", "peaklist", "author", "peaklist"};
    static final int AML_0 = 0;
    static final int AML_AUDITTRAIL = 0;
    static final int AML_EXPERIMENTSTEPSET = 1;
    static final int AML_SAMPLESET = 2;
    static final int AML_RESULT = 3;
    static final int AML_1 = 3;
    static final int CML_0 = 4;
    static final int CML_SPECTRUM = 4;
    static final int CML_METADATALIST = 5;
    static final int CML_CONDITIONLIST = 6;
    static final int CML_PARAMETERLIST = 7;
    static final int CML_SAMPLE = 8;
    static final int CML_SPECTRUMDATA = 9;
    static final int CML_PEAKLIST = 10;
    static final int CML_1 = 10;
    static final int AML_AUTHOR = 11;
    static final int CML_PEAKLIST2 = 12;

    protected abstract JDXSource getXML(BufferedReader var1);

    protected abstract boolean processTag(int var1) throws Exception;

    protected abstract void processEndTag(int var1) throws Exception;

    @Override
    public JDXSource getSource(String string, BufferedReader bufferedReader) {
        this.filePath = string;
        return this.getXML(bufferedReader);
    }

    protected void getSimpleXmlReader(BufferedReader bufferedReader) {
        this.reader = new JSVXmlReader(bufferedReader);
    }

    protected void checkStart() throws Exception {
        if (this.reader.peek() == 1) {
            return;
        }
        String string = "Error: XML <xxx> not found at beginning of file; not an XML document?";
        this.errorLog.append(string);
        throw new IOException(string);
    }

    protected void populateVariables() {
        List<String[]> list = new List<String[]>();
        JDXSpectrum jDXSpectrum = new JDXSpectrum();
        jDXSpectrum.setTitle(this.title);
        jDXSpectrum.setJcampdx("5.01");
        jDXSpectrum.setDataClass("XYDATA");
        jDXSpectrum.setDataType(this.techname);
        jDXSpectrum.setContinuous(this.continuous);
        jDXSpectrum.setIncreasing(this.increasing);
        jDXSpectrum.setXFactor(this.xFactor);
        jDXSpectrum.setYFactor(this.yFactor);
        jDXSpectrum.setLongDate(this.LongDate);
        jDXSpectrum.setOrigin(this.origin);
        jDXSpectrum.setOwner(this.owner);
        FileReader.addHeader(list, "##PATHLENGTH", this.pathlength);
        FileReader.addHeader(list, "##RESOLUTION", this.resolution);
        if (!this.StrObFreq.equals("")) {
            FileReader.addHeader(list, "##.OBSERVEFREQUENCY", this.StrObFreq);
        }
        if (!this.obNucleus.equals("")) {
            FileReader.addHeader(list, "##.OBSERVENUCLEUS", this.obNucleus);
        }
        FileReader.addHeader(list, "##$MANUFACTURER", this.vendor);
        if (!this.casRN.equals("")) {
            FileReader.addHeader(list, "##CASREGISTRYNO", this.casRN);
        }
        if (!this.molForm.equals("")) {
            FileReader.addHeader(list, "##MOLFORM", this.molForm);
        }
        if (!this.modelType.equals("")) {
            FileReader.addHeader(list, "##SPECTROMETER/DATA SYSTEM", this.modelType);
        }
        jDXSpectrum.setHeaderTable(list);
        double d = 1.0;
        if (this.obFreq != Double.MAX_VALUE) {
            jDXSpectrum.setObservedFreq(this.obFreq);
            if (this.xUnits.toUpperCase().equals("HZ")) {
                this.xUnits = "PPM";
                jDXSpectrum.setHZtoPPM(true);
                d = this.obFreq;
            }
        }
        Coordinate[] coordinateArray = new Coordinate[this.npoints];
        for (int i = 0; i < this.npoints; ++i) {
            coordinateArray[i] = new Coordinate().set(this.xaxisData[i] / d, this.yaxisData[i]);
        }
        if (!this.increasing) {
            coordinateArray = Coordinate.reverse(coordinateArray);
        }
        jDXSpectrum.setXUnits(this.xUnits);
        jDXSpectrum.setYUnits(this.yUnits);
        jDXSpectrum.setXYCoords(coordinateArray);
        this.source.addJDXSpectrum(this.filePath, jDXSpectrum, false);
    }

    protected boolean checkPointCount() {
        if (this.continuous && this.npoints < 5) {
            System.err.println("Insufficient points to plot");
            this.errorLog.append("Insufficient points to plot \n");
            this.source.setErrorLog(this.errorLog.toString());
            return false;
        }
        return true;
    }

    protected void processErrors(String string) {
        this.reader = null;
        if (this.errorLog.length() > 0) {
            this.errorLog.append("these errors were found in " + string + " \n");
            this.errorLog.append("=====================\n");
        }
        this.source.setErrorLog(this.errorLog.toString());
    }

    protected void processXML(int n, int n2) throws Exception {
        block0: while (this.reader.hasNext()) {
            if (this.reader.nextEvent() != 1) continue;
            String string = this.reader.getTagName();
            boolean bl = this.reader.requiresEndTag();
            if (Logger.debugging) {
                Logger.info(this.tagName);
            }
            for (int i = n; i <= n2; ++i) {
                if (!string.equals(tagNames[i])) continue;
                this.process(i, bl);
                continue block0;
            }
        }
    }

    protected void process(int n, boolean bl) {
        String string = tagNames[n];
        try {
            this.tagName = this.reader.getTagName();
            this.attrList = this.reader.getAttributeList();
            if (!this.processTag(n) || !bl) {
                return;
            }
            block6: while (this.reader.hasNext()) {
                switch (this.reader.nextEvent()) {
                    default: {
                        continue block6;
                    }
                    case 2: {
                        if (!this.reader.getEndTag().equals(string)) continue block6;
                        this.processEndTag(n);
                        return;
                    }
                    case 1: 
                }
                this.tagName = this.reader.getTagName();
                if (this.tagName.startsWith("!--")) continue;
                this.attrList = this.reader.getAttributeList();
                if (this.processTag(n)) continue;
                return;
            }
        }
        catch (Exception exception) {
            String string2 = "error reading " + this.tagName + " section: " + exception.getMessage() + "\n" + exception.getStackTrace();
            Logger.error(string2);
            this.errorLog.append(string2 + "\n");
        }
    }
}

