/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Map;
import javajs.util.AU;
import javajs.util.DF;
import javajs.util.List;
import jspecview.api.AnnotationData;
import jspecview.common.Annotation;
import jspecview.common.ColorParameters;
import jspecview.common.JDXSpectrum;
import jspecview.common.Measurement;
import jspecview.common.Parameters;

public class MeasurementData
extends List<Measurement>
implements AnnotationData {
    private static final long serialVersionUID = 1L;
    private Annotation.AType type;
    protected JDXSpectrum spec;
    protected String units;
    protected int precision;
    protected Parameters myParams;
    private boolean isON = true;
    private String key;
    private static final String[] HEADER = new String[]{"", "start", "end", "value"};

    MeasurementData(Annotation.AType aType, JDXSpectrum jDXSpectrum) {
        this.type = aType;
        this.spec = jDXSpectrum;
        this.myParams = new Parameters().setName("MeasurementData");
    }

    List<Measurement> getMeasurements() {
        return this;
    }

    @Override
    public Annotation.AType getAType() {
        return this.type;
    }

    @Override
    public boolean getState() {
        return this.isON;
    }

    @Override
    public void setState(boolean bl) {
        this.isON = bl;
    }

    void setMeasurements(List<Measurement> list) {
    }

    @Override
    public Parameters getParameters() {
        return this.myParams;
    }

    public String[] getDataHeader() {
        return HEADER;
    }

    public String[][] getMeasurementListArray(String string) {
        this.units = string;
        double[][] dArray = this.getMeasurementListArrayReal(string);
        int n = this.spec.isNMR() ? 4 : 2;
        int n2 = this.spec.isHNMR() && string.equals("ppm") ? 4 : 2;
        String[][] stringArray = new String[this.size()][];
        int n3 = this.size();
        while (--n3 >= 0) {
            stringArray[n3] = new String[]{"" + (n3 + 1), DF.formatDecimalDbl(dArray[n3][0], n), DF.formatDecimalDbl(dArray[n3][1], n), DF.formatDecimalDbl(dArray[n3][2], n2)};
        }
        return stringArray;
    }

    double[][] getMeasurementListArrayReal(String string) {
        boolean bl = this.spec.isNMR() && string.equalsIgnoreCase("HZ");
        double[][] dArray = AU.newDouble2(this.size());
        int n = 0;
        int n2 = this.size();
        while (--n2 >= 0) {
            double d = ((Measurement)this.get(n2)).getValue();
            if (bl) {
                d *= this.spec.observedFreq;
            }
            dArray[n++] = new double[]{((Measurement)this.get(n2)).getXVal(), ((Measurement)this.get(n2)).getXVal2(), d};
        }
        return dArray;
    }

    static boolean checkParameters(MeasurementData measurementData, ColorParameters colorParameters) {
        if (measurementData.size() == 0) {
            return false;
        }
        Parameters parameters = measurementData.getParameters();
        switch (measurementData.getAType()) {
            case Integration: {
                break;
            }
            case PeakList: {
                return colorParameters.peakListInterpolation.equals(parameters.peakListInterpolation) && colorParameters.peakListThreshold == parameters.peakListThreshold;
            }
            case Measurements: {
                break;
            }
        }
        return false;
    }

    @Override
    public JDXSpectrum getSpectrum() {
        return this.spec;
    }

    @Override
    public MeasurementData getData() {
        return this;
    }

    protected void clear(double d, double d2) {
        int n = this.size();
        while (--n >= 0) {
            Measurement measurement = (Measurement)this.get(n);
            if (measurement.text.length() != 0 && !measurement.overlaps(d, d2)) continue;
            this.remove(n);
        }
    }

    @Override
    public void setSpecShift(double d) {
        int n = this.size();
        while (--n >= 0) {
            Measurement measurement = (Measurement)this.get(n);
            double d2 = measurement.getXVal() + d;
            measurement.setXVal(d2);
            measurement.setValue(d2);
            measurement.text = DF.formatDecimalDbl(d2, this.precision);
        }
    }

    @Override
    public String getGraphSetKey() {
        return this.key;
    }

    @Override
    public void setGraphSetKey(String string) {
        this.key = string;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    void getInfo(Map<String, Object> map) {
        map.put("header", this.getDataHeader());
        map.put("table", this.getMeasurementListArrayReal("ppm"));
        if (this.units != null) {
            map.put("units", this.units);
        }
    }
}

