/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Map;
import javajs.util.List;
import javajs.util.SB;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTreeNode;
import jspecview.common.JDXSpectrum;
import jspecview.common.Parameters;
import jspecview.dialog.JSVDialog;
import jspecview.source.JDXSource;

public class PanelNode {
    public JSVTreeNode treeNode;
    public JDXSource source;
    public String fileName;
    public JSVPanel jsvp;
    public String id;
    public JSVDialog legend;
    public boolean isSelected;
    public boolean isView;
    public String frameTitle;

    public PanelNode(String string, String string2, JDXSource jDXSource, JSVPanel jSVPanel) {
        this.id = string;
        this.source = jDXSource;
        this.fileName = string2;
        this.jsvp = jSVPanel;
        if (jSVPanel != null) {
            jSVPanel.getPanelData().getSpectrumAt(0).setId(string);
            this.frameTitle = jSVPanel.getTitle();
        }
    }

    public void setTreeNode(JSVTreeNode jSVTreeNode) {
        this.treeNode = jSVTreeNode;
    }

    public Object getTreeNode() {
        return this.treeNode;
    }

    public void dispose() {
        this.source.dispose();
        if (this.jsvp != null) {
            this.jsvp.dispose();
        }
        this.source = null;
        this.jsvp = null;
        this.legend = null;
    }

    public JDXSpectrum getSpectrum() {
        return this.jsvp.getPanelData().getSpectrum();
    }

    public JSVDialog setLegend(JSVDialog jSVDialog) {
        if (this.legend != null) {
            this.legend.dispose();
        }
        this.legend = jSVDialog;
        return jSVDialog;
    }

    public String toString() {
        return (this.id == null ? "" : this.id + ": ") + (this.frameTitle == null ? this.fileName : this.frameTitle);
    }

    public static JDXSource findSourceByNameOrId(String string, List<PanelNode> list) {
        PanelNode panelNode;
        int n = list.size();
        while (--n >= 0) {
            panelNode = (PanelNode)list.get(n);
            if (!string.equals(panelNode.id) && !string.equalsIgnoreCase(panelNode.source.getFilePath())) continue;
            return panelNode.source;
        }
        n = list.size();
        while (--n >= 0) {
            panelNode = (PanelNode)list.get(n);
            if (!string.equals(panelNode.fileName)) continue;
            return panelNode.source;
        }
        return null;
    }

    public static PanelNode findNodeById(String string, List<PanelNode> list) {
        int n = list.size();
        while (--n >= 0) {
            if (!string.equals(((PanelNode)list.get((int)n)).id)) continue;
            return (PanelNode)list.get(n);
        }
        return null;
    }

    public static PanelNode findNode(JSVPanel jSVPanel, List<PanelNode> list) {
        int n = list.size();
        while (--n >= 0) {
            if (((PanelNode)list.get((int)n)).jsvp != jSVPanel) continue;
            return (PanelNode)list.get(n);
        }
        return null;
    }

    public static String getSpectrumListAsString(List<PanelNode> list) {
        SB sB = new SB();
        for (int i = 0; i < list.size(); ++i) {
            String string = ((PanelNode)list.get((int)i)).id;
            sB.append(" ").append(string);
        }
        return sB.toString().trim();
    }

    public static boolean isOpen(List<PanelNode> list, String string) {
        if (string != null) {
            int n = list.size();
            while (--n >= 0) {
                if (!string.equals(((PanelNode)list.get((int)n)).source.getFilePath()) && !string.equals(((PanelNode)list.get((int)n)).frameTitle)) continue;
                return true;
            }
        }
        return false;
    }

    public void setFrameTitle(String string) {
        this.frameTitle = string;
    }

    public static JSVPanel getLastFileFirstNode(List<PanelNode> list) {
        int n = list.size();
        PanelNode panelNode = n == 0 ? null : (PanelNode)list.get(n - 1);
        int n2 = n - 1;
        while (--n2 >= 0 && ((PanelNode)list.get((int)n2)).source == panelNode.source) {
            panelNode = (PanelNode)list.get(n2);
        }
        return panelNode == null ? null : panelNode.jsvp;
    }

    Map<String, Object> getInfo(String string) {
        Map<String, Object> map = this.jsvp.getPanelData().getInfo(false, string);
        Parameters.putInfo(string, map, "panelId", this.id);
        Parameters.putInfo(string, map, "panelFileName", this.fileName);
        Parameters.putInfo(string, map, "panelSource", this.source.getFilePath());
        return map;
    }
}

