/*
 * Decompiled with CFR 0.152.
 */
package jspecview.java;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jspecview.api.JSVPanel;
import jspecview.api.PlatformDialog;
import jspecview.common.JDXSpectrum;
import jspecview.dialog.DialogManager;
import jspecview.dialog.JSVDialog;
import jspecview.java.AwtDialog;

public class AwtDialogManager
extends DialogManager
implements ListSelectionListener,
WindowListener,
ActionListener {
    public PlatformDialog getDialog(JSVDialog jsvDialog) {
        return new AwtDialog(this, jsvDialog, this.registerDialog(jsvDialog));
    }

    public String getDialogInput(Object parentComponent, String phrase, String title, int msgType, Object icon, Object[] objects, String defaultStr) {
        return (String)JOptionPane.showInputDialog((Component)parentComponent, phrase, title, msgType, (Icon)icon, objects, defaultStr);
    }

    public int getOptionFromDialog(Object frame, String[] items, JSVPanel jsvp, String title, String label) {
        final JDialog dialog = new JDialog((JFrame)frame, title, true);
        dialog.setResizable(false);
        dialog.setSize(200, 100);
        Component panel = (Component)((Object)jsvp);
        dialog.setLocation((panel.getLocation().x + panel.getSize().width) / 2, (panel.getLocation().y + panel.getSize().height) / 2);
        final JComboBox<String> cb = new JComboBox<String>(items);
        Dimension d = new Dimension(120, 25);
        cb.setPreferredSize(d);
        cb.setMaximumSize(d);
        cb.setMinimumSize(d);
        JPanel p = new JPanel(new FlowLayout());
        JButton button = new JButton("OK");
        p.add(cb);
        p.add(button);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)new JLabel(label, 0), "North");
        dialog.getContentPane().add(p);
        final int[] ret = new int[]{Integer.MIN_VALUE};
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ret[0] = cb.getSelectedIndex();
                dialog.dispose();
            }
        });
        dialog.setVisible(true);
        dialog.dispose();
        return ret[0];
    }

    public int[] getLocationOnScreen(Object component) {
        Point pt = ((Component)component).getLocationOnScreen();
        return new int[]{pt.x, pt.y};
    }

    public void showMessageDialog(Object parentComponent, String msg, String title, int msgType) {
        JOptionPane.showMessageDialog((Component)parentComponent, msg, title, msgType);
    }

    public void showProperties(Object frame, JDXSpectrum spectrum) {
        Object[][] rowData = spectrum.getHeaderRowDataAsArray();
        Object[] columnNames = new String[]{"Label", "Description"};
        JTable table = new JTable(rowData, columnNames);
        table.setPreferredScrollableViewportSize(new Dimension(400, 195));
        JScrollPane scrollPane = new JScrollPane(table);
        JOptionPane.showMessageDialog((Component)frame, scrollPane, "Header Information", -1);
    }

    protected void showScrollingText(Object frame, String title, String text) {
        JDialog dialog = new JDialog(null, title, true);
        dialog.setLayout(new BorderLayout());
        JEditorPane sourcePane = new JEditorPane();
        sourcePane.setText(text);
        sourcePane.setEditable(false);
        sourcePane.setFont(new Font(null, 1, 12));
        JScrollPane scrollPane = new JScrollPane(sourcePane);
        scrollPane.setPreferredSize(new Dimension(500, 400));
        scrollPane.setMinimumSize(new Dimension(500, 400));
        JPanel contentPanel = new JPanel();
        contentPanel.add((Component)scrollPane, "Center");
        dialog.getContentPane().add(contentPanel);
        dialog.pack();
        dialog.setVisible(true);
    }

    public synchronized void valueChanged(ListSelectionEvent e) {
        boolean adjusting = e.getValueIsAdjusting();
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        String selector = this.getSelectorName(lsm);
        if (selector == null) {
            return;
        }
        int index = lsm.getLeadSelectionIndex();
        this.processTableEvent(selector, index, -1, adjusting);
    }

    public void actionPerformed(ActionEvent e) {
        this.processClick(((Component)e.getSource()).getName());
    }

    public void windowClosing(WindowEvent e) {
        this.processWindowClosing(((Component)e.getSource()).getName());
    }

    public void windowActivated(WindowEvent arg0) {
    }

    public void windowClosed(WindowEvent arg0) {
    }

    public void windowDeactivated(WindowEvent arg0) {
    }

    public void windowDeiconified(WindowEvent arg0) {
    }

    public void windowIconified(WindowEvent arg0) {
    }

    public void windowOpened(WindowEvent arg0) {
    }
}

