/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import javajs.util.DF;
import javajs.util.PT;

public class JSVTxt {
    public static final String newLine = System.getProperty("line.separator");

    public static String fixExponentInt(double d) {
        return d == Math.floor(d) ? String.valueOf((int)d) : PT.simpleReplace(JSVTxt.fixExponent(d), "E+00", "");
    }

    public static String fixIntNoExponent(double d) {
        return d == Math.floor(d) ? String.valueOf((int)d) : DF.formatDecimalTrimmed(d, 10);
    }

    public static boolean isAlmostInteger(double d) {
        return d != 0.0 && Math.abs(d - Math.floor(d)) / d > 1.0E-8;
    }

    private static String fixExponent(double d) {
        String string = DF.formatDecimalDbl(d, -7);
        int n = string.indexOf("E");
        if (n < 0) {
            return string;
        }
        switch (string.length() - n) {
            case 2: {
                string = string.substring(0, n + 1) + "0" + string.substring(n + 1);
                break;
            }
            case 3: {
                if (string.charAt(n + 1) != '-') break;
                string = string.substring(0, n + 2) + "0" + string.substring(n + 2);
            }
        }
        if (string.indexOf("E-") < 0) {
            string = string.substring(0, n + 1) + "+" + string.substring(n + 1);
        }
        return string;
    }
}

