/*
 * Decompiled with CFR 0.152.
 */
package javajs.util;

import java.util.Map;
import javajs.util.A4;
import javajs.util.DF;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.T3;

public class PT {
    public static final float[] tensScale = new float[]{10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f};
    public static final float[] decimalScale = new float[]{0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f, 1.0E-9f};
    public static final float FLOAT_MIN_SAFE = Float.MIN_VALUE;

    public static int parseInt(String str) {
        return PT.parseIntNext(str, new int[1]);
    }

    public static int parseIntNext(String str, int[] next) {
        int cch = str.length();
        if (next[0] < 0 || next[0] >= cch) {
            return Integer.MIN_VALUE;
        }
        return PT.parseIntChecked(str, cch, next);
    }

    /*
     * Unable to fully structure code
     */
    public static int parseIntChecked(String str, int ichMax, int[] next) {
        digitSeen = false;
        value = 0;
        ich = next[0];
        if (ich >= 0) ** GOTO lbl7
        return -2147483648;
lbl-1000:
        // 1 sources

        {
            ++ich;
lbl7:
            // 2 sources

            ** while (ich < ichMax && PT.isWhiteSpace((String)str, (int)ich))
        }
lbl8:
        // 1 sources

        negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            negative = true;
            ++ich;
        }
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10 + (ch - 48);
            digitSeen = true;
            ++ich;
        }
        if (!digitSeen) {
            value = -2147483648;
        } else if (negative) {
            value = -value;
        }
        next[0] = ich;
        return value;
    }

    public static boolean isWhiteSpace(String str, int ich) {
        char ch;
        return ich >= 0 && ((ch = str.charAt(ich)) == ' ' || ch == '\t' || ch == '\n');
    }

    /*
     * Unable to fully structure code
     */
    public static float parseFloatChecked(String str, int ichMax, int[] next, boolean isStrict) {
        digitSeen = false;
        ich = next[0];
        if (!isStrict || str.indexOf(10) == str.lastIndexOf(10)) ** GOTO lbl6
        return NaNf;
lbl-1000:
        // 1 sources

        {
            ++ich;
lbl6:
            // 2 sources

            ** while (ich < ichMax && PT.isWhiteSpace((String)str, (int)ich))
        }
lbl7:
        // 1 sources

        negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            ++ich;
            negative = true;
        }
        ch = '\u0000';
        ival = 0.0f;
        ival2 = 0.0f;
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            ival = ival * 10.0f + (float)(ch - 48) * 1.0f;
            ++ich;
            digitSeen = true;
        }
        isDecimal = false;
        iscale = 0;
        v0 = nzero = ival == 0.0f ? -1 : 0;
        if (ch == '.') {
            isDecimal = true;
            while (++ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
                digitSeen = true;
                if (nzero < 0) {
                    if (ch == '0') {
                        --nzero;
                        continue;
                    }
                    nzero = -nzero;
                }
                if (iscale >= PT.decimalScale.length) continue;
                ival2 = ival2 * 10.0f + (float)(ch - 48) * 1.0f;
                ++iscale;
            }
        }
        if (!digitSeen) {
            value = NaNf;
        } else if (ival2 > 0.0f) {
            value = ival2 * PT.decimalScale[iscale - 1];
            value = nzero > 1 ? (nzero - 2 < PT.decimalScale.length ? (value *= PT.decimalScale[nzero - 2]) : (float)((double)value * Math.pow(10.0, 1 - nzero))) : (value += ival);
        } else {
            value = ival;
        }
        isExponent = false;
        if (ich < ichMax && (ch == 'E' || ch == 'e' || ch == 'D')) {
            isExponent = true;
            if (++ich >= ichMax) {
                return NaNf;
            }
            ch = str.charAt(ich);
            if (ch == '+' && ++ich >= ichMax) {
                return NaNf;
            }
            next[0] = ich;
            exponent = PT.parseIntChecked(str, ichMax, next);
            if (exponent == -2147483648) {
                return NaNf;
            }
            if (exponent > 0 && exponent <= PT.tensScale.length) {
                value *= PT.tensScale[exponent - 1];
            } else if (exponent < 0 && -exponent <= PT.decimalScale.length) {
                value *= PT.decimalScale[-exponent - 1];
            } else if (exponent != 0) {
                value = (float)((double)value * Math.pow(10.0, exponent));
            }
        } else {
            next[0] = ich;
        }
        if (negative) {
            value = -value;
        }
        if (value == Infinityf) {
            value = 3.4028235E38f;
        }
        return isStrict == false || (isExponent == false || isDecimal != false) && PT.checkTrailingText(str, next[0], ichMax) != false ? value : NaNf;
    }

    public static boolean checkTrailingText(String str, int ich, int ichMax) {
        char ch;
        while (ich < ichMax && (Character.isWhitespace(ch = str.charAt(ich)) || ch == ';')) {
            ++ich;
        }
        return ich == ichMax;
    }

    public static float[] parseFloatArray(String str) {
        return PT.parseFloatArrayNext(str, new int[1], null, null, null);
    }

    public static int parseFloatArrayInfested(String[] tokens, float[] data) {
        int len = data.length;
        int nTokens = tokens.length;
        int n = 0;
        int max = 0;
        int i = 0;
        while (i >= 0 && i < len && n < nTokens) {
            float f;
            while (Float.isNaN(f = PT.parseFloat(tokens[n++])) && n < nTokens) {
            }
            if (!Float.isNaN(f)) {
                max = i;
                data[max] = f;
            }
            if (n == nTokens) break;
            ++i;
        }
        return max + 1;
    }

    public static float[] parseFloatArrayNext(String str, int[] next, float[] f, String strStart, String strEnd) {
        int n = 0;
        int pt = next[0];
        if (pt >= 0) {
            int p;
            if (strStart != null && (p = str.indexOf(strStart, pt)) >= 0) {
                next[0] = p + strStart.length();
            }
            str = str.substring(next[0]);
            int n2 = pt = strEnd == null ? -1 : str.indexOf(strEnd);
            if (pt < 0) {
                pt = str.length();
            } else {
                str = str.substring(0, pt);
            }
            next[0] = next[0] + (pt + 1);
            String[] tokens = PT.getTokens(str);
            if (f == null) {
                f = new float[tokens.length];
            }
            n = PT.parseFloatArrayInfested(tokens, f);
        }
        if (f == null) {
            return new float[0];
        }
        int i = n;
        while (i < f.length) {
            f[i] = Float.NaN;
            ++i;
        }
        return f;
    }

    public static float parseFloatRange(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] < 0 || next[0] >= ichMax) {
            return Float.NaN;
        }
        return PT.parseFloatChecked(str, ichMax, next, false);
    }

    public static float parseFloatNext(String str, int[] next) {
        int cch;
        int n = cch = str == null ? -1 : str.length();
        if (next[0] < 0 || next[0] >= cch) {
            return Float.NaN;
        }
        return PT.parseFloatChecked(str, cch, next, false);
    }

    public static float parseFloatStrict(String str) {
        int cch = str.length();
        if (cch == 0) {
            return Float.NaN;
        }
        return PT.parseFloatChecked(str, cch, new int[1], true);
    }

    public static float parseFloat(String str) {
        return PT.parseFloatNext(str, new int[1]);
    }

    public static int parseIntRadix(String s, int i) throws NumberFormatException {
        return Integer.parseInt(s, i);
    }

    public static String[] getTokens(String line) {
        return PT.getTokensAt(line, 0);
    }

    public static String parseToken(String str) {
        return PT.parseTokenNext(str, new int[1]);
    }

    public static String parseTrimmed(String str) {
        return PT.parseTrimmedRange(str, 0, str.length());
    }

    public static String parseTrimmedAt(String str, int ichStart) {
        return PT.parseTrimmedRange(str, ichStart, str.length());
    }

    public static String parseTrimmedRange(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax < cch) {
            cch = ichMax;
        }
        if (cch < ichStart) {
            return "";
        }
        return PT.parseTrimmedChecked(str, ichStart, cch);
    }

    public static String[] getTokensAt(String line, int ich) {
        if (line == null) {
            return null;
        }
        int cchLine = line.length();
        if (ich < 0 || ich > cchLine) {
            return null;
        }
        int tokenCount = PT.countTokens(line, ich);
        String[] tokens = new String[tokenCount];
        int[] next = new int[]{ich};
        int i = 0;
        while (i < tokenCount) {
            tokens[i] = PT.parseTokenChecked(line, cchLine, next);
            ++i;
        }
        return tokens;
    }

    public static int countTokens(String line, int ich) {
        int tokenCount = 0;
        if (line != null) {
            int ichMax = line.length();
            while (true) {
                if (ich < ichMax && PT.isWhiteSpace(line, ich)) {
                    ++ich;
                    continue;
                }
                if (ich == ichMax) break;
                ++tokenCount;
                while (++ich < ichMax && !PT.isWhiteSpace(line, ich)) {
                }
            }
        }
        return tokenCount;
    }

    public static String parseTokenNext(String str, int[] next) {
        int cch = str.length();
        if (next[0] < 0 || next[0] >= cch) {
            return null;
        }
        return PT.parseTokenChecked(str, cch, next);
    }

    public static String parseTokenRange(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] < 0 || next[0] >= ichMax) {
            return null;
        }
        return PT.parseTokenChecked(str, ichMax, next);
    }

    public static String parseTokenChecked(String str, int ichMax, int[] next) {
        int ich = next[0];
        while (ich < ichMax && PT.isWhiteSpace(str, ich)) {
            ++ich;
        }
        int ichNonWhite = ich;
        while (ich < ichMax && !PT.isWhiteSpace(str, ich)) {
            ++ich;
        }
        next[0] = ich;
        if (ichNonWhite == ich) {
            return null;
        }
        return str.substring(ichNonWhite, ich);
    }

    public static String parseTrimmedChecked(String str, int ich, int ichMax) {
        while (ich < ichMax && PT.isWhiteSpace(str, ich)) {
            ++ich;
        }
        int ichLast = ichMax - 1;
        while (ichLast >= ich && PT.isWhiteSpace(str, ichLast)) {
            --ichLast;
        }
        if (ichLast < ich) {
            return "";
        }
        return str.substring(ich, ichLast + 1);
    }

    public static double dVal(String s) throws NumberFormatException {
        return Double.valueOf(s);
    }

    public static float fVal(String s) throws NumberFormatException {
        return Float.parseFloat(s);
    }

    public static int parseIntRange(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] < 0 || next[0] >= ichMax) {
            return Integer.MIN_VALUE;
        }
        return PT.parseIntChecked(str, ichMax, next);
    }

    public static void parseFloatArrayData(String[] tokens, float[] data) {
        PT.parseFloatArrayDataN(tokens, data, data.length);
    }

    public static void parseFloatArrayDataN(String[] tokens, float[] data, int nData) {
        int i = nData;
        while (--i >= 0) {
            float f = data[i] = i >= tokens.length ? Float.NaN : PT.parseFloat(tokens[i]);
        }
    }

    public static String[] split(String text, String run) {
        if (text.length() == 0) {
            return new String[0];
        }
        int n = 1;
        int i = text.indexOf(run);
        int runLen = run.length();
        if (i < 0 || runLen == 0) {
            String[] lines = new String[]{text};
            return lines;
        }
        int len = text.length() - runLen;
        while (i >= 0 && i < len) {
            i = text.indexOf(run, i + runLen);
            ++n;
        }
        String[] lines = new String[n];
        i = 0;
        int ipt = 0;
        int pt = 0;
        while ((ipt = text.indexOf(run, i)) >= 0 && pt + 1 < n) {
            lines[pt++] = text.substring(i, ipt);
            i = ipt + runLen;
        }
        if (text.indexOf(run, len) != len) {
            len += runLen;
        }
        lines[pt] = text.substring(i, len);
        return lines;
    }

    public static String getQuotedStringAt(String line, int ipt0) {
        int[] next = new int[]{ipt0};
        return PT.getQuotedStringNext(line, next);
    }

    public static String getQuotedStringNext(String line, int[] next) {
        String value = line;
        int i = next[0];
        if (i < 0 || (i = value.indexOf("\"", i)) < 0) {
            return "";
        }
        next[0] = ++i;
        value = value.substring(i);
        i = -1;
        while (++i < value.length() && value.charAt(i) != '\"') {
            if (value.charAt(i) != '\\') continue;
            ++i;
        }
        next[0] = next[0] + (i + 1);
        return value.substring(0, i);
    }

    public static boolean isOneOf(String key, String semiList) {
        if (semiList.length() == 0) {
            return false;
        }
        if (semiList.charAt(0) != ';') {
            semiList = ";" + semiList + ";";
        }
        return key.indexOf(";") < 0 && semiList.indexOf(String.valueOf(';') + key + ';') >= 0;
    }

    public static String getQuotedAttribute(String info, String name) {
        int i = info.indexOf(String.valueOf(name) + "=");
        return i < 0 ? null : PT.getQuotedStringAt(info, i);
    }

    public static float approx(float f, float n) {
        return (float)Math.round(f * n) / n;
    }

    public static String simpleReplace(String str, String strFrom, String strTo) {
        if (str == null || strFrom.length() == 0 || str.indexOf(strFrom) < 0) {
            return str;
        }
        boolean isOnce = strTo.indexOf(strFrom) >= 0;
        do {
            str = str.replace(strFrom, strTo);
        } while (!isOnce && str.indexOf(strFrom) >= 0);
        return str;
    }

    public static String formatF(float value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        return PT.formatS(DF.formatDecimal(value, precision), width, 0, alignLeft, zeroPad);
    }

    public static String formatD(double value, int width, int precision, boolean alignLeft, boolean zeroPad, boolean allowOverflow) {
        return PT.formatS(DF.formatDecimal((float)value, -1 - precision), width, 0, alignLeft, zeroPad);
    }

    public static String formatS(String value, int width, int precision, boolean alignLeft, boolean zeroPad) {
        if (value == null) {
            return "";
        }
        int len = value.length();
        if (precision != Integer.MAX_VALUE && precision > 0 && precision < len) {
            value = value.substring(0, precision);
        } else if (precision < 0 && len + precision >= 0) {
            value = value.substring(len + precision + 1);
        }
        int padLength = width - value.length();
        if (padLength <= 0) {
            return value;
        }
        boolean isNeg = zeroPad && !alignLeft && value.charAt(0) == '-';
        char padChar = zeroPad ? (char)'0' : ' ';
        char padChar0 = isNeg ? (char)'-' : padChar;
        SB sb = new SB();
        if (alignLeft) {
            sb.append(value);
        }
        sb.appendC(padChar0);
        int i = padLength;
        while (--i > 0) {
            sb.appendC(padChar);
        }
        if (!alignLeft) {
            sb.append(isNeg ? String.valueOf(padChar) + value.substring(1) : value);
        }
        return sb.toString();
    }

    public static String replaceAllCharacters(String str, String strFrom, String strTo) {
        int i = strFrom.length();
        while (--i >= 0) {
            String chFrom = strFrom.substring(i, i + 1);
            str = PT.simpleReplace(str, chFrom, strTo);
        }
        return str;
    }

    public static String trim(String str, String chars) {
        if (chars.length() == 0) {
            return str.trim();
        }
        int len = str.length();
        int k = 0;
        while (k < len && chars.indexOf(str.charAt(k)) >= 0) {
            ++k;
        }
        int m = str.length() - 1;
        while (m > k && chars.indexOf(str.charAt(m)) >= 0) {
            --m;
        }
        return str.substring(k, m + 1);
    }

    public static String trimQuotes(String value) {
        return value != null && value.length() > 1 && value.startsWith("\"") && value.endsWith("\"") ? value.substring(1, value.length() - 1) : value;
    }

    public static String replaceAllCharacter(String str, String strFrom, char chTo) {
        if (str == null) {
            return null;
        }
        int i = strFrom.length();
        while (--i >= 0) {
            str = str.replace(strFrom.charAt(i), chTo);
        }
        return str;
    }

    public static String toJSON(String infoType, Object info) {
        SB sb = new SB();
        String sep = "";
        if (info == null) {
            return PT.packageJSON(infoType, null);
        }
        if (info instanceof Integer || info instanceof Float || info instanceof Double) {
            return PT.packageJSON(infoType, info.toString());
        }
        if (info instanceof String) {
            return PT.packageJSON(infoType, PT.fixString((String)info));
        }
        if (PT.isAS(info)) {
            sb.append("[");
            int imax = ((String[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(PT.fixString(((String[])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (PT.isAI(info)) {
            sb.append("[");
            int imax = ((int[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).appendI(((int[])info)[i]);
                sep = ",";
                ++i;
            }
            sb.append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (PT.isAF(info)) {
            sb.append("[");
            int imax = ((float[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).appendF(((float[])info)[i]);
                sep = ",";
                ++i;
            }
            sb.append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (PT.isAD(info)) {
            sb.append("[");
            int imax = ((double[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).appendD(((double[])info)[i]);
                sep = ",";
                ++i;
            }
            sb.append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (PT.isAP(info)) {
            sb.append("[");
            int imax = ((P3[])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep);
                PT.addJsonTuple(sb, ((P3[])info)[i]);
                sep = ",";
                ++i;
            }
            sb.append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (PT.isASS(info)) {
            sb.append("[");
            int imax = ((String[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(PT.toJSON(null, ((String[][])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (PT.isAII(info)) {
            sb.append("[");
            int imax = ((int[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(PT.toJSON(null, ((int[][])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (PT.isAFF(info)) {
            sb.append("[");
            int imax = ((float[][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(PT.toJSON(null, ((float[][])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (PT.isAFFF(info)) {
            sb.append("[");
            int imax = ((float[][][])info).length;
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(PT.toJSON(null, ((float[][][])info)[i]));
                sep = ",";
                ++i;
            }
            sb.append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (info instanceof List) {
            sb.append("[ ");
            int imax = ((List)info).size();
            int i = 0;
            while (i < imax) {
                sb.append(sep).append(PT.toJSON(null, ((List)info).get(i)));
                sep = ",";
                ++i;
            }
            sb.append(" ]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (info instanceof M4) {
            float[] x = new float[4];
            M4 m4 = (M4)info;
            sb.appendC('[');
            int i = 0;
            while (i < 4) {
                if (i > 0) {
                    sb.appendC(',');
                }
                m4.getRow(i, x);
                sb.append(PT.toJSON(null, x));
                ++i;
            }
            sb.appendC(']');
            return PT.packageJSONSb(infoType, sb);
        }
        if (info instanceof M3) {
            float[] x = new float[3];
            M3 m3 = (M3)info;
            sb.appendC('[');
            int i = 0;
            while (i < 3) {
                if (i > 0) {
                    sb.appendC(',');
                }
                m3.getRow(i, x);
                sb.append(PT.toJSON(null, x));
                ++i;
            }
            sb.appendC(']');
            return PT.packageJSONSb(infoType, sb);
        }
        if (info instanceof T3) {
            PT.addJsonTuple(sb, (T3)info);
            return PT.packageJSONSb(infoType, sb);
        }
        if (info instanceof A4) {
            sb.append("[").appendF(((A4)info).x).append(",").appendF(((A4)info).y).append(",").appendF(((A4)info).z).append(",").appendF((float)((double)((A4)info).angle * 180.0 / Math.PI)).append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (info instanceof P4) {
            sb.append("[").appendF(((P4)info).x).append(",").appendF(((P4)info).y).append(",").appendF(((P4)info).z).append(",").appendF(((P4)info).w).append("]");
            return PT.packageJSONSb(infoType, sb);
        }
        if (info instanceof Map) {
            sb.append("{ ");
            for (String key : ((Map)info).keySet()) {
                sb.append(sep).append(PT.packageJSON(key, PT.toJSON(null, ((Map)info).get(key))));
                sep = ",";
            }
            sb.append(" }");
            return PT.packageJSONSb(infoType, sb);
        }
        return PT.packageJSON(infoType, PT.fixString(info.toString()));
    }

    public static String packageJSONSb(String infoType, SB sb) {
        return PT.packageJSON(infoType, sb.toString());
    }

    public static String packageJSON(String infoType, String info) {
        if (infoType == null) {
            return info;
        }
        return "\"" + infoType + "\": " + info;
    }

    public static String fixString(String s) {
        if (s == null || s.indexOf("{\"") == 0) {
            return s;
        }
        s = PT.simpleReplace(s, "\"", "''");
        s = PT.simpleReplace(s, "\n", " | ");
        return "\"" + s + "\"";
    }

    public static void addJsonTuple(SB sb, T3 pt) {
        sb.append("[").appendF(pt.x).append(",").appendF(pt.y).append(",").appendF(pt.z).append("]");
    }

    public static boolean isAS(Object x) {
        return x instanceof String[];
    }

    public static boolean isASS(Object x) {
        return x instanceof String[][];
    }

    public static boolean isAP(Object x) {
        return x instanceof P3[];
    }

    public static boolean isAF(Object x) {
        return x instanceof float[];
    }

    public static boolean isAFloat(Object x) {
        return x instanceof Float[];
    }

    public static boolean isAD(Object x) {
        return x instanceof double[];
    }

    public static boolean isAB(Object x) {
        return x instanceof byte[];
    }

    public static boolean isAI(Object x) {
        return x instanceof int[];
    }

    public static boolean isAII(Object x) {
        return x instanceof int[][];
    }

    public static boolean isAFF(Object x) {
        return x instanceof float[][];
    }

    public static boolean isAFFF(Object x) {
        return x instanceof float[][][];
    }

    public static String escapeUrl(String url) {
        url = PT.simpleReplace(url, "\n", "");
        url = PT.simpleReplace(url, "%", "%25");
        url = PT.simpleReplace(url, "#", "%23");
        url = PT.simpleReplace(url, "[", "%5B");
        url = PT.simpleReplace(url, "]", "%5D");
        url = PT.simpleReplace(url, " ", "%20");
        return url;
    }
}

