/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.Map;
import javajs.util.DF;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.Parameters;
import jspecview.common.PeakPick;
import jspecview.common.ScaleData;

public class PeakData
extends MeasurementData {
    private static final long serialVersionUID = 1L;
    private double thresh;
    private double minY;
    private double maxY;
    private static final String[] HNMR_HEADER = new String[]{"peak", "shift/ppm", "intens", "shift/hz", "diff/hz", "2-diff", "3-diff"};

    public PeakData(Annotation.AType aType, JDXSpectrum jDXSpectrum) {
        super(aType, jDXSpectrum);
    }

    public double getThresh() {
        return this.thresh;
    }

    @Override
    public String[] getDataHeader() {
        String[] stringArray;
        if (this.spec.isHNMR()) {
            stringArray = HNMR_HEADER;
        } else {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "peak";
            stringArray2[1] = this.spec.getXUnits();
            stringArray = stringArray2;
            stringArray2[2] = this.spec.getYUnits();
        }
        return stringArray;
    }

    @Override
    public String[][] getMeasurementListArray(String string) {
        String[][] stringArray = new String[this.size()][];
        double[] dArray = new double[]{-1.0E100, 1.0E100, 1.0E100};
        int n = 0;
        int n2 = this.size();
        while (--n2 >= 0) {
            double[] dArray2 = this.spec.getPeakListArray((Measurement)this.get(n2), dArray, this.maxY);
            stringArray[n] = dArray2.length == 2 ? new String[]{"" + (n + 1), DF.formatDecimalDbl(dArray2[0], 2), DF.formatDecimalDbl(dArray2[1], 4)} : new String[]{"" + (n + 1), DF.formatDecimalDbl(dArray2[0], 4), DF.formatDecimalDbl(dArray2[1], 4), DF.formatDecimalDbl(dArray2[2], 2), dArray2[3] == 0.0 ? "" : DF.formatDecimalDbl(dArray2[3], 2), dArray2[4] == 0.0 ? "" : DF.formatDecimalDbl(dArray2[4], 2), dArray2[5] == 0.0 ? "" : DF.formatDecimalDbl(dArray2[5], 2)};
            ++n;
        }
        return stringArray;
    }

    @Override
    public double[][] getMeasurementListArrayReal(String string) {
        double[][] dArrayArray = new double[this.size()][];
        double[] dArray = new double[]{-1.0E100, 1.0E100, 1.0E100};
        int n = 0;
        int n2 = this.size();
        while (--n2 >= 0) {
            dArrayArray[n] = this.spec.getPeakListArray((Measurement)this.get(n2), dArray, this.maxY);
            ++n;
        }
        return dArrayArray;
    }

    @Override
    public void getInfo(Map<String, Object> map) {
        map.put("interpolation", this.myParams.peakListInterpolation);
        map.put("threshold", this.myParams.peakListThreshold);
        super.getInfo(map);
    }

    public void setPeakList(Parameters parameters, int n, ScaleData scaleData) {
        this.precision = n == Integer.MIN_VALUE ? this.spec.getDefaultUnitPrecision() : n;
        Coordinate[] coordinateArray = this.spec.getXYCoords();
        if (coordinateArray.length < 3) {
            return;
        }
        this.clear();
        if (parameters != null) {
            this.myParams.peakListInterpolation = parameters.peakListInterpolation;
            this.myParams.peakListThreshold = parameters.peakListThreshold;
        }
        boolean bl = this.myParams.peakListInterpolation.equals("parabolic");
        boolean bl2 = this.spec.isInverted();
        this.minY = scaleData.minYOnScale;
        this.maxY = scaleData.maxYOnScale;
        double d = scaleData.minXOnScale;
        double d2 = scaleData.maxXOnScale;
        this.thresh = this.myParams.peakListThreshold;
        if (Double.isNaN(this.thresh)) {
            this.thresh = this.myParams.peakListThreshold = (this.minY + this.maxY) / 2.0;
        }
        double d3 = 0.0;
        double[] dArray = new double[]{coordinateArray[0].getYVal(), d3 = coordinateArray[1].getYVal(), 0.0};
        int n2 = 0;
        if (bl2) {
            for (int i = 2; i < coordinateArray.length; ++i) {
                double d4 = coordinateArray[i].getYVal();
                dArray[i % 3] = d4;
                double d5 = d4;
                if (d3 < this.thresh && dArray[(i - 2) % 3] > d3 && d3 < d5) {
                    double d6;
                    double d7 = d6 = bl ? Coordinate.parabolicInterpolation(coordinateArray, i - 1) : coordinateArray[i - 1].getXVal();
                    if (d6 >= d || d6 <= d2) {
                        PeakPick peakPick = new PeakPick().setValue(d6, d5, this.spec, null, 0.0);
                        this.addLast(peakPick);
                        if (++n2 == 100) break;
                    }
                }
                d3 = d5;
            }
        } else {
            for (int i = 2; i < coordinateArray.length; ++i) {
                double d8 = coordinateArray[i].getYVal();
                dArray[i % 3] = d8;
                double d9 = d8;
                if (d3 > this.thresh && dArray[(i - 2) % 3] < d3 && d3 > d9) {
                    double d10;
                    double d11 = d10 = bl ? Coordinate.parabolicInterpolation(coordinateArray, i - 1) : coordinateArray[i - 1].getXVal();
                    if (d10 >= d && d10 <= d2) {
                        PeakPick peakPick = new PeakPick().setValue(d10, d9, this.spec, DF.formatDecimalDbl(d10, n), d10);
                        this.addLast(peakPick);
                        if (++n2 == 100) break;
                    }
                }
                d3 = d9;
            }
        }
    }
}

