/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.IOException;
import java.util.Arrays;
import javajs.util.List;
import javajs.util.OC;
import jspecview.api.JSVExporter;
import jspecview.common.Coordinate;
import jspecview.common.ExportType;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.export.JDXCompressor;
import jspecview.source.FileReader;
import jspecview.util.JSVTxt;

public class JDXExporter
implements JSVExporter {
    public static final String newLine = System.getProperty("line.separator");
    private OC out;
    private ExportType type;
    private JDXSpectrum spectrum;
    private JSViewer viewer;
    private static final double FACTOR_DIVISOR = 1000000.0;

    public String exportTheSpectrum(JSViewer viewer, ExportType type, OC out, JDXSpectrum spectrum, int startIndex, int endIndex, PanelData pd) throws IOException {
        this.out = out;
        this.type = type;
        this.spectrum = spectrum;
        this.viewer = viewer;
        this.toStringAux(startIndex, endIndex);
        out.closeChannel();
        return "OK " + out.getByteCount() + " bytes";
    }

    private void toStringAux(int startIndex, int endIndex) {
        Coordinate[] newXYCoords = this.spectrum.getXYCoords();
        String tabDataSet = "";
        String tmpDataClass = "XYDATA";
        if (this.spectrum.isHZtoPPM()) {
            Coordinate[] xyCoords = newXYCoords;
            newXYCoords = new Coordinate[xyCoords.length];
            int i = 0;
            while (i < xyCoords.length) {
                newXYCoords[i] = xyCoords[i].copy();
                ++i;
            }
            Coordinate.applyScale(newXYCoords, this.spectrum.getObservedFreq(), 1.0);
        }
        double xCompFactor = this.spectrum.getXFactor();
        boolean isIntegerX = JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, 1.0, true);
        if (!isIntegerX && !JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, xCompFactor, true)) {
            xCompFactor = 1.0;
        }
        double minY = Coordinate.getMinY(newXYCoords, startIndex, endIndex);
        double maxY = Coordinate.getMaxY(newXYCoords, startIndex, endIndex);
        double yCompFactor = this.spectrum.getYFactor();
        switch (this.type) {
            case XY: {
                yCompFactor = 1.0;
                tmpDataClass = this.spectrum.isContinuous() ? "XYDATA" : "XYPOINTS";
                break;
            }
            case PAC: {
                yCompFactor = 1.0;
                break;
            }
            default: {
                boolean isIntegerY = JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, 1.0, false);
                if (isIntegerY || JDXExporter.areIntegers(newXYCoords, startIndex, endIndex, yCompFactor, false)) break;
                yCompFactor = (maxY - minY) / 1000000.0;
            }
        }
        int step = 1;
        if (this.spectrum.isExportXAxisLeftToRight() != this.spectrum.getFirstX() < this.spectrum.getLastX()) {
            int t = startIndex;
            startIndex = endIndex;
            endIndex = t;
            step = -1;
        }
        switch (this.type) {
            case DIF: 
            case DIFDUP: {
                tabDataSet = JDXCompressor.compressDIF(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor, this.type == ExportType.DIFDUP);
                break;
            }
            case FIX: {
                tabDataSet = JDXCompressor.compressFIX(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case PAC: {
                tabDataSet = JDXCompressor.compressPAC(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case SQZ: {
                tabDataSet = JDXCompressor.compressSQZ(newXYCoords, startIndex, endIndex, step, xCompFactor, yCompFactor);
                break;
            }
            case XY: {
                tabDataSet = JDXCompressor.getXYList(newXYCoords, startIndex, endIndex, step);
                break;
            }
        }
        int index = Arrays.binarySearch(FileReader.VAR_LIST_TABLE[0], tmpDataClass);
        String varList = FileReader.VAR_LIST_TABLE[1][index];
        this.getHeaderString(tmpDataClass, minY, maxY, xCompFactor, yCompFactor, startIndex, endIndex);
        this.out.append("##" + tmpDataClass + "= " + varList + newLine);
        this.out.append(tabDataSet);
        this.out.append("##END=");
    }

    private void getHeaderString(String tmpDataClass, double minY, double maxY, double tmpXFactor, double tmpYFactor, int startIndex, int endIndex) {
        this.out.append("##TITLE= ").append(this.spectrum.getTitle()).append(newLine);
        this.out.append("##JCAMP-DX= 5.01").append(newLine);
        this.out.append("##DATA TYPE= ").append(this.spectrum.getDataType()).append(newLine);
        this.out.append("##DATA CLASS= ").append(tmpDataClass).append(newLine);
        this.out.append("##ORIGIN= ").append(this.spectrum.getOrigin()).append(newLine);
        this.out.append("##OWNER= ").append(this.spectrum.getOwner()).append(newLine);
        String d = this.spectrum.getDate();
        String longdate = "";
        String currentTime = this.viewer.apiPlatform.getDateFormat(false);
        longdate = this.spectrum.getLongDate().equals("") || d.length() != 8 ? String.valueOf(currentTime) + " $$ export date from JSpecView" : (d.length() == 8 ? String.valueOf(d.charAt(0) < '5' ? "20" : "19") + d + " " + this.spectrum.getTime() : this.spectrum.getLongDate());
        this.out.append("##LONGDATE= ").append(longdate).append(newLine);
        List<String[]> headerTable = this.spectrum.getHeaderTable();
        int i = 0;
        while (i < headerTable.size()) {
            String[] entry = (String[])headerTable.get(i);
            String label = entry[0];
            String dataSet = entry[1];
            String nl = dataSet.startsWith("<") && dataSet.contains("</") ? newLine : "";
            this.out.append(label).append("= ").append(nl).append(dataSet).append(newLine);
            ++i;
        }
        double observedFreq = this.spectrum.getObservedFreq();
        if (!this.spectrum.is1D()) {
            this.out.append("##NUM DIM= ").append("" + this.spectrum.numDim).append(newLine);
        }
        if (observedFreq != Double.MAX_VALUE) {
            this.out.append("##.OBSERVE FREQUENCY= ").append("" + observedFreq).append(newLine);
        }
        if (this.spectrum.observedNucl != "") {
            this.out.append("##.OBSERVE NUCLEUS= ").append(this.spectrum.observedNucl).append(newLine);
        }
        this.out.append("##XUNITS= ").append(this.spectrum.isHZtoPPM() ? "HZ" : this.spectrum.getXUnits()).append(newLine);
        this.out.append("##YUNITS= ").append(this.spectrum.getYUnits()).append(newLine);
        this.out.append("##XFACTOR= ").append(JSVTxt.fixExponentInt(tmpXFactor)).append(newLine);
        this.out.append("##YFACTOR= ").append(JSVTxt.fixExponentInt(tmpYFactor)).append(newLine);
        double f = this.spectrum.isHZtoPPM() ? observedFreq : 1.0;
        Coordinate[] xyCoords = this.spectrum.getXYCoords();
        this.out.append("##FIRSTX= ").append(JSVTxt.fixExponentInt(xyCoords[startIndex].getXVal() * f)).append(newLine);
        this.out.append("##FIRSTY= ").append(JSVTxt.fixExponentInt(xyCoords[startIndex].getYVal())).append(newLine);
        this.out.append("##LASTX= ").append(JSVTxt.fixExponentInt(xyCoords[endIndex].getXVal() * f)).append(newLine);
        this.out.append("##NPOINTS= ").append("" + (Math.abs(endIndex - startIndex) + 1)).append(newLine);
        this.out.append("##MINY= ").append(JSVTxt.fixExponentInt(minY)).append(newLine);
        this.out.append("##MAXY= ").append(JSVTxt.fixExponentInt(maxY)).append(newLine);
    }

    private static boolean areIntegers(Coordinate[] xyCoords, int startIndex, int endIndex, double factor, boolean isX) {
        int i = startIndex;
        while (i <= endIndex) {
            double x = (isX ? xyCoords[i].getXVal() : xyCoords[i].getYVal()) / factor;
            if (JSVTxt.isAlmostInteger(x)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

