/*
 * Decompiled with CFR 0.152.
 */
package javajs.awt;

import javajs.api.GenericColor;
import javajs.api.SwingController;
import javajs.awt.Dimension;
import javajs.util.CU;

public abstract class Component {
    protected boolean visible;
    protected boolean enabled;
    protected String text;
    protected String name;
    protected int width;
    protected int height;
    protected String id;
    protected SwingController controller;
    Object actionListener;
    private GenericColor bgcolor;
    protected int minWidth = 30;
    protected int minHeight = 30;
    protected int renderWidth;
    protected int renderHeight;

    protected Component(String type) {
        if (type == null) {
            return;
        }
        this.id = String.valueOf(type) + ("" + Math.random()).substring(3);
    }

    public abstract String toHTML();

    public void setBackground(GenericColor color) {
        this.bgcolor = color;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPreferredSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public void addActionListener(Object listener) {
        this.actionListener = listener;
    }

    public String getText() {
        return this.text;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setMinimumSize(Dimension d) {
        this.minWidth = d.width;
        this.minHeight = d.height;
    }

    public int getSubcomponentWidth() {
        return this.width;
    }

    public int getSubcomponentHeight() {
        return this.height;
    }

    protected String getCSSstyle(int defaultPercent) {
        int height;
        int width = this.renderWidth > 0 ? this.renderWidth : this.getSubcomponentWidth();
        int n = height = this.renderHeight > 0 ? this.renderHeight : this.getSubcomponentHeight();
        return String.valueOf(width > 0 ? "width:" + width + "px;" : (defaultPercent > 0 ? "width:" + defaultPercent + "%;" : "")) + (height > 0 ? "height:" + height + "px;" : (defaultPercent > 0 ? "height:" + defaultPercent + "%;" : "")) + (this.bgcolor == null ? "" : "background-color:" + CU.toCSSString(this.bgcolor) + ";");
    }

    public void repaint() {
    }
}

