/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import javajs.util.List;
import jspecview.common.JDXSpectrum;
import jspecview.source.JDXHeader;

public class JDXSource
extends JDXHeader {
    public static final int TYPE_VIEW = -2;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_SIMPLE = 0;
    public static final int TYPE_BLOCK = 1;
    public static final int TYPE_NTUPLE = 2;
    public int type = 0;
    public boolean isCompoundSource = false;
    private List<JDXSpectrum> jdxSpectra;
    private String errors = "";
    private String filePath;
    public int peakCount;
    public boolean isView;

    public void dispose() {
        this.headerTable = null;
        this.jdxSpectra = null;
    }

    public JDXSource(int n, String string) {
        this.type = n;
        this.setFilePath(string);
        this.headerTable = new List();
        this.jdxSpectra = new List();
        this.isCompoundSource = n != 0;
    }

    public JDXSpectrum getJDXSpectrum(int n) {
        return this.jdxSpectra.size() <= n ? null : (JDXSpectrum)this.jdxSpectra.get(n);
    }

    public void addJDXSpectrum(String string, JDXSpectrum jDXSpectrum, boolean bl) {
        if (string == null) {
            string = this.filePath;
        }
        jDXSpectrum.setFilePath(string);
        int n = this.jdxSpectra.size();
        if (n == 0 || !((JDXSpectrum)this.jdxSpectra.get(n - 1)).addSubSpectrum(jDXSpectrum, bl)) {
            this.jdxSpectra.addLast(jDXSpectrum);
        }
    }

    public int getNumberOfSpectra() {
        return this.jdxSpectra.size();
    }

    public List<JDXSpectrum> getSpectra() {
        return this.jdxSpectra;
    }

    public JDXSpectrum[] getSpectraAsArray() {
        return (JDXSpectrum[])(this.jdxSpectra == null ? null : this.jdxSpectra.toArray());
    }

    public String getErrorLog() {
        return this.errors;
    }

    public void setErrorLog(String string) {
        this.errors = string;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static JDXSource createView(List<JDXSpectrum> list) {
        JDXSource jDXSource = new JDXSource(-2, "view");
        jDXSource.isView = true;
        for (int i = 0; i < list.size(); ++i) {
            jDXSource.addJDXSpectrum(((JDXSpectrum)list.get(i)).getFilePath(), (JDXSpectrum)list.get(i), false);
        }
        return jDXSource;
    }

    public String[][] getHeaderRowDataAsArray(boolean bl, String[][] stringArray) {
        if (stringArray == null) {
            stringArray = new String[0][0];
        }
        String[][] stringArray2 = this.getHeaderRowDataAsArray(bl, stringArray.length);
        int n = stringArray.length;
        while (--n >= 0) {
            stringArray2[stringArray2.length - stringArray.length + n] = stringArray[n];
        }
        return stringArray2;
    }
}

