/*
 * Decompiled with CFR 0.152.
 */
package jspecview.tree;

import javajs.util.List;
import jspecview.api.JSVPanel;
import jspecview.api.JSVTree;
import jspecview.api.JSVTreeNode;
import jspecview.api.JSVTreePath;
import jspecview.api.ScriptInterface;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelNode;
import jspecview.source.JDXSource;
import jspecview.tree.SimpleTreeModel;
import jspecview.tree.SimpleTreeNode;
import jspecview.tree.SimpleTreePath;

public class SimpleTree
implements JSVTree {
    protected ScriptInterface si;
    private JSVTreeNode rootNode;
    private SimpleTreeModel spectraTreeModel;
    protected JSViewer viewer;
    private SimpleTreePath selectedPath;

    @Override
    public JSVTreeNode getRootNode() {
        return this.rootNode;
    }

    public SimpleTree(JSViewer jSViewer) {
        this.viewer = jSViewer;
        this.rootNode = new SimpleTreeNode("Spectra", null);
        this.spectraTreeModel = new SimpleTreeModel(this.rootNode);
    }

    public void valueChanged() {
        this.viewer.selectedTreeNode(this.getLastSelectedPathComponent());
    }

    private JSVTreeNode getLastSelectedPathComponent() {
        return (JSVTreeNode)(this.selectedPath == null ? null : this.selectedPath.getLastPathComponent());
    }

    @Override
    public void setSelectedPanel(ScriptInterface scriptInterface, JSVPanel jSVPanel) {
        if (jSVPanel != null) {
            JSVTreeNode jSVTreeNode = PanelNode.findNode((JSVPanel)jSVPanel, this.viewer.panelNodes).treeNode;
            this.setSelectionPath(this.viewer.spectraTree.newTreePath(jSVTreeNode.getPath()));
        }
    }

    private void setSelectionPath(JSVTreePath jSVTreePath) {
        this.selectedPath = (SimpleTreePath)jSVTreePath;
        this.valueChanged();
    }

    @Override
    public JSVTreeNode createTree(ScriptInterface scriptInterface, JDXSource jDXSource, JSVPanel[] jSVPanelArray) {
        SimpleTree simpleTree = (SimpleTree)this.viewer.spectraTree;
        JSVTreeNode jSVTreeNode = simpleTree.getRootNode();
        List<PanelNode> list = this.viewer.panelNodes;
        String string = JSVFileManager.getName(jDXSource.getFilePath());
        PanelNode panelNode = new PanelNode(null, string, jDXSource, null);
        SimpleTreeNode simpleTreeNode = new SimpleTreeNode(string, panelNode);
        panelNode.setTreeNode(simpleTreeNode);
        simpleTree.spectraTreeModel.insertNodeInto(simpleTreeNode, jSVTreeNode, jSVTreeNode.getChildCount());
        int n = scriptInterface.siGetFileCount() + 1;
        scriptInterface.siSetFileCount(n);
        for (int i = 0; i < jSVPanelArray.length; ++i) {
            JSVPanel jSVPanel = jSVPanelArray[i];
            String string2 = n + "." + (i + 1);
            panelNode = scriptInterface.siGetNewPanelNode(string2, string, jDXSource, jSVPanel);
            SimpleTreeNode simpleTreeNode2 = new SimpleTreeNode(panelNode.toString(), panelNode);
            panelNode.setTreeNode(simpleTreeNode2);
            list.addLast(panelNode);
            simpleTree.spectraTreeModel.insertNodeInto(simpleTreeNode2, simpleTreeNode, simpleTreeNode.getChildCount());
        }
        this.viewer.selectFrameNode(jSVPanelArray[0]);
        return simpleTreeNode;
    }

    @Override
    public void setPath(JSVTreePath jSVTreePath) {
        this.setSelectionPath(jSVTreePath);
    }

    @Override
    public JSVTreePath newTreePath(Object[] objectArray) {
        return new SimpleTreePath(objectArray);
    }

    @Override
    public void deleteNodes(List<JSVTreeNode> list) {
        for (int i = 0; i < list.size(); ++i) {
            this.spectraTreeModel.removeNodeFromParent((JSVTreeNode)list.get(i));
        }
    }
}

