/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.J2SIgnoreImport;
import org.jmol.util.DefaultLogger;
import org.jmol.util.LoggerInterface;

@J2SIgnoreImport(value={Runtime.class})
public final class Logger {
    private static LoggerInterface _logger = new DefaultLogger();
    public static final int LEVEL_FATAL = 1;
    public static final int LEVEL_ERROR = 2;
    public static final int LEVEL_WARN = 3;
    public static final int LEVEL_INFO = 4;
    public static final int LEVEL_DEBUG = 5;
    public static final int LEVEL_DEBUGHIGH = 6;
    public static final int LEVEL_MAX = 7;
    private static final boolean[] _activeLevels = new boolean[7];
    private static boolean _logLevel = false;
    public static boolean debugging;
    public static boolean debuggingHigh;
    static Map<String, Integer> htTiming;

    static {
        Logger._activeLevels[6] = Logger.getProperty("debugHigh", false);
        Logger._activeLevels[5] = Logger.getProperty("debug", false);
        Logger._activeLevels[4] = Logger.getProperty("info", true);
        Logger._activeLevels[3] = Logger.getProperty("warn", true);
        Logger._activeLevels[2] = Logger.getProperty("error", true);
        Logger._activeLevels[1] = Logger.getProperty("fatal", true);
        _logLevel = Logger.getProperty("logLevel", false);
        debugging = _logger != null && (_activeLevels[5] || _activeLevels[6]);
        debuggingHigh = debugging && _activeLevels[6];
        htTiming = new Hashtable<String, Integer>();
    }

    private Logger() {
    }

    private static boolean getProperty(String level, boolean defaultValue) {
        try {
            String property = System.getProperty("jmol.logger." + level, null);
            if (property != null) {
                return property.equalsIgnoreCase("true");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    public static void setLogger(LoggerInterface logger) {
        _logger = logger;
        debugging = Logger.isActiveLevel(5) || Logger.isActiveLevel(6);
        debuggingHigh = debugging && _activeLevels[6];
    }

    public static boolean isActiveLevel(int level) {
        return _logger != null && level >= 0 && level < 7 && _activeLevels[level];
    }

    public static void setActiveLevel(int level, boolean active) {
        if (level < 0) {
            level = 0;
        }
        if (level >= 7) {
            level = 6;
        }
        Logger._activeLevels[level] = active;
        debugging = Logger.isActiveLevel(5) || Logger.isActiveLevel(6);
        debuggingHigh = debugging && _activeLevels[6];
    }

    public static void setLogLevel(int level) {
        int i = 7;
        while (--i >= 0) {
            Logger.setActiveLevel(i, i <= level);
        }
    }

    public static String getLevel(int level) {
        switch (level) {
            case 6: {
                return "DEBUGHIGH";
            }
            case 5: {
                return "DEBUG";
            }
            case 4: {
                return "INFO";
            }
            case 3: {
                return "WARN";
            }
            case 2: {
                return "ERROR";
            }
            case 1: {
                return "FATAL";
            }
        }
        return "????";
    }

    public static boolean logLevel() {
        return _logLevel;
    }

    public static void doLogLevel(boolean log) {
        _logLevel = log;
    }

    public static void debug(String txt) {
        if (!debugging) {
            return;
        }
        try {
            _logger.debug(txt);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void info(String txt) {
        try {
            if (Logger.isActiveLevel(4)) {
                _logger.info(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warn(String txt) {
        try {
            if (Logger.isActiveLevel(3)) {
                _logger.warn(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void warnEx(String txt, Throwable e) {
        try {
            if (Logger.isActiveLevel(3)) {
                _logger.warnEx(txt, e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void error(String txt) {
        try {
            if (Logger.isActiveLevel(2)) {
                _logger.error(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void errorEx(String txt, Throwable e) {
        try {
            if (Logger.isActiveLevel(2)) {
                _logger.errorEx(txt, e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static int getLogLevel() {
        int i = 7;
        while (--i >= 0) {
            if (!Logger.isActiveLevel(i)) continue;
            return i;
        }
        return 0;
    }

    public static void fatal(String txt) {
        try {
            if (Logger.isActiveLevel(1)) {
                _logger.fatal(txt);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void fatalEx(String txt, Throwable e) {
        try {
            if (Logger.isActiveLevel(1)) {
                _logger.fatalEx(txt, e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void startTimer(String msg) {
        if (msg != null) {
            htTiming.put(msg, (int)System.currentTimeMillis());
        }
    }

    public static String getTimerMsg(String msg, long time) {
        if (time == 0L) {
            time = Logger.getTimeFrom(msg);
        }
        return "Time for " + msg + ": " + time + " ms";
    }

    private static int getTimeFrom(String msg) {
        Integer t;
        return msg == null || (t = htTiming.get(msg)) == null ? -1 : (int)(System.currentTimeMillis() - (long)t.intValue());
    }

    public static int checkTimer(String msg, boolean andReset) {
        int time = Logger.getTimeFrom(msg);
        if (time >= 0 && !msg.startsWith("(")) {
            Logger.info(Logger.getTimerMsg(msg, time));
        }
        if (andReset) {
            Logger.startTimer(msg);
        }
        return time;
    }

    public static void checkMemory() {
        long bTotal = 0L;
        long bFree = 0L;
        long bMax = 0L;
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        bTotal = runtime.totalMemory();
        bFree = runtime.freeMemory();
        bMax = runtime.maxMemory();
        Logger.info("Memory: Total-Free=" + (bTotal - bFree) + "; Total=" + bTotal + "; Free=" + bFree + "; Max=" + bMax);
    }
}

