/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.script;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javajs.util.A4;
import javajs.util.AU;
import javajs.util.CU;
import javajs.util.DF;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P4;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.BondSet;
import org.jmol.script.SV;
import org.jmol.script.ScriptEvaluator;
import org.jmol.script.ScriptException;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.viewer.Viewer;

public class ScriptMathProcessor {
    private boolean chk;
    private boolean wasSyntaxCheck;
    private boolean logMessages;
    private ScriptEvaluator eval;
    private Viewer viewer;
    private T[] oStack = new T[8];
    private SV[] xStack = new SV[8];
    private char[] ifStack = new char[8];
    private int ifPt = -1;
    public int oPt = -1;
    private int xPt = -1;
    private int parenCount;
    private int squareCount;
    private int braceCount;
    public boolean wasX;
    private int incrementX;
    private boolean isArrayItem;
    private boolean asVector;
    public boolean asBitSet;
    private int ptid = 0;
    private int ptx = Integer.MAX_VALUE;
    private boolean skipping;
    private boolean haveSpaceBeforeSquare;
    private int equalCount;
    private static final String qMods = " w:0 x:1 y:2 z:3 normal:4 eulerzxz:5 eulerzyz:6 vector:-1 theta:-2 axisx:-3 axisy:-4 axisz:-5 axisangle:-6 matrix:-9";

    ScriptMathProcessor(ScriptEvaluator scriptEvaluator, boolean bl, boolean bl2, boolean bl3) {
        this.eval = scriptEvaluator;
        this.viewer = scriptEvaluator.viewer;
        this.logMessages = scriptEvaluator.logMessages;
        this.chk = this.wasSyntaxCheck = scriptEvaluator.chk;
        this.isArrayItem = bl;
        this.asVector = bl2 || bl;
        this.asBitSet = bl3;
        this.wasX = bl;
        if (this.logMessages) {
            Logger.debug("initialize RPN");
        }
    }

    SV getResult(boolean bl) throws ScriptException {
        boolean bl2 = true;
        while (bl2 && this.oPt >= 0) {
            bl2 = this.operate();
        }
        if (bl2) {
            if (this.asVector) {
                List<SV> list = new List<SV>();
                for (int i = 0; i <= this.xPt; ++i) {
                    list.addLast(SV.selectItemVar(this.xStack[i]));
                }
                return SV.newV(135198, list);
            }
            if (this.xPt == 0) {
                SV sV = this.xStack[0];
                if (sV.tok == 10 || sV.tok == 7 || sV.tok == 4 || sV.tok == 11 || sV.tok == 12) {
                    sV = SV.selectItemVar(sV);
                }
                if (this.asBitSet && sV.tok == 7) {
                    sV = SV.newV(10, SV.unEscapeBitSetArray((List)sV.value, false));
                }
                return sV;
            }
        }
        if (!(bl || this.xPt < 0 && this.oPt < 0)) {
            this.eval.error(22);
        }
        return null;
    }

    private void putX(SV sV) {
        if (this.skipping) {
            return;
        }
        if (++this.xPt == this.xStack.length) {
            this.xStack = (SV[])AU.doubleLength(this.xStack);
        }
        if (this.logMessages) {
            Logger.debug("\nputX: " + sV);
        }
        this.xStack[this.xPt] = sV;
        this.ptx = ++this.ptid;
    }

    private void putOp(T t) {
        if (++this.oPt >= this.oStack.length) {
            this.oStack = (T[])AU.doubleLength(this.oStack);
        }
        this.oStack[this.oPt] = t;
        ++this.ptid;
    }

    private void putIf(char c) {
        if (++this.ifPt >= this.ifStack.length) {
            this.ifStack = (char[])AU.doubleLength(this.ifStack);
        }
        this.ifStack[this.ifPt] = c;
    }

    public boolean addXVar(SV sV) {
        this.putX(sV);
        this.wasX = true;
        return true;
    }

    public boolean addXObj(Object object) {
        SV sV = SV.getVariable(object);
        if (sV == null) {
            return false;
        }
        this.putX(sV);
        this.wasX = true;
        return true;
    }

    public boolean addXStr(String string) {
        this.putX(SV.newS(string));
        this.wasX = true;
        return true;
    }

    public boolean addXBool(boolean bl) {
        this.putX(SV.getBoolean(bl));
        this.wasX = true;
        return true;
    }

    public boolean addXInt(int n) {
        this.putX(SV.newI(n));
        this.wasX = true;
        return true;
    }

    public boolean addXList(List<?> list) {
        this.putX(SV.getVariableList(list));
        this.wasX = true;
        return true;
    }

    public boolean addXMap(Map<String, ?> map) {
        this.putX(SV.getVariableMap(map));
        this.wasX = true;
        return true;
    }

    public boolean addXM3(M3 m3) {
        this.putX(SV.newV(11, m3));
        this.wasX = true;
        return true;
    }

    public boolean addXM4(M4 m4) {
        this.putX(SV.newV(12, m4));
        this.wasX = true;
        return true;
    }

    public boolean addXFloat(float f) {
        if (Float.isNaN(f)) {
            return this.addXStr("NaN");
        }
        this.putX(SV.newV(3, Float.valueOf(f)));
        this.wasX = true;
        return true;
    }

    public boolean addXBs(BS bS) {
        this.putX(SV.newV(10, bS));
        this.wasX = true;
        return true;
    }

    public boolean addXPt(P3 p3) {
        this.putX(SV.newV(8, p3));
        this.wasX = true;
        return true;
    }

    public boolean addXPt4(P4 p4) {
        this.putX(SV.newV(9, p4));
        this.wasX = true;
        return true;
    }

    public boolean addXNum(SV sV) throws ScriptException {
        if (this.wasX) {
            switch (sV.tok) {
                case 2: {
                    if (sV.intValue >= 0) break;
                    this.addOp(T.tokenMinus);
                    sV = SV.newI(-sV.intValue);
                    break;
                }
                case 3: {
                    float f = ((Float)sV.value).floatValue();
                    if (!(f < 0.0f) && (f != 0.0f || 1.0f / f != Float.NEGATIVE_INFINITY)) break;
                    this.addOp(T.tokenMinus);
                    sV = SV.newV(3, Float.valueOf(-f));
                }
            }
        }
        this.putX(sV);
        this.wasX = true;
        return true;
    }

    public boolean addXAV(SV[] sVArray) {
        this.putX(SV.getVariableAV(sVArray));
        this.wasX = true;
        return true;
    }

    public boolean addXAD(double[] dArray) {
        this.putX(SV.getVariableAD(dArray));
        this.wasX = true;
        return true;
    }

    public boolean addXAS(String[] stringArray) {
        this.putX(SV.getVariableAS(stringArray));
        this.wasX = true;
        return true;
    }

    public boolean addXAI(int[] nArray) {
        this.putX(SV.getVariableAI(nArray));
        this.wasX = true;
        return true;
    }

    public boolean addXAII(int[][] nArray) {
        this.putX(SV.getVariableAII(nArray));
        this.wasX = true;
        return true;
    }

    public boolean addXAF(float[] fArray) {
        this.putX(SV.getVariableAF(fArray));
        this.wasX = true;
        return true;
    }

    public boolean addXAFF(float[][] fArray) {
        this.putX(SV.getVariableAFF(fArray));
        this.wasX = true;
        return true;
    }

    private static boolean isOpFunc(T t) {
        return T.tokAttr(t.tok, 0x8100000) && t != T.tokenArraySquare || t.tok == 0x101000D1 && T.tokAttr(t.intValue, 0x8100000);
    }

    public boolean addOp(T t) throws ScriptException {
        return this.addOpAllowMath(t, true);
    }

    boolean addOpAllowMath(T t, boolean bl) throws ScriptException {
        boolean bl2;
        boolean bl3;
        if (this.logMessages) {
            Logger.debug("addOp entry\naddOp: " + t);
        }
        int n = this.oPt >= 0 ? this.oStack[this.oPt].tok : 0;
        boolean bl4 = this.skipping = this.ifPt >= 0 && (this.ifStack[this.ifPt] == 'F' || this.ifStack[this.ifPt] == 'X');
        if (this.skipping) {
            switch (t.tok) {
                case 0x10100010: {
                    this.putOp(t);
                    return true;
                }
                case 0x10100022: {
                    if (n != 0x10100022 || this.ifStack[this.ifPt] == 'X') {
                        return true;
                    }
                    this.ifStack[this.ifPt] = 84;
                    this.wasX = false;
                    this.skipping = false;
                    return true;
                }
                case 0x10100011: {
                    if (n == 0x10100010) {
                        --this.oPt;
                        return true;
                    }
                    if (n != 0x10100022) {
                        this.putOp(t);
                        return true;
                    }
                    this.wasX = true;
                    --this.ifPt;
                    this.oPt -= 2;
                    this.skipping = false;
                    return true;
                }
            }
            return true;
        }
        T t2 = null;
        boolean bl5 = false;
        boolean bl6 = bl3 = t.tok == 0x101000D1;
        if (bl3 && !this.wasX) {
            return false;
        }
        boolean bl7 = bl2 = bl && ScriptMathProcessor.isOpFunc(t);
        if (this.oPt >= 1 && t.tok != 0x10100010 && n == 135266319) {
            n = this.oStack[--this.oPt].tok;
        }
        boolean bl8 = this.oPt >= 1 && n == 0x10100010;
        switch (t.tok) {
            case 1073742195: {
                this.haveSpaceBeforeSquare = true;
                return true;
            }
            case 0x10100030: {
                if (this.wasX) break;
                return false;
            }
            case 32: 
            case 64: 
            case 96: 
            case 128: 
            case 160: 
            case 192: 
            case 480: {
                int n2;
                int n3 = n2 = this.oPt < 0 ? 0 : n;
                if (!this.wasX || n2 != 0x101000D1 && n2 != 1678770178 && n2 != 0x44100001) {
                    return false;
                }
                this.oStack[this.oPt].intValue |= t.tok;
                return true;
            }
            case 0x10100040: {
                bl5 = true;
                if (this.wasX && !this.haveSpaceBeforeSquare) break;
                ++this.squareCount;
                t = t2 = T.tokenArraySquare;
                this.haveSpaceBeforeSquare = false;
                break;
            }
            case 0x10100041: {
                break;
            }
            case 0x101000C1: 
            case 269484226: {
                int n4 = this.incrementX = t.tok == 269484226 ? 1 : -1;
                if (this.ptid != this.ptx) break;
                if (this.chk) {
                    return true;
                }
                SV sV = this.xStack[this.xPt];
                this.xStack[this.xPt] = SV.newS("").setv(sV, false);
                return sV.increment(this.incrementX);
            }
            case 0x101000A0: {
                if (this.wasX) break;
                this.addXInt(0);
                t = SV.newV(0x101000C0, "-");
                break;
            }
            case 0x10100011: {
                if (this.wasX || this.oPt < 1 || n != 0x10100010 || ScriptMathProcessor.isOpFunc(this.oStack[this.oPt - 1])) break;
                return false;
            }
            case 0x10100010: 
            case 0x10100070: {
                bl5 = true;
            }
            default: {
                if (bl2) {
                    if (!bl3 && this.wasX && !bl8) {
                        return false;
                    }
                    t2 = t;
                    bl5 = true;
                    break;
                }
                if (this.wasX != bl5 || n == 0x101000D1) break;
                return false;
            }
        }
        while (!(this.oPt < 0 || n == 0x10100022 || bl5 && (n != 0x101000D1 || t.tok != 0x101000D1 && t.tok != 0x10100040) || T.getPrecedence(n) < T.getPrecedence(t.tok))) {
            if (this.logMessages) {
                Logger.debug("\noperating, oPt=" + this.oPt + " isLeftOp=" + bl5 + " oStack[oPt]=" + T.nameOf(n) + "        prec=" + T.getPrecedence(n) + " pending op=\"" + T.nameOf(t.tok) + "\" prec=" + T.getPrecedence(t.tok));
                this.dumpStacks("operating");
            }
            if (t.tok == 0x10100011 && n == 0x10100010) {
                if (this.xPt < 0) break;
                this.xStack[this.xPt] = SV.selectItemVar(this.xStack[this.xPt]);
                break;
            }
            if (t.tok == 0x10100041 && n == 135266306) break;
            if (t.tok == 0x10100041 && n == 0x10100040) {
                if (this.isArrayItem && this.squareCount == 1 && this.equalCount == 0) {
                    this.addXVar(SV.newT(T.tokenArraySelector));
                    break;
                }
                if (this.doBitsetSelect()) break;
                return false;
            }
            if (!this.operate()) {
                return false;
            }
            n = this.oPt >= 0 ? this.oStack[this.oPt].tok : 0;
        }
        if (t2 != null) {
            this.addXVar(SV.newV(269484436, t2));
        }
        switch (t.tok) {
            case 0x10100010: {
                ++this.parenCount;
                this.wasX = false;
                break;
            }
            case 806354977: {
                boolean bl9 = this.getX().asBoolean();
                if (n == 0x10100022) {
                    --this.ifPt;
                } else {
                    this.putOp(T.tokenColon);
                }
                this.putIf(bl9 ? (char)'T' : 'F');
                this.skipping = !bl9;
                this.wasX = false;
                return true;
            }
            case 0x10100022: {
                if (n != 0x10100022) {
                    return false;
                }
                if (this.ifPt < 0) {
                    return false;
                }
                this.ifStack[this.ifPt] = 88;
                this.wasX = false;
                this.skipping = true;
                return true;
            }
            case 0x10100011: {
                this.wasX = true;
                if (this.parenCount-- <= 0) {
                    return false;
                }
                if (n == 0x10100022) {
                    --this.ifPt;
                    --this.oPt;
                }
                --this.oPt;
                if (this.oPt < 0) {
                    return true;
                }
                if (ScriptMathProcessor.isOpFunc(this.oStack[this.oPt]) && !this.evaluateFunction(0)) {
                    return false;
                }
                this.skipping = this.ifPt >= 0 && this.ifStack[this.ifPt] == 'X';
                return true;
            }
            case 0x10100030: {
                this.wasX = false;
                return true;
            }
            case 0x10100040: {
                ++this.squareCount;
                this.wasX = false;
                break;
            }
            case 0x10100041: {
                this.wasX = true;
                if (this.squareCount-- <= 0 || this.oPt < 0) {
                    return false;
                }
                if (this.oStack[this.oPt].tok == 135266306) {
                    return this.evaluateFunction(0x10100040);
                }
                --this.oPt;
                return true;
            }
            case 0x101000D1: {
                this.wasX = !bl || !T.tokAttr(t.intValue, 0x8100000);
                break;
            }
            case 0x10000A: {
                ++this.braceCount;
                this.wasX = false;
                break;
            }
            case 0x10000E: {
                if (this.braceCount-- <= 0) {
                    return false;
                }
                this.wasX = false;
                break;
            }
            case 0x10100050: 
            case 0x10100060: {
                if (!this.wasSyntaxCheck && this.xPt < 0) {
                    return false;
                }
                if (!this.wasSyntaxCheck && this.xStack[this.xPt].tok != 10 && this.xStack[this.xPt].tok != 7) {
                    boolean bl10 = this.getX().asBoolean();
                    this.addXVar(SV.getBoolean(bl10));
                    if (bl10 == (t.tok == 0x10100050)) {
                        this.chk = true;
                        t = t.tok == 0x10100050 ? T.tokenOrTRUE : T.tokenAndFALSE;
                    }
                }
                this.wasX = false;
                break;
            }
            case 269484436: {
                if (this.squareCount == 0) {
                    ++this.equalCount;
                }
                this.wasX = false;
                break;
            }
            default: {
                this.wasX = false;
            }
        }
        this.putOp(t);
        if (t.tok == 0x101000D1 && (t.intValue & 0xFFFFFE1F) == 135368713 && t.intValue != 135368713) {
            return this.evaluateFunction(0);
        }
        return true;
    }

    private boolean doBitsetSelect() {
        if (this.xPt < 0 || this.xPt == 0 && !this.isArrayItem) {
            return false;
        }
        SV sV = this.xStack[this.xPt--];
        SV sV2 = this.xStack[this.xPt];
        if (sV2.tok == 7 && sV.tok == 4 && sV2.intValue != Integer.MAX_VALUE) {
            sV2 = (SV)SV.selectItemTok(sV2, Integer.MIN_VALUE);
        }
        if (sV2.tok == 6) {
            SV sV3 = sV2.mapValue(SV.sValue(sV));
            this.xStack[this.xPt] = sV3 == null ? SV.newS("") : sV3;
            return true;
        }
        int n = sV.asInt();
        switch (sV2.tok) {
            default: {
                sV2 = SV.newS(SV.sValue(sV2));
            }
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
        }
        this.xStack[this.xPt] = (SV)SV.selectItemTok(sV2, n);
        return true;
    }

    void dumpStacks(String string) {
        int n;
        Logger.debug("\n\n------------------\nRPN stacks: " + string + "\n");
        for (n = 0; n <= this.xPt; ++n) {
            Logger.debug("x[" + n + "]: " + this.xStack[n]);
        }
        Logger.debug("\n");
        for (n = 0; n <= this.oPt; ++n) {
            Logger.debug("o[" + n + "]: " + this.oStack[n] + " prec=" + T.getPrecedence(this.oStack[n].tok));
        }
        Logger.debug(" ifStack = " + new String(this.ifStack).substring(0, this.ifPt + 1));
    }

    public SV getX() throws ScriptException {
        if (this.xPt < 0) {
            this.eval.error(13);
        }
        SV sV = SV.selectItemVar(this.xStack[this.xPt]);
        this.xStack[this.xPt--] = null;
        return sV;
    }

    private boolean evaluateFunction(int n) throws ScriptException {
        T t = this.oStack[this.oPt--];
        if (n == 0) {
            n = t.tok == 0x101000D1 ? t.intValue & 0xFFFFFE1F : t.tok;
        }
        int n2 = T.getMaxMathParams(n);
        int n3 = 0;
        int n4 = this.xPt;
        while (n4 >= 0 && this.xStack[n4--].value != t) {
            ++n3;
        }
        if (n2 > 0 && n3 > n2) {
            return false;
        }
        SV[] sVArray = new SV[n3];
        int n5 = n3;
        while (--n5 >= 0) {
            sVArray[n5] = this.getX();
        }
        --this.xPt;
        return !this.chk ? this.eval.getExtension().evaluate(this, t, sVArray, n) : (t.tok == 0x101000D1 ? true : this.addXBool(true));
    }

    private boolean operate() throws ScriptException {
        T t = this.oStack[this.oPt--];
        if (this.logMessages) {
            this.dumpStacks("operate: " + t);
        }
        if (this.isArrayItem && this.squareCount == 0 && this.equalCount == 1 && this.oPt < 0 && t.tok == 269484436) {
            return true;
        }
        SV sV = this.getX();
        if (sV == T.tokenArraySelector) {
            return false;
        }
        if (t.tok == 0x101000C1 || t.tok == 269484226) {
            if (!this.chk && !sV.increment(this.incrementX)) {
                return false;
            }
            this.wasX = true;
            this.putX(sV);
            return true;
        }
        if (t.tok == 0x10100070) {
            if (this.chk) {
                return this.addXBool(true);
            }
            switch (sV.tok) {
                case 9: {
                    return this.addXPt4(Quaternion.newP4((P4)sV.value).inv().toPoint4f());
                }
                case 11: {
                    M3 m3 = M3.newM((M3)sV.value);
                    m3.invert();
                    return this.addXM3(m3);
                }
                case 12: {
                    M4 m4 = M4.newM((M4)sV.value);
                    m4.invert();
                    return this.addXM4(m4);
                }
                case 10: {
                    return this.addXBs(BSUtil.copyInvert(SV.bsSelectVar(sV), sV.value instanceof BondSet ? this.viewer.getBondCount() : this.viewer.getAtomCount()));
                }
            }
            return this.addXBool(!sV.asBoolean());
        }
        int n = t.intValue & 0xFFFFFE1F;
        if (t.tok == 0x101000D1) {
            switch (n) {
                case 0x40000000: {
                    return this.getAllProperties(sV, (String)t.value);
                }
                case 1141899267: 
                case 1141899270: 
                case 1276117012: {
                    if (n == 1141899267 && sV.value instanceof BondSet) break;
                    return this.addXInt(SV.sizeOf(sV));
                }
                case 1141899272: {
                    return this.addXStr(ScriptMathProcessor.typeOf(sV));
                }
                case 0x44100011: {
                    if (sV.tok != 6) {
                        return this.addXStr("");
                    }
                    Set set = ((Map)sV.value).keySet();
                    Object[] objectArray = set.toArray(new String[set.size()]);
                    Arrays.sort(objectArray);
                    return this.addXAS((String[])objectArray);
                }
                case 0x44100004: {
                    String string;
                    switch (sV.tok) {
                        case 11: 
                        case 12: {
                            string = SV.sValue(sV);
                            string = PT.simpleReplace(string.substring(1, string.length() - 1), "],[", "]\n[");
                            break;
                        }
                        case 4: {
                            string = (String)sV.value;
                            break;
                        }
                        default: {
                            string = SV.sValue(sV);
                        }
                    }
                    string = PT.simpleReplace(string, "\n\r", "\n").replace('\r', '\n');
                    return this.addXAS(PT.split(string, "\n"));
                }
                case 1766856708: {
                    switch (sV.tok) {
                        case 4: 
                        case 7: {
                            String string = SV.sValue(sV);
                            P3 p3 = new P3();
                            return this.addXPt(CU.colorPtFromString(string, p3));
                        }
                        case 2: 
                        case 3: {
                            return this.addXPt(this.viewer.getColorPointForPropertyValue(SV.fValue(sV)));
                        }
                        case 8: {
                            return this.addXStr(Escape.escapeColor(CU.colorPtToFFRGB((P3)sV.value)));
                        }
                    }
                    break;
                }
                case 1679429641: {
                    return this.chk ? this.addXStr("x") : this.getBoundBox(sV);
                }
            }
            if (this.chk) {
                return this.addXStr(SV.sValue(sV));
            }
            if (sV.tok == 4) {
                Object object = SV.unescapePointOrBitsetAsVariable(SV.sValue(sV));
                if (!(object instanceof SV)) {
                    return false;
                }
                sV = (SV)object;
            }
            if (t.tok == sV.tok) {
                sV = this.getX();
            }
            return this.getPointOrBitsetOperation(t, sV);
        }
        SV sV2 = this.getX();
        if (this.chk) {
            if (t == T.tokenAndFALSE || t == T.tokenOrTRUE) {
                this.chk = false;
            }
            return this.addXVar(SV.newT(sV2));
        }
        return this.binaryOp(t, sV2, sV);
    }

    public boolean binaryOp(T t, SV sV, SV sV2) throws ScriptException {
        switch (t.tok) {
            case 0x10100060: 
            case 0x10100080: {
                switch (sV.tok) {
                    case 10: {
                        BS bS = SV.bsSelectVar(sV);
                        switch (sV2.tok) {
                            case 10: {
                                bS = BSUtil.copy(bS);
                                bS.and(SV.bsSelectVar(sV2));
                                return this.addXBs(bS);
                            }
                            case 2: {
                                int n = sV2.asInt();
                                return this.addXBool(n < 0 ? false : bS.get(n));
                            }
                        }
                    }
                }
                return this.addXBool(sV.asBoolean() && sV2.asBoolean());
            }
            case 0x10100050: {
                switch (sV.tok) {
                    case 10: {
                        BS bS = BSUtil.copy(SV.bsSelectVar(sV));
                        switch (sV2.tok) {
                            case 10: {
                                bS.or(SV.bsSelectVar(sV2));
                                return this.addXBs(bS);
                            }
                            case 2: {
                                int n = sV2.asInt();
                                if (n < 0) break;
                                bS.set(n);
                                return this.addXBs(bS);
                            }
                            case 7: {
                                List list = (List)sV2.value;
                                int n = list.size();
                                while (--n >= 0) {
                                    int n2 = ((SV)list.get(n)).asInt();
                                    if (n2 < 0) continue;
                                    bS.set(n2);
                                }
                                return this.addXBs(bS);
                            }
                        }
                        break;
                    }
                    case 7: {
                        return this.addXVar(SV.concatList(sV, sV2, false));
                    }
                }
                return this.addXBool(sV.asBoolean() || sV2.asBoolean());
            }
            case 0x10100051: {
                if (sV.tok == 10 && sV2.tok == 10) {
                    BS bS = BSUtil.copy(SV.bsSelectVar(sV));
                    bS.xor(SV.bsSelectVar(sV2));
                    return this.addXBs(bS);
                }
                boolean bl = sV.asBoolean();
                boolean bl2 = sV2.asBoolean();
                return this.addXBool(bl && !bl2 || bl2 && !bl);
            }
            case 269484114: {
                if (sV.tok != 10 || sV2.tok != 10) {
                    return false;
                }
                return this.addXBs(BSUtil.toggleInPlace(BSUtil.copy(SV.bsSelectVar(sV)), SV.bsSelectVar(sV2)));
            }
            case 269484434: {
                return this.addXBool(sV.asFloat() <= sV2.asFloat());
            }
            case 0x10100191: {
                return this.addXBool(sV.asFloat() >= sV2.asFloat());
            }
            case 0x10100190: {
                return this.addXBool(sV.asFloat() > sV2.asFloat());
            }
            case 269484435: {
                return this.addXBool(sV.asFloat() < sV2.asFloat());
            }
            case 269484436: {
                return this.addXBool(SV.areEqual(sV, sV2));
            }
            case 269484438: {
                return this.addXBool(!SV.areEqual(sV, sV2));
            }
            case 0x101000A1: {
                switch (sV.tok) {
                    default: {
                        return this.addXFloat(sV.asFloat() + sV2.asFloat());
                    }
                    case 7: {
                        return this.addXVar(SV.concatList(sV, sV2, true));
                    }
                    case 2: {
                        switch (sV2.tok) {
                            case 4: {
                                String string = SV.sValue(sV2).trim();
                                if (string.indexOf(".") >= 0 || string.indexOf("+") > 0 || string.lastIndexOf("-") > 0) break;
                                return this.addXInt(sV.intValue + sV2.asInt());
                            }
                            case 3: {
                                return this.addXFloat((float)sV.intValue + sV2.asFloat());
                            }
                        }
                        return this.addXInt(sV.intValue + sV2.asInt());
                    }
                    case 4: {
                        return this.addXVar(SV.newS(SV.sValue(sV) + SV.sValue(sV2)));
                    }
                    case 9: {
                        Quaternion quaternion = Quaternion.newP4((P4)sV.value);
                        switch (sV2.tok) {
                            default: {
                                return this.addXPt4(quaternion.add(sV2.asFloat()).toPoint4f());
                            }
                            case 9: 
                        }
                        return this.addXPt4(quaternion.mulQ(Quaternion.newP4((P4)sV2.value)).toPoint4f());
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV.value);
                        switch (sV2.tok) {
                            case 8: {
                                p3.add((P3)sV2.value);
                                return this.addXPt(p3);
                            }
                            case 9: {
                                P4 p4 = (P4)sV2.value;
                                p3.add(P3.new3(p4.x, p4.y, p4.z));
                                return this.addXPt(p3);
                            }
                        }
                        float f = sV2.asFloat();
                        return this.addXPt(P3.new3(p3.x + f, p3.y + f, p3.z + f));
                    }
                    case 11: 
                }
                switch (sV2.tok) {
                    default: {
                        return this.addXFloat(sV.asFloat() + sV2.asFloat());
                    }
                    case 11: {
                        M3 m3 = M3.newM((M3)sV.value);
                        m3.add((M3)sV2.value);
                        return this.addXM3(m3);
                    }
                    case 8: 
                }
                return this.addXM4(ScriptMathProcessor.getMatrix4f((M3)sV.value, (P3)sV2.value));
            }
            case 0x101000A0: {
                String string;
                if (sV.tok == 2 && (sV2.tok == 4 ? (string = SV.sValue(sV2).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0 : sV2.tok != 3)) {
                    return this.addXInt(sV.intValue - sV2.asInt());
                }
                if (sV.tok == 4 && sV2.tok == 2 && (string = SV.sValue(sV).trim()).indexOf(".") < 0 && string.indexOf("+") <= 0 && string.lastIndexOf("-") <= 0) {
                    return this.addXInt(sV.asInt() - sV2.intValue);
                }
                switch (sV.tok) {
                    default: {
                        return this.addXFloat(sV.asFloat() - sV2.asFloat());
                    }
                    case 6: {
                        Hashtable hashtable = new Hashtable((Map)sV.value);
                        hashtable.remove(SV.sValue(sV2));
                        return this.addXVar(SV.getVariableMap(hashtable));
                    }
                    case 11: {
                        switch (sV2.tok) {
                            default: {
                                return this.addXFloat(sV.asFloat() - sV2.asFloat());
                            }
                            case 11: 
                        }
                        M3 m3 = M3.newM((M3)sV.value);
                        m3.sub((M3)sV2.value);
                        return this.addXM3(m3);
                    }
                    case 12: {
                        switch (sV2.tok) {
                            default: {
                                return this.addXFloat(sV.asFloat() - sV2.asFloat());
                            }
                            case 12: 
                        }
                        M4 m4 = M4.newM((M4)sV.value);
                        m4.sub((M4)sV2.value);
                        return this.addXM4(m4);
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV.value);
                        switch (sV2.tok) {
                            default: {
                                float f = sV2.asFloat();
                                return this.addXPt(P3.new3(p3.x - f, p3.y - f, p3.z - f));
                            }
                            case 8: {
                                p3.sub((P3)sV2.value);
                                return this.addXPt(p3);
                            }
                            case 9: 
                        }
                        P4 p4 = (P4)sV2.value;
                        p3.sub(P3.new3(p4.x, p4.y, p4.z));
                        return this.addXPt(p3);
                    }
                    case 9: 
                }
                Quaternion quaternion = Quaternion.newP4((P4)sV.value);
                switch (sV2.tok) {
                    default: {
                        return this.addXPt4(quaternion.add(-sV2.asFloat()).toPoint4f());
                    }
                    case 9: 
                }
                Quaternion quaternion2 = Quaternion.newP4((P4)sV2.value);
                return this.addXPt4(quaternion2.mulQ(quaternion.inv()).toPoint4f());
            }
            case 0x101000C0: {
                switch (sV2.tok) {
                    default: {
                        return this.addXFloat(-sV2.asFloat());
                    }
                    case 2: {
                        return this.addXInt(-sV2.asInt());
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV2.value);
                        p3.scale(-1.0f);
                        return this.addXPt(p3);
                    }
                    case 9: {
                        P4 p4 = P4.newPt((P4)sV2.value);
                        p4.scale(-1.0f);
                        return this.addXPt4(p4);
                    }
                    case 11: {
                        M3 m3 = M3.newM((M3)sV2.value);
                        m3.transpose();
                        return this.addXM3(m3);
                    }
                    case 12: {
                        M4 m4 = M4.newM((M4)sV2.value);
                        m4.transpose();
                        return this.addXM4(m4);
                    }
                    case 10: 
                }
                return this.addXBs(BSUtil.copyInvert(SV.bsSelectVar(sV2), sV2.value instanceof BondSet ? this.viewer.getBondCount() : this.viewer.getAtomCount()));
            }
            case 1276117508: {
                if (sV.tok == 8 && sV2.tok == 8) {
                    P3 p3 = (P3)sV.value;
                    P3 p32 = (P3)sV2.value;
                    return this.addXPt(P3.new3(p3.x * p32.x, p3.y * p32.y, p3.z * p32.z));
                }
            }
            case 0x101000B1: {
                P3 p3;
                if (sV.tok == 2 && sV2.tok != 3) {
                    return this.addXInt(sV.intValue * sV2.asInt());
                }
                P3 p33 = sV.tok == 11 ? this.ptValue(sV2, false) : (p3 = sV2.tok == 11 ? this.ptValue(sV, false) : null);
                P4 p4 = sV.tok == 12 ? this.planeValue(sV2) : (sV2.tok == 12 ? this.planeValue(sV) : null);
                switch (sV2.tok) {
                    case 11: {
                        if (p3 != null) {
                            M3 m3 = M3.newM((M3)sV2.value);
                            m3.transpose();
                            m3.transform(p3);
                            if (sV.tok == 7) {
                                return this.addXVar(SV.getVariableAF(new float[]{p3.x, p3.y, p3.z}));
                            }
                            return this.addXPt(p3);
                        }
                        if (p4 == null) break;
                        return this.addXPt4(Quaternion.newP4(p4).mulQ(Quaternion.newM((M3)sV2.value)).toPoint4f());
                    }
                    case 12: {
                        if (p4 == null) break;
                        M4 m4 = M4.newM((M4)sV2.value);
                        m4.transpose();
                        m4.transform4(p4);
                        if (sV.tok == 7) {
                            return this.addXVar(SV.getVariableAF(new float[]{p4.x, p4.y, p4.z, p4.w}));
                        }
                        return this.addXPt4(p4);
                    }
                }
                switch (sV.tok) {
                    default: {
                        return this.addXFloat(sV.asFloat() * sV2.asFloat());
                    }
                    case 11: {
                        M3 m3 = (M3)sV.value;
                        if (p3 != null) {
                            m3.transform(p3);
                            if (sV2.tok == 7) {
                                return this.addXVar(SV.getVariableAF(new float[]{p3.x, p3.y, p3.z}));
                            }
                            return this.addXPt(p3);
                        }
                        switch (sV2.tok) {
                            case 11: {
                                M3 m32 = M3.newM((M3)sV2.value);
                                m32.mul2(m3, m32);
                                return this.addXM3(m32);
                            }
                            case 9: {
                                return this.addXM3(Quaternion.newM(m3).mulQ(Quaternion.newP4((P4)sV2.value)).getMatrix());
                            }
                        }
                        float f = sV2.asFloat();
                        A4 a4 = new A4();
                        a4.setM(m3);
                        a4.angle *= f;
                        M3 m33 = new M3();
                        m33.setAA(a4);
                        return this.addXM3(m33);
                    }
                    case 12: {
                        M4 m4 = (M4)sV.value;
                        if (p3 != null) {
                            m4.transform(p3);
                            if (sV2.tok == 7) {
                                return this.addXVar(SV.getVariableAF(new float[]{p3.x, p3.y, p3.z}));
                            }
                            return this.addXPt(p3);
                        }
                        if (p4 != null) {
                            m4.transform4(p4);
                            if (sV2.tok == 7) {
                                return this.addXVar(SV.getVariableAF(new float[]{p4.x, p4.y, p4.z, p4.w}));
                            }
                            return this.addXPt4(p4);
                        }
                        switch (sV2.tok) {
                            case 12: {
                                M4 m42 = M4.newM((M4)sV2.value);
                                m42.mul2(m4, m42);
                                return this.addXM4(m42);
                            }
                        }
                        return this.addXStr("NaN");
                    }
                    case 8: {
                        p3 = P3.newP((P3)sV.value);
                        switch (sV2.tok) {
                            case 8: {
                                P3 p34 = (P3)sV2.value;
                                return this.addXFloat(p3.x * p34.x + p3.y * p34.y + p3.z * p34.z);
                            }
                        }
                        float f = sV2.asFloat();
                        return this.addXPt(P3.new3(p3.x * f, p3.y * f, p3.z * f));
                    }
                    case 9: 
                }
                switch (sV2.tok) {
                    case 9: {
                        return this.addXPt4(Quaternion.newP4((P4)sV.value).mulQ(Quaternion.newP4((P4)sV2.value)).toPoint4f());
                    }
                }
                return this.addXPt4(Quaternion.newP4((P4)sV.value).mul(sV2.asFloat()).toPoint4f());
            }
            case 269484210: {
                String string = null;
                int n = sV2.asInt();
                switch (sV.tok) {
                    default: {
                        if (n == 0) {
                            return this.addXInt(0);
                        }
                        return this.addXInt(sV.asInt() % n);
                    }
                    case 3: {
                        float f = sV.asFloat();
                        if (n == 0) {
                            return this.addXInt(Math.round(f));
                        }
                        string = DF.formatDecimal(f, n);
                        return this.addXStr(string);
                    }
                    case 4: {
                        string = (String)sV.value;
                        if (n == 0) {
                            return this.addXStr(PT.trim(string, "\n\t "));
                        }
                        if (n == 9999) {
                            return this.addXStr(string.toUpperCase());
                        }
                        if (n == -9999) {
                            return this.addXStr(string.toLowerCase());
                        }
                        if (n > 0) {
                            return this.addXStr(PT.formatS(string, n, n, false, false));
                        }
                        return this.addXStr(PT.formatS(string, n, n - 1, true, false));
                    }
                    case 7: {
                        String[] stringArray = SV.listValue(sV);
                        for (int i = 0; i < stringArray.length; ++i) {
                            stringArray[i] = n == 0 ? stringArray[i].trim() : (n > 0 ? PT.formatS(stringArray[i], n, n, true, false) : PT.formatS(string, -n, n, false, false));
                        }
                        return this.addXAS(stringArray);
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV.value);
                        this.viewer.toUnitCell(p3, P3.new3(n, n, n));
                        return this.addXPt(p3);
                    }
                    case 9: {
                        P4 p4 = (P4)sV.value;
                        if (sV2.tok == 8) {
                            return this.addXPt(Quaternion.newP4(p4).transformPt((P3)sV2.value));
                        }
                        if (sV2.tok == 9) {
                            P4 p42 = P4.newPt((P4)sV2.value);
                            Quaternion.newP4(p4).getThetaDirected(p42);
                            return this.addXPt4(p42);
                        }
                        if (n == 0 && sV2.tok == 4) {
                            string = " " + sV2.value.toString().trim().toLowerCase() + ":";
                            int n3 = qMods.indexOf(string);
                            n = n3 >= 0 ? PT.parseInt(qMods.substring(n3 + string.length())) : -99;
                        }
                        switch (n) {
                            case 0: {
                                return this.addXFloat(p4.w);
                            }
                            case 1: {
                                return this.addXFloat(p4.x);
                            }
                            case 2: {
                                return this.addXFloat(p4.y);
                            }
                            case 3: {
                                return this.addXFloat(p4.z);
                            }
                        }
                        Quaternion quaternion = Quaternion.newP4(p4);
                        switch (n) {
                            case 4: {
                                return this.addXPt(P3.newP(quaternion.getNormal()));
                            }
                            case 5: {
                                return this.addXAF(quaternion.getEulerZXZ());
                            }
                            case 6: {
                                return this.addXAF(quaternion.getEulerZYZ());
                            }
                            case -1: {
                                return this.addXPt(P3.newP(quaternion.getVector(-1)));
                            }
                            case -2: {
                                return this.addXFloat(quaternion.getTheta());
                            }
                            case -3: {
                                return this.addXPt(P3.newP(quaternion.getVector(0)));
                            }
                            case -4: {
                                return this.addXPt(P3.newP(quaternion.getVector(1)));
                            }
                            case -5: {
                                return this.addXPt(P3.newP(quaternion.getVector(2)));
                            }
                            case -6: {
                                A4 a4 = quaternion.toAxisAngle4f();
                                return this.addXPt4(P4.new4(a4.x, a4.y, a4.z, (float)((double)(a4.angle * 180.0f) / Math.PI)));
                            }
                            case -9: {
                                return this.addXM3(quaternion.getMatrix());
                            }
                        }
                        return this.addXStr("NaN");
                    }
                    case 12: {
                        M4 m4 = (M4)sV.value;
                        switch (n) {
                            case 1: {
                                M3 m3 = new M3();
                                m4.getRotationScale(m3);
                                return this.addXM3(m3);
                            }
                            case 2: {
                                V3 v3 = new V3();
                                m4.get(v3);
                                return this.addXPt(P3.newP(v3));
                            }
                        }
                        return false;
                    }
                    case 10: 
                }
                return this.addXBs(SV.bsSelectRange(sV, n));
            }
            case 0x101000B0: {
                if (sV.tok == 2 && sV2.tok == 2 && sV2.intValue != 0) {
                    return this.addXInt(sV.intValue / sV2.intValue);
                }
                float f = sV2.asFloat();
                switch (sV.tok) {
                    default: {
                        float f2 = sV.asFloat();
                        return this.addXFloat(f2 / f);
                    }
                    case 8: {
                        P3 p3 = P3.newP((P3)sV.value);
                        if (f == 0.0f) {
                            return this.addXPt(P3.new3(Float.NaN, Float.NaN, Float.NaN));
                        }
                        return this.addXPt(P3.new3(p3.x / f, p3.y / f, p3.z / f));
                    }
                    case 9: 
                }
                if (sV2.tok == 9) {
                    return this.addXPt4(Quaternion.newP4((P4)sV.value).div(Quaternion.newP4((P4)sV2.value)).toPoint4f());
                }
                if (f == 0.0f) {
                    return this.addXPt4(P4.new4(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                }
                return this.addXPt4(Quaternion.newP4((P4)sV.value).mul(1.0f / f).toPoint4f());
            }
            case 269484211: {
                float f = sV2.asFloat();
                switch (sV.tok) {
                    default: {
                        return this.addXInt(f == 0.0f ? 0 : (int)Math.floor(sV.asFloat() / sV2.asFloat()));
                    }
                    case 9: 
                }
                if (f == 0.0f) {
                    return this.addXPt4(P4.new4(Float.NaN, Float.NaN, Float.NaN, Float.NaN));
                }
                if (sV2.tok == 9) {
                    return this.addXPt4(Quaternion.newP4((P4)sV.value).divLeft(Quaternion.newP4((P4)sV2.value)).toPoint4f());
                }
                return this.addXPt4(Quaternion.newP4((P4)sV.value).mul(1.0f / f).toPoint4f());
            }
            case 269484227: {
                float f = (float)Math.pow(sV.asFloat(), sV2.asFloat());
                return sV.tok == 2 && sV2.tok == 2 ? this.addXInt((int)f) : this.addXFloat(f);
            }
        }
        return true;
    }

    public P3 ptValue(SV sV, boolean bl) throws ScriptException {
        if (this.chk) {
            return new P3();
        }
        switch (sV.tok) {
            case 8: {
                return (P3)sV.value;
            }
            case 10: {
                return (P3)this.eval.getBitsetProperty(SV.bsSelectVar(sV), 1146095626, null, null, sV.value, null, false, Integer.MAX_VALUE, false);
            }
            case 4: {
                Object object = Escape.uP(SV.sValue(sV));
                if (!(object instanceof P3)) break;
                return (P3)object;
            }
            case 7: {
                Object object = Escape.uP("{" + SV.sValue(sV) + "}");
                if (!(object instanceof P3)) break;
                return (P3)object;
            }
        }
        if (!bl) {
            return null;
        }
        float f = SV.fValue(sV);
        return P3.new3(f, f, f);
    }

    public P4 planeValue(T t) {
        if (this.chk) {
            return new P4();
        }
        switch (t.tok) {
            case 9: {
                return (P4)t.value;
            }
            case 4: 
            case 7: {
                Object object = Escape.uP(SV.sValue(t));
                return object instanceof P4 ? (P4)object : null;
            }
        }
        return null;
    }

    private static String typeOf(SV sV) {
        int n = sV == null ? 0 : sV.tok;
        switch (n) {
            case 0x10000C: 
            case 0x10000D: {
                return "boolean";
            }
            case 10: {
                return sV.value instanceof BondSet ? "bondset" : "bitset";
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                return T.astrType[n];
            }
        }
        return "?";
    }

    private boolean getAllProperties(SV sV, String string) throws ScriptException {
        List<T> list;
        if (sV.tok != 10) {
            return false;
        }
        if (this.chk) {
            return this.addXStr("");
        }
        BS bS = SV.bsSelectVar(sV);
        int n = bS.cardinality();
        if (n == 0 || (list = T.getAtomPropertiesLike(string.substring(0, string.length() - 1))) == null) {
            return this.addXStr("");
        }
        Hashtable<String, SV> hashtable = new Hashtable<String, SV>();
        int n2 = n == 1 ? bS.nextSetBit(0) : Integer.MAX_VALUE;
        int n3 = list.size();
        block3: while (--n3 >= 0) {
            T t = (T)list.get(n3);
            int n4 = t.tok;
            switch (n4) {
                case 1095761925: 
                case 1095766024: {
                    continue block3;
                }
            }
            if (n2 == Integer.MAX_VALUE) {
                n4 |= 0x1E0;
            }
            hashtable.put((String)t.value, SV.getVariable(this.eval.getBitsetProperty(bS, n4, null, null, null, null, false, n2, true)));
        }
        return this.addXMap(hashtable);
    }

    public static M4 getMatrix4f(M3 m3, T3 t3) {
        return M4.newMV(m3, t3 == null ? new V3() : V3.newV(t3));
    }

    private boolean getBoundBox(SV sV) {
        if (sV.tok != 10) {
            return false;
        }
        if (this.chk) {
            return this.addXStr("");
        }
        BoxInfo boxInfo = this.viewer.getBoxInfo(SV.bsSelectVar(sV), 1.0f);
        P3[] p3Array = boxInfo.getBoundBoxPoints(true);
        List<P3> list = new List<P3>();
        for (int i = 0; i < 4; ++i) {
            list.addLast(p3Array[i]);
        }
        return this.addXList(list);
    }

    private boolean getPointOrBitsetOperation(T t, SV sV) throws ScriptException {
        switch (sV.tok) {
            case 7: {
                switch (t.intValue) {
                    case 32: 
                    case 64: 
                    case 96: 
                    case 128: 
                    case 160: 
                    case 192: {
                        return this.addXObj(this.eval.getExtension().getMinMax(sV.getList(), t.intValue));
                    }
                    case 1141899269: 
                    case 1276117011: {
                        return this.addXVar(sV.sortOrReverse(t.intValue == 1141899269 ? Integer.MIN_VALUE : 1));
                    }
                }
                SV[] sVArray = new SV[sV.getList().size()];
                for (int i = 0; i < sVArray.length; ++i) {
                    Object object = SV.unescapePointOrBitsetAsVariable(sV.getList().get(i));
                    if (!(object instanceof SV) || !this.getPointOrBitsetOperation(t, (SV)object)) {
                        return false;
                    }
                    sVArray[i] = this.xStack[this.xPt--];
                }
                return this.addXAV(sVArray);
            }
            case 8: {
                switch (t.intValue) {
                    case 1112541185: 
                    case 1112541205: {
                        return this.addXFloat(((P3)sV.value).x);
                    }
                    case 1112541186: 
                    case 1112541206: {
                        return this.addXFloat(((P3)sV.value).y);
                    }
                    case 1112541187: 
                    case 1112541207: {
                        return this.addXFloat(((P3)sV.value).z);
                    }
                    case 1146095626: {
                        P3 p3 = P3.newP((P3)sV.value);
                        this.viewer.toCartesian(p3, true);
                        return this.addXPt(p3);
                    }
                    case 1112541188: 
                    case 1112541189: 
                    case 1112541190: 
                    case 1146095627: {
                        P3 p3 = P3.newP((P3)sV.value);
                        this.viewer.toFractional(p3, true);
                        return t.intValue == 1146095627 ? this.addXPt(p3) : this.addXFloat(t.intValue == 1112541188 ? p3.x : (t.intValue == 1112541189 ? p3.y : p3.z));
                    }
                    case 1112541191: 
                    case 1112541192: 
                    case 1112541193: 
                    case 1146095629: {
                        P3 p3 = P3.newP((P3)sV.value);
                        this.viewer.toFractional(p3, false);
                        return t.intValue == 1146095627 ? this.addXPt(p3) : this.addXFloat(t.intValue == 1112541191 ? p3.x : (t.intValue == 1112541192 ? p3.y : p3.z));
                    }
                    case 1112539153: 
                    case 1112539154: 
                    case 1112539155: 
                    case 1146093582: {
                        P3 p3 = P3.newP((P3)sV.value);
                        this.viewer.toUnitCell(p3, null);
                        this.viewer.toFractional(p3, false);
                        return t.intValue == 1146093582 ? this.addXPt(p3) : this.addXFloat(t.intValue == 1112539153 ? p3.x : (t.intValue == 1112539154 ? p3.y : p3.z));
                    }
                }
                break;
            }
            case 9: {
                switch (t.intValue) {
                    case 1112541185: 
                    case 1112541205: {
                        return this.addXFloat(((P4)sV.value).x);
                    }
                    case 1112541186: 
                    case 1112541206: {
                        return this.addXFloat(((P4)sV.value).y);
                    }
                    case 1112541187: 
                    case 1112541207: {
                        return this.addXFloat(((P4)sV.value).z);
                    }
                    case 0x44100010: {
                        return this.addXFloat(((P4)sV.value).w);
                    }
                }
                break;
            }
            case 10: {
                if (t.intValue == 1678770178 && sV.value instanceof BondSet) {
                    return this.addXVar(sV);
                }
                BS bS = SV.bsSelectVar(sV);
                if (bS.cardinality() == 1 && (t.intValue & 0x1E0) == 0) {
                    t.intValue |= 0x20;
                }
                Object object = this.eval.getBitsetProperty(bS, t.intValue, null, null, sV.value, t.value, false, sV.index, true);
                if (t.intValue != 1678770178) {
                    return this.addXObj(object);
                }
                return this.addXVar(SV.newV(10, new BondSet((BS)object, this.viewer.getAtomIndices(bS))));
            }
        }
        return false;
    }

    public SV evalOp(T t) throws ScriptException {
        if (!this.addOp(t) || !this.operate()) {
            return null;
        }
        return this.xStack[this.xPt--];
    }
}

