/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.modelset.Bond;
import org.jmol.util.JmolNode;

public abstract class JmolEdge {
    public static final int BOND_STEREO_MASK = 1024;
    public static final int BOND_STEREO_NEAR = 1025;
    public static final int BOND_STEREO_FAR = 1041;
    public static final int BOND_AROMATIC_MASK = 512;
    public static final int BOND_AROMATIC_SINGLE = 513;
    public static final int BOND_AROMATIC_DOUBLE = 514;
    public static final int BOND_AROMATIC = 515;
    public static final int BOND_SULFUR_MASK = 256;
    public static final int BOND_PARTIAL_MASK = 224;
    public static final int BOND_PARTIAL01 = 33;
    public static final int BOND_PARTIAL12 = 66;
    public static final int BOND_PARTIAL23 = 97;
    public static final int BOND_PARTIAL32 = 100;
    public static final int BOND_COVALENT_MASK = 1023;
    public static final int BOND_COVALENT_SINGLE = 1;
    public static final int BOND_COVALENT_DOUBLE = 2;
    public static final int BOND_COVALENT_TRIPLE = 3;
    public static final int BOND_COVALENT_QUADRUPLE = 4;
    public static final int BOND_ORDER_UNSPECIFIED = 17;
    public static final int BOND_ORDER_ANY = 65535;
    public static final int BOND_ORDER_NULL = 131071;
    public static final int BOND_STRUT = 32768;
    public static final int BOND_AS_SINGLE = 65536;
    public static final int BOND_NEW = 131072;
    public static final int BOND_HBOND_SHIFT = 11;
    public static final int BOND_HYDROGEN_MASK = 30720;
    public static final int BOND_H_REGULAR = 2048;
    public static final int BOND_H_CALC_MASK = 28672;
    public static final int BOND_H_CALC = 4096;
    public static final int BOND_H_PLUS_2 = 6144;
    public static final int BOND_H_PLUS_3 = 8192;
    public static final int BOND_H_PLUS_4 = 10240;
    public static final int BOND_H_PLUS_5 = 12288;
    public static final int BOND_H_MINUS_3 = 14336;
    public static final int BOND_H_MINUS_4 = 16384;
    public static final int BOND_H_NUCLEOTIDE = 18432;
    public static final int[] argbsHbondType = new int[]{-38476, -256, -256, -1, -65281, -65536, -23296, -16711681, -16711936, -32640};
    public int index = -1;
    public int order;
    public static final int FLAG_AROMATIC_DOUBLE = 16;
    public static final int FLAG_AROMATIC_DEFINED = 8;
    public static final int FLAG_AROMATIC_STRICT = 4;
    public static final int FLAG_IGNORE_STEREOCHEMISTRY = 2;
    public static final int FLAG_NO_AROMATIC = 1;

    public abstract int getAtomIndex1();

    public abstract int getAtomIndex2();

    public abstract int getCovalentOrder();

    public abstract JmolNode getOtherAtomNode(JmolNode var1);

    public abstract boolean isCovalent();

    public abstract boolean isHydrogen();

    public static int getArgbHbondType(int n) {
        int n2 = (n & 0x7800) >> 11;
        return argbsHbondType[n2];
    }

    public static final String getBondOrderNumberFromOrder(int n) {
        if ((n &= 0xFFFDFFFF) == 131071 || n == 65535) {
            return "0";
        }
        if (Bond.isOrderH(n) || (n & 0x100) != 0) {
            return EnumBondOrder.SINGLE.number;
        }
        if ((n & 0xE0) != 0) {
            return (n >> 5) + "." + (n & 0x1F);
        }
        return EnumBondOrder.getNumberFromCode(n);
    }

    public static final String getCmlBondOrder(int n) {
        String string = JmolEdge.getBondOrderNameFromOrder(n);
        switch (string.charAt(0)) {
            case 'd': 
            case 's': 
            case 't': {
                return "" + string.toUpperCase().charAt(0);
            }
            case 'a': {
                if (string.indexOf("Double") >= 0) {
                    return "D";
                }
                if (string.indexOf("Single") >= 0) {
                    return "S";
                }
                return "aromatic";
            }
            case 'p': {
                if (string.indexOf(" ") >= 0) {
                    return string.substring(string.indexOf(" ") + 1);
                }
                return "partial12";
            }
        }
        return null;
    }

    public static final String getBondOrderNameFromOrder(int n) {
        switch (n &= 0xFFFDFFFF) {
            case 65535: 
            case 131071: {
                return "";
            }
            case 32768: {
                return EnumBondOrder.STRUT.name;
            }
            case 1: {
                return EnumBondOrder.SINGLE.name;
            }
            case 2: {
                return EnumBondOrder.DOUBLE.name;
            }
        }
        if ((n & 0xE0) != 0) {
            return "partial " + JmolEdge.getBondOrderNumberFromOrder(n);
        }
        if (Bond.isOrderH(n)) {
            return EnumBondOrder.H_REGULAR.name;
        }
        if ((n & 0x100) != 0) {
            return EnumBondOrder.SINGLE.name;
        }
        return EnumBondOrder.getNameFromCode(n);
    }

    public static final int getPartialBondDotted(int n) {
        return n & 0x1F;
    }

    public static final int getPartialBondOrder(int n) {
        return (n & 0xFFFDFFFF) >> 5;
    }

    protected static final int getCovalentBondOrder(int n) {
        if ((n & 0x3FF) == 0) {
            return 0;
        }
        if (((n &= 0xFFFDFFFF) & 0xE0) != 0) {
            return JmolEdge.getPartialBondOrder(n);
        }
        if ((n & 0x100) != 0) {
            n &= 0xFFFFFEFF;
        }
        if ((n & 0xF8) != 0) {
            n = 1;
        }
        return n & 7;
    }

    public static final int getBondOrderFromFloat(float f) {
        switch ((int)(f * 10.0f)) {
            case 10: {
                return 1;
            }
            case -10: 
            case 5: {
                return 33;
            }
            case 15: {
                return 515;
            }
            case -15: {
                return 66;
            }
            case 20: {
                return 2;
            }
            case 25: {
                return 97;
            }
            case -25: {
                return 100;
            }
            case 30: {
                return 3;
            }
            case 40: {
                return 4;
            }
        }
        return 131071;
    }

    public static int getBondOrderFromString(String string) {
        return EnumBondOrder.getCodeFromName(string);
    }

    private static enum EnumBondOrder {
        SINGLE(1, "1", "single"),
        DOUBLE(2, "2", "double"),
        TRIPLE(3, "3", "triple"),
        QUADRUPLE(4, "4", "quadruple"),
        AROMATIC(515, "1.5", "aromatic"),
        STRUT(32768, "1", "struts"),
        H_REGULAR(2048, "1", "hbond"),
        PARTIAL01(33, "0.5", "partial"),
        PARTIAL12(66, "1.5", "partialDouble"),
        PARTIAL23(97, "2.5", "partialTriple"),
        PARTIAL32(100, "2.5", "partialTriple2"),
        AROMATIC_SINGLE(513, "1", "aromaticSingle"),
        AROMATIC_DOUBLE(514, "2", "aromaticDouble"),
        UNSPECIFIED(17, "1", "unspecified");

        private int code;
        protected String number;
        protected String name;

        private EnumBondOrder(int n2, String string2, String string3) {
            this.code = n2;
            this.number = string2;
            this.name = string3;
        }

        static int getCodeFromName(String string) {
            for (EnumBondOrder enumBondOrder : EnumBondOrder.values()) {
                if (!enumBondOrder.name.equalsIgnoreCase(string)) continue;
                return enumBondOrder.code;
            }
            return 131071;
        }

        static String getNameFromCode(int n) {
            for (EnumBondOrder enumBondOrder : EnumBondOrder.values()) {
                if (enumBondOrder.code != n) continue;
                return enumBondOrder.name;
            }
            return "?";
        }

        static String getNumberFromCode(int n) {
            for (EnumBondOrder enumBondOrder : EnumBondOrder.values()) {
                if (enumBondOrder.code != n) continue;
                return enumBondOrder.number;
            }
            return "?";
        }
    }
}

