/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.JmolModulationSet;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.Vibration;

public class ModulationSet
extends Vibration
implements JmolModulationSet {
    public float vOcc = Float.NaN;
    public Map<String, Float> htUij;
    public float vOcc0;
    String id;
    V3 x456;
    private List<Modulation> mods;
    private M3 gammaE;
    private P3 qtOffset = new P3();
    private int modDim;
    private boolean enabled;
    private P3 r0;
    private ModulationSet modTemp;
    private int iop;
    private M3 gammaIinv;
    private M4 q123w;
    private V3 sI;
    private float scale = 1.0f;
    private P3 tinv = new P3();
    private SymmetryInterface unitCell;
    private boolean isQ;
    P3 ptTemp = new P3();

    @Override
    public float getScale() {
        return this.scale;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public ModulationSet set(String string, P3 p3, int n, List<Modulation> list, M3 m3, M4 m4, M4 m42, int n2) {
        this.id = string;
        this.modDim = n;
        this.mods = list;
        this.gammaE = m3;
        this.iop = n2;
        this.gammaIinv = new M3();
        m4.getRotationScale(this.gammaIinv);
        this.sI = new V3();
        m4.get(this.sI);
        this.gammaIinv.invert();
        this.q123w = m42;
        this.r0 = P3.newP(p3);
        this.x456 = V3.newV(this.r0);
        m42.transform(this.x456);
        this.x456.sub(this.sI);
        this.gammaIinv.transform(this.x456);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET create r=" + Escape.eP(p3) + " si=" + Escape.eP(this.sI) + " ginv=" + this.gammaIinv.toString().replace('\n', ' ') + " x4=" + this.x456.x);
        }
        return this;
    }

    public synchronized ModulationSet calculate(T3 t3, boolean bl) {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.htUij = null;
        this.vOcc = Float.NaN;
        this.tinv.set(0.0f, 0.0f, 0.0f);
        if (bl && this.qtOffset != null) {
            this.tinv.setT(this.qtOffset);
            this.q123w.transform(this.tinv);
        }
        if (t3 != null) {
            this.tinv.add(t3);
        }
        this.gammaIinv.transform(this.tinv);
        this.tinv.add(this.x456);
        int n = this.mods.size();
        while (--n >= 0) {
            ((Modulation)this.mods.get(n)).apply(this, this.tinv);
        }
        this.gammaE.transform(this);
        return this;
    }

    public void addUTens(String string, float f) {
        if (this.htUij == null) {
            this.htUij = new Hashtable<String, Float>();
        }
        Float f2 = this.htUij.get(string);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET " + this.id + " utens=" + string + " f=" + f2 + " v=" + f);
        }
        if (f2 != null) {
            f += f2.floatValue();
        }
        this.htUij.put(string, Float.valueOf(f));
    }

    @Override
    public synchronized void setModTQ(T3 t3, boolean bl, T3 t32, boolean bl2, float f, SymmetryInterface symmetryInterface) {
        if (this.enabled) {
            this.addTo(t3, -1.0f);
        }
        this.enabled = false;
        this.scale = f;
        this.unitCell = symmetryInterface;
        if (t32 != null) {
            if (bl2) {
                this.isQ = bl2;
                this.qtOffset.setT(t32);
                t32 = null;
            }
            this.calculate(t32, bl2);
        }
        if (bl) {
            this.addTo(t3, 1.0f);
            this.enabled = true;
        }
    }

    @Override
    public void addTo(T3 t3, float f) {
        this.ptTemp.setT(this);
        this.ptTemp.scale(this.scale * f);
        this.unitCell.toCartesian(this.ptTemp, true);
        t3.add(this.ptTemp);
    }

    @Override
    public String getState() {
        return "modulation " + (!this.enabled ? "OFF" : (this.qtOffset == null ? "ON" : Escape.eP(this.qtOffset) + " " + this.isQ));
    }

    @Override
    public Object getModulation(String string, T3 t3) {
        this.getModTemp();
        if (string.equals("D")) {
            return P3.newP(t3 == null ? this.r0 : this.modTemp.calculate(t3, false));
        }
        return null;
    }

    @Override
    public void setTempPoint(T3 t3, T3 t32, float f, float f2) {
        if (!this.enabled) {
            return;
        }
        this.getModTemp();
        this.addTo(t3, -1.0f);
        this.modTemp.calculate(t32, false).addTo(t3, f2);
    }

    private void getModTemp() {
        if (this.modTemp != null) {
            return;
        }
        this.modTemp = new ModulationSet();
        this.modTemp.id = this.id;
        this.modTemp.x456 = this.x456;
        this.modTemp.mods = this.mods;
        this.modTemp.gammaE = this.gammaE;
        this.modTemp.modDim = this.modDim;
        this.modTemp.gammaIinv = this.gammaIinv;
        this.modTemp.q123w = this.q123w;
        this.modTemp.r0 = this.r0;
        this.modTemp.unitCell = this.unitCell;
    }

    @Override
    public void getInfo(Map<String, Object> map) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("id", this.id);
        hashtable.put("r0", this.r0);
        hashtable.put("x456", this.x456);
        hashtable.put("modDim", this.modDim);
        hashtable.put("gammaE", this.gammaE);
        hashtable.put("gammaIinv", this.gammaIinv);
        hashtable.put("sI", this.sI);
        hashtable.put("q123w", this.q123w);
        hashtable.put("symop", this.iop + 1);
        List<Hashtable<String, Object>> list = new List<Hashtable<String, Object>>();
        for (int i = 0; i < this.mods.size(); ++i) {
            list.addLast(((Modulation)this.mods.get(i)).getInfo());
        }
        hashtable.put("mods", list);
        map.put("modulation", hashtable);
    }
}

