/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.api.EventManager;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.PT;
import org.jmol.i18n.GT;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.MeasurementPending;
import org.jmol.thread.HoverWatcherThread;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.Rectangle;
import org.jmol.viewer.MouseState;
import org.jmol.viewer.Viewer;
import org.jmol.viewer.binding.Binding;
import org.jmol.viewer.binding.JmolBinding;

public class ActionManager
implements EventManager {
    protected Viewer viewer;
    protected boolean haveMultiTouchInput = false;
    protected Binding binding;
    private Binding jmolBinding;
    private Binding pfaatBinding;
    private Binding dragBinding;
    private Binding rasmolBinding;
    private Binding predragBinding;
    private int LEFT_CLICKED;
    private int LEFT_DRAGGED;
    protected Thread hoverWatcherThread;
    protected Gesture dragGesture = new Gesture(20);
    public static final int ACTION_assignNew = 0;
    public static final int ACTION_center = 1;
    public static final int ACTION_clickFrank = 2;
    public static final int ACTION_connectAtoms = 3;
    public static final int ACTION_deleteAtom = 4;
    public static final int ACTION_deleteBond = 5;
    public static final int ACTION_depth = 6;
    public static final int ACTION_dragAtom = 7;
    public static final int ACTION_dragDrawObject = 8;
    public static final int ACTION_dragDrawPoint = 9;
    public static final int ACTION_dragLabel = 10;
    public static final int ACTION_dragMinimize = 11;
    public static final int ACTION_dragMinimizeMolecule = 12;
    public static final int ACTION_dragSelected = 13;
    public static final int ACTION_dragZ = 14;
    public static final int ACTION_multiTouchSimulation = 15;
    public static final int ACTION_navTranslate = 16;
    public static final int ACTION_pickAtom = 17;
    public static final int ACTION_pickIsosurface = 18;
    public static final int ACTION_pickLabel = 19;
    public static final int ACTION_pickMeasure = 20;
    public static final int ACTION_pickNavigate = 21;
    public static final int ACTION_pickPoint = 22;
    public static final int ACTION_popupMenu = 23;
    public static final int ACTION_reset = 24;
    public static final int ACTION_rotate = 25;
    public static final int ACTION_rotateBranch = 26;
    public static final int ACTION_rotateSelected = 27;
    public static final int ACTION_rotateZ = 28;
    public static final int ACTION_rotateZorZoom = 29;
    public static final int ACTION_select = 30;
    public static final int ACTION_selectAndDrag = 31;
    public static final int ACTION_selectAndNot = 32;
    public static final int ACTION_selectNone = 33;
    public static final int ACTION_selectOr = 34;
    public static final int ACTION_selectToggle = 35;
    public static final int ACTION_selectToggleExtended = 36;
    public static final int ACTION_setMeasure = 37;
    public static final int ACTION_slab = 38;
    public static final int ACTION_slabAndDepth = 39;
    public static final int ACTION_slideZoom = 40;
    public static final int ACTION_spinDrawObjectCCW = 41;
    public static final int ACTION_spinDrawObjectCW = 42;
    public static final int ACTION_stopMotion = 43;
    public static final int ACTION_swipe = 44;
    public static final int ACTION_translate = 45;
    public static final int ACTION_wheelZoom = 46;
    public static final int ACTION_count = 47;
    private static final String[] actionInfo = new String[47];
    private static final String[] actionNames = new String[47];
    private int atomPickingMode = 1;
    private int bondPickingMode;
    public static final int PICKING_OFF = 0;
    public static final int PICKING_IDENTIFY = 1;
    public static final int PICKING_LABEL = 2;
    public static final int PICKING_CENTER = 3;
    public static final int PICKING_DRAW = 4;
    public static final int PICKING_SPIN = 5;
    public static final int PICKING_SYMMETRY = 6;
    public static final int PICKING_DELETE_ATOM = 7;
    public static final int PICKING_DELETE_BOND = 8;
    public static final int PICKING_SELECT_ATOM = 9;
    public static final int PICKING_SELECT_GROUP = 10;
    public static final int PICKING_SELECT_CHAIN = 11;
    public static final int PICKING_SELECT_MOLECULE = 12;
    public static final int PICKING_SELECT_POLYMER = 13;
    public static final int PICKING_SELECT_STRUCTURE = 14;
    public static final int PICKING_SELECT_SITE = 15;
    public static final int PICKING_SELECT_MODEL = 16;
    public static final int PICKING_SELECT_ELEMENT = 17;
    public static final int PICKING_MEASURE = 18;
    public static final int PICKING_MEASURE_DISTANCE = 19;
    public static final int PICKING_MEASURE_ANGLE = 20;
    public static final int PICKING_MEASURE_TORSION = 21;
    public static final int PICKING_MEASURE_SEQUENCE = 22;
    public static final int PICKING_NAVIGATE = 23;
    public static final int PICKING_CONNECT = 24;
    public static final int PICKING_STRUTS = 25;
    public static final int PICKING_DRAG_SELECTED = 26;
    public static final int PICKING_DRAG_MOLECULE = 27;
    public static final int PICKING_DRAG_ATOM = 28;
    public static final int PICKING_DRAG_MINIMIZE = 29;
    public static final int PICKING_DRAG_MINIMIZE_MOLECULE = 30;
    public static final int PICKING_INVERT_STEREO = 31;
    public static final int PICKING_ASSIGN_ATOM = 32;
    public static final int PICKING_ASSIGN_BOND = 33;
    public static final int PICKING_ROTATE_BOND = 34;
    public static final int PICKING_IDENTIFY_BOND = 35;
    public static final int PICKING_DRAG_LIGAND = 36;
    private static final String[] pickingModeNames;
    public static final int PICKINGSTYLE_SELECT_JMOL = 0;
    public static final int PICKINGSTYLE_SELECT_CHIME = 0;
    public static final int PICKINGSTYLE_SELECT_RASMOL = 1;
    public static final int PICKINGSTYLE_SELECT_PFAAT = 2;
    public static final int PICKINGSTYLE_SELECT_DRAG = 3;
    public static final int PICKINGSTYLE_MEASURE_ON = 4;
    public static final int PICKINGSTYLE_MEASURE_OFF = 5;
    private static final String[] pickingStyleNames;
    private int pickingStyle;
    private int pickingStyleSelect = 0;
    private int pickingStyleMeasure = 5;
    private int rootPickingStyle = 0;
    private String pickAtomAssignType = "C";
    private char pickBondAssignType = (char)112;
    private boolean isPickAtomAssignCharge;
    private static final long MAX_DOUBLE_CLICK_MILLIS = 700L;
    protected static final long MININUM_GESTURE_DELAY_MILLISECONDS = 10L;
    private static final int SLIDE_ZOOM_X_PERCENT = 98;
    public static final float DEFAULT_MOUSE_DRAG_FACTOR = 1.0f;
    public static final float DEFAULT_MOUSE_WHEEL_FACTOR = 1.15f;
    public static final float DEFAULT_GESTURE_SWIPE_FACTOR = 1.0f;
    protected int xyRange = 0;
    private float gestureSwipeFactor = 1.0f;
    protected float mouseDragFactor = 1.0f;
    protected float mouseWheelFactor = 1.15f;
    protected final MouseState current = new MouseState("current");
    protected final MouseState moved = new MouseState("moved");
    private final MouseState clicked = new MouseState("clicked");
    private final MouseState pressed = new MouseState("pressed");
    private final MouseState dragged = new MouseState("dragged");
    protected int pressedCount;
    protected int clickedCount;
    private boolean drawMode;
    private boolean labelMode;
    private boolean dragSelectedMode;
    private boolean measuresEnabled = true;
    private boolean haveSelection;
    private boolean hoverActive = false;
    private MeasurementPending measurementPending;
    private int dragAtomIndex = -1;
    private boolean rubberbandSelectionMode = false;
    private final Rectangle rectRubber = new Rectangle();
    private boolean isAltKeyReleased = true;
    private boolean keyProcessing;
    protected boolean isMultiTouchClient;
    protected boolean isMultiTouchServer;
    private int pressAction;
    private int dragAction;
    private int clickAction;
    private MeasurementPending measurementQueued;
    private boolean selectionWorking = false;

    public void setViewer(Viewer viewer, String string) {
        this.viewer = viewer;
        this.jmolBinding = new JmolBinding();
        this.setBinding(this.jmolBinding);
        this.LEFT_CLICKED = Binding.getMouseAction(1, 16, 2);
        this.LEFT_DRAGGED = Binding.getMouseAction(1, 16, 1);
    }

    public void checkHover() {
        if (!(this.viewer.getInMotion(true) || this.viewer.getSpinOn() || this.viewer.getNavOn() || this.viewer.checkObjectHovered(this.current.x, this.current.y))) {
            int n = this.viewer.findNearestAtomIndex(this.current.x, this.current.y);
            if (n < 0) {
                return;
            }
            boolean bl = this.getAtomPickingMode() == 2 && this.isBound(Binding.getMouseAction(this.clickedCount, this.moved.modifiers, 1), 10);
            this.viewer.hoverOn(n, bl);
        }
    }

    public void processMultitouchEvent(int n, int n2, int n3, int n4, P3 p3, long l) {
    }

    boolean isBound(int n, int n2) {
        return this.binding.isBound(n, n2);
    }

    void bindAction(String string, String string2) {
        int n = ActionManager.getActionFromName(string2);
        int n2 = Binding.getMouseActionStr(string);
        if (n2 == 0) {
            return;
        }
        if (n >= 0) {
            this.binding.bindAction(n2, n);
        } else {
            this.binding.bindName(n2, string2);
        }
    }

    protected void clearBindings() {
        this.jmolBinding = new JmolBinding();
        this.setBinding(this.jmolBinding);
        this.pfaatBinding = null;
        this.dragBinding = null;
        this.rasmolBinding = null;
    }

    void unbindAction(String string, String string2) {
        if (string == null && string2 == null) {
            this.clearBindings();
            return;
        }
        int n = ActionManager.getActionFromName(string2);
        int n2 = Binding.getMouseActionStr(string);
        if (n >= 0) {
            this.binding.unbindAction(n2, n);
        } else if (n2 != 0) {
            this.binding.unbindName(n2, string2);
        }
        if (string2 == null) {
            this.binding.unbindUserAction(string);
        }
    }

    static void newAction(int n, String string, String string2) {
        ActionManager.actionInfo[n] = string2;
        ActionManager.actionNames[n] = string;
    }

    public static String getActionName(int n) {
        return n < actionNames.length ? actionNames[n] : null;
    }

    public static int getActionFromName(String string) {
        for (int i = 0; i < actionNames.length; ++i) {
            if (!actionNames[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public String getBindingInfo(String string) {
        return this.binding.getBindingInfo(actionInfo, actionNames, string);
    }

    protected void setBinding(Binding binding) {
        this.binding = binding;
    }

    public static final String getPickingModeName(int n) {
        return n < 0 || n >= pickingModeNames.length ? "off" : pickingModeNames[n];
    }

    public static final int getPickingMode(String string) {
        int n = pickingModeNames.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(pickingModeNames[n])) continue;
            return n;
        }
        return -1;
    }

    int getAtomPickingMode() {
        return this.atomPickingMode;
    }

    void setPickingMode(int n) {
        boolean bl = false;
        switch (n) {
            case -1: {
                bl = true;
                this.bondPickingMode = 35;
                n = 1;
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                this.viewer.setBooleanProperty("bondPicking", true);
                this.bondPickingMode = n;
                return;
            }
            case 8: {
                this.bondPickingMode = n;
                if (this.viewer.getBondPicking()) {
                    return;
                }
                bl = true;
            }
        }
        boolean bl2 = this.atomPickingMode != n;
        this.atomPickingMode = n;
        if (bl |= bl2) {
            this.resetMeasurement();
        }
    }

    void setAtomPickingOption(String string) {
        switch (this.atomPickingMode) {
            case 32: {
                this.pickAtomAssignType = string;
                this.isPickAtomAssignCharge = this.pickAtomAssignType.equals("Pl") || this.pickAtomAssignType.equals("Mi");
            }
        }
    }

    void setBondPickingOption(String string) {
        switch (this.bondPickingMode) {
            case 33: {
                this.pickBondAssignType = Character.toLowerCase(string.charAt(0));
            }
        }
    }

    public static final String getPickingStyleName(int n) {
        return n < 0 || n >= pickingStyleNames.length ? "toggle" : pickingStyleNames[n];
    }

    public static final int getPickingStyleIndex(String string) {
        int n = pickingStyleNames.length;
        while (--n >= 0) {
            if (!string.equalsIgnoreCase(pickingStyleNames[n])) continue;
            return n;
        }
        return -1;
    }

    public String getPickingState() {
        String string = ";set modelkitMode " + this.viewer.getBoolean(603979883) + ";set picking " + ActionManager.getPickingModeName(this.atomPickingMode);
        if (this.atomPickingMode == 32) {
            string = string + "_" + this.pickAtomAssignType;
        }
        string = string + ";";
        if (this.bondPickingMode != 0) {
            string = string + "set picking " + ActionManager.getPickingModeName(this.bondPickingMode);
        }
        if (this.bondPickingMode == 33) {
            string = string + "_" + this.pickBondAssignType;
        }
        string = string + ";";
        return string;
    }

    int getPickingStyle() {
        return this.pickingStyle;
    }

    void setPickingStyle(int n) {
        this.pickingStyle = n;
        if (n >= 4) {
            this.pickingStyleMeasure = n;
            this.resetMeasurement();
        } else {
            if (n < 3) {
                this.rootPickingStyle = n;
            }
            this.pickingStyleSelect = n;
        }
        this.rubberbandSelectionMode = false;
        switch (this.pickingStyleSelect) {
            case 2: {
                if (this.binding.name.equals("extendedSelect")) break;
                this.setBinding(this.pfaatBinding == null ? (this.pfaatBinding = Binding.newBinding("Pfaat")) : this.pfaatBinding);
                break;
            }
            case 3: {
                if (!this.binding.name.equals("drag")) {
                    this.setBinding(this.dragBinding == null ? (this.dragBinding = Binding.newBinding("Drag")) : this.dragBinding);
                }
                this.rubberbandSelectionMode = true;
                break;
            }
            case 1: {
                if (this.binding.name.equals("selectOrToggle")) break;
                this.setBinding(this.rasmolBinding == null ? (this.rasmolBinding = Binding.newBinding("Rasmol")) : this.rasmolBinding);
                break;
            }
            default: {
                if (this.binding == this.jmolBinding) break;
                this.setBinding(this.jmolBinding);
            }
        }
        if (!this.binding.name.equals("drag")) {
            this.predragBinding = this.binding;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, Object> getMouseInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        List<void> list = new List<void>();
        for (Object object : this.binding.getBindings().values()) {
            void stringArray;
            if (object instanceof Boolean) continue;
            if (PT.isAI(object)) {
                int[] nArray = (int[])object;
                String[] stringArray2 = new String[]{Binding.getMouseActionName(nArray[0], false), ActionManager.getActionName(nArray[1])};
            }
            list.addLast(stringArray);
        }
        hashtable.put("bindings", list);
        hashtable.put("bindingName", this.binding.name);
        hashtable.put("actionNames", actionNames);
        hashtable.put("actionInfo", actionInfo);
        hashtable.put("bindingInfo", PT.split(this.getBindingInfo(null), "\n"));
        return hashtable;
    }

    void setGestureSwipeFactor(float f) {
        this.gestureSwipeFactor = f;
    }

    void setMouseDragFactor(float f) {
        this.mouseDragFactor = f;
    }

    void setMouseWheelFactor(float f) {
        this.mouseWheelFactor = f;
    }

    protected void setCurrent(long l, int n, int n2, int n3) {
        this.viewer.hoverOff();
        this.current.set(l, n, n2, n3);
    }

    int getCurrentX() {
        return this.current.x;
    }

    int getCurrentY() {
        return this.current.y;
    }

    public void setMouseMode() {
        this.labelMode = false;
        this.drawMode = false;
        this.dragSelectedMode = this.viewer.getDragSelected();
        boolean bl = this.measuresEnabled = !this.dragSelectedMode;
        if (!this.dragSelectedMode) {
            switch (this.atomPickingMode) {
                default: {
                    return;
                }
                case 32: {
                    this.measuresEnabled = !this.isPickAtomAssignCharge;
                    return;
                }
                case 4: {
                    this.drawMode = true;
                    this.measuresEnabled = false;
                    break;
                }
                case 2: {
                    this.labelMode = true;
                    this.measuresEnabled = false;
                    break;
                }
                case 9: {
                    this.measuresEnabled = false;
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    this.measuresEnabled = false;
                    return;
                }
            }
        }
        this.exitMeasurementMode();
    }

    protected void clearMouseInfo() {
        this.clickedCount = 0;
        this.pressedCount = 0;
        this.dragGesture.setAction(0, 0L);
        this.exitMeasurementMode();
    }

    public boolean isMTClient() {
        return this.isMultiTouchClient;
    }

    public boolean isMTServer() {
        return this.isMultiTouchServer;
    }

    public void dispose() {
        this.clear();
    }

    public void clear() {
        this.startHoverWatcher(false);
        if (this.predragBinding != null) {
            this.binding = this.predragBinding;
        }
        this.viewer.setPickingMode(null, 1);
        this.viewer.setPickingStyle(null, this.rootPickingStyle);
        this.isAltKeyReleased = true;
    }

    public synchronized void startHoverWatcher(boolean bl) {
        if (this.viewer.isPreviewOnly()) {
            return;
        }
        try {
            if (bl) {
                if (this.hoverWatcherThread != null) {
                    return;
                }
                this.current.time = -1L;
                this.hoverWatcherThread = new HoverWatcherThread(this, this.current, this.moved, this.viewer);
            } else {
                if (this.hoverWatcherThread == null) {
                    return;
                }
                this.current.time = -1L;
                this.hoverWatcherThread.interrupt();
                this.hoverWatcherThread = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setModeMouse(int n) {
        if (n == -1) {
            this.startHoverWatcher(false);
        }
    }

    @Override
    public boolean keyPressed(int n, int n2) {
        if (this.keyProcessing) {
            return false;
        }
        this.viewer.hoverOff();
        this.keyProcessing = true;
        switch (n) {
            case 18: {
                if (this.dragSelectedMode && this.isAltKeyReleased) {
                    this.viewer.moveSelected(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
                }
                this.isAltKeyReleased = false;
                this.moved.modifiers |= 8;
                break;
            }
            case 16: {
                this.dragged.modifiers |= 1;
                this.moved.modifiers |= 1;
                break;
            }
            case 17: {
                this.moved.modifiers |= 2;
            }
        }
        int n3 = 0x2110 | this.moved.modifiers;
        if (!this.labelMode && !this.binding.isUserAction(n3)) {
            this.checkMotionRotateZoom(n3, this.current.x, 0, 0, false);
        }
        if (this.viewer.getBoolean(603979887)) {
            switch (n) {
                case 32: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 46: {
                    this.viewer.navigate(n, n2);
                }
            }
        }
        this.keyProcessing = false;
        return true;
    }

    @Override
    public void keyReleased(int n) {
        switch (n) {
            case 18: {
                if (this.dragSelectedMode) {
                    this.viewer.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
                }
                this.isAltKeyReleased = true;
                this.moved.modifiers &= 0xFFFFFFF7;
                break;
            }
            case 16: {
                this.moved.modifiers &= 0xFFFFFFFE;
                break;
            }
            case 17: {
                this.moved.modifiers &= 0xFFFFFFFD;
            }
        }
        if (this.moved.modifiers == 0) {
            this.viewer.setCursor(0);
        }
        if (!this.viewer.getBoolean(603979887)) {
            return;
        }
        switch (n) {
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                this.viewer.navigate(0, 0);
            }
        }
    }

    @Override
    public void mouseEnterExit(long l, int n, int n2, boolean bl) {
        this.setCurrent(l, n, n2, 0);
        if (bl && this.measurementPending != null) {
            this.exitMeasurementMode();
            this.viewer.refresh(3, "mouseExit");
        }
    }

    private void setMouseActions(int n, int n2, boolean bl) {
        this.pressAction = Binding.getMouseAction(n, n2, bl ? 5 : 4);
        this.dragAction = Binding.getMouseAction(n, n2, 1);
        this.clickAction = Binding.getMouseAction(n, n2, 2);
    }

    @Override
    public void mouseAction(int n, long l, int n2, int n3, int n4, int n5) {
        if (!this.viewer.getMouseEnabled()) {
            return;
        }
        if (Logger.debuggingHigh && n != 0) {
            this.viewer.showString("mouse action: " + n + " " + n5 + " " + Binding.getMouseActionName(Binding.getMouseAction(n4, n5, n), false), false);
        }
        switch (n) {
            case 0: {
                this.setCurrent(l, n2, n3, n5);
                this.moved.setCurrent(this.current, 0);
                if (this.measurementPending != null || this.hoverActive) {
                    this.clickAction = Binding.getMouseAction(this.clickedCount, n5, 0);
                    this.checkClickAction(n2, n3, l, 0);
                    return;
                }
                if (this.isZoomArea(n2)) {
                    this.checkMotionRotateZoom(this.LEFT_DRAGGED, 0, 0, 0, false);
                    return;
                }
                if (this.viewer.getCursor() == 8) {
                    this.viewer.setCursor(0);
                }
                return;
            }
            case 4: {
                this.setMouseMode();
                int n6 = this.pressedCount = this.pressed.check(0, 0, 0, n5, l, 700L) ? this.pressedCount + 1 : 1;
                if (this.pressedCount == 1) {
                    this.viewer.checkInMotion(1);
                    this.setCurrent(l, n2, n3, n5);
                }
                this.pressAction = Binding.getMouseAction(this.pressedCount, n5, 4);
                this.viewer.setCursor(12);
                this.pressed.setCurrent(this.current, 1);
                this.dragged.setCurrent(this.current, 1);
                this.viewer.setFocus();
                this.dragGesture.setAction(this.dragAction, l);
                this.checkPressedAction(n2, n3, l);
                return;
            }
            case 1: {
                this.setMouseMode();
                this.setMouseActions(this.pressedCount, n5, false);
                int n7 = n2 - this.dragged.x;
                int n8 = n3 - this.dragged.y;
                this.setCurrent(l, n2, n3, n5);
                this.dragged.setCurrent(this.current, -1);
                if (this.atomPickingMode != 32) {
                    this.exitMeasurementMode();
                }
                this.dragGesture.add(this.dragAction, n2, n3, l);
                this.checkDragWheelAction(this.dragAction, n2, n3, n7, n8, l, 1);
                return;
            }
            case 5: {
                this.setMouseActions(this.pressedCount, n5, true);
                this.setCurrent(l, n2, n3, n5);
                this.viewer.spinXYBy(0, 0, 0.0f);
                boolean bl = !this.pressed.check(this.xyRange, n2, n3, n5, l, Long.MAX_VALUE);
                this.checkReleaseAction(n2, n3, l, bl);
                return;
            }
            case 3: {
                if (this.viewer.isApplet() && !this.viewer.hasFocus()) {
                    return;
                }
                this.setCurrent(l, this.current.x, this.current.y, n5);
                this.checkDragWheelAction(Binding.getMouseAction(0, n5, 3), this.current.x, this.current.y, 0, n3, l, 3);
                return;
            }
            case 2: {
                this.setMouseMode();
                int n9 = n4 > 1 ? n4 : (this.clickedCount = this.clicked.check(0, 0, 0, n5, l, 700L) ? this.clickedCount + 1 : 1);
                if (this.clickedCount == 1) {
                    this.setCurrent(l, n2, n3, n5);
                }
                this.setMouseActions(this.clickedCount, n5, false);
                this.clicked.setCurrent(this.current, this.clickedCount);
                this.viewer.setFocus();
                if (this.atomPickingMode != 9 && this.isBound(Binding.getMouseAction(1, n5, 4), 31)) {
                    return;
                }
                this.clickAction = Binding.getMouseAction(this.clickedCount, n5, 2);
                this.checkClickAction(n2, n3, l, this.clickedCount);
                return;
            }
        }
    }

    private void checkPressedAction(int n, int n2, long l) {
        int n3 = Binding.getButtonMods(this.pressAction);
        boolean bl = this.isBound(Binding.getMouseAction(1, n3, 4), 31);
        if (n3 != 0) {
            this.pressAction = this.viewer.notifyMouseClicked(n, n2, this.pressAction, 4);
            if (this.pressAction == 0) {
                return;
            }
            n3 = Binding.getButtonMods(this.pressAction);
        }
        this.setMouseActions(this.pressedCount, n3, false);
        if (Logger.debugging) {
            Logger.debug(Binding.getMouseActionName(this.pressAction, false));
        }
        if (this.drawMode && (this.isBound(this.dragAction, 8) || this.isBound(this.dragAction, 9)) || this.labelMode && this.isBound(this.dragAction, 10)) {
            this.viewer.checkObjectDragged(Integer.MIN_VALUE, 0, n, n2, this.dragAction);
            return;
        }
        this.checkUserAction(this.pressAction, n, n2, 0, 0, l, 4);
        boolean bl2 = false;
        switch (this.atomPickingMode) {
            case 32: {
                bl2 = this.isBound(this.clickAction, 0);
                break;
            }
            case 28: {
                bl2 = this.isBound(this.dragAction, 7) || this.isBound(this.dragAction, 14);
                break;
            }
            case 26: 
            case 27: 
            case 36: {
                bl2 = this.isBound(this.dragAction, 7) || this.isBound(this.dragAction, 27) || this.isBound(this.dragAction, 14);
                break;
            }
            case 29: {
                bl2 = this.isBound(this.dragAction, 11) || this.isBound(this.dragAction, 14);
                break;
            }
            case 30: {
                boolean bl3 = bl2 = this.isBound(this.dragAction, 12) || this.isBound(this.dragAction, 27) || this.isBound(this.dragAction, 14);
            }
        }
        if (bl2) {
            this.dragAtomIndex = this.viewer.findNearestAtomIndexMovable(n, n2, true);
            if (this.dragAtomIndex >= 0 && (this.atomPickingMode == 32 || this.atomPickingMode == 31) && this.viewer.isAtomAssignable(this.dragAtomIndex)) {
                this.enterMeasurementMode(this.dragAtomIndex);
                this.measurementPending.addPoint(this.dragAtomIndex, null, false);
            }
            return;
        }
        if (this.isBound(this.pressAction, 23)) {
            int n4 = 106;
            if (this.viewer.getBoolean(603979883)) {
                Map<String, Object> map = this.viewer.checkObjectClicked(n, n2, this.LEFT_CLICKED);
                n4 = map != null && "bond".equals(map.get("type")) ? 98 : (this.viewer.findNearestAtomIndex(n, n2) >= 0 ? 97 : 109);
            }
            this.viewer.popupMenu(n, n2, (char)n4);
            return;
        }
        if (this.dragSelectedMode) {
            this.haveSelection = true;
            if (bl) {
                boolean bl4 = this.haveSelection = this.viewer.findNearestAtomIndexMovable(n, n2, true) >= 0;
            }
            if (!this.haveSelection) {
                return;
            }
            if (this.isBound(this.dragAction, 13) || this.isBound(this.dragAction, 14)) {
                this.viewer.moveSelected(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
            }
            return;
        }
        if (this.viewer.global.useArcBall) {
            this.viewer.rotateArcBall(n, n2, 0.0f);
        }
        this.checkMotionRotateZoom(this.dragAction, n, 0, 0, true);
    }

    private void checkDragWheelAction(int n, int n2, int n3, int n4, int n5, long l, int n6) {
        int n7 = Binding.getButtonMods(n);
        if (n7 != 0) {
            int n8 = this.viewer.notifyMouseClicked(n2, n3, Binding.getMouseAction(this.pressedCount, n7, n6), n6);
            if (n8 == 0) {
                return;
            }
            if (n8 > 0) {
                n = n8;
            }
        }
        if (this.isRubberBandSelect(n)) {
            this.calcRectRubberBand();
            this.viewer.refresh(3, "rubberBand selection");
            return;
        }
        if (this.checkUserAction(n, n2, n3, n4, n5, l, n6)) {
            return;
        }
        if (this.viewer.getRotateBondIndex() >= 0) {
            if (this.isBound(n, 26)) {
                this.viewer.moveSelected(n4, n5, Integer.MIN_VALUE, n2, n3, null, false, false);
                return;
            }
            if (!this.isBound(n, 25)) {
                this.viewer.setRotateBondIndex(-1);
            }
        }
        BS bS = null;
        if (this.dragAtomIndex >= 0) {
            switch (this.atomPickingMode) {
                case 26: {
                    this.setMotion(13, true);
                    if (this.isBound(n, 27) && this.viewer.getBoolean(603979785)) {
                        this.viewer.rotateSelected(this.getDegrees(n4, 0), this.getDegrees(n5, 1), null);
                    } else {
                        this.viewer.moveSelected(n4, n5, this.isBound(n, 14) ? -n5 : Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, true, false);
                    }
                    return;
                }
                case 27: 
                case 30: 
                case 36: {
                    bS = this.viewer.getAtomBits(1095761936, BSUtil.newAndSetBit(this.dragAtomIndex));
                    if (this.atomPickingMode == 36) {
                        bS.and(this.viewer.getAtomBitSet("ligand"));
                    }
                }
                case 28: 
                case 29: {
                    if (this.dragGesture.getPointCount() == 1) {
                        this.viewer.undoMoveActionClear(this.dragAtomIndex, 2, true);
                    }
                    this.setMotion(13, true);
                    if (this.isBound(n, 27)) {
                        this.viewer.rotateSelected(this.getDegrees(n4, 0), this.getDegrees(n5, 1), bS);
                    } else {
                        switch (this.atomPickingMode) {
                            case 27: 
                            case 30: 
                            case 36: {
                                this.viewer.select(bS, false, 0, true);
                            }
                        }
                        this.viewer.moveAtomWithHydrogens(this.dragAtomIndex, n4, n5, this.isBound(n, 14) ? -n5 : Integer.MIN_VALUE, bS);
                    }
                    return;
                }
            }
        }
        if (this.dragAtomIndex >= 0 && n6 == 1 && this.isBound(this.clickAction, 0) && this.atomPickingMode == 32) {
            int n9 = this.viewer.findNearestAtomIndexMovable(n2, n3, false);
            if (n9 >= 0) {
                if (this.measurementPending != null) {
                    this.measurementPending.setCount(1);
                } else if (this.measuresEnabled) {
                    this.enterMeasurementMode(n9);
                }
                this.addToMeasurement(n9, null, true);
                this.measurementPending.colix = (short)20;
            } else if (this.measurementPending != null) {
                this.measurementPending.setCount(1);
                this.measurementPending.colix = (short)23;
            }
            if (this.measurementPending == null) {
                return;
            }
            this.measurementPending.traceX = n2;
            this.measurementPending.traceY = n3;
            this.viewer.refresh(3, "assignNew");
            return;
        }
        if (!this.drawMode && !this.labelMode && this.isBound(n, 45)) {
            this.viewer.translateXYBy(n4, n5);
            return;
        }
        if (this.dragSelectedMode && this.haveSelection && (this.isBound(n, 13) || this.isBound(n, 27))) {
            int n10 = this.viewer.getSelectionSet(false).nextSetBit(0);
            if (n10 < 0) {
                return;
            }
            if (this.dragGesture.getPointCount() == 1) {
                this.viewer.undoMoveActionClear(n10, 2, true);
            } else {
                this.viewer.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
            }
            this.setMotion(13, true);
            if (this.isBound(n, 27) && this.viewer.getBoolean(603979785)) {
                this.viewer.rotateSelected(this.getDegrees(n4, 0), this.getDegrees(n5, 1), null);
            } else {
                this.viewer.moveSelected(n4, n5, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, true, false);
            }
            return;
        }
        if (this.drawMode && (this.isBound(n, 8) || this.isBound(n, 9)) || this.labelMode && this.isBound(n, 10)) {
            this.setMotion(13, true);
            this.viewer.checkObjectDragged(this.dragged.x, this.dragged.y, n2, n3, n);
            return;
        }
        if (this.checkMotionRotateZoom(n, n2, n4, n5, true)) {
            if (this.viewer.getSlabEnabled() && this.checkSlideZoom(n)) {
                this.viewer.slabDepthByPixels(n5);
            } else {
                this.viewer.zoomBy(n5);
            }
            return;
        }
        if (this.isBound(n, 25)) {
            float f = this.getDegrees(n4, 0);
            float f2 = this.getDegrees(n5, 1);
            if (this.viewer.global.useArcBall) {
                this.viewer.rotateArcBall(n2, n3, this.mouseDragFactor);
            } else {
                this.viewer.rotateXYBy(f, f2);
            }
            return;
        }
        if (this.isBound(n, 29)) {
            if (n4 == 0 && Math.abs(n5) > 1) {
                this.setMotion(8, true);
                this.viewer.zoomBy(n5 + (n5 > 0 ? -1 : 1));
            } else if (n5 == 0 && Math.abs(n4) > 1) {
                this.setMotion(13, true);
                this.viewer.rotateZBy(-n4 + (n4 > 0 ? 1 : -1), Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
            return;
        }
        if (this.isBound(n, 46)) {
            this.zoomByFactor(n5, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return;
        }
        if (this.isBound(n, 28)) {
            this.setMotion(13, true);
            this.viewer.rotateZBy(-n4, Integer.MAX_VALUE, Integer.MAX_VALUE);
            return;
        }
        if (this.viewer.getSlabEnabled()) {
            if (this.isBound(n, 6)) {
                this.viewer.depthByPixels(n5);
                return;
            }
            if (this.isBound(n, 38)) {
                this.viewer.slabByPixels(n5);
                return;
            }
            if (this.isBound(n, 39)) {
                this.viewer.slabDepthByPixels(n5);
                return;
            }
        }
    }

    private void checkReleaseAction(int n, int n2, long l, boolean bl) {
        if (Logger.debugging) {
            Logger.debug(Binding.getMouseActionName(this.pressAction, false));
        }
        this.viewer.checkInMotion(0);
        this.viewer.setInMotion(false);
        this.viewer.setCursor(0);
        this.dragGesture.add(this.dragAction, n, n2, l);
        if (bl) {
            this.viewer.setRotateBondIndex(Integer.MIN_VALUE);
        }
        if (this.dragAtomIndex >= 0 && (this.atomPickingMode == 29 || this.atomPickingMode == 30)) {
            this.minimize(true);
        }
        if (this.atomPickingMode == 32 && this.isBound(this.clickAction, 0)) {
            if (this.measurementPending == null || this.dragAtomIndex < 0) {
                return;
            }
            this.assignNew(n, n2);
            return;
        }
        this.dragAtomIndex = -1;
        boolean bl2 = this.isRubberBandSelect(this.dragAction);
        if (bl2) {
            this.selectRb(this.clickAction);
        }
        this.rubberbandSelectionMode = this.binding.name.equals("drag");
        this.rectRubber.x = Integer.MAX_VALUE;
        if (bl) {
            this.viewer.notifyMouseClicked(n, n2, Binding.getMouseAction(this.pressedCount, 0, 5), 5);
        }
        if (this.drawMode && (this.isBound(this.dragAction, 8) || this.isBound(this.dragAction, 9)) || this.labelMode && this.isBound(this.dragAction, 10)) {
            this.viewer.checkObjectDragged(Integer.MAX_VALUE, 0, n, n2, this.dragAction);
            return;
        }
        if (this.dragSelectedMode && this.isBound(this.dragAction, 13) && this.haveSelection) {
            this.viewer.moveSelected(Integer.MAX_VALUE, 0, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, null, false, false);
        }
        if (bl && this.checkUserAction(this.pressAction, n, n2, 0, 0, l, 5)) {
            return;
        }
        if (this.viewer.getBoolean(0x24000004) && this.isBound(this.dragAction, 44)) {
            float f = this.getExitRate();
            if (f > 0.0f) {
                this.viewer.spinXYBy(this.dragGesture.getDX(4, 2), this.dragGesture.getDY(4, 2), f * 30.0f * this.gestureSwipeFactor);
            }
            if (this.viewer.global.logGestures) {
                this.viewer.log("$NOW$ swipe " + this.dragGesture + " " + f);
            }
            return;
        }
    }

    private void checkClickAction(int n, int n2, long l, int n3) {
        if (!this.viewer.haveModelSet()) {
            return;
        }
        if (n3 > 0) {
            if (this.checkUserAction(this.clickAction, n, n2, 0, 0, l, 32768)) {
                return;
            }
            this.clickAction = this.viewer.notifyMouseClicked(n, n2, this.clickAction, 32768);
            if (this.clickAction == 0) {
                return;
            }
        }
        if (Logger.debugging) {
            Logger.debug(Binding.getMouseActionName(this.clickAction, false));
        }
        if (this.isBound(this.clickAction, 2) && this.viewer.frankClicked(n, n2)) {
            this.viewer.popupMenu(-n, n2, 'j');
            return;
        }
        if (this.isBound(this.clickAction, 2) && this.viewer.frankClickedModelKit(n, n2)) {
            this.viewer.popupMenu(0, 0, 'm');
            return;
        }
        Point3fi point3fi = null;
        boolean bl = false;
        boolean bl2 = false;
        Map<String, Object> map = null;
        if (!this.drawMode && (map = this.viewer.checkObjectClicked(n, n2, this.clickAction)) != null) {
            bl = "bond".equals(map.get("type"));
            bl2 = "isosurface".equals(map.get("type"));
            point3fi = this.getPoint(map);
        }
        if (bl) {
            n3 = 1;
        }
        if (point3fi != null && Float.isNaN(point3fi.x)) {
            return;
        }
        int n4 = this.findNearestAtom(n, n2, point3fi, n3 > 0);
        if (n3 == 0 && this.atomPickingMode != 32) {
            if (this.measurementPending == null) {
                return;
            }
            if (point3fi != null || this.measurementPending.getIndexOf(n4) == 0) {
                this.measurementPending.addPoint(n4, point3fi, false);
            }
            if (this.measurementPending.haveModified) {
                this.viewer.setPendingMeasurement(this.measurementPending);
            }
            this.viewer.refresh(3, "measurementPending");
            return;
        }
        this.setMouseMode();
        if (this.isBound(this.clickAction, 43)) {
            this.viewer.stopMotion();
        }
        if (this.viewer.getBoolean(603979887) && this.atomPickingMode == 23 && this.isBound(this.clickAction, 21)) {
            this.viewer.navTranslatePercent((float)n * 100.0f / (float)this.viewer.getScreenWidth() - 50.0f, (float)n2 * 100.0f / (float)this.viewer.getScreenHeight() - 50.0f);
            return;
        }
        if (bl) {
            if (this.isBound(this.clickAction, this.bondPickingMode == 34 || this.bondPickingMode == 33 ? 0 : 5)) {
                this.bondPicked((Integer)map.get("index"));
                return;
            }
        } else {
            if (bl2) {
                return;
            }
            if (this.atomPickingMode != 32 && this.measurementPending != null && this.isBound(this.clickAction, 20)) {
                this.atomOrPointPicked(n4, point3fi);
                if (this.addToMeasurement(n4, point3fi, false) == 4) {
                    this.toggleMeasurement();
                }
                return;
            }
            if (this.isBound(this.clickAction, 37)) {
                if (this.measurementPending != null) {
                    this.addToMeasurement(n4, point3fi, true);
                    this.toggleMeasurement();
                } else if (!this.drawMode && !this.labelMode && !this.dragSelectedMode && this.measuresEnabled) {
                    this.enterMeasurementMode(n4);
                    this.addToMeasurement(n4, point3fi, true);
                }
                this.atomOrPointPicked(n4, point3fi);
                return;
            }
        }
        if (this.isSelectAction(this.clickAction)) {
            if (!bl2) {
                this.atomOrPointPicked(n4, point3fi);
            }
            return;
        }
        if (this.isBound(this.clickAction, 24)) {
            if (n4 < 0) {
                this.reset();
            }
            return;
        }
    }

    private boolean checkUserAction(int n, int n2, int n3, int n4, int n5, long l, int n6) {
        if (!this.binding.isUserAction(n)) {
            return false;
        }
        boolean bl = false;
        Map<String, Object> map = this.binding.getBindings();
        String string = n + "\t";
        for (String string2 : map.keySet()) {
            Object object;
            if (string2.indexOf(string) != 0 || !PT.isAS(object = map.get(string2))) continue;
            String string3 = ((String[])object)[1];
            P3 p3 = null;
            if (string3.indexOf("_ATOM") >= 0) {
                int n7 = this.findNearestAtom(n2, n3, null, true);
                string3 = PT.simpleReplace(string3, "_ATOM", "({" + (n7 >= 0 ? "" + n7 : "") + "})");
                if (n7 >= 0) {
                    string3 = PT.simpleReplace(string3, "_POINT", Escape.eP(this.viewer.getModelSet().atoms[n7]));
                }
            }
            if (!(this.drawMode || string3.indexOf("_POINT") < 0 && string3.indexOf("_OBJECT") < 0 && string3.indexOf("_BOND") < 0)) {
                Map<String, Object> map2 = this.viewer.checkObjectClicked(n2, n3, n);
                if (map2 != null && (p3 = (P3)map2.get("pt")) != null) {
                    boolean bl2 = map2.get("type").equals("bond");
                    if (bl2) {
                        string3 = PT.simpleReplace(string3, "_BOND", "[{" + map2.get("index") + "}]");
                    }
                    string3 = PT.simpleReplace(string3, "_POINT", Escape.eP(p3));
                    string3 = PT.simpleReplace(string3, "_OBJECT", Escape.escapeMap(map2));
                }
                string3 = PT.simpleReplace(string3, "_BOND", "[{}]");
                string3 = PT.simpleReplace(string3, "_OBJECT", "{}");
            }
            string3 = PT.simpleReplace(string3, "_POINT", "{}");
            string3 = PT.simpleReplace(string3, "_ACTION", "" + n);
            string3 = PT.simpleReplace(string3, "_X", "" + n2);
            string3 = PT.simpleReplace(string3, "_Y", "" + (this.viewer.getScreenHeight() - n3));
            string3 = PT.simpleReplace(string3, "_DELTAX", "" + n4);
            string3 = PT.simpleReplace(string3, "_DELTAY", "" + n5);
            string3 = PT.simpleReplace(string3, "_TIME", "" + l);
            if ((string3 = PT.simpleReplace(string3, "_MODE", "" + n6)).startsWith("+:")) {
                bl = true;
                string3 = string3.substring(2);
            }
            this.viewer.evalStringQuiet(string3);
        }
        return !bl;
    }

    private boolean checkMotionRotateZoom(int n, int n2, int n3, int n4, boolean bl) {
        boolean bl2;
        boolean bl3 = this.checkSlideZoom(n);
        boolean bl4 = this.isBound(n, 25);
        boolean bl5 = this.isBound(n, 29);
        if (!(bl3 || bl4 || bl5)) {
            return false;
        }
        boolean bl6 = bl2 = bl5 && (n3 == 0 || Math.abs(n4) > 5 * Math.abs(n3));
        int n5 = bl2 || this.isZoomArea(this.moved.x) || this.isBound(n, 46) ? 8 : (bl4 || bl5 ? 13 : (this.isBound(n, 1) ? 12 : 0));
        this.setMotion(n5, bl);
        return bl2 || bl3;
    }

    protected float getExitRate() {
        long l = this.dragGesture.getTimeDifference(2);
        return l > 10L ? 0.0f : this.dragGesture.getSpeedPixelsPerMillisecond(4, 2);
    }

    private boolean isRubberBandSelect(int n) {
        n = n & 0xFFFFDFFF | 0x8000;
        return this.rubberbandSelectionMode && (this.isBound(n, 35) || this.isBound(n, 34) || this.isBound(n, 32));
    }

    Rectangle getRubberBand() {
        if (!this.rubberbandSelectionMode || this.rectRubber.x == Integer.MAX_VALUE) {
            return null;
        }
        return this.rectRubber;
    }

    private void calcRectRubberBand() {
        int n;
        int n2 = n = this.viewer.isAntialiased() ? 2 : 1;
        if (this.current.x < this.pressed.x) {
            this.rectRubber.x = this.current.x * n;
            this.rectRubber.width = (this.pressed.x - this.current.x) * n;
        } else {
            this.rectRubber.x = this.pressed.x * n;
            this.rectRubber.width = (this.current.x - this.pressed.x) * n;
        }
        if (this.current.y < this.pressed.y) {
            this.rectRubber.y = this.current.y * n;
            this.rectRubber.height = (this.pressed.y - this.current.y) * n;
        } else {
            this.rectRubber.y = this.pressed.y * n;
            this.rectRubber.height = (this.current.y - this.pressed.y) * n;
        }
    }

    protected float getDegrees(int n, int n2) {
        int n3;
        int n4 = n3 = n2 == 0 ? this.viewer.getScreenWidth() : this.viewer.getScreenHeight();
        if (n3 > 500) {
            n3 = 500;
        }
        return (float)n / (float)n3 * 180.0f * this.mouseDragFactor;
    }

    private boolean checkSlideZoom(int n) {
        return this.isBound(n, 40) && this.isZoomArea(this.pressed.x);
    }

    private boolean isZoomArea(int n) {
        return (float)n > (float)(this.viewer.getScreenWidth() * (this.viewer.isStereoDouble() ? 2 : 1) * 98) / 100.0f;
    }

    private Point3fi getPoint(Map<String, Object> map) {
        Point3fi point3fi = new Point3fi();
        point3fi.setT((P3)map.get("pt"));
        point3fi.modelIndex = (short)((Integer)map.get("modelIndex")).intValue();
        return point3fi;
    }

    private int findNearestAtom(int n, int n2, Point3fi point3fi, boolean bl) {
        int n3 = this.drawMode || point3fi != null ? -1 : this.viewer.findNearestAtomIndexMovable(n, n2, false);
        return n3 >= 0 && (bl || this.measurementPending == null) && !this.viewer.isInSelectionSubset(n3) ? -1 : n3;
    }

    private boolean isSelectAction(int n) {
        return this.isBound(n, 17) || !this.drawMode && !this.labelMode && this.atomPickingMode == 1 && this.isBound(n, 1) || this.dragSelectedMode && (this.isBound(this.dragAction, 27) || this.isBound(this.dragAction, 13)) || this.isBound(n, 22) || this.isBound(n, 35) || this.isBound(n, 32) || this.isBound(n, 34) || this.isBound(n, 36) || this.isBound(n, 30);
    }

    private void enterMeasurementMode(int n) {
        this.viewer.setPicked(-1);
        this.viewer.setPicked(n);
        this.viewer.setCursor(1);
        this.measurementPending = this.viewer.getMP();
        this.viewer.setPendingMeasurement(this.measurementPending);
        this.measurementQueued = this.measurementPending;
    }

    private int addToMeasurement(int n, Point3fi point3fi, boolean bl) {
        if (n == -1 && point3fi == null || this.measurementPending == null) {
            this.exitMeasurementMode();
            return 0;
        }
        int n2 = this.measurementPending.count;
        if (this.measurementPending.traceX != Integer.MIN_VALUE && n2 == 2) {
            n2 = 1;
            this.measurementPending.setCount(1);
        }
        return n2 == 4 && !bl ? n2 : this.measurementPending.addPoint(n, point3fi, true);
    }

    private void resetMeasurement() {
        this.exitMeasurementMode();
        this.measurementQueued = this.viewer.getMP();
    }

    private void exitMeasurementMode() {
        if (this.measurementPending == null) {
            return;
        }
        this.measurementPending = null;
        this.viewer.setPendingMeasurement(null);
        this.viewer.setCursor(0);
    }

    private void getSequence() {
        int n = this.measurementQueued.getAtomIndex(1);
        int n2 = this.measurementQueued.getAtomIndex(2);
        if (n < 0 || n2 < 0) {
            return;
        }
        String string = this.viewer.getSmiles(n, n2, null, true, false, false, false);
        this.viewer.setStatusMeasuring("measureSequence", -2, string, 0.0f);
    }

    private void minimize(boolean bl) {
        this.viewer.stopMinimization();
        int n = this.dragAtomIndex;
        if (bl) {
            this.dragAtomIndex = -1;
        }
        BS bS = this.viewer.getMotionFixedAtoms().cardinality() == 0 ? this.viewer.getAtomBits(this.viewer.isAtomPDB(n) ? 1087373318 : 1095761936, BSUtil.newAndSetBit(n)) : BSUtil.setAll(this.viewer.getAtomCount());
        this.viewer.minimize(Integer.MAX_VALUE, 0.0f, bS, null, 0.0f, false, false, false, false);
    }

    private int queueAtom(int n, Point3fi point3fi) {
        int n2 = this.measurementQueued.addPoint(n, point3fi, true);
        if (n >= 0) {
            this.viewer.setStatusAtomPicked(n, "Atom #" + n2 + ":" + this.viewer.getAtomInfo(n));
        }
        return n2;
    }

    protected void setMotion(int n, boolean bl) {
        switch (this.viewer.getCursor()) {
            case 3: {
                break;
            }
            default: {
                this.viewer.setCursor(n);
            }
        }
        if (bl) {
            this.viewer.setInMotion(true);
        }
    }

    protected void zoomByFactor(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        this.setMotion(8, true);
        this.viewer.zoomByFactor((float)Math.pow(this.mouseWheelFactor, n), n2, n3);
        this.viewer.setInMotion(false);
    }

    private void runScript(String string) {
        this.viewer.script(string);
    }

    private void atomOrPointPicked(int n, Point3fi point3fi) {
        if (n < 0) {
            this.resetMeasurement();
            if (this.isBound(this.clickAction, 33)) {
                this.runScript("select none");
                return;
            }
            if (this.atomPickingMode != 5 && this.atomPickingMode != 6) {
                return;
            }
        }
        int n2 = 2;
        switch (this.atomPickingMode) {
            case 28: 
            case 29: {
                return;
            }
            case 0: {
                return;
            }
            case 8: 
            case 24: 
            case 25: {
                boolean bl = this.atomPickingMode == 8;
                boolean bl2 = this.atomPickingMode == 25;
                if (!this.isBound(this.clickAction, bl ? 5 : 3)) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.count == 0 || this.measurementQueued.count > 2) {
                    this.resetMeasurement();
                    this.enterMeasurementMode(n);
                }
                this.addToMeasurement(n, point3fi, true);
                if (this.queueAtom(n, point3fi) != 2) {
                    return;
                }
                String string = bl || this.measurementQueued.isConnected(this.viewer.getModelSet().atoms, 2) ? " DELETE" : (bl2 ? "STRUTS" : "");
                this.runScript("connect " + this.measurementQueued.getMeasurementScript(" ", true) + string);
                this.resetMeasurement();
                return;
            }
            case 21: {
                ++n2;
            }
            case 20: {
                ++n2;
            }
            case 18: 
            case 19: 
            case 22: {
                if (!this.isBound(this.clickAction, 20)) {
                    return;
                }
                if (this.measurementQueued == null || this.measurementQueued.count == 0 || this.measurementQueued.count > n2) {
                    this.resetMeasurement();
                    this.enterMeasurementMode(n);
                }
                this.addToMeasurement(n, point3fi, true);
                this.queueAtom(n, point3fi);
                int n3 = this.measurementQueued.count;
                if (n3 == 1) {
                    this.viewer.setPicked(-1);
                    this.viewer.setPicked(n);
                }
                if (n3 < n2) {
                    return;
                }
                if (this.atomPickingMode == 22) {
                    this.getSequence();
                } else {
                    this.viewer.setStatusMeasuring("measurePicked", n2, this.measurementQueued.getStringDetail(), this.measurementQueued.value);
                    if (this.atomPickingMode == 18 || this.pickingStyleMeasure == 4) {
                        this.runScript("measure " + this.measurementQueued.getMeasurementScript(" ", true));
                    }
                }
                this.resetMeasurement();
                return;
            }
        }
        int n4 = this.measurementPending != null && this.atomPickingMode != 1 ? 1 : this.atomPickingMode;
        switch (n4) {
            case 3: {
                if (!this.isBound(this.clickAction, 17)) {
                    return;
                }
                if (point3fi == null) {
                    this.zoomTo(n);
                } else {
                    this.runScript("zoomTo " + Escape.eP(point3fi));
                }
                return;
            }
            case 5: 
            case 6: {
                if (!this.isBound(this.clickAction, 17)) break;
                this.checkTwoAtomAction(point3fi, n);
            }
        }
        if (point3fi != null) {
            return;
        }
        switch (n4) {
            case 1: {
                if (!this.drawMode && !this.labelMode && this.isBound(this.clickAction, 1)) {
                    this.zoomTo(n);
                } else if (this.isBound(this.clickAction, 17)) {
                    this.viewer.setStatusAtomPicked(n, null);
                }
                return;
            }
            case 2: {
                if (this.isBound(this.clickAction, 19)) {
                    this.runScript("set labeltoggle {atomindex=" + n + "}");
                    this.viewer.setStatusAtomPicked(n, null);
                }
                return;
            }
            case 31: {
                if (this.isBound(this.clickAction, 0)) {
                    BS bS = this.viewer.getAtomBitSet("connected(atomIndex=" + n + ") and !within(SMARTS,'[r50,R]')");
                    int n5 = bS.cardinality();
                    switch (n5) {
                        case 0: 
                        case 1: {
                            return;
                        }
                        case 2: {
                            break;
                        }
                        case 3: 
                        case 4: {
                            int[] nArray = new int[n5];
                            int[] nArray2 = new int[n5];
                            int n6 = 0;
                            int n7 = bS.nextSetBit(0);
                            while (n7 >= 0) {
                                nArray[n6] = this.viewer.getBranchBitSet(n7, n, true).cardinality();
                                nArray2[n6] = n7;
                                n7 = bS.nextSetBit(n7 + 1);
                                ++n6;
                            }
                            for (n7 = 0; n7 < n5 - 2; ++n7) {
                                int n8 = Integer.MIN_VALUE;
                                int n9 = 0;
                                for (int i = 0; i < n5; ++i) {
                                    if (nArray[i] < n8 || !bS.get(nArray2[i])) continue;
                                    n9 = nArray2[i];
                                    n8 = nArray[i];
                                }
                                bS.clear(n9);
                            }
                            break;
                        }
                    }
                    this.viewer.undoMoveActionClear(n, 2, true);
                    this.viewer.invertSelected(null, null, n, bS);
                    this.viewer.setStatusAtomPicked(n, "inverted: " + Escape.eBS(bS));
                }
                return;
            }
            case 7: {
                if (this.isBound(this.clickAction, 4)) {
                    BS bS = BSUtil.newAndSetBit(n);
                    this.viewer.deleteAtoms(bS, false);
                    this.viewer.setStatusAtomPicked(n, "deleted: " + Escape.eBS(bS));
                }
                return;
            }
        }
        String string = "atomindex=" + n;
        switch (this.atomPickingMode) {
            default: {
                return;
            }
            case 9: {
                this.selectAtoms(string);
                break;
            }
            case 10: {
                this.selectAtoms("within(group, " + string + ")");
                break;
            }
            case 11: {
                this.selectAtoms("within(chain, " + string + ")");
                break;
            }
            case 13: {
                this.selectAtoms("within(polymer, " + string + ")");
                break;
            }
            case 14: {
                this.selectAtoms("within(structure, " + string + ")");
                break;
            }
            case 12: {
                this.selectAtoms("within(molecule, " + string + ")");
                break;
            }
            case 16: {
                this.selectAtoms("within(model, " + string + ")");
                break;
            }
            case 17: {
                this.selectAtoms("visible and within(element, " + string + ")");
                break;
            }
            case 15: {
                this.selectAtoms("visible and within(site, " + string + ")");
            }
        }
        this.viewer.clearClickCount();
        this.viewer.setStatusAtomPicked(n, null);
    }

    private void assignNew(int n, int n2) {
        if (this.measurementPending.count == 2) {
            this.viewer.undoMoveActionClear(-1, 4146, true);
            this.runScript("assign connect " + this.measurementPending.getMeasurementScript(" ", false));
        } else if (this.pickAtomAssignType.equals("Xx")) {
            this.exitMeasurementMode();
            this.viewer.refresh(3, "bond dropped");
        } else if (this.pressed.inRange(this.xyRange, this.dragged.x, this.dragged.y)) {
            String string = "assign atom ({" + this.dragAtomIndex + "}) \"" + this.pickAtomAssignType + "\"";
            if (this.isPickAtomAssignCharge) {
                string = string + ";{atomindex=" + this.dragAtomIndex + "}.label='%C'; ";
                this.viewer.undoMoveActionClear(this.dragAtomIndex, 4, true);
            } else {
                this.viewer.undoMoveActionClear(-1, 4146, true);
            }
            this.runScript(string);
        } else if (!this.isPickAtomAssignCharge) {
            this.viewer.undoMoveActionClear(-1, 4146, true);
            Atom atom = this.viewer.getModelSet().atoms[this.dragAtomIndex];
            if (atom.getElementNumber() == 1) {
                this.runScript("assign atom ({" + this.dragAtomIndex + "}) \"X\"");
            } else {
                P3 p3 = P3.new3(n, n2, atom.sZ);
                this.viewer.unTransformPoint(p3, p3);
                this.runScript("assign atom ({" + this.dragAtomIndex + "}) \"" + this.pickAtomAssignType + "\" " + Escape.eP(p3));
            }
        }
        this.exitMeasurementMode();
    }

    private void bondPicked(int n) {
        if (this.bondPickingMode == 33) {
            this.viewer.undoMoveActionClear(-1, 4146, true);
        }
        switch (this.bondPickingMode) {
            case 33: {
                this.runScript("assign bond [{" + n + "}] \"" + this.pickBondAssignType + "\"");
                break;
            }
            case 34: {
                this.viewer.setRotateBondIndex(n);
                break;
            }
            case 8: {
                this.viewer.deleteBonds(BSUtil.newAndSetBit(n));
            }
        }
    }

    private void checkTwoAtomAction(Point3fi point3fi, int n) {
        int n2;
        boolean bl;
        boolean bl2 = bl = this.atomPickingMode == 5;
        if (this.viewer.getSpinOn() || this.viewer.getNavOn() || this.viewer.getPendingMeasurement() != null) {
            this.resetMeasurement();
            if (this.viewer.getSpinOn()) {
                this.runScript("spin off");
            }
            return;
        }
        if (this.measurementQueued.count >= 2) {
            this.resetMeasurement();
        }
        if ((n2 = this.measurementQueued.count) == 1 && (point3fi == null ? this.measurementQueued.getAtomIndex(1) == n : this.measurementQueued.getAtom(1).distance(point3fi) == 0.0f)) {
            return;
        }
        if (n >= 0 || point3fi != null) {
            n2 = this.queueAtom(n, point3fi);
        }
        if (n2 < 2) {
            if (bl) {
                this.viewer.scriptStatus(n2 == 1 ? GT._("pick one more atom in order to spin the model around an axis") : GT._("pick two atoms in order to spin the model around an axis"));
            } else {
                this.viewer.scriptStatus(n2 == 1 ? GT._("pick one more atom in order to display the symmetry relationship") : GT._("pick two atoms in order to display the symmetry relationship between them"));
            }
            return;
        }
        String string = this.measurementQueued.getMeasurementScript(" ", false);
        if (bl) {
            this.runScript("spin" + string + " " + this.viewer.getInt(553648157));
        } else {
            this.runScript("draw symop" + string + ";show symop" + string);
        }
    }

    private void reset() {
        this.runScript("!reset");
    }

    private void selectAtoms(String string) {
        String string2;
        if (this.measurementPending != null || this.selectionWorking) {
            return;
        }
        this.selectionWorking = true;
        String string3 = this.rubberbandSelectionMode || this.isBound(this.clickAction, 35) ? "selected and not (" + string + ") or (not selected) and " : (this.isBound(this.clickAction, 32) ? "selected and not " : (this.isBound(this.clickAction, 34) ? "selected or " : (this.clickAction == 0 || this.isBound(this.clickAction, 36) ? "selected tog " : (string2 = this.isBound(this.clickAction, 30) ? "" : null))));
        if (string2 != null) {
            string2 = string2 + "(" + string + ")";
            try {
                BS bS = this.viewer.getAtomBitSetEval(null, string2);
                this.viewer.select(bS, false, 0, false);
                this.viewer.refresh(3, "selections set");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.selectionWorking = false;
    }

    private void selectRb(int n) {
        BS bS = this.viewer.findAtomsInRectangle(this.rectRubber);
        if (bS.length() > 0) {
            String string = Escape.eBS(bS);
            if (this.isBound(n, 34)) {
                this.runScript("selectionHalos on;select selected or " + string);
            } else if (this.isBound(n, 32)) {
                this.runScript("selectionHalos on;select selected and not " + string);
            } else {
                this.runScript("selectionHalos on;select selected tog " + string);
            }
        }
        this.viewer.refresh(3, "mouseReleased");
    }

    private void toggleMeasurement() {
        if (this.measurementPending == null) {
            return;
        }
        int n = this.measurementPending.count;
        if (n >= 2 && n <= 4) {
            this.runScript("!measure " + this.measurementPending.getMeasurementScript(" ", true));
        }
        this.exitMeasurementMode();
    }

    private void zoomTo(int n) {
        this.runScript("zoomTo (atomindex=" + n + ")");
        this.viewer.setStatusAtomPicked(n, null);
    }

    @Override
    public boolean keyTyped(int n, int n2) {
        return false;
    }

    static {
        ActionManager.newAction(0, "_assignNew", GT.o(GT._("assign/new atom or bond (requires {0})"), "set picking assignAtom_??/assignBond_?"));
        ActionManager.newAction(1, "_center", GT._("center"));
        ActionManager.newAction(2, "_clickFrank", GT._("pop up recent context menu (click on Jmol frank)"));
        ActionManager.newAction(4, "_deleteAtom", GT.o(GT._("delete atom (requires {0})"), "set picking DELETE ATOM"));
        ActionManager.newAction(5, "_deleteBond", GT.o(GT._("delete bond (requires {0})"), "set picking DELETE BOND"));
        ActionManager.newAction(6, "_depth", GT.o(GT._("adjust depth (back plane; requires {0})"), "SLAB ON"));
        ActionManager.newAction(7, "_dragAtom", GT.o(GT._("move atom (requires {0})"), "set picking DRAGATOM"));
        ActionManager.newAction(8, "_dragDrawObject", GT.o(GT._("move whole DRAW object (requires {0})"), "set picking DRAW"));
        ActionManager.newAction(9, "_dragDrawPoint", GT.o(GT._("move specific DRAW point (requires {0})"), "set picking DRAW"));
        ActionManager.newAction(10, "_dragLabel", GT.o(GT._("move label (requires {0})"), "set picking LABEL"));
        ActionManager.newAction(11, "_dragMinimize", GT.o(GT._("move atom and minimize molecule (requires {0})"), "set picking DRAGMINIMIZE"));
        ActionManager.newAction(12, "_dragMinimizeMolecule", GT.o(GT._("move and minimize molecule (requires {0})"), "set picking DRAGMINIMIZEMOLECULE"));
        ActionManager.newAction(13, "_dragSelected", GT.o(GT._("move selected atoms (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(14, "_dragZ", GT.o(GT._("drag atoms in Z direction (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(15, "_multiTouchSimulation", GT._("simulate multi-touch using the mouse)"));
        ActionManager.newAction(16, "_navTranslate", GT.o(GT._("translate navigation point (requires {0} and {1})"), new String[]{"set NAVIGATIONMODE", "set picking NAVIGATE"}));
        ActionManager.newAction(17, "_pickAtom", GT._("pick an atom"));
        ActionManager.newAction(3, "_pickConnect", GT.o(GT._("connect atoms (requires {0})"), "set picking CONNECT"));
        ActionManager.newAction(18, "_pickIsosurface", GT.o(GT._("pick an ISOSURFACE point (requires {0}"), "set DRAWPICKING"));
        ActionManager.newAction(19, "_pickLabel", GT.o(GT._("pick a label to toggle it hidden/displayed (requires {0})"), "set picking LABEL"));
        ActionManager.newAction(20, "_pickMeasure", GT.o(GT._("pick an atom to include it in a measurement (after starting a measurement or after {0})"), "set picking DISTANCE/ANGLE/TORSION"));
        ActionManager.newAction(21, "_pickNavigate", GT.o(GT._("pick a point or atom to navigate to (requires {0})"), "set NAVIGATIONMODE"));
        ActionManager.newAction(22, "_pickPoint", GT.o(GT._("pick a DRAW point (for measurements) (requires {0}"), "set DRAWPICKING"));
        ActionManager.newAction(23, "_popupMenu", GT._("pop up the full context menu"));
        ActionManager.newAction(24, "_reset", GT._("reset (when clicked off the model)"));
        ActionManager.newAction(25, "_rotate", GT._("rotate"));
        ActionManager.newAction(26, "_rotateBranch", GT.o(GT._("rotate branch around bond (requires {0})"), "set picking ROTATEBOND"));
        ActionManager.newAction(27, "_rotateSelected", GT.o(GT._("rotate selected atoms (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(28, "_rotateZ", GT._("rotate Z"));
        ActionManager.newAction(29, "_rotateZorZoom", GT._("rotate Z (horizontal motion of mouse) or zoom (vertical motion of mouse)"));
        ActionManager.newAction(30, "_select", GT.o(GT._("select an atom (requires {0})"), "set pickingStyle EXTENDEDSELECT"));
        ActionManager.newAction(31, "_selectAndDrag", GT.o(GT._("select and drag atoms (requires {0})"), "set DRAGSELECTED"));
        ActionManager.newAction(32, "_selectAndNot", GT.o(GT._("unselect this group of atoms (requires {0})"), "set pickingStyle DRAG/EXTENDEDSELECT"));
        ActionManager.newAction(33, "_selectNone", GT.o(GT._("select NONE (requires {0})"), "set pickingStyle EXTENDEDSELECT"));
        ActionManager.newAction(34, "_selectOr", GT.o(GT._("add this group of atoms to the set of selected atoms (requires {0})"), "set pickingStyle DRAG/EXTENDEDSELECT"));
        ActionManager.newAction(35, "_selectToggle", GT.o(GT._("toggle selection (requires {0})"), "set pickingStyle DRAG/EXTENDEDSELECT/RASMOL"));
        ActionManager.newAction(36, "_selectToggleOr", GT.o(GT._("if all are selected, unselect all, otherwise add this group of atoms to the set of selected atoms (requires {0})"), "set pickingStyle DRAG"));
        ActionManager.newAction(37, "_setMeasure", GT._("pick an atom to initiate or conclude a measurement"));
        ActionManager.newAction(38, "_slab", GT.o(GT._("adjust slab (front plane; requires {0})"), "SLAB ON"));
        ActionManager.newAction(39, "_slabAndDepth", GT.o(GT._("move slab/depth window (both planes; requires {0})"), "SLAB ON"));
        ActionManager.newAction(40, "_slideZoom", GT._("zoom (along right edge of window)"));
        ActionManager.newAction(41, "_spinDrawObjectCCW", GT.o(GT._("click on two points to spin around axis counterclockwise (requires {0})"), "set picking SPIN"));
        ActionManager.newAction(42, "_spinDrawObjectCW", GT.o(GT._("click on two points to spin around axis clockwise (requires {0})"), "set picking SPIN"));
        ActionManager.newAction(43, "_stopMotion", GT.o(GT._("stop motion (requires {0})"), "set waitForMoveTo FALSE"));
        ActionManager.newAction(44, "_swipe", GT._("spin model (swipe and release button and stop motion simultaneously)"));
        ActionManager.newAction(45, "_translate", GT._("translate"));
        ActionManager.newAction(46, "_wheelZoom", GT._("zoom"));
        pickingModeNames = new String[]{"off", "identify", "label", "center", "draw", "spin", "symmetry", "deleteatom", "deletebond", "atom", "group", "chain", "molecule", "polymer", "structure", "site", "model", "element", "measure", "distance", "angle", "torsion", "sequence", "navigate", "connect", "struts", "dragselected", "dragmolecule", "dragatom", "dragminimize", "dragminimizemolecule", "invertstereo", "assignatom", "assignbond", "rotatebond", "identifybond", "dragligand"};
        pickingStyleNames = new String[]{"toggle", "selectOrToggle", "extendedSelect", "drag", "measure", "measureoff"};
    }

    public class Gesture {
        private int action;
        MotionPoint[] nodes;
        private int ptNext;
        private long time0;

        Gesture(int n) {
            this.nodes = new MotionPoint[n];
            for (int i = 0; i < n; ++i) {
                this.nodes[i] = new MotionPoint();
            }
        }

        void setAction(int n, long l) {
            this.action = n;
            this.ptNext = 0;
            this.time0 = l;
            for (int i = 0; i < this.nodes.length; ++i) {
                this.nodes[i].index = -1;
            }
        }

        int add(int n, int n2, int n3, long l) {
            this.action = n;
            this.getNode(this.ptNext).set(this.ptNext, n2, n3, l - this.time0);
            ++this.ptNext;
            return this.ptNext;
        }

        public long getTimeDifference(int n) {
            if ((n = this.getPointCount2(n, 0)) < 2) {
                return 0L;
            }
            MotionPoint motionPoint = this.getNode(this.ptNext - 1);
            MotionPoint motionPoint2 = this.getNode(this.ptNext - n);
            return motionPoint.time - motionPoint2.time;
        }

        public float getSpeedPixelsPerMillisecond(int n, int n2) {
            if ((n = this.getPointCount2(n, n2)) < 2) {
                return 0.0f;
            }
            MotionPoint motionPoint = this.getNode(this.ptNext - 1 - n2);
            MotionPoint motionPoint2 = this.getNode(this.ptNext - n - n2);
            float f = (float)(motionPoint.x - motionPoint2.x) / (float)ActionManager.this.viewer.getScreenWidth() * 360.0f;
            float f2 = (float)(motionPoint.y - motionPoint2.y) / (float)ActionManager.this.viewer.getScreenHeight() * 360.0f;
            return (float)Math.sqrt(f * f + f2 * f2) / (float)(motionPoint.time - motionPoint2.time);
        }

        int getDX(int n, int n2) {
            if ((n = this.getPointCount2(n, n2)) < 2) {
                return 0;
            }
            MotionPoint motionPoint = this.getNode(this.ptNext - 1 - n2);
            MotionPoint motionPoint2 = this.getNode(this.ptNext - n - n2);
            return motionPoint.x - motionPoint2.x;
        }

        int getDY(int n, int n2) {
            if ((n = this.getPointCount2(n, n2)) < 2) {
                return 0;
            }
            MotionPoint motionPoint = this.getNode(this.ptNext - 1 - n2);
            MotionPoint motionPoint2 = this.getNode(this.ptNext - n - n2);
            return motionPoint.y - motionPoint2.y;
        }

        int getPointCount() {
            return this.ptNext;
        }

        private int getPointCount2(int n, int n2) {
            if (n > this.nodes.length - n2) {
                n = this.nodes.length - n2;
            }
            int n3 = n + 1;
            while (--n3 >= 0 && this.getNode((int)(this.ptNext - n3 - n2)).index < 0) {
            }
            return n3;
        }

        MotionPoint getNode(int n) {
            return this.nodes[(n + this.nodes.length + this.nodes.length) % this.nodes.length];
        }

        public String toString() {
            if (this.nodes.length == 0) {
                return "" + this;
            }
            return Binding.getMouseActionName(this.action, false) + " nPoints = " + this.ptNext + " " + this.nodes[0];
        }
    }

    protected class MotionPoint {
        int index;
        int x;
        int y;
        long time;

        protected MotionPoint() {
        }

        void set(int n, int n2, int n3, long l) {
            this.index = n;
            this.x = n2;
            this.y = n3;
            this.time = l;
        }

        public String toString() {
            return "[x = " + this.x + " y = " + this.y + " time = " + this.time + " ]";
        }
    }
}

