/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.A4;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.api.Interface;
import org.jmol.api.JmolNavigatorInterface;
import org.jmol.api.JmolScriptEvaluator;
import org.jmol.constant.EnumStereoMode;
import org.jmol.java.BS;
import org.jmol.thread.JmolThread;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Point3fi;
import org.jmol.util.Quaternion;
import org.jmol.util.Vibration;
import org.jmol.viewer.Viewer;

public class TransformManager {
    Viewer viewer;
    public static final double degreesPerRadian = 57.29577951308232;
    static final int DEFAULT_NAV_FPS = 10;
    protected int perspectiveModel = 11;
    protected float cameraScaleFactor;
    public float referencePlaneOffset;
    protected float aperatureAngle;
    protected float cameraDistanceFromCenter;
    public float modelCenterOffset;
    public float modelRadius;
    public float modelRadiusPixels;
    public final P3 navigationCenter = new P3();
    public final P3 navigationOffset = new P3();
    public final P3 navigationShiftXY = new P3();
    public float navigationDepth;
    protected final M4 matrixTemp = new M4();
    protected final V3 vectorTemp = new V3();
    protected boolean haveNotifiedNaN = false;
    static final int DEFAULT_SPIN_Y = 30;
    static final int DEFAULT_SPIN_FPS = 30;
    public float spinX;
    public float spinY = 30.0f;
    public float spinZ;
    public float spinFps = 30.0f;
    public float navX;
    public float navY;
    public float navZ;
    public float navFps = Float.NaN;
    public boolean isSpinInternal = false;
    public boolean isSpinFixed = false;
    boolean isSpinSelected = false;
    public final P3 fixedRotationOffset = new P3();
    public final P3 fixedRotationCenter = new P3();
    protected final P3 perspectiveOffset = new P3();
    protected final P3 perspectiveShiftXY = new P3();
    private final P3 rotationCenterDefault = new P3();
    private float rotationRadiusDefault;
    public final A4 fixedRotationAxis = new A4();
    public final A4 internalRotationAxis = new A4();
    protected V3 internalTranslation;
    final P3 internalRotationCenter = P3.new3(0.0f, 0.0f, 0.0f);
    private float internalRotationAngle = 0.0f;
    protected final M3 matrixRotate = new M3();
    private final M3 matrixTemp3 = new M3();
    private final M4 matrixTemp4 = new M4();
    private final A4 axisangleT = new A4();
    private final V3 vectorT = new V3();
    private final V3 vectorT2 = new V3();
    private final P3 pointT2 = new P3();
    static final int MAXIMUM_ZOOM_PERCENTAGE = 200000;
    static final int MAXIMUM_ZOOM_PERSPECTIVE_DEPTH = 10000;
    V3 rotationAxis = new V3();
    float rotationRate = 0.0f;
    final V3 arcBall0 = new V3();
    final V3 arcBall1 = new V3();
    final V3 arcBallAxis = new V3();
    final M3 arcBall0Rotation = new M3();
    public final P3 fixedTranslation = new P3();
    public final P3 camera = new P3();
    public final P3 cameraSetting = new P3();
    float xTranslationFraction = 0.5f;
    float yTranslationFraction = 0.5f;
    protected float prevZoomSetting;
    public float previousX;
    public float previousY;
    boolean zoomEnabled = true;
    public float zoomPercent = 100.0f;
    float zoomPercentSetting = 100.0f;
    float zoomRatio;
    public boolean slabEnabled = false;
    boolean internalSlab = false;
    boolean zShadeEnabled = false;
    int slabPercentSetting;
    int depthPercentSetting;
    public int zSlabPercentSetting = 50;
    public int zDepthPercentSetting = 0;
    P3 zSlabPoint;
    public int slabValue;
    public int depthValue;
    public int zSlabValue;
    int zDepthValue;
    float slabRange = 0.0f;
    P4 slabPlane = null;
    P4 depthPlane = null;
    protected boolean perspectiveDepth = true;
    protected boolean scale3D = false;
    protected float cameraDepth = 3.0f;
    protected float cameraDepthSetting = 3.0f;
    protected float visualRange;
    protected float cameraDistance = 1000.0f;
    public int width;
    public int height;
    public int screenPixelCount;
    float scalePixelsPerAngstrom;
    public float scaleDefaultPixelsPerAngstrom;
    float scale3DAngstromsPerInch;
    protected boolean antialias;
    private boolean useZoomLarge;
    private boolean zoomHeight;
    int screenWidth;
    int screenHeight;
    public final M4 matrixTransform = new M4();
    public final M4 matrixTransformInv = new M4();
    protected final P3 point3fScreenTemp = new P3();
    protected final P3i point3iScreenTemp = new P3i();
    private final Point3fi ptVibTemp = new Point3fi();
    public boolean navigating = false;
    protected static final int MODE_STANDARD = 0;
    public static final int MODE_NAVIGATION = 1;
    protected static final int MODE_PERSPECTIVE_PYMOL = 2;
    static final int DEFAULT_PERSPECTIVE_MODEL = 11;
    public int mode = 0;
    public int defaultMode = 0;
    private final P3 pointTsp = new P3();
    protected final P3 untransformedPoint = new P3();
    protected final P3 ptTest1 = new P3();
    protected final P3 ptTest2 = new P3();
    protected final P3 ptTest3 = new P3();
    protected final A4 aaTest1 = new A4();
    protected final M3 matrixTest = new M3();
    public JmolThread motion;
    public boolean spinOn;
    public boolean navOn;
    private JmolThread spinThread;
    private boolean spinIsGesture;
    boolean vibrationOn;
    float vibrationPeriod;
    public int vibrationPeriodMs;
    private float vibrationScale;
    private P3 vibrationT = new P3();
    private JmolThread vibrationThread;
    EnumStereoMode stereoMode = EnumStereoMode.NONE;
    int[] stereoColors;
    float stereoDegrees = Float.NaN;
    float stereoRadians;
    boolean stereoFrame;
    protected final M3 matrixStereo = new M3();
    public boolean windowCentered;
    P3[] frameOffsets;
    final P3 frameOffset = new P3();
    BS bsSelectedAtoms;
    P3 ptOffset = new P3();
    public static final int NAV_MODE_IGNORE = -2;
    public static final int NAV_MODE_ZOOMED = -1;
    public static final int NAV_MODE_NONE = 0;
    public static final int NAV_MODE_RESET = 1;
    public static final int NAV_MODE_NEWXY = 2;
    public static final int NAV_MODE_NEWXYZ = 3;
    public static final int NAV_MODE_NEWZ = 4;
    public int navMode = 1;
    public float zoomFactor = Float.MAX_VALUE;
    public float navigationSlabOffset;
    private JmolNavigatorInterface nav;

    TransformManager(Viewer viewer, int n, int n2) {
        this.setViewer(viewer, n, n2);
    }

    private void setViewer(Viewer viewer, int n, int n2) {
        this.viewer = viewer;
        this.setScreenParameters(n, n2, true, false, true, true);
    }

    public void homePosition(boolean bl) {
        if (bl) {
            this.setSpinOff();
        }
        this.setNavOn(false);
        this.navFps = 10.0f;
        this.navZ = 0.0f;
        this.navY = 0.0f;
        this.navX = 0.0f;
        this.rotationCenterDefault.setT(this.viewer.getBoundBoxCenter());
        this.setFixedRotationCenter(this.rotationCenterDefault);
        this.rotationRadiusDefault = this.setRotationRadius(0.0f, true);
        this.windowCentered = true;
        this.setRotationCenterAndRadiusXYZ(null, true);
        this.matrixRotate.setIdentity();
        M3 m3 = (M3)this.viewer.getModelSetAuxiliaryInfoValue("defaultOrientationMatrix");
        if (m3 != null) {
            this.matrixRotate.setM(m3);
        }
        this.setZoomEnabled(true);
        this.zoomToPercent(this.viewer.global.modelKitMode ? 50.0f : 100.0f);
        this.zoomPercent = this.zoomPercentSetting;
        this.slabReset();
        this.resetFitToScreen(true);
        if (this.viewer.isJmolDataFrame()) {
            this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
        } else if (this.viewer.global.axesOrientationRasmol) {
            this.rotateX((float)Math.PI);
        }
        this.viewer.saveOrientation("default", null);
        if (this.mode == 1) {
            this.setNavigationMode(true);
        }
    }

    void clear() {
        this.clearVibration();
        this.clearSpin();
        this.stopMotion();
        this.fixedRotationCenter.set(0.0f, 0.0f, 0.0f);
        this.navigating = false;
        this.slabPlane = null;
        this.depthPlane = null;
        this.zSlabPoint = null;
        this.resetNavigationPoint(true);
    }

    private void setFixedRotationCenter(P3 p3) {
        if (p3 == null) {
            return;
        }
        this.fixedRotationCenter.setT(p3);
    }

    void setRotationPointXY(P3 p3) {
        P3i p3i = this.transformPoint(p3);
        this.fixedTranslation.set(p3i.x, p3i.y, 0.0f);
    }

    void spinXYBy(int n, int n2, float f) {
        if (n == 0 && n2 == 0) {
            if (this.spinThread != null && this.spinIsGesture) {
                this.clearSpin();
            }
            return;
        }
        this.clearSpin();
        P3 p3 = P3.newP(this.fixedRotationCenter);
        P3 p32 = new P3();
        this.transformPoint2(p3, p32);
        P3 p33 = P3.new3(-n2, n, 0.0f);
        p33.add(p32);
        this.unTransformPoint(p33, p33);
        this.viewer.setInMotion(false);
        this.rotateAboutPointsInternal(null, p33, p3, 10.0f * f, Float.NaN, false, true, null, true, null, null, null);
    }

    void rotateArcBall(float f, float f2, float f3) {
        float f4;
        float f5 = (this.screenPixelCount >> 2) * this.screenPixelCount;
        f4 = (float)((f4 = f5 - (f -= this.fixedTranslation.x) * f - (f2 -= this.fixedTranslation.y) * f2) < 0.0f ? -1 : 1) * (float)Math.sqrt(Math.abs(f4));
        if (f3 == 0.0f) {
            this.arcBall0Rotation.setM(this.matrixRotate);
            this.arcBall0.set(f, -f2, f4);
            if (!Float.isNaN(f4)) {
                this.arcBall0.normalize();
            }
            return;
        }
        if (Float.isNaN(this.arcBall0.z) || Float.isNaN(f4)) {
            return;
        }
        this.arcBall1.set(f, -f2, f4);
        this.arcBall1.normalize();
        this.arcBallAxis.cross(this.arcBall0, this.arcBall1);
        this.axisangleT.setVA(this.arcBallAxis, f3 * (float)Math.acos(this.arcBall0.dot(this.arcBall1)));
        this.matrixRotate.setM(this.arcBall0Rotation);
        this.rotateAxisAngle2(this.axisangleT, null);
    }

    void rotateXYBy(float f, float f2, BS bS) {
        this.rotateXRadians(f2 * ((float)Math.PI / 180), bS);
        this.rotateYRadians(f * ((float)Math.PI / 180), bS);
    }

    void rotateZBy(int n, int n2, int n3) {
        if (n2 != Integer.MAX_VALUE && n3 != Integer.MAX_VALUE) {
            this.resetXYCenter(n2, n3);
        }
        this.rotateZRadians((float)((double)n / 57.29577951308232));
    }

    void rotateFront() {
        this.matrixRotate.setIdentity();
    }

    void rotateX(float f) {
        this.matrixRotate.rotX(f);
    }

    void rotateY(float f) {
        this.matrixRotate.rotY(f);
    }

    void rotateZ(float f) {
        this.matrixRotate.rotZ(f);
    }

    private void applyRotation(M3 m3, boolean bl, BS bS, V3 v3, boolean bl2) {
        if (bS == null) {
            this.matrixRotate.mul2(m3, this.matrixRotate);
            return;
        }
        this.viewer.moveAtoms(m3, this.matrixRotate, v3, this.internalRotationCenter, bl, bS, bl2);
        if (v3 != null) {
            this.internalRotationCenter.add(v3);
        }
    }

    public synchronized void rotateXRadians(float f, BS bS) {
        this.matrixTemp3.rotX(f);
        this.applyRotation(this.matrixTemp3, false, bS, null, false);
    }

    public synchronized void rotateYRadians(float f, BS bS) {
        this.matrixTemp3.rotY(f);
        this.applyRotation(this.matrixTemp3, false, bS, null, false);
    }

    public synchronized void rotateZRadians(float f) {
        this.matrixTemp3.rotZ(f);
        this.applyRotation(this.matrixTemp3, false, null, null, false);
    }

    public void rotateAxisAngle(V3 v3, float f) {
        this.axisangleT.setVA(v3, f);
        this.rotateAxisAngle2(this.axisangleT, null);
    }

    private synchronized void rotateAxisAngle2(A4 a4, BS bS) {
        this.matrixTemp3.setAA(a4);
        this.applyRotation(this.matrixTemp3, false, bS, null, false);
    }

    boolean rotateAxisAngleAtCenter(JmolScriptEvaluator jmolScriptEvaluator, P3 p3, V3 v3, float f, float f2, boolean bl, BS bS) {
        if (p3 != null) {
            this.moveRotationCenter(p3, true);
        }
        this.setSpinOff();
        this.setNavOn(false);
        if (this.viewer.isHeadless()) {
            if (bl && f2 == Float.MAX_VALUE) {
                return false;
            }
            bl = false;
        }
        if (Float.isNaN(f) || f == 0.0f || f2 == 0.0f) {
            return false;
        }
        if (p3 != null) {
            this.setRotationPointXY(p3);
        }
        this.setFixedRotationCenter(p3);
        this.rotationAxis.setT(v3);
        this.rotationRate = f;
        if (bl) {
            this.fixedRotationAxis.setVA(v3, f * ((float)Math.PI / 180));
            this.isSpinInternal = false;
            this.isSpinFixed = true;
            this.isSpinSelected = bS != null;
            this.setSpin(jmolScriptEvaluator, true, f2, null, null, bS, false);
            return false;
        }
        float f3 = f2 * ((float)Math.PI / 180);
        this.fixedRotationAxis.setVA(v3, f2);
        this.rotateAxisAngleRadiansFixed(f3, bS);
        return true;
    }

    public synchronized void rotateAxisAngleRadiansFixed(float f, BS bS) {
        this.axisangleT.setAA(this.fixedRotationAxis);
        this.axisangleT.angle = f;
        this.rotateAxisAngle2(this.axisangleT, bS);
    }

    boolean rotateAboutPointsInternal(JmolScriptEvaluator jmolScriptEvaluator, P3 p3, P3 p32, float f, float f2, boolean bl, boolean bl2, BS bS, boolean bl3, V3 v3, List<P3> list, float[] fArray) {
        boolean bl4;
        this.setSpinOff();
        this.setNavOn(false);
        if (this.viewer.isHeadless()) {
            if (bl2 && f2 == Float.MAX_VALUE) {
                return false;
            }
            bl2 = false;
        }
        if (!(fArray != null || v3 != null && !((double)v3.length() < 0.001) || bl2 && f2 != 0.0f && !Float.isNaN(f) && f != 0.0f || !bl2 && f2 != 0.0f)) {
            return false;
        }
        V3 v32 = null;
        if (fArray == null) {
            v32 = V3.newVsub(p32, p3);
            if (bl) {
                v32.scale(-1.0f);
            }
            this.internalRotationCenter.setT(p3);
            this.rotationAxis.setT(v32);
            this.internalTranslation = v3 == null ? null : V3.newV(v3);
        }
        boolean bl5 = bl4 = bS != null;
        if (bl2) {
            if (fArray == null) {
                int n = (int)((double)(Math.abs(f2) / Math.abs(f) * this.spinFps) + 0.5);
                if (Float.isNaN(f2)) {
                    this.rotationRate = f;
                } else {
                    this.rotationRate = f = f2 / (float)n * this.spinFps;
                    if (v3 != null) {
                        this.internalTranslation.scale(1.0f / (float)n);
                    }
                }
                this.internalRotationAxis.setVA(v32, (Float.isNaN(this.rotationRate) ? 0.0f : this.rotationRate) * ((float)Math.PI / 180));
                this.isSpinInternal = true;
                this.isSpinFixed = false;
                this.isSpinSelected = bl4;
            } else {
                f2 = f;
            }
            this.setSpin(jmolScriptEvaluator, true, f2, list, fArray, bS, bl3);
            return fArray != null || bS != null;
        }
        float f3 = f2 * ((float)Math.PI / 180);
        this.internalRotationAxis.setVA(v32, f3);
        this.rotateAxisAngleRadiansInternal(f3, bS);
        return false;
    }

    public synchronized void rotateAxisAngleRadiansInternal(float f, BS bS) {
        this.internalRotationAngle = f;
        this.vectorT.set(this.internalRotationAxis.x, this.internalRotationAxis.y, this.internalRotationAxis.z);
        this.matrixRotate.transform2(this.vectorT, this.vectorT2);
        this.axisangleT.setVA(this.vectorT2, f);
        this.matrixTemp3.setAA(this.axisangleT);
        this.applyRotation(this.matrixTemp3, true, bS, this.internalTranslation, f > 1000000.0f);
        if (bS == null) {
            this.getNewFixedRotationCenter();
        }
    }

    void getNewFixedRotationCenter() {
        this.axisangleT.setAA(this.internalRotationAxis);
        this.axisangleT.angle = -this.internalRotationAngle;
        this.matrixTemp4.setAA(this.axisangleT);
        this.vectorT.setT(this.internalRotationCenter);
        this.pointT2.sub2(this.fixedRotationCenter, this.vectorT);
        P3 p3 = new P3();
        this.matrixTemp4.transform2(this.pointT2, p3);
        p3.add(this.vectorT);
        this.setRotationCenterAndRadiusXYZ(p3, false);
    }

    void setTranslationFractions() {
        this.xTranslationFraction = this.fixedTranslation.x / (float)this.width;
        this.yTranslationFraction = this.fixedTranslation.y / (float)this.height;
    }

    public void centerAt(int n, int n2, P3 p3) {
        if (p3 == null) {
            this.translateXYBy(n, n2);
            return;
        }
        if (this.windowCentered) {
            this.viewer.setBooleanProperty("windowCentered", false);
        }
        this.fixedTranslation.x = n;
        this.fixedTranslation.y = n2;
        this.setFixedRotationCenter(p3);
    }

    int percentToPixels(char c, float f) {
        switch (c) {
            case 'x': {
                return (int)Math.floor(f / 100.0f * (float)this.width);
            }
            case 'y': {
                return (int)Math.floor(f / 100.0f * (float)this.height);
            }
            case 'z': {
                return (int)Math.floor(f / 100.0f * (float)this.screenPixelCount);
            }
        }
        return 0;
    }

    int angstromsToPixels(float f) {
        return (int)Math.floor(this.scalePixelsPerAngstrom * f);
    }

    void translateXYBy(int n, int n2) {
        this.fixedTranslation.x += (float)n;
        this.fixedTranslation.y += (float)n2;
        this.setTranslationFractions();
    }

    public void setCamera(float f, float f2) {
        this.cameraSetting.set(f, f2, f != 0.0f || f2 != 0.0f ? 1 : 0);
    }

    public void translateToPercent(char c, float f) {
        switch (c) {
            case 'x': {
                this.xTranslationFraction = 0.5f + f / 100.0f;
                this.fixedTranslation.x = (float)this.width * this.xTranslationFraction;
                return;
            }
            case 'y': {
                this.yTranslationFraction = 0.5f + f / 100.0f;
                this.fixedTranslation.y = (float)this.height * this.yTranslationFraction;
                return;
            }
            case 'z': {
                if (this.mode == 1) {
                    this.setNavigationDepthPercent(f);
                }
                return;
            }
        }
    }

    public float getTranslationXPercent() {
        return this.width == 0 ? 0.0f : (this.fixedTranslation.x - (float)this.width / 2.0f) * 100.0f / (float)this.width;
    }

    public float getTranslationYPercent() {
        return this.height == 0 ? 0.0f : (this.fixedTranslation.y - (float)this.height / 2.0f) * 100.0f / (float)this.height;
    }

    public float getTranslationZPercent() {
        return 0.0f;
    }

    String getTranslationScript() {
        String string = "";
        float f = this.getTranslationXPercent();
        if ((double)f != 0.0) {
            string = string + "translate x " + f + ";";
        }
        if ((double)(f = this.getTranslationYPercent()) != 0.0) {
            string = string + "translate y " + f + ";";
        }
        return string;
    }

    String getOrientationText(int n) {
        switch (n) {
            case 4130: {
                return this.getMoveToText(1.0f, false);
            }
            case 1073742132: {
                return this.getRotationQuaternion().toString();
            }
            case 1073742178: {
                SB sB = new SB();
                TransformManager.truncate2(sB, this.getTranslationXPercent());
                TransformManager.truncate2(sB, this.getTranslationYPercent());
                return sB.toString();
            }
        }
        return this.getMoveToText(1.0f, true) + "\n#OR\n" + this.getRotateZyzText(true);
    }

    Map<String, Object> getOrientationInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("moveTo", this.getMoveToText(1.0f, false));
        hashtable.put("center", "center " + this.getCenterText());
        hashtable.put("centerPt", this.fixedRotationCenter);
        A4 a4 = new A4();
        this.getAxisAngle(a4);
        hashtable.put("axisAngle", a4);
        hashtable.put("quaternion", Quaternion.newAA(a4).toPoint4f());
        hashtable.put("rotationMatrix", this.matrixRotate);
        hashtable.put("rotateZYZ", this.getRotateZyzText(false));
        hashtable.put("rotateXYZ", this.getRotateXyzText());
        hashtable.put("transXPercent", Float.valueOf(this.getTranslationXPercent()));
        hashtable.put("transYPercent", Float.valueOf(this.getTranslationYPercent()));
        hashtable.put("zoom", Float.valueOf(this.zoomPercent));
        hashtable.put("modelRadius", Float.valueOf(this.modelRadius));
        if (this.mode == 1) {
            hashtable.put("navigationCenter", "navigate center " + Escape.eP(this.navigationCenter));
            hashtable.put("navigationOffsetXPercent", Float.valueOf(this.getNavigationOffsetPercent('X')));
            hashtable.put("navigationOffsetYPercent", Float.valueOf(this.getNavigationOffsetPercent('Y')));
            hashtable.put("navigationDepthPercent", Float.valueOf(this.getNavigationDepthPercent()));
        }
        return hashtable;
    }

    void getAxisAngle(A4 a4) {
        a4.setM(this.matrixRotate);
    }

    String getTransformText() {
        return this.matrixRotate.toString();
    }

    public M3 getMatrixRotate() {
        return this.matrixRotate;
    }

    public void setRotation(M3 m3) {
        if (!Float.isNaN(m3.m00)) {
            this.matrixRotate.setM(m3);
        }
    }

    public void getRotation(M3 m3) {
        m3.setM(this.matrixRotate);
    }

    protected void zoomBy(int n) {
        if (n > 20) {
            n = 20;
        } else if (n < -20) {
            n = -20;
        }
        float f = (float)n * this.zoomPercentSetting / 50.0f;
        if (f == 0.0f) {
            f = n > 0 ? 1 : (f < 0.0f ? -1 : 0);
        }
        this.zoomRatio = (f + this.zoomPercentSetting) / this.zoomPercentSetting;
        this.zoomPercentSetting += f;
    }

    float getZoomPercentFloat() {
        return this.zoomPercent;
    }

    public void zoomToPercent(float f) {
        this.zoomPercentSetting = f;
        this.zoomRatio = 0.0f;
    }

    void translateZBy(int n) {
        if (n >= this.screenPixelCount) {
            return;
        }
        float f = this.scalePixelsPerAngstrom / (1.0f - (float)n * 1.0f / (float)this.screenPixelCount);
        if (f >= (float)this.screenPixelCount) {
            return;
        }
        float f2 = f / this.scaleDefaultPixelsPerAngstrom * 100.0f;
        this.zoomRatio = f2 / this.zoomPercentSetting;
        this.zoomPercentSetting = f2;
    }

    void zoomByFactor0(float f, int n, int n2) {
        if (f <= 0.0f || !this.zoomEnabled) {
            return;
        }
        this.zoomRatio = f;
        this.zoomPercentSetting *= f;
        this.resetXYCenter(n, n2);
    }

    private void resetXYCenter(int n, int n2) {
        if (n == Integer.MAX_VALUE || n2 == Integer.MAX_VALUE) {
            return;
        }
        if (this.windowCentered) {
            this.viewer.setBooleanProperty("windowCentered", false);
        }
        P3 p3 = new P3();
        this.transformPoint2(this.fixedRotationCenter, p3);
        p3.set(n, n2, p3.z);
        this.unTransformPoint(p3, p3);
        this.fixedTranslation.set(n, n2, 0.0f);
        this.setFixedRotationCenter(p3);
    }

    void zoomByPercent(float f) {
        float f2 = f * this.zoomPercentSetting / 100.0f;
        if (f2 == 0.0f) {
            f2 = f < 0.0f ? -1.0f : 1.0f;
        }
        this.zoomRatio = (f2 + this.zoomPercentSetting) / this.zoomPercentSetting;
        this.zoomPercentSetting += f2;
    }

    void setScaleAngstromsPerInch(float f) {
        boolean bl = this.scale3D = f > 0.0f;
        if (this.scale3D) {
            this.scale3DAngstromsPerInch = f;
        }
        this.perspectiveDepth = !this.scale3D;
    }

    void setZslabPoint(P3 p3) {
        this.zSlabPoint = p3 == null ? null : P3.newP(p3);
    }

    int getZShadeStart() {
        return this.zShadeEnabled ? this.zDepthValue : 0;
    }

    public void setSlabRange(float f) {
        this.slabRange = f;
    }

    void setSlabEnabled(boolean bl) {
        this.slabEnabled = bl;
        this.viewer.global.setB("slabEnabled", bl);
    }

    void setZShadeEnabled(boolean bl) {
        this.zShadeEnabled = bl;
        this.viewer.global.setB("zShade", bl);
    }

    void setZoomEnabled(boolean bl) {
        this.zoomEnabled = bl;
        this.viewer.global.setB("zoomEnabled", bl);
    }

    void slabReset() {
        this.slabToPercent(100);
        this.depthToPercent(0);
        this.depthPlane = null;
        this.slabPlane = null;
        this.setSlabEnabled(false);
        this.setZShadeEnabled(false);
    }

    public int getSlabPercentSetting() {
        return this.slabPercentSetting;
    }

    void slabByPercentagePoints(int n) {
        this.slabPlane = null;
        this.slabPercentSetting += n;
        this.slabDepthChanged();
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
    }

    private void slabDepthChanged() {
        this.viewer.global.setI("slab", this.slabPercentSetting);
        this.viewer.global.setI("depth", this.depthPercentSetting);
    }

    void depthByPercentagePoints(int n) {
        this.depthPlane = null;
        this.depthPercentSetting += n;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
        this.slabDepthChanged();
    }

    void slabDepthByPercentagePoints(int n) {
        this.slabPlane = null;
        this.depthPlane = null;
        this.slabPercentSetting += n;
        this.depthPercentSetting += n;
        this.slabDepthChanged();
    }

    public void slabToPercent(int n) {
        this.viewer.setFloatProperty("slabRange", 0.0f);
        this.slabPercentSetting = n;
        this.slabPlane = null;
        if (this.depthPercentSetting >= this.slabPercentSetting) {
            this.depthPercentSetting = this.slabPercentSetting - 1;
        }
        this.slabDepthChanged();
    }

    void depthToPercent(int n) {
        this.viewer.global.setI("depth", n);
        this.depthPercentSetting = n;
        if (this.slabPercentSetting <= this.depthPercentSetting) {
            this.slabPercentSetting = this.depthPercentSetting + 1;
        }
        this.slabDepthChanged();
    }

    void zSlabToPercent(int n) {
        this.zSlabPercentSetting = n;
        if (this.zDepthPercentSetting > this.zSlabPercentSetting) {
            this.zDepthPercentSetting = n;
        }
    }

    void zDepthToPercent(int n) {
        this.zDepthPercentSetting = n;
        if (this.zDepthPercentSetting > this.zSlabPercentSetting) {
            this.zSlabPercentSetting = n;
        }
    }

    void slabInternal(P4 p4, boolean bl) {
        if (bl) {
            this.depthPlane = p4;
            this.depthPercentSetting = 0;
        } else {
            this.slabPlane = p4;
            this.slabPercentSetting = 100;
        }
    }

    void setSlabDepthInternal(boolean bl) {
        this.finalizeTransformParameters();
        if (bl) {
            this.depthPlane = null;
        } else {
            this.slabPlane = null;
        }
        this.slabInternal(this.getSlabDepthPlane(bl), bl);
    }

    P4 getSlabDepthPlane(boolean bl) {
        if (bl) {
            if (this.depthPlane != null) {
                return this.depthPlane;
            }
        } else if (this.slabPlane != null) {
            return this.slabPlane;
        }
        M4 m4 = this.matrixTransform;
        return P4.new4(-m4.m20, -m4.m21, -m4.m22, -m4.m23 + (float)(bl ? this.depthValue : this.slabValue));
    }

    P3[] getCameraFactors() {
        this.aperatureAngle = (float)(Math.atan2((float)this.screenPixelCount / 2.0f, this.referencePlaneOffset) * 2.0 * 180.0 / Math.PI);
        this.cameraDistanceFromCenter = this.referencePlaneOffset / this.scalePixelsPerAngstrom;
        P3 p3 = P3.new3(this.screenWidth / 2, this.screenHeight / 2, this.referencePlaneOffset);
        this.unTransformPoint(p3, p3);
        P3 p32 = P3.new3(this.screenWidth / 2, this.screenHeight / 2, 0.0f);
        this.viewer.unTransformPoint(p32, p32);
        p32.sub(this.fixedRotationCenter);
        P3 p33 = P3.new3(this.screenWidth / 2, this.screenHeight / 2, this.cameraDistanceFromCenter * this.scalePixelsPerAngstrom);
        this.viewer.unTransformPoint(p33, p33);
        p33.sub(this.fixedRotationCenter);
        p32.add(p33);
        return new P3[]{p3, p32, this.fixedRotationCenter, P3.new3(this.cameraDistanceFromCenter, this.aperatureAngle, this.scalePixelsPerAngstrom)};
    }

    int getFrontPlane() {
        return (int)this.cameraDistance;
    }

    void setPerspectiveDepth(boolean bl) {
        if (this.perspectiveDepth == bl) {
            return;
        }
        this.perspectiveDepth = bl;
        this.viewer.global.setB("perspectiveDepth", bl);
        this.resetFitToScreen(false);
    }

    boolean getPerspectiveDepth() {
        return this.perspectiveDepth;
    }

    public void setCameraDepthPercent(float f, boolean bl) {
        float f2;
        this.resetNavigationPoint(bl);
        float f3 = f2 = f < 0.0f ? -f / 100.0f : f;
        if (f2 == 0.0f) {
            return;
        }
        this.cameraDepthSetting = f2;
        this.viewer.global.setF("cameraDepth", this.cameraDepthSetting);
        if (this.mode == 1) {
            this.cameraDepth = Float.NaN;
        }
    }

    public float getCameraDepth() {
        return this.cameraDepthSetting;
    }

    void setVisualRange(float f) {
        this.visualRange = f;
    }

    M4 getUnscaledTransformMatrix() {
        M4 m4 = M4.newM(null);
        this.vectorTemp.setT(this.fixedRotationCenter);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        m4.sub(this.matrixTemp);
        this.matrixTemp.setM3(this.matrixRotate);
        m4.mul2(this.matrixTemp, m4);
        return m4;
    }

    private void setScreenParameters0(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (n == Integer.MAX_VALUE) {
            return;
        }
        this.screenWidth = n;
        this.screenHeight = n2;
        this.useZoomLarge = bl;
        this.antialias = bl2;
        this.width = bl2 ? n * 2 : n;
        this.height = bl2 ? n2 * 2 : n2;
        this.scaleFitToScreen(false, bl, bl3, bl4);
    }

    void setAntialias(boolean bl) {
        boolean bl2 = this.antialias != bl;
        this.antialias = bl;
        this.width = this.antialias ? this.screenWidth * 2 : this.screenWidth;
        int n = this.height = this.antialias ? this.screenHeight * 2 : this.screenHeight;
        if (bl2) {
            this.scaleFitToScreen(false, this.useZoomLarge, false, false);
        }
    }

    public float defaultScaleToScreen(float f) {
        return (float)this.screenPixelCount / 2.0f / f;
    }

    private void resetFitToScreen(boolean bl) {
        this.scaleFitToScreen(bl, this.viewer.global.zoomLarge, true, true);
    }

    void scaleFitToScreen(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (this.width == 0 || this.height == 0) {
            this.screenPixelCount = 1;
        } else {
            this.fixedTranslation.set((float)this.width * (bl ? 0.5f : this.xTranslationFraction), (float)this.height * (bl ? 0.5f : this.yTranslationFraction), 0.0f);
            this.setTranslationFractions();
            if (bl) {
                this.camera.set(0.0f, 0.0f, 0.0f);
            }
            if (bl4) {
                this.resetNavigationPoint(bl3);
            }
            if (this.zoomHeight) {
                bl2 = this.height > this.width;
            }
            int n = this.screenPixelCount = bl2 == this.height > this.width ? this.height : this.width;
        }
        if (this.screenPixelCount > 2) {
            this.screenPixelCount -= 2;
        }
        this.scaleDefaultPixelsPerAngstrom = this.defaultScaleToScreen(this.modelRadius);
    }

    float scaleToScreen(int n, int n2) {
        if (n2 == 0 || n < 2) {
            return 0.0f;
        }
        float f = this.scaleToPerspective(n, (float)n2 * this.scalePixelsPerAngstrom / 1000.0f);
        return f > 0.0f ? f : 1.0f;
    }

    float unscaleToScreen(float f, float f2) {
        float f3 = f2 / this.scalePixelsPerAngstrom;
        return this.perspectiveDepth ? f3 / this.getPerspectiveFactor(f) : f3;
    }

    float scaleToPerspective(int n, float f) {
        return this.perspectiveDepth ? f * this.getPerspectiveFactor(n) : f;
    }

    M4 getMatrixtransform() {
        return this.matrixTransform;
    }

    void setNavigationMode(boolean bl) {
        this.mode = bl && this.canNavigate() ? 1 : this.defaultMode;
        this.resetNavigationPoint(true);
    }

    boolean isNavigating() {
        return this.navigating || this.navOn;
    }

    public synchronized void finalizeTransformParameters() {
        this.haveNotifiedNaN = false;
        this.fixedRotationOffset.setT(this.fixedTranslation);
        this.camera.setT(this.cameraSetting);
        this.internalSlab = this.slabEnabled && (this.slabPlane != null || this.depthPlane != null);
        float f = this.getZoomSetting();
        if (this.zoomPercent != f) {
            this.zoomPercent = f;
            if (!this.viewer.global.fontCaching) {
                this.viewer.getGraphicsData().clearFontCache();
            }
        }
        this.calcCameraFactors();
        this.calcTransformMatrix();
        if (this.mode == 1) {
            this.calcNavigationPoint();
        } else {
            this.calcSlabAndDepthValues();
        }
    }

    float getZoomSetting() {
        if (this.zoomPercentSetting < 5.0f) {
            this.zoomPercentSetting = 5.0f;
        }
        if (this.zoomPercentSetting > 200000.0f) {
            this.zoomPercentSetting = 200000.0f;
        }
        return this.zoomEnabled || this.mode == 1 ? this.zoomPercentSetting : 100.0f;
    }

    public void calcSlabAndDepthValues() {
        this.slabValue = this.slabRange < 1.0f ? this.zValueFromPercent(this.slabPercentSetting) : (int)Math.floor(this.modelCenterOffset * this.slabRange / (2.0f * this.modelRadius) * (this.zoomPercentSetting / 100.0f));
        this.depthValue = this.zValueFromPercent(this.depthPercentSetting);
        if (this.zSlabPercentSetting == this.zDepthPercentSetting) {
            this.zSlabValue = this.slabValue;
            this.zDepthValue = this.depthValue;
        } else {
            this.zSlabValue = this.zValueFromPercent(this.zSlabPercentSetting);
            this.zDepthValue = this.zValueFromPercent(this.zDepthPercentSetting);
        }
        if (this.zSlabPoint != null) {
            try {
                this.transformPoint2(this.zSlabPoint, this.pointT2);
                this.zSlabValue = (int)this.pointT2.z;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.viewer.global.setS("_slabPlane", Escape.eP4(this.getSlabDepthPlane(false)));
        this.viewer.global.setS("_depthPlane", Escape.eP4(this.getSlabDepthPlane(true)));
        if (this.slabEnabled) {
            return;
        }
        this.slabValue = 0;
        this.depthValue = Integer.MAX_VALUE;
    }

    int zValueFromPercent(int n) {
        return (int)Math.floor((1.0f - (float)n / 50.0f) * this.modelRadiusPixels + this.modelCenterOffset);
    }

    public synchronized void calcTransformMatrix() {
        this.matrixTransform.setIdentity();
        this.vectorTemp.sub2(this.fixedRotationCenter, this.frameOffset);
        this.matrixTemp.setZero();
        this.matrixTemp.setTranslation(this.vectorTemp);
        this.matrixTransform.sub(this.matrixTemp);
        this.matrixTemp.setM3(this.stereoFrame ? this.matrixStereo : this.matrixRotate);
        this.matrixTransform.mul2(this.matrixTemp, this.matrixTransform);
        this.matrixTemp.setIdentity();
        this.matrixTemp.m11 = this.matrixTemp.m22 = this.scalePixelsPerAngstrom;
        this.matrixTemp.m00 = this.matrixTemp.m22;
        this.matrixTemp.m11 = this.matrixTemp.m22 = -this.scalePixelsPerAngstrom;
        this.matrixTransform.mul2(this.matrixTemp, this.matrixTransform);
        this.matrixTransform.m23 += this.modelCenterOffset;
        try {
            this.matrixTransformInv.invertM(this.matrixTransform);
        }
        catch (Exception exception) {
            System.out.println("ERROR INVERTING matrixTransform!");
        }
    }

    void rotatePoint(P3 p3, P3 p32) {
        this.matrixRotate.transform2(p3, p32);
        p32.y = -p32.y;
    }

    void transformPoints(int n, P3[] p3Array, P3i[] p3iArray) {
        int n2 = n;
        while (--n2 >= 0) {
            p3iArray[n2].setT(this.transformPoint(p3Array[n2]));
        }
    }

    void transformPointScr(P3 p3, P3i p3i) {
        p3i.setT(this.transformPoint(p3));
    }

    void transformPointNoClip(P3 p3, P3 p32) {
        this.getTempScreenPt(p3, null);
        p32.setT(this.point3fScreenTemp);
    }

    synchronized P3i transformPoint(P3 p3) {
        return p3.z == Float.MAX_VALUE || p3.z == -3.4028235E38f ? this.transformScreenPoint(p3) : this.getTempScreenPt(p3, this.internalSlab ? p3 : null);
    }

    private P3i transformScreenPoint(P3 p3) {
        if (p3.z == -3.4028235E38f) {
            this.point3iScreenTemp.x = (int)Math.floor(p3.x / 100.0f * (float)this.screenWidth);
            this.point3iScreenTemp.y = (int)Math.floor((1.0f - p3.y / 100.0f) * (float)this.screenHeight);
        } else {
            this.point3iScreenTemp.x = (int)p3.x;
            this.point3iScreenTemp.y = this.screenHeight - (int)p3.y;
        }
        if (this.antialias) {
            this.point3iScreenTemp.x <<= 1;
            this.point3iScreenTemp.y <<= 1;
        }
        this.matrixTransform.transform2(this.fixedRotationCenter, this.pointTsp);
        this.point3iScreenTemp.z = (int)this.pointTsp.z;
        return this.point3iScreenTemp;
    }

    P3i transformPointVib(P3 p3, Vibration vibration) {
        this.ptVibTemp.setT(p3);
        return this.getTempScreenPt(this.getVibrationPoint(vibration, this.ptVibTemp), p3);
    }

    public Point3fi getVibrationPoint(Vibration vibration, Point3fi point3fi) {
        vibration.setTempPoint(point3fi, this.vibrationT, this.vibrationScale, this.viewer.global.modulationScale);
        return point3fi;
    }

    public void transformPoint2(P3 p3, P3 p32) {
        this.getTempScreenPt(p3, p3);
        p32.setT(this.point3fScreenTemp);
    }

    void transformVector(V3 v3, V3 v32) {
        this.matrixTransform.rotate(v3, v32);
    }

    void move(JmolScriptEvaluator jmolScriptEvaluator, V3 v3, float f, V3 v32, float f2, float f3, int n) {
        JmolThread jmolThread = (JmolThread)Interface.getOptionInterface("thread.MoveThread");
        jmolThread.setManager(this, this.viewer, new Object[]{v3, v32, new float[]{f, f2, f3, n}});
        if (f3 > 0.0f) {
            jmolThread.setEval(jmolScriptEvaluator);
        }
        jmolThread.run();
    }

    boolean isInPosition(V3 v3, float f) {
        if (Float.isNaN(f)) {
            return true;
        }
        this.aaTest1.setVA(v3, (float)((double)f / 57.29577951308232));
        this.ptTest1.set(4.321f, 1.23456f, 3.14159f);
        this.getRotation(this.matrixTest);
        this.matrixTest.transform2(this.ptTest1, this.ptTest2);
        this.matrixTest.setAA(this.aaTest1);
        this.matrixTest.transform2(this.ptTest1, this.ptTest3);
        return (double)this.ptTest3.distance(this.ptTest2) < 0.1;
    }

    public void moveToPyMOL(JmolScriptEvaluator jmolScriptEvaluator, float f, float[] fArray) {
        M3 m3 = M3.newA(fArray);
        m3.invert();
        float f2 = fArray[9];
        float f3 = -fArray[10];
        float f4 = -fArray[11];
        P3 p3 = P3.new3(fArray[12], fArray[13], fArray[14]);
        float f5 = fArray[15];
        float f6 = fArray[16];
        float f7 = fArray[17];
        boolean bl = f7 >= 0.0f;
        this.setPerspectiveDepth(!bl);
        float f8 = Math.abs(f7) / 2.0f;
        float f9 = (float)Math.tan((double)f8 * Math.PI / 180.0);
        float f10 = f4 * f9;
        float f11 = 0.5f / f9;
        float f12 = f11 - 0.5f;
        float f13 = 50.0f / f10;
        if (f5 > 0.0f) {
            int n = 50 + (int)((f4 - f5) * f13);
            int n2 = 50 + (int)((f4 - f6) * f13);
            this.setSlabEnabled(true);
            this.slabToPercent(n);
            this.depthToPercent(n2);
            if (fArray.length == 21) {
                boolean bl2 = fArray[18] != 0.0f;
                boolean bl3 = fArray[19] != 0.0f;
                float f14 = fArray[20];
                this.setZShadeEnabled(bl2);
                if (bl2) {
                    if (bl3) {
                        this.viewer.setIntProperty("zSlab", (int)Math.min(100.0f, (float)n + f14 * (float)(n2 - n)));
                    } else {
                        this.viewer.setIntProperty("zSlab", (int)((float)(n + n2) / 2.0f));
                    }
                    this.viewer.setIntProperty("zDepth", n2);
                }
            }
        }
        this.moveTo(jmolScriptEvaluator, f, p3, null, 0.0f, m3, 100.0f, Float.NaN, Float.NaN, f10, null, Float.NaN, Float.NaN, Float.NaN, f12, f2, f3);
    }

    void moveTo(JmolScriptEvaluator jmolScriptEvaluator, float f, P3 p3, T3 t3, float f2, M3 m3, float f3, float f4, float f5, float f6, P3 p32, float f7, float f8, float f9, float f10, float f11, float f12) {
        float f13;
        if (m3 == null) {
            m3 = new M3();
            V3 v3 = V3.newV(t3);
            if (Float.isNaN(f2)) {
                m3.m00 = Float.NaN;
            } else if (f2 < 0.01f && f2 > -0.01f) {
                m3.setIdentity();
            } else {
                if (v3.x == 0.0f && v3.y == 0.0f && v3.z == 0.0f) {
                    return;
                }
                A4 a4 = new A4();
                a4.setVA(v3, (float)((double)f2 / 57.29577951308232));
                m3.setAA(a4);
            }
        }
        if (f11 == this.cameraSetting.x) {
            f11 = Float.NaN;
        }
        if (f12 == this.cameraSetting.y) {
            f12 = Float.NaN;
        }
        if (f10 == this.cameraDepth) {
            f10 = Float.NaN;
        }
        if (!Float.isNaN(f11)) {
            f4 = f11 * 50.0f / f6 / (float)this.width * (float)this.screenPixelCount;
        }
        if (!Float.isNaN(f12)) {
            f5 = f12 * 50.0f / f6 / (float)this.height * (float)this.screenPixelCount;
        }
        float f14 = f13 = p3 == null ? this.scaleDefaultPixelsPerAngstrom : this.defaultScaleToScreen(f6);
        if (f <= 0.0f) {
            this.setAll(p3, m3, p32, f3, f4, f5, f6, f13, f9, f7, f8, f10, f11, f12);
            this.viewer.moveUpdate(f);
            this.viewer.finalizeTransformParameters();
            return;
        }
        try {
            int n;
            if (this.motion == null) {
                this.motion = (JmolThread)Interface.getOptionInterface("thread.MoveToThread");
            }
            if ((n = this.motion.setManager(this, this.viewer, new Object[]{p3, m3, p32, new float[]{f, f3, f4, f5, f6, f13, f9, f7, f8, f10, f11, f12}})) <= 0 || this.viewer.global.waitForMoveTo) {
                if (n > 0) {
                    this.motion.setEval(jmolScriptEvaluator);
                }
                this.motion.run();
                if (!this.viewer.isSingleThreaded) {
                    this.motion = null;
                }
            } else {
                this.motion.start();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopMotion() {
        this.motion = null;
    }

    Quaternion getRotationQuaternion() {
        return Quaternion.newM(this.matrixRotate);
    }

    String getRotationText() {
        this.axisangleT.setM(this.matrixRotate);
        float f = (float)((double)this.axisangleT.angle * 57.29577951308232);
        SB sB = new SB();
        this.vectorT.set(this.axisangleT.x, this.axisangleT.y, this.axisangleT.z);
        if (f < 0.01f) {
            return "{0 0 1 0}";
        }
        this.vectorT.normalize();
        this.vectorT.scale(1000.0f);
        sB.append("{");
        TransformManager.truncate0(sB, this.vectorT.x);
        TransformManager.truncate0(sB, this.vectorT.y);
        TransformManager.truncate0(sB, this.vectorT.z);
        TransformManager.truncate2(sB, f);
        sB.append("}");
        return sB.toString();
    }

    String getMoveToText(float f, boolean bl) {
        this.finalizeTransformParameters();
        SB sB = new SB();
        sB.append("moveto ");
        if (bl) {
            sB.append("/* time, axisAngle */ ");
        }
        sB.appendF(f);
        sB.append(" ").append(this.getRotationText());
        if (bl) {
            sB.append(" /* zoom, translation */ ");
        }
        TransformManager.truncate2(sB, this.zoomPercentSetting);
        TransformManager.truncate2(sB, this.getTranslationXPercent());
        TransformManager.truncate2(sB, this.getTranslationYPercent());
        sB.append(" ");
        if (bl) {
            sB.append(" /* center, rotationRadius */ ");
        }
        sB.append(this.getCenterText());
        sB.append(" ").appendF(this.modelRadius);
        sB.append(this.getNavigationText(bl));
        if (bl) {
            sB.append(" /* cameraDepth, cameraX, cameraY */ ");
        }
        TransformManager.truncate2(sB, this.cameraDepth);
        TransformManager.truncate2(sB, this.cameraSetting.x);
        TransformManager.truncate2(sB, this.cameraSetting.y);
        sB.append(";");
        return sB.toString();
    }

    private String getCenterText() {
        return Escape.eP(this.fixedRotationCenter);
    }

    private String getRotateXyzText() {
        float f;
        float f2;
        SB sB = new SB();
        float f3 = this.matrixRotate.m20;
        float f4 = -((float)(Math.asin(f3) * 57.29577951308232));
        if (f3 > 0.999f || f3 < -0.999f) {
            f2 = -((float)(Math.atan2(this.matrixRotate.m12, this.matrixRotate.m11) * 57.29577951308232));
            f = 0.0f;
        } else {
            f2 = (float)(Math.atan2(this.matrixRotate.m21, this.matrixRotate.m22) * 57.29577951308232);
            f = (float)(Math.atan2(this.matrixRotate.m10, this.matrixRotate.m00) * 57.29577951308232);
        }
        sB.append("reset");
        sB.append(";center ").append(this.getCenterText());
        if (f2 != 0.0f) {
            sB.append("; rotate x");
            TransformManager.truncate2(sB, f2);
        }
        if (f4 != 0.0f) {
            sB.append("; rotate y");
            TransformManager.truncate2(sB, f4);
        }
        if (f != 0.0f) {
            sB.append("; rotate z");
            TransformManager.truncate2(sB, f);
        }
        sB.append(";");
        this.addZoomTranslationNavigationText(sB);
        return sB.toString();
    }

    private void addZoomTranslationNavigationText(SB sB) {
        float f;
        float f2;
        if (this.zoomPercent != 100.0f) {
            sB.append(" zoom");
            TransformManager.truncate2(sB, this.zoomPercent);
            sB.append(";");
        }
        if ((f2 = this.getTranslationXPercent()) != 0.0f) {
            sB.append(" translate x");
            TransformManager.truncate2(sB, f2);
            sB.append(";");
        }
        if ((f = this.getTranslationYPercent()) != 0.0f) {
            sB.append(" translate y");
            TransformManager.truncate2(sB, f);
            sB.append(";");
        }
        if (this.modelRadius != this.rotationRadiusDefault || this.modelRadius == 10.0f) {
            sB.append(" set rotationRadius");
            TransformManager.truncate2(sB, this.modelRadius);
            sB.append(";");
        }
        if (this.mode == 1) {
            sB.append("navigate 0 center ").append(Escape.eP(this.navigationCenter));
            sB.append(";navigate 0 translate");
            TransformManager.truncate2(sB, this.getNavigationOffsetPercent('X'));
            TransformManager.truncate2(sB, this.getNavigationOffsetPercent('Y'));
            sB.append(";navigate 0 depth ");
            TransformManager.truncate2(sB, this.getNavigationDepthPercent());
            sB.append(";");
        }
    }

    private String getRotateZyzText(boolean bl) {
        float f;
        float f2;
        SB sB = new SB();
        M3 m3 = (M3)this.viewer.getModelSetAuxiliaryInfoValue("defaultOrientationMatrix");
        if (m3 == null) {
            m3 = this.matrixRotate;
        } else {
            m3 = M3.newM(m3);
            m3.invert();
            m3.mul2(this.matrixRotate, m3);
        }
        float f3 = m3.m22;
        float f4 = (float)(Math.acos(f3) * 57.29577951308232);
        if (f3 > 0.999f || f3 < -0.999f) {
            f2 = (float)(Math.atan2(m3.m10, m3.m11) * 57.29577951308232);
            f = 0.0f;
        } else {
            f2 = (float)(Math.atan2(m3.m21, -m3.m20) * 57.29577951308232);
            f = (float)(Math.atan2(m3.m12, m3.m02) * 57.29577951308232);
        }
        if (f2 != 0.0f && f4 != 0.0f && f != 0.0f && bl) {
            sB.append("#Follows Z-Y-Z convention for Euler angles\n");
        }
        sB.append("reset");
        sB.append(";center ").append(this.getCenterText());
        if (f2 != 0.0f) {
            sB.append("; rotate z");
            TransformManager.truncate2(sB, f2);
        }
        if (f4 != 0.0f) {
            sB.append("; rotate y");
            TransformManager.truncate2(sB, f4);
        }
        if (f != 0.0f) {
            sB.append("; rotate z");
            TransformManager.truncate2(sB, f);
        }
        sB.append(";");
        this.addZoomTranslationNavigationText(sB);
        return sB.toString();
    }

    private static void truncate0(SB sB, float f) {
        sB.appendC(' ');
        sB.appendI(Math.round(f));
    }

    private static void truncate2(SB sB, float f) {
        sB.appendC(' ');
        sB.appendF((float)Math.round(f * 100.0f) / 100.0f);
    }

    void setSpinXYZ(float f, float f2, float f3) {
        if (!Float.isNaN(f)) {
            this.spinX = f;
        }
        if (!Float.isNaN(f2)) {
            this.spinY = f2;
        }
        if (!Float.isNaN(f3)) {
            this.spinZ = f3;
        }
        if (this.isSpinInternal || this.isSpinFixed) {
            this.clearSpin();
        }
    }

    void setSpinFps(int n) {
        if (n <= 0) {
            n = 1;
        } else if (n > 50) {
            n = 50;
        }
        this.spinFps = n;
    }

    void setNavXYZ(float f, float f2, float f3) {
        if (!Float.isNaN(f)) {
            this.navX = f;
        }
        if (!Float.isNaN(f2)) {
            this.navY = f2;
        }
        if (!Float.isNaN(f3)) {
            this.navZ = f3;
        }
    }

    private void clearSpin() {
        this.setSpinOff();
        this.setNavOn(false);
        this.isSpinInternal = false;
        this.isSpinFixed = false;
    }

    boolean getSpinOn() {
        return this.spinOn;
    }

    boolean getNavOn() {
        return this.navOn;
    }

    public void setSpinOn() {
        this.setSpin(null, true, Float.MAX_VALUE, null, null, null, false);
    }

    public void setSpinOff() {
        this.setSpin(null, false, Float.MAX_VALUE, null, null, null, false);
    }

    private void setSpin(JmolScriptEvaluator jmolScriptEvaluator, boolean bl, float f, List<P3> list, float[] fArray, BS bS, boolean bl2) {
        if (this.navOn && bl) {
            this.setNavOn(false);
        }
        if (this.spinOn == bl) {
            return;
        }
        this.spinOn = bl;
        this.viewer.global.setB("_spinning", bl);
        if (bl) {
            if (this.spinThread == null) {
                this.spinThread = (JmolThread)Interface.getOptionInterface("thread.SpinThread");
                this.spinThread.setManager(this, this.viewer, new Object[]{Float.valueOf(f), list, fArray, bS, bl2 ? Boolean.TRUE : null});
                this.spinIsGesture = bl2;
                if (bS == null && fArray == null) {
                    this.spinThread.start();
                } else {
                    this.spinThread.setEval(jmolScriptEvaluator);
                    this.spinThread.run();
                }
            }
        } else if (this.spinThread != null) {
            this.spinThread.reset();
            this.spinThread = null;
        }
    }

    public void setNavOn(boolean bl) {
        if (Float.isNaN(this.navFps)) {
            return;
        }
        boolean bl2 = this.navOn;
        if (bl && this.spinOn) {
            this.setSpin(null, false, 0.0f, null, null, null, false);
        }
        this.navOn = bl;
        this.viewer.global.setB("_navigating", bl);
        if (!bl) {
            this.navInterrupt();
        }
        if (bl) {
            if (this.navX == 0.0f && this.navY == 0.0f && this.navZ == 0.0f) {
                this.navZ = 1.0f;
            }
            if (this.navFps == 0.0f) {
                this.navFps = 10.0f;
            }
            if (this.spinThread == null) {
                this.spinThread = (JmolThread)Interface.getOptionInterface("thread.SpinThread");
                this.spinThread.setManager(this, this.viewer, null);
                this.spinThread.start();
            }
        } else if (bl2 && this.spinThread != null) {
            this.spinThread.interrupt();
            this.spinThread = null;
        }
    }

    void setVibrationScale(float f) {
        this.vibrationScale = f;
    }

    void setVibrationPeriod(float f) {
        if (Float.isNaN(f)) {
            f = this.vibrationPeriod;
        } else if (f == 0.0f) {
            this.vibrationPeriod = 0.0f;
            this.vibrationPeriodMs = 0;
        } else {
            this.vibrationPeriod = Math.abs(f);
            this.vibrationPeriodMs = (int)(this.vibrationPeriod * 1000.0f);
            if (f > 0.0f) {
                return;
            }
            f = -f;
        }
        this.setVibrationOn(f > 0.0f && this.viewer.modelGetLastVibrationIndex(this.viewer.getCurrentModelIndex(), 0) >= 0);
    }

    public void setVibrationT(float f) {
        this.vibrationT.x = f;
        if (this.vibrationScale == 0.0f) {
            this.vibrationScale = this.viewer.global.vibrationScale;
        }
    }

    boolean isVibrationOn() {
        return this.vibrationOn;
    }

    private void setVibrationOn(boolean bl) {
        if (!bl) {
            if (this.vibrationThread != null) {
                this.vibrationThread.interrupt();
                this.vibrationThread = null;
            }
            this.vibrationOn = false;
            return;
        }
        if (this.viewer.getModelCount() < 1) {
            this.vibrationOn = false;
            return;
        }
        if (this.vibrationThread == null) {
            this.vibrationThread = (JmolThread)Interface.getOptionInterface("thread.VibrationThread");
            this.vibrationThread.setManager(this, this.viewer, null);
            this.vibrationThread.start();
        }
        this.vibrationOn = true;
    }

    private void clearVibration() {
        this.setVibrationOn(false);
        this.vibrationScale = 0.0f;
    }

    void setStereoMode2(int[] nArray) {
        this.stereoMode = EnumStereoMode.CUSTOM;
        this.stereoColors = nArray;
    }

    void setStereoMode(EnumStereoMode enumStereoMode) {
        this.stereoColors = null;
        this.stereoMode = enumStereoMode;
    }

    void setStereoDegrees(float f) {
        this.stereoDegrees = f;
        this.stereoRadians = f * ((float)Math.PI / 180);
    }

    synchronized M3 getStereoRotationMatrix(boolean bl) {
        this.stereoFrame = bl;
        if (!bl) {
            return this.matrixRotate;
        }
        this.matrixTemp3.rotY(-this.stereoRadians);
        this.matrixStereo.mul2(this.matrixTemp3, this.matrixRotate);
        return this.matrixStereo;
    }

    boolean isWindowCentered() {
        return this.windowCentered;
    }

    void setWindowCentered(boolean bl) {
        this.windowCentered = bl;
        this.resetNavigationPoint(true);
    }

    P3 getRotationCenter() {
        return this.fixedRotationCenter;
    }

    float getRotationRadius() {
        return this.modelRadius;
    }

    public float setRotationRadius(float f, boolean bl) {
        this.modelRadius = f <= 0.0f ? this.viewer.calcRotationRadius(this.fixedRotationCenter) : f;
        f = this.modelRadius;
        if (bl) {
            this.viewer.setRotationRadius(f, false);
        }
        return f;
    }

    private void setRotationCenterAndRadiusXYZ(P3 p3, boolean bl) {
        this.resetNavigationPoint(false);
        if (p3 == null) {
            this.setFixedRotationCenter(this.rotationCenterDefault);
            this.modelRadius = this.rotationRadiusDefault;
            return;
        }
        this.setFixedRotationCenter(p3);
        if (bl && this.windowCentered) {
            this.modelRadius = this.viewer.calcRotationRadius(this.fixedRotationCenter);
        }
    }

    private void setRotCenterRel(String string, P3 p3) {
        P3 p32 = P3.newP(p3);
        if (string == "average") {
            p32.add(this.viewer.getAverageAtomPoint());
        } else if (string == "boundbox") {
            p32.add(this.viewer.getBoundBoxCenter());
        } else if (string != "absolute") {
            p32.setT(this.rotationCenterDefault);
        }
        this.setRotationCenterAndRadiusXYZ(p32, true);
    }

    void setNewRotationCenter(P3 p3, boolean bl) {
        if (p3 == null) {
            p3 = this.rotationCenterDefault;
        }
        if (this.windowCentered) {
            this.translateToPercent('x', 0.0f);
            this.translateToPercent('y', 0.0f);
            this.setRotationCenterAndRadiusXYZ(p3, true);
            if (bl) {
                this.resetFitToScreen(true);
            }
        } else {
            this.moveRotationCenter(p3, true);
        }
    }

    public void moveRotationCenter(P3 p3, boolean bl) {
        this.setRotationCenterAndRadiusXYZ(p3, false);
        if (bl) {
            this.setRotationPointXY(this.fixedRotationCenter);
        }
    }

    void setCenter() {
        this.setRotationCenterAndRadiusXYZ(this.fixedRotationCenter, true);
    }

    void setCenterAt(String string, P3 p3) {
        this.setRotCenterRel(string, p3);
        this.resetFitToScreen(true);
    }

    void setFrameOffset(int n) {
        if (this.frameOffsets == null || n < 0 || n >= this.frameOffsets.length) {
            this.frameOffset.set(0.0f, 0.0f, 0.0f);
        } else {
            this.frameOffset.setT(this.frameOffsets[n]);
        }
    }

    void setFrameOffsets(P3[] p3Array) {
        this.frameOffsets = p3Array;
    }

    void setSelectedTranslation(BS bS, char c, int n) {
        this.bsSelectedAtoms = bS;
        switch (c) {
            case 'X': 
            case 'x': {
                this.ptOffset.x += (float)n;
                break;
            }
            case 'Y': 
            case 'y': {
                this.ptOffset.y += (float)n;
                break;
            }
            case 'Z': 
            case 'z': {
                this.ptOffset.z += (float)n;
            }
        }
    }

    protected void setNavFps(int n) {
        this.navFps = n;
    }

    public void calcCameraFactors() {
        if (Float.isNaN(this.cameraDepth)) {
            this.cameraDepth = this.cameraDepthSetting;
            this.zoomFactor = Float.MAX_VALUE;
        }
        this.cameraDistance = this.cameraDepth * (float)this.screenPixelCount;
        this.referencePlaneOffset = this.cameraDistance + (float)this.screenPixelCount / 2.0f;
        float f = this.scale3D && !this.perspectiveDepth && this.mode != 1 ? 72.0f / this.scale3DAngstromsPerInch * (float)(this.antialias ? 2 : 1) : (this.scalePixelsPerAngstrom = (float)this.screenPixelCount / this.visualRange);
        if (this.mode != 1) {
            this.mode = this.camera.z == 0.0f ? 0 : 2;
        }
        this.perspectiveShiftXY.set(this.camera.z == 0.0f ? 0.0f : this.camera.x * this.scalePixelsPerAngstrom / (float)this.screenWidth * 100.0f, this.camera.z == 0.0f ? 0.0f : this.camera.y * this.scalePixelsPerAngstrom / (float)this.screenHeight * 100.0f, 0.0f);
        this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
        float f2 = 2.0f * this.modelRadius / this.visualRange * this.referencePlaneOffset;
        if (this.mode == 1) {
            this.calcNavCameraFactors(f2);
            return;
        }
        this.zoomFactor = Float.MAX_VALUE;
        this.modelCenterOffset = this.referencePlaneOffset;
        if (!this.scale3D || this.perspectiveDepth) {
            this.scalePixelsPerAngstrom *= this.modelCenterOffset / f2 * this.zoomPercent / 100.0f;
        }
        this.modelRadiusPixels = this.modelRadius * this.scalePixelsPerAngstrom;
    }

    private void calcNavCameraFactors(float f) {
        if (this.zoomFactor == Float.MAX_VALUE) {
            if (this.zoomPercent > 10000.0f) {
                this.zoomPercent = 10000.0f;
            }
            this.modelCenterOffset = f * 100.0f / this.zoomPercent;
        } else if (this.prevZoomSetting != this.zoomPercentSetting) {
            this.modelCenterOffset = this.zoomRatio == 0.0f ? f * 100.0f / this.zoomPercentSetting : (this.modelCenterOffset += (1.0f - this.zoomRatio) * this.referencePlaneOffset);
            this.navMode = -1;
        }
        this.prevZoomSetting = this.zoomPercentSetting;
        this.zoomFactor = this.modelCenterOffset / this.referencePlaneOffset;
        this.zoomPercent = this.zoomFactor == 0.0f ? 10000.0f : f / this.modelCenterOffset * 100.0f;
    }

    public float getPerspectiveFactor(float f) {
        return f <= 0.0f ? this.referencePlaneOffset : this.referencePlaneOffset / f;
    }

    protected P3i getTempScreenPt(P3 p3, P3 p32) {
        this.matrixTransform.transform2(p3, this.point3fScreenTemp);
        float f = this.point3fScreenTemp.z;
        if (Float.isNaN(f)) {
            if (!this.haveNotifiedNaN && Logger.debugging) {
                Logger.debug("NaN seen in TransformPoint");
            }
            this.haveNotifiedNaN = true;
            this.point3fScreenTemp.z = 1.0f;
            f = 1.0f;
        } else if (f <= 0.0f) {
            this.point3fScreenTemp.z = 1.0f;
            f = 1.0f;
        }
        switch (this.mode) {
            case 1: {
                this.point3fScreenTemp.x -= this.navigationShiftXY.x;
                this.point3fScreenTemp.y -= this.navigationShiftXY.y;
                break;
            }
            case 2: {
                this.point3fScreenTemp.x += this.perspectiveShiftXY.x;
                this.point3fScreenTemp.y += this.perspectiveShiftXY.y;
            }
        }
        if (this.perspectiveDepth) {
            float f2 = this.getPerspectiveFactor(f);
            this.point3fScreenTemp.x *= f2;
            this.point3fScreenTemp.y *= f2;
        }
        switch (this.mode) {
            case 1: {
                this.point3fScreenTemp.x += this.navigationOffset.x;
                this.point3fScreenTemp.y += this.navigationOffset.y;
                break;
            }
            case 2: {
                this.point3fScreenTemp.x -= this.perspectiveShiftXY.x;
                this.point3fScreenTemp.y -= this.perspectiveShiftXY.y;
            }
            case 0: {
                this.point3fScreenTemp.x += this.fixedRotationOffset.x;
                this.point3fScreenTemp.y += this.fixedRotationOffset.y;
            }
        }
        if (Float.isNaN(this.point3fScreenTemp.x) && !this.haveNotifiedNaN) {
            if (Logger.debugging) {
                Logger.debug("NaN found in transformPoint ");
            }
            this.haveNotifiedNaN = true;
        }
        this.point3iScreenTemp.set((int)this.point3fScreenTemp.x, (int)this.point3fScreenTemp.y, (int)this.point3fScreenTemp.z);
        if (p32 != null && (this.slabPlane != null && p32.x * this.slabPlane.x + p32.y * this.slabPlane.y + p32.z * this.slabPlane.z + this.slabPlane.w > 0.0f || this.depthPlane != null && p32.x * this.depthPlane.x + p32.y * this.depthPlane.y + p32.z * this.depthPlane.z + this.depthPlane.w < 0.0f)) {
            this.point3iScreenTemp.z = 1;
        }
        return this.point3iScreenTemp;
    }

    public void unTransformPoint(P3 p3, P3 p32) {
        this.untransformedPoint.setT(p3);
        switch (this.mode) {
            case 1: {
                this.untransformedPoint.x -= this.navigationOffset.x;
                this.untransformedPoint.y -= this.navigationOffset.y;
                break;
            }
            case 2: {
                this.point3fScreenTemp.x += this.perspectiveShiftXY.x;
                this.point3fScreenTemp.y += this.perspectiveShiftXY.y;
            }
            case 0: {
                this.untransformedPoint.x -= this.fixedRotationOffset.x;
                this.untransformedPoint.y -= this.fixedRotationOffset.y;
            }
        }
        if (this.perspectiveDepth) {
            float f = this.getPerspectiveFactor(this.untransformedPoint.z);
            this.untransformedPoint.x /= f;
            this.untransformedPoint.y /= f;
        }
        switch (this.mode) {
            case 1: {
                this.untransformedPoint.x += this.navigationShiftXY.x;
                this.untransformedPoint.y += this.navigationShiftXY.y;
                break;
            }
            case 2: {
                this.untransformedPoint.x -= this.perspectiveShiftXY.x;
                this.untransformedPoint.y -= this.perspectiveShiftXY.y;
            }
        }
        this.matrixTransformInv.transform2(this.untransformedPoint, p32);
    }

    boolean canNavigate() {
        return true;
    }

    protected void resetNavigationPoint(boolean bl) {
        if (this.zoomPercent < 5.0f && this.mode != 1) {
            this.perspectiveDepth = true;
            this.mode = 1;
            return;
        }
        if (this.mode == 1) {
            this.navMode = 1;
            this.slabPercentSetting = 0;
            this.perspectiveDepth = true;
        } else if (bl) {
            this.slabPercentSetting = 100;
        }
        this.viewer.setFloatProperty("slabRange", 0.0f);
        if (bl) {
            this.setSlabEnabled(this.mode == 1);
        }
        this.zoomFactor = Float.MAX_VALUE;
        this.zoomPercentSetting = this.zoomPercent;
    }

    public void setNavigatePt(P3 p3) {
        this.navigationCenter.setT(p3);
        this.navMode = 3;
        this.navigating = true;
        this.finalizeTransformParameters();
        this.navigating = false;
    }

    public P3 getNavigationCenter() {
        return this.navigationCenter;
    }

    public float getNavigationDepthPercent() {
        return this.navigationDepth;
    }

    void setNavigationSlabOffsetPercent(float f) {
        this.viewer.global.setF("navigationSlab", f);
        this.calcCameraFactors();
        this.navigationSlabOffset = f / 50.0f * this.modelRadiusPixels;
    }

    P3 getNavigationOffset() {
        this.transformPoint2(this.navigationCenter, this.navigationOffset);
        return this.navigationOffset;
    }

    public float getNavPtHeight() {
        return (float)this.height / 2.0f;
    }

    public float getNavigationOffsetPercent(char c) {
        this.getNavigationOffset();
        if (this.width == 0 || this.height == 0) {
            return 0.0f;
        }
        return c == 'X' ? (this.navigationOffset.x - (float)this.width / 2.0f) * 100.0f / (float)this.width : (this.navigationOffset.y - this.getNavPtHeight()) * 100.0f / (float)this.height;
    }

    protected String getNavigationText(boolean bl) {
        String string;
        String string2 = string = bl ? " /* navigation center, translation, depth */ " : " ";
        if (this.mode != 1) {
            return string + "{0 0 0} 0 0 0";
        }
        this.getNavigationOffset();
        return string + Escape.eP(this.navigationCenter) + " " + this.getNavigationOffsetPercent('X') + " " + this.getNavigationOffsetPercent('Y') + " " + this.getNavigationDepthPercent();
    }

    void setScreenParameters(int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        P3 p3 = this.mode == 1 ? P3.newP(this.navigationCenter) : null;
        P3 p32 = P3.newP(this.navigationOffset);
        p32.x /= (float)this.width;
        p32.y /= (float)this.height;
        this.setScreenParameters0(n, n2, bl, bl2, bl3, bl4);
        if (p3 != null) {
            this.navigationCenter.setT(p3);
            this.navTranslatePercentOrTo(-1.0f, p32.x * (float)this.width, p32.y * (float)this.height);
            this.setNavigatePt(p3);
        }
    }

    private void navInterrupt() {
        if (this.nav != null) {
            this.nav.interrupt();
        }
    }

    private boolean getNav() {
        if (this.nav != null) {
            return true;
        }
        this.nav = (JmolNavigatorInterface)Interface.getOptionInterface("navigate.Navigator");
        if (this.nav == null) {
            return false;
        }
        this.nav.set(this, this.viewer);
        return true;
    }

    public void navigateList(JmolScriptEvaluator jmolScriptEvaluator, List<Object[]> list) {
        if (this.getNav()) {
            this.nav.navigateList(jmolScriptEvaluator, list);
        }
    }

    public void navigateAxis(V3 v3, float f) {
        if (this.getNav()) {
            this.nav.navigateAxis(v3, f);
        }
    }

    void zoomByFactor(float f, int n, int n2) {
        if (this.mode != 1 || !this.zoomEnabled || f <= 0.0f) {
            this.zoomByFactor0(f, n, n2);
        } else if (this.getNav()) {
            this.nav.zoomByFactor(f, n, n2);
        }
    }

    public void setNavigationOffsetRelative() {
        if (this.getNav()) {
            this.nav.setNavigationOffsetRelative();
        }
    }

    synchronized void navigateKey(int n, int n2) {
        if (this.getNav()) {
            this.nav.navigateKey(n, n2);
        }
    }

    public void setNavigationDepthPercent(float f) {
        if (this.getNav()) {
            this.nav.setNavigationDepthPercent(f);
        }
    }

    public void navTranslatePercentOrTo(float f, float f2, float f3) {
        if (this.getNav()) {
            this.nav.navTranslatePercentOrTo(f, f2, f3);
        }
    }

    protected void calcNavigationPoint() {
        if (this.getNav()) {
            this.nav.calcNavigationPoint();
        }
    }

    protected String getNavigationState() {
        return this.mode == 1 && this.getNav() ? this.nav.getNavigationState() : "";
    }

    public void setZoomHeight(boolean bl, boolean bl2) {
        this.zoomHeight = bl;
        this.scaleFitToScreen(false, bl2, false, true);
    }

    public void setAll(P3 p3, M3 m3, P3 p32, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11) {
        this.setRotation(m3);
        if (p3 != null) {
            this.moveRotationCenter(p3, !this.windowCentered);
        }
        if (p32 != null && this.mode == 1) {
            this.navigationCenter.setT(p32);
        }
        if (!Float.isNaN(f9)) {
            this.setCameraDepthPercent(f9, false);
        }
        if (!Float.isNaN(f10) && !Float.isNaN(f11)) {
            this.setCamera(f10, f11);
        }
        if (!Float.isNaN(f)) {
            this.zoomToPercent(f);
        }
        if (!Float.isNaN(f4)) {
            this.modelRadius = f4;
        }
        if (!Float.isNaN(f5)) {
            this.scaleDefaultPixelsPerAngstrom = f5;
        }
        if (!Float.isNaN(f2) && !Float.isNaN(f3)) {
            this.translateToPercent('x', f2);
            this.translateToPercent('y', f3);
        }
        if (this.mode == 1) {
            if (!Float.isNaN(f7) && !Float.isNaN(f8)) {
                this.navTranslatePercentOrTo(0.0f, f7, f8);
            }
            if (!Float.isNaN(f6)) {
                this.setNavigationDepthPercent(f6);
            }
        }
    }
}

