/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.MSInterface;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Modulation;
import org.jmol.util.ModulationSet;
import org.jmol.util.Tensor;

public class MSReader
implements MSInterface {
    protected AtomSetCollectionReader cr;
    protected boolean modVib;
    protected String modAxes;
    protected boolean modAverage;
    protected String modType;
    protected boolean modDebug;
    protected int modSelected = -1;
    protected boolean modLast;
    protected int modDim;
    private P3 q1;
    private V3 q1Norm;
    private Map<String, P3> htModulation;
    private Map<String, List<Modulation>> htAtomMods;
    protected Map<String, Object> htSubsystems;
    private String atModel = "@0";
    private M3 q123;
    private boolean haveOccupancy;
    private Atom[] atoms;
    private int atomCount;
    private P3[] qs;
    private int modCount;
    private static final String U_LIST = "U11U22U33U12U13U23UISO";
    private int iopLast = -1;
    private M3 gammaE;
    private M4 gammaIS;
    private int nOps;

    public int initialize(AtomSetCollectionReader atomSetCollectionReader, String string) throws Exception {
        this.cr = atomSetCollectionReader;
        this.modDebug = atomSetCollectionReader.checkFilterKey("MODDEBUG");
        this.modLast = atomSetCollectionReader.checkFilterKey("MODLAST");
        this.modAxes = atomSetCollectionReader.getFilter("MODAXES=");
        this.modType = atomSetCollectionReader.getFilter("MODTYPE=");
        this.modSelected = atomSetCollectionReader.parseIntStr("" + atomSetCollectionReader.getFilter("MOD="));
        this.modVib = atomSetCollectionReader.checkFilterKey("MODVIB");
        this.modAverage = atomSetCollectionReader.checkFilterKey("MODAVE");
        this.setModDim(atomSetCollectionReader.parseIntStr(string));
        return this.modDim;
    }

    protected void setModDim(int n) {
        if (this.modAverage) {
            return;
        }
        this.modDim = n;
        if (this.modDim > 3) {
            this.cr.appendLoadNote("Too high modulation dimension (" + this.modDim + ") -- reading average structure");
            this.modDim = 0;
            this.modAverage = true;
        } else {
            this.cr.appendLoadNote("Modulation dimension = " + this.modDim);
            this.htModulation = new Hashtable<String, P3>();
        }
    }

    public void addModulation(Map<String, P3> map, String string, P3 p3, int n) {
        char c = string.charAt(0);
        switch (c) {
            case 'D': 
            case 'O': 
            case 'U': {
                if ((this.modType == null || this.modType.indexOf(c) >= 0) && (this.modSelected <= 0 || this.modSelected == 1)) break;
                return;
            }
        }
        if (this.modSelected > 0 && string.contains("_q_")) {
            switch (this.modSelected) {
                case 1: {
                    p3.z = 0.0f;
                    p3.y = 0.0f;
                    break;
                }
                case 2: {
                    p3.z = 0.0f;
                    p3.x = 0.0f;
                    break;
                }
                case 3: {
                    p3.y = 0.0f;
                    p3.x = 0.0f;
                }
            }
        }
        if (p3.x == 0.0f && p3.y == 0.0f && p3.z == 0.0f) {
            return;
        }
        if (map == null) {
            map = this.htModulation;
        }
        string = string + "@" + (n >= 0 ? n : this.cr.atomSetCollection.getCurrentAtomSetIndex());
        Logger.info((String)("Adding " + string + " " + p3));
        map.put(string, p3);
    }

    public void setModulation() {
        if (this.modDim == 0 || this.htModulation == null) {
            return;
        }
        if (this.modDebug) {
            Logger.debuggingHigh = true;
            Logger.debugging = true;
        }
        this.setModulationForStructure(this.cr.atomSetCollection.getCurrentAtomSetIndex());
        if (this.modDebug) {
            Logger.debuggingHigh = false;
            Logger.debugging = false;
        }
    }

    public void finalizeModulation() {
        if (this.modDim > 0 && !this.modVib) {
            this.cr.addJmolScript("modulation on" + (this.haveOccupancy ? ";display occupancy > 0.5" : ""));
        }
    }

    private String checkKey(String string, boolean bl) {
        int n = string.indexOf(this.atModel);
        return n < 0 || string.indexOf("*;*") >= 0 || bl && string.indexOf("?") >= 0 ? null : string.substring(0, n);
    }

    public P3 getMod(String string) {
        return this.htModulation.get(string + this.atModel);
    }

    /*
     * WARNING - void declaration
     */
    private void setModulationForStructure(int n) {
        void var9_15;
        Object d;
        String string;
        Map.Entry<String, P3> entry22;
        P3 p3;
        this.atModel = "@" + n;
        if (this.htModulation.containsKey("X_" + this.atModel)) {
            return;
        }
        this.htModulation.put("X_" + this.atModel, new P3());
        this.q123 = new M3();
        this.qs = null;
        for (int i = 0; i < this.modDim; ++i) {
            p3 = this.getMod("W_" + (i + 1));
            if (p3 == null) {
                Logger.info((String)("Not enough cell wave vectors for d=" + this.modDim));
                return;
            }
            this.cr.appendLoadNote("W_" + (i + 1) + " = " + p3);
            if (i == 0) {
                this.q1 = P3.newP((T3)p3);
            }
            this.q123.setRowV(i, (T3)p3);
        }
        this.q1Norm = V3.new3((float)(this.q1.x == 0.0f ? 0.0f : 1.0f), (float)(this.q1.y == 0.0f ? 0.0f : 1.0f), (float)(this.q1.z == 0.0f ? 0.0f : 1.0f));
        P3 p32 = P3.new3((float)1.0f, (float)0.0f, (float)0.0f);
        int n2 = this.cr.atomSetCollection.getAtomCount();
        Hashtable<String, P3> hashtable = new Hashtable<String, P3>();
        for (Map.Entry<String, P3> entry22 : this.htModulation.entrySet()) {
            string = this.checkKey(entry22.getKey(), false);
            if (string == null) continue;
            p3 = (P3)entry22.getValue();
            switch (string.charAt(0)) {
                case 'O': {
                    this.haveOccupancy = true;
                }
                case 'D': 
                case 'U': {
                    if (p3.z != 1.0f || string.charAt(2) == 'S') break;
                    int n3 = string.indexOf("?");
                    if (n3 >= 0) {
                        d = string.substring(n3 + 1);
                        p3 = this.getMod(string.substring(0, 2) + (String)d + "#*;*");
                        if (p3 == null) break;
                        string = string.substring(0, n3);
                        this.addModulation(hashtable, string, p3, n);
                        break;
                    }
                    double d2 = p3.x;
                    double n4 = Math.PI * 2 * (double)p3.y;
                    p3.x = (float)(d2 * Math.cos(n4));
                    p3.y = (float)(d2 * Math.sin(-n4));
                    p3.z = 0.0f;
                    Logger.info((String)("msCIF setting " + string + " " + p3));
                    break;
                }
                case 'W': {
                    if (this.modDim > 1) break;
                }
                case 'F': {
                    if (string.indexOf("_q_") >= 0) {
                        this.cr.appendLoadNote("Wave vector " + string + "=" + p3);
                        break;
                    }
                    P3 p33 = this.getQCoefs(p3);
                    if (p33 == null) {
                        this.cr.appendLoadNote("Cannot match atom wave vector " + string + " " + p3 + " to a cell wave vector or its harmonic");
                        break;
                    }
                    d = string + "_q_";
                    if (this.htModulation.containsKey((String)d + this.atModel)) break;
                    this.addModulation(hashtable, (String)d, p33, n);
                    if (!string.startsWith("F_")) break;
                    this.cr.appendLoadNote("atom wave vector " + string + " = " + p3 + " fn = " + p33);
                }
            }
        }
        if (!hashtable.isEmpty()) {
            this.htModulation.putAll(hashtable);
        }
        boolean bl = false;
        for (Map.Entry entry3 : this.htModulation.entrySet()) {
            string = this.checkKey((String)entry3.getKey(), true);
            if (string == null) continue;
            d = (P3)entry3.getValue();
            String string2 = string.substring(string.indexOf(";") + 1);
            int n3 = string2.indexOf("#=");
            if (n3 >= 0) {
                d = this.getMod(string2.substring(n3 + 2));
                string2 = string2.substring(0, n3);
            }
            if (Logger.debuggingHigh) {
                Logger.debug((String)("SetModulation: " + string + " " + d));
            }
            char c = string.charAt(0);
            n3 = string.indexOf("#") + 1;
            String string3 = null;
            switch (c) {
                case 'U': {
                    string3 = string.substring(4, string.indexOf(";"));
                }
                case 'D': 
                case 'O': {
                    int n4;
                    char c2 = string.charAt(2);
                    char c3 = string.charAt(n3);
                    char c4 = c2 == 'S' ? (char)'s' : (c2 == '0' ? (char)'c' : (c == 'O' ? (char)'o' : (c = c == 'U' ? (char)'u' : 'f')));
                    if (this.htAtomMods == null) {
                        this.htAtomMods = new Hashtable<String, List<Modulation>>();
                    }
                    int n5 = n4 = c2 == 'S' ? 0 : this.cr.parseIntStr(string.substring(2));
                    if (n4 == 0) {
                        this.addAtomModulation(string2, c3, c, (P3)d, string3, p32);
                    } else {
                        P3 p33 = this.getMod("F_" + n4 + "_q_");
                        if (p33 == null) {
                            Logger.error((String)("Missing qlist for F_" + n4));
                            this.cr.appendLoadNote("Missing cell wave vector for atom wave vector " + n4 + " for " + string + " " + d);
                        } else {
                            this.addAtomModulation(string2, c3, c, (P3)d, string3, p33);
                        }
                    }
                    bl = true;
                }
            }
        }
        if (!bl) {
            return;
        }
        this.atoms = this.cr.atomSetCollection.getAtoms();
        this.cr.symmetry = this.cr.atomSetCollection.getSymmetry();
        if (this.cr.symmetry != null) {
            this.nOps = this.cr.symmetry.getSpaceGroupOperationCount();
        }
        this.iopLast = -1;
        entry22 = new SB();
        int i = this.cr.atomSetCollection.getLastAtomSetAtomIndex();
        while (var9_15 < n2) {
            this.modulateAtom(this.atoms[var9_15], (SB)entry22);
            ++var9_15;
        }
        this.cr.atomSetCollection.setAtomSetAtomProperty("modt", entry22.toString(), -1);
        this.cr.appendLoadNote(this.modCount + " modulations for " + this.atomCount + " atoms");
        this.htAtomMods = null;
    }

    private P3 getQCoefs(P3 p3) {
        int n;
        int n2;
        if (this.qs == null) {
            this.qs = new P3[3];
            for (int i = 0; i < 3; ++i) {
                this.qs[i] = this.getMod("W_" + (i + 1));
            }
        }
        P3 p32 = new P3();
        for (n2 = 0; n2 < 3; ++n2) {
            float f;
            if (this.qs[n2] == null || !(Math.abs((f = p3.dot((T3)this.qs[n2]) / this.qs[n2].dot((T3)this.qs[n2])) - (float)(n = Math.round(f))) < 0.001f)) continue;
            switch (n2) {
                case 0: {
                    p32.x = n;
                    break;
                }
                case 1: {
                    p32.y = n;
                    break;
                }
                case 2: {
                    p32.z = n;
                }
            }
            return p32;
        }
        n2 = this.modDim < 2 ? 0 : -3;
        int n3 = this.modDim < 2 ? 0 : 3;
        n = this.modDim < 3 ? 0 : -3;
        int n4 = this.modDim < 3 ? 0 : 3;
        for (int i = -3; i <= 3; ++i) {
            for (int j = n2; j <= n3; ++j) {
                for (int k = n; k <= n4; ++k) {
                    p32.setT((T3)this.qs[0]);
                    p32.scale((float)i);
                    if (this.qs[1] != null) {
                        p32.scaleAdd2((float)j, (T3)this.qs[1], (T3)p32);
                    }
                    if (this.qs[2] != null) {
                        p32.scaleAdd2((float)k, (T3)this.qs[2], (T3)p32);
                    }
                    if (!(p32.distanceSquared((T3)p3) < 1.0E-4f)) continue;
                    p32.set((float)i, (float)j, 0.0f);
                    return p32;
                }
            }
        }
        return null;
    }

    private void addAtomModulation(String string, char c, char c2, P3 p3, String string2, P3 p32) {
        List list = this.htAtomMods.get(string);
        if (list == null) {
            ++this.atomCount;
            list = new List();
            this.htAtomMods.put(string, (List<Modulation>)list);
        }
        list.addLast((Object)new Modulation(c, c2, p3, string2, p32));
        ++this.modCount;
    }

    private void setSubsystemMatrix(String string, M4 m4) {
    }

    public void addSubsystem(String string, M4 m4, String string2) {
        if (this.htSubsystems == null) {
            this.htSubsystems = new Hashtable<String, Object>();
        }
        if (m4 == null) {
            this.htSubsystems.put(";" + string2, string);
        } else {
            this.htSubsystems.put(string, m4);
        }
    }

    private void addUStr(Atom atom, String string, float f) {
        int n = U_LIST.indexOf(string) / 3;
        if (Logger.debuggingHigh) {
            Logger.debug((String)("MOD RDR adding " + string + " " + n + " " + f + " to " + atom.anisoBorU[n]));
        }
        if (atom.anisoBorU == null) {
            Logger.error((String)("MOD RDR cannot modulate nonexistent atom anisoBorU for atom " + atom.atomName));
        } else {
            this.cr.setU(atom, n, f + atom.anisoBorU[n]);
        }
    }

    public void modulateAtom(Atom atom, SB sB) {
        P3 p3;
        List<Modulation> list = this.htAtomMods.get(atom.atomName);
        if (list == null || this.cr.symmetry == null || atom.bsSymmetry == null) {
            return;
        }
        int n = Math.max(atom.bsSymmetry.nextSetBit(0), 0);
        if (this.modLast) {
            n = Math.max((atom.bsSymmetry.length() - 1) % this.nOps, n);
        }
        System.out.println(atom.index + " " + atom.atomName + " " + n + " " + atom.bsSymmetry);
        if (Logger.debuggingHigh) {
            Logger.debug((String)("\nsetModulation: i=" + atom.index + " " + atom.atomName + " xyz=" + atom + " occ=" + atom.foccupancy));
        }
        if (n != this.iopLast) {
            this.iopLast = n;
            this.gammaE = new M3();
            this.cr.symmetry.getSpaceGroupOperation(n).getRotationScale(this.gammaE);
            this.gammaIS = this.cr.symmetry.getOperationGammaIS(n);
        }
        if (Logger.debugging) {
            Logger.debug((String)("setModulation iop = " + n + " " + this.cr.symmetry.getSpaceGroupXyz(n, false) + " " + atom.bsSymmetry));
        }
        M4 m4 = M4.newMV((M3)this.q123, (V3)new V3());
        this.setSubsystemMatrix(atom.atomName, m4);
        ModulationSet modulationSet = new ModulationSet().set(atom.index + " " + atom.atomName, P3.newP((T3)atom), this.modDim, list, this.gammaE, this.gammaIS, m4, n);
        modulationSet.calculate(null, false);
        if (!Float.isNaN(modulationSet.vOcc)) {
            float f;
            p3 = this.getMod("J_O#0;" + atom.atomName);
            float f2 = modulationSet.vOcc0;
            if (Float.isNaN(f2)) {
                f = modulationSet.vOcc;
            } else if (p3 == null) {
                f = atom.foccupancy + modulationSet.vOcc;
            } else if (atom.vib != null) {
                float f3 = atom.vib.x;
                float f4 = atom.foccupancy * f3 / (float)this.nOps / p3.y;
                f = f4 * (p3.y + modulationSet.vOcc);
            } else {
                f = p3.x * (p3.y + modulationSet.vOcc);
            }
            atom.foccupancy = Math.min(1.0f, Math.max(0.0f, f));
        }
        if (modulationSet.htUij != null) {
            if (Logger.debuggingHigh) {
                Logger.debug((String)("setModulation Uij(initial)=" + Escape.eAF((float[])atom.anisoBorU)));
                Logger.debug((String)("setModulation tensor=" + Escape.e((Object)((Tensor)atom.tensors.get(0)).getInfo("all"))));
            }
            for (Map.Entry entry : modulationSet.htUij.entrySet()) {
                this.addUStr(atom, (String)entry.getKey(), ((Float)entry.getValue()).floatValue());
            }
            if (atom.tensors != null) {
                ((Tensor)atom.tensors.get((int)0)).isUnmodulated = true;
            }
            p3 = this.cr.atomSetCollection.addRotatedTensor(atom, this.cr.symmetry.getTensor(atom.anisoBorU), n, false);
            p3.isModulated = true;
            if (Logger.debuggingHigh) {
                Logger.debug((String)("setModulation Uij(final)=" + Escape.eAF((float[])atom.anisoBorU) + "\n"));
                Logger.debug((String)("setModulation tensor=" + ((Tensor)atom.tensors.get(0)).getInfo("all")));
            }
        }
        atom.vib = modulationSet;
        if (this.modVib || atom.foccupancy != 0.0f) {
            float f = this.q1Norm.dot((T3)atom);
            if (Math.abs(f - (float)((int)f)) > 0.001f) {
                f = (int)Math.floor(f);
            }
            sB.append((int)f + "\n");
        }
    }
}

