/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javajs.J2SIgnoreImport;
import javajs.api.ZInputStream;
import javajs.util.List;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolDocument;
import org.jmol.api.JmolZipUtility;
import org.jmol.io.JmolBinary;
import org.jmol.io2.JmolZipInputStream;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Txt;
import org.jmol.viewer.FileManager;

@J2SIgnoreImport(value={BufferedOutputStream.class, ZipOutputStream.class})
public class ZipUtil
implements JmolZipUtility {
    public ZInputStream newZipInputStream(InputStream inputStream) {
        return ZipUtil.newZIS(inputStream);
    }

    private static ZInputStream newZIS(InputStream inputStream) {
        return inputStream instanceof ZInputStream ? (ZInputStream)inputStream : (inputStream instanceof BufferedInputStream ? new JmolZipInputStream(inputStream) : new JmolZipInputStream(new BufferedInputStream(inputStream)));
    }

    public void getAllZipData(InputStream inputStream, String[] stringArray, String string, String string2, Map<String, String> map) {
        ZipUtil.getAllZipDataStatic(inputStream, stringArray, string, string2, map);
    }

    private static void getAllZipDataStatic(InputStream inputStream, String[] stringArray, String string, String string2, Map<String, String> map) {
        ZipInputStream zipInputStream = (ZipInputStream)ZipUtil.newZIS(inputStream);
        SB sB = new SB();
        string2 = "|" + string2 + "|";
        String string3 = Txt.join((String[])stringArray, (char)'/', (int)1);
        String string4 = null;
        if (string3 != null && (string4 = string3.substring(0, string3.indexOf("/") + 1)).length() == 0) {
            string4 = null;
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string5;
                String string6 = zipEntry.getName();
                if (string3 != null && string4 != null && !string6.equals(string3) && !string6.startsWith(string4)) continue;
                sB.append(string6).appendC('\n');
                String string7 = "|" + string6.substring(string6.lastIndexOf("/") + 1) + "|";
                boolean bl = string2.indexOf(string7) >= 0;
                byte[] byArray = JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)zipEntry.getSize());
                if (bl) {
                    string5 = ZipUtil.getBinaryStringForBytes(byArray);
                    string6 = string6 + ":asBinaryString";
                } else {
                    string5 = JmolBinary.fixUTF((byte[])byArray);
                }
                string5 = "BEGIN Directory Entry " + string6 + "\n" + string5 + "\nEND Directory Entry " + string6 + "\n";
                map.put(string + "|" + string6, string5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        map.put("#Directory_Listing", sB.toString());
    }

    private static String getBinaryStringForBytes(byte[] byArray) {
        SB sB = new SB();
        for (int i = 0; i < byArray.length; ++i) {
            sB.append(Integer.toHexString(byArray[i] & 0xFF)).appendC(' ');
        }
        return sB.toString();
    }

    public Object getZipFileContents(BufferedInputStream bufferedInputStream, String[] stringArray, int n, boolean bl) {
        if (stringArray == null || n >= stringArray.length) {
            return this.getZipDirectoryAsStringAndClose(bufferedInputStream);
        }
        String string = stringArray[n];
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        try {
            ZipEntry zipEntry;
            boolean bl2;
            boolean bl3 = string.equals(".");
            if (bl3 || string.lastIndexOf("/") == string.length() - 1) {
                String string2;
                ZipEntry zipEntry2;
                SB sB = new SB();
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    string2 = zipEntry2.getName();
                    if (!bl3 && !string2.startsWith(string)) continue;
                    sB.append(string2).appendC('\n');
                }
                string2 = sB.toString();
                return bl ? JmolBinary.getBIS((byte[])string2.getBytes()) : string2;
            }
            int n2 = string.indexOf(":asBinaryString");
            boolean bl4 = bl2 = n2 > 0;
            if (bl2) {
                string = string.substring(0, n2);
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null && !string.equals(zipEntry.getName())) {
            }
            byte[] byArray = zipEntry == null ? null : JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)zipEntry.getSize());
            zipEntry = null;
            zipInputStream.close();
            if (byArray == null) {
                return "";
            }
            if (JmolBinary.isZipB((byte[])byArray)) {
                return this.getZipFileContents(JmolBinary.getBIS((byte[])byArray), stringArray, ++n, bl);
            }
            if (bl) {
                return JmolBinary.getBIS((byte[])byArray);
            }
            if (bl2) {
                SB sB = new SB();
                for (int i = 0; i < byArray.length; ++i) {
                    sB.append(Integer.toHexString(byArray[i] & 0xFF)).appendC(' ');
                }
                return sB.toString();
            }
            return JmolBinary.fixUTF((byte[])byArray);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public byte[] getZipFileContentsAsBytes(BufferedInputStream bufferedInputStream, String[] stringArray, int n) {
        byte[] byArray = new byte[]{};
        String string = stringArray[n];
        if (string.lastIndexOf("/") == string.length() - 1) {
            return byArray;
        }
        try {
            ZipEntry zipEntry;
            bufferedInputStream = JmolBinary.checkPngZipStream((BufferedInputStream)bufferedInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray2 = JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)zipEntry.getSize());
                return JmolBinary.isZipB((byte[])byArray2) && ++n < stringArray.length ? this.getZipFileContentsAsBytes(JmolBinary.getBIS((byte[])byArray2), stringArray, n) : byArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public String getZipDirectoryAsStringAndClose(BufferedInputStream bufferedInputStream) {
        SB sB = new SB();
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, false);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            Logger.error((String)exception.toString());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            sB.append(stringArray[i]).appendC('\n');
        }
        return sB.toString();
    }

    public String[] getZipDirectoryAndClose(BufferedInputStream bufferedInputStream, boolean bl) {
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, bl);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            Logger.error((String)exception.toString());
        }
        return stringArray;
    }

    private String[] getZipDirectoryOrErrorAndClose(BufferedInputStream bufferedInputStream, boolean bl) throws IOException {
        ZipEntry zipEntry;
        bufferedInputStream = JmolBinary.checkPngZipStream((BufferedInputStream)bufferedInputStream);
        List list = new List();
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        String string = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            if (bl && ZipUtil.isJmolManifest(string2)) {
                string = ZipUtil.getStreamAsString(zipInputStream);
                continue;
            }
            if (string2.startsWith("__MACOS")) continue;
            list.addLast((Object)string2);
        }
        zipInputStream.close();
        if (bl) {
            list.add(0, (Object)(string == null ? "" : string + "\n############\n"));
        }
        return (String[])list.toArray((Object[])new String[list.size()]);
    }

    static String getStreamAsString(InputStream inputStream) throws IOException {
        return JmolBinary.fixUTF((byte[])JmolBinary.getStreamBytes((InputStream)inputStream, (long)-1L));
    }

    private static boolean isJmolManifest(String string) {
        return string.startsWith("JmolManifest");
    }

    public String cacheZipContents(BufferedInputStream bufferedInputStream, String string, Map<String, byte[]> map) {
        ZipInputStream zipInputStream = (ZipInputStream)this.newZipInputStream(bufferedInputStream);
        SB sB = new SB();
        long l = 0L;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                sB.append(string2).appendC('\n');
                long l2 = zipEntry.getSize();
                byte[] byArray = JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)l2);
                l += (long)byArray.length;
                map.put(string + "|" + string2, byArray);
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (l == 0L) {
            return null;
        }
        Logger.info((String)("ZipUtil cached " + l + " bytes from " + string));
        return sB.toString();
    }

    static BufferedInputStream getUnGzippedInputStream(byte[] byArray) {
        try {
            return JmolBinary.getUnzippedInputStream((BufferedInputStream)JmolBinary.getBIS((byte[])byArray));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InputStream newGZIPInputStream(InputStream inputStream) throws IOException {
        return new BufferedInputStream(new GZIPInputStream(inputStream, 512));
    }

    public Object getAtomSetCollectionOrBufferedReaderFromZip(JmolAdapter jmolAdapter, InputStream inputStream, String string, String[] stringArray, Map<String, Object> map, int n, boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3;
        String string2;
        boolean bl4;
        String string3;
        boolean bl5 = n == 1;
        map.put("zipSet", string);
        String[] stringArray2 = (String[])map.get("subFileList");
        if (stringArray2 == null) {
            stringArray2 = ZipUtil.checkSpecialInZip(stringArray);
        }
        String string4 = string3 = stringArray2 == null || n >= stringArray2.length ? null : stringArray2[n];
        if (string3 != null && (string3.startsWith("/") || string3.startsWith("\\"))) {
            string3 = string3.substring(1);
        }
        int n2 = 0;
        if (string3 == null && map.containsKey("modelNumber") && (n2 = ((Integer)map.get("modelNumber")).intValue()) > 0 && bl5) {
            map.remove("modelNumber");
        }
        boolean bl6 = bl4 = (string2 = (String)map.get("manifest")) == null;
        if (bl4) {
            string2 = stringArray.length > 0 ? stringArray[0] : "";
        }
        boolean bl7 = bl3 = string2.length() > 0;
        if (bl3 && Logger.debugging) {
            Logger.debug((String)("manifest for  " + string + ":\n" + string2));
        }
        boolean bl8 = string2.indexOf("IGNORE_ERRORS") >= 0;
        boolean bl9 = string2.indexOf("IGNORE_MANIFEST") >= 0;
        boolean bl10 = bl2 = string2.indexOf("EXCEPT_FILES") >= 0;
        if (bl9 || string3 != null) {
            bl3 = false;
        }
        if (bl4 && bl3 && (object = JmolBinary.getManifestScriptPath((String)string2)) != null) {
            return "NOTE: file recognized as a script file: " + string + (String)object + "\n";
        }
        object = new List();
        Hashtable<AtomSetCollection, Object> hashtable = bl3 ? new Hashtable<AtomSetCollection, Object>() : null;
        boolean bl11 = false;
        Object object2 = ZipUtil.checkSpecialData(inputStream, stringArray);
        if (object2 instanceof String) {
            return object2;
        }
        SB sB = object2;
        try {
            Object object3;
            AtomSetCollection atomSetCollection;
            ZipEntry zipEntry;
            if (sB != null) {
                BufferedReader bufferedReader = JmolBinary.getBR((String)sB.toString());
                if (bl) {
                    return bufferedReader;
                }
                object2 = jmolAdapter.getAtomSetCollectionFromReader(string, (Object)bufferedReader, map);
                if (object2 instanceof String) {
                    return object2;
                }
                if (object2 instanceof AtomSetCollection) {
                    AtomSetCollection atomSetCollection2 = (AtomSetCollection)object2;
                    if (atomSetCollection2.errorMessage != null) {
                        if (bl8) {
                            return null;
                        }
                        return atomSetCollection2.errorMessage;
                    }
                    return atomSetCollection2;
                }
                if (bl8) {
                    return null;
                }
                return "unknown reader error";
            }
            if (inputStream instanceof BufferedInputStream) {
                inputStream = JmolBinary.checkPngZipStream((BufferedInputStream)((BufferedInputStream)inputStream));
            }
            ZipInputStream zipInputStream = (ZipInputStream)JmolBinary.newZipInputStream((InputStream)inputStream);
            if (bl3) {
                string2 = '|' + string2.replace('\r', '|').replace('\n', '|') + '|';
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null && (n2 <= 0 || object.size() < n2)) {
                Object object4;
                Object object5;
                if (zipEntry.isDirectory()) continue;
                atomSetCollection = zipEntry.getName();
                if (string3 != null && !atomSetCollection.equals(string3)) continue;
                if (string3 != null) {
                    map.put("subFileName", string3);
                }
                if (ZipUtil.isJmolManifest((String)atomSetCollection) || bl3 && bl2 == string2.indexOf("|" + (String)atomSetCollection + "|") >= 0) continue;
                byte[] byArray = JmolBinary.getStreamBytes((InputStream)zipInputStream, (long)zipEntry.getSize());
                if (JmolBinary.isGzipB((byte[])byArray)) {
                    byArray = JmolBinary.getStreamBytes((InputStream)ZipUtil.getUnGzippedInputStream(byArray), (long)-1L);
                }
                if (JmolBinary.isZipB((byte[])byArray)) {
                    object3 = JmolBinary.getBIS((byte[])byArray);
                    object5 = JmolBinary.getZipDirectoryAndClose((BufferedInputStream)object3, (boolean)true);
                    object3 = JmolBinary.getBIS((byte[])byArray);
                    object4 = this.getAtomSetCollectionOrBufferedReaderFromZip(jmolAdapter, (InputStream)object3, string + "|" + (String)atomSetCollection, (String[])object5, map, ++n, bl);
                    if (object4 instanceof String) {
                        if (bl8) continue;
                        return object4;
                    }
                    if (object4 instanceof AtomSetCollection || object4 instanceof List) {
                        if (bl3 && !bl2) {
                            hashtable.put(atomSetCollection, object4);
                            continue;
                        }
                        object.addLast(object4);
                        continue;
                    }
                    if (object4 instanceof BufferedReader) {
                        if (bl5) {
                            zipInputStream.close();
                        }
                        return object4;
                    }
                    if (bl8) continue;
                    zipInputStream.close();
                    return "unknown zip reader error";
                }
                if (JmolBinary.isPickleB((byte[])byArray)) {
                    object3 = JmolBinary.getBIS((byte[])byArray);
                    if (bl5) {
                        zipInputStream.close();
                    }
                    return object3;
                }
                if (JmolBinary.isCompoundDocumentB((byte[])byArray)) {
                    object5 = (JmolDocument)Interface.getInterface((String)"jmol.util.CompoundDocument");
                    object5.setStream(JmolBinary.getBIS((byte[])byArray), true);
                    object3 = object5.getAllDataFiles("Molecule", "Input").toString();
                } else {
                    object3 = JmolBinary.fixUTF((byte[])byArray);
                }
                object5 = JmolBinary.getBR((String)object3);
                if (bl) {
                    if (bl5) {
                        zipInputStream.close();
                    }
                    return object5;
                }
                object4 = string + "|" + zipEntry.getName();
                object2 = jmolAdapter.getAtomSetCollectionFromReader((String)object4, object5, map);
                if (!(object2 instanceof AtomSetCollection)) {
                    if (bl8) continue;
                    zipInputStream.close();
                    return "" + object2;
                }
                if (bl3 && !bl2) {
                    hashtable.put(atomSetCollection, object2);
                } else {
                    object.addLast(object2);
                }
                AtomSetCollection atomSetCollection3 = (AtomSetCollection)object2;
                if (atomSetCollection3.errorMessage == null || bl8) continue;
                zipInputStream.close();
                return atomSetCollection3.errorMessage;
            }
            if (bl5) {
                zipInputStream.close();
            }
            if (bl3 && !bl2) {
                atomSetCollection = PT.split((String)string2, (String)"|");
                for (int i = 0; i < ((AtomSetCollection)atomSetCollection).length; ++i) {
                    object3 = atomSetCollection[i];
                    if (object3.length() == 0 || object3.indexOf("#") == 0) continue;
                    if (hashtable.containsKey(object3)) {
                        object.addLast(hashtable.get(object3));
                        continue;
                    }
                    if (!Logger.debugging) continue;
                    Logger.debug((String)("manifested file " + (String)object3 + " was not found in " + string));
                }
            }
            if (!bl5) {
                return object;
            }
            atomSetCollection = new AtomSetCollection("Array", null, null, object);
            if (atomSetCollection.errorMessage != null) {
                if (bl8) {
                    return null;
                }
                return atomSetCollection.errorMessage;
            }
            if (bl11) {
                n2 = 1;
            }
            if (n2 > 0 && n2 <= object.size()) {
                return object.get(n2 - 1);
            }
            return atomSetCollection;
        }
        catch (Exception exception) {
            if (bl8) {
                return null;
            }
            Logger.error((String)("" + exception));
            return "" + exception;
        }
        catch (Error error) {
            Logger.errorEx(null, (Throwable)error);
            return "" + error;
        }
    }

    private static SB checkSpecialData(InputStream inputStream, String[] stringArray) {
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".spardir/") && stringArray[i].indexOf("_spartandir") < 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        SB sB = new SB();
        sB.append("Zip File Directory: ").append("\n").append(Escape.eAS((String[])stringArray, (boolean)true)).append("\n");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ZipUtil.getAllZipDataStatic(inputStream, new String[0], "", "Molecule", hashtable);
        String string = "|";
        String string2 = (String)hashtable.get(string + "output");
        if (string2 == null) {
            string = "|" + stringArray[1];
            string2 = (String)hashtable.get(string + "output");
        }
        sB.append(string2);
        String[] stringArray2 = ZipUtil.getSpartanFileList(string, ZipUtil.getSpartanDirs(string2));
        for (int i = 2; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            if (hashtable.containsKey(string3)) {
                sB.append((String)hashtable.get(string3));
                continue;
            }
            sB.append(string3 + "\n");
        }
        return sB;
    }

    public String[] spartanFileList(String string, String string2) {
        String[] stringArray = ZipUtil.getSpartanDirs(string2);
        if (stringArray.length == 0 && string.endsWith(".spardir.zip") && string2.indexOf(".zip|output") >= 0) {
            String string3 = string.replace('\\', '/');
            int n = string.lastIndexOf(".spardir");
            n = string3.lastIndexOf("/");
            string3 = string + "|" + string.substring(n + 1, string.length() - 4);
            return new String[]{"SpartanSmol", string3, string3 + "/output"};
        }
        return ZipUtil.getSpartanFileList(string, stringArray);
    }

    private static String[] getSpartanDirs(String string) {
        if (string == null) {
            return new String[0];
        }
        if (string.startsWith("java.io.FileNotFoundException") || string.startsWith("FILE NOT FOUND") || string.indexOf("<html") >= 0) {
            return new String[]{"M0001"};
        }
        List list = new List();
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(")")) {
                    list.addLast((Object)string2);
                } else if (string3.equals("Start-") && stringTokenizer.nextToken().equals("Molecule")) {
                    list.addLast((Object)PT.split((String)stringTokenizer.nextToken(), (String)"\"")[1]);
                }
                string2 = string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (String[])list.toArray((Object[])new String[list.size()]);
    }

    private static String[] getSpartanFileList(String string, String[] stringArray) {
        String[] stringArray2 = new String[2 + stringArray.length * 5];
        stringArray2[0] = "SpartanSmol";
        stringArray2[1] = "Directory Entry ";
        int n = 2;
        if ((string = string.replace('\\', '/')).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + (Character.isDigit(stringArray[i].charAt(0)) ? "/Profile." + stringArray[i] : "/" + stringArray[i]);
            stringArray2[n++] = string2 + "/#JMOL_MODEL " + stringArray[i];
            stringArray2[n++] = string2 + "/input";
            stringArray2[n++] = string2 + "/archive";
            stringArray2[n++] = string2 + "/Molecule:asBinaryString";
            stringArray2[n++] = string2 + "/proparc";
        }
        return stringArray2;
    }

    static String[] checkSpecialInZip(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length < 2) {
            stringArray2 = null;
        } else {
            String string = stringArray[1];
            if (string.endsWith(".spardir/") || stringArray.length == 2) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "";
                stringArray2 = stringArray3;
                stringArray3[1] = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
            } else {
                stringArray2 = null;
            }
        }
        return stringArray2;
    }

    public byte[] getCachedPngjBytes(FileManager fileManager, String string) {
        boolean bl;
        if (string.indexOf(".png") < 0) {
            return null;
        }
        Logger.info((String)("FileManager checking PNGJ cache for " + string));
        String string2 = ZipUtil.shortSceneFilename(string);
        if (fileManager.pngjCache == null && !this.cachePngjFile(fileManager, new String[]{string, null})) {
            return null;
        }
        Map map = fileManager.pngjCache;
        boolean bl2 = bl = string.indexOf(".min.") >= 0;
        if (!bl) {
            String string3 = fileManager.getCanonicalName(JmolBinary.getZipRoot((String)string));
            if (!map.containsKey(string3) && !this.cachePngjFile(fileManager, new String[]{string, null})) {
                return null;
            }
            if (string.indexOf("|") < 0) {
                string2 = string3;
            }
        }
        if (map.containsKey(string2)) {
            Logger.info((String)("FileManager using memory cache " + string2));
            return (byte[])map.get(string2);
        }
        if (!bl || !this.cachePngjFile(fileManager, new String[]{string, null})) {
            return null;
        }
        Logger.info((String)("FileManager using memory cache " + string2));
        return (byte[])map.get(string2);
    }

    public boolean cachePngjFile(FileManager fileManager, String[] stringArray) {
        Hashtable<String, byte[]> hashtable = fileManager.pngjCache = new Hashtable<String, byte[]>();
        if (stringArray == null) {
            return false;
        }
        stringArray[1] = null;
        if (stringArray[0] == null) {
            return false;
        }
        stringArray[0] = JmolBinary.getZipRoot((String)stringArray[0]);
        String string = ZipUtil.shortSceneFilename(stringArray[0]);
        try {
            stringArray[1] = this.cacheZipContents(JmolBinary.checkPngZipStream((BufferedInputStream)((BufferedInputStream)fileManager.getBufferedInputStreamOrErrorMessageFromName(stringArray[0], null, false, false, null, false))), string, fileManager.pngjCache);
        }
        catch (Exception exception) {
            return false;
        }
        if (stringArray[1] == null) {
            return false;
        }
        byte[] byArray = stringArray[1].getBytes();
        hashtable.put(fileManager.getCanonicalName(stringArray[0]), byArray);
        if (string.indexOf("_scene_") >= 0) {
            hashtable.put(ZipUtil.shortSceneFilename(stringArray[0]), byArray);
            byArray = (byte[])hashtable.remove(string + "|state.spt");
            if (byArray != null) {
                hashtable.put(ZipUtil.shortSceneFilename(stringArray[0] + "|state.spt"), byArray);
            }
        }
        for (String string2 : hashtable.keySet()) {
            System.out.println(string2);
        }
        return true;
    }

    private static String shortSceneFilename(String string) {
        int n;
        int n2 = string.indexOf("_scene_") + 7;
        if (n2 < 7) {
            return string;
        }
        String string2 = "";
        if (string.endsWith("|state.spt")) {
            n = string.indexOf(46, n2);
            if (n < 0) {
                return string;
            }
            string2 = string.substring(n2, n);
        }
        n = string.lastIndexOf("|");
        return string.substring(0, n2) + string2 + (n > 0 ? string.substring(n) : "");
    }

    public void addZipEntry(Object object, String string) throws IOException {
        ((ZipOutputStream)object).putNextEntry(new ZipEntry(string));
    }

    public void closeZipEntry(Object object) throws IOException {
        ((ZipOutputStream)object).closeEntry();
    }

    public Object getZipOutputStream(Object object) {
        return new ZipOutputStream((OutputStream)object);
    }

    public int getCrcValue(byte[] byArray) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        return (int)cRC32.getValue();
    }
}

