/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import javajs.util.P3;
import javajs.util.T3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.quantum.QMAtom;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

abstract class QuantumCalculation {
    protected boolean doDebug = false;
    protected BS bsExcluded;
    protected static final float bohr_per_angstrom = 1.8897161f;
    protected float[][][] voxelData;
    protected float[][][] voxelDataTemp;
    protected float[] vd;
    protected int[] countsXYZ;
    protected P3[] points;
    protected int xMin;
    protected int xMax;
    protected int yMin;
    protected int yMax;
    protected int zMin;
    protected int zMax;
    protected QMAtom[] qmAtoms;
    protected int atomIndex;
    protected QMAtom thisAtom;
    protected int firstAtomOffset;
    protected float[] xBohr;
    protected float[] yBohr;
    protected float[] zBohr;
    protected float[] originBohr = new float[3];
    protected float[] stepBohr = new float[3];
    protected int nX;
    protected int nY;
    protected int nZ;
    protected float[] X;
    protected float[] Y;
    protected float[] Z;
    protected float[] X2;
    protected float[] Y2;
    protected float[] Z2;
    protected float rangeBohrOrAngstroms = 10.0f;
    protected float unitFactor = 1.8897161f;
    protected float volume = 1.0f;

    QuantumCalculation() {
    }

    protected void initialize(int n, int n2, int n3, P3[] p3Array) {
        this.initialize0(n, n2, n3, p3Array);
    }

    protected void initialize0(int n, int n2, int n3, P3[] p3Array) {
        if (p3Array != null) {
            this.points = p3Array;
            n2 = n3 = p3Array.length;
            n = n3;
        }
        this.nX = this.xMax = n;
        this.nY = this.yMax = n2;
        this.nZ = this.zMax = n3;
        if (this.xBohr != null && this.xBohr.length >= n) {
            return;
        }
        this.xBohr = new float[n];
        this.yBohr = new float[n2];
        this.zBohr = new float[n3];
        this.X = new float[n];
        this.Y = new float[n2];
        this.Z = new float[n3];
        this.X2 = new float[n];
        this.Y2 = new float[n2];
        this.Z2 = new float[n3];
    }

    protected void setupCoordinates(float[] fArray, float[] fArray2, BS bS, P3[] p3Array, P3[] p3Array2, boolean bl) {
        int n;
        if (p3Array2 == null) {
            this.volume = 1.0f;
            n = 3;
            while (--n >= 0) {
                this.originBohr[n] = fArray[n] * this.unitFactor;
                this.stepBohr[n] = fArray2[n] * this.unitFactor;
                this.volume *= this.stepBohr[n];
            }
            Logger.info((String)("QuantumCalculation:\n origin = " + Escape.eAF((float[])fArray) + "\n steps = " + Escape.eAF((float[])fArray2) + "\n origin(Bohr)= " + Escape.eAF((float[])this.originBohr) + "\n steps(Bohr)= " + Escape.eAF((float[])this.stepBohr) + "\n counts= " + this.nX + " " + this.nY + " " + this.nZ));
        }
        if (p3Array != null) {
            int n2;
            this.qmAtoms = new QMAtom[bl ? bS.cardinality() : p3Array.length];
            n = bS == null ? 1 : 0;
            int n3 = n2 = n != 0 ? this.qmAtoms.length - 1 : bS.nextSetBit(0);
            int n4 = 0;
            while (n3 >= 0) {
                this.qmAtoms[bl ? n4++ : n3] = new QMAtom(n3, (Atom)p3Array[n3], this.X, this.Y, this.Z, this.X2, this.Y2, this.Z2, this.unitFactor);
                n3 = n != 0 ? n3 - 1 : bS.nextSetBit(n3 + 1);
            }
        }
    }

    public float processPt(P3 p3) {
        this.doDebug = false;
        if (this.points == null || this.nX != 1) {
            this.initializeOnePoint();
        }
        this.points[0].setT((T3)p3);
        this.voxelDataTemp[0][0][0] = 0.0f;
        this.setXYZBohr(this.points);
        this.processPoints();
        return this.voxelData[0][0][0];
    }

    protected void processPoints() {
        this.process();
    }

    protected void initializeOnePoint() {
        this.initializeOnePointQC();
    }

    protected void initializeOnePointQC() {
        this.points = new P3[1];
        this.points[0] = new P3();
        if (this.voxelData == null || this.voxelData == this.voxelDataTemp) {
            this.voxelDataTemp = new float[1][1][1];
            this.voxelData = this.voxelDataTemp;
        } else {
            this.voxelData = new float[1][1][1];
            this.voxelDataTemp = new float[1][1][1];
        }
        this.zMin = 0;
        this.yMin = 0;
        this.xMin = 0;
        this.initialize(1, 1, 1, this.points);
    }

    protected abstract void process();

    protected void setXYZBohr(P3[] p3Array) {
        this.setXYZBohrI(this.xBohr, 0, this.nX, p3Array);
        this.setXYZBohrI(this.yBohr, 1, this.nY, p3Array);
        this.setXYZBohrI(this.zBohr, 2, this.nZ, p3Array);
    }

    private void setXYZBohrI(float[] fArray, int n, int n2, P3[] p3Array) {
        if (p3Array != null) {
            float f = 0.0f;
            for (int i = 0; i < n2; ++i) {
                switch (n) {
                    case 0: {
                        f = p3Array[i].x;
                        break;
                    }
                    case 1: {
                        f = p3Array[i].y;
                        break;
                    }
                    case 2: {
                        f = p3Array[i].z;
                    }
                }
                fArray[i] = f * this.unitFactor;
            }
            return;
        }
        fArray[0] = this.originBohr[n];
        float f = this.stepBohr[n];
        int n3 = 0;
        while (++n3 < n2) {
            fArray[n3] = fArray[n3 - 1] + f;
        }
    }

    protected void setMinMax(int n) {
        this.zMax = n < 0 ? this.xMax : n + 1;
        this.yMax = this.zMax;
        this.zMin = n < 0 ? 0 : n;
        this.yMin = this.zMin;
    }
}

