/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.List;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Tensor;

public class MagresReader
extends AtomSetCollectionReader {
    private static final int BLOCK_NEW = -2;
    private static final int BLOCK_NONE = -1;
    private static final int BLOCK_CALC = 0;
    private static final int BLOCK_ATOMS = 1;
    private static final int BLOCK_MAGRES = 2;
    private int currentBlock = -1;
    private float[] cellParams;
    private Map<String, String> magresUnits = new Hashtable<String, String>();
    private List<Tensor> interactionTensors = new List();
    private SB header = new SB();

    protected void initializeReader() {
        this.setFractionalCoordinates(false);
        this.ignoreFileSpaceGroupName = true;
    }

    protected void finalizeReader() throws Exception {
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", (Object)this.header.toString());
        this.finalizeReaderASCR();
        if (this.interactionTensors.size() > 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("interactionTensors", this.interactionTensors);
        }
    }

    protected boolean checkLine() throws Exception {
        if (!this.trimLine()) {
            return true;
        }
        switch (this.checkBlock()) {
            case 0: {
                this.header.append(this.line).append("\n");
                this.appendLoadNote(this.line);
                break;
            }
            case 1: {
                if (this.cellParams == null && this.line.startsWith("lattice")) {
                    return this.readCellParams();
                }
                if (this.line.startsWith("symmetry")) {
                    return this.readSymmetry();
                }
                if (this.line.startsWith("units")) {
                    return this.setUnits(false);
                }
                if (!this.line.startsWith("atom")) break;
                return this.readAtom();
            }
            case 2: {
                if (this.line.startsWith("units")) {
                    return this.setUnits(true);
                }
                return this.readTensor();
            }
        }
        return true;
    }

    private boolean trimLine() {
        int n = this.line.indexOf("#");
        if (n >= 0) {
            this.line = this.line.substring(0, n);
        }
        this.line = this.line.trim();
        return this.line.length() > 0;
    }

    private int checkBlock() {
        if (!(this.line.startsWith("<") && this.line.endsWith(">") || this.line.startsWith("[") && this.line.endsWith("]"))) {
            return this.currentBlock;
        }
        this.line = PT.simpleReplace((String)this.line, (String)"<", (String)"[");
        this.line = PT.simpleReplace((String)this.line, (String)">", (String)"]");
        switch ("...............[calculation]..[/calculation].[atoms]........[/atoms].......[magres].......[/magres]......".indexOf(this.line + ".") / 15) {
            case 0: {
                Logger.info((String)("block indicator ignored: " + this.line));
                break;
            }
            case 1: {
                if (this.currentBlock != -1) break;
                this.currentBlock = 0;
                break;
            }
            case 2: {
                if (this.currentBlock != 0) break;
                this.currentBlock = -1;
                break;
            }
            case 3: {
                if (this.currentBlock != -1) break;
                this.currentBlock = 1;
                this.atomSetCollection.newAtomSet();
                this.magresUnits = new Hashtable<String, String>();
                break;
            }
            case 4: {
                if (this.currentBlock != 1) break;
                this.currentBlock = -1;
                break;
            }
            case 5: {
                if (this.currentBlock != -1) break;
                this.currentBlock = 2;
                this.magresUnits = new Hashtable<String, String>();
                this.atomSetCollection.setAtomSetAuxiliaryInfo("magresUnits", this.magresUnits);
                break;
            }
            case 6: {
                if (this.currentBlock != 2) break;
                this.currentBlock = -1;
            }
        }
        return -2;
    }

    private boolean setUnits(boolean bl) {
        String[] stringArray = this.getTokens();
        String string = stringArray[1];
        if (bl) {
            this.appendLoadNote("Ellipsoid set " + Escape.eS((String)string) + ": " + (string.startsWith("ms") ? "Magnetic Shielding" : (string.startsWith("efg") ? "Electric Field Gradient" : (string.startsWith("isc") ? "J-Coupling" : "?"))));
        }
        this.magresUnits.put(string, stringArray[2]);
        return true;
    }

    private boolean readSymmetry() {
        this.setSymmetryOperator(this.getTokens()[1]);
        return true;
    }

    private boolean readCellParams() throws Exception {
        String[] stringArray = this.getTokens();
        this.cellParams = new float[9];
        for (int i = 0; i < 9; ++i) {
            this.cellParams[i] = this.parseFloatStr(stringArray[i + 1]);
        }
        this.addPrimitiveLatticeVector(0, this.cellParams, 0);
        this.addPrimitiveLatticeVector(1, this.cellParams, 3);
        this.addPrimitiveLatticeVector(2, this.cellParams, 6);
        this.setSpaceGroupName("P1");
        return true;
    }

    private boolean readAtom() {
        String string = this.magresUnits.get("atom");
        if (string == null) {
            return true;
        }
        float f = string.startsWith("A") ? 1.0f : 0.5291772f;
        String[] stringArray = this.getTokens();
        Atom atom = new Atom();
        int n = 1;
        atom.elementSymbol = stringArray[n++];
        atom.atomName = MagresReader.getAtomName(stringArray[n++], stringArray[n++]);
        this.atomSetCollection.addAtomWithMappedName(atom);
        float f2 = this.parseFloatStr(stringArray[n++]) * f;
        float f3 = this.parseFloatStr(stringArray[n++]) * f;
        float f4 = this.parseFloatStr(stringArray[n++]) * f;
        atom.set(f2, f3, f4);
        this.setAtomCoord(atom);
        return true;
    }

    private static String getAtomName(String string, String string2) {
        return string + "_" + string2;
    }

    private boolean readTensor() throws Exception {
        int n;
        int n2;
        String string;
        int n3;
        Object object;
        String[] stringArray = this.getTokens();
        String string2 = stringArray[0];
        String string3 = this.magresUnits.get(string2);
        if (string3 == null) {
            Logger.warn((String)(string2 + " ignored; no units defined; line: " + this.line));
            return true;
        }
        boolean bl = string2.startsWith("isc");
        if (stringArray.length == 10) {
            this.magresUnits.remove(string2);
            object = new float[9];
            n3 = 0;
            while (n3 < 9) {
                object[n3++] = this.parseFloatStr(stringArray[n3]);
            }
            Logger.info((String)("Magres reader creating magres_" + string2 + ": " + Escape.eAF((float[])object)));
            this.atomSetCollection.setAtomSetAuxiliaryInfo("magres_" + string2, object);
        }
        object = MagresReader.getAtomName(stringArray[1], stringArray[2]);
        n3 = 3;
        String string4 = string = bl ? MagresReader.getAtomName(stringArray[n3++], stringArray[n3++]) : null;
        if (((String)object).equals(string)) {
            Logger.warn((String)(string2 + " ignored; atom1 == atom2 for " + (String)object + " line: " + this.line));
            return true;
        }
        Object object2 = object;
        if (string != null) {
            object2 = (String)object2 + "//" + string;
        }
        double[][] dArray = new double[3][3];
        for (n2 = 0; n2 < 3; ++n2) {
            for (n = 0; n < 3; ++n) {
                dArray[n2][n] = Double.valueOf(stringArray[n3++]);
            }
        }
        n2 = this.atomSetCollection.getAtomIndexFromName((String)object);
        Tensor tensor = new Tensor().setFromAsymmetricTensor(dArray, string2, (String)object2);
        if (string == null) {
            n = -1;
            this.atomSetCollection.getAtoms()[n2].addTensor(tensor, null, false);
        } else {
            n = this.atomSetCollection.getAtomIndexFromName(string);
            this.interactionTensors.addLast((Object)tensor);
        }
        tensor.setAtomIndexes(n2, n);
        return true;
    }
}

