/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Map;
import javajs.util.List;
import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.constant.EnumStructure;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.AminoMonomer;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.util.Logger;
import org.jmol.util.Measure;

public class AminoPolymer
extends AlphaPolymer {
    private static final float maxHbondAlphaDistance = 9.0f;
    private static final float maxHbondAlphaDistance2 = 81.0f;
    private static final float minimumHbondDistance2 = 0.25f;
    private Map<EnumStructure, float[]> structureList;

    AminoPolymer(Monomer[] monomerArray) {
        super(monomerArray);
        this.type = 1;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (((AminoMonomer)monomerArray[i]).hasOAtom()) continue;
            return;
        }
        this.hasWingPoints = true;
    }

    @Override
    protected void resetHydrogenPoints() {
        ProteinStructure proteinStructure = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            ProteinStructure proteinStructure2 = this.getProteinStructure(i);
            if (proteinStructure2 != null && proteinStructure2 != proteinStructure) {
                proteinStructure = proteinStructure2;
                proteinStructure.resetAxes();
            }
            ((AminoMonomer)this.monomers[i]).resetHydrogenPoint();
        }
    }

    @Override
    protected boolean calcPhiPsiAngles() {
        for (int i = 0; i < this.monomerCount - 1; ++i) {
            this.calcPhiPsiAngles2((AminoMonomer)this.monomers[i], (AminoMonomer)this.monomers[i + 1]);
        }
        return true;
    }

    private void calcPhiPsiAngles2(AminoMonomer aminoMonomer, AminoMonomer aminoMonomer2) {
        Atom atom = aminoMonomer.getNitrogenAtom();
        Atom atom2 = aminoMonomer.getLeadAtom();
        Atom atom3 = aminoMonomer.getCarbonylCarbonAtom();
        Atom atom4 = aminoMonomer2.getNitrogenAtom();
        Atom atom5 = aminoMonomer2.getLeadAtom();
        Atom atom6 = aminoMonomer2.getCarbonylCarbonAtom();
        aminoMonomer2.setGroupParameter(1112539145, Measure.computeTorsion((T3)atom3, (T3)atom4, (T3)atom5, (T3)atom6, (boolean)true));
        aminoMonomer.setGroupParameter(1112539146, Measure.computeTorsion((T3)atom, (T3)atom2, (T3)atom3, (T3)atom4, (boolean)true));
        aminoMonomer.setGroupParameter(1112539144, Measure.computeTorsion((T3)atom2, (T3)atom3, (T3)atom4, (T3)atom5, (boolean)true));
    }

    @Override
    protected float calculateRamachandranHelixAngle(int n, char c) {
        float f = n == 0 ? Float.NaN : this.monomers[n - 1].getGroupParameter(1112539146);
        float f2 = this.monomers[n].getGroupParameter(1112539146);
        float f3 = this.monomers[n].getGroupParameter(1112539145);
        float f4 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getGroupParameter(1112539145);
        float f5 = n == this.monomerCount - 1 ? Float.NaN : this.monomers[n + 1].getGroupParameter(1112539146);
        switch (c) {
            default: {
                float f6 = (float)((double)((f4 - f3) / 2.0f) * Math.PI / 180.0);
                float f7 = (float)((double)((f5 - f2) / 2.0f) * Math.PI / 180.0);
                return (float)(114.59155902616465 * Math.acos(Math.cos(f7) * Math.cos(f6) - Math.sin(f7) * Math.sin(f6) / 3.0));
            }
            case 'C': 
            case 'c': 
        }
        return f2 - f + f4 - f3;
    }

    @Override
    public void calcRasmolHydrogenBonds(BioPolymer bioPolymer, BS bS, BS bS2, List<Bond> list, int n, int[][][] nArray, boolean bl, boolean bl2) {
        if (bioPolymer == null) {
            bioPolymer = this;
        }
        if (!(bioPolymer instanceof AminoPolymer)) {
            return;
        }
        P3 p3 = new P3();
        V3 v3 = new V3();
        int[][] nArray2 = nArray == null ? new int[2][3] : (int[][])null;
        for (int i = 1; i < this.monomerCount; ++i) {
            boolean bl3;
            if (nArray == null) {
                int n2 = this.bioPolymerIndexInModel;
                nArray2[1][0] = n2;
                nArray2[0][0] = n2;
                nArray2[1][1] = Integer.MIN_VALUE;
                nArray2[0][1] = Integer.MIN_VALUE;
                nArray2[1][2] = 0;
                nArray2[0][2] = 0;
            } else {
                nArray2 = nArray[i];
            }
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[i];
            if (!aminoMonomer.getNHPoint(p3, v3, bl, bl2)) continue;
            boolean bl4 = bl3 = bS == null || bS.get(aminoMonomer.getNitrogenAtom().index);
            if (!bl3 || !bl && aminoMonomer.getCarbonylOxygenAtom() == null) continue;
            this.checkRasmolHydrogenBond(aminoMonomer, bioPolymer, i, p3, bl3 ? bS2 : bS, list, nArray2, bl);
        }
    }

    private void checkRasmolHydrogenBond(AminoMonomer aminoMonomer, BioPolymer bioPolymer, int n, P3 p3, BS bS, List<Bond> list, int[][] nArray, boolean bl) {
        Atom atom = aminoMonomer.getLeadAtom();
        Atom atom2 = aminoMonomer.getNitrogenAtom();
        Atom atom3 = aminoMonomer.getNitrogenAtom();
        int n2 = bioPolymer.monomerCount;
        while (--n2 >= 0) {
            int[] nArray2;
            Atom atom4;
            float f;
            AminoMonomer aminoMonomer2;
            Atom atom5;
            if (bioPolymer == this && (n2 == n || n2 + 1 == n) || (atom5 = (aminoMonomer2 = (AminoMonomer)bioPolymer.monomers[n2]).getCarbonylOxygenAtom()) == null || bS != null && !bS.get(atom5.index) || (f = atom.distanceSquared((T3)(atom4 = aminoMonomer2.getLeadAtom()))) >= 81.0f) continue;
            int n3 = this.calcHbondEnergy((P3)atom2, p3, aminoMonomer2, bl);
            if (n3 < nArray[0][2]) {
                nArray2 = nArray[1];
                nArray[1] = nArray[0];
                nArray[0] = nArray2;
            } else {
                if (n3 >= nArray[1][2]) continue;
                nArray2 = nArray[1];
            }
            nArray2[0] = bioPolymer.bioPolymerIndexInModel;
            nArray2[1] = n3 < -500 ? n2 : -1 - n2;
            nArray2[2] = n3;
        }
        if (list != null) {
            for (n2 = 0; n2 < 2; ++n2) {
                if (nArray[n2][1] < 0) continue;
                this.addResidueHydrogenBond(atom3, ((AminoMonomer)((AminoPolymer)bioPolymer).monomers[nArray[n2][1]]).getCarbonylOxygenAtom(), bioPolymer == this ? n : -99, nArray[n2][1], (float)nArray[n2][2] / 1000.0f, list);
            }
        }
    }

    private int calcHbondEnergy(P3 p3, P3 p32, AminoMonomer aminoMonomer, boolean bl) {
        double d;
        double d2;
        double d3;
        Atom atom = aminoMonomer.getCarbonylOxygenAtom();
        if (atom == null) {
            return 0;
        }
        float f = atom.distanceSquared((T3)p3);
        if (f < 0.25f) {
            return 0;
        }
        float f2 = atom.distanceSquared((T3)p32);
        if (f2 < 0.25f) {
            return 0;
        }
        Atom atom2 = aminoMonomer.getCarbonylCarbonAtom();
        float f3 = atom2.distanceSquared((T3)p32);
        if (f3 < 0.25f) {
            return 0;
        }
        float f4 = atom2.distanceSquared((T3)p3);
        if (f4 < 0.25f) {
            return 0;
        }
        double d4 = Math.sqrt(f2);
        int n = HBond.getEnergy((double)d4, (double)(d3 = Math.sqrt(f3)), (double)(d2 = Math.sqrt(f4)), (double)(d = Math.sqrt(f)));
        boolean bl2 = n < -500 && (!bl || d2 > d3 && d4 <= 3.0);
        return !bl2 && bl || n < -9900 ? 0 : n;
    }

    private void addResidueHydrogenBond(Atom atom, Atom atom2, int n, int n2, float f, List<Bond> list) {
        int n3;
        switch (n - n2) {
            case 2: {
                n3 = 6144;
                break;
            }
            case 3: {
                n3 = 8192;
                break;
            }
            case 4: {
                n3 = 10240;
                break;
            }
            case 5: {
                n3 = 12288;
                break;
            }
            case -3: {
                n3 = 14336;
                break;
            }
            case -4: {
                n3 = 16384;
                break;
            }
            default: {
                n3 = 4096;
            }
        }
        list.addLast((Object)new HBond(atom, atom2, n3, 1, 0, f));
    }

    @Override
    public void calculateStructures(boolean bl) {
        int n;
        if (bl) {
            return;
        }
        if (this.structureList == null) {
            this.structureList = this.model.getModelSet().getStructureList();
        }
        char[] cArray = new char[this.monomerCount];
        for (n = 0; n < this.monomerCount - 1; ++n) {
            AminoMonomer aminoMonomer = (AminoMonomer)this.monomers[n];
            AminoMonomer aminoMonomer2 = (AminoMonomer)this.monomers[n + 1];
            float f = aminoMonomer2.getGroupParameter(1112539145);
            float f2 = aminoMonomer.getGroupParameter(1112539146);
            cArray[n] = this.isHelix(f2, f) ? (f < 0.0f && f2 < 25.0f ? 52 : 51) : (this.isSheet(f2, f) ? 115 : (this.isTurn(f2, f) ? 116 : 110));
            if (!Logger.debugging) continue;
            Logger.debug((String)(0 + this.monomers[0].getChainID() + " aminopolymer:" + n + " " + aminoMonomer2.getGroupParameter(1112539145) + "," + aminoMonomer.getGroupParameter(1112539146) + " " + cArray[n]));
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n2;
            if (cArray[n] != '4') continue;
            for (n2 = n + 1; n2 < this.monomerCount && cArray[n2] == '4'; ++n2) {
            }
            if (--n2 >= n + 3) {
                this.addStructureProtected(EnumStructure.HELIX, null, 0, 0, n, n2);
            }
            n = n2;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n3;
            if (cArray[n] != '3') continue;
            for (n3 = n + 1; n3 < this.monomerCount && cArray[n3] == '3'; ++n3) {
            }
            if (--n3 >= n + 3) {
                this.addStructureProtected(EnumStructure.HELIX, null, 0, 0, n, n3);
            }
            n = n3;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n4;
            if (cArray[n] != 's') continue;
            for (n4 = n + 1; n4 < this.monomerCount && cArray[n4] == 's'; ++n4) {
            }
            if (--n4 >= n + 2) {
                this.addStructureProtected(EnumStructure.SHEET, null, 0, 0, n, n4);
            }
            n = n4;
        }
        for (n = 0; n < this.monomerCount; ++n) {
            int n5;
            if (cArray[n] != 't') continue;
            for (n5 = n + 1; n5 < this.monomerCount && cArray[n5] == 't'; ++n5) {
            }
            if (--n5 >= n + 2) {
                this.addStructureProtected(EnumStructure.TURN, null, 0, 0, n, n5);
            }
            n = n5;
        }
    }

    private boolean isTurn(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(EnumStructure.TURN), f, f2);
    }

    private boolean isSheet(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(EnumStructure.SHEET), f, f2);
    }

    private boolean isHelix(float f, float f2) {
        return AminoPolymer.checkPhiPsi(this.structureList.get(EnumStructure.HELIX), f, f2);
    }

    private static boolean checkPhiPsi(float[] fArray, float f, float f2) {
        for (int i = 0; i < fArray.length; i += 4) {
            if (!(f2 >= fArray[i]) || !(f2 <= fArray[i + 1]) || !(f >= fArray[i + 2]) || !(f <= fArray[i + 3])) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setStructureList(Map<EnumStructure, float[]> map) {
        this.structureList = map;
    }
}

