/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderbio;

import javajs.util.P3;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.constant.EnumStructure;
import org.jmol.modelsetbio.AlphaPolymer;
import org.jmol.modelsetbio.Helix;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.modelsetbio.Sheet;
import org.jmol.renderbio.StrandsRenderer;
import org.jmol.shapebio.BioShape;

public class RocketsRenderer
extends StrandsRenderer {
    protected boolean newRockets = false;
    protected boolean renderArrowHeads;
    protected P3[] cordMidPoints;
    protected boolean tPending;
    private ProteinStructure proteinstructurePending;
    private int startIndexPending;
    private int endIndexPending;
    private P3 screenA = new P3();
    private P3 screenB = new P3();
    private P3 screenC = new P3();
    private V3 vtemp = new V3();
    private static final byte[] boxFaces = new byte[]{0, 1, 3, 2, 0, 2, 6, 4, 0, 4, 5, 1, 7, 5, 4, 6, 7, 6, 2, 3, 7, 3, 1, 5};
    private final P3[] corners = new P3[8];
    private final P3[] screenCorners = new P3[8];
    private final P3 pointTipOffset;
    private final V3 scaledWidthVector;
    private final V3 scaledHeightVector;
    private static final byte[] arrowHeadFaces = new byte[]{0, 1, 3, 2, 0, 4, 5, 2, 1, 4, 5, 3};
    private final V3 lengthVector;
    private final P3 pointCorner;

    public RocketsRenderer() {
        int n = 8;
        while (--n >= 0) {
            this.screenCorners[n] = new P3();
            this.corners[n] = new P3();
        }
        this.pointTipOffset = new P3();
        this.scaledWidthVector = new V3();
        this.scaledHeightVector = new V3();
        this.lengthVector = new V3();
        this.pointCorner = new P3();
    }

    @Override
    protected void renderBioShape(BioShape bioShape) {
        boolean bl;
        if (!(bioShape.bioPolymer instanceof AlphaPolymer)) {
            return;
        }
        if (this.wireframeOnly) {
            this.renderStrands();
            return;
        }
        boolean bl2 = bl = !this.viewer.getBoolean(603979900);
        if (this.renderArrowHeads != bl) {
            bioShape.falsifyMesh();
            this.renderArrowHeads = bl;
        }
        this.calcRopeMidPoints(this.newRockets);
        this.calcScreenControlPoints(this.cordMidPoints);
        this.controlPoints = this.cordMidPoints;
        this.renderRockets();
        this.viewer.freeTempPoints(this.cordMidPoints);
    }

    protected boolean isSheet(int n) {
        return this.structureTypes[n] == EnumStructure.SHEET;
    }

    protected void calcRopeMidPoints(boolean bl) {
        P3 p3;
        int n = this.monomerCount + 1;
        this.cordMidPoints = this.viewer.allocTempPoints(n);
        ProteinStructure proteinStructure = null;
        for (int i = 0; i < this.monomerCount; ++i) {
            p3 = this.cordMidPoints[i];
            Monomer monomer = this.monomers[i];
            if (bl && this.renderArrowHeads) {
                p3.setT((T3)this.controlPoints[i]);
                continue;
            }
            if (this.isHelix(i) || !bl && this.isSheet(i)) {
                ProteinStructure proteinStructure2 = monomer.getProteinStructure();
                p3.setT((T3)(i - 1 != proteinStructure2.getMonomerIndex() ? proteinStructure2.getAxisStartPoint() : proteinStructure2.getAxisEndPoint()));
                proteinStructure = proteinStructure2;
                continue;
            }
            if (proteinStructure != null) {
                p3.setT((T3)proteinStructure.getAxisEndPoint());
            } else {
                p3.setT((T3)this.controlPoints[i]);
            }
            proteinStructure = null;
        }
        p3 = this.cordMidPoints[this.monomerCount];
        if (proteinStructure != null) {
            p3.setT((T3)proteinStructure.getAxisEndPoint());
        } else {
            p3.setT((T3)this.controlPoints[this.monomerCount]);
        }
    }

    protected void renderRockets() {
        this.tPending = false;
        int n = this.bsVisible.nextSetBit(0);
        while (n >= 0) {
            Monomer monomer = this.monomers[n];
            if (this.isHelix(n) || this.isSheet(n)) {
                this.renderSpecialSegment(monomer, this.getLeadColix(n), this.mads[n]);
            } else {
                this.renderPending();
                this.renderHermiteConic(n, true);
            }
            n = this.bsVisible.nextSetBit(n + 1);
        }
        this.renderPending();
    }

    protected void renderSpecialSegment(Monomer monomer, short s, short s2) {
        ProteinStructure proteinStructure = monomer.getProteinStructure();
        if (this.tPending) {
            if (proteinStructure == this.proteinstructurePending && s2 == this.mad && s == this.colix && proteinStructure.getIndex(monomer) == this.endIndexPending + 1) {
                ++this.endIndexPending;
                return;
            }
            this.renderPending();
        }
        this.proteinstructurePending = proteinStructure;
        this.startIndexPending = this.endIndexPending = proteinStructure.getIndex(monomer);
        this.colix = s;
        this.mad = s2;
        this.tPending = true;
    }

    protected void renderPending() {
        boolean bl;
        if (!this.tPending) {
            return;
        }
        P3[] p3Array = this.proteinstructurePending.getSegments();
        boolean bl2 = bl = this.endIndexPending == this.proteinstructurePending.getMonomerCount() - 1;
        if (this.proteinstructurePending instanceof Helix) {
            this.renderPendingRocketSegment(this.endIndexPending, p3Array[this.startIndexPending], p3Array[this.endIndexPending], p3Array[this.endIndexPending + 1], bl);
        } else if (this.proteinstructurePending instanceof Sheet) {
            this.renderPendingSheet(p3Array[this.startIndexPending], p3Array[this.endIndexPending], p3Array[this.endIndexPending + 1], bl);
        }
        this.tPending = false;
    }

    private void renderPendingRocketSegment(int n, P3 p3, P3 p32, P3 p33, boolean bl) {
        this.viewer.transformPt3f(p3, this.screenA);
        this.viewer.transformPt3f(p33, this.screenB);
        int n2 = (int)Math.floor((this.screenA.z + this.screenB.z) / 2.0f);
        int n3 = (int)this.viewer.scaleToScreen(n2, (int)this.mad);
        if (this.g3d.setColix(this.colix)) {
            this.g3d.fillCylinderBits((byte)2, n3, this.screenA, this.screenB);
            if (bl && this.renderArrowHeads) {
                this.vtemp.sub2((T3)p33, (T3)p3);
                this.vtemp.normalize();
                this.screenA.scaleAdd2(4.0f, (T3)this.vtemp, (T3)p33);
                this.viewer.transformPt3f(this.screenA, this.screenC);
                this.renderCone(n, p33, this.screenA, this.screenB, this.screenC);
            }
            if (this.startIndexPending == this.endIndexPending) {
                return;
            }
            P3 p34 = this.screenB;
            this.screenB = this.screenC;
            this.screenC = p34;
        }
    }

    protected void renderCone(int n, P3 p3, P3 p32, P3 p33, P3 p34) {
        int n2 = (this.mad << 1) - (this.mad >> 1);
        n2 = (int)this.viewer.scaleToScreen((int)Math.floor(p33.z), n2);
        this.g3d.fillConeSceen3f((byte)2, n2, p33, p34);
    }

    private void renderPendingSheet(P3 p3, P3 p32, P3 p33, boolean bl) {
        if (!this.g3d.setColix(this.colix)) {
            return;
        }
        if (bl && this.renderArrowHeads) {
            this.drawArrowHeadBox(p32, p33);
            this.drawBox(p3, p32);
        } else {
            this.drawBox(p3, p33);
        }
    }

    void buildBox(P3 p3, V3 v3, V3 v32, V3 v33) {
        int n = 8;
        while (--n >= 0) {
            P3 p32 = this.corners[n];
            p32.setT((T3)p3);
            if ((n & 1) != 0) {
                p32.add((T3)v3);
            }
            if ((n & 2) != 0) {
                p32.add((T3)v32);
            }
            if ((n & 4) != 0) {
                p32.add((T3)v33);
            }
            this.viewer.transformPt3f(p32, this.screenCorners[n]);
        }
    }

    void buildArrowHeadBox(P3 p3, V3 v3, V3 v32, P3 p32) {
        int n = 4;
        while (--n >= 0) {
            P3 p33 = this.corners[n];
            p33.setT((T3)p3);
            if ((n & 1) != 0) {
                p33.add((T3)v3);
            }
            if ((n & 2) != 0) {
                p33.add((T3)v32);
            }
            this.viewer.transformPt3f(p33, this.screenCorners[n]);
        }
        this.corners[4].setT((T3)p32);
        this.viewer.transformPt3f(p32, this.screenCorners[4]);
        this.corners[5].add2((T3)p32, (T3)v32);
        this.viewer.transformPt3f(this.corners[5], this.screenCorners[5]);
    }

    void drawBox(P3 p3, P3 p32) {
        this.setBox(1.0f, 0.25f, p3);
        this.lengthVector.sub2((T3)p32, (T3)p3);
        this.buildBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.lengthVector);
        for (int i = 0; i < 6; ++i) {
            byte by = boxFaces[i * 4];
            byte by2 = boxFaces[i * 4 + 1];
            byte by3 = boxFaces[i * 4 + 2];
            byte by4 = boxFaces[i * 4 + 3];
            this.g3d.fillQuadrilateral(this.screenCorners[by], this.screenCorners[by2], this.screenCorners[by3], this.screenCorners[by4]);
        }
    }

    private void setBox(float f, float f2, P3 p3) {
        Sheet sheet = (Sheet)this.proteinstructurePending;
        float f3 = (float)this.mad / 1000.0f;
        this.scaledWidthVector.setT((T3)sheet.getWidthUnitVector());
        this.scaledWidthVector.scale(f3 * f);
        this.scaledHeightVector.setT((T3)sheet.getHeightUnitVector());
        this.scaledHeightVector.scale(f3 * f2);
        this.pointCorner.scaleAdd2(-0.5f, (T3)p3, (T3)this.scaledHeightVector);
        this.pointCorner.add((T3)this.scaledWidthVector);
    }

    void drawArrowHeadBox(P3 p3, P3 p32) {
        this.setBox(1.25f, 0.333f, p3);
        this.pointTipOffset.scaleAdd2(-0.5f, (T3)p32, (T3)this.scaledHeightVector);
        this.buildArrowHeadBox(this.pointCorner, this.scaledWidthVector, this.scaledHeightVector, this.pointTipOffset);
        this.g3d.fillTriangle3f(this.screenCorners[0], this.screenCorners[1], this.screenCorners[4], true);
        this.g3d.fillTriangle3f(this.screenCorners[2], this.screenCorners[3], this.screenCorners[5], true);
        for (int i = 0; i < 12; i += 4) {
            byte by = arrowHeadFaces[i];
            byte by2 = arrowHeadFaces[i + 1];
            byte by3 = arrowHeadFaces[i + 2];
            byte by4 = arrowHeadFaces[i + 3];
            this.g3d.fillQuadrilateral(this.screenCorners[by], this.screenCorners[by2], this.screenCorners[by3], this.screenCorners[by4]);
        }
    }
}

