/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import java.util.Map;
import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.PT;
import javajs.util.T3;
import javajs.util.T3i;
import javajs.util.V3;
import org.jmol.java.BS;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Ellipsoid;
import org.jmol.shapespecial.Ellipsoids;
import org.jmol.util.C;
import org.jmol.util.GData;
import org.jmol.util.Normix;
import org.jmol.viewer.JC;

public final class EllipsoidsRenderer
extends ShapeRenderer {
    private Ellipsoids ellipsoids;
    private boolean[] bGlobals = new boolean[7];
    private boolean[] bOptions = new boolean[7];
    private final String[] OPTS = new String[]{"dots", "arcs", "axes", "fill", "ball", "arrows", "wireframe"};
    private static final int OPT_DOTS = 0;
    private static final int OPT_ARCS = 1;
    private static final int OPT_AXES = 2;
    private static final int OPT_FILL = 3;
    private static final int OPT_BALL = 4;
    private static final int OPT_ARROWS = 5;
    private static final int OPT_WIREFRAME = 6;
    private static final int OPT_COUNT = 7;
    private boolean fillArc;
    private boolean isSet;
    private int diameter;
    private int diameter0;
    private int dotCount;
    private int dotScale;
    private int dx;
    private int eigenSignMask = 7;
    private int iCutout = -1;
    private int selectedOctant = -1;
    private int[] coords;
    private V3[] axes;
    private P3 center;
    private float perspectiveFactor;
    private BS bsTemp = new BS();
    private M3 mat = new M3();
    private M3 mTemp = new M3();
    private M4 mDeriv = new M4();
    private M3 matScreenToCartesian = new M3();
    private M3 matScreenToEllipsoid = new M3();
    private M3 matEllipsoidToScreen = new M3();
    private final double[] coefs = new double[10];
    private final float[] factoredLengths = new float[3];
    private final P3i[] selectedPoints = new P3i[3];
    private final V3 v1 = new V3();
    private final V3 v2 = new V3();
    private final V3 v3 = new V3();
    private final P3 pt1 = new P3();
    private final P3 pt2 = new P3();
    private final P3i s0 = new P3i();
    private final P3i s1 = new P3i();
    private final P3i s2 = new P3i();
    private static final float toRadians = (float)Math.PI / 180;
    private static final float[] cossin = new float[36];
    private static final V3[] unitAxisVectors;
    private final P3i[] screens = new P3i[38];
    private final P3[] points = new P3[6];
    private static int[] axisPoints;
    private static int[] octants;

    public EllipsoidsRenderer() {
        int n;
        for (n = 0; n < this.points.length; ++n) {
            this.points[n] = new P3();
        }
        for (n = 0; n < this.screens.length; ++n) {
            this.screens[n] = new P3i();
        }
    }

    protected boolean render() {
        this.isSet = false;
        this.ellipsoids = (Ellipsoids)this.shape;
        if (!this.ellipsoids.isActive()) {
            return false;
        }
        boolean bl = false;
        if (!this.isSet) {
            this.isSet = this.setGlobals();
        }
        if (!this.ellipsoids.atomEllipsoids.isEmpty()) {
            bl |= this.renderEllipsoids(this.ellipsoids.atomEllipsoids, false);
        }
        if (!this.ellipsoids.simpleEllipsoids.isEmpty()) {
            bl |= this.renderEllipsoids(this.ellipsoids.simpleEllipsoids, true);
        }
        this.coords = null;
        return bl;
    }

    private boolean setGlobals() {
        this.bGlobals[1] = this.viewer.getBooleanProperty("ellipsoidArcs");
        this.bGlobals[5] = this.viewer.getBooleanProperty("ellipsoidArrows");
        this.bGlobals[2] = this.viewer.getBooleanProperty("ellipsoidAxes");
        this.bGlobals[4] = this.viewer.getBooleanProperty("ellipsoidBall");
        this.bGlobals[0] = this.viewer.getBooleanProperty("ellipsoidDots");
        this.bGlobals[3] = this.viewer.getBooleanProperty("ellipsoidFill");
        this.bGlobals[6] = !this.isExport && !this.viewer.checkMotionRendering(1113198596);
        this.diameter0 = Math.round(((Float)this.viewer.getParameter("ellipsoidAxisDiameter")).floatValue() * 1000.0f);
        M4 m4 = this.viewer.getMatrixtransform();
        this.mat.setRow(0, m4.m00, m4.m01, m4.m02);
        this.mat.setRow(1, m4.m10, m4.m11, m4.m12);
        this.mat.setRow(2, m4.m20, m4.m21, m4.m22);
        this.matScreenToCartesian.invertM(this.mat);
        this.setLogic();
        return true;
    }

    private void setOptions(String string) {
        int n;
        for (n = 0; n < 7; ++n) {
            this.bOptions[n] = this.bGlobals[n];
        }
        if (string != null) {
            string = ";" + string + ";";
            for (n = 0; n < 7; ++n) {
                if (PT.isOneOf((String)this.OPTS[n], (String)string)) {
                    this.bOptions[n] = true;
                    continue;
                }
                if (!PT.isOneOf((String)("no" + this.OPTS[n]), (String)string)) continue;
                this.bOptions[n] = false;
            }
        }
        this.setLogic();
    }

    private void setLogic() {
        this.bOptions[0] = this.bOptions[0] & !this.bOptions[6];
        this.bOptions[4] = this.bOptions[4] & !this.bOptions[6];
        this.bOptions[3] = this.bOptions[3] & !this.bOptions[6];
        boolean bl = this.fillArc = this.bOptions[3] && !this.bOptions[4];
        if (this.fillArc) {
            this.g3d.addRenderer(1073742182);
        }
        if (this.bOptions[4]) {
            this.bOptions[0] = false;
        }
        if (!(this.bOptions[0] || this.bOptions[1] || this.bOptions[4])) {
            this.bOptions[2] = true;
        }
        if (this.bOptions[0]) {
            this.bOptions[1] = false;
            this.bOptions[3] = false;
            this.dotScale = this.viewer.getInt(0x21000010);
        }
        if (this.bOptions[0]) {
            this.dotCount = (Integer)this.viewer.getParameter("ellipsoidDotCount");
            if (this.coords == null || this.coords.length != this.dotCount * 3) {
                this.coords = new int[this.dotCount * 3];
            }
        }
    }

    private boolean renderEllipsoids(Map<?, Ellipsoid> map, boolean bl) {
        boolean bl2 = false;
        Atom atom = null;
        for (Ellipsoid ellipsoid : map.values()) {
            if (!ellipsoid.visible) continue;
            if (bl) {
                this.colix = ellipsoid.colix;
            } else {
                atom = this.modelSet.atoms[ellipsoid.tensor.atomIndex1];
                if (atom.sZ <= 1 || !atom.isVisible(this.myVisibilityFlag)) continue;
                this.colix = C.getColixInherited((short)ellipsoid.colix, (short)atom.getColix());
            }
            if (!this.g3d.setColix(this.colix)) {
                bl2 = true;
                continue;
            }
            this.viewer.transformPtScr(ellipsoid.center, this.s0);
            this.renderOne(ellipsoid);
        }
        return bl2;
    }

    private void renderOne(Ellipsoid ellipsoid) {
        this.center = ellipsoid.center;
        int n = 2;
        float f = 0.0f;
        int n2 = 3;
        while (--n2 >= 0) {
            this.factoredLengths[n2] = Math.max(ellipsoid.getLength(n2), 0.02f);
            float f2 = this.factoredLengths[n2];
            if (!(f2 > f)) continue;
            f = f2;
            n = n2;
        }
        this.axes = ellipsoid.tensor.eigenVectors;
        this.setMatrices();
        this.setAxes(n);
        if (this.g3d.isClippedXY(this.dx + this.dx, this.s0.x, this.s0.y)) {
            return;
        }
        this.eigenSignMask = ellipsoid.tensor.eigenSignMask;
        this.setOptions(ellipsoid.options);
        this.diameter = (int)this.viewer.scaleToScreen(this.s0.z, this.bOptions[6] ? 1 : this.diameter0);
        if (ellipsoid.tensor.isIsotropic) {
            this.renderBall();
            return;
        }
        if (this.bOptions[4]) {
            this.renderBall();
            if (this.bOptions[1] || this.bOptions[2]) {
                this.g3d.setColix(this.viewer.getColixBackgroundContrast());
                if (this.bOptions[2]) {
                    this.renderAxes();
                }
                if (this.bOptions[1]) {
                    this.renderArcs();
                }
                this.g3d.setColix(this.colix);
            }
        } else {
            if (this.bOptions[2]) {
                this.renderAxes();
            }
            if (this.bOptions[1]) {
                this.renderArcs();
            }
        }
        if (this.bOptions[0]) {
            this.renderDots();
        }
        if (this.bOptions[5]) {
            this.renderArrows();
        }
    }

    private void setMatrices() {
        for (int i = 0; i < 3; ++i) {
            this.v1.setT((T3)this.axes[i]);
            this.v1.scale(this.factoredLengths[i]);
            this.mat.setColumnV(i, this.v1);
        }
        this.mat.invertM(this.mat);
        this.matScreenToEllipsoid.mul2(this.mat, this.matScreenToCartesian);
        this.matEllipsoidToScreen.invertM(this.matScreenToEllipsoid);
        this.perspectiveFactor = this.viewer.scaleToPerspective(this.s0.z, 1.0f);
        this.matScreenToEllipsoid.mulf(1.0f / this.perspectiveFactor);
    }

    private void setAxes(int n) {
        for (int i = 0; i < 6; ++i) {
            int n2 = axisPoints[i];
            int n3 = Math.abs(n2) - 1;
            this.points[i].scaleAdd2(this.factoredLengths[n3] * (float)(n2 < 0 ? -1 : 1), (T3)this.axes[n3], (T3)this.center);
            this.pt1.setT((T3)unitAxisVectors[i]);
            this.matEllipsoidToScreen.transform((T3)this.pt1);
            this.screens[i].set(Math.round((float)this.s0.x + this.pt1.x * this.perspectiveFactor), Math.round((float)this.s0.y + this.pt1.y * this.perspectiveFactor), Math.round(this.pt1.z + (float)this.s0.z));
            this.screens[i + 32].set(Math.round((float)this.s0.x + this.pt1.x * this.perspectiveFactor * 1.05f), Math.round((float)this.s0.y + this.pt1.y * this.perspectiveFactor * 1.05f), Math.round(this.pt1.z * 1.05f + (float)this.s0.z));
        }
        this.dx = 2 + (int)this.viewer.scaleToScreen(this.s0.z, Math.round((Float.isNaN(this.factoredLengths[n]) ? 1.0f : this.factoredLengths[n]) * 1000.0f));
    }

    private void renderBall() {
        this.setSelectedOctant();
        Ellipsoid.getEquationForQuadricWithCenter(this.s0.x, this.s0.y, this.s0.z, this.matScreenToEllipsoid, this.v1, this.mTemp, this.coefs, this.mDeriv);
        this.g3d.fillEllipsoid(this.center, this.points, this.s0.x, this.s0.y, this.s0.z, this.dx + this.dx, this.matScreenToEllipsoid, this.coefs, this.mDeriv, this.selectedOctant, this.selectedOctant >= 0 ? this.selectedPoints : null);
    }

    private void renderArrows() {
        for (int i = 0; i < 6; i += 2) {
            int n = i == 0 ? 1 : i;
            this.fillConeScreen(this.screens[i], this.screens[i + 1], (this.eigenSignMask & n) != 0);
        }
    }

    private void fillConeScreen(P3i p3i, P3i p3i2, boolean bl) {
        if (this.diameter == 0) {
            return;
        }
        float f = (this.diameter == 0 ? 1 : this.diameter) * 8;
        this.v1.set((float)(p3i2.x - p3i.x), (float)(p3i2.y - p3i.y), (float)(p3i2.z - p3i.z));
        this.v1.normalize();
        this.v1.scale(f);
        this.s1.setT((T3i)p3i);
        this.s2.setT((T3i)p3i);
        if (bl) {
            this.s2.x -= (int)this.v1.x;
            this.s2.y -= (int)this.v1.y;
            this.s2.z -= (int)this.v1.z;
        } else {
            this.s1.x -= (int)this.v1.x;
            this.s1.y -= (int)this.v1.y;
            this.s1.z -= (int)this.v1.z;
        }
        this.g3d.fillConeScreen((byte)2, (int)f, this.s1, this.s2, false);
        this.s1.setT((T3i)p3i2);
        this.s2.setT((T3i)p3i2);
        if (bl) {
            this.s2.x += (int)this.v1.x;
            this.s2.y += (int)this.v1.y;
            this.s2.z += (int)this.v1.z;
        } else {
            this.s1.x += (int)this.v1.x;
            this.s1.y += (int)this.v1.y;
            this.s1.z += (int)this.v1.z;
        }
        this.g3d.fillConeScreen((byte)2, (int)f, this.s1, this.s2, false);
    }

    private void renderAxes() {
        if (this.bOptions[4] && this.bOptions[3]) {
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[0]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[1]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.s0, this.selectedPoints[2]);
            return;
        }
        if (this.bOptions[4]) {
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[32], this.screens[33]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[34], this.screens[35]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[36], this.screens[37]);
        } else {
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[0], this.screens[1]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[2], this.screens[3]);
            this.g3d.fillCylinder((byte)2, this.diameter, this.screens[4], this.screens[5]);
        }
    }

    private void renderDots() {
        int n = 0;
        while (n < this.coords.length) {
            float f;
            float f2 = (float)Math.random();
            float f3 = (float)Math.random();
            if (Float.isNaN(f = (float)Math.sqrt(1.0f - (f2 *= (float)(Math.random() > 0.5 ? -1 : 1)) * f2 - (f3 *= (float)(Math.random() > 0.5 ? -1 : 1)) * f3))) continue;
            f = (float)(Math.random() > 0.5 ? -1 : 1) * f;
            this.pt1.scaleAdd2(f2 * this.factoredLengths[0], (T3)this.axes[0], (T3)this.center);
            this.pt1.scaleAdd2(f3 * this.factoredLengths[1], (T3)this.axes[1], (T3)this.pt1);
            this.pt1.scaleAdd2(f * this.factoredLengths[2], (T3)this.axes[2], (T3)this.pt1);
            this.viewer.transformPtScr(this.pt1, this.s1);
            this.coords[n++] = this.s1.x;
            this.coords[n++] = this.s1.y;
            this.coords[n++] = this.s1.z;
        }
        this.g3d.drawPoints(this.dotCount, this.coords, this.dotScale);
    }

    private void renderArcs() {
        if (this.g3d.drawEllipse(this.center, this.points[0], this.points[2], this.fillArc, this.bOptions[6])) {
            this.g3d.drawEllipse(this.center, this.points[2], this.points[5], this.fillArc, this.bOptions[6]);
            this.g3d.drawEllipse(this.center, this.points[5], this.points[0], this.fillArc, this.bOptions[6]);
            return;
        }
        for (int i = 1; i < 8; i += 2) {
            int n = i * 3;
            this.renderArc(octants[n], octants[n + 1]);
            this.renderArc(octants[n + 1], octants[n + 2]);
            this.renderArc(octants[n + 2], octants[n]);
        }
    }

    private void renderArc(int n, int n2) {
        this.v1.sub2((T3)this.points[n], (T3)this.center);
        this.v2.sub2((T3)this.points[n2], (T3)this.center);
        float f = this.v1.length();
        float f2 = this.v2.length();
        this.v1.normalize();
        this.v2.normalize();
        this.v3.cross(this.v1, this.v2);
        this.pt1.setT((T3)this.points[n]);
        this.s1.setT((T3i)this.screens[n]);
        short s = Normix.get2SidedNormix((V3)this.v3, (BS)this.bsTemp);
        if (!this.fillArc && !this.bOptions[6]) {
            this.screens[6].setT((T3i)this.s1);
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < 18) {
            this.pt2.scaleAdd2(cossin[n4] * f, (T3)this.v1, (T3)this.center);
            this.pt2.scaleAdd2(cossin[n4 + 1] * f2, (T3)this.v2, (T3)this.pt2);
            this.viewer.transformPtScr(this.pt2, this.s2);
            if (this.fillArc) {
                this.g3d.fillTriangle3CN(this.s0, this.colix, s, this.s1, this.colix, s, this.s2, this.colix, s);
            } else if (this.bOptions[6]) {
                this.g3d.fillCylinder((byte)2, this.diameter, this.s1, this.s2);
            } else {
                this.screens[n3 + 7].setT((T3i)this.s2);
            }
            this.pt1.setT((T3)this.pt2);
            this.s1.setT((T3i)this.s2);
            ++n3;
            n4 += 2;
        }
        if (!this.fillArc && !this.bOptions[6]) {
            this.g3d.addRenderer(553648147);
            for (n3 = 0; n3 < 18; ++n3) {
                this.g3d.fillHermite(5, this.diameter, this.diameter, this.diameter, this.screens[n3 == 0 ? n3 + 6 : n3 + 5], this.screens[n3 + 6], this.screens[n3 + 7], this.screens[n3 == 17 ? n3 + 7 : n3 + 8]);
            }
        }
    }

    private void setSelectedOctant() {
        int n = Integer.MAX_VALUE;
        this.selectedOctant = -1;
        this.iCutout = -1;
        if (this.bOptions[3]) {
            for (int i = 0; i < 8; ++i) {
                int n2 = octants[i * 3];
                int n3 = octants[i * 3 + 1];
                int n4 = octants[i * 3 + 2];
                int n5 = this.screens[n2].z + this.screens[n3].z + this.screens[n4].z;
                if (n5 >= n) continue;
                n = n5;
                this.iCutout = i;
            }
            this.selectedPoints[0] = this.screens[octants[this.iCutout * 3]];
            this.s1.setT((T3i)this.selectedPoints[0]);
            this.selectedPoints[1] = this.screens[octants[this.iCutout * 3 + 1]];
            this.s1.add((T3i)this.selectedPoints[1]);
            this.selectedPoints[2] = this.screens[octants[this.iCutout * 3 + 2]];
            this.s1.add((T3i)this.selectedPoints[2]);
            this.s1.scaleAdd(-3, (T3i)this.s0, (T3i)this.s1);
            this.pt1.set((float)this.s1.x, (float)this.s1.y, (float)this.s1.z);
            this.matScreenToEllipsoid.transform((T3)this.pt1);
            this.selectedOctant = GData.getScreenOctant((P3)this.pt1);
        }
    }

    static {
        int n = 0;
        for (int i = 5; i <= 90; i += 5) {
            EllipsoidsRenderer.cossin[n++] = (float)Math.cos((float)i * ((float)Math.PI / 180));
            EllipsoidsRenderer.cossin[n++] = (float)Math.sin((float)i * ((float)Math.PI / 180));
        }
        unitAxisVectors = new V3[]{JC.axisNX, JC.axisX, JC.axisNY, JC.axisY, JC.axisNZ, JC.axisZ};
        axisPoints = new int[]{-1, 1, -2, 2, -3, 3};
        octants = new int[]{5, 0, 3, 5, 2, 0, 4, 0, 2, 4, 3, 0, 5, 2, 1, 5, 1, 3, 4, 3, 1, 4, 1, 2};
    }
}

