/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import javajs.util.P3;
import javajs.util.P4;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.AtomDataReader;
import org.jmol.jvxl.readers.SurfaceGenerator;

class IsoFxyReader
extends AtomDataReader {
    private float[][] data;
    private boolean isPlanarMapping;
    private Object[] func;
    private final float[] values = new float[3];

    IsoFxyReader() {
    }

    @Override
    void init(SurfaceGenerator surfaceGenerator) {
        this.initIFR(surfaceGenerator);
    }

    protected void initIFR(SurfaceGenerator surfaceGenerator) {
        this.initADR(surfaceGenerator);
        this.isXLowToHigh = true;
        this.precalculateVoxelData = false;
        this.atomDataServer = surfaceGenerator.getAtomDataServer();
        this.params.fullyLit = true;
        boolean bl = this.isPlanarMapping = this.params.thePlane != null || this.params.state == 3;
        if (this.params.func != null) {
            this.volumeData.sr = this;
        }
    }

    @Override
    protected void setup(boolean bl) {
        if (this.params.functionInfo.size() > 5) {
            this.data = (float[][])this.params.functionInfo.get(5);
        }
        this.setupType("functionXY");
    }

    protected void setupType(String string) {
        this.func = (Object[])this.params.func;
        String string2 = (String)this.params.functionInfo.get(0);
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append(string).append("\n").append(string2).append("\n");
        if (this.params.thePlane != null || this.data == null && !this.useOriginStepsPoints) {
            this.setVolumeForPlane();
        } else if (this.data == null) {
            this.setVolumeDataParams();
        } else {
            this.setVolumeData();
        }
        JvxlCoder.jvxlCreateHeaderWithoutTitleOrAtoms(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    protected void setVolumeData() {
        if (this.data == null) {
            this.setVolumeDataADR();
            return;
        }
        this.volumetricOrigin.setT((T3)((P3)this.params.functionInfo.get(1)));
        for (int i = 0; i < 3; ++i) {
            P4 p4 = (P4)this.params.functionInfo.get(i + 2);
            this.voxelCounts[i] = Math.abs((int)p4.x);
            this.volumetricVectors[i].set(p4.y, p4.z, p4.w);
        }
        if (this.isAnisotropic) {
            this.setVolumetricAnisotropy();
        }
    }

    @Override
    protected void readSurfaceData(boolean bl) throws Exception {
        if (this.volumeData.sr != null) {
            return;
        }
        this.readSurfaceDataVDR(bl);
    }

    @Override
    public float[] getPlane(int n) {
        float[] fArray = this.getPlane2(n);
        this.setPlane(n, fArray);
        return fArray;
    }

    private void setPlane(int n, float[] fArray) {
        int n2 = 0;
        for (int i = 0; i < this.nPointsY; ++i) {
            for (int j = 0; j < this.nPointsZ; ++j) {
                fArray[n2++] = this.getValue(n, i, j);
            }
        }
    }

    protected float getValue(int n, int n2, int n3) {
        float f;
        if (this.data == null) {
            f = this.evaluateValue(n, n2, n3);
        } else {
            this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptTemp);
            f = this.data[n][n2];
        }
        return this.isPlanarMapping ? f : f - this.ptTemp.z;
    }

    @Override
    public float getValueAtPoint(P3 p3, boolean bl) {
        if (this.params.func == null) {
            return 0.0f;
        }
        this.values[0] = p3.x;
        this.values[1] = p3.y;
        this.values[2] = p3.z;
        return this.atomDataServer.evalFunctionFloat(this.func[0], this.func[1], this.values);
    }

    protected float evaluateValue(int n, int n2, int n3) {
        this.volumeData.voxelPtToXYZ(n, n2, n3, this.ptTemp);
        return this.getValueAtPoint(this.ptTemp, false);
    }
}

