/*
 * Decompiled with CFR 0.152.
 */
package javajs.awt;

import javajs.api.GenericColor;
import javajs.api.SwingController;
import javajs.awt.Dimension;
import javajs.util.CU;

public abstract class Component {
    protected boolean visible;
    protected boolean enabled;
    protected String text;
    protected String name;
    protected int width;
    protected int height;
    protected String id;
    protected SwingController controller;
    Object actionListener;
    private GenericColor bgcolor;
    protected int minWidth = 30;
    protected int minHeight = 30;
    protected int renderWidth;
    protected int renderHeight;

    protected Component(String string) {
        if (string == null) {
            return;
        }
        this.id = string + ("" + Math.random()).substring(3);
    }

    public abstract String toHTML();

    public void setBackground(GenericColor genericColor) {
        this.bgcolor = genericColor;
    }

    public void setText(String string) {
        this.text = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPreferredSize(Dimension dimension) {
        this.width = dimension.width;
        this.height = dimension.height;
    }

    public void addActionListener(Object object) {
        this.actionListener = object;
    }

    public String getText() {
        return this.text;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minWidth = dimension.width;
        this.minHeight = dimension.height;
    }

    public int getSubcomponentWidth() {
        return this.width;
    }

    public int getSubcomponentHeight() {
        return this.height;
    }

    protected String getCSSstyle(int n) {
        int n2 = this.renderWidth > 0 ? this.renderWidth : this.getSubcomponentWidth();
        int n3 = this.renderHeight > 0 ? this.renderHeight : this.getSubcomponentHeight();
        return (n2 > 0 ? "width:" + n2 + "px;" : (n > 0 ? "width:" + n + "%;" : "")) + (n3 > 0 ? "height:" + n3 + "px;" : (n > 0 ? "height:" + n + "%;" : "")) + (this.bgcolor == null ? "" : "background-color:" + CU.toCSSString(this.bgcolor) + ";");
    }

    public void repaint() {
    }
}

