/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.util.Hashtable;
import javajs.util.List;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.molxyz.MolReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.io.JmolBinary;
import org.jmol.java.BS;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class JcampdxReader
extends MolReader {
    private String thisModelID;
    private AtomSetCollection models;
    private String modelIdList = "";
    private List<String> peakData = new List();
    private String lastModel = "";
    private int selectedModel;
    private int[] peakIndex;
    private String peakFilePath;
    String piUnitsX;
    String piUnitsY;
    private String allTypes;

    @Override
    public void initializeReader() throws Exception {
        this.viewer.setBooleanProperty("_JSpecView".toLowerCase(), true);
        if (this.isTrajectory) {
            Logger.warn("TRAJECTORY keyword ignored");
            this.isTrajectory = false;
        }
        if (this.reverseModels) {
            Logger.warn("REVERSE keyword ignored");
            this.reverseModels = false;
        }
        this.selectedModel = this.desiredModelNumber;
        this.desiredModelNumber = Integer.MIN_VALUE;
        this.peakFilePath = Escape.eS(this.filePath);
        this.htParams.remove("modelNumber");
        if (this.htParams.containsKey("zipSet")) {
            this.peakIndex = (int[])this.htParams.get("peakIndex");
            if (this.peakIndex == null) {
                this.peakIndex = new int[1];
                this.htParams.put("peakIndex", this.peakIndex);
            }
            if (!this.htParams.containsKey("subFileName")) {
                this.peakFilePath = Escape.eS(PT.split(this.filePath, "|")[0]);
            }
        } else {
            this.peakIndex = new int[1];
        }
        if (!this.checkFilterKey("NOSYNC")) {
            this.addJmolScript("sync on");
        }
    }

    @Override
    public boolean checkLine() throws Exception {
        int n = this.line.indexOf("=");
        if (n < 0 || !this.line.startsWith("##")) {
            return true;
        }
        String string = this.line.substring(0, n).trim();
        if (string.equals("##$MODELS")) {
            return this.readModels();
        }
        if (string.equals("##$PEAKS")) {
            return this.readPeaks(false) > 0;
        }
        if (string.equals("##$SIGNALS")) {
            return this.readPeaks(true) > 0;
        }
        return true;
    }

    @Override
    public void finalizeReader() throws Exception {
        this.processPeakData();
        this.finalizeReaderMR();
    }

    private int findModelById(String string) {
        int n = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            if (!string.equals(this.atomSetCollection.getAtomSetAuxiliaryInfoValue(n, "modelID"))) continue;
            return n;
        }
        return -1;
    }

    private boolean readModels() throws Exception {
        if (this.line.indexOf("<Models") < 0) {
            this.discardLinesUntilContains2("<Models", "##");
            if (this.line.indexOf("<Models") < 0) {
                return false;
            }
        }
        this.models = null;
        this.line = "";
        this.thisModelID = "";
        boolean bl = true;
        while (true) {
            int n = this.atomSetCollection.getCurrentAtomSetIndex();
            this.discardLinesUntilNonBlank();
            if (this.line == null || !this.line.contains("<ModelData")) break;
            this.models = this.getModelAtomSetCollection();
            if (this.models != null) {
                this.atomSetCollection.appendAtomSetCollection(-1, this.models);
            }
            this.updateModelIDs(n, bl);
            bl = false;
        }
        return true;
    }

    private void updateModelIDs(int n, boolean bl) {
        int n2 = this.atomSetCollection.getAtomSetCount();
        if (bl && n2 == n + 2) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("modelID", this.thisModelID);
            return;
        }
        int n3 = 0;
        int n4 = n;
        while (++n4 < n2) {
            this.atomSetCollection.setAtomSetAuxiliaryInfoForSet("modelID", this.thisModelID + "." + ++n3, n4);
        }
    }

    private static String getAttribute(String string, String string2) {
        String string3 = PT.getQuotedAttribute(string, string2);
        return string3 == null ? "" : string3;
    }

    private AtomSetCollection getModelAtomSetCollection() throws Exception {
        int n;
        int n2;
        this.lastModel = this.thisModelID;
        this.thisModelID = JcampdxReader.getAttribute(this.line, "id");
        String string = ";" + this.thisModelID + ";";
        if (this.modelIdList.indexOf(string) >= 0) {
            this.discardLinesUntilContains("</ModelData>");
            return null;
        }
        this.modelIdList = this.modelIdList + string;
        String string2 = JcampdxReader.getAttribute(this.line, "baseModel");
        String string3 = JcampdxReader.getAttribute(this.line, "type").toLowerCase();
        float f = PT.parseFloat(JcampdxReader.getAttribute(this.line, "vibrationScale"));
        if (string3.equals("xyzvib")) {
            string3 = "xyz";
        } else if (string3.length() == 0) {
            string3 = null;
        }
        SB sB = new SB();
        while (this.readLine() != null && !this.line.contains("</ModelData>")) {
            sB.append(this.line).appendC('\n');
        }
        String string4 = sB.toString();
        Object object = SmarterJmolAdapter.staticGetAtomSetCollectionReader(this.filePath, string3, JmolBinary.getBR(string4), this.htParams);
        if (object instanceof String) {
            Logger.warn("" + object);
            return null;
        }
        if ((object = SmarterJmolAdapter.staticGetAtomSetCollection((AtomSetCollectionReader)object)) instanceof String) {
            Logger.warn("" + object);
            return null;
        }
        AtomSetCollection atomSetCollection = (AtomSetCollection)object;
        if (string2.length() == 0) {
            string2 = this.lastModel;
        }
        if (string2.length() != 0 && (n2 = this.findModelById(string2)) >= 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfoForSet("jdxModelID", string2, n2);
            n = atomSetCollection.getAtomSetCount();
            while (--n >= 0) {
                atomSetCollection.setAtomSetAuxiliaryInfoForSet("jdxBaseModel", string2, n);
            }
            if (atomSetCollection.getBondCount() == 0) {
                this.setBonding(atomSetCollection, n2);
            }
        }
        if (!Float.isNaN(f)) {
            Logger.info("jdx applying vibrationScale of " + f + " to " + atomSetCollection.getAtomCount() + " atoms");
            Atom[] atomArray = atomSetCollection.getAtoms();
            n = atomSetCollection.getAtomCount();
            while (--n >= 0) {
                atomArray[n].scaleVector(f);
            }
        }
        Logger.info("jdx model=" + this.thisModelID + " type=" + atomSetCollection.getFileTypeName());
        return atomSetCollection;
    }

    private void setBonding(AtomSetCollection atomSetCollection, int n) {
        int n2;
        int n3 = this.atomSetCollection.getAtomSetAtomCount(n);
        int n4 = atomSetCollection.getAtomCount();
        if (n4 % n3 != 0) {
            Logger.warn("atom count in secondary model (" + n4 + ") is not a multiple of " + n3 + " -- bonding ignored");
            return;
        }
        Bond[] bondArray = this.atomSetCollection.getBonds();
        int n5 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            n5 += this.atomSetCollection.getAtomSetBondCount(n2);
        }
        n2 = n5 + this.atomSetCollection.getAtomSetBondCount(n);
        int n6 = this.atomSetCollection.getAtomSetAtomIndex(n);
        int n7 = atomSetCollection.getAtomSetCount();
        for (int i = 0; i < n7; ++i) {
            int n8 = atomSetCollection.getAtomSetAtomIndex(i) - n6;
            if (atomSetCollection.getAtomSetAtomCount(i) != n3) {
                Logger.warn("atom set atom count in secondary model (" + atomSetCollection.getAtomSetAtomCount(i) + ") is not equal to " + n3 + " -- bonding ignored");
                return;
            }
            for (int j = n5; j < n2; ++j) {
                atomSetCollection.addNewBondWithOrder(bondArray[j].atomIndex1 + n8, bondArray[j].atomIndex2 + n8, bondArray[j].order);
            }
        }
    }

    private int readPeaks(boolean bl) throws Exception {
        JcampdxReader jcampdxReader = this;
        Object var3_3 = null;
        try {
            BS bS;
            Object object;
            Object[] objectArray;
            int n = bl ? 1 : 0;
            String string = bl ? "Signals" : "Peaks";
            String string2 = bl ? "<Signal" : "<PeakData";
            String string3 = this.discardUntil(jcampdxReader, string);
            if (string3.indexOf("<" + string) < 0) {
                string3 = this.discardUntil(jcampdxReader, "<" + string);
            }
            if (string3.indexOf("<" + string) < 0) {
                return 0;
            }
            String string4 = this.getPeakFilePath();
            String string5 = this.getQuotedAttribute(string3, "model");
            string5 = " model=" + this.escape(string5 == null ? this.thisModelID : string5);
            String string6 = this.getQuotedAttribute(string3, "type");
            if ("HNMR".equals(string6)) {
                string6 = "1HNMR";
            } else if ("CNMR".equals(string6)) {
                string6 = "13CNMR";
            }
            string6 = string6 == null ? "" : " type=" + this.escape(string6);
            this.piUnitsX = this.getQuotedAttribute(string3, "xLabel");
            this.piUnitsY = this.getQuotedAttribute(string3, "yLabel");
            Hashtable<Object[], Object[]> hashtable = new Hashtable<Object[], Object[]>();
            List<Object[]> list = new List<Object[]>();
            while ((string3 = jcampdxReader.readLine()) != null && !(string3 = string3.trim()).startsWith("</" + string)) {
                if (!string3.startsWith(string2)) continue;
                this.info(string3);
                String string7 = this.getQuotedAttribute(string3, "title");
                if (string7 == null) {
                    string7 = string6 == "1HNMR" ? "atom%S%: %ATOMS%; integration: %NATOMS%" : "";
                    string7 = " title=" + this.escape(string7);
                } else {
                    string7 = "";
                }
                String string8 = "<PeakData " + string4 + " index=\"%INDEX%\"" + string7 + string6 + (this.getQuotedAttribute(string3, "model") == null ? string5 : "") + " " + string3.substring(string2.length()).trim();
                String string9 = this.getQuotedAttribute(string8, "atoms");
                if (string9 != null) {
                    string8 = this.simpleReplace(string8, "atoms=\"" + string9 + "\"", "atoms=\"%ATOMS%\"");
                }
                if ((objectArray = (Object[])hashtable.get(object = (int)(this.parseFloatStr(this.getQuotedAttribute(string3, "xMin")) * 100.0f) + "_" + (int)(this.parseFloatStr(this.getQuotedAttribute(string3, "xMax")) * 100.0f))) == null) {
                    objectArray = new Object[]{string8, string9 == null ? null : new BS()};
                    hashtable.put((Object[])object, objectArray);
                    list.addLast(objectArray);
                }
                if ((bS = (BS)objectArray[1]) == null) continue;
                string9 = string9.replace(',', ' ');
                bS.or(this.unescapeBitSet("({" + string9 + "})"));
            }
            int n2 = 0;
            int n3 = list.size();
            for (int i = 0; i < n3; ++i) {
                object = (Object[])list.get(i);
                objectArray = (Object[])object[0];
                objectArray = this.simpleReplace((String)objectArray, "%INDEX%", "" + this.getPeakIndex());
                bS = (BS)object[1];
                if (bS != null) {
                    String string10 = "";
                    int n4 = bS.nextSetBit(0);
                    while (n4 >= 0) {
                        string10 = string10 + "," + (n4 + n);
                        n4 = bS.nextSetBit(n4 + 1);
                    }
                    n4 = bS.cardinality();
                    n2 += n4;
                    objectArray = this.simpleReplace((String)objectArray, "%ATOMS%", string10.substring(1));
                    objectArray = this.simpleReplace((String)objectArray, "%S%", n4 == 1 ? "" : "s");
                    objectArray = this.simpleReplace((String)objectArray, "%NATOMS%", "" + n4);
                }
                this.info("Jmol using " + (String)objectArray);
                this.add(this.peakData, (String)objectArray);
            }
            this.setSpectrumPeaks(var3_3, this.peakData, n2);
            return n3;
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private void info(String string) {
        Logger.info(string);
    }

    private BS unescapeBitSet(String string) {
        return Escape.uB(string);
    }

    private String simpleReplace(String string, String string2, String string3) {
        return PT.simpleReplace(string, string2, string3);
    }

    private String escape(String string) {
        return Escape.eS(string);
    }

    private String getQuotedAttribute(String string, String string2) {
        return PT.getQuotedAttribute(string, string2);
    }

    private void setSpectrumPeaks(Object object, Object object2, int n) {
    }

    private void add(List<String> list, String string) {
        list.addLast(string);
    }

    private String getPeakFilePath() {
        return " file=" + Escape.eS(this.peakFilePath);
    }

    private String discardUntil(Object object, String string) throws Exception {
        return this.discardLinesUntilContains2("<" + string, "##");
    }

    private int getPeakIndex() {
        this.peakIndex[0] = this.peakIndex[0] + 1;
        return this.peakIndex[0];
    }

    private void processPeakData() {
        int n;
        if (this.peakData.size() == 0) {
            return;
        }
        BS bS = new BS();
        int n2 = this.peakData.size();
        boolean bl = n2 > 0;
        for (n = 0; n < n2; ++n) {
            String string;
            this.line = (String)this.peakData.get(n);
            String string2 = JcampdxReader.getAttribute(this.line, "type");
            this.thisModelID = JcampdxReader.getAttribute(this.line, "model");
            int n3 = this.findModelById(this.thisModelID);
            if (n3 < 0) {
                Logger.warn("cannot find model " + this.thisModelID + " required for " + this.line);
                continue;
            }
            this.addType(n3, string2);
            String string3 = string2 + ": " + JcampdxReader.getAttribute(this.line, "title");
            String string4 = "jdxAtomSelect_" + JcampdxReader.getAttribute(this.line, "type");
            bS.set(n3);
            if (JcampdxReader.getAttribute(this.line, "atoms").length() != 0) {
                List<String> list = (List<String>)this.atomSetCollection.getAtomSetAuxiliaryInfoValue(n3, string4);
                if (list == null) {
                    list = new List<String>();
                    this.atomSetCollection.setAtomSetAuxiliaryInfoForSet(string4, list, n3);
                }
                list.addLast(this.line);
                string = string2 + ": ";
            } else if (this.atomSetCollection.getAtomSetAuxiliaryInfoValue(n3, "jdxModelSelect") == null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfoForSet("name", string3, n3);
                this.atomSetCollection.setAtomSetAuxiliaryInfoForSet("jdxModelSelect", this.line, n3);
                string = "model: ";
            } else {
                string = "ignored: ";
            }
            Logger.info(string + this.line);
        }
        n = n2 = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            this.thisModelID = (String)this.atomSetCollection.getAtomSetAuxiliaryInfoValue(n, "modelID");
            if (!bl || bS.get(n) || this.thisModelID.indexOf(".") < 0) continue;
            this.atomSetCollection.removeAtomSet(n);
            --n2;
        }
        if (this.selectedModel == Integer.MIN_VALUE) {
            if (this.allTypes != null) {
                this.appendLoadNote(this.allTypes);
            }
        } else {
            if (this.selectedModel == 0) {
                this.selectedModel = n2 - 1;
            }
            n = this.atomSetCollection.getAtomSetCount();
            while (--n >= 0) {
                if (n + 1 == this.selectedModel) continue;
                this.atomSetCollection.removeAtomSet(n);
            }
            if (n2 > 0) {
                this.appendLoadNote((String)this.atomSetCollection.getAtomSetAuxiliaryInfoValue(0, "name"));
            }
        }
        n = this.atomSetCollection.getAtomSetCount();
        while (--n >= 0) {
            this.atomSetCollection.setAtomSetNumber(n, n + 1);
        }
        this.atomSetCollection.centralize();
    }

    private void addType(int n, String string) {
        String string2 = this.addType((String)this.atomSetCollection.getAtomSetAuxiliaryInfoValue(n, "spectrumTypes"), string);
        if (string2 == null) {
            return;
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfoForSet("spectrumTypes", string2, n);
        String string3 = this.addType(this.allTypes, string);
        if (string3 != null) {
            this.allTypes = string3;
        }
    }

    private String addType(String string, String string2) {
        if (string != null && string.contains(string2)) {
            return null;
        }
        string = string == null ? "" : string + ",";
        return string + string2;
    }
}

