/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.BC;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.adapter.readers.quantum.SpartanArchive;
import org.jmol.adapter.readers.quantum.SpartanInputReader;
import org.jmol.util.Logger;

public class SpartanSmolReader
extends SpartanInputReader {
    private boolean iHaveModelStatement = false;
    private boolean isCompoundDocument = false;
    private boolean inputOnly;
    private boolean espCharges;
    private String endCheck = "END Directory Entry ";
    private String title;
    SpartanArchive spartanArchive;
    Map<String, String> titles;
    private boolean haveCharges;

    @Override
    protected void initializeReader() throws Exception {
        this.modelName = "Spartan file";
        this.isCompoundDocument = this.readLine().indexOf("Compound Document File Directory") >= 0;
        this.inputOnly = this.checkFilterKey("INPUT");
        this.espCharges = !this.checkFilterKey("MULLIKEN");
    }

    @Override
    protected boolean checkLine() throws Exception {
        String string;
        if (this.isCompoundDocument && (string = this.line.toLowerCase()).equals("begin directory entry molecule") || this.line.indexOf("JMOL_MODEL") >= 0 && !this.line.startsWith("END")) {
            if (this.modelNumber > 0) {
                this.applySymmetryAndSetTrajectory();
            }
            this.iHaveModelStatement = true;
            int n = this.getModelNumber();
            this.modelNumber = this.bsModels == null && n != Integer.MIN_VALUE ? n : this.modelNumber + 1;
            this.bondData = "";
            if (!this.doGetModel(this.modelNumber, null)) {
                return this.checkLastModel();
            }
            if (this.modelAtomCount == 0) {
                this.atomSetCollection.newAtomSet();
            }
            this.moData = new Hashtable();
            this.moData.put("isNormalized", Boolean.TRUE);
            if (n == Integer.MIN_VALUE) {
                n = this.modelNumber;
                this.title = "Model " + n;
            } else {
                this.title = this.titles.get("Title" + n);
                this.title = "Profile " + n + (this.title == null ? "" : ": " + this.title);
            }
            Logger.info(this.title);
            this.atomSetCollection.setAtomSetName(this.title);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("isPDB", Boolean.FALSE);
            this.atomSetCollection.setCurrentAtomSetNumber(n);
            if (this.isCompoundDocument) {
                this.readTransform();
            }
            return true;
        }
        if (this.iHaveModelStatement && !this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("BEGIN") == 0) {
            string = this.line.toLowerCase();
            if (string.endsWith("input")) {
                this.bondData = "";
                this.readInputRecords();
                if (this.atomSetCollection.errorMessage != null) {
                    this.continuing = false;
                    return false;
                }
                if (this.title != null) {
                    this.atomSetCollection.setAtomSetName(this.title);
                }
                this.setCharges();
                if (this.inputOnly) {
                    this.continuing = false;
                    return false;
                }
            } else {
                if (string.endsWith("_output")) {
                    return true;
                }
                if (string.endsWith("output")) {
                    this.readOutput();
                    return false;
                }
                if (string.endsWith("molecule") || string.endsWith("molecule:asbinarystring")) {
                    this.readTransform();
                    return false;
                }
                if (string.endsWith("proparc") || string.endsWith("propertyarchive")) {
                    this.readProperties();
                    return false;
                }
                if (string.endsWith("archive")) {
                    this.readArchive();
                    return false;
                }
            }
            return true;
        }
        if (this.line.indexOf("5D shell") >= 0) {
            this.calculationType = this.line;
            this.moData.put("calculationType", this.calculationType);
        }
        return true;
    }

    @Override
    protected void finalizeReader() throws Exception {
        Float f;
        this.finalizeReaderASCR();
        if (this.atomCount > 0 && this.spartanArchive != null && this.atomSetCollection.getBondCount() == 0 && this.bondData != null) {
            this.spartanArchive.addBonds(this.bondData, 0);
        }
        if (this.moData != null && (f = (Float)this.atomSetCollection.getAtomSetCollectionAuxiliaryInfo("HOMO_N")) != null) {
            this.moData.put("HOMO", f.intValue());
        }
    }

    private void readTransform() throws Exception {
        String string = this.readLine();
        String[] stringArray = SpartanSmolReader.getTokensStr(string.trim());
        if (stringArray.length < 16) {
            return;
        }
        byte[] byArray = new byte[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            byArray[i] = (byte)PT.parseIntRadix(stringArray[i], 16);
        }
        float[] fArray = new float[16];
        BC bC = new BC();
        int n = 16;
        int n2 = byArray.length - 8;
        while (--n >= 0) {
            fArray[n] = bC.bytesToDoubleToFloat(byArray, n2, false);
            n2 -= 8;
        }
        this.setTransform(fArray[0], fArray[1], fArray[2], fArray[4], fArray[5], fArray[6], fArray[8], fArray[9], fArray[10]);
    }

    private void readOutput() throws Exception {
        this.titles = new Hashtable<String, String>();
        SB sB = new SB();
        while (this.readLine() != null && !this.line.startsWith("END ")) {
            sB.append(this.line).append("\n");
            int n = this.line.indexOf(")");
            if (n <= 0) continue;
            this.titles.put("Title" + this.parseIntRange(this.line, 0, n), this.line.substring(n + 1).trim());
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", sB.toString());
    }

    private void readArchive() throws Exception {
        this.spartanArchive = new SpartanArchive(this, this.bondData, this.endCheck);
        if (this.readArchiveHeader()) {
            this.modelAtomCount = this.spartanArchive.readArchive(this.line, false, this.atomCount, false);
            if (this.atomCount == 0 || !this.isTrajectory) {
                this.atomCount += this.modelAtomCount;
            }
        }
    }

    private void setCharges() {
        if (this.haveCharges || this.atomSetCollection.getAtomCount() == 0) {
            return;
        }
        this.haveCharges = this.espCharges && this.atomSetCollection.setAtomSetCollectionPartialCharges("ESPCHARGES") || this.atomSetCollection.setAtomSetCollectionPartialCharges("MULCHARGES") || this.atomSetCollection.setAtomSetCollectionPartialCharges("Q1_CHARGES") || this.atomSetCollection.setAtomSetCollectionPartialCharges("ESPCHARGES");
    }

    private void readProperties() throws Exception {
        if (this.spartanArchive == null) {
            this.readLine();
            return;
        }
        this.spartanArchive.readProperties();
        this.readLine();
        this.setCharges();
    }

    private int getModelNumber() {
        try {
            int n = this.line.indexOf("JMOL_MODEL ") + 11;
            return this.parseIntAt(this.line, n);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private boolean readArchiveHeader() throws Exception {
        String string = this.readLine();
        if (Logger.debugging) {
            Logger.debug(string);
        }
        if (string.indexOf("Error:") == 0) {
            return false;
        }
        this.atomSetCollection.setCollectionName(string);
        this.modelName = this.readLine();
        if (Logger.debugging) {
            Logger.debug(this.modelName);
        }
        this.readLine();
        return true;
    }
}

