/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import javajs.util.PT;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class AbinitReader
extends AtomSetCollectionReader {
    private float[] cellLattice;
    private String[] atomList;
    private int nAtom;
    private int nType;
    private int[] typeArray;

    @Override
    protected void initializeReader() {
        this.setSpaceGroupName("P1");
        this.doApplySymmetry = true;
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.contains("natom")) {
            this.readNoatom();
        } else if (this.line.contains("ntypat") || this.line.contains("ntype")) {
            this.readNotypes();
        } else if (this.line.contains("typat") || this.line.contains("type")) {
            this.readTypesequence();
        } else if (this.line.contains("Pseudopotential")) {
            this.readAtomSpecies();
        } else if (this.line.contains("Symmetries :")) {
            this.readSpaceGroup();
        } else if (this.line.contains("Real(R)+Recip(G)")) {
            this.readIntiallattice();
        } else if (this.line.contains("xred")) {
            this.readIntitfinalCoord();
        }
        return true;
    }

    private void readNoatom() throws Exception {
        String[] stringArray = AbinitReader.getTokensStr(this.line);
        if (stringArray.length <= 2) {
            this.nAtom = this.parseIntStr(stringArray[1]);
        }
    }

    private void readNotypes() throws Exception {
        String[] stringArray = AbinitReader.getTokensStr(this.line);
        if (stringArray.length <= 2) {
            this.nType = this.parseIntStr(stringArray[1]);
        }
    }

    private void readTypesequence() throws Exception {
        this.typeArray = new int[this.nAtom];
        int n = 0;
        while (this.line != null && this.line.indexOf("wtk") < 0) {
            String string = this.line;
            if (this.line.contains("type")) {
                string = PT.simpleReplace(string, "type", "");
            }
            if (this.line.contains("typat")) {
                string = PT.simpleReplace(string, "typat", "");
            }
            String[] stringArray = AbinitReader.getTokensStr(string);
            for (int i = 0; i < stringArray.length; ++i) {
                this.typeArray[n] = this.parseIntStr(stringArray[i]);
                ++n;
            }
            this.readLine();
        }
    }

    private void readAtomSpecies() throws Exception {
        this.atomList = new String[this.nAtom];
        this.readLine();
        String[] stringArray = AbinitReader.getTokensStr(this.line);
        int n = this.parseIntStr(stringArray[4]);
        for (int i = 0; i < this.nType; ++i) {
            int n2;
            int n3 = 0;
            this.discardLinesUntilContains("zion");
            String string = PT.simpleReplace(this.line, ".", " ");
            String[] stringArray2 = AbinitReader.getTokensStr(string);
            if (stringArray2[0] == "-") {
                n3 = 1;
            }
            if (n != (n2 = this.parseIntStr(stringArray2[n3]))) continue;
            for (int j = 0; j < this.typeArray.length; ++j) {
                this.atomList[j] = AbinitReader.getElementSymbol(n2);
            }
        }
    }

    private void readSpaceGroup() throws Exception {
    }

    private void readIntiallattice() throws Exception {
        this.cellLattice = new float[9];
        String string = "";
        int n = 0;
        while (this.readLine() != null && this.line.indexOf("Unit cell volume") < 0) {
            string = this.line;
            string = PT.simpleReplace(string, "=", "= ");
            String[] stringArray = AbinitReader.getTokensStr(string);
            this.cellLattice[n++] = this.parseFloatStr(stringArray[1]) * 0.5291772f;
            this.cellLattice[n++] = this.parseFloatStr(stringArray[2]) * 0.5291772f;
            this.cellLattice[n++] = this.parseFloatStr(stringArray[3]) * 0.5291772f;
        }
        this.setSymmetry();
    }

    private void setSymmetry() throws Exception {
        this.applySymmetryAndSetTrajectory();
        this.setSpaceGroupName("P1");
        this.setFractionalCoordinates(false);
    }

    private void readIntitfinalCoord() throws Exception {
        String string = "";
        int n = 0;
        while (this.readLine() != null && this.line.contains("znucl")) {
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = this.atomList[n++];
            string = this.line;
            if (string.contains("xred")) {
                PT.simpleReplace(string, "xred", "");
            }
            String[] stringArray = AbinitReader.getTokensStr(string);
            float f = this.parseFloatStr(stringArray[0]);
            float f2 = this.parseFloatStr(stringArray[1]);
            float f3 = this.parseFloatStr(stringArray[2]);
            this.setAtomCoordXYZ(atom, f, f2, f3);
        }
    }
}

